var freetextQu = (function () {
    function freetextQu() {
        var _this = this;
        this.processKeyUp = function (evt) {
            //Decide whether to allow show 
            var wordcount = document.getElementById('id_userinput').innerText.trim().split(/\s+/).length;
            if (document.getElementById('id_userinput').innerText.length > 0) {
                _this.showSamp.classList.remove("disabled");
                _this.showExp.classList.remove("disabled");
            }
            else {
                _this.showSamp.classList.add("disabled");
                _this.showExp.classList.add("disabled");
            }
            document.getElementById('length').innerHTML = wordcount + " words.";
        };
        this.showHideSample = function (evt) {
            if (document.getElementById('id_userinput').value.length == 0) {
                alert("Please type in your own version first.");
            }
            else {
                if (_this.sampVis == true) {
                    _this.sampleEl.innerHTML = "";
                    _this.sampVis = false;
                    _this.showSamp.value = "Show sample";
                }
                else {
                    _this.sampleEl.innerHTML = _this.sampleanswer;
                    _this.sampVis = true;
                    _this.showSamp.value = "Hide sample";
                }
            }
        };
        this.showHideExp = function (evt) {
            if (document.getElementById('id_userinput').value.length == 0) {
                alert("Please type in your own version first.");
            }
            else {
                if (_this.expVis) {
                    _this.expEl.innerHTML = "";
                    _this.expVis = false;
                    _this.showExp.value = "Show explanation";
                }
                else {
                    _this.expEl.innerHTML = _this.explanationtext;
                    _this.expVis = true;
                    _this.showExp.value = "Hide explanation";
                }
            }
        };
        this.finishClick = function (evt) {
            window.location.href = window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/')) + "/index.html#tasks";
        };
    }
    freetextQu.prototype.start = function () {
        this.introEl = document.getElementById('intro');
        this.problemEl = document.getElementById('problem');
        this.introEl.innerHTML = this.intro;
        this.problemEl.innerHTML = this.problemtext;
        this.sampleEl = document.getElementById("sample");
        this.showSamp = document.getElementById('showsampleBtn');
        this.showSamp.addEventListener("click", this.showHideSample, true);
        this.showSamp.classList.add("disabled");
        this.showExp = document.getElementById('showexplanationBtn');
        this.showExp.addEventListener("click", this.showHideExp, true);
        this.showExp.classList.add("disabled");
        this.sampVis = false;
        this.expEl = document.getElementById("explanation2");
        this.finishBtn = document.getElementById('FinishBtn');
        this.finishBtn.addEventListener("click", this.finishClick, true);
        document.getElementById('id_userinput').addEventListener("keyup", this.processKeyUp, true);
    };
    return freetextQu;
})();
function initFreetext(theJSON) {
    var el = document.getElementById('content');
    var ftq = createInstanceFromJson(freetextQu, theJSON);
    ftq.start();
}
;
var choiceSubQu = (function () {
    function choiceSubQu() {
    }
    choiceSubQu.fromJSON = function (theJSON) {
        var cq;
        cq = new choiceSubQu();
        cq.question = theJSON.question;
        cq.question_number = theJSON.question_number;
        cq.answers = [];
        for (var a in theJSON.answers) {
            cq.answers[a] = choiceAns.fromJSON(theJSON.answers[a]);
        }
        cq.attempted = false;
        return cq;
    };
    return choiceSubQu;
})();
var choiceAns = (function () {
    function choiceAns() {
    }
    choiceAns.fromJSON = function (theJSON) {
        var ca;
        ca = new choiceAns();
        ca.answer = theJSON.answer;
        ca.feedback = theJSON.feedback;
        ca.answer_number = theJSON.answer_number;
        return ca;
    };
    return choiceAns;
})();
var choiceQu = (function () {
    function choiceQu() {
        var _this = this;
        this.prevClick = function (evt) {
            _this.curQu--;
            _this.displayQu(_this.curQu);
        };
        this.nextClick = function (evt) {
            _this.curQu++;
            _this.displayQu(_this.curQu);
        };
        this.finishClick = function (evt) {
            window.location.href = window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/')) + "/index.html#tasks";
        };
        this.processAnswer = function (evt) {
            //evt.preventDefault();
            var aid = evt.target.getAttribute("id");
            var aid2 = aid.split("_", 3);
            if (_this.curFdbkID != '') {
                document.getElementById(_this.curFdbkID).innerHTML = _this.curFdbkQu;
            }
            _this.curFdbkID = aid;
            _this.curFdbkQu = document.getElementById(aid).innerHTML;
            document.getElementById(aid).innerHTML += "<div class='feedback'>" + _this.questions[aid2[0]].answers[aid2[1]].feedback + "</div>";
            _this.questions[aid2[0]].attempted = true;
            _this.updateButtons(aid2[0]);
            return false;
        };
    }
    choiceQu.prototype.start = function () {
        this.introEl = document.getElementById('intro');
        this.qnumEl = document.getElementById('qnum');
        this.problemEl = document.getElementById('problem');
        document.getElementById('intro').innerHTML = this.intro;
        this.qnumEl.innerHTML = "1 of " + this.questions.length.toString();
        this.prevBtn = document.getElementById('PrevBtn');
        this.prevBtn.addEventListener("click", this.prevClick, true);
        this.nextBtn = document.getElementById('NextBtn');
        this.nextBtn.addEventListener("click", this.nextClick, true);
        this.finishBtn = document.getElementById('FinishBtn');
        this.finishBtn.addEventListener("click", this.finishClick, true);
        this.curQu = 0;
        this.displayQu(this.curQu);
    };
    choiceQu.prototype.displayQu = function (num) {
        var out = "<p>" + this.questions[num].question + "</p><hr/>";
        for (var a in this.questions[num].answers) {
            var id = num + "_" + a;
            out += "<div class='ans' id='" + id + "_container'><a id='" + id + "'>" + this.questions[num].answers[a].answer + "</a></div>";
        }
        this.problemEl.innerHTML = out;
        for (var a in this.questions[num].answers) {
            var id = num + "_" + a;
            document.getElementById(id + "_container").addEventListener("click", this.processAnswer, true);
        }
        this.curFdbkID = '';
        this.curFdbkQu = '';
        this.updateButtons(num);
    };
    choiceQu.prototype.updateButtons = function (num) {
        if (num == 0)
            this.prevBtn.disabled = true;
        else
            this.prevBtn.disabled = false;
        if ((this.questions[num].attempted) && (num < this.questions.length - 1))
            this.nextBtn.disabled = false;
        else
            this.nextBtn.disabled = true;
        var completed = true;
        for (var n in this.questions) {
            if (!this.questions[n].attempted)
                completed = false;
        }
        if (completed)
            this.finishBtn.disabled = false;
        else
            this.finishBtn.disabled = true;
    };
    choiceQu.fromJSON = function (theJSON) {
        var cq;
        cq = new choiceQu();
        cq.intro = theJSON.intro;
        cq.questions = [];
        for (var q in theJSON.questions) {
            cq.questions[q] = choiceSubQu.fromJSON(theJSON.questions[q]);
        }
        return cq;
    };
    return choiceQu;
})();
function initChoice(theJSON) {
    var cq = choiceQu.fromJSON(theJSON);
    cq.start();
}
;
var wordClickQu = (function () {
    function wordClickQu() {
        var _this = this;
        this.CloseFeedback = function (evt) {
            _this.feedbackEl.style.display = 'none';
        };
        this.CheckCorrection = function (evt) {
            var summitted = _this.correctionEdt.value.trim();
            if (summitted == _this.words[_this.currentWCWID].correct) {
                _this.feedbackTxtEl.innerHTML = "<p>Correct.</p>" + _this.words[_this.currentWCWID].feedback;
                document.getElementById(_this.currentWCWID).innerHTML = summitted;
                _this.correctionArea.style.display = 'none';
                if (_this.words[_this.currentWCWID].iserror)
                    _this.totalFound++;
                _this.updateStatus();
            }
            else {
                _this.correctionEdt.value = '';
                _this.feedbackTxtEl.innerHTML = "No, that is not correct, try again.";
            }
        };
        this.wordClick = function (evt) {
            if (evt.target.getAttribute("id") in _this.words) {
                _this.currentWCWID = evt.target.getAttribute("id");
                if (_this.words[_this.currentWCWID].correct == '') {
                    _this.feedbackTxtEl.innerHTML = _this.words[_this.currentWCWID].feedback;
                    _this.correctionArea.style.display = 'none';
                    if (_this.words[_this.currentWCWID].iserror)
                        _this.totalFound++;
                    _this.updateStatus();
                }
                else {
                    _this.feedbackTxtEl.innerHTML = "";
                    _this.correctionEdt.value = '';
                    _this.correctionArea.style.display = 'block';
                }
                _this.feedbackEl.style.display = 'block';
                //alert(wcw.feedback);
                document.getElementById(evt.target.getAttribute("id")).style.textDecoration = 'underline';
            }
            else {
                _this.currentWCWID = null;
                _this.feedbackTxtEl.innerHTML = _this.otherwordtext;
                _this.correctionArea.style.display = 'none';
                _this.feedbackEl.style.display = 'block';
            }
        };
        this.finishClick = function (evt) {
            window.location.href = window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/')) + "/index.html#tasks";
            //window.history.back();
        };
    }
    wordClickQu.prototype.start = function () {
        this.introEl = document.getElementById('intro');
        this.statusEl = document.getElementById('status');
        this.problemEl = document.getElementById('problem');
        this.feedbackEl = document.getElementById('feedback');
        this.correctionArea = document.getElementById('correction');
        this.correctionEdt = document.getElementById('correctionEdt');
        this.feedbackTxtEl = document.getElementById('feedbackTxt');
        document.getElementById('FdbkCloseBtn').addEventListener("click", this.CloseFeedback, true);
        document.getElementById('CorrectionBtn').addEventListener("click", this.CheckCorrection, true);
        this.introEl.innerHTML = this.description;
        this.problemEl.innerHTML = this.problemtext;
        this.finishBtn = document.getElementById('FinishBtn');
        this.finishBtn.addEventListener("click", this.finishClick, true);
        var wordEls = document.getElementsByClassName('wcword');
        this.totalToFind = 0;
        this.totalFound = 0;
        for (var wid in this.words) {
            if (this.words[wid].iserror)
                this.totalToFind++;
        }
        for (var i in wordEls) {
            if ((wordEls.item(i) != null) && (typeof (wordEls.item(i).addEventListener) === typeof (Function))) {
                wordEls.item(i).addEventListener("click", this.wordClick, true);
            }
        }
        this.updateStatus();
    };
    wordClickQu.prototype.updateStatus = function () {
        if (this.statusEl != null)
            this.statusEl.innerHTML = this.totalFound + " of " + this.totalToFind + " potential errors found.";
    };
    wordClickQu.fromJSON = function (theJSON) {
        var cq;
        cq = new wordClickQu();
        cq.description = theJSON.description;
        cq.problemtext = theJSON.problemtext;
        cq.tasksuccess = theJSON.tasksuccess;
        cq.taskfailure = theJSON.taskfailure;
        cq.otherwordtext = theJSON.otherwordtext;
        cq.words = [];
        for (var q in theJSON.words) {
            cq.words[q] = wordClickWord.fromJSON(theJSON.words[q]);
        }
        return cq;
    };
    return wordClickQu;
})();
var wordClickWord = (function () {
    function wordClickWord() {
    }
    wordClickWord.fromJSON = function (theJSON) {
        var cw;
        cw = new wordClickWord();
        cw.wordlocation = theJSON.wordlocation;
        cw.iserror = theJSON.iserror;
        cw.feedback = theJSON.feedback;
        cw.correct = theJSON.correct;
        return cw;
    };
    return wordClickWord;
})();
function initWordClick(theJSON) {
    var cq = wordClickQu.fromJSON(theJSON);
    cq.start();
}
;
var selectCatSelection = (function () {
    function selectCatSelection() {
    }
    selectCatSelection.fromJSON = function (theJSON) {
        var cs;
        cs = new selectCatSelection();
        cs.start = theJSON.start;
        cs.end = theJSON.end;
        cs.problem = theJSON.problem;
        cs.explanation = theJSON.explanation;
        return cs;
    };
    return selectCatSelection;
})();
var selectCatSelectable = (function () {
    function selectCatSelectable(plaintext, id, startIdx) {
        this.plaintext = plaintext;
        this.id = id;
        this.startIdx = startIdx;
        this.selected = false;
        this.category = -1;
    }
    return selectCatSelectable;
})();
var selectCatStage;
(function (selectCatStage) {
    selectCatStage[selectCatStage["Select"] = 0] = "Select";
    selectCatStage[selectCatStage["Review"] = 1] = "Review";
    selectCatStage[selectCatStage["Update"] = 2] = "Update";
    selectCatStage[selectCatStage["Compare"] = 3] = "Compare";
})(selectCatStage || (selectCatStage = {}));
var selectCatQu = (function () {
    function selectCatQu() {
        var _this = this;
        this.makeSelection = function (evt) {
            if (document.getSelection().toString().length > 0) {
                var rc = document.getSelection().rangeCount;
                var sc, ec;
                var sc2 = document.getSelection().getRangeAt(0).startContainer;
                if (sc2.nodeType === 3)
                    sc = sc2.parentNode;
                else
                    sc = sc2;
                var sc2 = document.getSelection().getRangeAt(0).endContainer;
                var ecp = document.getSelection().getRangeAt(0).endOffset;
                if (sc2.nodeType === 3)
                    ec = sc2.parentNode;
                else
                    ec = sc2;
                var startnr = +sc.id.substring(2);
                var endnr = +ec.id.substring(2);
                if (ecp == 0)
                    endnr--;
                _this.clearSelection(false);
                for (var n = startnr; n <= endnr; n++) {
                    _this.plaintextParts[n].selected = true;
                }
                _this.updatePlainText();
                document.getSelection().removeAllRanges();
            }
        };
        this.categoryClick = function (evt) {
            var idx;
            if (evt.target.getAttribute('id') == 'clear')
                idx = -1;
            else
                idx = +evt.target.getAttribute('id').substr(5);
            for (var n = 0; n < _this.plaintextParts.length; n++) {
                if (_this.plaintextParts[n].selected)
                    _this.plaintextParts[n].category = idx;
            }
            _this.clearSelection(true);
        };
        this.showExplanation = function (evt) {
            var idx = +evt.target.getAttribute('id').substr(5);
            _this.explanation.innerHTML = _this.selections[idx].explanation;
            _this.explanation.style.visibility = 'visible';
        };
        this.hideExplanation = function (evt) {
            _this.explanation.innerHTML = '&nbsp;';
            _this.explanation.style.visibility = 'hidden';
        };
        this.reviewClick = function (evt) {
            document.getElementById('problem').style.display = 'none';
            document.getElementById('review').style.display = 'block';
            _this.stage = selectCatStage.Review;
            _this.renderReview();
            for (var n = 0; n < _this.selections.length; n++) {
                var h = document.getElementById('tutor' + n);
                h.onmouseover = _this.showExplanation;
                h.onmouseout = _this.hideExplanation;
            }
            _this.updateButtons();
        };
        this.nextClick = function (evt) {
            if (_this.stage == selectCatStage.Review) {
                _this.stage = selectCatStage.Update;
                document.getElementById('update').style.display = 'block';
                _this.updateButtons();
            }
            else {
                _this.stage = selectCatStage.Compare;
                document.getElementById('solution').style.display = 'block';
                document.getElementById('solutionContent').innerHTML = _this.textversion;
                _this.updateButtons();
            }
        };
        this.finishClick = function (evt) {
            window.location.href = window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/')) + "/index.html#tasks";
            //window.history.back();
        };
    }
    selectCatQu.prototype.start = function () {
        this.introEl = document.getElementById('intro');
        this.problemEl = document.getElementById('problem');
        this.categoriesEl = document.getElementById('categories');
        this.reviewBtn = document.getElementById('ReviewBtn');
        this.reviewBtn.addEventListener("click", this.reviewClick, true);
        this.nextBtn = document.getElementById('NextBtn');
        this.nextBtn.addEventListener("click", this.nextClick, true);
        this.finishBtn = document.getElementById('FinishBtn');
        this.finishBtn.addEventListener("click", this.finishClick, true);
        this.explanation = document.getElementById('explanation');
        this.plaintextParts = new Array();
        this.stage = selectCatStage.Select;
        this.introEl.innerHTML = this.intro;
        var pos = 0;
        for (var n = 0; n < this.plaintext.length; n++) {
            this.problemEl.innerHTML += '<span id="pt' + n + '">' + this.plaintext[n] + '</span>';
            this.plaintextParts[n] = new selectCatSelectable(this.plaintext[n], 'pt' + n, pos);
            pos += this.plaintext[n].length;
        }
        this.problemEl.addEventListener("mouseup", this.makeSelection, true);
        for (var n_1 in this.problems) {
            this.categoriesEl.innerHTML += "\n<span class='prob' id='prob_" + n_1 + "' style='background-color: " + this.problemColours[n_1] + ";'>" + this.problems[n_1] + "</span> ";
        }
        this.categoriesEl.innerHTML += "\n<span class='prob' id='clear' style='background-color: #aaaaaa;'>Remove</span> ";
        for (var n_2 in this.problems) {
            var el = document.getElementById("prob_" + n_2);
            if (el != null)
                el.addEventListener("click", this.categoryClick, true);
        }
        var el = document.getElementById("clear");
        if (el != null)
            el.addEventListener("click", this.categoryClick, true);
        this.updateButtons();
    };
    selectCatQu.prototype.updatePlainText = function () {
        var bkcolour;
        var colour;
        for (var n = 0; n < this.plaintextParts.length; n++) {
            if (this.plaintextParts[n].selected == true) {
                bkcolour = '#3333dd';
                colour = '#ffffff';
            }
            else {
                colour = '#000000';
                if (this.plaintextParts[n].category == -1)
                    bkcolour = '#ffffff';
                else
                    bkcolour = this.problemColours[this.plaintextParts[n].category];
            }
            document.getElementById('pt' + n).style.color = colour;
            document.getElementById('pt' + n).style.backgroundColor = bkcolour;
        }
    };
    selectCatQu.prototype.clearSelection = function (update) {
        for (var n = 0; n < this.plaintextParts.length; n++) {
            this.plaintextParts[n].selected = false;
        }
        if (update) {
            this.updatePlainText();
        }
    };
    selectCatQu.prototype.renderReview = function () {
        var reviewEl;
        var pos;
        var nextSel;
        var selEnd;
        var curSel;
        var bkcolour;
        reviewEl = document.getElementById('yourContent');
        pos = 0;
        for (var n = 0; n < this.plaintext.length; n++) {
            if (this.plaintextParts[n].category == -1)
                bkcolour = '#ffffff';
            else
                bkcolour = this.problemColours[this.plaintextParts[n].category];
            reviewEl.innerHTML += '<span style="background-color:' + bkcolour + ';">' + this.plaintext[n] + '</span>';
            pos += this.plaintext[n].length;
        }
        reviewEl = document.getElementById('tutorsContent');
        pos = 0;
        var txt = '';
        nextSel = this.selections.length - 1;
        selEnd = 0;
        curSel = -1;
        var outp = "";
        for (var n = 0; n < this.plaintext.length; n++) {
            if ((pos > 0) && (pos >= selEnd)) {
                bkcolour = '#ffffff';
                curSel = -1;
                outp += '</span>';
            }
            if ((nextSel >= 0) && (pos >= this.selections[nextSel].start)) {
                selEnd = this.selections[nextSel].end;
                curSel = nextSel;
                bkcolour = this.problemColours[this.selections[curSel].problem];
                nextSel--;
                outp += '<span id="tutor' + curSel + '" style="background-color:' + bkcolour + ';">';
            }
            outp += this.plaintext[n];
            //reviewEl.innerHTML += '<span id="tutor' + n + '" style="background-color:' + bkcolour + ';">' + this.plaintext[n] + '</span>';
            pos += this.plaintext[n].length;
        }
        reviewEl.innerHTML = outp;
    };
    selectCatQu.prototype.updateButtons = function () {
        switch (this.stage) {
            case selectCatStage.Select:
                this.reviewBtn.disabled = false;
                this.reviewBtn.hidden = false;
                this.nextBtn.hidden = true;
                this.finishBtn.hidden = true;
                break;
            case selectCatStage.Review:
                this.reviewBtn.hidden = true;
                this.nextBtn.hidden = false;
                this.nextBtn.disabled = false;
                this.finishBtn.hidden = false;
                this.finishBtn.disabled = true;
                break;
            case selectCatStage.Update:
                this.reviewBtn.hidden = true;
                this.nextBtn.hidden = false;
                this.nextBtn.disabled = false;
                this.finishBtn.hidden = false;
                this.finishBtn.disabled = true;
                break;
            case selectCatStage.Compare:
                this.reviewBtn.hidden = true;
                this.nextBtn.hidden = false;
                this.nextBtn.disabled = true;
                this.finishBtn.hidden = false;
                this.finishBtn.disabled = false;
                break;
        }
    };
    selectCatQu.fromJSON = function (theJSON) {
        var cw;
        cw = new selectCatQu();
        cw.intro = theJSON.intro;
        cw.plaintext = theJSON.plaintext;
        cw.textversion = theJSON.textversion;
        cw.problems = theJSON.problems;
        cw.problemColours = theJSON.problemColours;
        cw.selections = [];
        for (var q in theJSON.selections) {
            cw.selections[q] = selectCatSelection.fromJSON(theJSON.selections[q]);
        }
        return cw;
    };
    return selectCatQu;
})();
function initSelectCat(theJSON) {
    var cq = selectCatQu.fromJSON(theJSON);
    cq.start();
}
;
// Found at http://stackoverflow.com/questions/32167593/how-to-do-runtime-type-casting-in-typescript/32169241#32169241 
function createInstanceFromJson(objType, json) {
    var newObj = new objType();
    var relationships = objType["relationships"] || {};
    for (var prop in json) {
        if (json.hasOwnProperty(prop)) {
            if (newObj[prop] == null) {
                if (relationships[prop] == null) {
                    newObj[prop] = json[prop];
                }
                else {
                    newObj[prop] = createInstanceFromJson(relationships[prop], json[prop]);
                }
            }
            else {
                console.warn("Property " + prop + " not set because it already existed on the object.");
            }
        }
    }
    return newObj;
}
//# sourceMappingURL=questions.js.map