<1. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 33601891
TI  - Training novice users to assess stroke aetiology in remote settings using transcranial ultrasound: pilot study.
SO  - Rural & Remote Health. 21(1):5618, 2021 02.
VI  - 1
ST  - In-Process
AU  - Antipova D
AU  - Eadie L
AU  - MacAden AS
AU  - Wilson P
FA  - Antipova, Daria
FA  - Eadie, Leila
FA  - MacAden, Ashish Stephen
FA  - Wilson, Philip
IN  - Antipova, Daria. Centre for Rural Health, Institute of Applied Health Sciences, University of Aberdeen, Inverness, Scotland IV2 3JH, UK dariantipova@gmail.com.
IN  - Eadie, Leila. Centre for Rural Health, Institute of Applied Health Sciences, University of Aberdeen, Inverness, Scotland IV2 3JH, UK leila.eadie@gmail.com.
IN  - MacAden, Ashish Stephen. Raigmore Hospital, NHS Highland, Inverness, Scotland IV2 3UJ, UK ashish.macaden@nhs.scot.
IN  - Wilson, Philip. Centre for Rural Health, Institute of Applied Health Sciences, University of Aberdeen, Inverness, Scotland IV2 3JH, UK p.wilson@abdn.ac.uk.
AB  - INTRODUCTION: Emergency care delivery to patients in remote and rural areas is limited by diagnostic restrictions and long transport times to major centres of care. People with suspected acute stroke living long distances from a hospital are unlikely to receive time-critical reperfusion therapy for these reasons. Basic brain imaging assessing blood flow in the major intracranial arteries could facilitate such care in remote settings. A 3-hour training package for novice transcranial ultrasound users has been piloted on a small group of volunteers to investigate whether they could acquire transcranial ultrasound images and video clips to potentially allow remote interpretation and optimise pre-hospital management of acute stroke.
AB  - METHODS: A pilot training project was set up in a university setting in Inverness, Scotland. Volunteer clinicians and students of nursing or medicine with no practical experience in transcranial ultrasound were recruited. Participants received three 1-hour training sessions combining theoretical aspects and hands-on practice on healthy volunteers provided by a qualified neurologist with more than 2 years of experience in transcranial ultrasound. Transcranial greyscale and colour-coded duplex sonography was performed to visualise midline structures and major intracranial vessels, and to measure blood flow velocity in the middle cerebral artery, followed by an unsupervised assessment. Qualitative analysis of the anonymised feedback from participants on the training experience and its potential application was also performed.
AB  - RESULTS: A total of 11 volunteers were recruited in the current pilot study. The average time to complete transcranial ultrasound assessment was approximately 40 minutes. The brain midline and cerebral peduncles were correctly labelled by 64% (7/11) and 91% (10/11) of volunteers, respectively. Participants demonstrated a good performance in detecting major intracranial vessels. The correct labelling rate for the middle cerebral artery was 73% (8/11), and 64% (7/11) for the anterior and posterior cerebral arteries. There was agreement between the trainer and the participants on rating the quality of scans as assessed using a visual analogue scale. All participants gave positive feedback on the provided training and time allocated for each session. Generally, volunteers thought that operating the ultrasound machine and the probe simultaneously was difficult. It was also suggested that further follow-up training, with possible supervision, would be useful to retain the acquired skills.
AB  - CONCLUSIONS: Transcranial ultrasound scans of a quality to allow expert interpretation can be acquired by inexperienced transcranial ultrasound operators after receiving a brief training. This could potentially be used by medical staff working in remote and rural areas to facilitate acute care for stroke patients, but further work with a larger sample is needed.
PT  - Journal Article
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=prem&AN=33601891
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:33601891&id=doi:10.22605%2FRRH5618&issn=1445-6354&isbn=&volume=21&issue=1&spage=5618&pages=5618&date=2021&title=Rural+%26+Remote+Health&atitle=Training+novice+users+to+assess+stroke+aetiology+in+remote+settings+using+transcranial+ultrasound%3A+pilot+study.&aulast=Antipova&pid=%3Cauthor%3EAntipova+D%3C%2Fauthor%3E%3CAN%3E33601891%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<2. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 34039617
TI  - Value improvement at the point of care: engaging and empowering front-line teams with a new quality improvement methodology.
SO  - BMJ Open Quality. 10(2), 2021 05.
VI  - 1
ST  - In-Process
AU  - Gupta P
AU  - Chacko G
AU  - Mavin P
AU  - McDonald I
AU  - El Hassan M
AU  - Omari E
AU  - Ali A
AU  - Siddiqui R
AU  - Khan N
AU  - McKenzie L
AU  - Bolender T
AU  - Andrews W
AI  - Gupta, Poonam; ORCID: https://orcid.org/0000-0002-9654-244X
FA  - Gupta, Poonam
FA  - Chacko, Gracy
FA  - Mavin, Paul
FA  - McDonald, Ian
FA  - El Hassan, Mawahib
FA  - Omari, Emad
FA  - Ali, Azhar
FA  - Siddiqui, Raana
FA  - Khan, Needa
FA  - McKenzie, Lisa
FA  - Bolender, Tricia
FA  - Andrews, William
IN  - Gupta, Poonam. Performance Improvement, Heart Hospital, Hamad Medical Corporation, Doha, Qatar dubai.poonam@gmail.com.
IN  - Chacko, Gracy. Nursing Department, Heart Hospital, Hamad Medical Corporation, Doha, Qatar.
IN  - Mavin, Paul. Executive Director, Heart hospital, Hamad Medical Corporation, Doha, Qatar.
IN  - McDonald, Ian. Nursing Department, Heart Hospital, Hamad Medical Corporation, Doha, Qatar.
IN  - El Hassan, Mawahib. Consultant Cardiology, Heart Hospital, Hamad Medical Corporation, Doha, Qatar.
IN  - Omari, Emad. Nursing Department, Heart Hospital, Hamad Medical Corporation, Doha, Qatar.
IN  - Ali, Azhar. Institute for Healthcare Improvement, Cambridge, Massachusetts, USA.
IN  - Siddiqui, Raana. Hamad Healthcare Quality Institute, Hamad Medical Corporation, Doha, Qatar.
IN  - Khan, Needa. Hamad Healthcare Quality Institute, Hamad Medical Corporation, Doha, Qatar.
IN  - McKenzie, Lisa. Institute for Healthcare Improvement, Cambridge, Massachusetts, USA.
IN  - Bolender, Tricia. Institute for Healthcare Improvement, Cambridge, Massachusetts, USA.
IN  - Andrews, William. Performance Improvement, Heart Hospital, Hamad Medical Corporation, Doha, Qatar.
AB  - BACKGROUND: Healthcare organisations require systems to consistently meet the needs of their patients while providing excellent quality of care. The value improvement (VI) approach was developed by the Institute for healthcare improvement and successfully piloted at Raigmore Hospital, Scotland. It showed positive results in improving outcomes and reducing costs. Our multidisciplinary team from a tertiary care cardiac hospital in Doha, Qatar wanted to see if we could improve value in a clinically and geographically distinct context. We sought to understand the effectiveness of this approach as an integrative management philosophy that aims for continuous improvement in the quality of services by increasing efficiency and reducing waste.
AB  - METHODS: This study evaluates the outcomes achieved from applying the VI methodology. The method is rooted in a framework that emphasises standardisation, continuous process improvement and rightsizing capacity to demand. The main tools include a data box score, a visual management board and weekly communication huddles.
AB  - RESULTS: As a result of the VI methodology, our team achieved improvements across performance, staff capacity and cost domains. Compared with the 4-8 weeks baseline data collection period, these improvements included an increase in discharges before 13:00 hour by 61%, a reduction in the number of blood samples per patient per day by 20%, an increase in nursing time spent in direct patient care by 18%, and an increase in staff satisfaction to 40%.
AB  - CONCLUSIONS: We found that the VI approach offered a systematic method for continuously improving the quality of care by focusing attention each week on safety, efficiency and patient experience. The team improved numerous processes and outcomes resulting in a positive impact on patients and families and increased the engagement of staff in continuous improvement. In this way, we improved our capacity to undertake and complete quality projects.

 Copyright © Author(s) (or their employer(s)) 2021. Re-use permitted under CC BY-NC. No commercial re-use. See rights and permissions. Published by BMJ.
PT  - Journal Article
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=prem&AN=34039617
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:34039617&id=doi:10.1136%2Fbmjoq-2020-001233&issn=2399-6641&isbn=&volume=10&issue=2&spage=&pages=&date=2021&title=BMJ+Open+Quality&atitle=Value+improvement+at+the+point+of+care%3A+engaging+and+empowering+front-line+teams+with+a+new+quality+improvement+methodology.&aulast=Gupta&pid=%3Cauthor%3EGupta+P%3C%2Fauthor%3E%3CAN%3E34039617%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<3. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 33358127
TI  - An evaluation of the current mentorship/preceptorship practices for newly qualified radiographers in Northern Ireland.
SO  - Radiography (London). 27(2):589-597, 2021 05.
VI  - 1
ST  - In-Process
AU  - Morris K
AU  - Cathcart JM
FA  - Morris, K
FA  - Cathcart, J M
IN  - Morris, K. C/O WHSCT, Omagh Hospital & PCC, 7 Donaghanie Rd, Omagh, Co. Tyrone, BT79 0NR, UK. Electronic address: kellie.morris@westerntrust.hscni.net.
IN  - Cathcart, J M. C/O School of Health Sciences, Ulster University, Shore Rd, Newtonabbey, Co. Antrim, BT37 0QB, UK. Electronic address: j.cathcart@ulster.ac.uk.
AB  - INTRODUCTION: Mentorship/Preceptorship (M/P) has been utilised within the nursing profession since the early 1980's. Successful, structured M/P programmes can be hugely beneficial to Northern Ireland (NI) Trusts who recruit regularly and often rely on the fluidity of staff movement regionally. In the absence of standardised tools to accurately and universally measure the competency of newly qualified Radiographers (NQR) as they evolve, establishing the benchmark for effective practice within Radiology departments in NI is difficult and highly subjective at best. This study aimed to evaluate the current M/P strategies within NI as perceived by NQR and Radiology Managers (RM).
AB  - METHODS: A mix of both qualitative and quantitative data was obtained using questionnaires through a scoping exercise. Opinions were sought from a target audience of NQR, who began full-time employment following graduation in 2018, and RM involved in the delivery of current M/P programmes within the NI Trusts.
AB  - RESULTS: Responses were gained from all five NI trusts to achieve a representative regional sample, with final opinions of RM (n = 8, 54%) and NQR (n = 30, 67%) received. With the exception of one response, all NQRs confirmed receiving some form of M/P support within their inaugural post.
AB  - CONCLUSION: Significant variations were apparent in both the structure and delivery of Trust M/P induction programmes, calling into question the comparable competency of NQRs regionally.
AB  - IMPLICATIONS FOR PRACTICE: The disparity in approach towards M/P programmes across NI, and subsequent lack of comparability of NQR competence, endorses the development of a more robust and universal method for the regional assessment of NQRs, such as that of the 'Flying Start NHS R' programme utilised by National Health Service (NHS) Scotland, in combination with knowledge and skills framework (KSF) practices in supervision.

 Crown Copyright © 2020. Published by Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=prem&AN=33358127
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:33358127&id=doi:10.1016%2Fj.radi.2020.11.025&issn=1078-8174&isbn=&volume=27&issue=2&spage=589&pages=589-597&date=2021&title=Radiography+%28London%29&atitle=An+evaluation+of+the+current+mentorship%2Fpreceptorship+practices+for+newly+qualified+radiographers+in+Northern+Ireland.&aulast=Morris&pid=%3Cauthor%3EMorris+K%3C%2Fauthor%3E%3CAN%3E33358127%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<4. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32516840
TI  - Co-creation of five key research priorities across law enforcement and public health: A methodological example and outcomes.
SO  - Journal of Psychiatric & Mental Health Nursing. 28(1):3-15, 2021 Feb.
VI  - 1
ST  - In-Process
AU  - Murray J
AU  - Heyman I
AU  - Dougall N
AU  - Wooff A
AU  - Aston E
AU  - Enang I
AI  - Murray, Jennifer; ORCID: https://orcid.org/0000-0002-1076-3461
AI  - Heyman, Inga; ORCID: https://orcid.org/0000-0002-4338-7714
FA  - Murray, Jennifer
FA  - Heyman, Inga
FA  - Dougall, Nadine
FA  - Wooff, Andrew
FA  - Aston, Elizabeth
FA  - Enang, Iniobong
IN  - Murray, Jennifer. School of Health & Social Care, Edinburgh Napier University, Edinburgh, UK.
IN  - Heyman, Inga. School of Health & Social Care, Edinburgh Napier University, Edinburgh, UK.
IN  - Dougall, Nadine. School of Health & Social Care, Edinburgh Napier University, Edinburgh, UK.
IN  - Wooff, Andrew. School of Applied Sciences, Edinburgh Napier University, Edinburgh, UK.
IN  - Aston, Elizabeth. School of Applied Sciences, Edinburgh Napier University, Edinburgh, UK.
IN  - Enang, Iniobong. School of Health & Social Care, Edinburgh Napier University, Edinburgh, UK.
AB  - WHAT IS KNOWN ON THE SUBJECT?: Between policing and health, there are many shared issues. Mental health distress and crises and caring for people who may be vulnerable are priority areas. Working together in partnership is challenging, and fragmented systems and processes are the result. This leads to poor experiences for the police, health professions and the public. WHAT THE PAPER ADDS TO EXISTING KNOWLEDGE?: This paper describes an event that brought together 26 stakeholders involved in law enforcement and public health. The aim of this work was to identify the biggest shared challenges that they experience in their day to day jobs. The five key priorities were as follows: vulnerability; mental health crisis; decision-making around assessment and triage across professional groups and professional roles; peer support and organizational well-being; and information and data sharing. WHAT ARE THE IMPLICATIONS FOR PRACTICE?: This paper demonstrates the strength of bringing partners together throughout law enforcement and public health, making proper time to actually discuss the "big issues" which affect them, how they each experience these issues, and how they might have overcome these within their own professions. Only through working together as partners and having everyone on the same page with the shared priorities can we really start to make a difference in the areas and with the people who matter. The focus on "vulnerability" and "mental health crisis" demonstrates the complexity of the issues between the professions, and that they need to find effective ways to work together to support people. No one professional group can solve inter-professional challenges alone. ABSTRACT: Introduction Law enforcement professions now assume more responsibility for tackling mental health issues alongside public health colleagues than ever before. The term "vulnerability" is frequently used within Law Enforcement and Public Health (LEPH) to identify those requiring emergency mental health care. However, there are ongoing challenges within LEPH to determine whose responsibility this is. Aim To co-create the most important priorities for LEPH research in Scotland. Method The paper describes a collaborative workshop which brought together an Expert Advisory Group (EAG) of 26 senior stakeholders, from academia, policing, mental health nursing, psychiatry, paramedics, emergency medicine, people with lived experience, policy makers and third sector. Results The five key priorities included: vulnerability; mental health crisis; decision-making around assessment and triage across professional groups and professional roles; peer support and organizational well-being; and information and data sharing. Discussion The paper discusses the EAG group event as a co-production process, focusing on how key LEPH research priorities were derived. Implications for practice This paper demonstrates the inextricable link between co-production and co-creation of value via EAG group consensus on LEPH research priorities. Shared vision and professional will are not enough to ensure progress: there must also be shared policy, knowledge and access.

 Copyright © 2020 The Authors. Journal of Psychiatric and Mental Health Nursing published by John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=prem&AN=32516840
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32516840&id=doi:10.1111%2Fjpm.12664&issn=1351-0126&isbn=&volume=28&issue=1&spage=3&pages=3-15&date=2021&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Co-creation+of+five+key+research+priorities+across+law+enforcement+and+public+health%3A+A+methodological+example+and+outcomes.&aulast=Murray&pid=%3Cauthor%3EMurray+J%3C%2Fauthor%3E%3CAN%3E32516840%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<5. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 34394668
TI  - Transition into remote and rural nurse education and careers: a qualitative study of student nurses.
SO  - Journal of Research in Nursing. 25(6-7):509-520, 2020 Sep.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Kyle RG
AU  - Beattie M
AU  - Smith A
AI  - Beattie, Michelle; ORCID: https://orcid.org/0000-0003-2396-9992
FA  - Kyle, Richard G
FA  - Beattie, Michelle
FA  - Smith, Annetta
IN  - Kyle, Richard G. Reader, School of Health & Social Care, Edinburgh Napier University, Sighthill Campus, UK.
IN  - Beattie, Michelle. Lecturer, Department of Nursing and Midwifery, University of the Highlands and Islands, UK.
IN  - Smith, Annetta. Professor and Head of the Department, Department of Nursing and Midwifery, University of the Highlands and Islands, UK.
AB  - Background: Global nurse shortages present a threat to the sustainability of remote and rural healthcare. Interventions have been developed to support recruitment and retention of nurses that focus on providing pre-nursing experience for school pupils who intend to pursue nursing careers. However, there is a lack of evidence around how pre-nursing experience supports transition into nurse education.
AB  - Aims: This study aims to explore the impact of a pre-nursing scholarship for school pupils in remote and rural areas of Scotland on experiences of transition into nurse education.
AB  - Methods: This was a qualitative study involving semi-structured telephone and face-to-face interviews with pre-nursing scholarship participants.
AB  - Results: An authentic pre-nursing experience supported school pupils' transition to nurse education. First, it increased students' self-efficacy, both in their decision to choose nursing as a career and their ability to nurse. Second, it helped students to realise that the opportunity to study closer to home was available to them. Third, it supported students' educational and social integration, helping them feel prepared for university teaching and learning approaches and the social experience of being a student.
AB  - Conclusions: Pre-nursing experience can support transition into nurse education and contribute to career pathways that support recruitment and retention of nurses in remote and rural areas.

 Copyright © The Author(s) 2020.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm&AN=34394668
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:34394668&id=doi:10.1177%2F1744987120908911&issn=1744-9871&isbn=&volume=25&issue=6-7&spage=509&pages=509-520&date=2020&title=Journal+of+Research+in+Nursing&atitle=Transition+into+remote+and+rural+nurse+education+and+careers%3A+a+qualitative+study+of+student+nurses.&aulast=Kyle&pid=%3Cauthor%3EKyle+RG%3C%2Fauthor%3E%3CAN%3E34394668%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<6. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 34394418
TI  - What makes a nursing home homely? A Scottish based study, using Q methodology of the perceptions of staff, residents and significant others.
SO  - Journal of Research in Nursing. 23(2-3):141-158, 2018 May.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Fleming A
AU  - Kydd A
AI  - Fleming, Anne; ORCID: https://orcid.org/0000-0001-5220-4871
FA  - Fleming, Anne
FA  - Kydd, Angela
IN  - Fleming, Anne. 11 Kirkintilloch Road, Glasgow, UK.
IN  - Kydd, Angela. Associate Professor, School of Health and Social Care, Edinburgh Napier University, UK.
AB  - Background: A 'homely' nursing or care home is of international interest and comes from a wide variety of academic disciplines and from policy makers and charities. However, 'homeliness' is a dynamic and complex concept and one worthy of further investigation.
AB  - Aims: (a) To explore what is meant by 'homely' in the care home environment, (b) to explore whether a 'homely' care home is a priority in the expressed views of residents, staff and visitors, and (c) to explore features contributing to the creation of homeliness in the care home environment.
AB  - Method: A mixed methodology was used - a narrative literature review, an environmental assessment using the Sheffield care environment assessment matrix (SCEAM) tool and Q methodology. Participants (n = 16) included staff, residents and their relatives from care homes in the west of Scotland.
AB  - Results: The literature review generated eight themes: home as space; home as place, design features, homeliness, the outdoors, home and identity, dementia design and specific rooms. The SCEAM revealed that homely environments supported personalisation, safety and health, privacy, community, comfort and awareness, choice and staff accommodation. The Q method revealed three factors: standards driven, making the most of it and a sense of belonging.
AB  - Conclusion: The results showed that staff and relatives placed priority on features included in national standards of care, while residents placed more importance on a feeling of belonging.

 Copyright © The Author(s) 2018.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm&AN=34394418
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:34394418&id=doi:10.1177%2F1744987118757837&issn=1744-9871&isbn=&volume=23&issue=2-3&spage=141&pages=141-158&date=2018&title=Journal+of+Research+in+Nursing&atitle=What+makes+a+nursing+home+homely%3F+A+Scottish+based+study%2C+using+Q+methodology+of+the+perceptions+of+staff%2C+residents+and+significant+others.&aulast=Fleming&pid=%3Cauthor%3EFleming+A%3C%2Fauthor%3E%3CAN%3E34394418%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<7. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 33531794
TI  - Cataract Surgery Redesign: Meeting Increasing Demand, Training, Audit and Patient-Centered Care.
SO  - Clinical Ophthalmology. 15:289-297, 2021.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Ah-See KL
AU  - Blaikie A
AU  - Boyle N
AU  - Foulds J
AU  - Wheeldon C
AU  - Wilson P
AU  - Styles C
AU  - Sutherland S
AU  - Sanders R
AI  - Ah-See, Kim Lawrence; ORCID: https://orcid.org/0000-0002-7085-7486
AI  - Blaikie, Andrew; ORCID: https://orcid.org/0000-0001-7913-6872
AI  - Styles, Caroline; ORCID: https://orcid.org/0000-0002-6515-1032
FA  - Ah-See, Kim Lawrence
FA  - Blaikie, Andrew
FA  - Boyle, Natalie
FA  - Foulds, Jonathan
FA  - Wheeldon, Catherine
FA  - Wilson, Peter
FA  - Styles, Caroline
FA  - Sutherland, Shona
FA  - Sanders, Roshini
IN  - Ah-See, Kim Lawrence. Department of Ophthalmology, Princess Alexandra Eye Pavilion, Edinburgh, Scotland, UK.
IN  - Blaikie, Andrew. School of Medicine, University of St Andrews, St Andrews, Scotland, UK.
IN  - Boyle, Natalie. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Foulds, Jonathan. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Wheeldon, Catherine. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Wilson, Peter. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Styles, Caroline. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Sutherland, Shona. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
IN  - Sanders, Roshini. Department of Ophthalmology, Queen Margaret Hospital, Dunfermline, Fife, UK.
AB  - Objective: The demand for cataract surgery in Fife (a well-defined region in southeast Scotland) was steadily increasing over 15 years. Cataract surgery was therefore being outsourced to meet demand with consequences on list mix, training needs, patient experience and staff morale. We aimed to redesign our services to meet local demand, retain a patient-centered service and continue to fulfil training needs.
AB  - Methods: We quantified cataract surgery delivery over an 18-month period: before, during and after redesign of services. We studied numbers of operations, trainee cases and number of outsourced cases. We also considered the economic implications of the redesign.
AB  - Results: We studied three periods (each of six months duration): before redesign (BR), redesign period (RP) and post-redesign (PR). Data were collected on total operation numbers, number of cases performed by trainees, and numbers performed out with normal working hours (weekend lists) and external providers. An economic analysis examined the cost of outsourcing cataracts during BR and RP and the costs of the redesign, including building, equipment and additional nursing staff.
AB  - Conclusion: Regional fulfilment of cataract surgery provision remains a continuous challenge within the NHS. We show that with minimal investment, smart redesign process and collaborative working, increased local provision is possible while fulfilling trainee needs and achieving the necessary clinical audits and national standards.

 Copyright © 2021 Ah-See et al.
PT  - Journal Article
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm&AN=33531794
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:33531794&id=doi:10.2147%2FOPTH.S268190&issn=1177-5467&isbn=&volume=15&issue=&spage=289&pages=289-297&date=2021&title=Clinical+Ophthalmology&atitle=Cataract+Surgery+Redesign%3A+Meeting+Increasing+Demand%2C+Training%2C+Audit+and+Patient-Centered+Care.&aulast=Ah-See&pid=%3Cauthor%3EAh-See+KL%3C%2Fauthor%3E%3CAN%3E33531794%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<8. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16722572
TI  - Is the involvement of opinion leaders in the implementation of research findings a feasible strategy?.
SO  - Implementation Science. 1:3, 2006 Feb 22.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Grimshaw JM
AU  - Eccles MP
AU  - Greener J
AU  - Maclennan G
AU  - Ibbotson T
AU  - Kahan JP
AU  - Sullivan F
FA  - Grimshaw, Jeremy M
FA  - Eccles, Martin P
FA  - Greener, Jenny
FA  - Maclennan, Graeme
FA  - Ibbotson, Tracy
FA  - Kahan, James P
FA  - Sullivan, Frank
IN  - Grimshaw, Jeremy M. Health Services Research Unit, University of Aberdeen, Aberdeen, UK. jgrimshaw@ohri.ca
AB  - BACKGROUND: There is only limited empirical evidence about the effectiveness of opinion leaders as health care change agents.
AB  - AIM: To test the feasibility of identifying, and the characteristics of, opinion leaders using a sociometric instrument and a self-designating instrument in different professional groups within the UK National Health Service.
AB  - DESIGN: Postal questionnaire survey.
AB  - SETTING AND PARTICIPANTS: All general practitioners, practice nurses and practice managers in two regions of Scotland. All physicians and surgeons (junior hospital doctors and consultants) and medical and surgical nursing staff in two district general hospitals and one teaching hospital in Scotland, as well as all Scottish obstetric and gynaecology, and oncology consultants.
AB  - RESULTS: Using the sociometric instrument, the extent of social networks and potential coverage of the study population in primary and secondary care was highly idiosyncratic. In contrast, relatively complex networks with good coverage rates were observed in both national specialty groups. Identified opinion leaders were more likely to have the expected characteristics of opinion leaders identified from diffusion and social influence theories. Moreover, opinion leaders appeared to be condition-specific. The self-designating instrument identified more opinion leaders, but it was not possible to estimate the extent and structure of social networks or likely coverage by opinion leaders. There was poor agreement in the responses to the sociometric and self-designating instruments.
AB  - CONCLUSION: The feasibility of identifying opinion leaders using an off-the-shelf sociometric instrument is variable across different professional groups and settings within the NHS. Whilst it is possible to identify opinion leaders using a self-designating instrument, the effectiveness of such opinion leaders has not been rigorously tested in health care settings. Opinion leaders appear to be monomorphic (different leaders for different issues). Recruitment of opinion leaders is unlikely to be an effective general strategy across all settings and professional groups; the more specialised the group, the more opinion leaders may be a useful strategy.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm&AN=16722572
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16722572&id=doi:10.1186%2F1748-5908-1-3&issn=1748-5908&isbn=&volume=1&issue=&spage=3&pages=3&date=2006&title=Implementation+Science&atitle=Is+the+involvement+of+opinion+leaders+in+the+implementation+of+research+findings+a+feasible+strategy%3F.&aulast=Grimshaw&pid=%3Cauthor%3EGrimshaw+JM%3C%2Fauthor%3E%3CAN%3E16722572%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<9. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32695147
TI  - [Skill mix of nurses and primary health care professionals: a systematic review]. [Review] [Portuguese]
SO  - Pan American Journal of Public Health. 44:e82, 2020.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Cassiani SHB
AU  - Fernandes MNF
AU  - Reveiz L
AU  - Filho JRF
AU  - da Silva FAM
FA  - Cassiani, Silvia Helena De Bortoli
FA  - Fernandes, Maria Neyrian de Fatima
FA  - Reveiz, Ludovic
FA  - Filho, Jose Rodrigues Freire
FA  - da Silva, Fernando Antonio Menezes
IN  - Cassiani, Silvia Helena De Bortoli. Organizacao Pan-Americana da Saude Washington, D.C. Estados Unidos de America Organizacao Pan-Americana da Saude, Washington, D.C., Estados Unidos de America.
IN  - Fernandes, Maria Neyrian de Fatima. Universidade Federal do Maranhao Imperatrize Brasil Universidade Federal do Maranhao, Imperatriz, Brasil.
IN  - Reveiz, Ludovic. Organizacao Pan-Americana da Saude Washington, D.C. Estados Unidos de America Organizacao Pan-Americana da Saude, Washington, D.C., Estados Unidos de America.
IN  - Filho, Jose Rodrigues Freire. Universidade de Sao Paulo Ribeirao Preto Brasil Universidade de Sao Paulo, Ribeirao Preto, Brasil.
IN  - da Silva, Fernando Antonio Menezes. Organizacao Pan-Americana da Saude Washington, D.C. Estados Unidos de America Organizacao Pan-Americana da Saude, Washington, D.C., Estados Unidos de America.
AB  - Objective: To evaluate the effectiveness of the strategy of skill mix of nurses and other health care professionals in primary health care.
AB  - Methods: Systematic review of the literature aligned with the recommendations of the Preferred Reporting Items for Systematic Reviews and Meta-Analyses (PRISMA), including observational and intervention studies. No restrictions were established for period or country of publication; studies published in Spanish, English and Portuguese were included. The search was carried out in MEDLINE, CINAHL, LILACS, EMBASE and Web of Science electronic databases.
AB  - Results: Eighteen studies were analyzed, including 6 from the United States; 3 from the Netherlands; 2 from the United Kingdom; 1 each from Australia, South Africa, South Korea, Scotland, Haiti and Japan; and 1 study with a prospective observational design from 8 countries. The studies reported that the skill mix among health professionals enables a better use of material resources; optimizes time spent on care; improves adhesion to treatment, quality of care and commitment and satisfaction with the work; and reduces the level of psychological distress in nursing professionals.
AB  - Conclusions: The expansion of tasks of nurses and other health care professionals, and the skill mix as well as the development of interprofessional teams, are strategies that help to face a scarcity and poor distribution of human resources in urban and non-urban areas with improvement of the health care of the population and satisfaction of professionals and clients.
PT  - English Abstract
PT  - Journal Article
PT  - Review
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm&AN=32695147
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32695147&id=doi:10.26633%2FRPSP.2020.82&issn=1020-4989&isbn=&volume=44&issue=&spage=e82&pages=e82&date=2020&title=Pan+American+Journal+of+Public+Health&atitle=Combinacao+de+tarefas+do+enfermeiro+e+de+outros+profissionais+na+atencao+primaria+em+saude%3A+uma+revisao+sistematica.&aulast=Cassiani&pid=%3Cauthor%3ECassiani+SHB%3C%2Fauthor%3E%3CAN%3E32695147%3C%2FAN%3E%3CDT%3EEnglish+Abstract%3C%2FDT%3E

<10. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 34372794
TI  - Developing and evaluating online COVID-centric advance care planning training and information resources for nursing staff and family members in nursing homes: the necessary discussions study protocol.
SO  - BMC Geriatrics. 21(1):456, 2021 08 09.
VI  - 1
ST  - MEDLINE
AU  - Harding A
AU  - Preston N
AU  - Doherty J
AU  - Cousins E
AU  - Varey S
AU  - McCann A
AU  - Dening KH
AU  - Finucane A
AU  - Carter G
AU  - Mitchell G
AU  - Brazil K
AI  - Brazil, Kevin; ORCID: https://orcid.org/0000-0001-7669-4991
FA  - Harding, Andrew
FA  - Preston, Nancy
FA  - Doherty, Julie
FA  - Cousins, Emily
FA  - Varey, Sandra
FA  - McCann, Adrienne
FA  - Dening, Karen Harrison
FA  - Finucane, Anne
FA  - Carter, Gillian
FA  - Mitchell, Gary
FA  - Brazil, Kevin
IN  - Harding, Andrew. Division of Health Research, Faculty of Health and Medicine, Lancaster University, Lancaster, UK.
IN  - Preston, Nancy. Division of Health Research, Faculty of Health and Medicine, Lancaster University, Lancaster, UK.
IN  - Doherty, Julie. School of Nursing and Midwifery, Centre for Evidence and Social Innovation, Queen's University Belfast, Belfast, UK.
IN  - Cousins, Emily. Division of Health Research, Faculty of Health and Medicine, Lancaster University, Lancaster, UK.
IN  - Varey, Sandra. Division of Health Research, Faculty of Health and Medicine, Lancaster University, Lancaster, UK.
IN  - McCann, Adrienne. School of Nursing and Midwifery, Centre for Evidence and Social Innovation, Queen's University Belfast, Belfast, UK.
IN  - Dening, Karen Harrison. School of Nursing and Midwifery, Faculty of Health and Life Sciences, De Montfort University, Leicester & Dementia UK, London, UK.
IN  - Finucane, Anne. Clinical Psychology, University of Edinburgh, Edinburgh & Marie Curie Hospice Edinburgh, Edinburgh, UK.
IN  - Carter, Gillian. School of Nursing and Midwifery, Centre for Evidence and Social Innovation, Queen's University Belfast, Belfast, UK.
IN  - Mitchell, Gary. School of Nursing and Midwifery, Centre for Evidence and Social Innovation, Queen's University Belfast, Belfast, UK.
IN  - Brazil, Kevin. School of Nursing and Midwifery, Centre for Evidence and Social Innovation, Queen's University Belfast, Belfast, UK. k.brazil@qub.ac.uk.
AB  - BACKGROUND: Nursing home residents are typically older adults with high levels of chronic illness and impairment. As such, they are particularly susceptible to severe complications and mortality from COVID-19. Since all nursing home residents are at increased risk, nursing home care staff need to know what residents would want to happen should they become infected with COVID-19. This study aims to develop and evaluate advance care planning (ACP) COVID-centric online training and information resources for nursing home staff and family members of residents, to improve care at the end of life during a COVID-19 outbreak. Based on the findings we will develop implementation guidelines for nursing homes to ensure wider impact and application during the pandemic and beyond.
AB  - METHODS: The content of the training and information resources will be based on a rapid review of literature and guidance on ACP in the context of COVID-19 and consultation with the study expert reference group. An integrated communications company will then work alongside the research team to design the online training and information resources. To evaluate the resources, we will employ a multiple case study design where a nursing home (defined as an institutional setting in which nursing care is provided to older adults on-site 24 h a day) will be the unit of analysis or 'case'. The RE-AIM (reach, effectiveness, adoption, implementation, maintenance) framework will guide the evaluation of implementation of the training and information resources. We will recruit and interview staff and family members from between 6 and 9 nursing homes across Northern Ireland, England and Scotland and gather quantitative data from a feedback survey included in the training and information resources.
AB  - DISCUSSION: The Necessary Discussions study is very timely given the challenging experiences of nursing homes, their staff, residents and their family members during the COVID-19 pandemic. It meets a key need and addresses an important gap in research and practice. The training and information resources will be 'COVID-centric', but they will also have a longstanding relevance for future ACP practice in UK care homes.
AB  - TRIAL REGISTRATION: ISRCTN registry ( ID 18003630 ) on 19.05.21.

 Copyright © 2021. The Author(s).
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=medl&AN=34372794
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:34372794&id=doi:10.1186%2Fs12877-021-02398-1&issn=1471-2318&isbn=&volume=21&issue=1&spage=456&pages=456&date=2021&title=BMC+Geriatrics&atitle=Developing+and+evaluating+online+COVID-centric+advance+care+planning+training+and+information+resources+for+nursing+staff+and+family+members+in+nursing+homes%3A+the+necessary+discussions+study+protocol.&aulast=Harding&pid=%3Cauthor%3EHarding+A%3C%2Fauthor%3E%3CAN%3E34372794%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<11. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30449154
TI  - Developing facilitation skills amongst undergraduate nursing students to promote dementia awareness with children in a higher education institution (innovative practice).
SO  - Dementia. 19(8):2857-2866, 2020 Nov.
VI  - 1
ST  - MEDLINE
AU  - Gibson C
AU  - Rennie K
AU  - Dewing J
AU  - McKinlay L
FA  - Gibson, Caroline
FA  - Rennie, Karen
FA  - Dewing, Jan
FA  - McKinlay, Lesley
IN  - Gibson, Caroline. Queen Margaret University, Edinburgh, UK.
IN  - Rennie, Karen. Queen Margaret University, Edinburgh, UK.
IN  - Dewing, Jan. Queen Margaret University, Edinburgh, UK.
IN  - McKinlay, Lesley. Queen Margaret University, Edinburgh, UK.
AB  - Final year students on a BSc Hons Nursing programme in Scotland were supported to become Dementia Friends facilitators and develop interactive dementia awareness sessions for children from local schools. The children were invited to indicate phrases and images they associated with 'dementia' at the outset and end of the session. Analysis of the responses suggested that there were positive changes in the children's values and beliefs when thinking about a person living with dementia during the sessions. We suggest that peer learning is a valuable strategy to increase public and professional awareness about dementia and supports the development of graduate attributes.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=medl&AN=30449154
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30449154&id=doi:10.1177%2F1471301218811788&issn=1471-3012&isbn=&volume=19&issue=8&spage=2857&pages=2857-2866&date=2020&title=Dementia&atitle=Developing+facilitation+skills+amongst+undergraduate+nursing+students+to+promote+dementia+awareness+with+children+in+a+higher+education+institution+%28innovative+practice%29.&aulast=Gibson&pid=%3Cauthor%3EGibson+C%3C%2Fauthor%3E%3CAN%3E30449154%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<12. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32587731
TI  - Undergraduate nursing and midwifery student's attitudes to mental illness.
SO  - Nursing Open. 7(4):1118-1128, 2020 07.
VI  - 1
ST  - MEDLINE
AU  - Hawthorne A
AU  - Fagan R
AU  - Leaver E
AU  - Baxter J
AU  - Logan P
AU  - Snowden A
AI  - Hawthorne, Angela; ORCID: https://orcid.org/0000-0001-9813-6405
AI  - Snowden, Austyn; ORCID: https://orcid.org/0000-0001-9321-622X
FA  - Hawthorne, Angela
FA  - Fagan, Ross
FA  - Leaver, Elspeth
FA  - Baxter, Jessica
FA  - Logan, Pamela
FA  - Snowden, Austyn
IN  - Hawthorne, Angela. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
IN  - Hawthorne, Angela. Rapid Response Team, Royal Edinbugh Hospital Edinburgh UK.
IN  - Fagan, Ross. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
IN  - Fagan, Ross. South East Recovery Hub South Neighbourhood Office (West Wing) Edinburgh UK.
IN  - Leaver, Elspeth. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
IN  - Leaver, Elspeth. HMP Addiewell Addiewell UK.
IN  - Baxter, Jessica. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
IN  - Baxter, Jessica. Huntlyburn Ward Borders General Hospital Melrose UK.
IN  - Logan, Pamela. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
IN  - Snowden, Austyn. School of Health and Social Care Edinburgh Napier University Edinburgh UK.
AB  - Aim: To explore levels of stigma in students of all fields of nursing and midwifery at different years and examine the impact of exposure to people with mental illness.
AB  - Design: A cross-sectional survey was used.
AB  - Methods: The Community Attitudes to Mental Illness questionnaire was administered to all branches of student nurses (adult health, mental health, child health and learning disability) and midwives in all three years in one Higher Education Institution (HEI) in Scotland.
AB  - Results: Mental health nursing students scored significantly better on all stigma subscales. Stigma worsened with a little professional exposure to people with mental illness but then improved with increasing exposure. Both personal exposure and professional exposure to people with mental illness change perceptions. The professional results follow a J-curve. Current plans for cross-field experience involving short or virtual placements during student nurse training are likely to worsen stigma rather than improve it.

 Copyright © 2020 The Authors. Nursing Open published by John Wiley & Sons Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=32587731
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32587731&id=doi:10.1002%2Fnop2.494&issn=2054-1058&isbn=&volume=7&issue=4&spage=1118&pages=1118-1128&date=2020&title=Nursing+Open&atitle=Undergraduate+nursing+and+midwifery+student%27s+attitudes+to+mental+illness.&aulast=Hawthorne&pid=%3Cauthor%3EHawthorne+A%3C%2Fauthor%3E%3CAN%3E32587731%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<13. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 33823376
TI  - Professional identity in nursing: A mixed method research study. [Review]
SO  - Nurse Education in Practice. 52:103039, 2021 Mar.
VI  - 1
ST  - MEDLINE
AU  - Philippa R
AU  - Ann H
AU  - Jacqueline M
AU  - Nicola A
FA  - Philippa, Rasmussen
FA  - Ann, Henderson
FA  - Jacqueline, McCallum
FA  - Nicola, Andrew
IN  - Philippa, Rasmussen. Nursing Science Program, Adelaide Nursing School, Faculty of Health and Medical Science, University of Adelaide, Level 4, Adelaide Health and Medical Science Building, Corner North Terrace and George Street, Adelaide, South Australia 5005, Australia. Electronic address: philippa.rasmussen@adelaide.edu.au.
IN  - Ann, Henderson. Adelaide Nursing School, Faculty of Health and Medical Science, University of Adelaide, Level 4, Adelaide Health and Medical Science Building, Corner North Terrace and George Street, Adelaide, South Australia 5005, Australia.
IN  - Jacqueline, McCallum. Department/Reader Glasgow Caledonian University, Room A401, Govan Mbeki Building Cowcaddens Road, Glasgow G4 0BA, Scotland, UK.
IN  - Nicola, Andrew. Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, Scotland, UK.
AB  - Professional identity is developed through a self-understanding as a nurse along with experience in clinical practice and understanding of their role. Personal and professional factors can influence its development. A recent integrative literature review synthesised factors that influenced registered nurse's perceptions of their professional identity into three categories of the self, the role and the context of nursing practice. This review recommended that further research was needed into professional identity and how factors and perceptions changed over time. The aims of this study were to explore registered nurses' understanding of professional identity and establish if it changed over time. A mixed-methods study using a two-stage design with an on-line survey and focus groups was implemented with registered nurses who were studying nursing at a postgraduate level in Australia or Scotland. The reported influences on professional identity related to the nurse, the nursing role, patient care, the environment, the health care team and the perceptions of nursing. Professional development and time working in the profession were drivers of changes in thinking about nursing, their role and working context and their professional identity. Additionally, participants sought validation of their professional identity from others external to the profession.

 Copyright © 2021 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Review
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=33823376
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:33823376&id=doi:10.1016%2Fj.nepr.2021.103039&issn=1471-5953&isbn=&volume=52&issue=&spage=103039&pages=103039&date=2021&title=Nurse+Education+in+Practice&atitle=Professional+identity+in+nursing%3A+A+mixed+method+research+study.&aulast=Philippa&pid=%3Cauthor%3EPhilippa+R%3C%2Fauthor%3E%3CAN%3E33823376%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<14. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32657489
TI  - How has COVID-19 impacted on Learning Disability Nursing Services in Scotland?.
SO  - Journal of Psychiatric & Mental Health Nursing. 28(3):503-504, 2021 Jun.
VI  - 1
ST  - MEDLINE
AU  - Middleton A
AU  - Gribben K
AU  - Houston A
AU  - McInroy M
AU  - Shepherd K
AU  - Wilson A
AU  - Cairney S
AI  - Middleton, Alan; ORCID: https://orcid.org/0000-0002-9933-6318
FA  - Middleton, Alan
FA  - Gribben, Karen
FA  - Houston, Alison
FA  - McInroy, Michelle
FA  - Shepherd, Kelly
FA  - Wilson, Ashleigh
FA  - Cairney, Sophie
IN  - Middleton, Alan. Glasgow Caledonian University, Glasgow, UK.
IN  - Gribben, Karen. East Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
IN  - Houston, Alison. East Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
IN  - McInroy, Michelle. East Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
IN  - Shepherd, Kelly. North Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
IN  - Wilson, Ashleigh. East Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
IN  - Cairney, Sophie. North Ayrshire Health & Social Care Partnership, NHS Ayrshire & Arran, Ayr, UK.
PT  - Letter
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=32657489
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32657489&id=doi:10.1111%2Fjpm.12674&issn=1351-0126&isbn=&volume=28&issue=3&spage=503&pages=503-504&date=2021&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=How+has+COVID-19+impacted+on+Learning+Disability+Nursing+Services+in+Scotland%3F.&aulast=Middleton&pid=%3Cauthor%3EMiddleton+A%3C%2Fauthor%3E%3CAN%3E32657489%3C%2FAN%3E%3CDT%3ELetter%3C%2FDT%3E

<15. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 33830792
TI  - The future of nurse education? Studying at the Open University in Scotland.
SO  - British Journal of Nursing. 30(7):428-432, 2021 Apr 08.
VI  - 1
ST  - MEDLINE
AU  - Davidson MC
AU  - Malcolm L
AU  - Sturley L
AU  - Crowley M
AU  - MacKinnon F
AU  - McInally W
FA  - Davidson, Michael Cj
FA  - Malcolm, Lorraine
FA  - Sturley, Liz
FA  - Crowley, Margaret
FA  - MacKinnon, Fiona
FA  - McInally, Wendy
IN  - Davidson, Michael Cj. Nations Manager.
IN  - Malcolm, Lorraine. Project Development Manager, Widening Access to Nursing.
IN  - Sturley, Liz. Programme Lead, Nursing.
IN  - Crowley, Margaret. Staff Tutor, Nursing.
IN  - MacKinnon, Fiona. Staff Tutor, Nursing.
IN  - McInally, Wendy. Senior Lecturer in Children and Young People's Nursing, Faculty of Wellbeing, Education and Language Studies, The Open University, Edinburgh.
AB  - This article describes nurse education with the Open University in Scotland (OUiS). Although there are problems with nurse recruitment and retention across the UK, in Scotland the landscape is somewhat different, with greater support for students required in remote and rural areas. Despite these challenges, the OUiS continues to recruit to the commissioned numbers of places. OUiS nursing students are primarily health care support workers who are a key group within the health and social care workforce but historically have faced many challenges in developing clear career pathways into nursing. At the heart of the OU is the fundamental recognition of distance online pedagogy, complemented by work-based learning support by employers. Partnership working between the OU, employers and education commissioners is crucial to its success.
PT  - Journal Article
YR  - 2021
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=33830792
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:33830792&id=doi:10.12968%2Fbjon.2021.30.7.428&issn=0966-0461&isbn=&volume=30&issue=7&spage=428&pages=428-432&date=2021&title=British+Journal+of+Nursing&atitle=The+future+of+nurse+education%3F+Studying+at+the+Open+University+in+Scotland.&aulast=Davidson&pid=%3Cauthor%3EDavidson+MC%3C%2Fauthor%3E%3CAN%3E33830792%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<16. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32890934
TI  - Strategies to promote nurses' health: A qualitative study with student nurses.
SO  - Nurse Education in Practice. 48:102860, 2020 Oct.
VI  - 1
ST  - MEDLINE
AU  - Bak MAR
AU  - Hoyle LP
AU  - Mahoney C
AU  - Kyle RG
FA  - Bak, Marieke A R
FA  - Hoyle, Louise P
FA  - Mahoney, Catherine
FA  - Kyle, Richard G
IN  - Bak, Marieke A R. Section of Medical Ethics, Department of General Practice, Amsterdam UMC, University of Amsterdam, Meibergdreef 15, 1105 AZ, Amsterdam, the Netherlands. Electronic address: marieke.bak@amsterdamumc.nl.
IN  - Hoyle, Louise P. Faculty of Health Sciences and Sport, University of Stirling, Stirling, FK9 4LA, UK. Electronic address: louise.hoyle@stir.ac.uk.
IN  - Mahoney, Catherine. School of Health & Social Care, Edinburgh Napier University, Edinburgh, EH11 4BN, UK. Electronic address: c.mahoney@napier.ac.uk.
IN  - Kyle, Richard G. School of Health & Social Care, Edinburgh Napier University, Edinburgh, EH11 4BN, UK; Research and Evaluation Division, Public Health Wales, Cardiff, CF10 4BZ, UK. Electronic address: richard.kyle@wales.nhs.uk.
AB  - Developing strategies to support student nurses' health is a global priority for healthcare organisations and governments. This is because emerging international evidence indicates that improvements in student nurses' health are required to increase the longevity of careers and reduce the loss of time, skill and financial cost of sickness absence and workforce exit. However, we do not know what intervention strategies student nurses think would support their health. The study aim was to explore student nurses' views on factors that influence health-related behaviours and strategies that could improve health. Data were collected through participatory activities during focus groups with student nurses in Scotland. Analysis was theoretically informed and involved mapping to the Behaviour Change Wheel framework. Students identified several factors that influenced health-related behaviours. Four were ranked most important: knowledge, culture, time constraints, and stress. Strategies student nurses thought should be prioritised to improve nurses' health-related behaviours were: stimulating a health-promoting environment by reviewing shift work, improving workplace support, increasing staffing levels, subsidising and role-modelling of healthy food and exercise; and creating applied health-promoting curricula by integrating time and stress management training and lifestyle advice into nursing education. Educational and environmental interventions are needed to support student nurses' health.

 Copyright © 2020 The Authors. Published by Elsevier Ltd.. All rights reserved.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=32890934
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32890934&id=doi:10.1016%2Fj.nepr.2020.102860&issn=1471-5953&isbn=&volume=48&issue=&spage=102860&pages=102860&date=2020&title=Nurse+Education+in+Practice&atitle=Strategies+to+promote+nurses%27+health%3A+A+qualitative+study+with+student+nurses.&aulast=Bak&pid=%3Cauthor%3EBak+MAR%3C%2Fauthor%3E%3CAN%3E32890934%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<17. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32407232
TI  - Nurses step up to the challenge of working during the pandemic.
SO  - British Journal of Nursing. 29(9):512-514, 2020 May 14.
VI  - 1
ST  - MEDLINE
AU  - White J
AU  - McArdle C
AU  - McQueen F
AU  - May R
FA  - White, Jean
FA  - McArdle, Charlotte
FA  - McQueen, Fiona
FA  - May, Ruth
IN  - White, Jean. Chief Nursing Officer, Wales.
IN  - McArdle, Charlotte. Chief Nursing Officer, Northern Ireland.
IN  - McQueen, Fiona. Chief Nursing Officer, Scotland.
IN  - May, Ruth. Chief Nursing Officer, England.
AB  - Chief Nursing Officers for Northern Ireland, Scotland, Wales and England <b>Jean White</b>, <b>Charlotte McArdle</b>, <b>Fiona McQueen</b> and <b>Ruth May</b> all agree that, although plans to mark International Nurses' Day are on hold, we must still find time to celebrate nurses across all specialties who have responded with speed and flexibility.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med18&AN=32407232
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32407232&id=doi:10.12968%2Fbjon.2020.29.9.512&issn=0966-0461&isbn=&volume=29&issue=9&spage=512&pages=512-514&date=2020&title=British+Journal+of+Nursing&atitle=Nurses+step+up+to+the+challenge+of+working+during+the+pandemic.&aulast=White&pid=%3Cauthor%3EWhite+J%3C%2Fauthor%3E%3CAN%3E32407232%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<18. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 32064796
TI  - Implementing the National Early Warning Score 2 into pre-registration nurse education.
SO  - Nursing Standard. 35(3):70-75, 2020 02 28.
VI  - 1
ST  - MEDLINE
AU  - Butler ZA
FA  - Butler, Zoe Abigail
IN  - Butler, Zoe Abigail. Department of Nursing, Health and Professional Practice, University of Cumbria, Lancaster, Lancashire, England.
AB  - Recognising signs of deteriorating health in patients and responding to them appropriately are crucial nursing competencies. In acute care, failure to detect and act promptly on deterioration can lead to the patient's death. To achieve clinical competence, nursing students require training in the use of techniques for monitoring physiological observations as well as protocols that enable them to respond to deterioration. The use of early warning scores has been advocated to standardise the methods and frequency of patient monitoring in acute care settings. In 2012, the Royal College of Physicians developed the National Early Warning Score (NEWS), which was updated in 2017 and known as NEWS2. This early warning score is used in acute hospitals in England, Scotland, Wales and Northern Ireland. This article explores the benefits and challenges of using NEWS2 as an educational tool in pre-registration nursing programmes to support nursing students in recognising and responding to deteriorating health.

 Copyright © 2020 RCN Publishing Company Ltd. All rights reserved. Not to be copied, transmitted or recorded in any way, in whole or part, without prior permission of the publishers.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med17&AN=32064796
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:32064796&id=doi:10.7748%2Fns.2020.e11470&issn=0029-6570&isbn=&volume=35&issue=3&spage=70&pages=70-75&date=2020&title=Nursing+Standard&atitle=Implementing+the+National+Early+Warning+Score+2+into+pre-registration+nurse+education.&aulast=Butler&pid=%3Cauthor%3EButler+ZA%3C%2Fauthor%3E%3CAN%3E32064796%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<19. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31794948
TI  - Acceptability of delivering an adapted Buurtzorg model in the Scottish care context.
SO  - Public Health. 179:111-117, 2020 Feb.
VI  - 1
ST  - MEDLINE
AU  - Leask CF
AU  - Bell J
AU  - Murray F
FA  - Leask, C F
FA  - Bell, J
FA  - Murray, F
IN  - Leask, C F. Aberdeen City Health and Social Care Partnership, Marischal College, Broad St, Aberdeen, AB10 1AB, UK; Health Intelligence Department, NHS Grampian, Eday Rd, Aberdeen, AB15 6RE, UK. Electronic address: calum.leask@nhs.net.
IN  - Bell, J. Health Intelligence Department, NHS Grampian, Eday Rd, Aberdeen, AB15 6RE, UK. Electronic address: Jacqueline.bell11@nhs.net.
IN  - Murray, F. Health Intelligence Department, NHS Grampian, Eday Rd, Aberdeen, AB15 6RE, UK. Electronic address: Fiona.murray2@nhs.net.
AB  - OBJECTIVES: Given increasing epidemiological and financial pressures on services, there is a need to test new models of integrated health and social care. Crucial to this testing is determining acceptability, particularly to those delivering services. The Dutch 'Buurtzorg' model, characterised by self-managing nursing teams, has shown promise, but its principles are yet to be adapted and tested in Scotland. The study aim was to understand the experiences of working in a self-managing, integrated, health and social care team.
AB  - STUDY DESIGN: This is a case study within a primary care setting.
AB  - METHODS: The Integrated Neighbourhood Care Aberdeen (INCA) project comprised two self-managing teams of support workers and nurses working at different sites in Aberdeen. Acceptability was explored through semistructured interviews with staff. Data were recorded and analysed thematically.
AB  - RESULTS: Staff reported high-quality patient care, which they attributed to autonomy over the frequency and duration of visits. Tensions between team members and between teams and management were apparent partly due to the predominantly social care caseload, confounding guidance on how to implement self-management and communication challenges. The team colocated within a General Practice reported positive relationships with other professionals.
AB  - CONCLUSIONS: Self-management requires a clear framework in which to function. Allowing staff autonomy to vary care provision according to need may improve patient outcomes.

 Crown Copyright © 2019. Published by Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med17&AN=31794948
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31794948&id=doi:10.1016%2Fj.puhe.2019.10.011&issn=0033-3506&isbn=&volume=179&issue=&spage=111&pages=111-117&date=2020&title=Public+Health&atitle=Acceptability+of+delivering+an+adapted+Buurtzorg+model+in+the+Scottish+care+context.&aulast=Leask&pid=%3Cauthor%3ELeask+CF%3C%2Fauthor%3E%3CAN%3E31794948%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<20. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31756592
TI  - "Delirium: An essential component in undergraduate training?".
SO  - Nurse Education Today. 85:104211, 2020 Feb.
VI  - 1
ST  - MEDLINE
AU  - Copeland C
AU  - Barron DT
FA  - Copeland, Claire
FA  - Barron, Derek T
IN  - Copeland, Claire. Ageing & Health, NHS Forth Valley, United Kingdom of Great Britain and Northern Ireland; Care, Erskine, United Kingdom of Great Britain and Northern Ireland. Electronic address: Clairecopeland@nhs.net.
IN  - Barron, Derek T. Ageing & Health, NHS Forth Valley, United Kingdom of Great Britain and Northern Ireland; Care, Erskine, United Kingdom of Great Britain and Northern Ireland. Electronic address: derek.barron@erskine.org.uk.
AB  - Delirium is an acute medical emergency, the presenting features are significant disturbances in the person's cognition, both their attention and awareness. Delirium develops over a short period of time and predominantly relates to an underlying medical condition. It is significantly under-recognised in the older adults who present to acute medical services and in those living within a care home setting. Up to 30% of older adults who present via the Emergency Department may be experiencing signs and symptoms of delirium, with up to 33% of older adults within the care home setting also experiencing delirium. In both settings the delirium may go unrecognised and be incorrectly considered as a deterioration of an existing dementia. Nurses and care staff in the care home setting, spend more time with older adults than any member of the multi-disciplinary team e.g. GP, physiotherapist, district nurse etc. and as such, their knowledge and skills in the recognition and early intervention when delirium is present can have a significant impact on the outcome for the older adult. Using a Freedom of Information request (Freedom of Information (Scotland) Act, 2002), a legal process designed to elicit transparency and guarantee a response, the authors invited responses from Scottish universities, to enable a review of the current approach in the teaching of delirium to undergraduate nursing students. At the outset, the authors were interested to establish the extent to which delirium featured in the nursing undergraduate programme in Scotland. Having established that the approach to teaching was highly variable, this paper poses the question whether more structured focus should be given to the topic within the undergraduate nursing curriculum.

 Copyright © 2019 Elsevier Ltd. All rights reserved.
PT  - Editorial
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med17&AN=31756592
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31756592&id=doi:10.1016%2Fj.nedt.2019.104211&issn=0260-6917&isbn=&volume=85&issue=&spage=104211&pages=104211&date=2020&title=Nurse+Education+Today&atitle=%22Delirium%3A+An+essential+component+in+undergraduate+training%3F%22.&aulast=Copeland&pid=%3Cauthor%3ECopeland+C%3C%2Fauthor%3E%3CAN%3E31756592%3C%2FAN%3E%3CDT%3EEditorial%3C%2FDT%3E

<21. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31707252
TI  - An exploration of the influences on under-representation of male pre-registration nursing students.
SO  - Nurse Education Today. 84:104234, 2020 Jan.
VI  - 1
ST  - MEDLINE
AU  - Whitford HM
AU  - Marland GR
AU  - Carson MN
AU  - Bain H
AU  - Eccles J
AU  - Lee J
AU  - Taylor J
FA  - Whitford, Heather M
FA  - Marland, Glenn R
FA  - Carson, Maggie N
FA  - Bain, Heather
FA  - Eccles, Jacqueline
FA  - Lee, John
FA  - Taylor, James
IN  - Whitford, Heather M. School of Nursing and Health Sciences, University of Dundee, DD1 4HJ, United Kingdom. Electronic address: h.m.whitford@dundee.ac.uk.
IN  - Marland, Glenn R. 19 Urquhart Crescent, Dumfries DG1 4XF, United Kingdom. Electronic address: glenn.marland@uws.ac.uk.
IN  - Carson, Maggie N. School of Health in Social Science, The University of Edinburgh, Edinburgh EH8 9AG, United Kingdom. Electronic address: m.n.carson@ed.ac.uk.
IN  - Bain, Heather. School of Nursing and Midwifery, Robert Gordon University, Aberdeen AB107QJ, United Kingdom. Electronic address: Heather.bain@rgu.ac.uk.
IN  - Eccles, Jacqueline. School of Nursing and Health Sciences, University of Dundee, DD1 4HJ, United Kingdom. Electronic address: j.eccles@dundee.ac.uk.
IN  - Lee, John. School of Nursing and Health Sciences, University of Dundee, DD1 4HJ, United Kingdom. Electronic address: j.lee@dundee.ac.uk.
IN  - Taylor, James. School of Health & Life Sciences, University of the West of Scotland, G72 0LH, United Kingdom. Electronic address: james.taylor@uws.ac.uk.
AB  - BACKGROUND: Worldwide, men are under-represented in the nursing profession. In Scotland less than 10% of pre-registration nursing students are male. Reasons for this imbalance need to be understood.
AB  - OBJECTIVES: To explore the views of male pre-registration nursing students, nursing lecturers and school teachers about this imbalance.
AB  - DESIGN: Mixed methods study using focus groups and online survey.
AB  - SETTINGS: Focus groups in four locations across Scotland. Online survey sent to teachers across Scotland.
AB  - PARTICIPANTS AND METHODS: Eight focus groups with 33 male nursing students; four focus groups with 21 university and college nursing lecturers; 46 school teachers returned the online survey.
AB  - RESULTS: Although nursing was considered a worthwhile career with job stability and many opportunities, it was also viewed as not being a career for men. Assumptions about the profession and femininity were challenging for men and use of the term 'male nurse' was felt to be anomalous. In some circumstances the provision of intimate care to particular patient groups caused difficulty. Positive encouragement from others, a positive role model or knowledge of nursing from significant others could be helpful. However concerns about low earning potential and negative media publicity about the NHS could be a disincentive. Being mature and having resilience were important to cope with being a male nursing student in a mainly female workplace. Some more 'technical' specialties were felt to be more attractive to men.
AB  - CONCLUSIONS: Nursing is viewed as a worthwhile career choice for men, but the gendered assumptions about the feminine nature of nursing can be a deterrent.

 Copyright © 2019 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med17&AN=31707252
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31707252&id=doi:10.1016%2Fj.nedt.2019.104234&issn=0260-6917&isbn=&volume=84&issue=&spage=104234&pages=104234&date=2020&title=Nurse+Education+Today&atitle=An+exploration+of+the+influences+on+under-representation+of+male+pre-registration+nursing+students.&aulast=Whitford&pid=%3Cauthor%3EWhitford+HM%3C%2Fauthor%3E%3CAN%3E31707252%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<22. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31509778
TI  - Patient classification systems used to classify nursing intensity and assess nursing staffing resources in home health care: A scoping review. [Review]
SO  - International Journal of Nursing Studies. 99:103361, 2019 Nov.
VI  - 1
ST  - MEDLINE
AU  - Flo J
AU  - Landmark B
AU  - Tonnessen S
AU  - Fagerstrom L
FA  - Flo, Jill
FA  - Landmark, Bjorg
FA  - Tonnessen, Siri
FA  - Fagerstrom, Lisbeth
IN  - Flo, Jill. Faculty of Health and Social Sciences, Department of Nursing and Health Sciences, University of South-Eastern Norway, Drammen, Norway. Electronic address: Jill.Flo@usn.no.
IN  - Landmark, Bjorg. Faculty of Health and Social Sciences, Department of Nursing and Health Sciences, University of South-Eastern Norway, Drammen, Norway.
IN  - Tonnessen, Siri. Faculty of Health and Social Sciences, Department of Nursing and Health Sciences, University of South-Eastern Norway, Vestfold, Norway.
IN  - Fagerstrom, Lisbeth. Faculty of Health and Social Sciences, Department of Nursing and Health Sciences, University of South-Eastern Norway, Drammen, Norway; Faculty of Education and Welfare studies, Abo Akademi, Vasa, Finland.
AB  - OBJECTIVES: To identify the patient classification systems used to classify nursing intensity in the assessment of nursing staffing resources currently used in home health care, with a special emphasis on validity, reliability and staff allocation.
AB  - DESIGN: Scoping review of internationally published and grey literature, based on a methodological framework by Arksey and O'Malley.
AB  - DATA SOURCES: Searches of the electronic databases Cinahl, Medline, Embase and SweMed, the websites Google and Google Scholar and hand searches of reference lists occurred. Eligibility criteria included (A) a focus on patient classification systems measuring nursing intensity and workload in home health care and (B) published in English between January 2007 and March 2019. In level one testing two team members screened titles and abstracts, in level two testing two team members determined which papers should undergo a full text review. Data were extracted using structured extraction by one team member and verified by two other members.
AB  - RESULTS: Thirteen peer-reviewed articles and grey literature documents were identified, from Canada, Ireland, the UK, the USA, Scotland, Turkey and the Netherlands. Four patient classification systems had been tested for both validity and reliability. Validity was tested through face validity, predictive validity, concurrent validity or content validity index. Reliability was tested through stability, internal consistency, observer agreement or inter rater reliability. One patient classification system had been tested only for reliability, through interrater reliability and observer agreement. Two patient classification systems had been evaluated through summative evaluation; one qualitatively through focus group interviews and one through semi-structured interviews. Only one patient classification system had been validity and reliability tested and evaluated. Overall, the patient classification systems in the included papers (13) were considered to have benefits and to be appropriate for the measurement of patients' needs, workload and allocation of staff, although specific information was not always given.
AB  - CONCLUSION: Little has been published on validity or reliability tested patient classification systems linked to staffing allocation in home health care in the past decade. Limited research was seen where a patient classification system was considered to be fully operational in home health care.

 Copyright © 2019. Published by Elsevier Ltd.
PT  - Journal Article
PT  - Review
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31509778
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31509778&id=doi:10.1016%2Fj.ijnurstu.2019.05.009&issn=0020-7489&isbn=&volume=99&issue=&spage=103361&pages=103361&date=2019&title=International+Journal+of+Nursing+Studies&atitle=Patient+classification+systems+used+to+classify+nursing+intensity+and+assess+nursing+staffing+resources+in+home+health+care%3A+A+scoping+review.&aulast=Flo&pid=%3Cauthor%3EFlo+J%3C%2Fauthor%3E%3CAN%3E31509778%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<23. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31336537
TI  - Assessment of inpatient diabetes knowledge among healthcare professionals in a district general hospital.
SO  - Diabetes & Metabolic Syndrome. 13(2):1657-1660, 2019 Mar - Apr.
VI  - 1
ST  - MEDLINE
AU  - Thomas L
AU  - Devi Krishnamoorthy SD
AU  - Ramasami P
FA  - Thomas, Lydiya
FA  - Devi Krishnamoorthy, Sri Dthuruga
FA  - Ramasami, Prakash
IN  - Thomas, Lydiya. Dr Gray's Hospital, NHS Grampian, Elgin, IV30 1SN, UK. Electronic address: lydiya.thomas@nhs.net.
IN  - Devi Krishnamoorthy, Sri Dthuruga. Dr Gray's Hospital, NHS Grampian, Elgin, IV30 1SN, UK.
IN  - Ramasami, Prakash. Department of Biostatistics, Christian Medical College, Vellore, 632 002, India.
AB  - AIMS: Diabetes mellitus is a commonly encountered diagnosis in hospitalised patients that is associated with prolonged admissions and mortality. One in six hospital beds in the UK are occupied by diabetes patients. Therefore, healthcare providers need to have a sound knowledge in managing in-patients with diabetes. Thus the aim of this clinical survey was to assess the diabetes-related knowledge of healthcare professionals in a district general hospital.
AB  - METHODS: A 24-item questionnaire, based on the 'Think Check Act (TCA)' diabetes modules implemented by the Healthcare Improvement Scotland was issued to the medical and nursing staff. Simple statistics were used for data collation and analysis.
AB  - RESULTS: 30 questionnaires were completed by 10 doctors at varying stages of training, 17 nurses, 1 physician associate and 2 healthcare assistants. The mean percentage score of the participants were 57.4%. 22 (73.3%) correctly defined hypoglycaemia and 27 (90%) knew the location of hypo box and 7 (23.3%) were aware of TCA. Responses to other management related to diabetes emergencies were average. The responses between doctors and nurses were insignificant except for hypo box location (p=0.0413).
AB  - CONCLUSION: Knowledge about managing inpatient diabetes problems amongst healthcare professional at a district general hospital appears mediocre. Significant gaps have been identified which would be targeted for future educational events.

 Crown Copyright © 2019. Published by Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31336537
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31336537&id=doi:10.1016%2Fj.dsx.2019.03.028&issn=1871-4021&isbn=&volume=13&issue=2&spage=1657&pages=1657-1660&date=2019&title=Diabetes+%26+Metabolic+Syndrome&atitle=Assessment+of+inpatient+diabetes+knowledge+among+healthcare+professionals+in+a+district+general+hospital.&aulast=Thomas&pid=%3Cauthor%3EThomas+L%3C%2Fauthor%3E%3CAN%3E31336537%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<24. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31234832
TI  - Process evaluation of specialist nurse implementation of a soft opt-out organ donation system in Wales.
SO  - BMC Health Services Research. 19(1):414, 2019 Jun 24.
VI  - 1
ST  - MEDLINE
AU  - Noyes J
AU  - Mclaughlin L
AU  - Morgan K
AU  - Roberts A
AU  - Moss B
AU  - Stephens M
AU  - Walton P
AI  - Noyes, Jane; ORCID: http://orcid.org/0000-0003-4238-5984
FA  - Noyes, Jane
FA  - Mclaughlin, Leah
FA  - Morgan, Karen
FA  - Roberts, Abigail
FA  - Moss, Bethan
FA  - Stephens, Michael
FA  - Walton, Phillip
IN  - Noyes, Jane. School of Social Sciences, Bangor University, Room 107, Neuaddc Ogwen, Bangor, Wales, UK, LL57 2DG. jane.noyes@bangor.ac.uk.
IN  - Mclaughlin, Leah. School of Social Sciences, Bangor University, Room 107, Neuaddc Ogwen, Bangor, Wales, UK, LL57 2DG.
IN  - Morgan, Karen. Major Health Conditions Policy Team, Directorate of Health Policy, Health and Social Services Group, Welsh Government, Cardiff, Wales, UK, CF10 3NQ.
IN  - Roberts, Abigail. NHS Blood and Transplant, North West Regional Office, 14 Estuary Banks, Speke, Liverpool, L24 8RB, UK.
IN  - Moss, Bethan. NHS Blood and Transplant, South Wales, South West and South Central, Unit 3 Cae Gwyrdd, Greenmeadow Springs Business Park, Tongwynlais, Cardiff, CF15 7AB, UK.
IN  - Stephens, Michael. Department of Nephrology and Transplantation, Heath Park, Cardiff and Vale University Health Board, University Hospital of Wales, Cardiff, CF14 4XW, UK.
IN  - Walton, Phillip. NHS Blood and Transplant, South Wales, South West and South Central, Unit 3 Cae Gwyrdd, Greenmeadow Springs Business Park, Tongwynlais, Cardiff, CF15 7AB, UK.
AB  - BACKGROUND: Wales introduced a soft opt-out organ donation system on 1st December 2015 with the aim of improving consent rates. In the first 18 months consent rates improved but the difference could not solely be attributed to the soft opt-out system when compared with similar improvements in consent rates in other UK nations.
AB  - METHODS: We conducted an 18 month post-intervention qualitative process evaluation involving 88 family members of 60/211 potential organ donor cases, and 19 professionals. Views and experiences of Specialist Nurses in Organ Donation who implemented the new system and family members who were involved in decision making were collected to see how their respective behaviours impacted on implementation. Data collection included interviews, focus groups and qualitative questionnaire data.
AB  - RESULTS: Implementation was considered a success by Specialist Nurses in Organ Donation. The bespoke retraining programme and responsive approach to addressing initial implementation issues were identified as examples of best practice. Specialist Nurses in Organ Donation were valued by family members. Six implementation issues had an impact on consent rates - the media campaign had gaps, the system was more complex, challenges in changing professional behaviours, inability to obtain the required standard of evidence from family members to overturn a donation decision, increased complexity of consent processes, and additional health systems issues.
AB  - CONCLUSION: This is the first comprehensive process evaluation of implementing a soft opt-out system of organ donation. Specific elements of good implementation practice (such as investment in the retraining programme and the responsiveness of Specialist Nurses in Organ Donation and managers to feedback) were identified. The key message is that despite retraining, nursing practice did not radically change overnight to accommodate the new soft opt-out system. Policy makers and health service managers should not assume that nurses simply need more time to implement the soft-out as intended. Additional responsive modification of processes, ongoing training and support is required to help with implementation as originally intended. Scotland, England and the Netherlands are introducing soft opt-out systems. There is an opportunity to learn from initial implementation in Wales, by acknowledging gaps, good practice and opportunities to further improve processes and nursing practices.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31234832
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31234832&id=doi:10.1186%2Fs12913-019-4266-z&issn=1472-6963&isbn=&volume=19&issue=1&spage=414&pages=414&date=2019&title=BMC+Health+Services+Research&atitle=Process+evaluation+of+specialist+nurse+implementation+of+a+soft+opt-out+organ+donation+system+in+Wales.&aulast=Noyes&pid=%3Cauthor%3ENoyes+J%3C%2Fauthor%3E%3CAN%3E31234832%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<25. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31194650
TI  - General Practice Nurse education in Scotland - now and in the future.
SO  - Education for Primary Care. 30(5):263-266, 2019 09.
VI  - 1
ST  - MEDLINE
AU  - Innes L
FA  - Innes, Lynne
IN  - Innes, Lynne. Medicine, NHS Education for Scotland, Edinburgh, UK.
AB  - General practice is changing in Scotland with a new GP contract transforming how health care will be delivered in the future. These changes and developments are supportive of general practice nurses (GPNs) enabling their transformation into a new role of expert nursing generalists. GPNs are core members of the primary care team and are therefore fundamental to the future of General Practice. With over half of all GPNs in Scotland being over the age of 50 years or over the profession faces challenges to sustain the workforce. In consideration of this, the Scottish Government and NHS Education for Scotland have considered these challenges and are supporting GPNs with significant investment and a clear vision to support recruitment and retention of a highly skilled GPN workforce for the future.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31194650
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31194650&id=doi:10.1080%2F14739879.2019.1626771&issn=1473-9879&isbn=&volume=30&issue=5&spage=263&pages=263-266&date=2019&title=Education+for+Primary+Care&atitle=General+Practice+Nurse+education+in+Scotland+-+now+and+in+the+future.&aulast=Innes&pid=%3Cauthor%3EInnes+L%3C%2Fauthor%3E%3CAN%3E31194650%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<26. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31166774
TI  - Barriers and facilitators to implementing the Carer Support Needs Assessment Tool in a community palliative care setting.
SO  - British Journal of Community Nursing. 24(6):284-290, 2019 Jun 02.
VI  - 1
ST  - MEDLINE
AU  - Horseman Z
AU  - Milton L
AU  - Finucane A
FA  - Horseman, Zoe
FA  - Milton, Libby
FA  - Finucane, Anne
IN  - Horseman, Zoe. Research Assistant, Usher Institute of Population Health Sciences and Informatics College of Medicine and Veterinary Medicine, University of Edinburgh.
IN  - Milton, Libby. Lead Nurse, Marie Curie Hospice Edinburgh.
IN  - Finucane, Anne. Honorary Fellow, University of Edinburgh; Research Lead, Marie Curie Hospice.
AB  - Family carers play a central role in community-based palliative care. However, caring for a terminally ill person puts the carer at increased risk of physical and mental morbidity. The Carer Support Needs Assessment Tool (CSNAT) enables comprehensive assessment of carer support needs. The present study aimed to identify barriers and facilitators to implementing the CSNAT in a community specialist palliative care service. Semi-structured interviews with 12 palliative care nurse specialists from two community nursing teams in Lothian, Scotland, June 2017. Data was audio-recorded, transcribed and analysed. Palliative care nurse specialists acknowledge the importance of carers in palliative care and encourage carer support practices. Nurses perceived the CSNAT as useful, but used it as an 'add-on' to current practice, rather than as a new approach to carer-led assessment. Further training is recommended to ensure community palliative care nurses are familiar with the broader CSNAT approach.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31166774
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31166774&id=doi:10.12968%2Fbjcn.2019.24.6.284&issn=1462-4753&isbn=&volume=24&issue=6&spage=284&pages=284-290&date=2019&title=British+Journal+of+Community+Nursing&atitle=Barriers+and+facilitators+to+implementing+the+Carer+Support+Needs+Assessment+Tool+in+a+community+palliative+care+setting.&aulast=Horseman&pid=%3Cauthor%3EHorseman+Z%3C%2Fauthor%3E%3CAN%3E31166774%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<27. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31070968
TI  - Leaders in health for everyone.
SO  - British Journal of Nursing. 28(9):568-570, 2019 May 09.
VI  - 1
ST  - MEDLINE
AU  - May R
AU  - McArdle C
AU  - McQueen F
AU  - White J
FA  - May, Ruth
FA  - McArdle, Charlotte
FA  - McQueen, Fiona
FA  - White, Jean
IN  - May, Ruth. Chief Nursing Officer, England.
IN  - McArdle, Charlotte. Chief Nursing Officer, Northern Ireland.
IN  - McQueen, Fiona. Chief Nursing Officer, Scotland.
IN  - White, Jean. Chief Nursing Officer, Wales.
AB  - The chief nursing officers for England, Northern Ireland, Scotland and Wales celebrate nurses' essential role in ensuring high-quality care for all.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31070968
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31070968&id=doi:10.12968%2Fbjon.2019.28.9.568&issn=0966-0461&isbn=&volume=28&issue=9&spage=568&pages=568-570&date=2019&title=British+Journal+of+Nursing&atitle=Leaders+in+health+for+everyone.&aulast=May&pid=%3Cauthor%3EMay+R%3C%2Fauthor%3E%3CAN%3E31070968%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<28. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31007257
TI  - Chronic Stress and Ovarian Function in Female Childhood Cancer Survivors.
SO  - Oncology Nursing Forum. 46(3):E75-E85, 2019 05 01.
VI  - 1
ST  - MEDLINE
AU  - Hardy TM
AU  - Garnier-Villarreal M
AU  - Ohlendorf JM
AU  - McCarthy DO
FA  - Hardy, Theresa M
FA  - Garnier-Villarreal, Mauricio
FA  - Ohlendorf, Jennifer M
FA  - McCarthy, Donna O
IN  - Hardy, Theresa M. New York University.
IN  - Garnier-Villarreal, Mauricio. Marquette University.
IN  - Ohlendorf, Jennifer M. Marquette University.
IN  - McCarthy, Donna O. Marquette University.
AB  - OBJECTIVES: To explore the relationships among perceived stress, biomarkers of hypothalamic-pituitary-adrenal (HPA) activity, gonadotropin levels, and anti-Mullerian hormone (AMH) in female childhood cancer survivors (CCSs).
AB  - SAMPLE &AMP; SETTING: 24 female CCSs from the Royal Hospital for Sick Children in Edinburgh, Scotland, were included in the study.
AB  - METHODS &AMP; VARIABLES: Perceived stress was measured using the Perceived Stress Scale. HPA activity was measured using salivary cortisol and hair cortisol. Ovarian function was measured using serum gonadotropin levels and serum AMH levels. Latent growth curve modeling was used to determine diurnal cortisol slope and intercept. Bayesian structural equation modeling was used to explore the relationship among perceived stress, biomarkers of HPA activity, and ovarian function.
AB  - RESULTS: The authors found an inverse association between perceived stress and ovarian function and a positive association between biomarkers of HPA activity and ovarian function.
AB  - IMPLICATIONS FOR NURSING: Further research is needed to understand factors contributing to risk for post-treatment reproductive dysfunction in female CCSs.
PT  - Journal Article
PT  - Research Support, N.I.H., Extramural
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=31007257
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31007257&id=doi:10.1188%2F19.ONF.E75-E85&issn=0190-535X&isbn=&volume=46&issue=3&spage=E75&pages=E75-E85&date=2019&title=Oncology+Nursing+Forum&atitle=Chronic+Stress+and+Ovarian+Function+in+Female+Childhood+Cancer+Survivors.&aulast=Hardy&pid=%3Cauthor%3EHardy+TM%3C%2Fauthor%3E%3CAN%3E31007257%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<29. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30884418
TI  - Health and health behaviours among a cohort of first year nursing students in Scotland: A self-report survey.
SO  - Nurse Education in Practice. 36:71-75, 2019 Mar.
VI  - 1
ST  - MEDLINE
AU  - Evans JM
AU  - Eades CE
AU  - Cameron DM
FA  - Evans, Josie Mm
FA  - Eades, Claire E
FA  - Cameron, Dawn M
IN  - Evans, Josie Mm. Faculty of Health Sciences and Sport, University of Stirling, Scotland, FK9 4LA, UK. Electronic address: josie.evans@stir.ac.uk.
IN  - Eades, Claire E. Faculty of Health Sciences and Sport, University of Stirling, Scotland, FK9 4LA, UK. Electronic address: c.e.eades@stir.ac.uk.
IN  - Cameron, Dawn M. Faculty of Health Sciences and Sport, University of Stirling, Scotland, FK9 4LA, UK. Electronic address: dawn.cameron@stir.ac.uk.
AB  - The study aim was to collect data on the health and health-related behaviours of undergraduate nursing students at a Higher Education Institution in Scotland, to identify the need for potential health behaviour change interventions as part of their undergraduate course. An anonymous self-report questionnaire (with questions about physical activity, diet, sleep, alcohol, smoking, mental health) was administered to first year nursing students at a Scottish university. The response rate was 88%, with 207 respondents (26 male, 178 female, 3 other). Age ranged from 16 to 45 years (mean 24.5 years). Overall, 48 (23.1%) students rated their physical health as excellent/very good, and 100 (48.3%) their mental health as such. 157 (76.2%) students were achieving 150min of physical activity per week. There were 48 (29%) and 30 (18.2%) overweight and obese students respectively. 129 (62.6%) students viewed a mobile device for >30min before sleep. 176 (86.3%) students consumed alcohol, with 32 (15.4%) reporting binge drinking. The prevalence of current smoking was 24.8%. The students' health behaviour profile was therefore broadly similar to that of the general population in Scotland, but smoking, diet, sleep practices and binge-drinking were identified as priority areas for health education and intervention.

 Copyright © 2019. Published by Elsevier Ltd.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30884418
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30884418&id=doi:10.1016%2Fj.nepr.2019.02.019&issn=1471-5953&isbn=&volume=36&issue=&spage=71&pages=71-75&date=2019&title=Nurse+Education+in+Practice&atitle=Health+and+health+behaviours+among+a+cohort+of+first+year+nursing+students+in+Scotland%3A+A+self-report+survey.&aulast=Evans&pid=%3Cauthor%3EEvans+JM%3C%2Fauthor%3E%3CAN%3E30884418%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<30. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30830704
TI  - Mixed-methods evaluation of an educational intervention to change mental health nurses' attitudes to people diagnosed with borderline personality disorder.
SO  - Journal of Clinical Nursing. 28(13-14):2613-2623, 2019 Jul.
VI  - 1
ST  - MEDLINE
AU  - Dickens GL
AU  - Lamont E
AU  - Mullen J
AU  - MacArthur N
AU  - Stirling FJ
AI  - Dickens, Geoffrey L; ORCID: https://orcid.org/0000-0002-8862-1527
AI  - Stirling, Fiona J; ORCID: https://orcid.org/0000-0001-6241-6704
FA  - Dickens, Geoffrey L
FA  - Lamont, Emma
FA  - Mullen, Jo
FA  - MacArthur, Nadine
FA  - Stirling, Fiona J
IN  - Dickens, Geoffrey L. School of Health and Social Sciences, Abertay University, Dundee, UK.
IN  - Lamont, Emma. School of Health and Social Sciences, Abertay University, Dundee, UK.
IN  - Mullen, Jo. Independent Consultant, Elgin, UK.
IN  - MacArthur, Nadine. NHS Grampian, Dr Gray's Hospital, Elgin, UK.
IN  - Stirling, Fiona J. School of Health and Social Sciences, Abertay University, Dundee, UK.
AB  - AIMS AND OBJECTIVES: To evaluate and explore mental health nurses' responses to and experience of an educational intervention to improve attitudes towards people with a diagnosis of borderline personality disorder (BPD). Report findings are concordant with relevant EQUATOR guidelines (STROBE and COREQ).
AB  - BACKGROUND: Attitudes towards people with a diagnosis of BPD are poorer than for people with other diagnoses. There is limited evidence about what might improve this situation. One intervention with reportedly good effect uses an underlying biosocial model of BPD. No previous intervention has been co-produced with an expert by experience. We developed and delivered a 1-day intervention comprising these elements.
AB  - DESIGN: A mixed-methods design was used comprising prospective within-subjects cohort intervention and qualitative elements. Participants were mental health nursing staff working in inpatient and community settings in one NHS Board in Scotland, UK.
AB  - METHODS: Measurement of cognitive and emotional attitudes to people with a diagnosis of BPD at pre- and postintervention (N = 28) and at 4-month follow-up. Focus groups were used to explore participants' experiences of the intervention (N = 11).
AB  - RESULTS: Quantitative evaluation revealed some sustained changes consistent with expected attitudinal gains in relation to the perceived treatment characteristics of this group, the perception of their suicidal tendencies and negative attitudes in general. Qualitative findings revealed some hostility towards the underpinning biosocial model and positive appreciation for the involvement of an expert by experience.
AB  - CONCLUSIONS: Sustained benefits of an educational intervention for people working with people diagnosed with BPD in some but not all areas. Participants provided contrasting messages about what they think will be useful.
AB  - RELEVANCE TO CLINICAL PRACTICE: The study provides further evidence for incorporation of a biosocial model into staff training as well as the benefits of expert by experience co-production. Mental health nurses, however, believe that more well-resourced services are the key to improving care.

 Copyright © 2019 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30830704
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30830704&id=doi:10.1111%2Fjocn.14847&issn=0962-1067&isbn=&volume=28&issue=13-14&spage=2613&pages=2613-2623&date=2019&title=Journal+of+Clinical+Nursing&atitle=Mixed-methods+evaluation+of+an+educational+intervention+to+change+mental+health+nurses%27+attitudes+to+people+diagnosed+with+borderline+personality+disorder.&aulast=Dickens&pid=%3Cauthor%3EDickens+GL%3C%2Fauthor%3E%3CAN%3E30830704%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<31. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30772845
TI  - Does sector matter for the quality of care services? A secondary analysis of social care services regulated by the Care Inspectorate in Scotland.
SO  - BMJ Open. 9(2):e022975, 2019 02 15.
VI  - 1
ST  - MEDLINE
AU  - Bach-Mortensen AM
AU  - Montgomery P
AI  - Bach-Mortensen, Anders Malthe; ORCID: https://orcid.org/0000-0001-7804-7958
FA  - Bach-Mortensen, Anders Malthe
FA  - Montgomery, Paul
IN  - Bach-Mortensen, Anders Malthe. Department of Social Policy and Intervention, University of Oxford, Oxford, UK.
IN  - Montgomery, Paul. Department of Social Policy, Sociology and Criminology, University of Birmingham, Birmingham, UK.
AB  - OBJECTIVES: Social services are increasingly commissioned to third and for-profit sector providers, but little is known about whether and how these changes influence quality indicators. We assessed quality-related outcomes across for-profit, public and third sector organisations delivering social care services.
AB  - DESIGN: A secondary analysis was conducted on publically available data collected by the independent regulator of social care organisations in Scotland. All outcomes are reported as predicted probabilities derived from multivariate logistic regression coefficients. Generalised ordered logit models are utilised for the quality domains and the risk assessment score and logistic regression for whether complaints or requirements were issued to organisations.
AB  - SETTING: Organisations inspected by the Care Inspectorate in Scotland.
AB  - POPULATION: 13 310 social care organisations (eg, nursing homes and day care organisations).
AB  - PRIMARY OUTCOMES: The quality and risk domains collected by the Care Inspectorate and complaints and requirements issued to organisations within the last 3 years.
AB  - RESULTS: Controlling for multiple factors, we find that public and third sector providers performed consistently and statistically significantly better than for-profit organisations on most outcomes. For example, for-profit services were the most likely to be rated as high and medium risk (6.9% and 13.2%, respectively), and the least likely to be classified as low risk (79.9%). Public providers had the highest probability of being categorised as low risk (91.1%), and the lowest probability of having their services classified as medium (6.9%) and high risk (2%), followed by third sector providers (86%, 8.5% and 4.5%, respectively). Public providers performed better than third sector providers in some outcomes, but differences were relatively low and inconsistent.
AB  - CONCLUSION: Public and third sector providers were rated considerably higher than their for-profit counterparts on most observed outcomes. Regulators might use this information to consider how social care providers across sector are incentivised to manage their resources.

 Copyright © Author(s) (or their employer(s)) 2019. Re-use permitted under CC BY-NC. No commercial re-use. See rights and permissions. Published by BMJ.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30772845
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30772845&id=doi:10.1136%2Fbmjopen-2018-022975&issn=2044-6055&isbn=&volume=9&issue=2&spage=e022975&pages=e022975&date=2019&title=BMJ+Open&atitle=Does+sector+matter+for+the+quality+of+care+services%3F+A+secondary+analysis+of+social+care+services+regulated+by+the+Care+Inspectorate+in+Scotland.&aulast=Bach-Mortensen&pid=%3Cauthor%3EBach-Mortensen+AM%3C%2Fauthor%3E%3CAN%3E30772845%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<32. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30678669
TI  - How to conserve dignity in palliative care: suggestions from older patients, significant others, and healthcare professionals in Swedish municipal care.
SO  - BMC Palliative Care. 18(1):10, 2019 Jan 24.
VI  - 1
ST  - MEDLINE
AU  - Ostlund U
AU  - Blomberg K
AU  - Soderman A
AU  - Werkander Harstade C
AI  - Ostlund, Ulrika; ORCID: http://orcid.org/0000-0003-2949-2195
FA  - Ostlund, Ulrika
FA  - Blomberg, Karin
FA  - Soderman, Annika
FA  - Werkander Harstade, Carina
IN  - Ostlund, Ulrika. Centre for Research & Development, Uppsala University/Region Gavleborg, 80188, Gavle, SE, Sweden. ulrika.ostlund@regiongavleborg.se.
IN  - Ostlund, Ulrika. Department of Public Health and Caring Sciences, Uppsala University, Uppsala, Sweden. ulrika.ostlund@regiongavleborg.se.
IN  - Blomberg, Karin. Faculty of Medicine and Health, School of Health Sciences, Orebro University, Orebro, Sweden.
IN  - Soderman, Annika. Faculty of Medicine and Health, School of Health Sciences, Orebro University, Orebro, Sweden.
IN  - Werkander Harstade, Carina. Centre for Collaborative Palliative Care, Department of Health and Caring Sciences, Linnaeus University, Kalmar/Vaxjo, Sweden.
AB  - BACKGROUND: An essential aspect of palliative care nursing is to conserve the dignity of the patient. A Dignity Care Intervention (DCI) has been developed in Scotland to facilitate this role for nurses. The DCI is now being adapted to a Swedish context (DCI-SWE) and a central step is to identify culturally relevant, dignity-conserving care actions. These care actions will be incorporated into the DCI-SWE. Therefore, the aim of this study was to suggest care actions for conserving dignity in palliative care from the perspectives of the patients, significant others (SOs), and health care professionals (HPs) in municipality care in Sweden.
AB  - METHODS: This study used a descriptive design with a qualitative approach. Data from 20 participants were collected through semi-structured individual interviews with patients (n = 3), SOs (n = 4), two focus groups with nurses (n = 9) and one focus group with physicians (n = 4) in two Swedish municipalities. These data were deductively analysed using qualitative content analysis with the Chochinov model of dignity as framework.
AB  - RESULTS: With the Chochinov model of dignity as a framework, care actions based on suggestions from the participants were identified and presented under three themes: Illness related concerns, Dignity conserving repertoire, and Social dignity inventory. The study found both specific concrete care actions and more general approaches. Such general approaches were found to be relevant for several dignity related issues as all-embracing attitudes and behaviours. However, these general approaches could also be relevant as specific care actions to conserve dignity in relation to certain issues. Care actions were also found to be linked to each other, showing the importance of a holistic perspective in conserving dignity.
AB  - CONCLUSIONS: As part of the adaption of the DCI from a Scottish to a Swedish context, this study added relevant care actions for collaborative planning of individualised care in mutual dialogues between nurses and those they care for. The adapted intervention, DCI-SWE, has the potential to help the nurses in providing palliative care of evidence-based quality.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30678669
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30678669&id=doi:10.1186%2Fs12904-019-0393-x&issn=1472-684X&isbn=&volume=18&issue=1&spage=10&pages=10&date=2019&title=BMC+Palliative+Care&atitle=How+to+conserve+dignity+in+palliative+care%3A+suggestions+from+older+patients%2C+significant+others%2C+and+healthcare+professionals+in+Swedish+municipal+care.&aulast=Ostlund&pid=%3Cauthor%3EOstlund+U%3C%2Fauthor%3E%3CAN%3E30678669%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<33. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30549359
TI  - The role of specialist nurses for organ donation: A solution for maximising organ donation rates?.
SO  - Journal of Clinical Nursing. 28(9-10):2020-2027, 2019 May.
VI  - 1
ST  - MEDLINE
AU  - Tocher J
AU  - Neades B
AU  - Smith GD
AU  - Kelly D
AI  - Tocher, Jennifer; ORCID: https://orcid.org/0000-0002-2654-1310
AI  - Neades, Barbara; ORCID: https://orcid.org/0000-0002-8552-1045
AI  - Smith, Graeme D; ORCID: https://orcid.org/0000-0003-2974-3919
AI  - Kelly, Daniel; ORCID: https://orcid.org/0000-0002-1847-0655
FA  - Tocher, Jennifer
FA  - Neades, Barbara
FA  - Smith, Graeme D
FA  - Kelly, Daniel
IN  - Tocher, Jennifer. Nursing Studies, School of Health in Social Science, Old Medical School, University of Edinburgh, Edinburgh, UK.
IN  - Neades, Barbara. Edinburgh Napier University, Edinburgh, UK.
IN  - Smith, Graeme D. Edinburgh Napier University, Edinburgh, UK.
IN  - Kelly, Daniel. Royal College of Nursing Chair of Nursing Research, School of Healthcare Sciences, Cardiff University, Cardiff, UK.
AB  - AIMS AND OBJECTIVES: To explore the role that Donor Transplant Co-ordinators have played and the future potential of Specialist Nurses for Organ Donation (SN-ODs), within organ donation strategies in the UK and other countries.
AB  - BACKGROUND: Organ donation and transplantation rates vary extensively around the world. However, there is a universal shortage of deceased donors, prompting different approaches to increase transplantation rates. Within the UK, the Clinical Lead for Organ Donation and Specialist Nurse in Organ Donation undertake a key role in the implementation of the Organ Donation Strategy. The Human Transplantation (Wales) Act 2015 is a recent development which facilities a deemed (presumed) consent approach to organ donation, the Specialist Nurse in Organ Donation undertakes a major role identifying the potential donor in this situation by confirming the deemed consent status of the donor and supporting bereaved relatives. UK governments in England and Scotland are currently seeking legislative changes to an opt-out system of organ donation, in line with the Wales change.
AB  - DESIGN: This discursive paper explores the role from Donor Transplant Co-ordinator to Specialist Nurse in Organ Donation (SN-OD) within organ donation policy in different settings, but with a specific focus on the UK. The paper clarifies the current and future potential of nurses working with bereaved families when requesting authorisation for donation.
AB  - IMPLICATIONS FOR NURSING: The current scope and future potential of Donor Transplant Co-ordinator and Specialist Nurse in Organ Donation roles need better recognition. Little empirical data exist about the key role that these nurses play in the organ donation process, especially in relation to gaining authorisation to proceed to donation.
AB  - CONCLUSION: There is a need to clarify the role of the Specialist Nurse in Organ Donation and their impact on improving rates of organ donation.

 Copyright © 2018 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30549359
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30549359&id=doi:10.1111%2Fjocn.14741&issn=0962-1067&isbn=&volume=28&issue=9-10&spage=2020&pages=2020-2027&date=2019&title=Journal+of+Clinical+Nursing&atitle=The+role+of+specialist+nurses+for+organ+donation%3A+A+solution+for+maximising+organ+donation+rates%3F.&aulast=Tocher&pid=%3Cauthor%3ETocher+J%3C%2Fauthor%3E%3CAN%3E30549359%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<34. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30522536
TI  - Development and assessment of the content validity of the professional good practices scale in nursing homes.
SO  - International Psychogeriatrics. 31(10):1517-1521, 2019 10.
VI  - 1
ST  - MEDLINE
AU  - Perez-Rojo G
AU  - Noriega C
AU  - Velasco C
AU  - Lopez J
FA  - Perez-Rojo, G
FA  - Noriega, C
FA  - Velasco, C
FA  - Lopez, J
IN  - Perez-Rojo, G. Department of Psychology and Pedagogy, School of Medicine, Universidad San Pablo-CEU, CEU Universities, Madrid, Spain.
IN  - Noriega, C. Department of Psychology and Pedagogy, School of Medicine, Universidad San Pablo-CEU, CEU Universities, Madrid, Spain.
IN  - Velasco, C. Department of Psychology and Pedagogy, School of Medicine, Universidad San Pablo-CEU, CEU Universities, Madrid, Spain.
IN  - Lopez, J. Department of Psychology and Pedagogy, School of Medicine, Universidad San Pablo-CEU, CEU Universities, Madrid, Spain.
AB  - Recent approaches in the care of older people have led to a greater emphasis on good practices to prevent elder abuse. The instruments assessing good practices are very limited, and those focused on elder abuse have rarely considered subtle forms, especially in institutional settings. The aim of this study was to develop and assess the content validity of a good practices scale for professionals working in nursing homes. An extensive literature review of the tools assessing professionals' good-bad practices towards older people was conducted. A preliminary scale based on Kayser-Jones' (1990) [Old, Alone and Neglected: Care of the Aged in Scotland and the United States. Berkeley, CA: University of California Press] types of abuse was developed, including four subscales: Personalization, Humanization, Absence of Infantilization, and Absence of Victimization. Content validity was analyzed through a panel of eight experts. Rovinelli and Hambleton's index of item-objective congruence was used to analyze the items' inclusiveness in the assigned subscale to establish their representativeness. Items' relevance and clarity were analyzed using the paired comparison method. The final version of the scale included 56 items, with appropriate levels of item objective-congruence, relevance, and clarity. This instrument will allow professionals to detect and develop awareness and intervention programs that aim to promote good practices in nursing homes.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30522536
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30522536&id=doi:10.1017%2FS1041610218002077&issn=1041-6102&isbn=&volume=31&issue=10&spage=1517&pages=1517-1521&date=2019&title=International+Psychogeriatrics&atitle=Development+and+assessment+of+the+content+validity+of+the+professional+good+practices+scale+in+nursing+homes.&aulast=Perez-Rojo&pid=%3Cauthor%3EPerez-Rojo+G%3C%2Fauthor%3E%3CAN%3E30522536%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<35. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30390377
TI  - Migrants' Healthcare Experience: A Meta-Ethnography Review of the Literature. [Review]
SO  - Journal of Nursing Scholarship. 51(1):58-67, 2019 01.
VI  - 1
ST  - MEDLINE
AU  - Luiking ML
AU  - Heckemann B
AU  - Ali P
AU  - Dekker-van Doorn C
AU  - Ghosh S
AU  - Kydd A
AU  - Watson R
AU  - Patel H
FA  - Luiking, Marie-Louise
FA  - Heckemann, Birgit
FA  - Ali, Parveen
FA  - Dekker-van Doorn, Connie
FA  - Ghosh, Sumana
FA  - Kydd, Angela
FA  - Watson, Roger
FA  - Patel, Harshida
IN  - Luiking, Marie-Louise. Rho Chi-at-Large, PhD candidate, Sigma European coordinator, Amersfoort, Netherlands.
IN  - Heckemann, Birgit. Tau Omega, Research Associate, Department of Health Professions, Division of Nursing, Bern University of Applied Sciences, Bern, Switzerland.
IN  - Ali, Parveen. Phi Mu, Lecturer, School of Nursing & Midwifery, Sheffield University, Sheffield, United Kingdom.
IN  - Dekker-van Doorn, Connie. Rho Chi-at-Large, Professor, Research Centre Innovations in Care, Rotterdam University of Applied Sciences, Rotterdam, Netherlands.
IN  - Ghosh, Sumana. Tau Omega, Institute of Health Care, & Science, Sahlgrenska Academy, Gothenburg University, Gothenburg, Sweden.
IN  - Kydd, Angela. Upsilon Xi-at-Large, Associate Professor, Edinburgh Napier University, Edinburgh, United Kingdom.
IN  - Watson, Roger. Phi Mu, Professor, Faculty of Health and Social Care, University of Hull, Hull, United Kingdom.
IN  - Patel, Harshida. Tau Omega, Professor, Institute of Health Care & Science, Sahlgrenska Academy, University of Gothenburg, Gothenburg, Sweden.
AB  - PURPOSE: Worldwide, more than 214 million people have left their country of origin. This unprecedented mass migration impacts health care in host countries. This article explores and synthesizes literature on the healthcare experiences of migrants.
AB  - DESIGN: A meta-ethnography study of qualitative studies was conducted.
AB  - METHODS: Eight databases (Medline, the Cumulative Index to Nursing and Allied Health Literature [CINAHL], PsycINFO, Embase, Web of Science, Migration Observatory, National Health Service Scotland Knowledge Network, and Adaptive Spectrum and Signal Alignment [ASSIA]) were searched for relevant full-text articles in English, published between January 2006 and June 2016. Articles were screened against inclusion criteria for eligibility. Included articles were assessed for quality and analyzed using Noblit and Hare's seven-step meta-ethnography process.
AB  - FINDINGS: Twenty-seven studies were included in the review. Five key contextualization dimensions were identified: personal factors, the healthcare system, accessing healthcare, the encounter, and the healthcare experience. These five areas all underlined the uniqueness of each individual migrant, emphasizing the need to treat a person rather than a population. Within a true person-centered approach, the individual's cultural background is fundamental to effective care.
AB  - CONCLUSIONS: From the findings, a model has been designed using the five dimensions and grounded in a person-centered care approach. This may help healthcare providers to identify weak points, as well as to improve the organization and healthcare professionals' ability to provide person-centered care to migrant patients.
AB  - CLINICAL RELEVANCE: The proposed model facilitates identification of points of weakness in the care of migrant patients. Employing a person-centered care approach may contribute to improve health outcomes for migrant patients.

 Copyright © 2018 Sigma Theta Tau International.
PT  - Journal Article
PT  - Review
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=30390377
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30390377&id=doi:10.1111%2Fjnu.12442&issn=1527-6546&isbn=&volume=51&issue=1&spage=58&pages=58-67&date=2019&title=Journal+of+Nursing+Scholarship&atitle=Migrants%27+Healthcare+Experience%3A+A+Meta-Ethnography+Review+of+the+Literature.&aulast=Luiking&pid=%3Cauthor%3ELuiking+ML%3C%2Fauthor%3E%3CAN%3E30390377%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<36. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28933258
TI  - Dignity in nursing care: What does it mean to nursing students?.
SO  - Nursing Ethics. 26(2):390-404, 2019 Mar.
VI  - 1
ST  - MEDLINE
AU  - Mullen RF
AU  - Kydd A
AU  - Fleming A
AU  - McMillan L
FA  - Mullen, Rosemary F
FA  - Kydd, Angela
FA  - Fleming, Anne
FA  - McMillan, Laura
IN  - Mullen, Rosemary F. University of the West of Scotland, Scotland.
IN  - Kydd, Angela. Edinburgh Napier University, Scotland.
IN  - Fleming, Anne. Independent Researcher, Scotland.
IN  - McMillan, Laura. University of the West of Scotland, Scotland.
AB  - BACKGROUND:: Despite growing interest in the potential of nursing education to enhance dignity in nursing care, relatively little is known about what dignity means to nursing students.
AB  - RESEARCH QUESTION:: What meaning does dignity in nursing care have for nursing students?
AB  - RESEARCH DESIGN:: Photo-elicitation was embedded within a Nominal Group Technique and responses were analysed by qualitative and quantitative content analysis.
AB  - PARTICIPANTS AND RESEARCH CONTEXT:: Participants were recruited from each year of a 3-year undergraduate preregistration adult nursing programme in Scotland. In total, 31 nursing students participated in the study.
AB  - ETHICAL CONSIDERATIONS:: The study was approved by the Ethics Committee of the School of Health, Nursing and Midwifery, University of the West of Scotland.
AB  - FINDINGS:: Participants articulated the meaning of dignity in nursing care in terms of the relationships and feelings involved. A total of 10 categories of meaning were identified.
AB  - DISCUSSION:: The significance of the nature of the nurse-patient interaction to preserving dignity in nursing care is highlighted.
AB  - CONCLUSION:: Understanding the meaning of dignity for nursing students may help prepare future nurses more able to preserve dignity in nursing care.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=28933258
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28933258&id=doi:10.1177%2F0969733017720825&issn=0969-7330&isbn=&volume=26&issue=2&spage=390&pages=390-404&date=2019&title=Nursing+Ethics&atitle=Dignity+in+nursing+care%3A+What+does+it+mean+to+nursing+students%3F.&aulast=Mullen&pid=%3Cauthor%3EMullen+RF%3C%2Fauthor%3E%3CAN%3E28933258%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<37. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28452250
TI  - Implementation of a Complex Intervention to Support Leadership Development in Nursing Homes: A Multimethod Participatory Study.
SO  - Journal of Applied Gerontology. 38(7):931-958, 2019 07.
VI  - 1
ST  - MEDLINE
AU  - Dewar B
AU  - Barrie K
AU  - Sharp C
AU  - Meyer J
FA  - Dewar, Belinda
FA  - Barrie, Karen
FA  - Sharp, Cathy
FA  - Meyer, Julienne
IN  - Dewar, Belinda. 1 University of West of Scotland, Hamilton, UK.
IN  - Barrie, Karen. 2 University of Edinburgh, UK.
IN  - Sharp, Cathy. 3 Research for Real, The Melting Pot, Edinburgh, UK.
IN  - Meyer, Julienne. 4 City, University of London, UK.
AB  - Leadership is key to quality improvement in nursing homes. This article reports on the initial analysis of the transformational My Home Life Leadership Support program for nursing home managers being implemented in Scotland. It analyses learning from a multimethod participatory descriptive study. Contribution analysis theory informed the evaluation. Evidence-Based Practice, Relationship-Centered Care, Appreciative Inquiry, and Caring Conversations informed the intervention to develop transformational leadership. Data generation methods included baseline and postintervention questionnaires to describe culture change within the study population, together with more in-depth qualitative data generated from group discussions throughout the leadership support program. Qualitative data analysis was an iterative collaborative process with participants to generate themes about the impact of the program on themselves and their practice. Data showed positive changes in managers' perceptions of their self-awareness, leadership communication and relationship skills, and development of positive cultures. This model offers lessons for those interested in ways to approach the emotional, educational, and cultural dynamics of change in other human service contexts.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med16&AN=28452250
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28452250&id=doi:10.1177%2F0733464817705957&issn=0733-4648&isbn=&volume=38&issue=7&spage=931&pages=931-958&date=2019&title=Journal+of+Applied+Gerontology&atitle=Implementation+of+a+Complex+Intervention+to+Support+Leadership+Development+in+Nursing+Homes%3A+A+Multimethod+Participatory+Study.&aulast=Dewar&pid=%3Cauthor%3EDewar+B%3C%2Fauthor%3E%3CAN%3E28452250%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<38. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29801452
TI  - Task shifting between physicians and nurses in acute care hospitals: cross-sectional study in nine countries.
SO  - Human Resources for Health [Electronic Resource]. 16(1):24, 2018 05 25.
VI  - 1
ST  - MEDLINE
AU  - Maier CB
AU  - Koppen J
AU  - Busse R
AU  - MUNROS team
FA  - Maier, Claudia B
FA  - Koppen, Julia
FA  - Busse, Reinhard
FA  - MUNROS team
IN  - Maier, Claudia B. Department of Healthcare Management, Technische Universitat Berlin, H 80, Strase des 17. Juni 135, 10623, Berlin, Germany. c.maier@tu-berlin.de.
IN  - Maier, Claudia B. Center for Health Outcomes and Policy Research, University of Pennsylvania, School of Nursing, Claire Fagin Hall, 418 Curie Blvd., Philadelphia, PA, 19104, United States of America. c.maier@tu-berlin.de.
IN  - Koppen, Julia. Department of Healthcare Management, Technische Universitat Berlin, H 80, Strase des 17. Juni 135, 10623, Berlin, Germany.
IN  - Busse, Reinhard. Department of Healthcare Management, Technische Universitat Berlin, H 80, Strase des 17. Juni 135, 10623, Berlin, Germany.
AB  - BACKGROUND: Countries vary in the extent to which reforms have been implemented expanding nurses' Scopes-of-Practice (SoP). There is limited cross-country research if and how reforms affect clinical practice, particularly in hospitals. This study analyses health professionals' perceptions of role change and of task shifting between the medical and nursing professions in nine European countries.
AB  - METHODS: Cross-sectional design with surveys completed by 1716 health professionals treating patients with breast cancer (BC) and acute myocardial infarction (AMI) in 161 hospitals across nine countries. Descriptive and bivariate analysis on self-reported staff role changes and levels of independence (with/without physician oversight) by two country groups, with major SoP reforms implemented between 2010 and 2015 (Netherlands, England, Scotland) and without (Czech Republic, Germany, Italy, Norway, Poland, Turkey). Participation in 'medical tasks' was identified using two methods, a data-driven and a conceptual approach. Individual task-related analyses were performed for the medical and nursing professions, and Advanced Practice Nurses/Specialist Nurses (APN/SN).
AB  - RESULTS: Health professionals from the Netherlands, England and Scotland more frequently reported changes to staff roles over this time period vs. the other six countries (BC 74.0% vs. 38.7%, p < .001; AMI 61.7% vs. 37.3%, p < .001), and higher independence in new roles (BC 58.6% vs. 24.0%, p < .001; AMI 48.9% vs. 29.2%, p < .001). A higher proportion of nurses and APN/SN from these three countries reported to undertake tasks related to BC diagnosis, therapy, prescribing of medicines and information to patients compared to the six countries. Similar cross-country differences existed for AMI on prescribing medications and follow-up care. Tasks related to diagnosis and therapy, however, remained largely within the medical profession's domain. Most tasks were reported to be performed by both professions rather than carried out by one profession only.
AB  - CONCLUSIONS: Higher levels of changes to staff roles and task shifting were reported in the Netherlands, England and Scotland, suggesting that professional boundaries have shifted, for instance on chemotherapy or prescribing medicines. For most tasks, however, a partial instead of full task shifting is practice.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29801452
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29801452&id=doi:10.1186%2Fs12960-018-0285-9&issn=1478-4491&isbn=&volume=16&issue=1&spage=24&pages=24&date=2018&title=Human+Resources+for+Health+%5BElectronic+Resource%5D&atitle=Task+shifting+between+physicians+and+nurses+in+acute+care+hospitals%3A+cross-sectional+study+in+nine+countries.&aulast=Maier&pid=%3Cauthor%3EMaier+CB%3C%2Fauthor%3E%3CAN%3E29801452%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<39. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30218946
TI  - A process of developing a national practice assessment document.
SO  - Nurse Education in Practice. 33:17-20, 2018 Nov.
VI  - 1
ST  - MEDLINE
AU  - Roxburgh M
AU  - McCallum J
AU  - McCrossan G
AU  - Smith F
FA  - Roxburgh, Michelle
FA  - McCallum, Jacqueline
FA  - McCrossan, Gill
FA  - Smith, Fiona
IN  - Roxburgh, Michelle. Department of Nursing, University of the Highlands and Islands, Centre for Health Science, Old Perth Road, Inverness, UK. Electronic address: michelle.roxburgh@uhi.ac.uk.
IN  - McCallum, Jacqueline. Glasgow Caledonian University, Room, A511, Govan Mbeki Building, Cowcaddens Road, Glasgow, G4 0BA, UK. Electronic address: Jacqueline.mccallum@gcu.ac.uk.
IN  - McCrossan, Gill. Edinburgh Napier University, Room 4b.43, Sighthill Campus, Sighthill Court, Edinburgh, EH11 4BN, UK. Electronic address: g.mccrossan@napier.ac.uk.
IN  - Smith, Fiona. University of Stirling, Faculty of Health Sciences and Sport, Pathfoot Building, Room E07, Stirling Campus, Stirling, FK9 4LA, UK. Electronic address: fiona.smith@stir.ac.uk.
AB  - This paper will share how one country within the United Kingdom (UK) collaborated on a national partnership approach in developing a consistent pre-registration undergraduate nursing practice learning assessment document. In 2011 the Scottish Heads of Academic Nursing and Allied Health Professionals (SHANAHP, now Council of Deans Scotland, CoDS) agreed to support the development of a Scottish national approach to practice learning assessment document (the "Scottish Ongoing Achievement Record"). Whilst no direct funding was received to support this work, each HEI agreed that this work would be recognised via the release of staff time to enable completion. Utilising a communities of practice approach to collaborative working, the national group incorporated the collective knowledge and experience of representatives from all Higher Education Institutes (HEIs) in Scotland that provided undergraduate pre-registration nurse education. The work of the group will be described in four phases, Mapping of Influential Drivers; Guiding Principles and Good Practice; Document development; and Implementation. Appraisal of the advantages of this approach in light of international literature will be considered alongside challenges encountered during development and implementation.

 Copyright © 2018 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=30218946
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30218946&id=doi:10.1016%2Fj.nepr.2018.08.011&issn=1471-5953&isbn=&volume=33&issue=&spage=17&pages=17-20&date=2018&title=Nurse+Education+in+Practice&atitle=A+process+of+developing+a+national+practice+assessment+document.&aulast=Roxburgh&pid=%3Cauthor%3ERoxburgh+M%3C%2Fauthor%3E%3CAN%3E30218946%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<40. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30153849
TI  - Supporting the health and well-being of school-aged children through a school nurse programme: a realist evaluation.
SO  - BMC Health Services Research. 18(1):664, 2018 Aug 28.
VI  - 1
ST  - MEDLINE
AU  - Doi L
AU  - Wason D
AU  - Malden S
AU  - Jepson R
AI  - Doi, Lawrence; ORCID: http://orcid.org/0000-0001-6853-5050
FA  - Doi, Lawrence
FA  - Wason, Deborah
FA  - Malden, Stephen
FA  - Jepson, Ruth
IN  - Doi, Lawrence. Scottish Collaboration for Public Health Research and Policy, School of Health in Social Science, Doorway 6, Old Medical School, Teviot Place, University of Edinburgh, Edinburgh, EH8 9AG, UK. larry.doi@ed.ac.uk.
IN  - Wason, Deborah. Evaluation Team, NHS Health Scotland, Edinburgh, UK.
IN  - Malden, Stephen. Scottish Collaboration for Public Health Research and Policy, School of Health in Social Science, Doorway 6, Old Medical School, Teviot Place, University of Edinburgh, Edinburgh, EH8 9AG, UK.
IN  - Jepson, Ruth. Scottish Collaboration for Public Health Research and Policy, School of Health in Social Science, Doorway 6, Old Medical School, Teviot Place, University of Edinburgh, Edinburgh, EH8 9AG, UK.
AB  - BACKGROUND: The school nurse's role varies across countries. In Scotland, the Chief Nursing Officer recommended that the role should be refocused. The refocused programme emphasises nine care pathways with a view to improve pupils' health and wellbeing. Two sites were identified to test this new programme. Our aim was to assess how, for whom and under what circumstances the programme works in order to provide learning to support school nurse training and intended national roll-out.
AB  - METHODS: This study was a mixed methods study, using a realist evaluation approach, and conducted in three phases. In phase one, six nurse managers from both study sites took part in individual interviews or focus groups and this was complemented by programme documents to develop initial programme theory. In phase two, the programme theory was tested using qualitative data from 27 school nurses, and quantitative data from the first 6 months of the programme that captured patterns of referral. The programme theory was refined through analyses and interpretation of data in phase three.
AB  - RESULTS: The findings show that the programme enhanced opportunities for early and improved identification of health and wellbeing needs. The context of the nine pathways worked through the mechanism of streamlining referral of relevant cases to school nurses, and yielded positive outcomes by extending school nurses and thus children's engagement with wider services. The mental health and wellbeing pathway was the most frequently used, and nurses referred complex mental health cases to more specialist mental health services, but felt less equipped to deal with low to moderate cases.
AB  - CONCLUSIONS: The programme facilitated early identification of risk but was less successful at equipping school nurses to actually deliver specific interventions as intended. Capacity building strategies for school nurses should seek to enhance intervention delivery skills within the parameters of the pathways. Realist evaluation provided a useful framework in terms of identifying contextual and mechanistic influences that required strengthening prior to wider implementation.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=30153849
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30153849&id=doi:10.1186%2Fs12913-018-3480-4&issn=1472-6963&isbn=&volume=18&issue=1&spage=664&pages=664&date=2018&title=BMC+Health+Services+Research&atitle=Supporting+the+health+and+well-being+of+school-aged+children+through+a+school+nurse+programme%3A+a+realist+evaluation.&aulast=Doi&pid=%3Cauthor%3EDoi+L%3C%2Fauthor%3E%3CAN%3E30153849%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<41. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29956297
TI  - Technology Informatics Guiding Education Reform - TIGER.
SO  - Methods of Information in Medicine. 57(S 01):e30-e42, 2018 06.
VI  - 1
ST  - MEDLINE
AU  - Hubner U
AU  - Shaw T
AU  - Thye J
AU  - Egbert N
AU  - Marin HF
AU  - Chang P
AU  - O'Connor S
AU  - Day K
AU  - Honey M
AU  - Blake R
AU  - Hovenga E
AU  - Skiba D
AU  - Ball MJ
FA  - Hubner, Ursula
FA  - Shaw, Toria
FA  - Thye, Johannes
FA  - Egbert, Nicole
FA  - Marin, Heimar de Fatima
FA  - Chang, Polun
FA  - O'Connor, Siobhan
FA  - Day, Karen
FA  - Honey, Michelle
FA  - Blake, Rachelle
FA  - Hovenga, Evelyn
FA  - Skiba, Diane
FA  - Ball, Marion J
AB  - BACKGROUND: While health informatics recommendations on competencies and education serve as highly desirable corridors for designing curricula and courses, they cannot show how the content should be situated in a specific and local context. Therefore, global and local perspectives need to be reconciled in a common framework.
AB  - OBJECTIVES: The primary aim of this study is therefore to empirically define and validate a framework of globally accepted core competency areas in health informatics and to enrich this framework with exemplar information derived from local educational settings.
AB  - METHODS: To this end, (i) a survey was deployed and yielded insights from 43 nursing experts from 21 countries worldwide to measure the relevance of the core competency areas, (ii) a workshop at the International Nursing Informatics Conference (NI2016) held in June 2016 to provide information about the validation and clustering of these areas and (iii) exemplar case studies were compiled to match these findings with the practice. The survey was designed based on a comprehensive compilation of competencies from the international literature in medical and health informatics.
AB  - RESULTS: The resulting recommendation framework consists of 24 core competency areas in health informatics defined for five major nursing roles. These areas were clustered in the domains "data, information, knowledge", "information exchange and information sharing", "ethical and legal issues", "systems life cycle management", "management" and "biostatistics and medical technology", all of which showed high reliability values. The core competency areas were ranked by relevance and validated by a different group of experts. Exemplar case studies from Brazil, Germany, New Zealand, Taiwan/China, United Kingdom (Scotland) and the United States of America expanded on the competencies described in the core competency areas.
AB  - CONCLUSIONS: This international recommendation framework for competencies in health informatics directed at nurses provides a grid of knowledge for teachers and learner alike that is instantiated with knowledge about informatics competencies, professional roles, priorities and practical, local experience. It also provides a methodology for developing frameworks for other professions/disciplines. Finally, this framework lays the foundation of cross-country learning in health informatics education for nurses and other health professionals.

 Copyright Schattauer GmbH.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29956297
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29956297&id=doi:10.3414%2FME17-01-0155&issn=0026-1270&isbn=&volume=57&issue=01&spage=e30&pages=e30-e42&date=2018&title=Methods+of+Information+in+Medicine&atitle=Technology+Informatics+Guiding+Education+Reform+-+TIGER.&aulast=Hubner&pid=%3Cauthor%3EHubner+U%3C%2Fauthor%3E%3CAN%3E29956297%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<42. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29947482
TI  - Supervision and assessment: the new Nursing and Midwifery Council standards. [Review]
SO  - Nursing Management (Harrow). 25(3):17-21, 2018 07 27.
VI  - 1
ST  - MEDLINE
AU  - Duffy K
AU  - Gillies A
FA  - Duffy, Kathleen
FA  - Gillies, Alan
IN  - Duffy, Kathleen. Programme practice education, NHS Education for Scotland, Glasgow, Scotland.
IN  - Gillies, Alan. NHS Education for Scotland, Glasgow, Scotland.
AB  - In the UK, mentors of pre-registration nurses must achieve the stage 2 outcomes of the Nursing and Midwifery Council (NMC) ( 2008 ) standards to support learning and assessment in practice. Approval for new standards for student supervision and assessment was granted at the NMC meeting in March 2018 ( NMC 2018a ). The introduction of the new standards will see the dissolution of mentorship and the emergence of new roles to support students in academic and practice environments. This article gives an overview of these standards and, drawing on the recommendations from a collaborative event hosted by NHS Education for Scotland and some of the findings from a rapid literature review undertaken for that event, provides nurse managers with information to help inform their discussions as they work in partnership with approved education institution colleagues to realise, support and sustain the roles outlined in the new standards. The article concludes with some questions to consider during these collaborative discussions.

 Copyright ©2018 RCN Publishing Company Ltd. All rights reserved. Not to be copied, transmitted or recorded in any way, in whole or part, without prior permission of the publishers.
PT  - Journal Article
PT  - Review
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29947482
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29947482&id=doi:10.7748%2Fnm.2018.e1765&issn=1354-5760&isbn=&volume=25&issue=3&spage=17&pages=17-21&date=2018&title=Nursing+Management+%28Harrow%29&atitle=Supervision+and+assessment%3A+the+new+Nursing+and+Midwifery+Council+standards.&aulast=Duffy&pid=%3Cauthor%3EDuffy+K%3C%2Fauthor%3E%3CAN%3E29947482%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<43. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29923693
TI  - Compassion in emergency departments. Part 1: nursing students' perspectives.
SO  - Emergency Nurse. 26(2):25-30, 2018 Jul 10.
VI  - 1
ST  - MEDLINE
AU  - Hunter D
AU  - McCallum J
AU  - Howes D
FA  - Hunter, David
FA  - McCallum, Jacqueline
FA  - Howes, Dora
IN  - Hunter, David. Adult health, University of the West of Scotland, Paisley Campus, Renfrewshire, Scotland.
IN  - McCallum, Jacqueline. Glasgow Caledonian University, Glasgow, Scotland.
IN  - Howes, Dora. School of Medicine, Dentistry and Nursing, University of Glasgow, Singapore.
AB  - Compassion is a topical issue in clinical nursing practice, nurse education and policy, but a review of the literature reveals that nursing students' experiences of compassionate care receives little attention. In this three-part series David Hunter and colleagues explore compassion in emergency departments (EDs) from nursing students' point of view. Part 1 provides findings of a professional doctorate study of nursing students' experiences of compassionate care in EDs, part 2 explores the barriers to compassionate care in this clinical setting that emerged from the study, and part 3 considers factors that enable and support compassionate care provision in EDs.
AB  - AIM: The aim of the study was to explore nursing students' experiences of the provision of compassionate care in EDs.
AB  - METHOD: The underpinning methodology was an exploratory-descriptive qualitative design. A total of 15 nursing students from across the west of Scotland, who had been placed in eight different EDs, participated in face-to-face interviews which were audio recorded, transcribed and analysed.
AB  - FINDINGS: Two major themes emerged 'doing the little things' and 'a strange, new world: the uniqueness of the ED'. The students also identified barriers and enablers to providing compassionate care which are discussed in parts two and three.
AB  - CONCLUSION: Despite the challenges of working in the most acute of clinical settings, nurses can provide compassionate care to patients and their relatives. However, this is not universal because certain groups of patients considered 'challenging' do not receive equitable compassionate care.

 Copyright ©2018 RCN Publishing Company Ltd. All rights reserved. Not to be copied, transmitted or recorded in any way, in whole or part, without prior permission of the publishers.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29923693
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29923693&id=doi:10.7748%2Fen.2018.e1774&issn=1354-5752&isbn=&volume=26&issue=2&spage=25&pages=25-30&date=2018&title=Emergency+Nurse&atitle=Compassion+in+emergency+departments.+Part+1%3A+nursing+students%27+perspectives.&aulast=Hunter&pid=%3Cauthor%3EHunter+D%3C%2Fauthor%3E%3CAN%3E29923693%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<44. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29749790
TI  - Healthcare is a human right.
SO  - British Journal of Nursing. 27(9):493-495, 2018 May 10.
VI  - 1
ST  - MEDLINE
AU  - Cummings J
AU  - White J
AU  - McQueen F
AU  - McArdle C
FA  - Cummings, Jane
FA  - White, Jean
FA  - McQueen, Fiona
FA  - McArdle, Charlotte
IN  - Cummings, Jane. Chief Nursing Officer, England.
IN  - White, Jean. Chief Nursing Officer, Wales.
IN  - McQueen, Fiona. Chief Nursing Officer, Scotland.
IN  - McArdle, Charlotte. Chief Nursing Officer, Northern Ireland.
AB  - In celebration of International Nurses Day, Jane Cummings, Jean White, Fiona McQueen and Charlotte McArdle, Chief Nursing Officers (CNOs) for England, Wales, Scotland and Northern Ireland, share their thoughts on this important day in the nursing calendar.
PT  - Historical Article
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29749790
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29749790&id=doi:10.12968%2Fbjon.2018.27.9.493&issn=0966-0461&isbn=&volume=27&issue=9&spage=493&pages=493-495&date=2018&title=British+Journal+of+Nursing&atitle=Healthcare+is+a+human+right.&aulast=Cummings&pid=%3Cauthor%3ECummings+J%3C%2Fauthor%3E%3CAN%3E29749790%3C%2FAN%3E%3CDT%3EHistorical+Article%3C%2FDT%3E

<45. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29567593
TI  - Student health professionals' attitudes and experience after watching "Ida's Diary", a first-person account of living with borderline personality disorder: Mixed methods study.
SO  - Nurse Education Today. 65:128-135, 2018 Jun.
VI  - 1
ST  - MEDLINE
AU  - Dickens GL
AU  - Lamont E
AU  - Stirling FJ
FA  - Dickens, Geoffrey L
FA  - Lamont, Emma
FA  - Stirling, Fiona J
IN  - Dickens, Geoffrey L. Division of Mental Health Nursing and Counselling, Abertay University, Bell Street, Dundee DD1 1HG, United Kingdom. Electronic address: g.dickens@abertay.ac.uk.
IN  - Lamont, Emma. Faculty of Health Sciences and Sport, Room J06 Pathfoot, University of Stirling, Stirling FK9 4LA, United Kingdom. Electronic address: emma.lamont@stir.ac.uk.
IN  - Stirling, Fiona J. Division of Mental Health Nursing and Counselling, Abertay University, Bell Street, Dundee DD1 1HG, United Kingdom. Electronic address: f.stirling@abertay.ac.uk.
AB  - BACKGROUND: There is increasing interest in the use of commercial movies in nursing education, or "cinenurducation". There is a need for educational interventions which target mental health nurses' attitudes towards people with borderline personality disorder.
AB  - OBJECTIVES: To investigate and evaluate the experience and effects of attendance at a screening of the movie Ida's Diary, a first-person account of living with borderline personality disorder.
AB  - DESIGN: Mixed methods design comprising a within-subjects AB longitudinal survey, and a qualitative analysis of participant-generated data and researcher field notes from a World Cafe discussion group.
AB  - SETTINGS: One university in Scotland.
AB  - PARTICIPANTS: N=66 undergraduate and postgraduate mental health nursing and counselling students.
AB  - METHODS: Participants completed measures of cognitive and emotional attitudes towards, and knowledge about, people with borderline personality disorder before and after one of two film screenings. We conducted a World Cafe discussion group after the second screening. Resulting data were subject to a qualitative thematic analysis.
AB  - RESULTS: Quantitative analysis revealed a five-factor cognitive and a single-factor emotional attitude structure. Cognitive-attitudinal items related to treatment deservingness and value of mixed treatment approaches improved across iterations. Total knowledge score did not change, but one item about borderline personality disorder as a precursor to schizophrenia received considerably more incorrect endorsement post-screening. Qualitative analysis revealed five themes: Facilitation and inhibition of learning; promotion but not satiation of appetite for knowledge; challenging existing understanding; prompting creativity and anxiety; and initiating thinking about the bigger picture.
AB  - CONCLUSIONS: Participants found the film thought provoking; it increased their appetite for knowledge. Findings suggest that screening should be delivered in conjunction with more didactic information about borderline personality disorder.

 Copyright © 2018 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29567593
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29567593&id=doi:10.1016%2Fj.nedt.2018.03.003&issn=0260-6917&isbn=&volume=65&issue=&spage=128&pages=128-135&date=2018&title=Nurse+Education+Today&atitle=Student+health+professionals%27+attitudes+and+experience+after+watching+%22Ida%27s+Diary%22%2C+a+first-person+account+of+living+with+borderline+personality+disorder%3A+Mixed+methods+study.&aulast=Dickens&pid=%3Cauthor%3EDickens+GL%3C%2Fauthor%3E%3CAN%3E29567593%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<46. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29493274
TI  - Implementing a sustainable clinical supervision model for Isles nurses in Orkney.
SO  - British Journal of Community Nursing. 23(3):136-139, 2018 Mar 02.
VI  - 1
ST  - MEDLINE
AU  - Hall I
FA  - Hall, Ian
IN  - Hall, Ian. Advanced nurse practitioner, NHS Orkney.
AB  - The Isles Network of Care (INOC) community nurses work at the extreme of the remote and rural continuum, working mostly as lone practitioners. Following the development of sustainable clinical supervision model for Isles nurses in Orkney, clinical supervision was found to improve both peer support and governance for this group of isolated staff. A literature overview identified the transition of clinical supervision in general nursing over 24 years from 'carrot' to 'stick'. The study included a questionnaire survey that was sent to the 2017 Queen's Nursing Institute Scotland cohort to elicit information about the nurses' experience of clinical supervision. The survey found that 55% provide supervision and 40% receive it. Health board encouragement of its use was found to be disappointingly low at 40%. The INOC nurses were surveyed about the new peer-support (restorative) model, which relies on video-conference contact to allow face to face interaction between isolated isles nurses. Feedback prompted a review of clinical supervision pairings, and the frequency and methods of meeting. The need for supervisor training led to agreement with the Remote and Rural Health Education Alliance to provide relevant support. The perceived benefits of supervision included increased support and reflection, and improved relationships with isolated colleagues.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29493274
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29493274&id=doi:10.12968%2Fbjcn.2018.23.3.136&issn=1462-4753&isbn=&volume=23&issue=3&spage=136&pages=136-139&date=2018&title=British+Journal+of+Community+Nursing&atitle=Implementing+a+sustainable+clinical+supervision+model+for+Isles+nurses+in+Orkney.&aulast=Hall&pid=%3Cauthor%3EHall+I%3C%2Fauthor%3E%3CAN%3E29493274%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<47. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29171079
TI  - A survey of staffing levels in paediatric diabetes services throughout the UK.
SO  - Diabetic Medicine. 35(2):242-248, 2018 02.
VI  - 1
ST  - MEDLINE
AU  - Charalampopoulos D
AU  - Amin R
AU  - Warner JT
AU  - Viner RM
AU  - Campbell F
AU  - Edge JA
AU  - Stephenson T
AI  - Charalampopoulos, D; ORCID: https://orcid.org/0000-0002-3763-3130
FA  - Charalampopoulos, D
FA  - Amin, R
FA  - Warner, J T
FA  - Viner, R M
FA  - Campbell, F
FA  - Edge, J A
FA  - Stephenson, T
IN  - Charalampopoulos, D. UCL Great Ormond Street Institute of Child Health, University College London, London.
IN  - Amin, R. UCL Great Ormond Street Institute of Child Health, University College London, London.
IN  - Warner, J T. Department of Paediatric Endocrinology and Diabetes, Children's Hospital for Wales, Cardiff.
IN  - Viner, R M. UCL Great Ormond Street Institute of Child Health, University College London, London.
IN  - Campbell, F. Leeds Children's Hospital, Leeds Teaching Hospitals NHS Trust, Leeds.
IN  - Edge, J A. Department of Paediatric Endocrinology and Diabetes, Oxford Children's Hospital, Oxford, UK.
IN  - Stephenson, T. UCL Great Ormond Street Institute of Child Health, University College London, London.
AB  - AIMS: To assess staffing levels of healthcare professionals involved in the care of children and young people with diabetes in the UK.
AB  - METHODS: A web-based questionnaire was distributed to lead consultant paediatricians from all paediatric diabetes services in the UK between October and December 2014. Data on staffing levels and other aspects of diabetes services were collected and differences between the four nations of the UK and across the 10 English diabetes networks were explored.
AB  - RESULTS: Some 175 services (93%) caring for 29 711 children and young people aged <= 24 years with diabetes participated in the survey. Northern Ireland and Wales had the lowest ratio of total staff to patient population. Nursing caseloads per one whole-time equivalent (WTE) nurse ranged from 71 patients in England to 110 patients in Northern Ireland with only 52% of the UK services meeting the Royal College of Nursing recommended nurse-to-patient ratio of > 1 : 70. Scotland and Northern Ireland had the highest ratio of consultants and fully trained doctors per 1000 patients (3.5 WTE). Overall, 17% of consultants had a Certificate of Completion of Training in Endocrinology and Diabetes. Some 44% of dietitians were able to adjust insulin dose. Only 43% of services provided 24-h access to advice from the diabetes team and 82% of services had access to a psychologist. Staffing levels adjusted for volume were not directly related to glycaemic performance of services in England and Wales.
AB  - CONCLUSIONS: Wide variations in staffing levels existed across the four nations of the UK and important gaps were present in key areas.

 Copyright © 2017 Diabetes UK.
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29171079
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29171079&id=doi:10.1111%2Fdme.13550&issn=0742-3071&isbn=&volume=35&issue=2&spage=242&pages=242-248&date=2018&title=Diabetic+Medicine&atitle=A+survey+of+staffing+levels+in+paediatric+diabetes+services+throughout+the+UK.&aulast=Charalampopoulos&pid=%3Cauthor%3ECharalampopoulos+D%3C%2Fauthor%3E%3CAN%3E29171079%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<48. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29132018
TI  - The provision of accredited higher education on dementia in six European countries: An exploratory study.
SO  - Nurse Education Today. 60:161-169, 2018 Jan.
VI  - 1
ST  - MEDLINE
AU  - Hvalic-Touzery S
AU  - Skela-Savic B
AU  - Macrae R
AU  - Jack-Waugh A
AU  - Tolson D
AU  - Hellstrom A
AU  - de Abreu W
AU  - Pesjak K
FA  - Hvalic-Touzery, Simona
FA  - Skela-Savic, Brigita
FA  - Macrae, Rhoda
FA  - Jack-Waugh, Anna
FA  - Tolson, Debbie
FA  - Hellstrom, Amanda
FA  - de Abreu, Wilson
FA  - Pesjak, Katja
IN  - Hvalic-Touzery, Simona. Faculty of Social Sciences, University of Ljubljana, Kardeljeva ploscad 5, 1000 Ljubljana, Slovenia. Electronic address: simona.hvalic-touzery@fdv.uni-lj.si.
IN  - Skela-Savic, Brigita. Angela Boskin Faculty of Health Care, Spodnji Plavz 3, 4270 Jesenice, Slovenia. Electronic address: bskelasavic@fzab.si.
IN  - Macrae, Rhoda. Alzheimer Scotland Centre for Policy and Practice, School of Health Nursing and Midwifery, University of West of Scotland, Paisley, United Kingdom. Electronic address: Rhoda.Macrae@uws.ac.uk.
IN  - Jack-Waugh, Anna. Alzheimer Scotland Centre for Policy and Practice, University of West of Scotland, Dumfries Campus, Dumfries DG1,2ZN, United Kingdom. Electronic address: anna.jack-waugh@uws.ac.uk.
IN  - Tolson, Debbie. Alzheimer Scotland Centre for Policy and Practice, University of the West of Scotland, Paisley, United Kingdom. Electronic address: debbie.tolson@uws.ac.uk.
IN  - Hellstrom, Amanda. Faculty of Health and Life Sciences, Linnaeus University, Stagneliusgatan 14b, 392 34 Kalmar, Sweden. Electronic address: amanda.hellstrom@lnu.se.
IN  - de Abreu, Wilson. Porto School of Nursing, Rua Dr. Antonio Bernardino de Almeida, 4200-072 Porto, Portugal. Electronic address: wjabreu@esenf.pt.
IN  - Pesjak, Katja. Angela Boskin Faculty of Health Care, Spodnji Plavz 3, 4270 Jesenice, Slovenia. Electronic address: kpesjak@fzab.si.
AB  - BACKGROUND: The World Health Organization has identified developing the knowledge and skills of healthcare professionals who are involved in dementia care as a priority. Most healthcare professionals lack the necessary knowledge, skills and understanding to provide high quality dementia care. While dementia education amongst most UK university health and social care programmes is inconsistent, we know little about the provision of dementia education in European universities.
AB  - OBJECTIVES: To examine the provision of accredited higher education on dementia in European countries, to illustrate that it is highly variable despite universities being the major provider of education for healthcare professionals internationally.
AB  - DESIGN: An exploratory research design was used.
AB  - SETTINGS: The providers of higher education undergraduate and postgraduate programmes in the Czech Republic, Portugal, Scotland, Slovenia, Spain, Sweden.
AB  - PARTICIPANTS: Higher Education Institutions who provide undergraduate and postgraduate education in the fields of nursing, medicine, psychology, social work, physiotherapy, occupational therapy, and gerontology in six European countries.
AB  - METHODS: The data was collected using a structured questionnaire. Researchers in each country conducted an internet-based search using the websites of Higher Education Institutions to identify existing accredited dementia education.
AB  - RESULTS: These searches revealed a lack of dementia education in undergraduate health and social care study programmes. Three of the six countries offered postgraduate study programmes on dementia. There was a significant variation amongst the countries in relation to the provision of dementia education at undergraduate, postgraduate and doctoral levels.
AB  - CONCLUSIONS: Dementia is a global challenge and educating and upskilling the workforce is a policy imperative. To deliver the best dementia care, investment in interprofessional evidence-based education is required if we are to respond effectively and compassionately to the needs of people living with dementia and their families. Higher Education Institutions have an important role to play in equipping health and social care professionals with the knowledge, skills and understanding to respond to this imperative.

 Copyright © 2017 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=29132018
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29132018&id=doi:10.1016%2Fj.nedt.2017.10.010&issn=0260-6917&isbn=&volume=60&issue=&spage=161&pages=161-169&date=2018&title=Nurse+Education+Today&atitle=The+provision+of+accredited+higher+education+on+dementia+in+six+European+countries%3A+An+exploratory+study.&aulast=Hvalic-Touzery&pid=%3Cauthor%3EHvalic-Touzery+S%3C%2Fauthor%3E%3CAN%3E29132018%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<49. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28818126
TI  - To Care and Educate: The Continuity Within Queen's Nursing in Scotland, c. 1948-2000.
SO  - Nursing History Review. 26(1):97-110, 2018 01 01.
VI  - 1
ST  - MEDLINE
AU  - Greenlees J
FA  - Greenlees, Janet
PT  - Historical Article
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=28818126
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28818126&id=doi:10.1891%2F1062-8061.26.97&issn=1062-8061&isbn=&volume=26&issue=1&spage=97&pages=97-110&date=2018&title=Nursing+History+Review&atitle=To+Care+and+Educate%3A+The+Continuity+Within+Queen%27s+Nursing+in+Scotland%2C+c.+1948-2000.&aulast=Greenlees&pid=%3Cauthor%3EGreenlees+J%3C%2Fauthor%3E%3CAN%3E28818126%3C%2FAN%3E%3CDT%3EHistorical+Article%3C%2FDT%3E

<50. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28803080
TI  - Palliative Care Development in Kyrgyzstan.
SO  - Journal of Pain & Symptom Management. 55(2S):S41-S45, 2018 02.
VI  - 1
ST  - MEDLINE
AU  - Mukambetov A
AU  - Sabyrbekova T
AU  - Asanalieva L
AU  - Sadykov I
AU  - Connor SR
FA  - Mukambetov, Aibek
FA  - Sabyrbekova, Taalaigul
FA  - Asanalieva, Lola
FA  - Sadykov, Ilim
FA  - Connor, Stephen R
IN  - Mukambetov, Aibek. Soros Foundation-Kyrgyzstan, Bishkek, Kyrgyzstan.
IN  - Sabyrbekova, Taalaigul. Public Foundation "Ergene", Bishkek, Kyrgyzstan.
IN  - Asanalieva, Lola. Public Union Open Medical Community, Bishkek, Kyrgyzstan.
IN  - Sadykov, Ilim. Soros Foundation-Kyrgyzstan, Bishkek, Kyrgyzstan.
IN  - Connor, Stephen R. Worldwide Hospice Palliative Care Alliance, Fairfax, Virginia, USA. Electronic address: sconnor@thewhpca.org.
AB  - Palliative care began in Kyrgyzstan in 2005 as a pilot home-based care program in Osh Cancer Center and was supported by a small group of nurses and one physician from Scotland. In 2010, the Soros Foundation-Kyrgyzstan and the Open Society Foundation's International Palliative Care Initiative began supporting work on palliative care policy, legislation, essential medicine availability, education, advocacy, and implementation. A Ministry of Health working group was established to lead this initiative, and technical assistance was provided by an international palliative care consultant. Work began with a national needs assessment, which identified the existing barriers to the provision of quality palliative care, and recommendations were made to the working group to address these challenges. Today, palliative care is included in many national health care policies and laws, a national palliative care association has been established, undergraduate medical and nursing education include elements of palliative care, oral morphine and fentanyl patches are now available in parts of the country, inpatient services exist in the National Cancer Center in Osh and Bishkek, two tuberculosis hospitals with multidrug resistant/extensively drug resistant, and home care services in Osh and Bishkek. Public information campaigns and advocacy activities continue to increase public awareness about palliative care and press government action.

 Copyright © 2017 American Academy of Hospice and Palliative Medicine. Published by Elsevier Inc. All rights reserved.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=28803080
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28803080&id=doi:10.1016%2Fj.jpainsymman.2017.05.010&issn=0885-3924&isbn=&volume=55&issue=2&spage=S41&pages=S41-S45&date=2018&title=Journal+of+Pain+%26+Symptom+Management&atitle=Palliative+Care+Development+in+Kyrgyzstan.&aulast=Mukambetov&pid=%3Cauthor%3EMukambetov+A%3C%2Fauthor%3E%3CAN%3E28803080%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<51. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28677921
TI  - Expertise in action: Insights into the dynamic nature of expertise in community-based nursing.
SO  - Journal of Clinical Nursing. 27(3-4):e451-e462, 2018 Feb.
VI  - 1
ST  - MEDLINE
AU  - Dickson CAW
AU  - McVittie C
AU  - Kapilashrami A
AI  - Dickson, Caroline A W; ORCID: http://orcid.org/0000-0001-5132-0109
FA  - Dickson, Caroline A W
FA  - McVittie, Chris
FA  - Kapilashrami, Anuj
IN  - Dickson, Caroline A W. Community Nursing, Queen Margaret University, Musseiburgh, UK.
IN  - McVittie, Chris. Social Psychology, Queen Margaret University, Musseiburgh, UK.
IN  - Kapilashrami, Anuj. Global Health Policy, University of Edinburgh, Edinburgh, UK.
AB  - AIMS AND OBJECTIVES: To gain insight into community nurses' experiences and how they make sense of the expertise they offer in their role.
AB  - BACKGROUND: Globally, the spotlight is currently on community nursing expertise because of the movement of hospital-based to community-based care. Caring for people at home is no longer solely concerned with prevention, but delivering complex care to patients who are acutely unwell or at the end of their life. Little is known about the distinct expertise of community nurses, or their contribution to patient outcomes. There is a need to examine expertise in this group in order to inform current and future care provision within community settings.
AB  - DESIGN: A hermeneutic, phenomenological study.
AB  - METHOD: Semistructured interviews were conducted with eight community nurses in Scotland, UK, who hold an additional postregistration, professional qualification. Participants also kept audio-journals. Data were analysed using interpretive phenomenological analysis.
AB  - FINDINGS: Participants described their expertise in three themes: negotiating a "way in" to care, managing complexity and "thinking on your feet." They did not refer to themselves as specialist practitioners, nor did they perceive that they were viewed as specialist by colleagues or management. They appeared to dismiss their range of expertise which included forming trusting relationships, anticipating care needs and problem-solving, enabling them to undertake complex care management.
AB  - CONCLUSIONS: Expertise of community nurses in this study is dynamic, contextualised and action-oriented enabling them to be creative problem-solvers. It reflects engagement with patients and families and all aspects of the setting where care is provided, rather than being solely an identifiable set of specialist skills.
AB  - RELEVANCE TO CLINICAL PRACTICE: It is vital to recognise community-based expertise internationally, especially if current WHO aims for community-based health care are to be achieved. Highlighting this expertise contributes to current discourse and may be considered in education and practice reviews.

 Copyright © 2017 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med15&AN=28677921
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28677921&id=doi:10.1111%2Fjocn.13950&issn=0962-1067&isbn=&volume=27&issue=3-4&spage=e451&pages=e451-e462&date=2018&title=Journal+of+Clinical+Nursing&atitle=Expertise+in+action%3A+Insights+into+the+dynamic+nature+of+expertise+in+community-based+nursing.&aulast=Dickson&pid=%3Cauthor%3EDickson+CAW%3C%2Fauthor%3E%3CAN%3E28677921%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<52. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29273008
TI  - Implementation of guidelines for multidisciplinary team management of pregnancy in women with pre-existing diabetes or cardiac conditions: results from a UK national survey.
SO  - BMC Pregnancy & Childbirth. 17(1):434, 2017 12 22.
VI  - 1
ST  - MEDLINE
AU  - Taylor C
AU  - McCance DR
AU  - Chappell L
AU  - Nelson-Piercy C
AU  - Thorne SA
AU  - Ismail KMK
AU  - Green JSA
AU  - Bick D
AI  - Taylor, Cath; ORCID: https://orcid.org/0000-0001-6239-4744
FA  - Taylor, Cath
FA  - McCance, David R
FA  - Chappell, Lucy
FA  - Nelson-Piercy, Catherine
FA  - Thorne, Sara A
FA  - Ismail, Khaled M K
FA  - Green, James S A
FA  - Bick, Debra
IN  - Taylor, Cath. University of Surrey, Faculty of Health and Medical Sciences, School of Health Sciences, Guildford, GU2 7XH, UK. Cath.Taylor@surrey.ac.uk.
IN  - McCance, David R. Regional Centre for Endocrinology and Diabetes, Royal Victoria Hospital, Grosvenor Road, Belfast, BT12 6BA, UK.
IN  - Chappell, Lucy. King's College London, Women's Health Academic Centre, Division of Women's Health, London, SE1 7EH, UK.
IN  - Nelson-Piercy, Catherine. King's College London, Women's Health Academic Centre, Division of Women's Health, London, SE1 7EH, UK.
IN  - Thorne, Sara A. Department of Cardiology, Queen Elizabeth Hospital NHS Foundation Trust, Birmingham, B15 2TH, UK.
IN  - Ismail, Khaled M K. The Birmingham Centre of Women's and Children's Health, College of Medical and Dental Sciences, University of Birmingham, Birmingham, B15 2TT, UK.
IN  - Green, James S A. Whipps Cross Hospital, Barts Health NHS Trust, London, UK.
IN  - Green, James S A. Department of Health and Social Care, London South Bank University, London, UK.
IN  - Bick, Debra. King's College London, Florence Nightingale Faculty of Nursing & Midwifery, London, SE1 8WA, UK.
AB  - BACKGROUND: Despite numerous publications stating the importance of multidisciplinary care for women with pre-existing medical conditions, there is a lack of evidence regarding structure or processes of multidisciplinary working, nor impact on maternal or infant outcomes. This study aimed to evaluate the implementation of guidelines for multidisciplinary team (MDT) management in pregnant women with pre-existing diabetes or cardiac conditions. These conditions were selected as exemplars of increasingly common medical conditions in pregnancy for which MDT management is recommended to prevent or reduce adverse maternal and fetal outcomes.
AB  - METHODS: National on-line survey sent to clinicians responsible for management or referral of women with pre-existing diabetes or cardiac conditions in UK National Health Service (NHS) maternity units. The survey comprised questions regarding the organisation of MDT management for women with pre-existing diabetes or cardiac conditions. Content was informed by national guidance.
AB  - RESULTS: One hundred seventy-nine responses were received, covering all health regions in England (162 responses) and 17 responses from Scotland, Wales and Northern Ireland. 132 (74%) related to women with diabetes and 123 (69%) to women with cardiac conditions. MDT referral was reportedly standard practice in most hospitals, particularly for women with pre-existing diabetes (88% of responses vs. 63% for cardiac) but there was wide variation in relation to MDT membership, timing of referral and working practices. These inconsistencies were evident within and between maternity units across the UK. Reported membership was medically dominated and often in the absence of midwifery/nursing and other allied health professionals. Less than half of MDTs for women with diabetes met the recommendations for membership in national guidance, and although two thirds of MDTs for women with cardiac disease met the core recommendations for membership, most did not report having the extended members: midwives, neonatologists or intensivists.
AB  - CONCLUSIONS: The wide diversity of organisational management for women with pre-existing diabetes or cardiac conditions is of concern and merits more detailed inquiry. Evidence is also required to support and better define the recommendations for MDT care.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=29273008
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29273008&id=doi:10.1186%2Fs12884-017-1609-9&issn=1471-2393&isbn=&volume=17&issue=1&spage=434&pages=434&date=2017&title=BMC+Pregnancy+%26+Childbirth&atitle=Implementation+of+guidelines+for+multidisciplinary+team+management+of+pregnancy+in+women+with+pre-existing+diabetes+or+cardiac+conditions%3A+results+from+a+UK+national+survey.&aulast=Taylor&pid=%3Cauthor%3ETaylor+C%3C%2Fauthor%3E%3CAN%3E29273008%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<53. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29186177
TI  - Intensive Care Syndrome: Promoting Independence and Return to Employment (InS:PIRE). Early evaluation of a complex intervention.
SO  - PLoS ONE [Electronic Resource]. 12(11):e0188028, 2017.
VI  - 1
ST  - MEDLINE
AU  - McPeake J
AU  - Shaw M
AU  - Iwashyna TJ
AU  - Daniel M
AU  - Devine H
AU  - Jarvie L
AU  - Kinsella J
AU  - MacTavish P
AU  - Quasim T
AI  - McPeake, Joanne; ORCID: http://orcid.org/0000-0001-8206-6801
FA  - McPeake, Joanne
FA  - Shaw, Martin
FA  - Iwashyna, Theodore J
FA  - Daniel, Malcolm
FA  - Devine, Helen
FA  - Jarvie, Lyndsey
FA  - Kinsella, John
FA  - MacTavish, Pamela
FA  - Quasim, Tara
IN  - McPeake, Joanne. University of Glasgow, School of Medicine, Dentistry and Nursing, Glasgow, Scotland, United Kingdom.
IN  - McPeake, Joanne. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
IN  - Shaw, Martin. University of Glasgow, School of Medicine, Dentistry and Nursing, Glasgow, Scotland, United Kingdom.
IN  - Shaw, Martin. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Clinical Physics Department, Glasgow, Scotland, United Kingdom.
IN  - Iwashyna, Theodore J. Center for Clinical Management Research, VA Ann Arbor Health System, Ann Arbor, Michigan, United States of America.
IN  - Iwashyna, Theodore J. Department of Internal Medicine, Division of Pulmonary and Critical Care, University of Michigan, Ann Arbor, Michigan, United States of America.
IN  - Daniel, Malcolm. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
IN  - Devine, Helen. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
IN  - Jarvie, Lyndsey. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
IN  - Kinsella, John. University of Glasgow, School of Medicine, Dentistry and Nursing, Glasgow, Scotland, United Kingdom.
IN  - Kinsella, John. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
IN  - MacTavish, Pamela. University of Glasgow, School of Medicine, Dentistry and Nursing, Glasgow, Scotland, United Kingdom.
IN  - Quasim, Tara. University of Glasgow, School of Medicine, Dentistry and Nursing, Glasgow, Scotland, United Kingdom.
IN  - Quasim, Tara. NHS Greater Glasgow and Clyde, Glasgow Royal Infirmary, Intensive Care Unit, Glasgow, United Kingdom.
AB  - BACKGROUND: Many patients suffer significant physical, social and psychological problems in the months and years following critical care discharge. At present, there is minimal evidence of any effective interventions to support this patient group following hospital discharge. The aim of this project was to understand the impact of a complex intervention for ICU survivors.
AB  - METHODS: Quality improvement project conducted between September 2014 and June 2016, enrolling 49 selected patients from one ICU in Scotland. To evaluate the impact of this programme outcomes were compared to an existing cohort of patients from the same ICU from 2008-2009. Patients attended a five week peer supported rehabilitation programme. This multidisciplinary programme included pharmacy, physiotherapy, nursing, medical, and psychology input. The primary outcome in this evaluation was the EQ-5D, a validated measure of health-related quality of life. The minimally clinically important difference (MCID) in the EQ-5D is 0.08. We also measured change in self-efficacy over the programme duration. Based on previous research, this study utilised a 2.4 (6%) point change in self-efficacy scores as a MCID.
AB  - RESULTS: 40 patients (82%) completed follow-up surveys at 12 months. After regression adjustment for those factors known to impact recovery from critical care, there was a 0.07-0.16 point improvement in quality of life for those patients who took part in the intervention compared to historical controls from the same institution, depending on specific regression strategy used. Self-efficacy scores increased by 2.5 points (6.25%) over the duration of the five week programme (p = 0.003), and was sustained at one year post intervention. In the year following ICU, 15 InS:PIRE patients returned to employment or volunteering roles (88%) compared with 11 (46%) in the historical control group (p = 0.15).
AB  - CONCLUSIONS AND RELEVANCE: This historical control study suggests that a complex intervention may improve quality of life and self-efficacy in survivors of ICU. A larger, multi-centre study is needed to investigate this intervention further.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=29186177
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29186177&id=doi:10.1371%2Fjournal.pone.0188028&issn=1932-6203&isbn=&volume=12&issue=11&spage=e0188028&pages=e0188028&date=2017&title=PLoS+ONE+%5BElectronic+Resource%5D&atitle=Intensive+Care+Syndrome%3A+Promoting+Independence+and+Return+to+Employment+%28InS%3APIRE%29.+Early+evaluation+of+a+complex+intervention.&aulast=McPeake&pid=%3Cauthor%3EMcPeake+J%3C%2Fauthor%3E%3CAN%3E29186177%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<54. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29052664
TI  - A Qualitative Study Exploring Models of Supportive Care in Men and Their Partners/Caregivers Affected by Metastatic Prostate Cancer.
SO  - Oncology Nursing Forum. 44(6):E241-E249, 2017 11 01.
VI  - 1
ST  - MEDLINE
AU  - Primeau C
AU  - Paterson C
AU  - Nabi G
FA  - Primeau, Charlotte
FA  - Paterson, Catherine
FA  - Nabi, Ghulam
IN  - Primeau, Charlotte. University of Dundee and Ninewells Hospital.
IN  - Paterson, Catherine. University of Dundee and Ninewells Hospital.
IN  - Nabi, Ghulam. University of Dundee and Ninewells Hospital.
AB  - PURPOSE/OBJECTIVES: To explore the experiences of patients with metastatic prostate cancer and their partners/caregivers, as well as an interprofessional team, with a nurse-led multimodality supportive care intervention. .
AB  - RESEARCH APPROACH: Qualitative study. .
AB  - SETTING: National Health Service (NHS), Tayside, Scotland..
AB  - PARTICIPANTS: 19 patients, 7 partners/caregivers, and 7 interprofessional members from four hospitals in NHS, Tayside, Scotland..
AB  - METHODOLOGIC APPROACH: 33 semistructured interviews were conducted to explore patients' and partners/caregivers' experiences of supportive care, and a framework approach was used to analyze the data. .
AB  - FINDINGS: Men and their partners/caregivers experienced a range of unmet physical, psychological, and informational supportive care needs. The participants in the intervention group reported overall high satisfaction with the use of holistic needs assessments and self-management plans, with a decrease in unmet needs compared to the standard of care over time. The prostate cancer specialist nurse was perceived as the hub of survivorship care. Members of the interprofessional team perceived benefit in the nurse-led multimodal supportive care intervention..
AB  - INTERPRETATION: An emphasis needs to be placed on personalizing care, with supportive care interventions targeted to individual needs. .
AB  - IMPLICATIONS FOR NURSING: Care can be improved by incorporating holistic needs assessment to target specialized interventions for optimized, individualized care plans. An intervention seminar encouraged self-management and self-efficiency, leading to greater satisfaction for participants.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=29052664
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29052664&id=doi:10.1188%2F17.ONF.E241-E249&issn=0190-535X&isbn=&volume=44&issue=6&spage=E241&pages=E241-E249&date=2017&title=Oncology+Nursing+Forum&atitle=A+Qualitative+Study+Exploring+Models+of+Supportive+Care+in+Men+and+Their+Partners%2FCaregivers+Affected+by+Metastatic+Prostate+Cancer.&aulast=Primeau&pid=%3Cauthor%3EPrimeau+C%3C%2Fauthor%3E%3CAN%3E29052664%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<55. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28933993
TI  - Gradual physical decline characterises the illness trajectories of care home residents.
SO  - International Journal of Palliative Nursing. 23(9):457-461, 2017 Sep 02.
VI  - 1
ST  - MEDLINE
AU  - Finucane AM
AU  - Stevenson B
AU  - Murray SA
FA  - Finucane, Anne M
FA  - Stevenson, Barbara
FA  - Murray, Scott A
IN  - Finucane, Anne M. Research Lead Marie Curie Hospice Edinburgh.
IN  - Stevenson, Barbara. Community Palliative Care Clinical Nurse Specialist Marie Curie Hospice Edinburgh.
IN  - Murray, Scott A. St Columba's Hospice Chair of Primary Palliative Care, Primary Palliative Care Research Group, Centre for Population Health Sciences, The Usher Institute Of Population Health Sciences And Informatics, The University of Edinburgh.
AB  - BACKGROUND: Three archetypal trajectories of physical decline have been identified: a short period of rapid decline; long-term limitations with intermittent acute periods; and a prolonged gradual decline. An understanding of illness trajectories can help clarify the evolving needs of people with progressive conditions, and inform the development of palliative care services to meet their needs. Many frail older people live and die in care homes; the present study is the first to explore the illness trajectories of residents in care home settings.
AB  - AIMS: To determine the prevailing trajectories of physical decline in care home residents; and to identify the dominant illness trajectories of residents in care homes in Lothian, Scotland.
AB  - METHOD: Data were collected as part of a service development project to improve palliative care in eight care homes in south Edinburgh that provided 24-hour onsite nursing care.
AB  - RESULTS: Data on 120 residents were collected. The dominant illness trajectory, found in 78% of residents, was prolonged gradual decline. The majority of residents (67%) had two or more long-term conditions. Overall, 74% had dementia. Only 11% of residents died in hospital; of these, most died within 1 week of admission.
AB  - CONCLUSION: Interventions to improve palliative care in care homes need to be modelled on the needs of residents who experience prolonged gradual decline characterised by frailty, dementia, multimorbidity and an uncertain prognosis.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28933993
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28933993&id=doi:10.12968%2Fijpn.2017.23.9.457&issn=1357-6321&isbn=&volume=23&issue=9&spage=457&pages=457-461&date=2017&title=International+Journal+of+Palliative+Nursing&atitle=Gradual+physical+decline+characterises+the+illness+trajectories+of+care+home+residents.&aulast=Finucane&pid=%3Cauthor%3EFinucane+AM%3C%2Fauthor%3E%3CAN%3E28933993%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<56. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28862905
TI  - Community nursing middle management: 'dealing with different people in different time zones on both sides'.
SO  - British Journal of Community Nursing. 22(9):448-457, 2017 Sep 02.
VI  - 1
ST  - MEDLINE
AU  - Allan E
FA  - Allan, Elaine
IN  - Allan, Elaine. Lead Nurse (School Nursing), Associate Lecturer, Robert Gordon University, Aberdeen.
AB  - The overall aim of the investigation was to redress a knowledge gap by exploring community nursing middle managers' (CNMMs') experiences of role enactment through change within Community Health Partnerships (CHPs) in Scotland-now further evolved into Health and Social Care Partnerships (HSCPs). HSCPs play a key role in shifting care from the acute to the primary care/community setting. However, a literature review demonstrated there has been very little research into the role of CNMMs within the changing primary care context. This concept was considered important in understanding how CNMMs enacted their roles to implement service change. A qualitative longitudinal interpretative phenomenological analysis (IPA) ( Smith, 1996 ) study was conducted in four distinct phases, comprising the reflexive, foundational, recursive and expansive, from 2008-2011. Some 35 semi-structured interviews were conducted with 26 participants. CNMMs perceived that their responsibilities had increased, become more complex and wider ranging. Maintaining an implicit connection with service users was a primary motivation for CNMMs. They were proud to be members of the nursing profession aligning their identity with their career history. A small but significant proportion resigned during the study and some were considering leaving the NHS. The study addresses a gap in literature, contributes to the understanding of NHS community nursing, middle management, role, change and gives a voice to CNMMs in Scotland. They are the lynchpins in taking change forward and maintaining quality services. Much more attention needs to be paid to the needs, constitution and sustenance of middle managers in Scottish community nursing-which has policy, practice, education, and research and retention implications.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28862905
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28862905&id=doi:10.12968%2Fbjcn.2017.22.9.448&issn=1462-4753&isbn=&volume=22&issue=9&spage=448&pages=448-457&date=2017&title=British+Journal+of+Community+Nursing&atitle=Community+nursing+middle+management%3A+%27dealing+with+different+people+in+different+time+zones+on+both+sides%27.&aulast=Allan&pid=%3Cauthor%3EAllan+E%3C%2Fauthor%3E%3CAN%3E28862905%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<57. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28853669
TI  - Future of nursing in Scotland.
SO  - Nursing Management (Harrow). 24(5):11, 2017 08 30.
VI  - 1
ST  - MEDLINE
AU  - Trueland J
FA  - Trueland, Jennifer
AB  - There is much to like in Scotland's Nursing 2030 Vision, but its success will depend on its implementation. As the name suggests, the document, published in July, sets out a strategy for what nursing in Scotland should look like in 2030. It considers what is done well and what should change, and how to deal with future demands, such as the ageing population and workforce.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28853669
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28853669&id=doi:10.7748%2Fnm.24.5.11.s9&issn=1354-5760&isbn=&volume=24&issue=5&spage=11&pages=11&date=2017&title=Nursing+Management+%28Harrow%29&atitle=Future+of+nursing+in+Scotland.&aulast=Trueland&pid=%3Cauthor%3ETrueland+J%3C%2Fauthor%3E%3CAN%3E28853669%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<58. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28749230
TI  - The History of Children's Nursing and Its Direction Within the United Kingdom.
SO  - Comprehensive Child & Adolescent Nursing. 40(3):200-214, 2017 Sep.
VI  - 1
ST  - MEDLINE
AU  - Clarke S
FA  - Clarke, Sonya
IN  - Clarke, Sonya. a School of Nursing and Midwifery, Queen's University Belfast, Belfast, Co Antrim, Northern Ireland.
AB  - This article presents an account of the "evolution of children's nursing." The pertinent topic was originally developed as part of a Doctorate in Education (EdD) as it was anticipated an understanding of children's nursing would provide a more comprehensive context for a doctoral study that aims to explore the child's experience of staying in Northern Ireland's regional children's hospital from the perspectives of children and children's nurses using child-centered methodology. Northern Ireland, England, Scotland, and Wales are the 4 countries collectively known as the United Kingdom (UK). Hence the concept of "children's/pediatric nursing" was extracted and presented as a catalogue of significant events in their order of occurrence. The article also considers the future direction of children's nursing within the UK. Wider dissemination was thought pivotal to inform all registered nurses, inclusive of those caring for children in all healthcare settings.
PT  - Historical Article
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28749230
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28749230&id=doi:10.1080%2F24694193.2017.1316790&issn=2469-4207&isbn=&volume=40&issue=3&spage=200&pages=200-214&date=2017&title=Comprehensive+Child+%26+Adolescent+Nursing&atitle=The+History+of+Children%27s+Nursing+and+Its+Direction+Within+the+United+Kingdom.&aulast=Clarke&pid=%3Cauthor%3EClarke+S%3C%2Fauthor%3E%3CAN%3E28749230%3C%2FAN%3E%3CDT%3EHistorical+Article%3C%2FDT%3E

<59. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28736934
TI  - Using social media to engage nurses in health policy development.
SO  - Journal of Nursing Management. 25(8):632-639, 2017 Nov.
VI  - 1
ST  - MEDLINE
AU  - O'Connor S
FA  - O'Connor, Siobhan
IN  - O'Connor, Siobhan. School of Health and Social Care, Edinburgh Napier University, Edinburgh, UK.
CM  - Comment in (CIN)
AB  - AIMS: To explore nurses' views on future priorities for the profession and to examine social media as an engagement tool to aid policy discussion and development.
AB  - BACKGROUND: Nurses are often not directly involved in policy creation and some feel it is a process they cannot easily influence.
AB  - METHODS: A descriptive mixed methods study of a Twitter chat hosted by the Chief Nursing Officer for Scotland was undertaken. Data were gathered using an analytics platform and NCapture software. The framework approach aided thematic analysis to draw out themes.
AB  - RESULTS: Sixty-four people took part in the Twitter chat (#CNOScot) and posted 444 tweets. Nurses called for investment in technology, nursing research, education and mental health. Primary care and advanced practice roles to support older adults with complex health and social care needs were also seen as vital to develop further.
AB  - CONCLUSION: Social media can help reach and engage nurses in policy discussion and ensure there is better continuity between policy and practice but some groups risk being excluded using this digital medium.
AB  - IMPLICATIONS FOR NURSING MANAGEMENT: Nursing leaders should consider social media as one of many engagement strategies to ensure nurses and other stakeholders participate in policy debate that informs health strategy development.

 Copyright © 2017 The Authors. Journal of Nursing Management Published by John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28736934
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28736934&id=doi:10.1111%2Fjonm.12501&issn=0966-0429&isbn=&volume=25&issue=8&spage=632&pages=632-639&date=2017&title=Journal+of+Nursing+Management&atitle=Using+social+media+to+engage+nurses+in+health+policy+development.&aulast=O%27Connor&pid=%3Cauthor%3EO%27Connor+S%3C%2Fauthor%3E%3CAN%3E28736934%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<60. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28589813
TI  - We are proud to be a four-country regulator.
SO  - Nursing Standard. 31(41):28, 2017 Jun 07.
VI  - 1
ST  - MEDLINE
AU  - Janet Finch D
FA  - Janet Finch, Dame
AB  - The Nursing and Midwifery Council held its last next meeting in Cardiff. We are proud to be a four-country regulator, and once a year we hold the meeting outside London, giving us a chance to meet with our stakeholders in Wales, Northern Ireland and Scotland.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28589813
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28589813&id=doi:10.7748%2Fns.31.41.28.s27&issn=0029-6570&isbn=&volume=31&issue=41&spage=28&pages=28&date=2017&title=Nursing+Standard&atitle=We+are+proud+to+be+a+four-country+regulator.&aulast=Janet+Finch&pid=%3Cauthor%3EJanet+Finch+D%3C%2Fauthor%3E%3CAN%3E28589813%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<61. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28501731
TI  - Learning and unlearning dignity in care: Experiential and experimental educational approaches.
SO  - Nurse Education in Practice. 25:50-56, 2017 Jul.
VI  - 1
ST  - MEDLINE
AU  - Kyle RG
AU  - Medford W
AU  - Blundell J
AU  - Webster E
AU  - Munoz SA
AU  - Macaden L
FA  - Kyle, Richard G
FA  - Medford, Wayne
FA  - Blundell, Julie
FA  - Webster, Elaine
FA  - Munoz, Sarah-Anne
FA  - Macaden, Leah
IN  - Kyle, Richard G. School of Health and Social Care, Edinburgh Napier University, UK. Electronic address: r.kyle@napier.ac.uk.
IN  - Medford, Wayne. School of Medicine, Pharmacy and Health, Durham University, UK.
IN  - Blundell, Julie. Faculty of Health Sciences and Sport, University of Stirling, UK.
IN  - Webster, Elaine. Centre for the Study of Human Rights Law, University of Strathclyde, UK.
IN  - Munoz, Sarah-Anne. Division of Health Research, University of the Highlands and Islands, UK.
IN  - Macaden, Leah. Faculty of Health Sciences and Sport, University of Stirling, UK.
AB  - Guarding against loss of human dignity is fundamental to nursing practice. It is assumed in the existing literature that 'dignity' as a concept and 'dignity in care' as a practice is amenable to education. Building on this assumption, a range of experiential and experimental educational approaches have been used to enhance students' understanding of dignity. However, little is known about student nurses' views on whether dignity is amenable to education and, if so, which educational approaches would be welcomed. This mixed-methods study used an online questionnaire survey and focus groups to address these questions. Student nurses in Scotland completed online questionnaires (n = 111) and participated in focus groups (n = 35). Students concluded that education has transformative potential to encourage learning around the concept of dignity and practice of dignity in care but also believed that dignity could be unlearned through repeated negative practice exposures. Experiential and experimental educational approaches were welcomed by student nurses, including patient testimony, role-play, simulation, and empathy exercises to step into the lives of others. Nurse educators should further integrate experiential and experimental educational approaches into undergraduate and postgraduate nursing curricula to guard against the loss of learning around dignity students believed occurred over time.

 Copyright © 2017 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28501731
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28501731&id=doi:10.1016%2Fj.nepr.2017.05.001&issn=1471-5953&isbn=&volume=25&issue=&spage=50&pages=50-56&date=2017&title=Nurse+Education+in+Practice&atitle=Learning+and+unlearning+dignity+in+care%3A+Experiential+and+experimental+educational+approaches.&aulast=Kyle&pid=%3Cauthor%3EKyle+RG%3C%2Fauthor%3E%3CAN%3E28501731%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<62. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28493766
TI  - UK Chief Nursing Officers: shaping the future of the profession.
SO  - British Journal of Nursing. 26(9):498-500, 2017 May 11.
VI  - 1
ST  - MEDLINE
AU  - Cummings J
AU  - McArdle C
AU  - McQueen F
AU  - White J
FA  - Cummings, Jane
FA  - McArdle, Charlotte
FA  - McQueen, Fiona
FA  - White, Jean
IN  - Cummings, Jane. Chief Nursing Officer, England.
IN  - McArdle, Charlotte. Chief Nursing Officer, Northern Ireland.
IN  - McQueen, Fiona. Chief Nursing Officer, Scotland.
IN  - White, Jean. Chief Nursing Officer, Wales.
AB  - In celebration of International Nurses Day, Jane Cummings, Charlotte McArdle, Fiona McQueen and Jean White, Chief Nursing Officers (CNOs) for England, Northern Ireland, Scotland and Wales.
PT  - Journal Article
PT  - Portrait
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28493766
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28493766&id=doi:10.12968%2Fbjon.2017.26.9.498&issn=0966-0461&isbn=&volume=26&issue=9&spage=498&pages=498-500&date=2017&title=British+Journal+of+Nursing&atitle=UK+Chief+Nursing+Officers%3A+shaping+the+future+of+the+profession.&aulast=Cummings&pid=%3Cauthor%3ECummings+J%3C%2Fauthor%3E%3CAN%3E28493766%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<63. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28399515
TI  - Healthcare professionals' views of the use and administration of two salvage therapy drugs for acute ulcerative colitis: a nested qualitative study within the CONSTRUCT trial.
SO  - BMJ Open. 7(2):e014512, 2017 02 22.
VI  - 1
ST  - MEDLINE
AU  - Clement C
AU  - Rapport F
AU  - Seagrove A
AU  - Alrubaiy L
AU  - Williams J
FA  - Clement, Clare
FA  - Rapport, Frances
FA  - Seagrove, Anne
FA  - Alrubaiy, Laith
FA  - Williams, John
IN  - Clement, Clare. School of Social and Community Medicine, University of Bristol, Bristol, UK.
IN  - Rapport, Frances. Centre for Healthcare Resilience and Implementation Science, Macquarie University, Sydney, Australia.
IN  - Seagrove, Anne. Swansea University Medical School, Swansea University, Swansea, UK.
IN  - Alrubaiy, Laith. Swansea University Medical School, Swansea University, Swansea, UK.
IN  - Williams, John. Swansea University Medical School, Swansea University, Swansea, UK.
AB  - OBJECTIVES: Insight into healthcare professionals' views and experiences of the use of ciclosporin and infliximab as salvage therapies for acute ulcerative colitis (UC) and how this may affect participation in a comparison trial is lacking. The study aimed to capture views and opinions of healthcare professionals about the two drugs within the CONSTRUCT trial.
AB  - DESIGN: An interview-based qualitative study using Framework Analysis embedded within an open-label, pragmatic randomised trial.
AB  - SETTING: National Health Service Health Boards and Trusts, including large teaching and district hospitals in England, Scotland and Wales.
AB  - PARTICIPANTS: Principal Investigators (PIs) for trial sites (who were all consultant gastroenterologists) and nurses responsible for administering and monitoring the salvage therapy drugs across trial sites. 15 PIs and 8 nurses recruited from a range of sites stratified by site recruitment rates were interviewed.
AB  - RESULTS: Interviews revealed that professionals made judgements regarding the salvage therapies largely based on experience of giving the two drugs and perceptions of effectiveness and adverse side effects. A clear preference for infliximab among nurses was revealed, largely based on experiences of administration and drug handling, with some doctors strongly favouring infliximab based on experience of prescribing the drug as well as patient views and the existing evidence base. Most doctors were more equivocal, and all were prepared to suspend preferences and wait for evidence of effectiveness and safety from the CONSTRUCT trial. PIs also questioned guidelines around drug use and restrictions placed on personal autonomy in delivering best patient care.
AB  - CONCLUSIONS: Findings highlight healthcare professionals' preference for the salvage treatment, infliximab in treating steroid-resistant UC, largely based on resource intensive nursing requirements of intravenous administration of ciclosporin. Not all doctors expressed this preference, being more equivocal, and all professionals were content to suspend preferences within the CONSTRUCT trial and recognised the importance of establishing relative effectiveness and safety.
AB  - TRIAL REGISTRATION NUMBER: ISRCTN 22663589.

 Copyright Published by the BMJ Publishing Group Limited. For permission to use (where not already granted under a licence) please go to http://www.bmj.com/company/products-services/rights-and-licensing/.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28399515
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28399515&id=doi:10.1136%2Fbmjopen-2016-014512&issn=2044-6055&isbn=&volume=7&issue=2&spage=e014512&pages=e014512&date=2017&title=BMJ+Open&atitle=Healthcare+professionals%27+views+of+the+use+and+administration+of+two+salvage+therapy+drugs+for+acute+ulcerative+colitis%3A+a+nested+qualitative+study+within+the+CONSTRUCT+trial.&aulast=Clement&pid=%3Cauthor%3EClement+C%3C%2Fauthor%3E%3CAN%3E28399515%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<64. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28360237
TI  - Developing a national dental education research strategy: priorities, barriers and enablers.
SO  - BMJ Open. 7(3):e013129, 2017 03 29.
VI  - 1
ST  - MEDLINE
AU  - Ajjawi R
AU  - Barton KL
AU  - Dennis AA
AU  - Rees CE
AI  - Ajjawi, Rola; ORCID: https://orcid.org/0000-0003-0651-3870
FA  - Ajjawi, Rola
FA  - Barton, Karen L
FA  - Dennis, Ashley A
FA  - Rees, Charlotte E
IN  - Ajjawi, Rola. Centre for Assessment in Research and Digital Learning, Deakin University, Geelong, Victoria, Australia.
IN  - Barton, Karen L. Division of Food and Drink, School of Science, Engineering & Technology, Abertay University, Dundee, UK.
IN  - Dennis, Ashley A. Centre for Medical Education, University of Dundee, Dundee, UK.
IN  - Rees, Charlotte E. Faculty of Medicine, Nursing & Health Sciences, Monash University, Melbourne, Victoria, Australia.
AB  - OBJECTIVES: This study aimed to identify national dental education research (DER) priorities for the next 3-5 years and to identify barriers and enablers to DER.
AB  - SETTING: Scotland.
AB  - PARTICIPANTS: In this two-stage online questionnaire study, we collected data with multiple dental professions (eg, dentistry, dental nursing and dental hygiene) and stakeholder groups (eg, learners, clinicians, educators, managers, researchers and academics). Eighty-five participants completed the Stage 1 qualitative questionnaire and 649 participants the Stage 2 quantitative questionnaire.
AB  - RESULTS: Eight themes were identified at Stage 1. Of the 24 DER priorities identified, the top three were: role of assessments in identifying competence; undergraduate curriculum prepares for practice and promoting teamwork. Following exploratory factor analysis, the 24 items loaded onto four factors: teamwork and professionalism, measuring and enhancing performance, dental workforce issues and curriculum integration and innovation. Barriers and enablers existed at multiple levels: individual, interpersonal, institutional structures and cultures and technology.
AB  - CONCLUSIONS: This priority setting exercise provides a necessary first step to developing a national DER strategy capturing multiple perspectives. Promoting DER requires improved resourcing alongside efforts to overcome peer stigma and lack of valuing and motivation.

 Copyright Published by the BMJ Publishing Group Limited. For permission to use (where not already granted under a licence) please go to http://www.bmj.com/company/products-services/rights-and-licensing/.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28360237
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28360237&id=doi:10.1136%2Fbmjopen-2016-013129&issn=2044-6055&isbn=&volume=7&issue=3&spage=e013129&pages=e013129&date=2017&title=BMJ+Open&atitle=Developing+a+national+dental+education+research+strategy%3A+priorities%2C+barriers+and+enablers.&aulast=Ajjawi&pid=%3Cauthor%3EAjjawi+R%3C%2Fauthor%3E%3CAN%3E28360237%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<65. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28124407
TI  - A thematic analysis of the experience of UK mental health nurses who have trained in Solution Focused Brief Therapy.
SO  - Journal of Psychiatric & Mental Health Nursing. 24(2-3):105-113, 2017 Mar.
VI  - 1
ST  - MEDLINE
AU  - Smith S
AU  - Macduff C
FA  - Smith, S
FA  - Macduff, C
IN  - Smith, S. School of Nursing and Midwifery, Robert Gordon University, Aberdeen, UK.
IN  - Macduff, C. Robert Gordon University, Aberdeen, UK.
AB  - WHAT IS KNOWN ON THE SUBJECT?: Solution Focused Brief Therapy (SFBT) is an effective model of brief psychotherapy. Evidence suggests that nurses can be trained to deliver SFBT with only a few days training. It has been argued that SFBT reflects the core values of nursing practice, but no empirical research has been undertaken to validate this assertion. WHAT DOES THIS PAPER ADD TO EXISTING KNOWLEDGE?: This is the first time the impact of such training on nurses' sense of professional and personal identity has been explored. Drawing upon data derived from twenty interviews, this paper explores the key themes reported by nurses in relation to their personal experience of training in SFBT. This paper extends our understanding of the lived experience of mental health nurses and facilitates discussion on the preparation and practice of their role. WHAT ARE THE IMPLICATIONS FOR PRACTICE?: Training in SFBT can provide a framework for nurses to empower their clients/patients to take control of their own recovery in a shared and trusting relationship. Training in SFBT can enhance nurses' sense of trust in their clients. Training in solution-focused interactions may provide a framework for many nurses to provide the type of collaborative, patient-led care they aspire to.
AB  - ABSTRACT: Introduction SFBT is a psychotherapeutic model that aims to 'build solutions' rather than 'solve problems'. It has evolved into a structured communication framework utilized across a range of disciplines, focusing on the future, as opposed to the past, and on participant's strengths and abilities, as opposed to their problems and deficits. There have been no studies exploring the experience of training in SFBT from the perspective of the nurses being trained. Aim This study sought to explore the experience of nurses who had completed a six-month training course in SFBT. Methods Using a qualitative methodology, 20 nurses who had undertaken SFBT training were interviewed at various locations across Scotland. Results Five main themes emerged from analysis of the 20 interviews. Many of the participants reported increased trust in their clients and enhanced role satisfaction. Implications for Practice Training in SFBT provides nurses with an alternative model of practice to the dominant 'medical' and 'psychological' models of contemporary practice. The experiences of the participants in this study suggest that SFBT can be a useful intervention in nursing practice and that nurses can easily incorporate SFBT into their practice.

 Copyright © 2017 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28124407
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28124407&id=doi:10.1111%2Fjpm.12365&issn=1351-0126&isbn=&volume=24&issue=2-3&spage=105&pages=105-113&date=2017&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=A+thematic+analysis+of+the+experience+of+UK+mental+health+nurses+who+have+trained+in+Solution+Focused+Brief+Therapy.&aulast=Smith&pid=%3Cauthor%3ESmith+S%3C%2Fauthor%3E%3CAN%3E28124407%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<66. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28088047
TI  - Sliding doors: Did drama-based inter-professional education improve the tensions round person-centred nursing and social care delivery for people with dementia: A mixed method exploratory study.
SO  - Nurse Education Today. 51:1-7, 2017 Apr.
VI  - 1
ST  - MEDLINE
AU  - Dingwall L
AU  - Fenton J
AU  - Kelly TB
AU  - Lee J
FA  - Dingwall, Lindsay
FA  - Fenton, Jane
FA  - Kelly, Timothy B
FA  - Lee, John
IN  - Dingwall, Lindsay. NHS Tayside/School of Nursing & Health Sciences, University of Dundee, Dundee, Scotland, United Kingdom. Electronic address: l.h.dingwall@dundee.ac.uk.
IN  - Fenton, Jane. University of Dundee, Dundee, Scotland, United Kingdom.
IN  - Kelly, Timothy B. University of Dundee, Dundee, Scotland, United Kingdom.
IN  - Lee, John. School of Nursing & Health Sciences, University of Dundee, Dundee, Scotland, United Kingdom.
AB  - This educational intervention takes place when the population of older people with dementia is increasing. Health and Social care professionals must work jointly in increasingly complex contexts. Negative attitudes towards older people are cited as a contributor to poor care delivery, including the use of dismissive and/or patronising language, failing to meet fundamental needs and afford choice. 'Sliding Doors to Personal Futures' is a joint, drama-based, educational initiative between NHS Education Scotland and the Scottish Social Services Council, delivered using interprofessional education (IPE) towards encouraging person-centred health and social care. This paper considers whether 'Sliding Doors' had an impact on social work and nursing students' attitudes to older people, person-centred care and interprofessional collaboration. Two groups of third year students were studied; one from nursing and one from social work. A mixed methods approach was taken and attitudes and attitudinal shifts measured and discussed. Quantitative results demonstrated that social work students made positive attitudinal shifts in some questionnaire items and collectively the social work students were more person-centred than nursing students in their care approaches. The qualitative data however, drawn from focus groups, illuminated these results and highlighted the link between the ability for a professional to be person-centred and the conceptual view of risk within the particular profession. Risk acceptance, the theoretical position of social work, may facilitate person-centred care, whereas the perceived risk-averse nature of the nursing profession may inhibit it. Students' attempts to understand the quantitative results, without understanding the restrictions and parameters of each other's profession, led them to revert to stereotypes and negative views of each other as practitioners. The paper concludes that there is an important difference between nurses' and social workers' frames of reference. It is suggested that IPE in its current form will not impact positively on outcomes for older people, unless both professions can openly acknowledge the reality of their professional contexts and develop an understanding of each other's professional restrictions, opportunities and aspirations.

 Copyright © 2017 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28088047
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28088047&id=doi:10.1016%2Fj.nedt.2016.12.008&issn=0260-6917&isbn=&volume=51&issue=&spage=1&pages=1-7&date=2017&title=Nurse+Education+Today&atitle=Sliding+doors%3A+Did+drama-based+inter-professional+education+improve+the+tensions+round+person-centred+nursing+and+social+care+delivery+for+people+with+dementia%3A+A+mixed+method+exploratory+study.&aulast=Dingwall&pid=%3Cauthor%3EDingwall+L%3C%2Fauthor%3E%3CAN%3E28088047%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<67. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28025842
TI  - A review of safe-staffing models and their applicability to care homes.
SO  - Journal of Nursing Management. 25(2):157-162, 2017 Mar.
VI  - 1
ST  - MEDLINE
AU  - Mitchell G
AU  - Cousins C
AU  - Burrows R
AU  - Cousins G
FA  - Mitchell, Gary
FA  - Cousins, Carol
FA  - Burrows, Ruth
FA  - Cousins, Gary
IN  - Mitchell, Gary. Four Seasons Health Care, Northern Ireland, UK.
IN  - Cousins, Carol. Four Seasons Health Care, Northern Ireland, UK.
IN  - Burrows, Ruth. Four Seasons Health Care, Northern Ireland, UK.
IN  - Cousins, Gary. Four Seasons Health Care, Northern Ireland, UK.
AB  - Presently, there are a range of evidence-based staffing tools that have been used to inform nursing, midwifery and health care capacity. These tools are designed to be used with professional judgement and include frameworks such as Rhys Hearn, the National Services Scotland Care Home Staffing Project, a variety of Royal College of Nursing Tool Kits including the Older People in Hospital's tool and the only National Institute of Clinical Excellence approved safe-staffing tool, Shelford's Safer Nursing Tool. These safe-staffing tools are used to score a patient's or resident's level of dependency across a number of domains, for example a patient/resident's ability to wash, dress, mobilise or fulfil their own elimination needs. While these tools have been beneficial with regards to informing staff levels there are a number of limitations that are important to highlight. Succinctly, most are not readily applicable to care home settings nor do they focus on more person-centred aspects of care.

 Copyright © 2016 John Wiley & Sons Ltd.
PT  - Editorial
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=28025842
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28025842&id=doi:10.1111%2Fjonm.12450&issn=0966-0429&isbn=&volume=25&issue=2&spage=157&pages=157-162&date=2017&title=Journal+of+Nursing+Management&atitle=A+review+of+safe-staffing+models+and+their+applicability+to+care+homes.&aulast=Mitchell&pid=%3Cauthor%3EMitchell+G%3C%2Fauthor%3E%3CAN%3E28025842%3C%2FAN%3E%3CDT%3EEditorial%3C%2FDT%3E

<68. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27991612
TI  - Patient-Reported Self-Efficacy, Anxiety, and Health-Related Quality of Life During Chemotherapy: Results From a Longitudinal Study.
SO  - Oncology Nursing Forum. 44(1):127-136, 2017 01 01.
VI  - 1
ST  - MEDLINE
AU  - Papadopoulou C
AU  - Kotronoulas G
AU  - Schneider A
AU  - Miller MI
AU  - McBride J
AU  - Polly Z
AU  - Bettles S
AU  - Whitehouse A
AU  - McCann L
AU  - Kearney N
AU  - Maguire R
FA  - Papadopoulou, Constantina
FA  - Kotronoulas, Grigorios
FA  - Schneider, Annegret
FA  - Miller, Morven I
FA  - McBride, Jackie
FA  - Polly, Zoe
FA  - Bettles, Simon
FA  - Whitehouse, Alison
FA  - McCann, Lisa
FA  - Kearney, Nora
FA  - Maguire, Roma
IN  - Papadopoulou, Constantina. University of the West of Scotland.
IN  - Kotronoulas, Grigorios. University of Surrey.
IN  - Schneider, Annegret. University of Surrey.
IN  - Miller, Morven I. University of Surrey.
IN  - McBride, Jackie. University of Surrey.
IN  - Polly, Zoe. University of Surrey.
IN  - Bettles, Simon. University of Surrey.
IN  - Whitehouse, Alison. University of Surrey.
IN  - McCann, Lisa. University of Surrey.
IN  - Kearney, Nora. University of Surrey.
IN  - Maguire, Roma. University of Surrey.
AB  - PURPOSE/OBJECTIVES: To explore changes over time in self-efficacy and the predictive ability of changes in state anxiety and health-related quality of life during chemotherapy..
AB  - DESIGN: Secondary analysis of a longitudinal dataset derived from a larger, multicenter study..
AB  - SETTING: Outpatient oncology clinics across eight general hospitals in England, Scotland, and Northern Ireland..
AB  - SAMPLE: 137 patients scheduled to receive adjuvant chemotherapy for breast or colorectal cancer..
AB  - METHODS: At the beginning of each of six chemotherapy cycles, participants completed the Strategies Used by People to Promote Health questionnaire, the State-Trait Anxiety Inventory, and the Functional Assessment of Cancer Therapy-Breast or -Colorectal questionnaire. Multilevel model analysis was used to analyze longitudinal data, adjusted for demographic and clinical variables..
AB  - MAIN RESEARCH VARIABLES: Self-efficacy, anxiety, and health-related quality of life..
AB  - FINDINGS: No significant time effects were found for patients' overall perceived self-efficacy or self-efficacy parameters. A trend toward greater self-efficacy was evident as chemotherapy progressed. Self-efficacy was significantly associated with decreased state anxiety throughout chemotherapy. Increases in overall self-efficacy and perceived ability to maintain a positive attitude were significantly associated with over-time increases in physical, emotional, and functional well-being, as well as with fewer cancer-related concerns..
AB  - CONCLUSIONS: Findings highlight the importance of clinical assessments throughout treatment that focus on patients' perceived self-efficacy as a positive regulator of mood and well-being. .
AB  - IMPLICATIONS FOR NURSING: The current study suggests self-efficacy enhancement should be a key component of psycho-behavioral programs designed to support patients with cancer throughout chemotherapy.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=27991612
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27991612&id=doi:10.1188%2F17.ONF.127-136&issn=0190-535X&isbn=&volume=44&issue=1&spage=127&pages=127-136&date=2017&title=Oncology+Nursing+Forum&atitle=Patient-Reported+Self-Efficacy%2C+Anxiety%2C+and+Health-Related+Quality+of+Life+During+Chemotherapy%3A+Results+From+a+Longitudinal+Study.&aulast=Papadopoulou&pid=%3Cauthor%3EPapadopoulou+C%3C%2Fauthor%3E%3CAN%3E27991612%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<69. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27960119
TI  - Revealing student nurses' perceptions of human dignity through curriculum co-design.
SO  - Social Science & Medicine. 174:1-8, 2017 02.
VI  - 1
ST  - MEDLINE
AU  - Munoz SA
AU  - Macaden L
AU  - Kyle R
AU  - Webster E
FA  - Munoz, Sarah-Anne
FA  - Macaden, Leah
FA  - Kyle, Richard
FA  - Webster, Elaine
IN  - Munoz, Sarah-Anne. Division of Health Research, University of the Highlands and Islands, An Lochran, 10 Inverness Campus, Inverness, IV2 NB, United Kingdom. Electronic address: sarah-anne.munoz@uhi.ac.uk.
IN  - Macaden, Leah. School of Health Sciences, University of Stirling, United Kingdom.
IN  - Kyle, Richard. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, United Kingdom.
IN  - Webster, Elaine. School of Law, University of Strathclyde, United Kingdom.
AB  - Dignity is a slippery concept to define - yet it has been at the heart of media and policy debates around the provision of health and social care in recent years; particularly in the United Kingdom following the Mid-Staffordshire scandal and subsequent Francis Inquiry. This paper considers the concept of dignity in care from the perspective of student nurses. Thus, it allows us to discuss how professional nurses-to-be conceptualise dignity and also how they consider it should/could be taught at undergraduate and postgraduate levels of training, and as part of their Continuing Professional Development. It is only through understanding how student nurses conceptualise and experience human dignity, and the giving and receiving of dignity in care, that it will be possible to support its facilitation in the preparation of practitioners. This paper reports on findings from a series of participatory research workshops held with undergraduate nursing students in Scotland in 2013-14 that were designed to engage the students in the development of educational resources to support the teaching of dignity in care within the nursing curriculum. The outputs from each workshop, along with analysis of transcripts of the workshop discussions, demonstrate the value of co-design as a methodology for involving students in the development of interdisciplinary resources. We observed a desire from students to actively enhance their understandings of dignity - to be able to recognise it; to see dignity in care being practiced; to experience providing such care and to have the appropriate tools to reflect on their own experience. Overall, the research revealed a rich understanding of the ways in which human dignity is conceptualised by nursing students as an embodied practice, associated with memory and personal to an individual. It was understood by the students as shifting, experiential and fragile.

 Copyright © 2016 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=27960119
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27960119&id=doi:10.1016%2Fj.socscimed.2016.12.011&issn=0277-9536&isbn=&volume=174&issue=&spage=1&pages=1-8&date=2017&title=Social+Science+%26+Medicine&atitle=Revealing+student+nurses%27+perceptions+of+human+dignity+through+curriculum+co-design.&aulast=Munoz&pid=%3Cauthor%3EMunoz+SA%3C%2Fauthor%3E%3CAN%3E27960119%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<70. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27914356
TI  - Can podcasts for assessment guidance and feedback promote self-efficacy among undergraduate nursing students? A qualitative study.
SO  - Nurse Education Today. 49:115-121, 2017 Feb.
VI  - 1
ST  - MEDLINE
AU  - McSwiggan LC
AU  - Campbell M
FA  - McSwiggan, Linda C
FA  - Campbell, Maureen
IN  - McSwiggan, Linda C. School of Nursing and Health Sciences, University of Dundee, 11 Airlie Place, DUNDEE DD4 0RG, United Kingdom. Electronic address: l.c.mcswiggan@dundee.ac.uk.
IN  - Campbell, Maureen. School of Nursing and Health Sciences, University of Dundee, 11 Airlie Place, DUNDEE DD4 0RG, United Kingdom. Electronic address: m.z.campbell@dundee.ac.uk.
AB  - BACKGROUND: Improving assessment guidance and feedback for students has become an international priority within higher education. Podcasts have been proposed as a tool for enhancing teaching, learning and assessment. However, a stronger theory-based rationale for using podcasts, particularly as a means of facilitating assessment guidance and feedback, is required.
AB  - OBJECTIVE: To explore students' experiences of using podcasts for assessment guidance and feedback. To consider how these podcasts shaped beliefs about their ability to successfully engage with, and act on, assessment guidance and feedback Design Exploratory qualitative study. Setting Higher education institution in North-East Scotland. Participants Eighteen third year undergraduate nursing students who had utilised podcasts for assessment guidance and feedback within their current programme of study.
AB  - METHODS: Participants took part in one of four focus groups, conducted between July and September 2013. Purposive sampling was utilised to recruit participants of different ages, gender, levels of self-assessed information technology skills and levels of academic achievement. Data analysis was guided by the framework approach.
AB  - FINDINGS: Thematic analysis highlighted similarities and differences in terms of students' experiences of using podcasts for assessment guidance and feedback. Further analysis revealed that Self-Efficacy Theory provided deeper theoretical insights into how the content, structure and delivery of podcasts can be shaped to promote more successful engagement with assessment guidance and feedback from students. The structured, logical approach of assessment guidance podcasts appeared to strengthen self-efficacy by providing readily accessible support and by helping students convert intentions into action. Students with high self-efficacy in relation to tasks associated with assessment were more likely to engage with feedback, whereas those with low self-efficacy tended to overlook opportunities to access feedback due to feelings of helplessness and futility.
AB  - CONCLUSIONS: Adopting well-structured podcasts as an educational tool, based around the four major sources of information (performance accomplishments, vicarious experience, social persuasion, and physiological and emotional states), has potential to promote self efficacy for individuals, as well as groups of students, in terms of assessment guidance and feedback.

 Copyright © 2016 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=27914356
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27914356&id=doi:10.1016%2Fj.nedt.2016.11.021&issn=0260-6917&isbn=&volume=49&issue=&spage=115&pages=115-121&date=2017&title=Nurse+Education+Today&atitle=Can+podcasts+for+assessment+guidance+and+feedback+promote+self-efficacy+among+undergraduate+nursing+students%3F+A+qualitative+study.&aulast=McSwiggan&pid=%3Cauthor%3EMcSwiggan+LC%3C%2Fauthor%3E%3CAN%3E27914356%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<71. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27791264
TI  - Comparison of family nursing in Slovenia and Scotland: integrative review. [Review]
SO  - International Nursing Review. 64(2):276-285, 2017 Jun.
VI  - 1
ST  - MEDLINE
AU  - Ljubic A
AU  - Clark DJ
AU  - Stemberger Kolnik T
FA  - Ljubic, A
FA  - Clark, D J
FA  - Stemberger Kolnik, T
IN  - Ljubic, A. Health Centre Postojna, Postojna, Slovenia.
IN  - Clark, D J. University of Wales Swansea, School of Health Science, Swansea, UK.
IN  - Stemberger Kolnik, T. University of Primorska, Faculty of Health Science, Izola, Slovenia.
AB  - AIM: The aim of this study was to examine and compare the advantages and disadvantages of two systems of community nursing through the history of their development, and to compare these systems with the World Health Organization model of the Family Health Nurse.
AB  - BACKGROUND: In Slovenia, the family/community nursing service is designed according to the World Health Organization policies and is performed by the generalist family/community nurse. In contrast, across Scotland there is no universal model and the current system comprises several different specialist-nursing pathways. The study aimed to describe each model and to understand why the family health nurse model was preferred in Slovenia but rejected in Scotland.
AB  - METHODS: This study was based on integrative review method conducted from August 2013 to September 2015 using national and international specialized databases. While the published literature on this topic is very limited, this review also includes unpublished material. For data analysis, the Walker and Avant's concept analysis model was used.
AB  - RESULTS: Three main themes were identified through the process of the literature search; the Family Health Nurse concept, family/community nursing development in Slovenia, and community nursing development in Scotland. Findings related specifically to the different roles of nurses in the community in Slovenia and Scotland are reported.
AB  - CONCLUSIONS: It is clear that the WHO guidelines and recommendations are not suitable for implementation in all member countries. Both models have advantages and disadvantages. In developing community nursing services, it would be wise to look for systems that represent the best solutions for treatment of the individual, the family and the community.
AB  - IMPLICATIONS FOR NURSING AND HEALTH POLICY: The findings should be used when designing new models applied in different healthcare systems within each country, with a focus on strategy aimed at the welfare of the patient and his family. Findings give a possible solution for financially restricted healthcare systems, regarding the patient's care in the home environment.

 Copyright © 2016 International Council of Nurses.
PT  - Comparative Study
PT  - Journal Article
PT  - Review
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=27791264
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27791264&id=doi:10.1111%2Finr.12324&issn=0020-8132&isbn=&volume=64&issue=2&spage=276&pages=276-285&date=2017&title=International+Nursing+Review&atitle=Comparison+of+family+nursing+in+Slovenia+and+Scotland%3A+integrative+review.&aulast=Ljubic&pid=%3Cauthor%3ELjubic+A%3C%2Fauthor%3E%3CAN%3E27791264%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<72. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27219070
TI  - Are there gender differences in locus of control specific to alcohol dependence?.
SO  - Journal of Clinical Nursing. 26(1-2):258-265, 2017 Jan.
VI  - 1
ST  - MEDLINE
AU  - McPherson A
AU  - Martin CR
FA  - McPherson, Andrew
FA  - Martin, Colin R
IN  - McPherson, Andrew. Substance Use and Misuse Research Group, Institute for Applied Health Research, School of Health & Life Sciences, Glasgow Caledonian University, Glasgow, UK.
IN  - Martin, Colin R. Faculty of Society and Health, Buckinghamshire New University, Uxbridge, UK.
AB  - AIMS AND OBJECTIVES: To investigate gender differences in locus of control in an alcohol-dependent population.
AB  - BACKGROUND: Locus of control helps to explain behaviour in terms of internal (the individual is responsible) or external (outside forces, such as significant other people or chance, are responsible) elements. Past research on gender differences in locus of control in relation to alcohol dependence has shown mixed results. There is a need then to examine gender and locus of control in relation to alcohol dependence to ascertain the veracity of any locus of control differences as a function of gender.
AB  - DESIGN AND METHODS: The Multidimensional Health Locus of Control form-C was administered to clients from alcohol dependence treatment centres in the West of Scotland. Independent t-tests were carried out to assess gender differences in alcohol dependence severity and internal/external aspects of locus of control.
AB  - RESULTS: One hundred and eighty-eight (53% females) participants were recruited from a variety of alcohol dependence treatment centres. The majority of participants (72%) came from Alcoholics Anonymous groups. Women revealed a greater internal locus of control compared with men. Women also had a greater 'significant others' locus of control score than men. Men were more reliant on 'chance' and 'doctors' than women. All these trends were not, however, statistically significant.
AB  - CONCLUSIONS: Gender differences in relation to locus of control and alcohol dependence from past studies are ambiguous. This study also found no clear statistically significant differences in locus of control orientation as a function of gender.
AB  - RELEVANCE TO CLINICAL PRACTICE: This article helps nurses to contextualise health behaviours as a result of internal or external forces. It also helps nursing staff to better understand alcohol dependence treatment in relation to self-efficacy and control. Moreover, it highlights an important concept in health education theory.

 Copyright © 2016 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med14&AN=27219070
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27219070&id=doi:10.1111%2Fjocn.13391&issn=0962-1067&isbn=&volume=26&issue=1-2&spage=258&pages=258-265&date=2017&title=Journal+of+Clinical+Nursing&atitle=Are+there+gender+differences+in+locus+of+control+specific+to+alcohol+dependence%3F.&aulast=McPherson&pid=%3Cauthor%3EMcPherson+A%3C%2Fauthor%3E%3CAN%3E27219070%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<73. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30820338
TI  - A study protocol for a feasibility study: Propofol Target-Controlled Infusion in Emergency Department Sedation (ProTEDS)-a multi-centre feasibility study protocol.
SO  - Pilot & Feasibility Studies. 5:27, 2019.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Burton FM
AU  - Lowe DJ
AU  - Millar J
AU  - Corfield AR
AU  - Sim MAB
AI  - Burton, Fiona M; ORCID: https://orcid.org/0000-0001-7891-2884
AI  - Burton, Fiona M; ISNI: 0000 0001 2193 314X
AI  - Burton, Fiona M; GRID: 0000 0001 2193 314X
AI  - Corfield, Alasdair R; ISNI: 0000 0004 0624 7792
AI  - Corfield, Alasdair R; GRID: 0000 0004 0624 7792
AI  - Sim, Malcolm A B; ISNI: 0000 0001 2193 314X
AI  - Sim, Malcolm A B; GRID: 0000 0001 2193 314X
FA  - Burton, Fiona M
FA  - Lowe, David J
FA  - Millar, Jonathan
FA  - Corfield, Alasdair R
FA  - Sim, Malcolm A B
IN  - Burton, Fiona M. Department of Emergency Medicine, University Hospital Hairmyres, Eaglesham Road, Glasgow, G75 8RG UK.
IN  - Burton, Fiona M. 2Glasgow University Section of Anaesthesia, Pain and Critical Care, Glasgow, Scotland.
IN  - Lowe, David J. Department of Emergency Medicine, Queen Elizabeth University Hospital, Glasgow, Scotland.
IN  - Millar, Jonathan. Department of Anaesthesia and Critical Care, Queen Elizabeth University Hospital, Glasgow, Scotland.
IN  - Corfield, Alasdair R. 5Department of Emergency Medicine, Royal Alexandra Hospital, Paisley, Scotland.
IN  - Sim, Malcolm A B. 2Glasgow University Section of Anaesthesia, Pain and Critical Care, Glasgow, Scotland.
IN  - Sim, Malcolm A B. Department of Anaesthesia and Critical Care, Queen Elizabeth University Hospital, Glasgow, Scotland.
AB  - Background: Procedural sedation is a core skill of the emergency physician. Bolus administration of propofol is widely utilised in UK emergency departments to provide procedural sedation. Bolus administration of propofol, titrated to an endpoint of sedation, has a rapid effect but can easily result in apnoea and loss of airway patency. The use of a target-controlled infusion of propofol allows for controlled titration to an effect site concentration and may reduce the rate of adverse incidents. Target-controlled infusion of propofol is not currently used in emergency departments. The primary aim of this feasibility study is to ensure that propofol target-controlled infusion (TCI) is acceptable to the patient and that recruitment rates are adequate to power a randomised controlled trial comparing propofol target-controlled infusion versus bolus administration.
AB  - Methods: This study will recruit in four emergency departments in Scotland, UK. Patients aged 18-65 years with anterior shoulder dislocation, weighing >= 50 kg and fasted >= 90 min, will be screened. Recruited patients will undergo emergency reduction of a dislocated shoulder facilitated by procedural sedation utilising TCI of propofol. The widespread adoption of TCI propofol by emergency departments will require evidence that it is safe, potentially effective, patient centred and a timely method of providing procedural sedation. The primary endpoint will be acceptability measured by patient satisfaction. The secondary endpoints will include incidence and severity of adverse events, number of shoulder reduction attempts, nursing opinion of patient experience, patient's reported pain score and time from commencement of TCI propofol sedation to desired sedation level. The study will be open for recruitment from April 2017 to December 2018.
AB  - Discussion: If the study demonstrates patient acceptability with adequate recruitment, we will be in a position to determine the feasibility of progression to a randomised controlled clinical trial of TCI compared to bolus administration of propofol.
AB  - Trial registration: ClinicalTrials.gov Identifier: NCT03442803. Registered retrospectively on 22 February 2018.
PT  - Journal Article
YR  - 2019
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=30820338
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30820338&id=doi:10.1186%2Fs40814-019-0412-y&issn=2055-5784&isbn=&volume=5&issue=&spage=27&pages=27&date=2019&title=Pilot+%26+Feasibility+Studies&atitle=A+study+protocol+for+a+feasibility+study%3A+Propofol+Target-Controlled+Infusion+in+Emergency+Department+Sedation+%28ProTEDS%29-a+multi-centre+feasibility+study+protocol.&aulast=Burton&pid=%3Cauthor%3EBurton+FM%3C%2Fauthor%3E%3CAN%3E30820338%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<74. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 30335573
TI  - Media Depictions of "Unacceptable" Workplace Violence Toward Nurses.
SO  - Policy, Politics, & Nursing Practice. 19(3-4):57-71, 2018 Aug-Nov.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Hoyle LP
AU  - Smith E
AU  - Mahoney C
AU  - Kyle RG
AI  - Kyle, Richard G; ORCID: https://orcid.org/0000-0002-6394-109X
FA  - Hoyle, Louise P
FA  - Smith, Emma
FA  - Mahoney, Catherine
FA  - Kyle, Richard G
IN  - Hoyle, Louise P. School of Health & Social Care, Edinburgh Napier University, UK.
IN  - Smith, Emma. School of Health & Social Care, Edinburgh Napier University, UK.
IN  - Mahoney, Catherine. School of Health & Social Care, Edinburgh Napier University, UK.
IN  - Kyle, Richard G. School of Health & Social Care, Edinburgh Napier University, UK.
AB  - Violence and aggression toward nurses are global concerns. Despite repeated research on causal factors and widespread zero tolerance campaigns, rates of violence and aggression have not declined. Violence and aggression toward nurses can negatively affect their health and ultimately patient care. Media reporting of violence and aggression toward nurses might shape people's perceptions of the profession, perhaps impeding nurse recruitment and retention efforts in the face of global nursing shortages. The purpose of this study was to determine how print media in Scotland depicted reports of violence and aggression toward nurses. We used qualitative thematic analysis of newspaper articles and online news reporting of incidents of violence and aggression toward nurses between June 1, 2006 and May 31, 2016. Searches of Nexis and British Broadcasting Corporation (BBC) News Online databases returned 92 relevant newspaper articles. Standards for reporting qualitative research informed presentation of results. Key themes included blame (of perpetrator or senior management), helplessness (of nurses specifically or victimization), culture (social or organizational), and prevention and reduction measures. We concluded that media coverage of violence and aggression was overwhelmingly negative and reductionist. Normalization of violence and aggression was an accepted and acceptable part of the nursing role. We conclude with recommendations for policy and call for nurse leaders to challenge this culture of acceptability, especially to support recruitment and retention of nursing staff.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=30335573
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:30335573&id=doi:10.1177%2F1527154418802488&issn=1527-1544&isbn=&volume=19&issue=3-4&spage=57&pages=57-71&date=2018&title=Policy%2C+Politics%2C+%26+Nursing+Practice&atitle=Media+Depictions+of+%22Unacceptable%22+Workplace+Violence+Toward+Nurses.&aulast=Hoyle&pid=%3Cauthor%3EHoyle+LP%3C%2Fauthor%3E%3CAN%3E30335573%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<75. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29632435
TI  - Perceptions of perioperative nursing competence: a cross-country comparison.
SO  - BMC Nursing. 17:12, 2018.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Gillespie BM
AU  - Harbeck EB
AU  - Falk-Brynhildsen K
AU  - Nilsson U
AU  - Jaensson M
AI  - Gillespie, Brigid M; ORCID: https://orcid.org/0000-0003-3186-5691
AI  - Gillespie, Brigid M; ISNI: 0000 0004 0625 9072
AI  - Gillespie, Brigid M; GRID: 0000 0004 0625 9072
AI  - Gillespie, Brigid M; ISNI: 0000 0004 0437 5432
AI  - Gillespie, Brigid M; GRID: 0000 0004 0437 5432
AI  - Harbeck, Emma B; ISNI: 0000 0004 0437 5432
AI  - Harbeck, Emma B; GRID: 0000 0004 0437 5432
AI  - Falk-Brynhildsen, Karin; ISNI: 0000 0001 0738 8966
AI  - Falk-Brynhildsen, Karin; GRID: 0000 0001 0738 8966
AI  - Nilsson, Ulrica; ISNI: 0000 0001 0738 8966
AI  - Nilsson, Ulrica; GRID: 0000 0001 0738 8966
AI  - Jaensson, Maria; ISNI: 0000 0001 0738 8966
AI  - Jaensson, Maria; GRID: 0000 0001 0738 8966
FA  - Gillespie, Brigid M
FA  - Harbeck, Emma B
FA  - Falk-Brynhildsen, Karin
FA  - Nilsson, Ulrica
FA  - Jaensson, Maria
IN  - Gillespie, Brigid M. 1School of Nursing & Midwifery, Griffith University, Gold Coast, QLD Australia.
IN  - Gillespie, Brigid M. 2Gold Coast Hospital and Health Service, Gold Coast, QLD Australia.
IN  - Gillespie, Brigid M. 3National Centre of Research Excellence in Nursing, Griffith University, Gold Coast, QLD Australia.
IN  - Harbeck, Emma B. 3National Centre of Research Excellence in Nursing, Griffith University, Gold Coast, QLD Australia.
IN  - Harbeck, Emma B. 4Menzies Health Institute Queensland, Griffith University, Gold Coast, QLD Australia.
IN  - Falk-Brynhildsen, Karin. 5Faculty of Medicine and Health, School of Health Sciences, Orebro University, Orebro, Sweden.
IN  - Nilsson, Ulrica. 5Faculty of Medicine and Health, School of Health Sciences, Orebro University, Orebro, Sweden.
IN  - Jaensson, Maria. 5Faculty of Medicine and Health, School of Health Sciences, Orebro University, Orebro, Sweden.
AB  - Background: Throughout many countries, professional bodies rely on yearly self-assessment of competence for ongoing registration; therefore, nursing competence is pivotal to safe clinical practice. Our aim was to describe and compare perioperative nurses' perceptions of competence in four countries, while examining the effect of specialist education and years of experience in the operating room.
AB  - Methods: We conducted a secondary analysis of cross-sectional surveys from four countries including; Australia, Canada, Scotland, and Sweden. The 40-item Perceived Perioperative Competence Scale-Revised (PPCS-R), was used with a total sample of 768 respondents. We used a factorial design to examine the influence of country, years of experience in the operating room and specialist education on nurses' reported perceived perioperative competence.
AB  - Results: Regardless of country origin, nurses with specialist qualifications reported higher perceived perioperative competence when compared to nurses without specialist education. However, cross-country differences were dependent on nurses' number of years of experience in the operating room. Nurses from Sweden with 6-10 years of experience in the operating room reported lower perceived perioperative competence when compared to Australian nurses. In comparing nurses with > 10 years of experience, Swedish nurses reported significantly lower perceived perioperative competence when compared to nurses from Australia, Canada and Scotland.
AB  - Conclusion: Researchers need to consider educational level and years of experience in the perioperative context when examining constructs such as competence.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=29632435
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29632435&id=doi:10.1186%2Fs12912-018-0284-0&issn=1472-6955&isbn=&volume=17&issue=1&spage=12&pages=12&date=2018&title=BMC+Nursing&atitle=Perceptions+of+perioperative+nursing+competence%3A+a+cross-country+comparison.&aulast=Gillespie&pid=%3Cauthor%3EGillespie+BM%3C%2Fauthor%3E%3CAN%3E29632435%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<76. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 29416859
TI  - Applying realistic medicine to intrathecal opioid utilisation in Scotland: do we have a standardised approach?.
SO  - British Journal of Pain. 12(1):5-9, 2018 Feb.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Hart R
AU  - Burns G
AU  - Smith S
FA  - Hart, Robert
FA  - Burns, Gordon
FA  - Smith, Susan
IN  - Hart, Robert. Department of Anaesthesia, Critical Care and Pain, Glasgow Royal Infirmary, Glasgow, UK.
IN  - Burns, Gordon. Department of Anaesthesia, Critical Care and Pain, Glasgow Royal Infirmary, Glasgow, UK.
IN  - Smith, Susan. Department of Anaesthesia, Critical Care and Pain, Glasgow Royal Infirmary, Glasgow, UK.
AB  - Intrathecal opioids (ITOs) are commonly administered as part of a multimodal anaesthetic strategy for a variety of surgical procedures. The evolution of laparoscopic surgical techniques has seen the popularity of ITOs increase as they are effective, well tolerated and lack the cardiovascular side effects associated with epidural infusions. The risk of delayed respiratory depression remains a concern; therefore, high-quality post-operative monitoring is vital. The evidence regarding the practicalities of ITO administration such as opioid dose, type, side effect prevalence and ideal post-operative care arrangements are sparse. As such, a variety of clinical opinion has been generated. In order to quantify this variation within Scotland, we devised a short telephone questionnaire regarding ITO utilisation. We contacted 16 acute surgical sites. Of these, 14 confirmed regular utilisation of ITOs. Our survey demonstrated significant variability in practice. Both diamorphine and morphine are utilised, but no centre could provide a reason to justify the choice of one over the other. The commonly administered dose range for both agents ranged between 100 and 1100 microg. Most centres employed post-operative monitoring geared towards the detection of delayed respiratory depression but this was not unanimous. Each centre had a variation on what observations nursing staff were expected to complete in the post-operative period. Itch and nausea were not encountered frequently. Two centres experienced at least one episode of delayed respiratory depression which was detected and treated with no patient harm. In the report to the Scottish Government, 'Realistic Medicine', by the Chief Medical Officer, the need to reduce unnecessary variation in practice and outcomes is highlighted. We believe that a national sprint audit would gather sufficient prospective data to further determine whether a correlation exists between side effect profile and ITO utilisation practice. We hope this would help form a consensus and guide a standardised approach.
PT  - Journal Article
YR  - 2018
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=29416859
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:29416859&id=doi:10.1177%2F2049463717717124&issn=2049-4637&isbn=&volume=12&issue=1&spage=5&pages=5-9&date=2018&title=British+Journal+of+Pain&atitle=Applying+realistic+medicine+to+intrathecal+opioid+utilisation+in+Scotland%3A+do+we+have+a+standardised+approach%3F.&aulast=Hart&pid=%3Cauthor%3EHart+R%3C%2Fauthor%3E%3CAN%3E29416859%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<77. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28792348
TI  - 'Savings from frozen posts raided for other budgets'.
SO  - Nursing Standard. 31(50):9, 2017 Aug 09.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Mckew M
FA  - Mckew, Matthew
AB  - Money saved by freezing nursing posts is being used to shore up budgets in other areas, RCN Scotland said.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=28792348
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28792348&id=doi:10.7748%2Fns.31.50.9.s7&issn=0029-6570&isbn=&volume=31&issue=50&spage=9&pages=9&date=2017&title=Nursing+Standard&atitle=%27Savings+from+frozen+posts+raided+for+other+budgets%27.&aulast=Mckew&pid=%3Cauthor%3EMckew+M%3C%2Fauthor%3E%3CAN%3E28792348%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<78. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28792329
TI  - A vision for nursing in Scotland.
SO  - Nursing Standard. 31(50):18-20, 2017 Aug 09.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Trueland J
FA  - Trueland, Jennifer
AB  - When Scotland's chief nursing officer Fiona McQueen travelled the country to talk to people about what was important for nursing now and in the future, several messages came through.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=28792329
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28792329&id=doi:10.7748%2Fns.31.50.18.s22&issn=0029-6570&isbn=&volume=31&issue=50&spage=18&pages=18-20&date=2017&title=Nursing+Standard&atitle=A+vision+for+nursing+in+Scotland.&aulast=Trueland&pid=%3Cauthor%3ETrueland+J%3C%2Fauthor%3E%3CAN%3E28792329%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<79. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28677459
TI  - RCN queries Scottish plans to increase staff numbers.
SO  - Nursing Standard. 31(45):11, 2017 Jul 05.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Scottish Government plans to increase nursing numbers raise more questions than answers, RCN Scotland says.
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=28677459
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28677459&id=doi:10.7748%2Fns.31.45.11.s11&issn=0029-6570&isbn=&volume=31&issue=45&spage=11&pages=11&date=2017&title=Nursing+Standard&atitle=RCN+queries+Scottish+plans+to+increase+staff+numbers.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E28677459%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<80. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28610519
TI  - Nurse vacancies climb to all-time high in Scotland.
SO  - Nursing Standard. 31(42):9, 2017 Jun 14.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Mckew M
FA  - Mckew, Matthew
AB  - Nursing and midwifery vacancies in Scotland continue to rise, as does spend on temporary staff, according to data released by the Information Services Division Scotland (ISD).
PT  - Journal Article
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=28610519
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28610519&id=doi:10.7748%2Fns.31.42.9.s6&issn=0029-6570&isbn=&volume=31&issue=42&spage=9&pages=9&date=2017&title=Nursing+Standard&atitle=Nurse+vacancies+climb+to+all-time+high+in+Scotland.&aulast=Mckew&pid=%3Cauthor%3EMckew+M%3C%2Fauthor%3E%3CAN%3E28610519%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<81. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28545890
TI  - Derek Hoy: A legacy for Nursing Informatics in Scotland.
SO  - International Journal of Medical Informatics. 104:126-127, 2017 08.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - O'Connor S
AU  - Hardiker N
FA  - O'Connor, Siobhan
FA  - Hardiker, Nick
IN  - O'Connor, Siobhan. School of Health and Social Care, Edinburgh Napier University, Sighthill Campus, Edinburgh, United Kingdom. Electronic address: S.OConnor@napier.ac.uk.
IN  - Hardiker, Nick. School of Nursing, Midwifery, Social Work and Social Sciences, University of Salford, Manchester, United Kingdom.
PT  - Editorial
YR  - 2017
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm4&AN=28545890
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28545890&id=doi:10.1016%2Fj.ijmedinf.2017.05.010&issn=1386-5056&isbn=&volume=104&issue=&spage=126&pages=126-127&date=2017&title=International+Journal+of+Medical+Informatics&atitle=Derek+Hoy%3A+A+legacy+for+Nursing+Informatics+in+Scotland.&aulast=O%27Connor&pid=%3Cauthor%3EO%27Connor+S%3C%2Fauthor%3E%3CAN%3E28545890%3C%2FAN%3E%3CDT%3EEditorial%3C%2FDT%3E

<82. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 31974264
TI  - Novel quality improvement method to reduce cost while improving the quality of patient care: retrospective observational study.
SO  - BMJ Quality & Safety. 29(7):586-594, 2020 07.
VI  - 1
ST  - In-Process
AU  - Mate KS
AU  - Rakover J
AU  - Cordiner K
AU  - Noble A
AU  - Hassan N
AI  - Rakover, Jeffrey; ORCID: https://orcid.org/0000-0002-2563-1904
FA  - Mate, Kedar S
FA  - Rakover, Jeffrey
FA  - Cordiner, Kay
FA  - Noble, Amy
FA  - Hassan, Noura
IN  - Mate, Kedar S. Research and Development Department, Institute for Healthcare Improvement, Cambridge, Massachusetts, USA.
IN  - Mate, Kedar S. Medicine, Weill Cornell Medical School, New York City, New York, USA.
IN  - Rakover, Jeffrey. Research and Development Department, Institute for Healthcare Improvement, Cambridge, Massachusetts, USA jrakover@ihi.org.
IN  - Cordiner, Kay. Respiratory Unit in Raigmore Hospital, NHS Highland, Inverness, Highlands, UK.
IN  - Noble, Amy. Respiratory Unit, Raigmore Hospital, Inverness, Highlands, UK.
IN  - Hassan, Noura. Obstetrics and Gynecology, Jewish General Hospital, McGill University, Montreal, Quebec, Canada.
AB  - BACKGROUND: Healthcare cost management strategies are limited in number and resource intensive. Budget constraints in the National Health Service Scotland (NHS Scotland) apply pressure on regional health boards to improve efficiency while preserving quality.
AB  - METHODS: We developed a technical method to assist health systems to reduce operating costs, called continuous value management (CVM). Derived from lean accounting and employing quality improvement (QI) methods, the approach allows for management to reduce or repurpose resources to improve efficiency. The primary outcome measure was the cost per patient admitted to the ward in British pounds ().
AB  - INTERVENTIONS: The first step of CVM is developing a standard care model. Teams then track system performance weekly using a tool called the 'box score', and improve performance using QI methods with results displayed on a visual management board. A 29-bed inpatient respiratory ward in a mid-sized hospital in NHS Scotland pilot tested the method.
AB  - RESULTS: We included 5806 patients between October 2016 and May 2018. During the 18-month pilot, the ward realised a 21.8% reduction in cost per patient admitted to the ward (from an initial average level of 807.70 to 631.50 as a new average applying Shewhart control chart rules, p<0.0001), and agency nursing spend decreased by 30.8%. The ward realised a 28.9% increase in the number of patients admitted to the ward per week. Other quality measures (eg, staff satisfaction) were sustained or improved.
AB  - CONCLUSION: CVM methods reduced the cost of care while improving quality. Most of the reduction came by way of reduced bank nursing spend. Work is under way to further test CVM and understand leadership behaviours supporting scale-up.

 Copyright © Author(s) (or their employer(s)) 2020. No commercial re-use. See rights and permissions. Published by BMJ.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2020
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=prem1&AN=31974264
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:31974264&id=doi:10.1136%2Fbmjqs-2019-009825&issn=2044-5415&isbn=&volume=29&issue=7&spage=586&pages=586-594&date=2020&title=BMJ+Quality+%26+Safety&atitle=Novel+quality+improvement+method+to+reduce+cost+while+improving+the+quality+of+patient+care%3A+retrospective+observational+study.&aulast=Mate&pid=%3Cauthor%3EMate+KS%3C%2Fauthor%3E%3CAN%3E31974264%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<83. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27164839
TI  - Implementing a complex rehabilitation intervention in a stroke trial: a qualitative process evaluation of AVERT.
SO  - BMC Medical Research Methodology. 16:52, 2016 05 10.
VI  - 1
ST  - MEDLINE
AU  - Luker JA
AU  - Craig LE
AU  - Bennett L
AU  - Ellery F
AU  - Langhorne P
AU  - Wu O
AU  - Bernhardt J
FA  - Luker, Julie A
FA  - Craig, Louise E
FA  - Bennett, Leanne
FA  - Ellery, Fiona
FA  - Langhorne, Peter
FA  - Wu, Olivia
FA  - Bernhardt, Julie
IN  - Luker, Julie A. Centre for Research Excellence in Stroke Rehabilitation and Brain Recovery, Florey Institute of Neuroscience and Mental Health, University of Melbourne, Melbourne, Australia. Julie.luker@unisa.edu.au.
IN  - Luker, Julie A. International Centre for Allied Health Evidence, University of South Australia, Adelaide, Australia. Julie.luker@unisa.edu.au.
IN  - Craig, Louise E. Nursing Research Institute, Australian Catholic University, Sydney, Australia.
IN  - Bennett, Leanne. International Centre for Allied Health Evidence, University of South Australia, Adelaide, Australia.
IN  - Ellery, Fiona. Centre for Research Excellence in Stroke Rehabilitation and Brain Recovery, Florey Institute of Neuroscience and Mental Health, University of Melbourne, Melbourne, Australia.
IN  - Langhorne, Peter. Institute of Cardiovascular & Medical Sciences, University of Glasgow, Glasgow, Scotland, UK.
IN  - Wu, Olivia. Institute of Health and Wellbeing, University of Glasgow, Glasgow, Scotland, UK.
IN  - Bernhardt, Julie. Centre for Research Excellence in Stroke Rehabilitation and Brain Recovery, Florey Institute of Neuroscience and Mental Health, University of Melbourne, Melbourne, Australia.
IN  - Bernhardt, Julie. Latrobe University, Melbourne, Australia.
AB  - BACKGROUND: The implementation of multidisciplinary stroke rehabilitation interventions is challenging, even when the intervention is evidence-based. Very little is known about the implementation of complex interventions in rehabilitation clinical trials. The aim of study was to better understand how the implementation of a rehabilitation intervention in a clinical trial within acute stroke units is experienced by the staff involved. This qualitative process evaluation was part of a large Phase III stroke rehabilitation trial (AVERT).
AB  - METHODS: A descriptive qualitative approach was used. We purposively sampled 53 allied health and nursing staff from 19 acute stroke units in Australia, New Zealand and Scotland. Semi-structured interviews were conducted by phone, voice-internet, or face to face. Digitally recorded interviews were transcribed and analysed by two researchers using rigorous thematic analysis.
AB  - RESULTS: Our analysis uncovered ten important themes that provide insight into the challenges of implementing complex new rehabilitation practices within complex care settings, plus factors and strategies that assisted implementation. Themes were grouped into three main categories: staff experience of implementing the trial intervention, barriers to implementation, and overcoming the barriers. Participation in the trial was challenging but had personal rewards and improved teamwork at some sites. Over the years that the trial ran some staff perceived a change in usual care. Barriers to trial implementation at some sites included poor teamwork, inadequate staffing, various organisational barriers, staff attitudes and beliefs, and patient-related barriers. Participants described successful implementation strategies that were built on interdisciplinary teamwork, education and strong leadership to 'get staff on board', and developing different ways of working.
AB  - CONCLUSIONS: The AVERT stroke rehabilitation trial required commitment to deliver an intervention that needed strong collaboration between nurses and physiotherapists and was different to current care models. This qualitative process evaluation contributes unique insights into factors that may be critical to successful trials teams, and as AVERT was a pragmatic trial, success factors to delivering complex intervention in clinical practice.
AB  - TRIAL REGISTRATION: AVERT registered with Australian New Zealand Clinical Trials Registry ACTRN12606000185561 .
PT  - Clinical Trial
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27164839
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27164839&id=doi:10.1186%2Fs12874-016-0156-9&issn=1471-2288&isbn=&volume=16&issue=1&spage=52&pages=52&date=2016&title=BMC+Medical+Research+Methodology&atitle=Implementing+a+complex+rehabilitation+intervention+in+a+stroke+trial%3A+a+qualitative+process+evaluation+of+AVERT.&aulast=Luker&pid=%3Cauthor%3ELuker+JA%3C%2Fauthor%3E%3CAN%3E27164839%3C%2FAN%3E%3CDT%3EClinical+Trial%3C%2FDT%3E

<84. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27905245
TI  - NHS Scotland's vision for nursing.
SO  - Nursing Management (Harrow). 23(8):11, 2016 Dec 01.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
AB  - NHS Scotland is nearing the end of a project to develop a 2030 Vision for Nursing, but there is still time for healthcare professionals to contribute. The aims of the project are to: >> Draw up a strategy to maximise the nursing contribution to health and well-being. >> Set out what nursing should look like by 2030. >> Highlight what nurses do well and what needs to change.
PT  - News
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27905245
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27905245&id=doi:10.7748%2Fnm.23.8.11.s11&issn=1354-5760&isbn=&volume=23&issue=8&spage=11&pages=11&date=2016&title=Nursing+Management+%28Harrow%29&atitle=NHS+Scotland%27s+vision+for+nursing.&aulast=williams&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27905245%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<85. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27781329
TI  - The Magic Wand Question and Recovery-Focused Practice in Child and Adolescent Mental Health Services. [Review]
SO  - Journal of Child & Adolescent Psychiatric Nursing. 29(4):164-170, 2016 11.
VI  - 1
ST  - MEDLINE
AU  - Wells K
AU  - McCaig M
FA  - Wells, Karen
FA  - McCaig, Marie
IN  - Wells, Karen. Staff Nurse, National Health Service, Dumfries and Galloway, United Kingdom.
IN  - McCaig, Marie. Mental Health Nursing Lecturer, University of West Scotland, Dumfries, United Kingdom.
AB  - BACKGROUND: This paper uses a case study to describe the implementation of the Magic Wand Question (MWQ), also known as the miracle question, in a child and adolescent mental health service (CAMHS) in Scotland. The MWQ, a common intervention, is based on a Solution-Focused Brief Therapy (SFBT) approach. This intervention was undertaken by a third year student nurse with the intention of demonstrating how practice can be more closely aligned to a recovery-focused, strengths-based approach, which is in line with national policy.
AB  - METHODS: SFBT has a growing evidence base for use with children and young people. However, there are still some common uncertainties about its use; therefore, a literature review has been undertaken to further explore the evidence base for the use of SFBT, with a focus on the MWQ. Furthermore, an exploration of the planning, implementation, and evaluation of the effectiveness of the MWQ is provided with a 15-year-old girl experiencing symptoms of low mood.
AB  - RESULTS: Although limitations have been identified, giving careful consideration to posing the MWQ, through detailed planning prior to implementation, led to an increased understanding of factors supporting the use of the MWQ and reduced any uncertainty around when to use the MWQ in practice. In this clinical intervention, with a 15-year-old girl experiencing symptoms of low mood, the use of the MWQ was successful.
AB  - CONCLUSION: The effectiveness of any treatment is best judged by the individual receiving care, and positive results have been achieved in this case study. Use of this approach ensured professionals were looking beyond diagnosis, illness, and problems in line with the principles of recovery-focused practice (Scottish Recovery Network [SRN] and NHS Education for Scotland [NES], 2007). The use of the MWQ in this case enhanced the knowledge of evidence-based practices, in line with the Nursing and Midwifery Council (NMC, ) and improved overall outcomes for individuals receiving care.

 Copyright © 2016 Wiley Periodicals, Inc.
PT  - Journal Article
PT  - Review
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27781329
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27781329&id=doi:10.1111%2Fjcap.12159&issn=1073-6077&isbn=&volume=29&issue=4&spage=164&pages=164-170&date=2016&title=Journal+of+Child+%26+Adolescent+Psychiatric+Nursing&atitle=The+Magic+Wand+Question+and+Recovery-Focused+Practice+in+Child+and+Adolescent+Mental+Health+Services.&aulast=Wells&pid=%3Cauthor%3EWells+K%3C%2Fauthor%3E%3CAN%3E27781329%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<86. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27745075
TI  - After Brexit: nursing a divided UK.
SO  - Nursing Standard. 31(3):22-25, 2016 Sep 14.
VI  - 1
ST  - MEDLINE
AU  - Trueland J
FA  - Trueland, Jennifer
AB  - Back in September 2014, the people of Scotland voted by 55% to 45% to stay part of the UK. Billed as a once in a generation event, the referendum appeared to put paid to the idea of an independent Scotland for the foreseeable future.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27745075
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27745075&id=doi:10.7748%2Fns.31.3.22.s23&issn=0029-6570&isbn=&volume=31&issue=3&spage=22&pages=22-25&date=2016&title=Nursing+Standard&atitle=After+Brexit%3A+nursing+a+divided+UK.&aulast=Trueland&pid=%3Cauthor%3ETrueland+J%3C%2Fauthor%3E%3CAN%3E27745075%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<87. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27473760
TI  - Staff education, regular sedation and analgesia quality feedback, and a sedation monitoring technology for improving sedation and analgesia quality for critically ill, mechanically ventilated patients: a cluster randomised trial.
SO  - The Lancet Respiratory Medicine. 4(10):807-817, 2016 10.
VI  - 1
ST  - MEDLINE
AU  - Walsh TS
AU  - Kydonaki K
AU  - Antonelli J
AU  - Stephen J
AU  - Lee RJ
AU  - Everingham K
AU  - Hanley J
AU  - Phillips EC
AU  - Uutela K
AU  - Peltola P
AU  - Cole S
AU  - Quasim T
AU  - Ruddy J
AU  - McDougall M
AU  - Davidson A
AU  - Rutherford J
AU  - Richards J
AU  - Weir CJ
AU  - Development and Evaluation of Strategies to Improve Sedation Practice in Intensive Care (DESIST) study investigators
FA  - Walsh, Timothy S
FA  - Kydonaki, Kalliopi
FA  - Antonelli, Jean
FA  - Stephen, Jacqueline
FA  - Lee, Robert J
FA  - Everingham, Kirsty
FA  - Hanley, Janet
FA  - Phillips, Emma C
FA  - Uutela, Kimmo
FA  - Peltola, Petra
FA  - Cole, Stephen
FA  - Quasim, Tara
FA  - Ruddy, James
FA  - McDougall, Marcia
FA  - Davidson, Alan
FA  - Rutherford, John
FA  - Richards, Jonathan
FA  - Weir, Christopher J
FA  - Development and Evaluation of Strategies to Improve Sedation Practice in Intensive Care (DESIST) study investigators
IN  - Walsh, Timothy S. Anaesthetics, Critical Care and Pain Medicine, University of Edinburgh, Edinburgh, Scotland, UK. Electronic address: twalsh@staffmail.ed.ac.uk.
IN  - Kydonaki, Kalliopi. Anaesthetics, Critical Care and Pain Medicine, University of Edinburgh, Edinburgh, Scotland, UK; Edinburgh Napier University, Edinburgh, Scotland, UK.
IN  - Antonelli, Jean. Edinburgh Clinical Trials Unit, University of Edinburgh, Edinburgh, Scotland, UK.
IN  - Stephen, Jacqueline. Edinburgh Clinical Trials Unit, University of Edinburgh, Edinburgh, Scotland, UK.
IN  - Lee, Robert J. Centre for Population Health Sciences, University of Edinburgh, Edinburgh, Scotland, UK.
IN  - Everingham, Kirsty. Anaesthetics, Critical Care and Pain Medicine, University of Edinburgh, Edinburgh, Scotland, UK.
IN  - Hanley, Janet. Edinburgh Napier University, Edinburgh, Scotland, UK; Edinburgh Health Services Research Unit, Edinburgh, Scotland, UK.
IN  - Phillips, Emma C. Anaesthetics, Critical Care and Pain Medicine, University of Edinburgh, Edinburgh, Scotland, UK.
IN  - Uutela, Kimmo. GE Healthcare Finland Oy, Kuortaneenkatu 2, 00510 Helsinki, Finland.
IN  - Peltola, Petra. GE Healthcare Finland Oy, Kuortaneenkatu 2, 00510 Helsinki, Finland.
IN  - Cole, Stephen. Department of Anaesthetics, Ninewells Hospital, NHS Tayside, Scotland, UK.
IN  - Quasim, Tara. University Department of Anaesthetics, Glasgow University, Glasgow Royal Infirmary, Glasgow, Scotland, UK.
IN  - Ruddy, James. Department of Anaesthetics, Monklands Hospital, NHS Lanarkshire, Scotland, UK.
IN  - McDougall, Marcia. Department of Anaesthetics, Victoria Hospital, Kirkcaldy, NHS Fife, Scotland, UK.
IN  - Davidson, Alan. Department of Anaesthetics, Victoria Infirmary, NHS GGC, Glasgow, Scotland, UK.
IN  - Rutherford, John. Department of Anaesthetics, Dumfries and Galloway Royal Infirmary, NHS Dumfries and Galloway, Scotland, UK.
IN  - Richards, Jonathan. Department of Anaesthetics, Forth Valley Royal Hospital, NHS Forth Valley, Scotland, UK.
IN  - Weir, Christopher J. Centre for Population Health Sciences, University of Edinburgh, Edinburgh, Scotland, UK; Edinburgh Health Services Research Unit, Edinburgh, Scotland, UK.
CM  - Comment in (CIN)
CM  - Comment in (CIN)
AB  - BACKGROUND: Optimal sedation of patients in intensive care units (ICUs) requires the avoidance of pain, agitation, and unnecessary deep sedation, but these outcomes are challenging to achieve. Excessive sedation can prolong ICU stay, whereas light sedation can increase pain and frightening memories, which are commonly recalled by ICU survivors. We aimed to assess the effectiveness of three interventions to improve sedation and analgesia quality: an online education programme; regular feedback of sedation-analgesia quality data; and use of a novel sedation-monitoring technology (the Responsiveness Index [RI]).
AB  - METHODS: We did a cluster randomised trial in eight ICUs, which were randomly allocated to receive education alone (two ICUs), education plus sedation-analgesia quality feedback (two ICUs), education plus RI monitoring technology (two ICUs), or all three interventions (two ICUs). Randomisation was done with computer-generated random permuted blocks, stratified according to recruitment start date. A 45 week baseline period was followed by a 45 week intervention period, separated by an 8 week implementation period in which the interventions were introduced. ICU and research staff were not masked to study group assignment during the intervention period. All mechanically ventilated patients were potentially eligible. We assessed patients' sedation-analgesia quality for each 12 h period of nursing care, and sedation-related adverse events daily. Our primary outcome was the proportion of care periods with optimal sedation-analgesia, defined as being free from excessive sedation, agitation, poor limb relaxation, and poor ventilator synchronisation. Analysis used multilevel generalised linear mixed modelling to explore intervention effects in a single model taking clustering and patient-level factors into account. A concurrent mixed-methods process evaluation was undertaken to help understand the trial findings. The trial is registered with ClinicalTrials.gov, number NCT01634451.
AB  - FINDINGS: Between June 1, 2012, and Dec 31, 2014, we included 881 patients (9187 care periods) during the baseline period and 591 patients (6947 care periods) during the intervention period. During the baseline period, optimal sedation-analgesia was present for 5150 (56%) care periods. We found a significant improvement in optimal sedation-analgesia with RI monitoring (odds ratio [OR] 1.44 [95% CI 1.07-1.95]; p=0.017), which was mainly due to increased periods free from excessive sedation (OR 1.59 [1.09-2.31]) and poor ventilator synchronisation (OR 1.55 [1.05-2.30]). However, more patients experienced sedation-related adverse events (OR 1.91 [1.02-3.58]). We found no improvement in overall optimal sedation-analgesia with education (OR 1.13 [95% CI 0.86-1.48]), but fewer patients experienced sedation-related adverse events (OR 0.56 [0.32-0.99]). The sedation-analgesia quality data feedback did not improve quality (OR 0.74 [95% CI 0.54-1.00]) or sedation-related adverse events (OR 1.15 [0.61-2.15]). The process evaluation suggested many clinicians found the RI monitoring useful, but it was often not used for decision making as intended. Education was valued and considered useful by staff. By contrast, sedation-analgesia quality feedback was poorly understood and thought to lack relevance to bedside nursing practice.
AB  - INTERPRETATION: Combination of RI monitoring and online education has the potential to improve sedation-analgesia quality and patient safety in mechanically ventilated ICU patients. The RI monitoring seemed to improve sedation-analgesia quality, but inconsistent adoption by bedside nurses limited its impact. The online education programme resulted in a clinically relevant improvement in patient safety and was valued by nurses, but any changes to behaviours did not seem to alter other measures of sedation-analgesia quality. Providing sedation-analgesia quality feedback to ICUs did not appear to improve any quality metrics, probably because staff did not think it relevant to bedside practice.
AB  - FUNDING: Chief Scientist Office, Scotland; GE Healthcare.

 Copyright © 2016 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Multicenter Study
PT  - Randomized Controlled Trial
PT  - Research Support, Non-U.S. Gov't
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27473760
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27473760&id=doi:10.1016%2FS2213-2600%2816%2930178-3&issn=2213-2600&isbn=&volume=4&issue=10&spage=807&pages=807-817&date=2016&title=The+Lancet+Respiratory+Medicine&atitle=Staff+education%2C+regular+sedation+and+analgesia+quality+feedback%2C+and+a+sedation+monitoring+technology+for+improving+sedation+and+analgesia+quality+for+critically+ill%2C+mechanically+ventilated+patients%3A+a+cluster+randomised+trial.&aulast=Walsh&pid=%3Cauthor%3EWalsh+TS%3C%2Fauthor%3E%3CAN%3E27473760%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<88. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27428803
TI  - A teachable moment for the teachable moment? A prospective study to evaluate delivery of a workshop designed to increase knowledge and skills in relation to alcohol brief interventions (ABIs) amongst final year nursing and occupational therapy undergraduates.
SO  - Nurse Education in Practice. 20:45-53, 2016 Sep.
VI  - 1
ST  - MEDLINE
AU  - O'May F
AU  - Gill J
AU  - McWhirter E
AU  - Kantartzis S
AU  - Rees C
AU  - Murray K
FA  - O'May, Fiona
FA  - Gill, Jan
FA  - McWhirter, Eleanor
FA  - Kantartzis, Sarah
FA  - Rees, Cheryl
FA  - Murray, Kerry
IN  - O'May, Fiona. School of Health Sciences, Queen Margaret University, QMU Drive, Musselburgh, East Lothian, EH21 6UU, Scotland, UK. Electronic address: fomay@qmu.ac.uk.
IN  - Gill, Jan. Department of Nursing, School of Nursing, Midwifery and Social Care, (Sighthill Campus) Edinburgh Napier University, Edinburgh, EH11 4BN, Scotland, UK. Electronic address: J.Gill@napier.ac.uk.
IN  - McWhirter, Eleanor. NHS Lothian Health Promotion Service, Canaan Park, Astley Ainslie Hospital, 133 Grange Loan, Edinburgh, EH9 2HL, Scotland, UK. Electronic address: Eleanor.mcwhirter@nhslothian.scot.nhs.uk.
IN  - Kantartzis, Sarah. Occupational Therapies and Arts Therapies, School of Health Sciences, Queen Margaret University, QMU Drive, Musselburgh, East Lothian, EH21 6UU, Scotland, UK. Electronic address: Skantartzis@qmu.ac.uk.
IN  - Rees, Cheryl. Division of Psychiatry, University of Edinburgh, Kennedy Tower, Royal Edinburgh Hospital, Edinburgh, EH10 5HF, Scotland, UK. Electronic address: cheryl.rees@ed.ac.uk.
IN  - Murray, Kerry. NHS Lothian Health Promotion Service, Canaan Park, Astley Ainslie Hospital, 133 Grange Loan, Edinburgh, EH9 2HL, Scotland, UK. Electronic address: Kerry.Murray@nhslothian.scot.nhs.uk.
AB  - The perceived value of Alcohol Brief Interventions as a tool to address alcohol misuse in Scotland has supported the establishment of a Health Improvement, Efficiency, Access and Treatment, HEAT: H4 Standard to deliver ABIs within certain health care settings. This requires that nursing, medical and allied health professionals are appropriately skilled to deliver these interventions. This study explores the knowledge and attitudes regarding alcohol misuse and related interventions among two cohorts of final year nursing and occupational therapy undergraduate students before, during and following participation in a workshop devoted to ABI delivery. While relatively good knowledge around recommended limits for daily consumption was evident, this did not translate into competence relating to drink unit content. Although there was overwhelming agreement for the role of each profession in ABI delivery, less than half of students in each cohort at the outset of the workshop agreed that they had the appropriate knowledge to advise patients about responsible drinking. In both cohorts, at the three month follow-up stage, this percentage had almost doubled. Newly qualified practitioners perceived a wider role for motivational interviewing, and endorsed interactive delivery of alcohol education throughout all levels of the curriculum.

 Copyright © 2016 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27428803
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27428803&id=doi:10.1016%2Fj.nepr.2016.06.004&issn=1471-5953&isbn=&volume=20&issue=&spage=45&pages=45-53&date=2016&title=Nurse+Education+in+Practice&atitle=A+teachable+moment+for+the+teachable+moment%3F+A+prospective+study+to+evaluate+delivery+of+a+workshop+designed+to+increase+knowledge+and+skills+in+relation+to+alcohol+brief+interventions+%28ABIs%29+amongst+final+year+nursing+and+occupational+therapy+undergraduates.&aulast=O%27May&pid=%3Cauthor%3EO%27May+F%3C%2Fauthor%3E%3CAN%3E27428803%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<89. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27353918
TI  - The NMC has to look beyond England, says Janet Finch.
SO  - Nursing Standard. 30(44):28, 2016 Jun 29.
VI  - 1
ST  - MEDLINE
AU  - Finch DJ
FA  - Finch, Dame Janet
AB  - The Nursing and Midwifery Council is a 4-country regulator. Our remit covers Wales, Scotland, Northern Ireland and England, which is reflected in the membership of our council and many of our activities.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27353918
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27353918&id=doi:10.7748%2Fns.30.44.28.s27&issn=0029-6570&isbn=&volume=30&issue=44&spage=28&pages=28&date=2016&title=Nursing+Standard&atitle=The+NMC+has+to+look+beyond+England%2C+says+Janet+Finch.&aulast=Finch&pid=%3Cauthor%3EFinch+DJ%3C%2Fauthor%3E%3CAN%3E27353918%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<90. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27353914
TI  - Inspirational, meaningful care quality nursing across Scotland.
SO  - Nursing Standard. 30(44):18-20, 2016 Jun 29.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
AB  - In Scotland, geography and social conditions are placing demands on nurses' ingenuity. As RCN Scotland Director Theresa Fyffe says: 'Nurses in Scotland are constantly overcoming the challenges thrown at them by our health and social care system and diverse geography.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27353914
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27353914&id=doi:10.7748%2Fns.30.44.18.s23&issn=0029-6570&isbn=&volume=30&issue=44&spage=18&pages=18-20&date=2016&title=Nursing+Standard&atitle=Inspirational%2C+meaningful+care+quality+nursing+across+Scotland.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27353914%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<91. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27341566
TI  - Being Dementia Smart (BDS): A Dementia Nurse Education Journey in Scotland.
SO  - International Journal of Nursing Education Scholarship. 13, 2016 Jun 24.
VI  - 1
ST  - MEDLINE
AU  - Macaden L
FA  - Macaden, Leah
AB  - There is a global demographic transition secondary to population ageing. The number of older people living with multimorbidities including dementia has been significantly rising both in developed and developing countries. It is estimated that there would be 74.7 million people living with dementia by 2030 that would escalate to 135.46 million by 2050. 62 % of people with dementia currently live in low and middle income countries that are very poorly resourced to cope with this epidemic. Dementia is now duly recognised as a national priority within the UK and a global priority at the 2013 G8 Summit. Management and care of an individual with dementia requires a multidisciplinary approach with expertise and a competent skill base. Nurses are central to the delivery of dementia care delivery in hospitals, community and residential care settings. It is against this background that this pre-registration integrated dementia curriculum was developed to build capacity and capability with dementia expertise among the future nursing workforce in Scotland in line with the National Dementia Strategy.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27341566
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27341566&id=doi:10.1515%2Fijnes-2015-0019&issn=1548-923X&isbn=&volume=13&issue=&spage=&pages=&date=2016&title=International+Journal+of+Nursing+Education+Scholarship&atitle=Being+Dementia+Smart+%28BDS%29%3A+A+Dementia+Nurse+Education+Journey+in+Scotland.&aulast=Macaden&pid=%3Cauthor%3EMacaden+L%3C%2Fauthor%3E%3CAN%3E27341566%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<92. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27286937
TI  - Do emotional intelligence and previous caring experience influence student nurse performance? A comparative analysis.
SO  - Nurse Education Today. 43:1-9, 2016 Aug.
VI  - 1
ST  - MEDLINE
AU  - Stenhouse R
AU  - Snowden A
AU  - Young J
AU  - Carver F
AU  - Carver H
AU  - Brown N
FA  - Stenhouse, Rosie
FA  - Snowden, Austyn
FA  - Young, Jenny
FA  - Carver, Fiona
FA  - Carver, Hannah
FA  - Brown, Norrie
IN  - Stenhouse, Rosie. University of Edinburgh, United Kingdom. Electronic address: Rosie.Stenhouse@ed.ac.uk.
IN  - Snowden, Austyn. Edinburgh Napier University, United Kingdom.
IN  - Young, Jenny. Edinburgh Napier University, United Kingdom.
IN  - Carver, Fiona. Edinburgh Napier University, United Kingdom.
IN  - Carver, Hannah. Edinburgh Napier University, United Kingdom.
IN  - Brown, Norrie. Edinburgh Napier University, United Kingdom.
AB  - BACKGROUND: Reports of poor nursing care have focused attention on values based selection of candidates onto nursing programmes. Values based selection lacks clarity and valid measures. Previous caring experience might lead to better care. Emotional intelligence (EI) might be associated with performance, is conceptualised and measurable.
AB  - OBJECTIVES: To examine the impact of 1) previous caring experience, 2) emotional intelligence 3) social connection scores on performance and retention in a cohort of first year nursing and midwifery students in Scotland.
AB  - DESIGN: A longitudinal, quasi experimental design.
AB  - SETTING: Adult and mental health nursing, and midwifery programmes in a Scottish University.
AB  - METHODS: Adult, mental health and midwifery students (n=598) completed the Trait Emotional Intelligence Questionnaire-short form and Schutte's Emotional Intelligence Scale on entry to their programmes at a Scottish University, alongside demographic and previous caring experience data. Social connection was calculated from a subset of questions identified within the TEIQue-SF in a prior factor and Rasch analysis. Student performance was calculated as the mean mark across the year. Withdrawal data were gathered.
AB  - RESULTS: 598 students completed baseline measures. 315 students declared previous caring experience, 277 not. An independent-samples t-test identified that those without previous caring experience scored higher on performance (57.33+/-11.38) than those with previous caring experience (54.87+/-11.19), a statistically significant difference of 2.47 (95% CI, 0.54 to 4.38), t(533)=2.52, p=.012. Emotional intelligence scores were not associated with performance. Social connection scores for those withdrawing (mean rank=249) and those remaining (mean rank=304.75) were statistically significantly different, U=15,300, z=-2.61, p$_amp_$lt;0.009.
AB  - CONCLUSIONS: Previous caring experience led to worse performance in this cohort. Emotional intelligence was not a useful indicator of performance. Lower scores on the social connection factor were associated with withdrawal from the course.

 Copyright © 2016 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27286937
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27286937&id=doi:10.1016%2Fj.nedt.2016.04.015&issn=0260-6917&isbn=&volume=43&issue=&spage=1&pages=1-9&date=2016&title=Nurse+Education+Today&atitle=Do+emotional+intelligence+and+previous+caring+experience+influence+student+nurse+performance%3F+A+comparative+analysis.&aulast=Stenhouse&pid=%3Cauthor%3EStenhouse+R%3C%2Fauthor%3E%3CAN%3E27286937%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<93. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27213847
TI  - Towards international consensus on patient harm: perspectives on pressure injury policy.
SO  - Journal of Nursing Management. 24(7):902-914, 2016 Oct.
VI  - 1
ST  - MEDLINE
AU  - Jackson D
AU  - Hutchinson M
AU  - Barnason S
AU  - Li W
AU  - Mannix J
AU  - Neville S
AU  - Piper D
AU  - Power T
AU  - Smith GD
AU  - Usher K
FA  - Jackson, Debra
FA  - Hutchinson, Marie
FA  - Barnason, Susan
FA  - Li, William
FA  - Mannix, Judy
FA  - Neville, Stephen
FA  - Piper, Donella
FA  - Power, Tamara
FA  - Smith, Graeme D
FA  - Usher, Kim
IN  - Jackson, Debra. Oxford Brookes University, Oxford, UK. djackson@brookes.ac.uk.
IN  - Jackson, Debra. Oxford University Hospital NHS Foundation Trust, Oxford, UK. djackson@brookes.ac.uk.
IN  - Jackson, Debra. University of New England, Lismore, New South Wales, Australia. djackson@brookes.ac.uk.
IN  - Hutchinson, Marie. Southern Cross University, Lismore, New South Wales, Australia.
IN  - Barnason, Susan. University of Nebraska Medical Center, Lincoln, Nebraska, USA.
IN  - Li, William. The University of Hong Kong, Hong Kong, China.
IN  - Mannix, Judy. Western Sydney University, Sydney, New South Wales, Australia.
IN  - Neville, Stephen. Auckland University of Technology, Auckland, New Zealand.
IN  - Piper, Donella. University of New England, Lismore, New South Wales, Australia.
IN  - Power, Tamara. University of Technology Sydney, Sydney, New South Wales, Australia.
IN  - Smith, Graeme D. Edinburgh Napier University, Scotland, UK.
IN  - Usher, Kim. University of New England, Lismore, New South Wales, Australia.
AB  - AIMS: To analyse influential policies that inform practice related to pressure injury management in Australia, England, Hong Kong, New Zealand, Scotland and the United States of America.
AB  - BACKGROUND: Pressure injuries are associated with significant harm to patients, and carry economic consequences for the health sector. Internationally, preventing and managing pressure injuries is a key nursing activity and quality indicator.
AB  - EVALUATION: Comparative review and synthesis of pressure injury policies that inform practice.
AB  - KEY ISSUES: The predominant focus of policy is on patient risk assessment, compliance with documentation and pressure relief. Financial penalty for institutions is emerging as a strategy where pressure injuries occur. Comparisons of prevalence rates are hampered by the lack of consensus on data collection and reporting. To date there has been little evaluation of policy implementation and implemented policy strategies, associated guidelines remain founded upon expert opinion and low-level evidence.
AB  - IMPLICATIONS FOR NURSING MANAGEMENT: The pressure injury policy agenda has fostered a discourse of attention to incidents, compliance and penalty (sanctions). Prevention and intervention strategies are informed by technical and biomedical interpretations of patient risk and harm, with little attention given to the nature or design of nursing work. Considerable challenges remain if this policy agenda is successfully to eliminate pressure injury as a source of patient harm.

 Copyright © 2016 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27213847
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27213847&id=doi:10.1111%2Fjonm.12396&issn=0966-0429&isbn=&volume=24&issue=7&spage=902&pages=902-914&date=2016&title=Journal+of+Nursing+Management&atitle=Towards+international+consensus+on+patient+harm%3A+perspectives+on+pressure+injury+policy.&aulast=Jackson&pid=%3Cauthor%3EJackson+D%3C%2Fauthor%3E%3CAN%3E27213847%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<94. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27170408
TI  - Developing voluntary standards for district nurse education and practice.
SO  - British Journal of Community Nursing. 21(5):240-5, 2016 May.
VI  - 1
ST  - MEDLINE
AU  - Saunders M
FA  - Saunders, Mary
IN  - Saunders, Mary. Project Manager, Queen's Nursing Institute, London.
AB  - This article charts the development of a project, funded by the Queen's Nursing Institute and Queen's Nursing Institute Scotland, to develop voluntary standards that reflect the contemporary and future practice of district nurses. The standards are designed to enhance, but not replace, the Nursing and Midwifery Council standards for district nurse specialist practice. The project encompassed the four UK countries and gathered data from a wide range of sources to inform the new standards that were launched in September 2015.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27170408
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27170408&id=doi:10.12968%2Fbjcn.2016.21.5.240&issn=1462-4753&isbn=&volume=21&issue=5&spage=240&pages=240-5&date=2016&title=British+Journal+of+Community+Nursing&atitle=Developing+voluntary+standards+for+district+nurse+education+and+practice.&aulast=Saunders&pid=%3Cauthor%3ESaunders+M%3C%2Fauthor%3E%3CAN%3E27170408%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<95. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27167639
TI  - An analysis of policy to practice initiatives in Scotland: what are the key lessons learned?.
SO  - Journal of Nursing Management. 24(6):825-33, 2016 Sep.
VI  - 1
ST  - MEDLINE
AU  - Shuai Z
AU  - Macduff C
FA  - Shuai, Ziying
FA  - Macduff, Colin
IN  - Shuai, Ziying. School of Nursing & Midwifery, Robert Gordon University, Aberdeen, UK.
IN  - Macduff, Colin. School of Nursing & Midwifery, Robert Gordon University, Aberdeen, UK.
AB  - AIM: The study sought to identify and explain common issues and lessons arising from four national health policy initiatives related to nursing, midwifery and allied health professions (NMAHPs) in Scotland between 2005 and 2010.
AB  - BACKGROUND: The Scottish government has been seeking effective practice developments in NMAHPs through enacting policy initiatives to improve patient care. Despite many of these initiatives being individually evaluated, no integrative systematic study has been undertaken to synthesise better understandings.
AB  - DESIGN: Multiple case study design involving qualitative research was the main methodology.
AB  - METHODS: The study used purposive and snowball sampling and in-depth interviews to elicit the views of 24 stakeholders.
AB  - FINDINGS: This study enabled identification and explanation of key generic lessons such as internal policy alignment, good leadership and governance at all levels, effective communication, and sustainability linked to policy external alignment.
AB  - CONCLUSION AND IMPLICATIONS FOR NURSING MANAGEMENT: Findings highlight the importance of strategy for internal policy alignment involving top-down and cross-sectional cooperation and appraising external policy alignment when progressing a sustainable policy initiative. At all levels, leadership is important to provide clear guidance, manage different expectations and enable understanding of initiatives for enactment. Analysis of such initiatives would be useful in preparing nurse managers.

 Copyright © 2016 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27167639
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27167639&id=doi:10.1111%2Fjonm.12389&issn=0966-0429&isbn=&volume=24&issue=6&spage=825&pages=825-33&date=2016&title=Journal+of+Nursing+Management&atitle=An+analysis+of+policy+to+practice+initiatives+in+Scotland%3A+what+are+the+key+lessons+learned%3F.&aulast=Shuai&pid=%3Cauthor%3EShuai+Z%3C%2Fauthor%3E%3CAN%3E27167639%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<96. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27125940
TI  - Implementing digital skills training in care homes: a literature review. [Review]
SO  - Nursing Older People. 28(4):26-9, 2016 May.
VI  - 1
ST  - MEDLINE
AU  - Wild D
AU  - Kydd A
AU  - Szczepura A
FA  - Wild, Deidre
FA  - Kydd, Angela
FA  - Szczepura, Ala
IN  - Wild, Deidre. Centre for Technology Enabled Health Research, Coventry University.
IN  - Kydd, Angela. Edinburgh Napier University.
IN  - Szczepura, Ala. Coventry University.
AB  - This article is the first of a two-part series that informs and describes digital skills training using a dedicated console computer provided for staff and residents in a care home setting. This was part of a programme of culture change in a large care home with nursing in Glasgow, Scotland. The literature review shows that over the past decade there has been a gradual increase in the use of digital technology by staff and older people in community settings including care homes. Policy from the European Commission presents a persuasive argument for the advancement of technology-enabled care to counter the future impact of an increased number of people of advanced age on finite health and social care resources. The psychosocial and environmental issues that inhibit or enhance the acquisition of digital skills in care homes are considered and include the identification of exemplar schemes and the support involved.
PT  - Journal Article
PT  - Review
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27125940
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27125940&id=doi:10.7748%2Fnop.28.4.26.s22&issn=1472-0795&isbn=&volume=28&issue=4&spage=26&pages=26-9&date=2016&title=Nursing+Older+People&atitle=Implementing+digital+skills+training+in+care+homes%3A+a+literature+review.&aulast=Wild&pid=%3Cauthor%3EWild+D%3C%2Fauthor%3E%3CAN%3E27125940%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<97. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27105191
TI  - Alterations and Interdependence in Self-Reported Sleep-Wake Parameters of Patient-Caregiver Dyads During Adjuvant Chemotherapy for Breast Cancer.
SO  - Oncology Nursing Forum. 43(3):288-301, 2016 05 01.
VI  - 1
ST  - MEDLINE
AU  - Kotronoulas G
AU  - Wengstrom Y
AU  - Kearney N
FA  - Kotronoulas, Grigorios
FA  - Wengstrom, Yvonne
FA  - Kearney, Nora
IN  - Kotronoulas, Grigorios. University of Surrey.
IN  - Wengstrom, Yvonne. Karolinska Institutet.
IN  - Kearney, Nora. University of Surrey.
AB  - PURPOSE/OBJECTIVES: To longitudinally explore changes, similarities, differences, and interrelations in the sleep-wake parameters of patient-caregiver dyads throughout adjuvant chemotherapy for breast cancer..
AB  - DESIGN: Observational, repeated-measures, dyadic study..
AB  - SETTING: Four ambulatory oncology clinics in Scotland..
AB  - SAMPLE: 48 dyads consisting of patients and their primary informal caregivers..
AB  - METHODS: Four dyadic, self-reported sleep-wake assessments took place before chemo-therapy (T0), during chemotherapy cycles 1 (T1) and 4 (T2), and after chemotherapy (T3). Dyads completed the Pittsburgh Sleep Quality Index. Multilevel hierarchical linear modeling was used to explore dyadic data..
AB  - MAIN RESEARCH VARIABLES: Perceived sleep quality, sleep onset latency (SOL), total sleep time, habitual sleep efficiency, wake after sleep onset, daily disturbance, daytime napping duration, overall sleep-wake impairment..
AB  - FINDINGS: The majority of dyads had at least one poor sleeper throughout the study; 25%-35% were dyads of concurrent poor sleepers. Curvilinear patterns of change were evident for patients' (but not caregivers') sleep-wake parameters, steadily deteriorating from pre- to midtreatment, then leveling off close to baseline. Average trajectories were significantly different between the dyad members but indicative of a trend for concurrent deterioration at T2. Dyad members' perceived sleep quality, SOL, and overall sleep-wake impairment were closely interrelated; wake variables remained uncoupled..
AB  - CONCLUSIONS: Despite overall differences in magnitude, sleep problems may be concurrently present in both dyad members, covary, and peak midway through chemotherapy. .
AB  - IMPLICATIONS FOR NURSING: Dyadic sleep assessments can shed light on potential areas of sleep interaction to enable interventions to support care dyads at risk of sleep distress during chemotherapy for breast cancer.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=27105191
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27105191&id=doi:10.1188%2F16.ONF.288-301&issn=0190-535X&isbn=&volume=43&issue=3&spage=288&pages=288-301&date=2016&title=Oncology+Nursing+Forum&atitle=Alterations+and+Interdependence+in+Self-Reported+Sleep-Wake+Parameters+of+Patient-Caregiver+Dyads+During+Adjuvant+Chemotherapy+for+Breast+Cancer.&aulast=Kotronoulas&pid=%3Cauthor%3EKotronoulas+G%3C%2Fauthor%3E%3CAN%3E27105191%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<98. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26968512
TI  - Doreen Norton OBE, MSc, SRN, FRCN (1922-2007): Pioneer who revolutionised pressure sore management and geriatric nursing to international acclaim.
SO  - Journal of Medical Biography. 24(2):201-6, 2016 May.
VI  - 1
ST  - MEDLINE
AU  - Denham MJ
FA  - Denham, Michael J
IN  - Denham, Michael J. Retired, Hertfordshire, UK m.denham@brl4it.co.uk.
AB  - Doreen Norton was a delightful, widely respected nurse who devoted her life to improving the care of elderly people. She researched the neglected problem of pressure sores, revolutionised their nursing care, and thus achieved international fame. Her Pressure Sore Scale was established as a management tool and is still used today. She was a key member of the design team that produced the 'King's Fund Bed', researched equipment required on geriatric wards, assessed all geriatric long stay units in Scotland and established research as a valuable nursing tool within her profession and health authorities. She lectured extensively and her publications attracted worldwide acclamation. After her retirement, she was subsequently appointed to the world's first Chair of Gerontological Nursing in Cleveland, Ohio.

 Copyright © The Author(s) 2016.
PT  - Biography
PT  - Historical Article
PT  - Journal Article
PT  - Portrait
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26968512
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26968512&id=doi:10.1177%2F0967772016638973&issn=0967-7720&isbn=&volume=24&issue=2&spage=201&pages=201-6&date=2016&title=Journal+of+Medical+Biography&atitle=Doreen+Norton+OBE%2C+MSc%2C+SRN%2C+FRCN+%281922-2007%29%3A+Pioneer+who+revolutionised+pressure+sore+management+and+geriatric+nursing+to+international+acclaim.&aulast=Denham&pid=%3Cauthor%3EDenham+MJ%3C%2Fauthor%3E%3CAN%3E26968512%3C%2FAN%3E%3CDT%3EBiography%3C%2FDT%3E

<99. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26954633
TI  - Understanding the effects of eczema.
SO  - Nursing Children and Young People. 28(2):9, 2016 Mar.
VI  - 1
ST  - MEDLINE
AU  - Cosh J
FA  - Cosh, Jackie
AB  - EMOTIONAL AND practical support is crucial for the families of children with eczema. This was the main feedback from a workshop organised by the charity Eczema Outreach Scotland for first-year nursing students at the University of Edinburgh.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26954633
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26954633&id=doi:10.7748%2Fncyp.28.2.9.s9&issn=2046-2336&isbn=&volume=28&issue=2&spage=9&pages=9&date=2016&title=Nursing+Children+and+Young+People&atitle=Understanding+the+effects+of+eczema.&aulast=Cosh&pid=%3Cauthor%3ECosh+J%3C%2Fauthor%3E%3CAN%3E26954633%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<100. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26948226
TI  - How emergency department staff perceive acute nurse practitioners.
SO  - Emergency Nurse. 23(10):26-31, 2016 Mar.
VI  - 1
ST  - MEDLINE
AU  - Bryson C
FA  - Bryson, Clare
IN  - Bryson, Clare. NHS Tayside Emergency Department, Ninewells Hospital, Dundee.
AB  - Over the past few years, emergency nursing has introduced new roles to allow nurses to practise at advanced levels. The well established emergency nurse practitioner role, which focuses on patients with minor illnesses and injuries, is being expanded and remodelled, partly to fill the gap created by the decline in the number of emergency medicine doctors. One emergency department in Scotland has introduced an extended nursing role called the acute nurse practitioner, which enables nurses to work at an extended level in the majors area of the department. This article discusses findings from a study that examined a range of healthcare clinicians' perceptions of this newly established service. Findings suggest that the service is received positively by colleagues and patients, but also highlight a number of issues that need to be addressed to enhance the service and support implementation in other emergency departments.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26948226
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26948226&id=doi:10.7748%2Fen.23.10.26.s23&issn=1354-5752&isbn=&volume=23&issue=10&spage=26&pages=26-31&date=2016&title=Emergency+Nurse&atitle=How+emergency+department+staff+perceive+acute+nurse+practitioners.&aulast=Bryson&pid=%3Cauthor%3EBryson+C%3C%2Fauthor%3E%3CAN%3E26948226%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<101. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26862795
TI  - A one-year practice-based learning programme for new general practice nurses in Scotland: evaluation of the pilot.
SO  - Education for Primary Care. 27(1):18-24, 2016 Jan.
VI  - 1
ST  - MEDLINE
AU  - Wakeling J
AU  - Ferguson J
AU  - Kennedy S
FA  - Wakeling, Judy
FA  - Ferguson, Julie
FA  - Kennedy, Susan
IN  - Wakeling, Judy. a NHS Education for Scotland, Glasgow, UK.
IN  - Ferguson, Julie. a NHS Education for Scotland, Glasgow, UK.
IN  - Kennedy, Susan. a NHS Education for Scotland, Glasgow, UK.
CM  - Comment in (CIN)
AB  - This paper summarises the evaluation of a pilot programme introduced by NHS Education for Scotland to provide education and skills training for nurses new to general practice. The programme was developed through extensive consultation with existing general practice nurses and was educationally accredited by the Royal College of General Practitioners and the Royal College of Nursing in 2013. Twelve nurses embarked upon the programme 2012-2013 and nine completed it. The programme was extensively evaluated through questionnaires (with supervisors, practice staff and participants), analysis of programme documentation and interviews with participants. Based on the evaluation feedback, alterations have been made to subsequent deliveries of the programme. These include removing some topic areas and lengthening the programme by three months. The programme continues to be successfully delivered and evaluation is ongoing to ensure it continues to meet nurses' needs.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26862795
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26862795&id=doi:10.1080%2F14739879.2015.1101898&issn=1473-9879&isbn=&volume=27&issue=1&spage=18&pages=18-24&date=2016&title=Education+for+Primary+Care&atitle=A+one-year+practice-based+learning+programme+for+new+general+practice+nurses+in+Scotland%3A+evaluation+of+the+pilot.&aulast=Wakeling&pid=%3Cauthor%3EWakeling+J%3C%2Fauthor%3E%3CAN%3E26862795%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<102. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26559483
TI  - Prevalence of overweight and obesity among nurses in Scotland: A cross-sectional study using the Scottish Health Survey.
SO  - International Journal of Nursing Studies. 53:126-33, 2016 Jan.
VI  - 1
ST  - MEDLINE
AU  - Kyle RG
AU  - Neall RA
AU  - Atherton IM
FA  - Kyle, Richard G
FA  - Neall, Rosie A
FA  - Atherton, Iain M
IN  - Kyle, Richard G. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, Edinburgh, UK. Electronic address: r.kyle@napier.ac.uk.
IN  - Neall, Rosie A. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, Edinburgh, UK.
IN  - Atherton, Iain M. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, Edinburgh, UK.
AB  - BACKGROUND: Increasing prevalence of overweight and obesity represents a global pandemic. As the largest occupational group in international healthcare systems nurses are at the forefront of health promotion to address this pandemic. However, nurses own health behaviours are known to influence the extent to which they engage in health promotion and the public's confidence in advice offered. Estimating the prevalence of overweight and obesity among nurses is therefore important. However, to date, prevalence estimates have been based on non-representative samples and internationally no studies have compared prevalence of overweight and obesity among nurses to other healthcare professionals using representative data.
AB  - OBJECTIVES: To estimate overweight and obesity prevalence among nurses in Scotland, and compare to other healthcare professionals and those working in non-heath related occupations.
AB  - DESIGN: Cross-sectional study using a nationally representative sample of five aggregated annual rounds (2008-2012) of the Scottish Health Survey.
AB  - SETTING: Scotland.
AB  - PARTICIPANTS: 13,483 adults aged 17-65 indicating they had worked in the past 4 weeks, classified in four occupational groups: nurses (n=411), other healthcare professionals (n=320), unqualified care staff (n=685), and individuals employed in non-health related occupations (n=12,067).
AB  - MAIN OUTCOME MEASURES: Prevalence of overweight and obesity defined as Body Mass Index>=25.0.
AB  - METHODS: Estimates of overweight and obesity prevalence in each occupational group were calculated with 95% confidence intervals (CI). A logistic regression model was then built to compare the odds of being overweight or obese with not being overweight or obese for nurses in comparison to the other occupational categories. Data were analysed using SAS 9.1.3.
AB  - RESULTS: 69.1% (95% CI 64.6, 73.6) of Scottish nurses were overweight or obese. Prevalence of overweight and obesity was higher in nurses than other healthcare professionals (51.3%, CI 45.8, 56.7), unqualified care staff (68.5%, CI 65.0, 72.0) and those in non-health related occupations (68.9%, CI 68.1, 69.7). A logistic regression model adjusted for socio-demographic composition indicated that, compared to nurses, the odds of being overweight or obese was statistically significantly lower for other healthcare professionals (Odds Ratio [OR] 0.45, CI 0.33, 0.61) and those in non-health related occupations (OR 0.78, CI 0.62, 0.97).
AB  - CONCLUSIONS: Prevalence of overweight and obesity among Scottish nurses is worryingly high, and significantly higher than those in other healthcare professionals and non-health related occupations. High prevalence of overweight and obesity potentially harms nurses' own health and hampers the effectiveness of nurses' health promotion role. Interventions are therefore urgently required to address overweight and obesity among the Scottish nursing workforce.

 Copyright © 2015 Elsevier Ltd. All rights reserved.
PT  - Comparative Study
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26559483
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26559483&id=doi:10.1016%2Fj.ijnurstu.2015.10.015&issn=0020-7489&isbn=&volume=53&issue=&spage=126&pages=126-33&date=2016&title=International+Journal+of+Nursing+Studies&atitle=Prevalence+of+overweight+and+obesity+among+nurses+in+Scotland%3A+A+cross-sectional+study+using+the+Scottish+Health+Survey.&aulast=Kyle&pid=%3Cauthor%3EKyle+RG%3C%2Fauthor%3E%3CAN%3E26559483%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<103. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26556706
TI  - Understanding pre-registration nursing fitness to practise processes. [Review]
SO  - Nurse Education Today. 36:412-8, 2016 Jan.
VI  - 1
ST  - MEDLINE
AU  - MacLaren J
AU  - Haycock-Stuart E
AU  - McLachlan A
AU  - James C
FA  - MacLaren, Jessica
FA  - Haycock-Stuart, Elaine
FA  - McLachlan, Alison
FA  - James, Christine
IN  - MacLaren, Jessica. School of Health in Social Science, The University of Edinburgh, Old Medical Quad, Teviot Place, Edinburgh EH8 9AG, UK. Electronic address: Jessica.MacLaren@ed.ac.uk.
IN  - Haycock-Stuart, Elaine. School of Health in Social Science, The University of Edinburgh, Old Medical Quad, Teviot Place, Edinburgh EH8 9AG, UK. Electronic address: E.A.Haycock-Stuart@ed.ac.uk.
IN  - McLachlan, Alison. School of Health Nursing and Midwifery, University of the West of Scotland, Paisley PA1 2BE, UK.
IN  - James, Christine. School of Health Nursing and Midwifery, University of the West of Scotland, Paisley PA1 2BE, UK.
AB  - BACKGROUND: Protection of the public is a key aspect of pre-registration nursing education and UK Nursing and Midwifery Council monitoring processes. Universities must ensure that nursing students are "fit to practise" both during their programme and at the point of registration. However, current evidence suggests that institutional fitness to practise policies and processes can be inconsistent, lacking in clarity, and open to legal challenge.
AB  - OBJECTIVES: To examine fitness to practise processes in pre-registration nursing programmes in Scotland.
AB  - PARTICIPANTS: Academic personnel (n=11) with key roles in fitness to practise processes in nine of the eleven Scottish universities providing pre-registration nursing programmes.
AB  - METHODS: Semi-structured qualitative interviews were conducted with eleven academics with responsibility for fitness to practise processes in pre-registration programmes. The qualitative data and documentary evidence including institutional policies and processes were thematically analysed.
AB  - FINDINGS: In this paper, we focus on illuminating the key theme of Stages and Thresholds in Fitness to Practise processes i.e. Pre-fitness to practise, Stage 1, Stage 2, and Appeal, along with two thresholds (between Pre-fitness to practise and Stage 1; between Stage 1 and Stage 2.
AB  - CONCLUSIONS: Diverse fitness to practise processes are currently in place for Scottish pre-registration nursing students. These processes draw on a shared set of principles but are couched in different terminology and vary according to their location within different university structures. Nevertheless, universities appear to be confronting broadly similar issues around ensuring fitness to practise and are building a body of expertise in this area. Examples of good practice are identified and include the use of staged processes and graduated outcomes, the incorporation of teaching about fitness to practise into nursing programmes, positive attitudes around health and disability, and collaborative decision making. Areas of challenge include systems for student support and consistent, equitable, and auditable fitness to practise processes.

 Copyright © 2015 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
PT  - Review
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26556706
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26556706&id=doi:10.1016%2Fj.nedt.2015.10.025&issn=0260-6917&isbn=&volume=36&issue=&spage=412&pages=412-8&date=2016&title=Nurse+Education+Today&atitle=Understanding+pre-registration+nursing+fitness+to+practise+processes.&aulast=MacLaren&pid=%3Cauthor%3EMacLaren+J%3C%2Fauthor%3E%3CAN%3E26556706%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<104. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26163277
TI  - First year undergraduate nursing students and nursing mentors: An evaluation of their experience of specialist areas as their hub practice learning environment.
SO  - Nurse Education in Practice. 16(1):182-7, 2016 Jan.
VI  - 1
ST  - MEDLINE
AU  - McCallum J
AU  - Lamont D
AU  - Kerr EL
FA  - McCallum, Jacqueline
FA  - Lamont, David
FA  - Kerr, Emma-Louise
IN  - McCallum, Jacqueline. Glasgow Caledonian University, Room A511, Govan Mbeki Building, Cowcaddens Road, Glasgow, G4 0BA, UK. Electronic address: Jacqueline.mccallum@gcu.ac.uk.
IN  - Lamont, David. NHS Greater Glasgow & Clyde Acute Services Division, Practice Development, 4th Floor Former Outpatient Dept, Victoria Infirmary, Grange Road, Glasgow, G42 9TY, UK. Electronic address: David.Lamont@ggc.scot.nhs.uk.
IN  - Kerr, Emma-Louise. NHS Greater Glasgow & Clyde Acute Services Division, Flat 4, 34 Shelley Court, Gartnavel General Hospital, GreatWestern Road, Glasgow, G12 0YN, UK. Electronic address: emma-louise.kerr@ggc.scot.nhs.uk.
AB  - Specialist environments have traditionally not been considered as practice learning environments for year one nursing students. Through implementation of the hub and spoke model of practice learning this was implemented across one health board and Higher Education Institution in Scotland. Sixty nine students from specialist and 147 from general areas out of a total population of 467 students (46.2%) and thirteen mentors from specialist and 26 from general areas out of a total 577 mentors (6.7%) completed a questionnaire. The findings support this initiative and suggest in some cases student experiences are more positive in specialist environments.

 Copyright © 2015 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med13&AN=26163277
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26163277&id=doi:10.1016%2Fj.nepr.2015.06.005&issn=1471-5953&isbn=&volume=16&issue=1&spage=182&pages=182-7&date=2016&title=Nurse+Education+in+Practice&atitle=First+year+undergraduate+nursing+students+and+nursing+mentors%3A+An+evaluation+of+their+experience+of+specialist+areas+as+their+hub+practice+learning+environment.&aulast=McCallum&pid=%3Cauthor%3EMcCallum+J%3C%2Fauthor%3E%3CAN%3E26163277%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<105. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26636893
TI  - Learning to deal with crisis in the home: Part 2 - preparing preregistration students.
SO  - British Journal of Community Nursing. 20(12):594-9, 2015 Dec.
VI  - 1
ST  - MEDLINE
AU  - Gibson CE
AU  - Dickson C
AU  - Lawson B
AU  - McMillan A
AU  - Kelly H
FA  - Gibson, Caroline E
FA  - Dickson, Caroline
FA  - Lawson, Bill
FA  - McMillan, Ailsa
FA  - Kelly, Helena
IN  - Gibson, Caroline E. Senior Lecturer in Nursing, Queen Margaret University Edinburgh, Scotland.
IN  - Dickson, Caroline. Senior Lecturer in Community Nursing, Queen Margaret University Edinburgh, Scotland.
IN  - Lawson, Bill. Lecturer in Nursing, Queen Margaret University Edinburgh, Scotland.
IN  - McMillan, Ailsa. Lecturer in Nursing and Programme Leader BSc Hons Nursing, Queen Margaret University Edinburgh, Scotland.
IN  - Kelly, Helena. Lecturer in Nursing, Glasgow Caledonian University, Scotland.
AB  - The global shift of health care is from acute services to community and primary care. Therefore, registrants must be prepared to work effectively within diverse settings. This article is the second in a series discussing the preparation of nurses for contemporary health-care challenges in the community. In it, we outline the design, implementation, and evaluation of simulated emergency scenarios within an honours degree-level, pre-registration nursing curriculum in Scotland. Over 3 years, 99 final-year students participated in interactive sessions focusing on recognition and management of the deteriorating patient and emergency care. Clinical scenarios were designed and delivered collaboratively with community practitioners. Debriefing challenged the students to reflect on learning and transferability of skills of clinical reasoning and care management to the community context. Students considered the scenarios to be realistic and perceived that their confidence had increased. Development of such simulation exercises is worthy of further debate in education and practice.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26636893
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26636893&id=doi:10.12968%2Fbjcn.2015.20.12.594&issn=1462-4753&isbn=&volume=20&issue=12&spage=594&pages=594-9&date=2015&title=British+Journal+of+Community+Nursing&atitle=Learning+to+deal+with+crisis+in+the+home%3A+Part+2+-+preparing+preregistration+students.&aulast=Gibson&pid=%3Cauthor%3EGibson+CE%3C%2Fauthor%3E%3CAN%3E26636893%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<106. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26515660
TI  - Nursing home placement in the Donepezil and Memantine in Moderate to Severe Alzheimer's Disease (DOMINO-AD) trial: secondary and post-hoc analyses.
SO  - Lancet Neurology. 14(12):1171-81, 2015 Dec.
VI  - 1
ST  - MEDLINE
AU  - Howard R
AU  - McShane R
AU  - Lindesay J
AU  - Ritchie C
AU  - Baldwin A
AU  - Barber R
AU  - Burns A
AU  - Dening T
AU  - Findlay D
AU  - Holmes C
AU  - Jones R
AU  - Jones R
AU  - McKeith I
AU  - Macharouthu A
AU  - O'Brien J
AU  - Sheehan B
AU  - Juszczak E
AU  - Katona C
AU  - Hills R
AU  - Knapp M
AU  - Ballard C
AU  - Brown RG
AU  - Banerjee S
AU  - Adams J
AU  - Johnson T
AU  - Bentham P
AU  - Phillips PP
FA  - Howard, Robert
FA  - McShane, Rupert
FA  - Lindesay, James
FA  - Ritchie, Craig
FA  - Baldwin, Ashley
FA  - Barber, Robert
FA  - Burns, Alistair
FA  - Dening, Tom
FA  - Findlay, David
FA  - Holmes, Clive
FA  - Jones, Robert
FA  - Jones, Roy
FA  - McKeith, Ian
FA  - Macharouthu, Ajay
FA  - O'Brien, John
FA  - Sheehan, Bart
FA  - Juszczak, Edmund
FA  - Katona, Cornelius
FA  - Hills, Robert
FA  - Knapp, Martin
FA  - Ballard, Clive
FA  - Brown, Richard G
FA  - Banerjee, Sube
FA  - Adams, Jessica
FA  - Johnson, Tony
FA  - Bentham, Peter
FA  - Phillips, Patrick P J
IN  - Howard, Robert. Division of Psychiatry, University College London, London, UK; Department of Old Age Psychiatry, Institute of Psychiatry, Psychology and Neuroscience, King's College London, London, UK. Electronic address: robert.howard@ucl.ac.uk.
IN  - McShane, Rupert. Oxford Health NHS Foundation Trust, Warneford Hospital, Headington, Oxford, UK.
IN  - Lindesay, James. Health Sciences, University of Leicester, Leicester, UK.
IN  - Ritchie, Craig. Centre for Brain Sciences, University of Edinburgh, Edinburgh, UK.
IN  - Baldwin, Ashley. Five Boroughs Partnership NHS Foundation Trust, Winwick, Warrington, UK.
IN  - Barber, Robert. Centre for Ageing and Vitality, Newcastle upon Tyne, UK.
IN  - Burns, Alistair. Institute of Brain, Behaviour and Mental Health, University of Manchester, Manchester, UK.
IN  - Dening, Tom. Institute of Mental Health, University of Nottingham, Nottingham, UK.
IN  - Findlay, David. Kingsway Care Centre, Dundee, UK.
IN  - Holmes, Clive. Faculty of Medicine, University of Southampton, Southampton, UK.
IN  - Jones, Robert. Department of Pyschiatry, University of Nottingham, Nottingham, UK.
IN  - Jones, Roy. Research Institute for the Care of Older People, Bath, UK.
IN  - McKeith, Ian. Newcastle; University Institute for Ageing, Newcastle University, Newcastle Upon Tyne, UK.
IN  - Macharouthu, Ajay. Ayrshire and Arran NHS, University Hospital Crosshouse, Crosshouse, Kilmarnock, UK.
IN  - O'Brien, John. Department of Psychiatry, University of Cambridge, Cambridge, UK.
IN  - Sheehan, Bart. Oxford University Hospitals NHS Trust, Headington, Oxford, UK.
IN  - Juszczak, Edmund. National Perinatal Epidemiology Unit Clinical Trials Unit, University of Oxford, Oxford, UK.
IN  - Katona, Cornelius. Division of Psychiatry, University College London, London, UK.
IN  - Hills, Robert. Cardiff University School of Medicine, Cardiff, UK.
IN  - Knapp, Martin. London School of Economics, London, UK.
IN  - Ballard, Clive. Wolfson Centre for Age Related Disorders, King's College London, London, UK.
IN  - Brown, Richard G. Department of Psychology, King's College London, London, UK.
IN  - Banerjee, Sube. Brighton and Sussex Medical School, University of Sussex, Brighton, East Sussex, UK.
IN  - Adams, Jessica. Department of Old Age Psychiatry, King's College London, London, UK.
IN  - Johnson, Tony. Medical Research Council Clinical Trials Unit, University College London, London, UK.
IN  - Bentham, Peter. Birmingham and Solihull Mental Health NHS Foundation Trust, Birmingham, UK.
IN  - Phillips, Patrick P J. Medical Research Council Clinical Trials Unit, University College London, London, UK.
CM  - Comment in (CIN)
CM  - Comment in (CIN)
AB  - BACKGROUND: Findings from observational studies have suggested a delay in nursing home placement with dementia drug treatment, but findings from a previous randomised trial of patients with mild-to-moderate Alzheimer's disease showed no effect. We investigated the effects of continuation or discontinuation of donepezil and starting of memantine on subsequent nursing home placement in patients with moderate-to-severe Alzheimer's disease.
AB  - METHODS: In the randomised, double-blind, placebo-controlled Donepezil and Memantine in Moderate to Severe Alzheimer's Disease (DOMINO-AD) trial, community-living patients with moderate-to-severe Alzheimer's disease (who had been prescribed donepezil continuously for at least 3 months at a dose of 10 mg for at least the previous 6 weeks and had a score of between 5 and 13 on the Standardised Mini-Mental State Examination) were recruited from 15 secondary care memory centres in England and Scotland and randomly allocated to continue donepezil 10 mg per day without memantine, discontinue donepezil without memantine, discontinue donepezil and start memantine 20 mg per day, or continue donepezil 10 mg per day and start memantine 20 mg per day, for 52 weeks. After 52 weeks, choice of treatment was left to participants and their physicians. Place of residence was recorded during the first 52 weeks of the trial and then every 26 weeks for a further 3 years. A secondary outcome of the trial, reported in this study, was nursing home placement: an irreversible move from independent accommodation to a residential caring facility. Analyses restricted to risk of placement in the first year of follow-up after the patients had completed the double-blind phase of the trial were post-hoc. The DOMINO-AD trial is registered with the ISRCTN Registry, number ISRCTN49545035.
AB  - FINDINGS: Between Feb 11, 2008, and March 5, 2010, 73 (25%) patients were randomly assigned to continue donepezil without memantine, 73 (25%) to discontinue donepezil without memantine, 76 (26%) to discontinue donepezil and start memantine, and 73 (25%) to continue donepezil and start memantine. 162 (55%) patients underwent nursing home placement within 4 years of randomisation, with similar numbers for all groups (36 [49%] in patients who continued donepezil without memantine, 42 [58%] who discontinued donepezil without memantine, 41 [54%] who discontinued donepezil and started memantine, and 43 [59%] who continued donepezil and started memantine). We noted significant (p=0.010) heterogeneity of treatment effect over time, with significantly more nursing home placements in the combined donepezil discontinuation groups during the first year (hazard ratio 2.09 [95% CI 1.29-3.39]) than in the combined donepezil continuation groups, and no difference during the next 3 years (0.89 [0.58-1.35]). We noted no effect of patients starting memantine compared with not starting memantine during the first year (0.92 [0.58-1.45]) or the next 3 years (1.23 [0.81-1.87]).
AB  - INTERPRETATION: Withdrawal of donepezil in patients with moderate-to-severe Alzheimer's disease increased the risk of nursing home placement during 12 months of treatment, but made no difference during the following 3 years of follow-up. Decisions to stop or continue donepezil treatment should be informed by potential risks of withdrawal, even if the perceived benefits of continued treatment are not clear.
AB  - FUNDING: Medical Research Council and UK Alzheimer's Society.

 Copyright © 2015 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Randomized Controlled Trial
PT  - Research Support, Non-U.S. Gov't
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26515660
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26515660&id=doi:10.1016%2FS1474-4422%2815%2900258-6&issn=1474-4422&isbn=&volume=14&issue=12&spage=1171&pages=1171-81&date=2015&title=Lancet+Neurology&atitle=Nursing+home+placement+in+the+Donepezil+and+Memantine+in+Moderate+to+Severe+Alzheimer%27s+Disease+%28DOMINO-AD%29+trial%3A+secondary+and+post-hoc+analyses.&aulast=Howard&pid=%3Cauthor%3EHoward+R%3C%2Fauthor%3E%3CAN%3E26515660%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<107. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26492690
TI  - Nursing quality scheme piloted in Scotland.
SO  - Nursing Times. 111(21):6, 2015 May 20-26.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
PT  - News
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26492690
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26492690&id=doi:&issn=0954-7762&isbn=&volume=111&issue=21&spage=6&pages=6&date=2015&title=Nursing+Times&atitle=Nursing+quality+scheme+piloted+in+Scotland.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E26492690%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<108. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26419573
TI  - Inspiring undergraduates towards a career in community nursing. [Review]
SO  - Nursing Management (Harrow). 22(6):18, 20-5, 2015 Oct.
VI  - 1
ST  - MEDLINE
AU  - Cable C
AU  - Dickson C
AU  - Morris G
FA  - Cable, Clare
FA  - Dickson, Caroline
FA  - Morris, Gillian
IN  - Cable, Clare. Queen's Nursing Institute Scotland.
IN  - Dickson, Caroline. Queen Margaret University, Edinburgh.
IN  - Morris, Gillian. University of Dundee.
AB  - This article is based on the findings of a literature review commissioned by the Queen's Nursing Institute Scotland as part of its commitment to promote an evidence-based educational policy. An analysis of the literature suggests that there is potential to expand the provision of community placements beyond traditional clinical areas and these placements should be identified and overseen in collaboration with managers, mentors and higher education institutions to ensure a consistent approach and a positive learning experience. This may inspire undergraduate nurses to pursue a career in community nursing. Currently, there is little evidence to support models. High-quality evaluation research is required to ensure that new models are developed using a sound evidence base.
PT  - Journal Article
PT  - Review
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26419573
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26419573&id=doi:10.7748%2Fnm.22.6.18.e1382&issn=1354-5760&isbn=&volume=22&issue=6&spage=18&pages=18%2C+20-5&date=2015&title=Nursing+Management+%28Harrow%29&atitle=Inspiring+undergraduates+towards+a+career+in+community+nursing.&aulast=Cable&pid=%3Cauthor%3ECable+C%3C%2Fauthor%3E%3CAN%3E26419573%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<109. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26307282
TI  - Older rural population needs a flexible nursing workforce.
SO  - Nursing Standard. 29(52):10, 2015 Aug 26.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
AB  - A 'radical shift in resources' is required to meet the needs of older people in remote and rural areas, according to a report published by the RCN with support from Age Scotland.
PT  - News
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26307282
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26307282&id=doi:10.7748%2Fns.29.52.10.s12&issn=0029-6570&isbn=&volume=29&issue=52&spage=10&pages=10&date=2015&title=Nursing+Standard&atitle=Older+rural+population+needs+a+flexible+nursing+workforce.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E26307282%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<110. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26209613
TI  - A survey of morbidity and mortality review meetings in the general surgical units of the West of Scotland.
SO  - Scottish Medical Journal. 60(4):244-8, 2015 Nov.
VI  - 1
ST  - MEDLINE
AU  - Khine M
AU  - Leung E
AU  - McGregor JR
FA  - Khine, Myo
FA  - Leung, Edward
FA  - McGregor, John R
IN  - Khine, Myo. Specialty Doctor in General Surgery, Department of Surgery, Crosshouse Hospital, UK mkhine@nhs.net.
IN  - Leung, Edward. Consultant General and Colorectal Surgeon, Department of Surgery, Crosshouse Hospital, UK.
IN  - McGregor, John R. Consultant General and Colorectal Surgeon, Department of Surgery, Crosshouse Hospital, UK.
AB  - BACKGROUND AND AIMS: There is little consensus as to the conduct of surgical morbidity and mortality review meetings. The aim of this survey was to determine how surgical morbidity and mortality meetings in the surgical units in the West of Scotland are carried out and to explore possible areas for improvement.
AB  - METHODS AND RESULTS: Forty six surgical trainees distributed between the 15 general surgery units of the West of Scotland were asked to provide details of their surgical morbidity and mortality meetings for the training year 2012-2013. Twenty-five of 46 (54%) specialty trainees responded with all units being represented. All had designated time for surgical morbidity and mortality review. Meeting frequency varied as follows: weekly (3 units), fortnightly (1 unit), monthly (10 units), three monthly (1 unit). Fewer than half the units (6) included Foundation Trainees, and only one meeting was attended by nursing staff. Five units had clear criteria for morbidity, but only three included morbidity collected from outpatient follow-up. A standardised proforma was used to present the cases in only 2 units.
AB  - CONCLUSIONS: All 15 surgical units in the West of Scotland have a regular surgical morbidity and mortality meeting but significant variations were observed as to frequency and participating personnel. A more robust system for reporting morbidities should be considered.

 Copyright © The Author(s) 2015.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26209613
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26209613&id=doi:10.1177%2F0036933015597179&issn=0036-9330&isbn=&volume=60&issue=4&spage=244&pages=244-8&date=2015&title=Scottish+Medical+Journal&atitle=A+survey+of+morbidity+and+mortality+review+meetings+in+the+general+surgical+units+of+the+West+of+Scotland.&aulast=Khine&pid=%3Cauthor%3EKhine+M%3C%2Fauthor%3E%3CAN%3E26209613%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<111. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26053929
TI  - Developing clinical skills bundles.
SO  - The clinical teacher. 12(6):403-7, 2015 Dec.
VI  - 1
ST  - MEDLINE
AU  - Mok M
AU  - Ker J
FA  - Mok, May
FA  - Ker, Jean
IN  - Mok, May. NHS Tayside, Clinical Skills Centre, University of Dundee, UK.
IN  - Ker, Jean. NHS Tayside, Clinical Skills Centre, University of Dundee, UK.
AB  - BACKGROUND: This article describes an innovative method of learning clinical skills. A care bundle is defined as a small set of evidence-based interventions that, when implemented together, results in significantly better patient outcomes than when implemented individually. Care bundles improve the consistency of standards of care delivered, and hence reduce harm.
AB  - CONTEXT: In 2007 The Scottish Clinical Skills Strategy identified the use of simulation-based education to ensure all health care staff can deliver a consistently high standard of clinical skills practice throughout the National Health Service in Scotland (NHS Scotland).
AB  - INNOVATION: Clinical skills bundles were developed to underpin a number of evidence-based care bundles. Grouping the clinical skills together and learning them as a clinical skills bundle may improve the reliability of skills delivery for each care bundle. Three groups were recruited and asked to identify a consensus of the essential technical and non-technical skills for clinical skills bundle for a central venous catheter (CVC) maintenance care bundle. As a pilot, six clinical skills bundle workshops were held for junior doctors, nursing and medical students, and clinical skills educators. The aims of the workshops were to introduce the concepts of clinical skills bundles and to give participants a chance to practice the underpinning clinical skills bundle for a care bundle using simulation. The majority of participants rated the workshop as excellent or good. Self-reported learning included refreshing their clinical skills in a different context. Care bundles improve the consistency of standards of care delivered
AB  - IMPLICATION: Learning skills together as a bundle may enhance the reliability of clinical skills performance for care bundles, and may also reinforce the use of care bundles.

 Copyright © 2015 John Wiley & Sons Ltd.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=26053929
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26053929&id=doi:10.1111%2Ftct.12332&issn=1743-4971&isbn=&volume=12&issue=6&spage=403&pages=403-7&date=2015&title=The+clinical+teacher&atitle=Developing+clinical+skills+bundles.&aulast=Mok&pid=%3Cauthor%3EMok+M%3C%2Fauthor%3E%3CAN%3E26053929%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<112. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25929099
TI  - Nursing leadership in Scotland.
SO  - Kentucky Nurse. 63(2):7, 2015 Apr-Jun.
VI  - 1
ST  - MEDLINE
AU  - Beam OP
FA  - Beam, Olivia P
PT  - Biography
PT  - Historical Article
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25929099
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25929099&id=doi:&issn=0742-8367&isbn=&volume=63&issue=2&spage=7&pages=7&date=2015&title=Kentucky+Nurse&atitle=Nursing+leadership+in+Scotland.&aulast=Beam&pid=%3Cauthor%3EBeam+OP%3C%2Fauthor%3E%3CAN%3E25929099%3C%2FAN%3E%3CDT%3EBiography%3C%2FDT%3E

<113. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25846703
TI  - Stepping up, stepping back, stepping forward: Student nurses' experiences as peer mentors in a pre-nursing scholarship.
SO  - Nurse Education in Practice. 15(6):492-7, 2015 Nov.
VI  - 1
ST  - MEDLINE
AU  - Smith A
AU  - Beattie M
AU  - Kyle RG
FA  - Smith, Annetta
FA  - Beattie, Michelle
FA  - Kyle, Richard G
IN  - Smith, Annetta. School of Health Sciences, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness, IV2 3JH, UK. Electronic address: annetta.smith@stir.ac.uk.
IN  - Beattie, Michelle. School of Health Sciences, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness, IV2 3JH, UK.
IN  - Kyle, Richard G. School of Health Sciences, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness, IV2 3JH, UK.
AB  - Mentorship is an essential part of the registered nurse's role, yet few opportunities exist for student nurses to mentor others during pre-registration programmes. This paper reports student nurses' experiences of mentoring school pupils during a pre-nursing scholarship. Focus groups were conducted with fifteen final year student nurses (14 female, 1 male) in two university campuses in Scotland. Discussions were audio recorded and transcribed verbatim, and data analysed thematically. Three interconnected themes emerged: 1) stepping up; 2) stepping back; 3) stepping forward. 'Stepping up' was a process through which student nurses rapidly assumed responsibility for mentoring pupils, facilitated through the attitudes and actions of students' mentors and students' control over pupils' practice experiences. 'Stepping back' encapsulated attitudes and behaviours that enabled student nurses to mentor pupils that involved considerable judgement around how unfolding events in practice could provide learning and development opportunities, and emotional acuity to support pupils through, sometimes challenging, practice situations. 'Stepping forward' described how students' mentoring experience allowed them to appraise and affirm nursing knowledge and skills, and gain greater appreciation of the reality and complexity of mentorship in clinical practice. Peer mentoring may prepare student nurses for future mentoring roles and aid their transition into clinical practice.

 Copyright © 2015 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25846703
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25846703&id=doi:10.1016%2Fj.nepr.2015.03.005&issn=1471-5953&isbn=&volume=15&issue=6&spage=492&pages=492-7&date=2015&title=Nurse+Education+in+Practice&atitle=Stepping+up%2C+stepping+back%2C+stepping+forward%3A+Student+nurses%27+experiences+as+peer+mentors+in+a+pre-nursing+scholarship.&aulast=Smith&pid=%3Cauthor%3ESmith+A%3C%2Fauthor%3E%3CAN%3E25846703%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<114. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25839877
TI  - Enhancing undergraduate community placements: a critical review of current literature. [Review]
SO  - British Journal of Community Nursing. 20(4):184-9, 2015 Apr.
VI  - 1
ST  - MEDLINE
AU  - Dickson CA
AU  - Morris G
AU  - Gable C
FA  - Dickson, Caroline A W
FA  - Morris, Gillian
FA  - Gable, Clare
IN  - Dickson, Caroline A W. Senior Lecturer in Community Nursing, Queen Margaret University, Edinburgh.
AB  - In the face of the UK-wide policy shift to increased home care, inspiring and enabling the next generation of community nurses is more urgent than ever. The quality of the pre-registration practice learning experience is highly influential on career choices at the point of qualification. Given that 50% of learning by pre-registration students takes place in practice, mentors have a crucial role to play in preparing the next generation of nurses to work in the community. This article discusses the findings of a systematic and critical literature review of pre-registration placements that was funded by the Queen's Nursing Institute Scotland. The review found that students' experiences of learning in community settings are variable, and perceptions of students and mentors are misaligned in terms of what a quality placement should look like. Although there is no clear definition of what constitutes a community placement and there is some underuse of learning environments in areas such as general practice nursing, there are also a number of examples of new and imaginative placements. While these innovations provide 'whole experience' placements, they are currently lacking robust evaluation, despite their potential usefulness on a larger scale. Mentors have the opportunity to provide students with a range of learning opportunities that increase preparedness for working in the community, allowing final year students in particular greater influence over their learning experience. Students undertaking community practice learning, where they have a managed level of autonomy, are more likely to feel confident to take on community nursing roles.
PT  - Journal Article
PT  - Review
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25839877
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25839877&id=doi:10.12968%2Fbjcn.2015.20.4.184&issn=1462-4753&isbn=&volume=20&issue=4&spage=184&pages=184-9&date=2015&title=British+Journal+of+Community+Nursing&atitle=Enhancing+undergraduate+community+placements%3A+a+critical+review+of+current+literature.&aulast=Dickson&pid=%3Cauthor%3EDickson+CA%3C%2Fauthor%3E%3CAN%3E25839877%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<115. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25828558
TI  - Different Experiences and Goals in Different Advanced Diseases: Comparing Serial Interviews With Patients With Cancer, Organ Failure, or Frailty and Their Family and Professional Carers.
SO  - Journal of Pain & Symptom Management. 50(2):216-24, 2015 Aug.
VI  - 1
ST  - MEDLINE
AU  - Kendall M
AU  - Carduff E
AU  - Lloyd A
AU  - Kimbell B
AU  - Cavers D
AU  - Buckingham S
AU  - Boyd K
AU  - Grant L
AU  - Worth A
AU  - Pinnock H
AU  - Sheikh A
AU  - Murray SA
FA  - Kendall, Marilyn
FA  - Carduff, Emma
FA  - Lloyd, Anna
FA  - Kimbell, Barbara
FA  - Cavers, Debbie
FA  - Buckingham, Susan
FA  - Boyd, Kirsty
FA  - Grant, Liz
FA  - Worth, Allison
FA  - Pinnock, Hilary
FA  - Sheikh, Aziz
FA  - Murray, Scott A
IN  - Kendall, Marilyn. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Carduff, Emma. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Lloyd, Anna. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Kimbell, Barbara. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Cavers, Debbie. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Buckingham, Susan. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom; Allergy and Respiratory Research Group, Centre for Population Health Sciences, The Usher Institute of Population Health Sciences & Informatics, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Boyd, Kirsty. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Grant, Liz. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Worth, Allison. Division of General Internal Medicine and Primary Care, Brigham and Women's Hospital/Harvard Medical School, Boston, Massachusetts, USA.
IN  - Pinnock, Hilary. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom; Allergy and Respiratory Research Group, Centre for Population Health Sciences, The Usher Institute of Population Health Sciences & Informatics, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom.
IN  - Sheikh, Aziz. Allergy and Respiratory Research Group, Centre for Population Health Sciences, The Usher Institute of Population Health Sciences & Informatics, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom; Wellcome Trust Clinical Research Facility Education Department, Western General Hospital, The University of Edinburgh, Edinburgh, Scotland, United Kingdom.
IN  - Murray, Scott A. Primary Palliative Care Research Group, Centre for Population Health Sciences, The University of Edinburgh, Medical School, Edinburgh, Scotland, United Kingdom. Electronic address: Scott.Murray@ed.ac.uk.
AB  - CONTEXT: Quality care for people living with life-limiting illnesses is a global priority. A detailed understanding of the varied experiences of people living and dying with different conditions and their family and professional caregivers should help policymakers and clinicians design and deliver more appropriate and person-centered care.
AB  - OBJECTIVES: To understand how patients with different advanced conditions and their family and professional caregivers perceive their deteriorating health and the services they need.
AB  - METHODS: We used a narrative framework to synthesize eight methodologically comparable, longitudinal, and multiperspective interview studies. We compared the end-of-life experiences of people dying from cancer (lung, glioma, and colorectal cancer), organ failure (heart failure, chronic obstructive pulmonary disease, and liver failure), and physical frailty and those of their family and professional caregivers in socioeconomically and ethnically diverse populations in Scotland.
AB  - RESULTS: The data set comprised 828 in-depth interviews with 156 patients, 114 family caregivers, and 170 health professionals. Narratives about cancer typically had a clear beginning, middle, and an anticipated end. Cancer patients gave a well-rehearsed account of their illness, hoping for recovery alongside fear of dying. In contrast, people with organ failure and their family caregivers struggled to pinpoint when their illness began, or to speak openly about death, hoping instead to avoid further deterioration. Frail older people tended to be frustrated by their progressive loss of independence, fearing dementia or nursing home admission more than dying.
AB  - CONCLUSION: These contrasting illness narratives affect and shape the experiences, thoughts, and fears of patients and their carers in the last months of life. Palliative care offered by generalists or specialists should be provided more flexibly and equitably, responding to the varied concerns and needs of people with different advanced conditions.

 Copyright © 2015 American Academy of Hospice and Palliative Medicine. Published by Elsevier Inc. All rights reserved.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25828558
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25828558&id=doi:10.1016%2Fj.jpainsymman.2015.02.017&issn=0885-3924&isbn=&volume=50&issue=2&spage=216&pages=216-24&date=2015&title=Journal+of+Pain+%26+Symptom+Management&atitle=Different+Experiences+and+Goals+in+Different+Advanced+Diseases%3A+Comparing+Serial+Interviews+With+Patients+With+Cancer%2C+Organ+Failure%2C+or+Frailty+and+Their+Family+and+Professional+Carers.&aulast=Kendall&pid=%3Cauthor%3EKendall+M%3C%2Fauthor%3E%3CAN%3E25828558%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<116. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25802097
TI  - Reflective writing: the student nurse's perspective on reflective writing and poetry writing.
SO  - Nurse Education Today. 35(7):906-11, 2015 Jul.
VI  - 1
ST  - MEDLINE
AU  - Coleman D
AU  - Willis DS
FA  - Coleman, Dawn
FA  - Willis, Diane S
IN  - Coleman, Dawn. University of Abertay, Dundee, United Kingdom. Electronic address: d.coleman@dundee.ac.uk.
IN  - Willis, Diane S. University of Glasgow, United Kingdom.
AB  - BACKGROUND: Reflective writing is a mandatory part of nurse education but how students develop their skills and use reflection as part of their experiential learning remains relatively unknown. Understanding reflective writing in all forms from the perspective of a student nurse is therefore important.
AB  - OBJECTIVES: To explore the use of reflective writing and the use of poetry in pre-registered nursing students.
AB  - DESIGN: A qualitative design was employed to explore reflective writing in pre-registered nursing students.
AB  - SETTING: A small university in Scotland.
AB  - PARTICIPANTS: BSc (Hons) Adult and Mental Health Pre-registration Student Nurses.
AB  - METHODS: Two focus groups were conducted with 10 student nurses during March 2012. Data was analysed thematically using the framework of McCarthy (1999).
AB  - RESULTS: Students found the process of reflective writing daunting but valued it over time. Current educational methods, such as assessing reflective accounts, often lead to the 'narrative' being watered down and the student feeling judged. Despite this, reflection made students feel responsible for their own learning and research on the topic. Some students felt the use of models of reflection constricting, whilst poetry freed up their expression allowing them to demonstrate the compassion for their patient under their care.
AB  - CONCLUSIONS: Poetry writing gives students the opportunity for freedom of expression, personal satisfaction and a closer connection with their patients, which the more formal approach to reflective writing did not offer. There is a need for students to have a safe and supportive forum in which to express and have their experiences acknowledged without the fear of being judged.

 Crown Copyright © 2015. Published by Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25802097
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25802097&id=doi:10.1016%2Fj.nedt.2015.02.018&issn=0260-6917&isbn=&volume=35&issue=7&spage=906&pages=906-11&date=2015&title=Nurse+Education+Today&atitle=Reflective+writing%3A+the+student+nurse%27s+perspective+on+reflective+writing+and+poetry+writing.&aulast=Coleman&pid=%3Cauthor%3EColeman+D%3C%2Fauthor%3E%3CAN%3E25802097%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<117. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25690196
TI  - Wales and Scotland gets much needed nurse training boost.
SO  - Nursing Standard. 29(25):12, 2015 Feb 20.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
AB  - There will be 305 extra nursing students trained in Wales and Scotland this year.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25690196
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25690196&id=doi:10.7748%2Fns.29.25.12.s14&issn=0029-6570&isbn=&volume=29&issue=25&spage=12&pages=12&date=2015&title=Nursing+Standard&atitle=Wales+and+Scotland+gets+much+needed+nurse+training+boost.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E25690196%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<118. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25682796
TI  - Making reasonable and achievable adjustments: the contributions of learning disability liaison nurses in 'Getting it right' for people with learning disabilities receiving general hospitals care.
SO  - Journal of Advanced Nursing. 71(7):1552-63, 2015 Jul.
VI  - 1
ST  - MEDLINE
AU  - MacArthur J
AU  - Brown M
AU  - McKechanie A
AU  - Mack S
AU  - Hayes M
AU  - Fletcher J
FA  - MacArthur, Juliet
FA  - Brown, Michael
FA  - McKechanie, Andrew
FA  - Mack, Siobhan
FA  - Hayes, Matthew
FA  - Fletcher, Joan
IN  - MacArthur, Juliet. Western General Hospital, Edinburgh, UK.
IN  - MacArthur, Juliet. Health Services Research Unit, Edinburgh, UK.
IN  - Brown, Michael. Edinburgh Napier University, UK.
IN  - Brown, Michael. NHS Lothian, Edinburgh, UK.
IN  - McKechanie, Andrew. NHS Lothian, Edinburgh, UK.
IN  - McKechanie, Andrew. The Patrick Wild Centre & The Division of Psychiatry, The University of Edinburgh, Royal Edinburgh Hospital, UK.
IN  - Mack, Siobhan. School of Health Sciences, Queen Margaret University, Musselburgh, UK.
IN  - Hayes, Matthew. NHS Lothian, Edinburgh, UK.
IN  - Fletcher, Joan. NHS Lothian, Edinburgh, UK.
AB  - AIMS: To examine the role of learning disability liaison nurses in facilitating reasonable and achievable adjustments to support access to general hospital services for people with learning disabilities.
AB  - DESIGN: Mixed methods study involving four health boards in Scotland with established Learning Disability Liaison Nurses (LDLN) Services. Quantitative data of all liaison nursing referrals over 18 months and qualitative data collected from stakeholders with experience of using the liaison services within the previous 3-6 months.
AB  - METHODS: Six liaison nurses collected quantitative data of 323 referrals and activity between September 2008-March 2010. Interviews and focus groups were held with 85 participants included adults with learning disabilities (n = 5), carers (n = 16), primary care (n = 39), general hospital (n = 19) and liaison nurses (n = 6).
AB  - RESULTS/FINDINGS: Facilitating reasonable and achievable adjustments was an important element of the LDLNs' role and focussed on access to information; adjustments to care; appropriate environment of care; ensuring equitable care; identifying patient need; meeting patient needs; and specialist tools/resources.
AB  - CONCLUSION: Ensuring that reasonable adjustments are made in the general hospital setting promotes person-centred care and equal health outcomes for people with a learning disability. This view accords with 'Getting it right' charter produced by the UK Charity Mencap which argues that healthcare professionals need support, encouragement and guidance to make reasonable adjustments for this group. LDLNs have an important and increasing role to play in advising on and establishing adjustments that are both reasonable and achievable.

 Copyright © 2015 John Wiley & Sons Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25682796
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25682796&id=doi:10.1111%2Fjan.12629&issn=0309-2402&isbn=&volume=71&issue=7&spage=1552&pages=1552-63&date=2015&title=Journal+of+Advanced+Nursing&atitle=Making+reasonable+and+achievable+adjustments%3A+the+contributions+of+learning+disability+liaison+nurses+in+%27Getting+it+right%27+for+people+with+learning+disabilities+receiving+general+hospitals+care.&aulast=MacArthur&pid=%3Cauthor%3EMacArthur+J%3C%2Fauthor%3E%3CAN%3E25682796%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<119. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25651283
TI  - Development and early application of the Scottish Community Nursing Workload Measurement Tool.
SO  - British Journal of Community Nursing. 20(2):89-92, 2015 Feb.
VI  - 1
ST  - MEDLINE
AU  - Grafen M
AU  - Mackenzie FC
FA  - Grafen, May
FA  - Mackenzie, Fiona C
IN  - Grafen, May. Workload Programme Advisor, Nursing and Midwifery Workload and Workforce Planning Programme, c/o Directorate for Chief Nursing Officer, Patients, Public and Health Professions.
AB  - This article describes the development and early application of the Scottish Community Nursing Workload Measurement Tool, part of a suite of tools aiming to ensure a consistent approach to measuring nursing workload across NHS Scotland. The tool, which enables community nurses to record and report their actual workload by collecting information on six categories of activity, is now being used by all NHS boards as part of a triangulated approach. Data being generated by the tool at national level include indications that approximately 50% of band 6 district nurses' time is spent in face-to-face and non-face-to-face contact and planned sessions with patients, and that over 60% of face-to-face contacts are at 'moderate' and 'complex' levels of intervention (2012 data). These data are providing hard evidence of key elements of community nursing activity and practice that will enable informed decisions about workforce planning to be taken forward locally and nationally. The article features an account of the early impact of the tool's implementation in an NHS board by an associate director of nursing. Positive effects from implementation include the generation of reliable data to inform planning decisions, identification of issues around nursing time spent on administrative tasks, clarification of school nursing roles, and information being fed back to teams on various aspects of performance.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25651283
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25651283&id=doi:10.12968%2Fbjcn.2015.20.2.89&issn=1462-4753&isbn=&volume=20&issue=2&spage=89&pages=89-92&date=2015&title=British+Journal+of+Community+Nursing&atitle=Development+and+early+application+of+the+Scottish+Community+Nursing+Workload+Measurement+Tool.&aulast=Grafen&pid=%3Cauthor%3EGrafen+M%3C%2Fauthor%3E%3CAN%3E25651283%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<120. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25467717
TI  - Working with the disabled patient: exploring student nurses views for curriculum development using a SWOT analysis.
SO  - Nurse Education Today. 35(2):383-7, 2015 Feb.
VI  - 1
ST  - MEDLINE
AU  - Willis DS
AU  - Thurston M
FA  - Willis, Diane S
FA  - Thurston, Mhairi
IN  - Willis, Diane S. Nursing Health Care, University of Glasgow, 57-61 Oakfield Avenue, Glasgow G12 8LL, United Kingdom. Electronic address: diane.willis@glasgow.ac.uk.
IN  - Thurston, Mhairi. Nursing and Counselling, Abertay University, Kydd Building, 1-3 Bell Street, Dundee, DD1 1HD, United Kingdom. Electronic address: m.thurston@abertay.ac.uk.
AB  - BACKGROUND: Increased longevity will mean an increase in people presenting with cognitive and physical disabilities, such as sight loss or dementia. The Patient Rights (Scotland) Act 2011 states that health care should be patient-focussed, taking into account patient needs. This will necessitate nursing curricula to reflect the needs of people who have disabilities and equip the future workforce with knowledge and skills to provide appropriate care. This study explores student nurses' strengths and weakness when working with people with disabilities and identifies opportunities and threats to developing their knowledge and skills to meet the needs of this population.
AB  - METHODS: As part of a study day, students from the year one Nursing programme were asked to take part in a SWOT analysis and post comments under the categories: strengths, weakness, opportunity and threats on a central wall about working with people with disabilities.
AB  - RESULTS: Students acknowledged some of the challenges of being disabled especially in a health setting but also believed they were developing their skills to provide holistic care that ensured autonomy. Communication was viewed as both a strength and weakness and was identified as an essential skill to working effectively with people who had a disability. Students acknowledged that clinical staff were not always experts in working with people who were disabled and welcomed the opportunity to work with experts and clients as well as being directed to resources to increase their knowledge.
AB  - CONCLUSIONS: Integration of disability into the nursing curriculum is needed to ensure students have awareness of and the confidence to work effectively with people who have a range of cognitive and physical disabilities alongside other medical problems.

 Copyright © 2014 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=25467717
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25467717&id=doi:10.1016%2Fj.nedt.2014.10.013&issn=0260-6917&isbn=&volume=35&issue=2&spage=383&pages=383-7&date=2015&title=Nurse+Education+Today&atitle=Working+with+the+disabled+patient%3A+exploring+student+nurses+views+for+curriculum+development+using+a+SWOT+analysis.&aulast=Willis&pid=%3Cauthor%3EWillis+DS%3C%2Fauthor%3E%3CAN%3E25467717%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<121. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23895504
TI  - Professional role identity in shaping community nurses' reactions to nursing policy.
SO  - Journal of Nursing Management. 23(4):459-67, 2015 May.
VI  - 1
ST  - MEDLINE
AU  - Elliott L
AU  - Kennedy C
AU  - Raeside R
FA  - Elliott, Lawrie
FA  - Kennedy, Catriona
FA  - Raeside, Robert
IN  - Elliott, Lawrie. School of Nursing Midwifery and Social Care, Edinburgh Napier University, Edinburgh, Scotland, UK.
AB  - AIM: To establish the extent to which professional role identity shapes community nurses' reactions before the implementation of a policy that sought to introduce a generic role.
AB  - BACKGROUND: Many countries seek to alter community nurse roles to address changes in population health and health workforce. We know little about the influences that might shape nurses' reaction to these policies before their implementation and our theoretical understanding is poorly developed at this point in the policy-making cycle.
AB  - METHOD: Self completed cross-sectional survey of 703 community nurses before the introduction of a generic Community Health Nurse role in Scotland.
AB  - RESULT: The minority (33%) supported the new role. The professional role identity of those who were supportive differed significantly from those who did not support the policy or were uncertain of it.
AB  - CONCLUSION: It is possible that the new policy acted to increase the value of the professional role identity of those who were supportive and conversely devalued the professional role identity of those who were unsupportive or uncertain of it.
AB  - IMPLICATIONS: Professional role identity should be considered by policy makers in any country seeking to introduce policies that aim to radically change the role of community nurses and that this is acknowledged at an early stage in the policy-making cycle.

 Copyright © 2013 The Authors. Journal of Nursing Management published by John Wiley & Sons Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med12&AN=23895504
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23895504&id=doi:10.1111%2Fjonm.12153&issn=0966-0429&isbn=&volume=23&issue=4&spage=459&pages=459-67&date=2015&title=Journal+of+Nursing+Management&atitle=Professional+role+identity+in+shaping+community+nurses%27+reactions+to+nursing+policy.&aulast=Elliott&pid=%3Cauthor%3EElliott+L%3C%2Fauthor%3E%3CAN%3E23895504%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<122. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25526290
TI  - Improving family carers' experiences of support at the end of life by enhancing communication: an action research study.
SO  - International Journal of Palliative Nursing. 20(12):608-16, 2014 Dec.
VI  - 1
ST  - MEDLINE
AU  - Dosser I
AU  - Kennedy C
FA  - Dosser, Isabel
FA  - Kennedy, Catriona
IN  - Dosser, Isabel. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, Sighthill Campus Sightill Court, Edinburgh, Scotland, UK.
AB  - BACKGROUND: This paper builds on findings from phase one of a participatory action research study, which investigated support for family carers at the end of life in an acute hospital setting in Scotland, UK ( Dosser and Kennedy, 2012 ). The research presented here is the second phase of the participatory action research study, in which nursing staff from an acute hospital ward are involved in ongoing analysis of data and ideas guided by action cycles and reflection.
AB  - METHODS: Two key change initiatives are reported; improving nurses' communication skills and improving the environment for family carers of loved ones at the end of life within the acute hospital setting. To address these points, nurses were enrolled on a communications skills course, and a new room for family carers was integrated into the hospital.
AB  - RESULTS: Data were analysed from interviews and questionnaires with the nurses, and from insights gathered in a reflective diary taken by the researcher. The changes implemented improved the confidence of participants in communicating with carers as well as patients and colleagues.
AB  - CONCLUSION: The findings highlight practical strategies and communication issues that can potentially impact on the grief experience of family carers, such as having a safe space nearby to rest in private, away from the bedside.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25526290
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25526290&id=doi:10.12968%2Fijpn.2014.20.12.608&issn=1357-6321&isbn=&volume=20&issue=12&spage=608&pages=608-16&date=2014&title=International+Journal+of+Palliative+Nursing&atitle=Improving+family+carers%27+experiences+of+support+at+the+end+of+life+by+enhancing+communication%3A+an+action+research+study.&aulast=Dosser&pid=%3Cauthor%3EDosser+I%3C%2Fauthor%3E%3CAN%3E25526290%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<123. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25467361
TI  - Better documentation improves patient care.
SO  - Nursing Standard. 29(14):44-51, 2014 Dec 09.
VI  - 1
ST  - MEDLINE
AU  - Kent P
AU  - Morrow K
FA  - Kent, Patricia
FA  - Morrow, Karen
IN  - Kent, Patricia. Documentation, Practice Development Centre, NHS Lanarkshire, Hamilton, Scotland.
AB  - This article is the sixth in a series of seven describing the journey within NHS Lanarkshire in partnership with the University of the West of Scotland to support nursing and midwifery leadership roles through Scotland's Leading Better Care programme. Preceding articles have provided an overview of the programme and discussed a range of staff development work programmes. This article describes work carried out on clinical documentation to promote delivery of the three quality ambitions of safe, effective and person-centred care.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25467361
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25467361&id=doi:10.7748%2Fns.29.14.44.e9267&issn=0029-6570&isbn=&volume=29&issue=14&spage=44&pages=44-51&date=2014&title=Nursing+Standard&atitle=Better+documentation+improves+patient+care.&aulast=Kent&pid=%3Cauthor%3EKent+P%3C%2Fauthor%3E%3CAN%3E25467361%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<124. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25424111
TI  - Developing healthcare support workers.
SO  - Nursing Standard. 29(13):44-51, 2014 Dec 02.
VI  - 1
ST  - MEDLINE
AU  - Brown J
AU  - McMurray J
FA  - Brown, Jacqueline
FA  - McMurray, Julia
IN  - Brown, Jacqueline. NMAHP Practice Development Centre, NHS Lanarkshire, Hamilton, Scotland.
AB  - This article the fifth in a series of seven, describes the measures taken by one health board in Scotland to enhance nursing and midwifery leadership. In NHS Lanarkshire, the Leading Better Care Programme was implemented locally by engaging all members of the nursing and midwifery teams, including healthcare support workers (HCSWs). This article discusses how NHS Lanarkshire is developing its HCSW workforce in response to recommendations in the Final Report of the Mid Staffordshire NHS Foundation Trust Public Inquiry and other relevant national initiatives. HCSWs provide vital care to patients, but are unregulated and, at present, there are no UK-wide agreed standards for training and development. The article includes an overview of a scoping exercise to identify training and development undertaken by HCSWs.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25424111
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25424111&id=doi:10.7748%2Fns.29.13.44.e9120&issn=0029-6570&isbn=&volume=29&issue=13&spage=44&pages=44-51&date=2014&title=Nursing+Standard&atitle=Developing+healthcare+support+workers.&aulast=Brown&pid=%3Cauthor%3EBrown+J%3C%2Fauthor%3E%3CAN%3E25424111%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<125. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25351093
TI  - Developing leadership roles in nursing and midwifery.
SO  - Nursing Standard. 29(9):43-9, 2014 Nov 04.
VI  - 1
ST  - MEDLINE
AU  - McGuire C
AU  - Ray D
FA  - McGuire, Clare
FA  - Ray, Devashish
IN  - McGuire, Clare. Leading Better Care, University of the West of Scotland, Hamilton, Lanarkshire.
AB  - This article is the first in a series of seven articles on an initiative undertaken in NHS Lanarkshire where a creative partnership with the University of the West of Scotland established a shared commitment to developing nursing and midwifery leadership. This article describes the national context within Scotland. It provides an overview of the innovative programmes of work and systems devised to support leadership throughout the organisation with a particular focus on quality of care.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25351093
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25351093&id=doi:10.7748%2Fns.29.9.43.e9034&issn=0029-6570&isbn=&volume=29&issue=9&spage=43&pages=43-9&date=2014&title=Nursing+Standard&atitle=Developing+leadership+roles+in+nursing+and+midwifery.&aulast=McGuire&pid=%3Cauthor%3EMcGuire+C%3C%2Fauthor%3E%3CAN%3E25351093%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<126. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25289609
TI  - Wales and Scotland see fall in number of children's nurses.
SO  - Nursing Children and Young People. 26(8):6, 2014 Oct.
VI  - 1
ST  - MEDLINE
AU  - Anonymous
AB  - WHILE THERE has been an increase in commissioned children's nursing training places across the UK since 2013/14, the number of children's nurses in Wales and Scotland has fallen, government figures show.
PT  - News
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25289609
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25289609&id=doi:10.7748%2Fncyp.26.8.6.s2&issn=2046-2336&isbn=&volume=26&issue=8&spage=6&pages=6&date=2014&title=Nursing+Children+and+Young+People&atitle=Wales+and+Scotland+see+fall+in+number+of+children%27s+nurses.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E25289609%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<127. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25286454
TI  - Bioelectrical impedance analysis is more accurate than clinical examination in determining the volaemic status of elderly patients with fragility fracture and hyponatraemia.
SO  - Journal of Nutrition, Health & Aging. 18(8):744-50, 2014.
VI  - 1
ST  - MEDLINE
AU  - Cumming K
AU  - Hoyle GE
AU  - Hutchison JD
AU  - Soiza RL
FA  - Cumming, K
FA  - Hoyle, G E
FA  - Hutchison, J D
FA  - Soiza, R L
IN  - Cumming, K. Dr Roy L Soiza, c/o Wards 11/12, Aberdeen Royal Infirmary, Foresterhill, Aberdeen, AB25 2ZN, tel: 00 44 1224 558109; e-mail: roy.soiza@nhs.net.
AB  - OBJECTIVES: Management of hyponatraemia depends crucially on accurate determination of volaemic (hydration) status but this is notoriously challenging to measure in older people. Bioelectrical impedance analysis (BIA) provides a validated means of determining total body water (TBW), but its clinical utility in determining volaemic status in hyponatraemia has never been tested. This study assessed the utility of BIA in the clinical management of hyponatraemia in elderly patients with fragility fractures (EPFF), a group at high risk of hyponatraemia.
AB  - DESIGN: Prospective observational study of consenting patients >=65 years with fragility fractures (N=127).
AB  - SETTING: University teaching hospital in Scotland.
AB  - PARTICIPANTS: Patients >=665 years with fragility fractures with capacity to consent to participation.
AB  - MEASUREMENTS: BIA and standard clinical examination procedures (jugular venous distension, skin turgor, mouth and axillary moistness, peripheral oedema, capillary refill time, overall impression) were performed daily throughout each participant's hospital stay. Volaemic status of hyponatraemia was determined by an expert panel using clinical data (history, examination, nursing observations and laboratory tests) blinded to TBW readings. Cohen's kappa was calculated to assess the level of agreement between the expert panel and both BIA and standard clinical examination measures in determining the volaemic state of hyponatraemia.
AB  - RESULTS: 26/33 (79%) cases of hyponatraemia had sufficient clinical information to allow determination of volaemic status by BIA. There was moderate level of agreement between BIA and the expert panel, kappa 0.52 (p<.001). All kappa values for standard clinical assessments of volaemic status neared zero, indicating nil to slight agreement.
AB  - CONCLUSION: BIA outperformed all aspects of the standard clinical examination in determining the volaemic status of hyponatraemic EPFF, suggesting it may be useful in clinical practice.
PT  - Comparative Study
PT  - Journal Article
PT  - Observational Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25286454
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25286454&id=doi:10.1007%2Fs12603-014-0446-z&issn=1279-7707&isbn=&volume=18&issue=8&spage=744&pages=744-50&date=2014&title=Journal+of+Nutrition%2C+Health+%26+Aging&atitle=Bioelectrical+impedance+analysis+is+more+accurate+than+clinical+examination+in+determining+the+volaemic+status+of+elderly+patients+with+fragility+fracture+and+hyponatraemia.&aulast=Cumming&pid=%3Cauthor%3ECumming+K%3C%2Fauthor%3E%3CAN%3E25286454%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<128. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25062378
TI  - Palliative care staff's perceptions of do not attempt cardiopulmonary resuscitation discussions.
SO  - International Journal of Palliative Nursing. 20(7):327-33, 2014 Jul.
VI  - 1
ST  - MEDLINE
AU  - Low C
AU  - Finucane A
AU  - Mason B
AU  - Spiller J
FA  - Low, Catherine
FA  - Finucane, Anne
FA  - Mason, Bruce
FA  - Spiller, Juliet
IN  - Low, Catherine. fifth-year medical student, University of Edinburgh, Scotland.
AB  - BACKGROUND: Do not attempt cardiopulmonary resuscitation (DNACPR) decisions aim to prevent unwanted and/or clinically inappropriate CPR attempts. As the NHS Scotland DNACPR policy has become embedded into clinical practice there has been greater awareness of the need to discuss DNACPR decisions with patients who would not benefit from CPR; however, little is known about how nursing and medical staff experience these discussions.
AB  - AIM: This study aimed to explore clinician experiences of discussing DNACPR decisions with patients in a Scottish specialist palliative care inpatient and community setting.
AB  - METHOD: Semi-structured face-to-face interviews were held with 11 specialist palliative care clinicians. These were transcribed and thematic analysis was undertaken.
AB  - RESULTS: The clinicians found DNACPR discussions challenging and experienced anxiety before discussions took place. They found it most appropriate to discuss DNACPR in the context of wider end-of-life discussions and in response to patient triggers. Patient-clinician relationships were complex and could make the conversation easier or more difficult. Negative patient reactions were rare and discussions were thought to provide some patients with a sense of relief.
AB  - CONCLUSION: The clinicians reported finding DNACPR discussions worthwhile and that they continue to discuss DNACPR decisions with patients despite the challenges. Recommendations for discussing DNACPR with patients are outlined.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25062378
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25062378&id=doi:10.12968%2Fijpn.2014.20.7.327&issn=1357-6321&isbn=&volume=20&issue=7&spage=327&pages=327-33&date=2014&title=International+Journal+of+Palliative+Nursing&atitle=Palliative+care+staff%27s+perceptions+of+do+not+attempt+cardiopulmonary+resuscitation+discussions.&aulast=Low&pid=%3Cauthor%3ELow+C%3C%2Fauthor%3E%3CAN%3E25062378%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<129. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25004034
TI  - Scotland faces questions over restructuring health workforce.
SO  - Nursing Children and Young People. 26(6):8-9, 2014 Jul.
VI  - 1
ST  - MEDLINE
AU  - Triggle N
FA  - Triggle, Nick
AB  - The past few years have been a period of flux for nurses working to improve the health of children in Scotland. But 2013 is likely to go down as a watershed. Indeed, you could say it was the year that health visiting and school nursing was reborn.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=25004034
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25004034&id=doi:10.7748%2Fncyp.26.6.8.s9&issn=2046-2336&isbn=&volume=26&issue=6&spage=8&pages=8-9&date=2014&title=Nursing+Children+and+Young+People&atitle=Scotland+faces+questions+over+restructuring+health+workforce.&aulast=Triggle&pid=%3Cauthor%3ETriggle+N%3C%2Fauthor%3E%3CAN%3E25004034%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<130. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24822383
TI  - Values-based training for mental health nurses.
SO  - Nursing Times. 110(15):22-4, 2014 Apr 9-15.
VI  - 1
ST  - MEDLINE
AU  - Lamza C
AU  - Smith P
FA  - Lamza, Claire
FA  - Smith, Paul
AB  - A pilot programme successfully engaged large numbers of people in discussing and challenging the competing values that underpin mental health nursing practice. This was followed by a recommendation that using a values-based approach to mental health nursing improved interpersonal relationships between staff and patients and carers. This article reports the responses of mental health nurses at two health boards (NHS Fife and NHS Forth Valley) to a values-based training programme using the 10 Essential Shared Capabilities, developed by the Scottish Government and NHS Education for Scotland.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24822383
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24822383&id=doi:&issn=0954-7762&isbn=&volume=110&issue=15&spage=22&pages=22-4&date=2014&title=Nursing+Times&atitle=Values-based+training+for+mental+health+nurses.&aulast=Lamza&pid=%3Cauthor%3ELamza+C%3C%2Fauthor%3E%3CAN%3E24822383%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<131. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24802918
TI  - Ensuring standards for the extended role of optometry.
SO  - The clinical teacher. 11(3):184-7, 2014 Jun.
VI  - 1
ST  - MEDLINE
AU  - Jarvis I
AU  - Ker J
FA  - Jarvis, Ian
FA  - Ker, Jean
IN  - Jarvis, Ian. Clinical Skills Centre, University of Dundee, Ninewells Hospital & Medical School, Dundee, UK.
AB  - BACKGROUND: In optometry, as in other health professions, such as pharmacy and nursing, there has been an expansion in the role of the optometrist in primary eye care, taking on aspects of care such as prescribing, which was traditionally undertaken by general practitioners. In optometry, this extended role involves monitoring eye conditions that do not require treatment or monitoring in secondary care, roles that were traditionally referred on. However, any extended role requires educational support. The development of a national educational programme can prevent any duplication of effort and provide a system of disseminating support to practitioners, who often work in isolation.
AB  - CONTEXT: The National Education Programme was developed and supported by the National Health Service (NHS) Education for Scotland (NES). This a national body responsible for supporting NHS services in Scotland, by developing and delivering education and training for those who work in NHS Scotland.
AB  - INNOVATION: Optometrists were given educational support in three main stages: simulation of component skills; safe learning in a simulated health care context; and support for the transfer of those skills to practice, including the use of mentoring via e-mail. The evaluation of this three-stage process has been positive.
AB  - IMPLICATIONS: To further develop any expanded role in health care practice, safe guidelines for practice are required. Simulation can provide support at the start of this process in setting standards. However, mentorship in the practice area, as reported in this study, was required to embed newly acquired skills.

 Copyright © 2014 John Wiley & Sons Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24802918
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24802918&id=doi:10.1111%2Ftct.12101&issn=1743-4971&isbn=&volume=11&issue=3&spage=184&pages=184-7&date=2014&title=The+clinical+teacher&atitle=Ensuring+standards+for+the+extended+role+of+optometry.&aulast=Jarvis&pid=%3Cauthor%3EJarvis+I%3C%2Fauthor%3E%3CAN%3E24802918%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<132. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24784556
TI  - Using a complex audit tool to measure workload, staffing and quality in district nursing.
SO  - British Journal of Community Nursing. 19(5):219-23, 2014 May.
VI  - 1
ST  - MEDLINE
AU  - Kirby E
AU  - Hurst K
FA  - Kirby, Esther
FA  - Hurst, Keith
IN  - Kirby, Esther. Deputy Director of Nursing, Quality and Patient Experience, Cumbria Partnership NHS Foundation Trust.
IN  - Hurst, Keith. Independent Analyst, Nottinghamshire.
AB  - This major community, workload, staffing and quality study is thought to be the most comprehensive community staffing project in England. It involved over 400 staff from 46 teams in 6 localities and is unique because it ties community staffing activity to workload and quality. Scotland was used to benchmark since the same evidence-based Safer Nursing Care Tool methodology developed by the second-named author was used (apart from quality) and took into account population and geographical similarities. The data collection method tested quality standards, acuity, dependency and nursing interventions by looking at caseloads, staff activity and service quality and funded, actual, temporary and recommended staffing. Key findings showed that 4 out of 6 localities had a heavy workload index that stretched staffing numbers and time spent with patients. The acuity and dependency of patients leaned heavily towards the most dependent and acute categories requiring more face-to-face care. Some areas across the localities had high levels of temporary staff, which affected quality and increased cost. Skill and competency shortages meant that a small number of staff had to travel significantly across the county to deliver complex care to some patients.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24784556
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24784556&id=doi:10.12968%2Fbjcn.2014.19.5.219&issn=1462-4753&isbn=&volume=19&issue=5&spage=219&pages=219-23&date=2014&title=British+Journal+of+Community+Nursing&atitle=Using+a+complex+audit+tool+to+measure+workload%2C+staffing+and+quality+in+district+nursing.&aulast=Kirby&pid=%3Cauthor%3EKirby+E%3C%2Fauthor%3E%3CAN%3E24784556%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<133. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24614807
TI  - Pro-donation behaviours of nursing students from the four countries of the UK.
SO  - PLoS ONE [Electronic Resource]. 9(3):e91405, 2014.
VI  - 1
ST  - MEDLINE
AU  - McGlade D
AU  - McClenahan C
AU  - Pierscionek B
FA  - McGlade, Donal
FA  - McClenahan, Carol
FA  - Pierscionek, Barbara
IN  - McGlade, Donal. Faculty of Science, Engineering and Computing, Kingston University London, Kingston upon Thames, England, United Kingdom.
IN  - McClenahan, Carol. School of Psychology, University of Ulster, Coleraine, Northern Ireland, United Kingdom.
IN  - Pierscionek, Barbara. Faculty of Science, Engineering and Computing, Kingston University London, Kingston upon Thames, England, United Kingdom.
AB  - BACKGROUND: The effectiveness of the organ donation system depends on the health professionals involved in procurement and in dealing with donors and their families. Concerns about lack of knowledge and experience of organ donation have been expressed among such professionals but there is a paucity of literature to indicate the basis of such concerns and where knowledge may be lacking. Given that regional variations in organ donation rates exist in the UK, this study investigates knowledge about and attitudes towards organ donation among student nurses in different countries of the UK and examines regional variations.
AB  - METHODS: A questionnaire was distributed to 667 student nurses (female:male = 582:85) aged 18 to 50 years (mean [SD] 25.4 [7.1] years) recruited from a total of five Universities (Scotland, Wales, Northern Ireland, England) during the period of January to September 2011.
AB  - RESULTS: Registration behaviour among participants was shown to vary depending upon many different factors that include birthplace, residency, fear of death and concerns of medical distrust.
AB  - CONCLUSIONS: Regional variations in organ donation behaviour in the UK were found in the cohorts of student nurses who participated in this study. These variations include willingness to register and to donate specific body parts and not others. The relationship between attitude and behaviour and how this may influence the decision making process of organ donation, as well as the underlying factors that result in regional variations, require further investigation.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24614807
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24614807&id=doi:10.1371%2Fjournal.pone.0091405&issn=1932-6203&isbn=&volume=9&issue=3&spage=e91405&pages=e91405&date=2014&title=PLoS+ONE+%5BElectronic+Resource%5D&atitle=Pro-donation+behaviours+of+nursing+students+from+the+four+countries+of+the+UK.&aulast=McGlade&pid=%3Cauthor%3EMcGlade+D%3C%2Fauthor%3E%3CAN%3E24614807%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<134. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24612885
TI  - Sadness, socialisation and shifted perceptions: school pupils' stories of a pre-nursing scholarship.
SO  - Nurse Education Today. 34(6):894-8, 2014 Jun.
VI  - 1
ST  - MEDLINE
AU  - Beattie M
AU  - Smith A
AU  - Kyle RG
FA  - Beattie, Michelle
FA  - Smith, Annetta
FA  - Kyle, Richard G
IN  - Beattie, Michelle. School of Nursing, Midwifery and Health, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness IV2 3JH, UK. Electronic address: michelle.beattie@stir.ac.uk.
IN  - Smith, Annetta. School of Nursing, Midwifery and Health, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness IV2 3JH, UK.
IN  - Kyle, Richard G. School of Nursing, Midwifery and Health, University of Stirling (Highland Campus), Centre for Health Science, Old Perth Road, Inverness IV2 3JH, UK.
AB  - BACKGROUND: Providing opportunities for aspirant nurses to obtain pre-nursing experience features prominently in the UK Government's response to The Francis Inquiry. Evidence from the USA suggests that pre-nursing experiences, such as summer camps, have the potential to contribute to effective nurse recruitment, selection and retention strategies. However, few similar pre-nursing experiences exist in the UK, and none have been evaluated. This paper reports the experiences of participation in a pilot pre-nursing scholarship among secondary school pupils in Scotland.
AB  - OBJECTIVES: To explore pupils' experiences of a pre-nursing scholarship to inform future design and delivery of similar programmes in the UK and internationally.
AB  - DESIGN: Qualitative focus group study.
AB  - SETTINGS: Two university campuses in Scotland.
AB  - PARTICIPANTS: Twenty-two secondary school students (all female, aged 15-18 years).
AB  - METHODS: Two focus groups were facilitated through the use of 'anecdote circles' to elicit pupils' stories of their scholarship experience. Anecdote circles allowed each pupil to share their story in turn and then collectively assemble, figuratively and physically through interlocking written cards, shared stories of the scholarship. Discussions were audio recorded and transcribed verbatim. Data were analysed thematically.
AB  - RESULTS: Three stories emerged: 1) sadness; 2) socialisation; and, 3) shifted perceptions. Sad stories were transformative affirming the pupils' desire to become a nurse. Stories of socialisation revealed how demonstrating practical skills affirmed the pupils' ability and suitability to nurse. Perceptions of the life and work of a (student) nurse, their future career, and the lives of older adults, shifted through the scholarship, especially during practice learning experience.
AB  - CONCLUSIONS: Storytelling revealed how a pre-nursing scholarship helped secondary school pupils to decide whether to pursue a nursing career by providing an opportunity to explore their ability, suitability and desire for nursing. The practice learning experience emerged as an important element of this decision-making process and should be integrated into similar pre-nursing experiences.

 Copyright © 2014 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24612885
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24612885&id=doi:10.1016%2Fj.nedt.2014.01.016&issn=0260-6917&isbn=&volume=34&issue=6&spage=894&pages=894-8&date=2014&title=Nurse+Education+Today&atitle=Sadness%2C+socialisation+and+shifted+perceptions%3A+school+pupils%27+stories+of+a+pre-nursing+scholarship.&aulast=Beattie&pid=%3Cauthor%3EBeattie+M%3C%2Fauthor%3E%3CAN%3E24612885%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<135. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24593040
TI  - Phenotyping community-acquired pneumonia according to the presence of acute respiratory failure and severe sepsis.
SO  - Respiratory Research. 15:27, 2014 Mar 04.
VI  - 1
ST  - MEDLINE
AU  - Aliberti S
AU  - Brambilla AM
AU  - Chalmers JD
AU  - Cilloniz C
AU  - Ramirez J
AU  - Bignamini A
AU  - Prina E
AU  - Polverino E
AU  - Tarsia P
AU  - Pesci A
AU  - Torres A
AU  - Blasi F
AU  - Cosentini R
FA  - Aliberti, Stefano
FA  - Brambilla, Anna Maria
FA  - Chalmers, James D
FA  - Cilloniz, Catia
FA  - Ramirez, Julio
FA  - Bignamini, Angelo
FA  - Prina, Elena
FA  - Polverino, Eva
FA  - Tarsia, Paolo
FA  - Pesci, Alberto
FA  - Torres, Antoni
FA  - Blasi, Francesco
FA  - Cosentini, Roberto
IN  - Blasi, Francesco. Department of Pathophysiology and Transplantation, IRCCS Fondazione Ca' Granda Ospedale Maggiore Policlinico, University of Milan, Via F, Sforza 35, Milan, Italy. francesco.blasi@unimi.it.
AB  - BACKGROUND: Acute respiratory failure (ARF) and severe sepsis (SS) are possible complications in patients with community-acquired pneumonia (CAP). The aim of the study was to evaluate prevalence, characteristics, risk factors and impact on mortality of hospitalized patients with CAP according to the presence of ARF and SS on admission.
AB  - METHODS: This was a multicenter, observational, prospective study of consecutive CAP patients admitted to three hospitals in Italy, Spain, and Scotland between 2008 and 2010. Three groups of patients were identified: those with neither ARF nor SS (Group A), those with only ARF (Group B) and those with both ARF and SS (Group C) on admission.
AB  - RESULTS: Among the 2,145 patients enrolled, 45% belonged to Group A, 36% to Group B and 20% to Group C. Patients in Group C were more severe than patients in Group B. Isolated ARF was correlated with age (p < 0.001), COPD (p < 0.001) and multilobar infiltrates (p < 0.001). The contemporary occurrence of ARF and SS was associated with age (p = 0.002), residency in nursing home (p = 0.007), COPD (p < 0.001), multilobar involvement (p < 0.001) and renal disease (p < 0.001). 4.2% of patients in Group A died, 9.3% in Group B and 26% in Group C, p < 0.001. After adjustment, the presence of only ARF had an OR for in-hospital mortality of 1.85 (p = 0.011) and the presence of both ARF and SS had an OR of 6.32 (p < 0.001).
AB  - CONCLUSIONS: The identification of ARF and SS on hospital admission can help physicians in classifying CAP patients into three different clinical phenotypes.
PT  - Journal Article
PT  - Multicenter Study
PT  - Observational Study
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24593040
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24593040&id=doi:10.1186%2F1465-9921-15-27&issn=1465-9921&isbn=&volume=15&issue=1&spage=27&pages=27&date=2014&title=Respiratory+Research&atitle=Phenotyping+community-acquired+pneumonia+according+to+the+presence+of+acute+respiratory+failure+and+severe+sepsis.&aulast=Aliberti&pid=%3Cauthor%3EAliberti+S%3C%2Fauthor%3E%3CAN%3E24593040%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<136. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24576249
TI  - Attitudes towards caring for older people in Scotland, Sweden and the United States.
SO  - Nursing Older People. 26(2):33-40, 2014 Mar.
VI  - 1
ST  - MEDLINE
AU  - Kydd A
AU  - Touhy T
AU  - Newman D
AU  - Fagerberg I
AU  - Engstrom G
FA  - Kydd, Angela
FA  - Touhy, Theris
FA  - Newman, David
FA  - Fagerberg, Ingegerd
FA  - Engstrom, Gabriella
IN  - Kydd, Angela. Institute of Older Persons' Health and Wellbeing, School of Health, Nursing and Midwifery, University of the West of Scotland, Hamilton.
AB  - AIM: To explore the attitudes of nurses and nursing students in Scotland, Sweden and the US towards working with older people.
AB  - METHOD: This quantitative study used the 20-item Multifactorial Attitudes Questionnaire (MAQ) to elicit attitudes on ageism, resources, working environment, education and professional esteem. Researchers from each country distributed the questionnaires to nursing students and nurses, giving a convenience sample of 1,587 respondents. Data were entered on the Statistical Package for Social Sciences version 18 and merged into one large dataset.
AB  - RESULTS: Scottish participants had the highest (positive) and Swedish participants the lowest mean MAQ score. The Kruskal-Wallis test showed significant differences in mean scores across the countries in 18 of the 20 statements, even when controlling for age and experience. Most participants gave positive responses, but agreed that negative attitudes towards working with older people pervade among peers due to working conditions, poor career prospects and a perceived lack of professional esteem.
AB  - CONCLUSION: Inspirational educators, excellent clinical placements and increasing the professional esteem of those working with older people are required to promote the specialty as an attractive career option.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24576249
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24576249&id=doi:10.7748%2Fnop2014.02.26.2.33.e547&issn=1472-0795&isbn=&volume=26&issue=2&spage=33&pages=33-40&date=2014&title=Nursing+Older+People&atitle=Attitudes+towards+caring+for+older+people+in+Scotland%2C+Sweden+and+the+United+States.&aulast=Kydd&pid=%3Cauthor%3EKydd+A%3C%2Fauthor%3E%3CAN%3E24576249%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<137. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24480095
TI  - Action learning sets in a nursing and midwifery practice learning context: a realistic evaluation.
SO  - Nurse Education in Practice. 14(4):410-6, 2014 Aug.
VI  - 1
ST  - MEDLINE
AU  - Machin AI
AU  - Pearson P
FA  - Machin, Alison I
FA  - Pearson, Pauline
IN  - Machin, Alison I. Faculty of Health and Life Sciences, Northumbria University, England, UK. Electronic address: alison.machin@northumbria.ac.uk.
IN  - Pearson, Pauline. Faculty of Health and Life Sciences, Northumbria University, England, UK. Electronic address: pauline.pearson@northumbria.ac.uk.
AB  - Action learning sets (ALS) are used widely for organisational and workforce development, including in nursing (Anderson and Thorpe, 2004; Pounder, 2009; Young et al., 2010). In the United Kingdom, a multi-faceted educational Pilot programme for new nurses and midwives was implemented to accelerate their clinical practice and leadership development (NHS Education Scotland, 2010). Action Learning Sets were provided for peer support and personal development. The Realistic Evaluation study reported in this paper explored issues of context, mechanism and outcome (Pawson and Tilley, 1997) influencing the action learning experiences of: programme participants (recently qualified nurses and midwives, from different practice settings); and programme supporters. A range of data were collected via: online questionnaires from 66 participants and 29 supporters; three focus groups, each comprising between eight and 10 programme participants; and one focus group with three action learning facilitators. The qualitative data pertaining to the ALS are presented in this paper. Thematic data analysis of context, mechanism and outcome configurations, generated five themes: creating and sustaining a collective learning environment; challenging constructively; collective support; the role of feedback; and effectiveness of ALS. Study outcomes suggest nursing and midwifery action learning should (a) be facilitated positively to improve participants' experience; (b) be renamed to avoid learning methodology confusion; and (c) be outcome focused to evidence impact on practice.

 Copyright © 2014 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24480095
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24480095&id=doi:10.1016%2Fj.nepr.2014.01.007&issn=1471-5953&isbn=&volume=14&issue=4&spage=410&pages=410-6&date=2014&title=Nurse+Education+in+Practice&atitle=Action+learning+sets+in+a+nursing+and+midwifery+practice+learning+context%3A+a+realistic+evaluation.&aulast=Machin&pid=%3Cauthor%3EMachin+AI%3C%2Fauthor%3E%3CAN%3E24480095%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<138. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24461906
TI  - Developing compassion through a relationship centred appreciative leadership programme.
SO  - Nurse Education Today. 34(9):1258-64, 2014 Sep.
VI  - 1
ST  - MEDLINE
AU  - Dewar B
AU  - Cook F
FA  - Dewar, Belinda
FA  - Cook, Fiona
IN  - Dewar, Belinda. Institute of Care and Practice Improvement, University of West of Scotland, Faculty of Health Education and Social Sciences, School of Health, Nursing and Midwifery, Caird Building, Hamilton Campus, Almada Street, Hamilton ML3 OBA, United Kingdom. Electronic address: Belinda.dewar@uws.ac.uk.
IN  - Cook, Fiona. Independent Consultant Practice Development, Edinburgh, United Kingdom. Electronic address: fionacook1@aol.com.
AB  - BACKGROUND: Recent attention in health care focuses on how to develop effective leaders for the future. Effective leadership is embodied in relationships and should be developed in and with staff and patients. This paper describes development, implementation and evaluation of an appreciative and relationship centred leadership programme carried out with 86 nursing staff covering 24 in-patient areas within one acute NHS Board in Scotland.
AB  - AIM OF LEADERSHIP PROGRAMME: The aim of the programme was to support staff to work together to develop a culture of inquiry that would enhance delivery of compassionate care.
AB  - THEORETICAL UNDERPINNINGS: The 12 month Leadership Programme used the principles of appreciative relationship centred leadership. Within this framework participants were supported to explore relationships with self, patients and families, and with teams and the wider organisation using caring conversations.
AB  - STRUCTURE OF PROGRAMME: Participants worked within communities of practice and action learning sets. They were supported to use a range of structured tools to learn about the experience of others and to identify caring practices that worked well and then explore ways in which these could happen more of the time.
AB  - METHODS: A range of methods were used to evaluate impact of the programme including a culture questionnaire and semi structured interviews. Immersion crystallisation technique and descriptive statistics were used to analyse the data.
AB  - FINDINGS: Key themes included; enhanced self-awareness, better relationships, greater ability to reflect on practice, different conversations in the workplace that were more compassionate and respectful, and an ethos of continuing learning and improvement.
AB  - CONCLUSIONS: The programme supported participants to think in different ways and to be reflective and engaged participants rather than passive actors in shaping the cultural climate in which compassionate relationship centred care can flourish. Multidisciplinary programmes where the process and outcomes are explicitly linked to organisational objectives need to be considered in future programmes.

 Copyright © 2014 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24461906
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24461906&id=doi:10.1016%2Fj.nedt.2013.12.012&issn=0260-6917&isbn=&volume=34&issue=9&spage=1258&pages=1258-64&date=2014&title=Nurse+Education+Today&atitle=Developing+compassion+through+a+relationship+centred+appreciative+leadership+programme.&aulast=Dewar&pid=%3Cauthor%3EDewar+B%3C%2Fauthor%3E%3CAN%3E24461906%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<139. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24219921
TI  - A multi-disciplinary approach to medication safety and the implication for nursing education and practice.
SO  - Nurse Education Today. 34(2):185-90, 2014 Feb.
VI  - 1
ST  - MEDLINE
AU  - Adhikari R
AU  - Tocher J
AU  - Smith P
AU  - Corcoran J
AU  - MacArthur J
FA  - Adhikari, Radha
FA  - Tocher, Jennifer
FA  - Smith, Pam
FA  - Corcoran, Janet
FA  - MacArthur, Juliet
IN  - Adhikari, Radha. School of Health in Social Science, University of Edinburgh, Doorway 6, Teviot Place, EH8 9AG, UK. Electronic address: radhika2@staffmail.ed.ac.uk.
IN  - Tocher, Jennifer. School of Health in Social Science, University of Edinburgh, Doorway 6, Teviot Place, EH8 9AG, UK. Electronic address: Jennifer.Tocher@ed.ac.uk.
IN  - Smith, Pam. School of Health in Social Science, University of Edinburgh, Doorway 6, Teviot Place, EH8 9AG, UK. Electronic address: pam.smith@ed.ac.uk.
IN  - Corcoran, Janet. NHS Comely Bank Centre13 Crewe Road South,EdinburghEH4 2LD, UK. Electronic address: Janet.Corcoran@nhslothian.scot.nhs.uk.
IN  - MacArthur, Juliet. Western General Hospital, Crewe Road, Edinburgh,EH4 2XU, UK. Electronic address: Juliet.macarthur@luht.scot.nhs.uk.
AB  - BACKGROUND: Medication management is a complex multi-stage and multi-disciplinary process, involving doctors, pharmacists, nurses and patients. Errors can occur at any stage from prescribing, dispensing and administering, to recording and reporting. There are a number of safety mechanisms built into the medication management system and it is recognised that nurses are the final stage of defence. However, medication error still remains a major challenge to patient safety globally.
AB  - OBJECTIVES: This paper aims to illustrate two main aspects of medication safety practices that have been elicited from an action research study in a Scottish Health Board and three local Higher Education Institutions: firstly current medication safety practices in two clinical settings; and secondly pre and post-registration nursing education and teaching on medication safety.
AB  - METHOD: This paper is based on Phase One and Two of an Action Research project. An ethnography-style observational method, influenced by an Appreciative Inquiry (AI) approach was adapted to study the everyday medication management systems and practices of two hospital wards. This was supplemented by seven in-depth interviews with nursing staff, numerous informal discussions with healthcare professionals, two focus-groups, one peer-interview and two in-depth individual interviews with final year nursing students from three Higher Education Institutions in Scotland.
AB  - RESULT: This paper highlights the current positive practical efforts in medication safety practices in the chosen clinical areas. Nursing staff do employ the traditional 'five right' principles - right patient, right medication, right dose, right route and right time - for safe administration. Nursing students are taught these principles in their pre-registration nursing education. However, there are some other challenges remaining: these include the establishment of a complete medication history (reconciliation) when patients come to hospital, the provision of an in-depth training in pharmacological knowledge to junior nursing staff and pre-registration nursing students.
AB  - CONCLUSION: This paper argues that the 'five rights' principle during medication administration is not enough for holistic medication safety and explains two reasons why there is a need for strengthened multi-disciplinary team-work to achieve greater patient safety. To accomplish this, nurses need to have sufficient knowledge of pharmacology and medication safety issues. These findings have important educational implications and point to the requirement for the incorporation of medication management and pharmacology in to the teaching curriculum for nursing students. There is also a call for continuing professional development opportunities for nurses working in clinical settings.

 Copyright © 2014.
PT  - Journal Article
PT  - Observational Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24219921
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24219921&id=doi:10.1016%2Fj.nedt.2013.10.008&issn=0260-6917&isbn=&volume=34&issue=2&spage=185&pages=185-90&date=2014&title=Nurse+Education+Today&atitle=A+multi-disciplinary+approach+to+medication+safety+and+the+implication+for+nursing+education+and+practice.&aulast=Adhikari&pid=%3Cauthor%3EAdhikari+R%3C%2Fauthor%3E%3CAN%3E24219921%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<140. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24007894
TI  - Developing a national computerised absence monitoring and management system to reduce nursing student attrition: evaluation of staff and student perspectives.
SO  - Nurse Education Today. 34(5):738-43, 2014 May.
VI  - 1
ST  - MEDLINE
AU  - Currie K
AU  - McCallum J
AU  - Murray J
AU  - Scott J
AU  - Strachan E
AU  - Yates L
AU  - Wright M
FA  - Currie, Kay
FA  - McCallum, Jacqueline
FA  - Murray, John
FA  - Scott, Janine
FA  - Strachan, Evelyn
FA  - Yates, Lynda
FA  - Wright, Marty
IN  - Currie, Kay. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom. Electronic address: k.currie@gcu.ac.uk.
IN  - McCallum, Jacqueline. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
IN  - Murray, John. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
IN  - Scott, Janine. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
IN  - Strachan, Evelyn. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
IN  - Yates, Lynda. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
IN  - Wright, Marty. School of Health & Life Sciences, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, United Kingdom.
AB  - BACKGROUND: Reducing avoidable nursing student attrition is an international challenge. A pattern of falling attendance is recognised as a frequent precursor to withdrawal from nursing programmes. To address concerns regarding nursing student attrition, the Scottish Government implemented a pilot project for a centralised Computerised Absence Management and Monitoring System (CAMMS). The CAMMS adopted an 'assertive outreach' approach, contacting students every two weeks via colour coded letters to tell them whether their attendance was 'excellent', 'good, but potentially causing concern'; or 'warning; attendance concerns/contact academic staff for support'. This article reports key findings from an evaluation of CAMMS.
AB  - OBJECTIVES: To explore the perceived impact of CAMMS on student support and attrition, from the perspectives of academic and administrative staff and students.
AB  - DESIGN: Mixed methods evaluation design.
AB  - SETTINGS: Three large geographically dispersed Schools of Nursing in Scotland.
AB  - PARTICIPANTS: 83 students; 20 academic staff; and 3 lead administrators.
AB  - METHODS: On-line cohort survey of academic staff and students; structured interviews with lead administrators.
AB  - RESULTS: Findings reflected a spectrum of negative and positive views of CAMMS. Students who are attending regularly seem pleased that their commitment is recognised. Lecturers who teach larger groups report greater difficulty getting to know students individually and acknowledge the benefit of identifying potential attendance concerns at an early stage. Conversely, some students who received a 'warning' letter were frequently annoyed or irritated, rather than feeling supported. Increased staff workload resulted in negative perceptions and a consequent reluctance to use CAMMS. However, students who were causing concern reported subsequent improvement in attendance.
AB  - CONCLUSIONS: CAMMS has the potential to identify 'at-risk' students at an early stage; however, the system should have flexibility to tailor automatically generated letters in response to individual circumstances, to avoid student frustration. Further research on the longer term impact of CAMMS on attrition rates is warranted.

 Copyright © 2013.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=24007894
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24007894&id=doi:10.1016%2Fj.nedt.2013.08.006&issn=0260-6917&isbn=&volume=34&issue=5&spage=738&pages=738-43&date=2014&title=Nurse+Education+Today&atitle=Developing+a+national+computerised+absence+monitoring+and+management+system+to+reduce+nursing+student+attrition%3A+evaluation+of+staff+and+student+perspectives.&aulast=Currie&pid=%3Cauthor%3ECurrie+K%3C%2Fauthor%3E%3CAN%3E24007894%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<141. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23375401
TI  - The health promotion work of the district nurse: interpreting its embeddedness.
SO  - Primary Health Care Research & Development. 15(1):15-25, 2014 Jan.
VI  - 1
ST  - MEDLINE
AU  - Runciman P
FA  - Runciman, Phyllis
IN  - Runciman, Phyllis. Formerly Senior Research Fellow, Glasgow Caledonian University, Glasgow, UK.
AB  - AIM: This article presents an interpretation of health promotion within the work of a district nurse (DN).
AB  - BACKGROUND: Literature supports the centrality of health promotion within nursing. It also presents debate about its meaning and suggests uncertainties for educators and practitioners about its relationship to nursing care. Two studies in Scotland on community nurses' health promotion work with older people suggested that health promotion was evident and recognisable in planned initiatives or projects but could be hidden and unrecognised in day-to-day nursing work with individual patients and their families.
AB  - METHODS: An experienced DN's interpretation of health promotion embedded in her work with a patient with multiple sclerosis is presented. The case was one of a number derived from a study designed in the constructivist paradigm, which addressed health promotion in relation to community nurse education and practice for a range of community nursing roles, including district nursing. The case study data were derived from observation of practice, interviews with the DN and the patient and from field notes.
AB  - FINDINGS: Health promotion emerged as embedded within day-to-day holistic nursing care. The DN illustrated an understanding of the dimensions of health and of the significance of core health promotion concepts such as education, prevention, advocacy, empowerment, self-esteem and self-efficacy. However, health promotion could be invisible, described as weaved into everything and on the back of other things, and therefore not normally acknowledged and clearly articulated. Embeddedness highlighted the challenge for evaluation, when nursing and health promotion activities are intrinsically related and can be argued as sharing certain principles, processes and outcomes.
AB  - CONCLUSION: Embeddedness is a significant issue for learning in practice. The ability of experienced community nurses to interpret and articulate the concept of health promotion clearly and to make tacit knowledge evident would be of benefit to students.
PT  - Case Reports
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med11&AN=23375401
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23375401&id=doi:10.1017%2FS1463423612000655&issn=1463-4236&isbn=&volume=15&issue=1&spage=15&pages=15-25&date=2014&title=Primary+Health+Care+Research+%26+Development&atitle=The+health+promotion+work+of+the+district+nurse%3A+interpreting+its+embeddedness.&aulast=Runciman&pid=%3Cauthor%3ERunciman+P%3C%2Fauthor%3E%3CAN%3E23375401%3C%2FAN%3E%3CDT%3ECase+Reports%3C%2FDT%3E

<142. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23387943
TI  - Nursing stress and patient care: real-time investigation of the effect of nursing tasks and demands on psychological stress, physiological stress, and job performance: study protocol.
SO  - Journal of Advanced Nursing. 69(10):2327-35, 2013 Oct.
VI  - 1
ST  - MEDLINE
AU  - Farquharson B
AU  - Bell C
AU  - Johnston D
AU  - Jones M
AU  - Schofield P
AU  - Allan J
AU  - Ricketts I
AU  - Morrison K
AU  - Johnston M
FA  - Farquharson, Barbara
FA  - Bell, Cheryl
FA  - Johnston, Derek
FA  - Jones, Martyn
FA  - Schofield, Pat
FA  - Allan, Julia
FA  - Ricketts, Ian
FA  - Morrison, Kenny
FA  - Johnston, Marie
IN  - Farquharson, Barbara. NMAHP Research Unit, University of Stirling, UK.
AB  - AIM: To examine the effects of nursing tasks (including their physiological and psychological demands, and the moderating effects of reward and control) on distress and job performance in real time.
AB  - BACKGROUND: Nurses working in hospital settings report high levels of occupational stress. Stress in nurses has been linked to reduced physical and psychological health, reduced job satisfaction, increased sickness absence, increased staff turnover, and poorer job performance. In this study, we will investigate theoretical models of stress and use multiple methods, including real-time data collection, to assess the relationship between stress and different nursing tasks in general medical and surgical ward nurses.
AB  - DESIGN: A real-time, repeated measures design.
AB  - METHODS: During 2011/2012, 100 nurses from a large general teaching hospital in Scotland will: (a) complete self-reports of mood; (b) have their heart rate and activity monitored over two shifts to obtain physiological indices of stress and energy expenditure; (c) provide perceptions of the determinants of stress in complex ward environments; and (d) describe their main activities. All measures will be taken repeatedly in real time over two working shifts.
AB  - DISCUSSION: Data obtained in this study will be analysed to examine the relationships between nursing tasks, self-reported and physiological measures of stress and to assess the effect of occupational stress on multiple work outcomes. The results will inform theoretical understanding of nurse stress and its determinants and suggest possible targets for intervention to reduce stress and associated harmful consequences.

 Copyright © 2013 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23387943
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23387943&id=doi:10.1111%2Fjan.12090&issn=0309-2402&isbn=&volume=69&issue=10&spage=2327&pages=2327-35&date=2013&title=Journal+of+Advanced+Nursing&atitle=Nursing+stress+and+patient+care%3A+real-time+investigation+of+the+effect+of+nursing+tasks+and+demands+on+psychological+stress%2C+physiological+stress%2C+and+job+performance%3A+study+protocol.&aulast=Farquharson&pid=%3Cauthor%3EFarquharson+B%3C%2Fauthor%3E%3CAN%3E23387943%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<143. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24158100
TI  - Nurses leading care in custody suite environments: a qualitative study from Scotland.
SO  - Journal of Forensic Nursing. 9(1):45-51, 2013 Jan-Mar.
VI  - 1
ST  - MEDLINE
AU  - Hurley J
AU  - Linsley P
AU  - Elvins M
AU  - Jones M
FA  - Hurley, John
FA  - Linsley, Paul
FA  - Elvins, Martin
FA  - Jones, Martyn
IN  - Hurley, John. Author Affiliations: 1Associate Professor, Southern Cross University, 2University of Lincoln, 3University of Dundee, Australia.
AB  - This paper outlines the qualitative findings of a recent multimethod study exploring the impact of nurses assuming leadership roles in delivering primary health care to detainees within police custody suites in Scotland. The full multimethod study was conducted within a framework of realistic evaluation with key findings indicating that the nurse-led model of service delivery offers positive outcomes for all key stakeholders. Findings from the qualitative component of the study showed that the quality of clinical care for detainees improved, policing concerns for detainee safety were mitigated, and forensic medical examiners were able to expand their specialist roles. Key supporting mechanisms in achieving these outcomes included generating collaborative practices, enacting clinical leadership, and providing a forensic nursing educational program to empower nurses to generate service provision and grow professional autonomy.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=24158100
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24158100&id=doi:10.1097%2FJFN.0b013e31827a57e7&issn=1556-3693&isbn=&volume=9&issue=1&spage=45&pages=45-51&date=2013&title=Journal+of+Forensic+Nursing&atitle=Nurses+leading+care+in+custody+suite+environments%3A+a+qualitative+study+from+Scotland.&aulast=Hurley&pid=%3Cauthor%3EHurley+J%3C%2Fauthor%3E%3CAN%3E24158100%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<144. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 24156194
TI  - Community nurses' participation in palliative care research: the Dignity Care Pathway.
SO  - British Journal of Community Nursing. 18(7):326, 328-31, 2013 Jul.
VI  - 1
ST  - MEDLINE
AU  - Andrew J
AU  - Johnston B
AU  - Papadopoulou C
FA  - Andrew, Jane
FA  - Johnston, Bridget
FA  - Papadopoulou, Constantina
IN  - Andrew, Jane. Palliative Care Services, Dundee, NHS Tayside, UK. janeandrew@nhs.net
AB  - Evidence-based practice is a cornerstone of modern health care. Ongoing challenges have been identified in the strength of the evidence base in community palliative care nursing (Walshe and Luker, 2010). This paper discusses the participation of community nurses in a palliative care research project. The Dignity Care Pathway (DCP) is an evidence-based framework developed using a collaborative research approach with community nurses in Scotland. Collaborative research has been advocated as one way to facilitate integrated knowledge transfer and to address the research-practice gap. The aim of this paper is to discuss the participation of community nurses in a collaborative research project to implement a palliative care intervention in practice. The discussion will draw on findings from the third phase of the DCP multiphase research project.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=24156194
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:24156194&id=doi:10.12968%2Fbjcn.2013.18.7.326&issn=1462-4753&isbn=&volume=18&issue=7&spage=326&pages=326%2C+328-31&date=2013&title=British+Journal+of+Community+Nursing&atitle=Community+nurses%27+participation+in+palliative+care+research%3A+the+Dignity+Care+Pathway.&aulast=Andrew&pid=%3Cauthor%3EAndrew+J%3C%2Fauthor%3E%3CAN%3E24156194%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<145. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23772448
TI  - The expansion of nurse prescribing in Scotland: an evaluation.
SO  - British Journal of Community Nursing. 18(5):234-42, 2013 May.
VI  - 1
ST  - MEDLINE
AU  - Coull A
AU  - Murray I
AU  - Turner-Halliday F
AU  - Watterson A
FA  - Coull, Alison
FA  - Murray, Ian
FA  - Turner-Halliday, Fiona
FA  - Watterson, Andrew
IN  - Coull, Alison. School of Nursing, Midwifery and Health, University of Stirling. a.f.coull@stir.ac.uk
AB  - Medicine prescribing by community nurses commenced in the UK in 1996. By 2001, nurse prescribing was extended to include more nurses and to cover a wider formulary. This research project provides an evaluation of the extension of prescribing powers to nurses in Scotland, following the introduction of legislation in 2001. It aimed to evaluate the impact of nurse prescribing powers on patients, nurses, prescribers, and other stakeholders. A range of methods were used, including two public surveys, stakeholder interviews, postal questionnaires and case studies. The benefits of extended nurse prescribing include: improved patient access to treatment; enhanced patient care; enabled more effective use of medical staff time and greater professional satisfaction for nurses who used nursing skills; and built inter-professional working. Some obstacles existed, including organisational, institutional and resource factors that restricted the overall success of the extension of nurse prescribing. There are high levels of agreement between patients, the public, nurse prescribers, physicians and other health professionals about the benefits of nurse prescribing to patients. The extension of nurse prescribing has been largely successful, with some organisational and procedural areas that could be addressed.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23772448
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23772448&id=doi:10.12968%2Fbjcn.2013.18.5.234&issn=1462-4753&isbn=&volume=18&issue=5&spage=234&pages=234-42&date=2013&title=British+Journal+of+Community+Nursing&atitle=The+expansion+of+nurse+prescribing+in+Scotland%3A+an+evaluation.&aulast=Coull&pid=%3Cauthor%3ECoull+A%3C%2Fauthor%3E%3CAN%3E23772448%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<146. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23647739
TI  - Shifting the balance of care? A qualitative study of policy implementation in community nursing.
SO  - Journal of Nursing Management. 21(6):867-77, 2013 Sep.
VI  - 1
ST  - MEDLINE
AU  - Haycock-Stuart E
AU  - Kean S
FA  - Haycock-Stuart, Elaine
FA  - Kean, Susanne
IN  - Haycock-Stuart, Elaine. School of Health in Social Science, The University of Edinburgh, The Medical School, Edinburgh, UK.
AB  - AIM: This qualitative study examined the interaction between policy implementation and service organisation and delivery for community nursing services.
AB  - BACKGROUND: Leadership in nursing is at the fore front of the policy agenda for shifting the balance of care from hospitals to the community setting and for improving the quality of healthcare services. Yet, little is known about the implementation of policy within the community setting.
AB  - METHOD: A qualitative, interpretive analysis including semi-structured interviews with nurse leaders (n = 12) and community nurses (n = 27) and three focus groups (n = 13) with community nurses (Total N = 39) in three Health Boards in Scotland.
AB  - RESULTS: Policy implementation is not adequately integrated between primary and secondary care service at the point of care delivery. The 'top down approach' to policy implementation for shifting the balance of care is currently at odds with the grass roots service organisation and delivery in the community setting.
AB  - CONCLUSIONS: The aspirations of integrated, collaborative health and social care require more clinicians working at the frontline in both primary and secondary care to value more the work of colleagues in the different sectors.
AB  - IMPLICATION FOR NURSING MANAGEMENT: The current 'top down approach' to policy implementation encourages resistance in the frontline community nurses rather than commitment. A more 'bottom up' integrated approach to policy implementation is therefore required.

 Copyright © 2013 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23647739
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23647739&id=doi:10.1111%2Fjonm.12088&issn=0966-0429&isbn=&volume=21&issue=6&spage=867&pages=867-77&date=2013&title=Journal+of+Nursing+Management&atitle=Shifting+the+balance+of+care%3F+A+qualitative+study+of+policy+implementation+in+community+nursing.&aulast=Haycock-Stuart&pid=%3Cauthor%3EHaycock-Stuart+E%3C%2Fauthor%3E%3CAN%3E23647739%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<147. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23612957
TI  - Improving end-of-life care in nursing homes: implementation and evaluation of an intervention to sustain quality of care.
SO  - Palliative Medicine. 27(8):772-8, 2013 Sep.
VI  - 1
ST  - MEDLINE
AU  - Finucane AM
AU  - Stevenson B
AU  - Moyes R
AU  - Oxenham D
AU  - Murray SA
FA  - Finucane, Anne M
FA  - Stevenson, Barbara
FA  - Moyes, Rhona
FA  - Oxenham, David
FA  - Murray, Scott A
IN  - Finucane, Anne M. Marie Curie Hospice Edinburgh, Edinburgh, UK. anne.finucane@mariecurie.org.uk
AB  - BACKGROUND: Internationally, policy calls for care homes to provide reliably good end-of-life care. We undertook a 20-month project to sustain palliative care improvements achieved by a previous intervention.
AB  - AIM: To sustain a high standard of palliative care in seven UK nursing care homes using a lower level of support than employed during the original project and to evaluate the effectiveness of this intervention.
AB  - DESIGN: Two palliative care nurse specialists each spent one day per week providing support and training to seven care homes in Scotland, United Kingdom; after death audit data were collected each month and analysed.
AB  - RESULTS: During the sustainability project, 132 residents died. In comparison with the initial intervention, there were increases in (a) the proportion of deceased residents with an anticipatory care plan in place (b) the proportion of those with Do Not Attempt Cardiopulmonary Resuscitation documentation in place and (c) the proportion of those who were on the Liverpool Care Pathway when they died. Furthermore, there was a reduction in inappropriate hospital deaths of frail and elderly residents with dementia. However, overall hospital deaths increased.
AB  - CONCLUSIONS: A lower level of nursing support managed to sustain and build on the initial outcomes. However, despite increased adoption of key end-of-life care tools, hospital deaths were higher during the sustainability project. While good support from palliative care nurse specialists and GPs can help ensure that key processes remain in place, stable management and key champions are vital to ensure that a palliative care approach becomes embedded within the culture of the care home.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23612957
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23612957&id=doi:10.1177%2F0269216313480549&issn=0269-2163&isbn=&volume=27&issue=8&spage=772&pages=772-8&date=2013&title=Palliative+Medicine&atitle=Improving+end-of-life+care+in+nursing+homes%3A+implementation+and+evaluation+of+an+intervention+to+sustain+quality+of+care.&aulast=Finucane&pid=%3Cauthor%3EFinucane+AM%3C%2Fauthor%3E%3CAN%3E23612957%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<148. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23596027
TI  - Paediatric thyroid cancer: the Scottish experience.
SO  - Scottish Medical Journal. 58(1):34-40, 2013 Feb.
VI  - 1
ST  - MEDLINE
AU  - Douglas CM
AU  - Macgregor FB
FA  - Douglas, C M
FA  - Macgregor, F B
IN  - Douglas, C M. Department of Paediatric ENT, Royal Hospital for Sick Children, UK.
AB  - BACKGROUND AND AIMS: Paediatric thyroid cancer is a rare disease, making diagnosis and treatment particularly challenging. Here we present the Scottish experience of thyroid cancer in the paediatric population and give an overview of how a child or adolescent that presents with a thyroid nodule should be investigated and managed.
AB  - METHODS AND RESULTS: Data has been obtained from ISD Scotland, giving population-based information on paediatric thyroid cancer. A literature review has been performed on the management and treatment of thyroid cancer in the younger population. Paediatric thyroid cancer in Scotland is a rare disease, although the incidence is increasing each year. In general, differentiated paediatric thyroid cancer carries a good prognosis, while the results are more mixed in the rarer pathologies such as medullary cancer.
AB  - CONCLUSION: Due to the small numbers of patients diagnosed each year in Scotland, it is imperative that these patients are discussed at a multidisciplinary thyroid MDT and managed in a tertiary referral centre by consultants and medical/nursing support staff who have experience in treating these patients.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23596027
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23596027&id=doi:10.1177%2F0036933013478341&issn=0036-9330&isbn=&volume=58&issue=1&spage=34&pages=34-40&date=2013&title=Scottish+Medical+Journal&atitle=Paediatric+thyroid+cancer%3A+the+Scottish+experience.&aulast=Douglas&pid=%3Cauthor%3EDouglas+CM%3C%2Fauthor%3E%3CAN%3E23596027%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<149. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23570875
TI  - Recruitment, selection and retention of nursing and midwifery students in Scottish Universities.
SO  - Nurse Education Today. 33(11):1301-10, 2013 Nov.
VI  - 1
ST  - MEDLINE
AU  - Rodgers S
AU  - Stenhouse R
AU  - McCreaddie M
AU  - Small P
FA  - Rodgers, Sheila
FA  - Stenhouse, Rosie
FA  - McCreaddie, May
FA  - Small, Pauline
IN  - Rodgers, Sheila. Nursing Studies, Health in Social Science, University of Edinburgh, Teviot Place, Edinburgh EH8 9AG, United Kingdom. Electronic address: s.rodgers@ed.ac.uk.
AB  - BACKGROUND: High attrition rates from pre-registration nursing and midwifery programmes have been reported in both the UK and in other countries.
AB  - OBJECTIVES: A study was conducted to identify best practice in recruitment, selection and retention across Scottish Universities providing pre-registration programmes.
AB  - DESIGN: A survey of all universities providing pre-registration programmes in Scotland was conducted. Semi-structured interviews were conducted with key personnel in each university. Documentary evidence was collected to supplement interview data and evidence recruitment, selection and retention practices.
AB  - SETTINGS: All universities in Scotland providing pre-registration nursing and/or midwifery programmes.
AB  - PARTICIPANTS: All 10 identified universities agreed to take part and a total of 18 interviews were conducted.
AB  - METHODS: Semi-structured face to face and telephone interviews were conducted. Relevant documentary evidence was collected. All data were subject to thematic analysis.
AB  - FINDINGS: Universities are predominantly concerned with recruiting to the institution and not to the professions. Interviews are widely used, and are a requirement in the United Kingdom. However, there is no evidence base within the literature that they have predictive validity despite creating scales and scoring systems which are largely unvalidated. The study identified initiatives aimed at addressing attrition/retention, however most had not been evaluated often due to the multi-factorial nature of attrition/retention and difficulties with measurement.
AB  - CONCLUSIONS: Recruitment selection and retention initiatives were rarely evaluated, and if so, adopted a relatively superficial approach. Evidence from existing studies to support practices was mostly weakly supportive or absent. The study highlights the need for a coordinated approach, supporting the development of a robust evidence base through the evaluation of local initiatives, and evaluation of new strategies. Evaluation strategies must take account of the local context to facilitate transferability of findings across different settings.

 Copyright © 2013 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23570875
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23570875&id=doi:10.1016%2Fj.nedt.2013.02.024&issn=0260-6917&isbn=&volume=33&issue=11&spage=1301&pages=1301-10&date=2013&title=Nurse+Education+Today&atitle=Recruitment%2C+selection+and+retention+of+nursing+and+midwifery+students+in+Scottish+Universities.&aulast=Rodgers&pid=%3Cauthor%3ERodgers+S%3C%2Fauthor%3E%3CAN%3E23570875%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<150. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23556215
TI  - The role of technology and digital gaming in nurse education.
SO  - Nursing Standard. 27(28):35-8, 2013 Mar 13.
VI  - 1
ST  - MEDLINE
AU  - Johnston B
AU  - Boyle L
AU  - MacArthur E
AU  - Manion BF
FA  - Johnston, Brian
FA  - Boyle, Liz
FA  - MacArthur, Ewan
FA  - Manion, Baltasar Fernandez
IN  - Johnston, Brian. School of Health, Nursing and Midwifery, University of the West of Scotland (UWS), Paisley. brian.johnston@uws.ac.uk
AB  - There is growing evidence that using e-learning and digital gaming technology can support students in their learning. An international project, Continuing/Higher Education in Research Methods Using Games, funded by the European Commission's Lifelong Learning Programme and led by a team at the University of the West of Scotland, aims to develop interactive activities and games to support nursing and social science students. This article looks at the scope of the project in helping to deliver nurse education.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23556215
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23556215&id=doi:10.7748%2Fns2013.03.27.28.35.s9612&issn=0029-6570&isbn=&volume=27&issue=28&spage=35&pages=35-8&date=2013&title=Nursing+Standard&atitle=The+role+of+technology+and+digital+gaming+in+nurse+education.&aulast=Johnston&pid=%3Cauthor%3EJohnston+B%3C%2Fauthor%3E%3CAN%3E23556215%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<151. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23498842
TI  - A foot in two camps: an exploratory study of nurse leaders in universities.
SO  - Nurse Education Today. 33(11):1342-6, 2013 Nov.
VI  - 1
ST  - MEDLINE
AU  - Ross F
AU  - Marks-Maran D
AU  - Tye C
FA  - Ross, Fiona
FA  - Marks-Maran, Di
FA  - Tye, Christopher
IN  - Ross, Fiona. Faculty of Health and Social Care Sciences, Kingston University and St George's, University of London, Cranmer Terrace, London SW17 0RE, UK. Electronic address: f.ross@sgul.kingston.ac.uk.
AB  - BACKGROUND: Nursing education was fully absorbed into universities in the United Kingdom in the late 1990s and thus is a relatively young academic discipline. In contrast to a lively literature on clinical nursing leadership, little attention has been given to the leadership of academic nursing as these roles encompass contract management, research and teaching.
AB  - OBJECTIVES: The purpose of this study was to explore the scope and meaning of leadership from the experience of nurse leaders in universities in the United Kingdom (UK).
AB  - DESIGN AND METHODS: The qualitative design used open ended telephone interviews. Interview transcripts were checked with participants. Framework analysis was used for capturing and identifying themes.
AB  - SETTING AND PARTICIPANTS: A convenience sample of academic nurse leaders (responsible for a School, Department or a Faculty) was identified through the UK Council of Deans of Health.
AB  - RESULTS: All ten respondents were managing health care portfolios and running departments of various sizes and often with a mix of nursing and other health care disciplines. There was regional and country representation (England, Scotland and Wales) and half the respondents were employed at pre 1992 and half at post 1992 universities (the latter institutions that were previously polytechnics and gained university status in 1992). Three core issues emerged from the data: the leadership context; ways in which the deans articulated their leadership skills and the issue of legitimacy of nursing in higher education.
AB  - CONCLUSION: Two important issues emerged for nursing deans, firstly the university as a knowledge producer and secondly the need to create strong academic and professional identities. The findings highlight role complexity as academic nurse leaders navigate the dichotomy between the different worlds of the university and health care practice. The legitimacy of nursing as a practice discipline in the university continues to be contested territory. There is an opportunity for nurse leaders to do more to develop a collective narrative about the contribution that academic nursing can make to the quality of the workforce.

 Copyright © 2013 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23498842
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23498842&id=doi:10.1016%2Fj.nedt.2013.02.008&issn=0260-6917&isbn=&volume=33&issue=11&spage=1342&pages=1342-6&date=2013&title=Nurse+Education+Today&atitle=A+foot+in+two+camps%3A+an+exploratory+study+of+nurse+leaders+in+universities.&aulast=Ross&pid=%3Cauthor%3ERoss+F%3C%2Fauthor%3E%3CAN%3E23498842%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<152. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23434190
TI  - Education programmes preparing independent prescribers in Scotland: an evaluation.
SO  - Nurse Education Today. 33(4):321-6, 2013 Apr.
VI  - 1
ST  - MEDLINE
AU  - Boreham N
AU  - Coull AF
AU  - Murray ID
AU  - Turner-Halliday F
AU  - Watterson AE
FA  - Boreham, Nick
FA  - Coull, Alison F
FA  - Murray, Ian D
FA  - Turner-Halliday, Fiona
FA  - Watterson, Andrew E
IN  - Boreham, Nick. School of Education, University of Glasgow, Glasgow G12 8QQ, United Kingdom.
AB  - BACKGROUND: Nurse prescribing (NP) is part of the modernisation of the health care workforce and contributes to patient care by improving access to quality services and medication, through utilisation of advanced professional skills. Nurses and midwives need to complete additional education in order to prescribe. This paper explores pedagogical issues relevant to professional training programmes.
AB  - OBJECTIVES: To assess if programmes of education for nurse prescribing in Scotland were fit for purpose, from both the student and educator perspective with recommendations for future educational delivery.
AB  - DESIGN: Data were collected using several methods: a questionnaire to all course members on prescribing programmes followed by focus-groups; and interviews with programme providers.
AB  - RESULTS: Nurses and midwives training as prescribers work in a wide range of healthcare settings, in different geographic environments. They tended to be experienced, educated to degree level and most are over forty years of age. Most undertook the course to develop professionally and to improve patient care. Existing provision of education for prescribing is deemed appropriate and fit for purpose. The NP programme greatly enhances pharmacological knowledge building on existing clinical experience. The nature of these programmes works well and should be retained. However, whilst the educational programmes were centrally funded, less than half of students were provided with any allocated study time from their employers preventing nurses from maximising the gain from the educational preparation for prescribing.
AB  - CONCLUSIONS: Nurse and midwife generic preparation for independent nurse prescribing in Scotland greatly increases professional expertise and is appropriate and fit for purpose. As other countries beyond Scotland and the UK seek to further progress nursing roles, learning from this controlled and structured development of prescribing underpinned by evidence could be of significant benefit.

 Copyright © 2013 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23434190
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23434190&id=doi:10.1016%2Fj.nedt.2013.01.018&issn=0260-6917&isbn=&volume=33&issue=4&spage=321&pages=321-6&date=2013&title=Nurse+Education+Today&atitle=Education+programmes+preparing+independent+prescribers+in+Scotland%3A+an+evaluation.&aulast=Boreham&pid=%3Cauthor%3EBoreham+N%3C%2Fauthor%3E%3CAN%3E23434190%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<153. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23410060
TI  - Time for change in community nursing? A critique of the implementation of the Review of Nursing in the Community across NHS Scotland.
SO  - Journal of Nursing Management. 21(2):339-50, 2013 Mar.
VI  - 1
ST  - MEDLINE
AU  - Dickson CA
AU  - Coulter Smith MA
FA  - Dickson, Caroline A W
FA  - Coulter Smith, Margaret A
IN  - Dickson, Caroline A W. Division of Nursing, Occupational Therapy and Arts Therapies, School of Health Sciences, Queen Margaret University, Edinburgh, Scotland. cdickson@qmu.ac.uk
AB  - AIM: Current literature underpinning change is examined and a critique offered of the implementation of the role of the generic Community Health Nurse in Scotland, from a leadership and cultural perspective.
AB  - BACKGROUND: In November 2006, Government strategy outlined a new service model for community nursing to be implemented in four demonstration sites across Scotland. Almost two-thirds of community nurses were not supportive of the model. There was belief this generic role would not meet the health needs of patients and carers.
AB  - EVALUATION: Evidence supporting the model is presented and the implementation process evaluated from leadership and cultural perspectives. The literature is examined to offer explanations as to why implementation was unsuccessful.
AB  - CONCLUSIONS: Transformational and transactional leadership at all levels of the organization are required to make change happen. Evidence supporting change provides an impetus for change. The culture of an organization should be recognized and harnessed during the change process. Effective facilitation will empower staff to make change happen.
AB  - IMPLICATIONS FOR NURSING MANAGEMENT: Engagement with staff is vital, at the beginning of the change process. The concept of 'nearby' leadership offers an enabling style of leadership at an individual and group level which will enable effective change.

 Copyright © 2012 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23410060
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23410060&id=doi:10.1111%2Fj.1365-2834.2012.01382.x&issn=0966-0429&isbn=&volume=21&issue=2&spage=339&pages=339-50&date=2013&title=Journal+of+Nursing+Management&atitle=Time+for+change+in+community+nursing%3F+A+critique+of+the+implementation+of+the+Review+of+Nursing+in+the+Community+across+NHS+Scotland.&aulast=Dickson&pid=%3Cauthor%3EDickson+CA%3C%2Fauthor%3E%3CAN%3E23410060%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<154. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23391260
TI  - Training health care professionals in root cause analysis: a cross-sectional study of post-training experiences, benefits and attitudes.
SO  - BMC Health Services Research. 13:50, 2013 Feb 07.
VI  - 1
ST  - MEDLINE
AU  - Bowie P
AU  - Skinner J
AU  - de Wet C
FA  - Bowie, Paul
FA  - Skinner, Joe
FA  - de Wet, Carl
IN  - Bowie, Paul. Postgraduate General Practice Education, NHS Education for Scotland, 2 Central Quay, Glasgow, Scotland, G3 8BW, United Kingdom. paul.bowie@nes.scot.nhs.uk
AB  - BACKGROUND: Root cause analysis (RCA) originated in the manufacturing engineering sector but has been adapted for routine use in healthcare to investigate patient safety incidents and facilitate organizational learning. Despite the limitations of the RCA evidence base, healthcare authorities and decision makers in NHS Scotland - similar to those internationally - have invested heavily in developing training programmes to build local capacity and capability, and this is a cornerstone of many organizational policies for investigating safety-critical issues. However, to our knowledge there has been no systematic attempt to follow-up and evaluate post-training experiences of RCA-trained staff in Scotland. Given the significant investment in people, time and funding we aimed to capture and learn from the reported experiences, benefits and attitudes of RCA-trained staff and the perceived impact on healthcare systems and safety.
AB  - METHODS: We adapted a questionnaire used in a published Australian research study to undertake a cross sectional online survey of health care professionals (e.g. nursing & midwifery, medical doctors and pharmacists) formally trained in RCA by a single territorial health board region in NHS Scotland.
AB  - RESULTS: A total of 228/469 of invited staff completed the survey (48%). A majority of respondents had yet to participate in a post-training RCA investigation (n=127, 55.7%). Of RCA-experience staff, 71 had assumed a lead investigator role (70.3%) on one or more occasions. A clear majority indicated that their improvement recommendations were generally or partly implemented (82%). The top three barriers to RCA success were cited as: lack of time (54.6%), unwilling colleagues (34%) and inter-professional differences (31%). Differences in agreement levels between RCA-experienced and inexperienced respondents were noted on whether a follow-up session would be beneficial after conducting RCA (65.3% v 39.4%) and if peer feedback on RCA reports would be of educational value (83.2% v 37.0%). Comparisons with the previous research highlighted significant differences such as less reported difficulties within RCA teams (P<0.001) and a greater proportion of respondents taking on RCA leadership roles in this study (P<0.001).
AB  - CONCLUSION: This study adds to our knowledge and understanding of the need to improve the effectiveness of RCA training and frontline practices in healthcare settings. The overall evidence points to a potential organisational learning need to provide RCA-trained staff with continuous development opportunities and performance feedback. Healthcare authorities may wish to look more critically at whom they train in RCA, and how this is delivered and supported educationally to maximize cost-benefits, organizational learning and safer patient care.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23391260
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23391260&id=doi:10.1186%2F1472-6963-13-50&issn=1472-6963&isbn=&volume=13&issue=1&spage=50&pages=50&date=2013&title=BMC+Health+Services+Research&atitle=Training+health+care+professionals+in+root+cause+analysis%3A+a+cross-sectional+study+of+post-training+experiences%2C+benefits+and+attitudes.&aulast=Bowie&pid=%3Cauthor%3EBowie+P%3C%2Fauthor%3E%3CAN%3E23391260%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<155. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23288887
TI  - Family health nursing: a response to the global health challenges.
SO  - Journal of Family Nursing. 19(1):99-118, 2013 Feb.
VI  - 1
ST  - MEDLINE
AU  - Martin P
AU  - Duffy T
AU  - Johnston B
AU  - Banks P
AU  - Harkess-Murphy E
AU  - Martin CR
FA  - Martin, Paul
FA  - Duffy, Tim
FA  - Johnston, Brian
FA  - Banks, Pauline
FA  - Harkess-Murphy, Eileen
FA  - Martin, Colin R
IN  - Martin, Paul. School of Health, Nursing, and Midwifery, University of West of Scotland, Paisley Campus, Paisley, Scotland, UK.
AB  - The European Family Health Nursing Project is a revitalized World Health Organization initiative led by the University of the West of Scotland. Partner countries include Armenia, Austria, Germany, Italy, Poland, Portugal, Romania, Slovenia, and Spain. European Union Lifelong Learning funding was received in 2011 to facilitate a consistency of approach in the development of a definition of family health nursing, required core competencies and capabilities, and consequent education and training requirements. Global health challenges have informed the development of the project: increasingly aging populations, the increasing incidence in noncommunicable diseases that are currently the main cause of death, and the significant progress made in the way health systems have developed to meet the demands in relation to access and equality of health services. Governments and policy makers should develop a health workforce based on the principles of teamwork and interdisciplinarity while recognizing the core contribution of the "specialist generalist" role in the primary care setting.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23288887
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23288887&id=doi:10.1177%2F1074840712471810&issn=1074-8407&isbn=&volume=19&issue=1&spage=99&pages=99-118&date=2013&title=Journal+of+Family+Nursing&atitle=Family+health+nursing%3A+a+response+to+the+global+health+challenges.&aulast=Martin&pid=%3Cauthor%3EMartin+P%3C%2Fauthor%3E%3CAN%3E23288887%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<156. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23283474
TI  - Safety in numbers 5: Evaluation of computer-based authentic assessment and high fidelity simulated OSCE environments as a framework for articulating a point of registration medication dosage calculation benchmark.
SO  - Nurse Education in Practice. 13(2):e55-65, 2013 Mar.
VI  - 1
ST  - MEDLINE
AU  - Sabin M
AU  - Weeks KW
AU  - Rowe DA
AU  - Hutton BM
AU  - Coben D
AU  - Hall C
AU  - Woolley N
FA  - Sabin, Mike
FA  - Weeks, Keith W
FA  - Rowe, David A
FA  - Hutton, B Meriel
FA  - Coben, Diana
FA  - Hall, Carol
FA  - Woolley, Norman
IN  - Sabin, Mike. NHS Education for Scotland, UK.
AB  - This paper reports a key educational initiative undertaken by NHS Education for Scotland (NES), based upon recommendations from a 'Numeracy in Healthcare' consultation. We report here the design of a web-based technical measurement authentic assessment environment evolved from the safeMedicate suite of programs that provided a model for an environment within which a medication dosage calculation problem-solving (MDC-PS) benchmark could be articulated. A sample of 63 third-year pre-registration nursing students was recruited from four participating universities in the UK. A counterbalanced design was employed where the virtual authentic assessment environment was evaluated for internal consistency reliability and criterion-related validity against an objective structured clinical assessment (OSCE) undertaken in high-fidelity simulated clinical environments. Outcome measures indicated an extremely high internal consistency of the web-based environment. It was concluded that the combination of a web-based authentic assessment environment and further assessment of safe technical measurement interpretation and dexterity in a practice/practice simulation setting, populated with a benchmark and a criterion referenced rubric validated by the profession, is an innovative, viable, valid and reliable assessment method for the safe administration of medicines. As a result, the rubric for assessment of the appropriate range of calculation type and complexity informed the NMC's revised Essential Skills Clusters for Medicines Management (NMC, 2010a; NMC, 2010b). This inclusion provides a particularly strong example of both research directly influencing policy and of evidence-based regulation.

 Copyright © 2012. Published by Elsevier Ltd.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23283474
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23283474&id=doi:10.1016%2Fj.nepr.2012.10.009&issn=1471-5953&isbn=&volume=13&issue=2&spage=e55&pages=e55-65&date=2013&title=Nurse+Education+in+Practice&atitle=Safety+in+numbers+5%3A+Evaluation+of+computer-based+authentic+assessment+and+high+fidelity+simulated+OSCE+environments+as+a+framework+for+articulating+a+point+of+registration+medication+dosage+calculation+benchmark.&aulast=Sabin&pid=%3Cauthor%3ESabin+M%3C%2Fauthor%3E%3CAN%3E23283474%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<157. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23279578
TI  - The 15th International Philosophy of Nursing Conference held in association with the International Philosophy of Nursing Society (IPONS) at the West Park Centre, Dundee, Scotland, 25-28 August 2011. Healthcare and the politics of austerity.
SO  - Nursing Philosophy. 14(1):2-4, 2013 Jan.
VI  - 1
ST  - MEDLINE
AU  - Purkis ME
FA  - Purkis, Mary Ellen
IN  - Purkis, Mary Ellen. Faculty of Human and Social Development, University of Victoria, Victoria, BC, Canada.
CM  - Comment in (CIN)
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23279578
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23279578&id=doi:10.1111%2Fj.1466-769X.2012.00546.x&issn=1466-7681&isbn=&volume=14&issue=1&spage=2&pages=2-4&date=2013&title=Nursing+Philosophy&atitle=The+15th+International+Philosophy+of+Nursing+Conference+held+in+association+with+the+International+Philosophy+of+Nursing+Society+%28IPONS%29+at+the+West+Park+Centre%2C+Dundee%2C+Scotland%2C+25-28+August+2011.+Healthcare+and+the+politics+of+austerity.&aulast=Purkis&pid=%3Cauthor%3EPurkis+ME%3C%2Fauthor%3E%3CAN%3E23279578%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<158. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23260621
TI  - Developing global citizenship online: an authentic alternative to overseas clinical placement.
SO  - Nurse Education Today. 33(10):1160-5, 2013 Oct.
VI  - 1
ST  - MEDLINE
AU  - Strickland K
AU  - Adamson E
AU  - McInally W
AU  - Tiittanen H
AU  - Metcalfe S
FA  - Strickland, Karen
FA  - Adamson, Elizabeth
FA  - McInally, Wendy
FA  - Tiittanen, Hannele
FA  - Metcalfe, Sharon
IN  - Strickland, Karen. Office of the Vice Principal (Academic), Edinburgh Napier University, Sighthill Campus, Sighthill Court, Edinburgh, EH11 4BN, UK. Electronic address: k.strickland@napier.ac.uk.
AB  - BACKGROUND: This paper presents the findings of a pilot project to develop and evaluate an international nursing module delivered using a collaborative online platform between nursing programmes in Scotland, USA and Finland. The purpose of the project was to provide an authentic international nursing experience for nursing students, allowing them to explore and contrast the nursing and health care issues in an international context.
AB  - METHODS: The pilot cohort ran in September 2011 with a total of 22 students with a mix of students from both undergraduate and postgraduate programmes. A mixed methods research design was used to evaluate the students' experience using an anonymous online questionnaire and the collection of testimonials from students based on their experience.
AB  - RESULTS: The results demonstrated high levels of satisfaction with the learning experience. Four key themes-learning together, widening horizons, developing autonomy and learning beyond frontiers-emerged from the qualitative data.
AB  - CONCLUSIONS: Developing confidence from the shared learning experience has real implications for the global mobility of the nursing workforce as it helps to prepare nurses for a career beyond their own country's borders. The pilot module has clearly demonstrated that the use of Web 2.0 technology in the forms of a wiki may effectively be employed to provide an online learning environment to allow cross institutional learning.

 Crown Copyright © 2012. Published by Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23260621
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23260621&id=doi:10.1016%2Fj.nedt.2012.11.016&issn=0260-6917&isbn=&volume=33&issue=10&spage=1160&pages=1160-5&date=2013&title=Nurse+Education+Today&atitle=Developing+global+citizenship+online%3A+an+authentic+alternative+to+overseas+clinical+placement.&aulast=Strickland&pid=%3Cauthor%3EStrickland+K%3C%2Fauthor%3E%3CAN%3E23260621%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<159. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23154151
TI  - Alcohol education and training in pre-registration nursing: a national survey to determine curriculum content in the United Kingdom (UK).
SO  - Nurse Education Today. 33(9):992-7, 2013 Sep.
VI  - 1
ST  - MEDLINE
AU  - Holloway AS
AU  - Webster BJ
FA  - Holloway, Aisha S
FA  - Webster, Brian J
IN  - Holloway, Aisha S. School of Health in Social Sciences, The University of Edinburgh, The Medical School, Teviot Place, Edinburgh EH8 9AG, UK. Aisha.Holloway@edu.ac.uk
AB  - BACKGROUND: Alcohol-related harm impacts significantly on the health of the population. Nurses are often among the first health professionals that many patients with alcohol-related problems come into contact with and have been identified as playing a key role but may be ill-prepared to respond. Future nurses need to have the skills, knowledge and clinical confidence to respond to patients suffering from alcohol-related harm. A pre-registration curriculum that ensures a nursing workforce fit for practice in responding to alcohol-related harm is necessary.
AB  - OBJECTIVES: To determine the level of alcohol education and training content in the pre-registration curriculum for nursing in the United Kingdom (UK). To establish whether there are variations in the pre-registration curriculum content across the UK.
AB  - DESIGN: A descriptive study.
AB  - SETTING: All 68 UK Higher Education Institutions offering a total of 111 pre-registration courses for nurses were invited to participate in the study.
AB  - PARTICIPANTS: Twenty nine completed questionnaires were returned, a response rate of 26%. The largest number of identified responders were from England (n=15), with 3 from Scotland and 1 each from Wales and Northern Ireland. Nine Universities chose not to identify themselves.
AB  - METHODS: An online semi-structured questionnaire survey was used to collect the study data.
AB  - RESULTS: Teaching of alcohol and alcohol related harm was mainly delivered during the second year of a pre-registration nursing programme provided mainly to adult and mental health students. Overall, the majority of alcohol related content that is provided within the responding pre-registration nursing courses relates to biophysiology, aetiology, and pharmacological and non-pharmacological interventions.
AB  - CONCLUSION: This study highlights the need for a greater and more relevant focus of alcohol education to pre-registration nursing students of all fields of practice incorporating an integrated approach across all years of study.

 Copyright © 2012 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=23154151
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23154151&id=doi:10.1016%2Fj.nedt.2012.10.011&issn=0260-6917&isbn=&volume=33&issue=9&spage=992&pages=992-7&date=2013&title=Nurse+Education+Today&atitle=Alcohol+education+and+training+in+pre-registration+nursing%3A+a+national+survey+to+determine+curriculum+content+in+the+United+Kingdom+%28UK%29.&aulast=Holloway&pid=%3Cauthor%3EHolloway+AS%3C%2Fauthor%3E%3CAN%3E23154151%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<160. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22849644
TI  - An ambiguous relationship--a qualitative meta-synthesis of hospitalized somatic patients' experience of interaction with fellow patients.
SO  - Scandinavian Journal of Caring Sciences. 27(3):495-505, 2013 Sep.
VI  - 1
ST  - MEDLINE
AU  - Larsen LS
AU  - Larsen BH
AU  - Birkelund R
FA  - Larsen, Lene S
FA  - Larsen, Birte H
FA  - Birkelund, Regner
IN  - Larsen, Lene S. Centre of Nursing Science, Viborg and Department of Nursing Science, Aarhus University, Aarhus, Denmark. lela@viauc.dk
AB  - AIM: The aim of this study was to provide a clear view of the existing knowledge regarding patients' significance to fellow patients during hospitalization.
AB  - METHOD: Sandelowski and Barroso's approach to qualitative meta-synthesis was selected and systematically used for collecting and assessing findings from qualitative studies. Data consisted of seven qualitative studies published as one book, four scientific articles and two doctoral theses from Scotland, UK, Norway and Denmark. The analysis and synthesis were conducted with inspiration from both Sandelowski and Barroso and Ian Dey's approach to qualitative data analysis.
AB  - RESULTS: The qualitative meta-synthesis resulted in the heading An Ambiguous Relationship under which three core categories illustrate the hospitalized patients' different interaction roles. The core categories were as follows: (i) the fellow patient experienced as an enforced companion, (ii) the fellow patient experienced as an expert on illness and hospital life and (iii) the fellow patient experienced as a care provider. Each core category was elaborated through several subcategories. Social interaction among hospitalized patients embedded elements of both enforced and volunteered participation. Typically, the social interaction was experienced as giving and was referred to in positive terms but recurrently, the opposite was experienced too. The ambiguity of the relationship clearly emerged in all of the synthesized themes presented in this article.
AB  - IMPLICATIONS FOR PRACTICE: Hospitalized patients experienced interaction with fellow patients to be of great significance. We suggest that knowledge of patients' interaction is to be included in the nursing education and that nurses reflect on how this knowledge may be implemented as a part of caring in nursing.

 Copyright © 2012 The Authors. Scandinavian Journal of Caring Sciences © 2012 Nordic College of Caring Science.
PT  - Journal Article
PT  - Meta-Analysis
PT  - Research Support, Non-U.S. Gov't
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=22849644
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22849644&id=doi:10.1111%2Fj.1471-6712.2012.01054.x&issn=0283-9318&isbn=&volume=27&issue=3&spage=495&pages=495-505&date=2013&title=Scandinavian+Journal+of+Caring+Sciences&atitle=An+ambiguous+relationship--a+qualitative+meta-synthesis+of+hospitalized+somatic+patients%27+experience+of+interaction+with+fellow+patients.&aulast=Larsen&pid=%3Cauthor%3ELarsen+LS%3C%2Fauthor%3E%3CAN%3E22849644%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<161. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22464633
TI  - The negative influence of significant others on high academic achieving school pupils' choice of nursing as a career.
SO  - Nurse Education Today. 33(3):205-9, 2013 Mar.
VI  - 1
ST  - MEDLINE
AU  - Neilson GR
AU  - McNally J
FA  - Neilson, Gavin R
FA  - McNally, Jim
IN  - Neilson, Gavin R. School of Nursing and Midwifery, University of Dundee, United Kingdom. g.r.neilson@dundee.ac.uk
AB  - The International Council of Nurses proposes that the shortage of nurses is global in scale and is expected to become much worse in the years ahead. A major factor impacting on the worldwide nursing shortage is the diminishing number of young people choosing nursing as a career (International Council of Nurses, 2008). One important dimension of the school pupils' career choice process is their interactions with significant others and the influence of these significant others (Hodkinson and Sparkes, 1997). As Schools/Departments of Nursing endeavour to attract more intellectual school leavers it is important to examine what advice and opinions are significant others giving regarding nursing as a career choice and how influential is this advice. This paper is based on interview data from 20 high academic achieving 5th and 6th year school pupils in Scotland, paradigmatic cases from a larger sample, who had considered nursing as a possible career choice within their career preference cluster, but then later disregarded nursing and decided to pursue medicine or another health care profession. The data was particularly striking in revealing the negative influence of significant others on high academic achieving school pupils' choice of nursing as a career. The influence of significant others, these being specifically parents, guardians, guidance teachers and career advisors was very apparent in the data in that they had a very negative view regarding nursing as a career choice for high academic achieving school pupils.

 Copyright © 2012 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=22464633
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22464633&id=doi:10.1016%2Fj.nedt.2012.02.019&issn=0260-6917&isbn=&volume=33&issue=3&spage=205&pages=205-9&date=2013&title=Nurse+Education+Today&atitle=The+negative+influence+of+significant+others+on+high+academic+achieving+school+pupils%27+choice+of+nursing+as+a+career.&aulast=Neilson&pid=%3Cauthor%3ENeilson+GR%3C%2Fauthor%3E%3CAN%3E22464633%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<162. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22429932
TI  - The structure of stress: confirmatory factor analysis of a Chinese version of the stressors in Nursing Students Scale (SINS).
SO  - Nurse Education Today. 33(2):160-5, 2013 Feb.
VI  - 1
ST  - MEDLINE
AU  - Watson R
AU  - Yanhua C
AU  - Ip MY
AU  - Smith GD
AU  - Wong TK
AU  - Deary IJ
FA  - Watson, Roger
FA  - Yanhua, Chen
FA  - Ip, Maggie Y K
FA  - Smith, Graeme D
FA  - Wong, Thomas K S
FA  - Deary, Ian J
IN  - Watson, Roger. The University of Hull, Hull, UK. r.watson@hull.ac.uk
AB  - BACKGROUND: Stress is a feature of the life of nursing students and this had been well studied. However, there are very few instruments to measure stress in nursing students specifically. One such instrument, the Stressors in Nursing Students Scale has been developed in Scotland and applied in studies in Hong Kong and Australia and proved useful alongside other measures of individual differences and psychological distress.
AB  - OBJECTIVES: To translate the Stressors in Nursing Students Scale into Chinese, test it with Chinese nursing students and explore the psychometric structure of stress in this population.
AB  - DESIGN: Cross-sectional survey using a self-administered questionnaire.
AB  - SETTING: A large teaching hospital in Southwest Mainland China.
AB  - PARTICIPANTS: Nursing students (n=1090) participated (1000 in the classroom and 90 on clinical placement); 862 from the classroom and 79 from clinical placements returned questionnaires (n=914) representing a return rate of 86.3%.
AB  - METHODS: Principal component analysis and confirmatory factor analysis using structural equation modelling.
AB  - RESULTS: A four-factor structure was obtained from principal component analysis. This was confirmed (fit indices>0.9 and RMSEA<0.06) using structural equation modelling. The stress-related factors were: Clinical (0.83), Finance (0.81), Confidence (0.82), and Education (0.70).
AB  - CONCLUSIONS: The original structure of the SINS in English was confirmed in this large sample of Chinese nursing students. This will allow cross-cultural studies of stress in nursing students.

 Copyright © 2012 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=22429932
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22429932&id=doi:10.1016%2Fj.nedt.2012.02.013&issn=0260-6917&isbn=&volume=33&issue=2&spage=160&pages=160-5&date=2013&title=Nurse+Education+Today&atitle=The+structure+of+stress%3A+confirmatory+factor+analysis+of+a+Chinese+version+of+the+stressors+in+Nursing+Students+Scale+%28SINS%29.&aulast=Watson&pid=%3Cauthor%3EWatson+R%3C%2Fauthor%3E%3CAN%3E22429932%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<163. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21956976
TI  - Work stress and well-being in oncology settings: a multidisciplinary study of health care professionals.
SO  - Psycho-Oncology. 22(1):46-53, 2013 Jan.
VI  - 1
ST  - MEDLINE
AU  - Jones MC
AU  - Wells M
AU  - Gao C
AU  - Cassidy B
AU  - Davie J
FA  - Jones, Martyn C
FA  - Wells, Mary
FA  - Gao, Chuan
FA  - Cassidy, Bernadette
FA  - Davie, Jackie
IN  - Jones, Martyn C. School of Nursing and Midwifery, Alliance for Self Care Research, University of Dundee, Dundee, UK. m.c.jones@dundee.ac.uk
AB  - OBJECTIVES: Staff working in oncology report high levels of work-related stress. This arises partly from the nature of clinical work, including practitioner perceptions of high demand and low control or high effort and low reward. This comparative study investigated the correlates of work stress in a multidisciplinary group of staff and the associations between staff perceptions of the work environment, emotional distress, job satisfaction and work-based social support.
AB  - METHODS: This questionnaire study combined quantitative and qualitative assessment in a cohort sample of multidisciplinary staff (N = 85) working in a cancer centre in North East Scotland. Ethical approval was granted by the local Research Ethics Committee. This paper reports on the quantitative element of the study,
AB  - RESULTS: Response rate was 50.6% (N = 85). Older, female and nursing and support staff were more likely to participate. Support staff reported the lowest perceptions of control, job satisfaction and managerial support. Radiographers reported the highest levels of job satisfaction, co-worker and managerial support. Nurses perceived lower decision control and job satisfaction than allied health professionals or doctors. In general, perceptions of decisional control and reward were protective of job satisfaction, particularly when work demands were high. Co-worker support was associated with perceptions of reduced effort, greater reward and increased satisfaction. Managerial support was also associated with greater control beliefs. Overall, sickness absence exceeded the 5% rates seen in other National Health Service surveys, whereas turnover intention rates were similar.
AB  - CONCLUSION: The development and introduction of multilevel strategies to reduce demand, improve control and support perceptions are warranted, particularly for support staff.

 Copyright © 2011 John Wiley & Sons, Ltd.
PT  - Comparative Study
PT  - Journal Article
YR  - 2013
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med10&AN=21956976
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21956976&id=doi:10.1002%2Fpon.2055&issn=1057-9249&isbn=&volume=22&issue=1&spage=46&pages=46-53&date=2013&title=Psycho-Oncology&atitle=Work+stress+and+well-being+in+oncology+settings%3A+a+multidisciplinary+study+of+health+care+professionals.&aulast=Jones&pid=%3Cauthor%3EJones+MC%3C%2Fauthor%3E%3CAN%3E21956976%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<164. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27925541
TI  - Morale at 'all-time low' for nurses in Scottish prisons.
SO  - Nursing Standard. 31(15):10, 2016 Dec 07.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Dean E
FA  - Dean, Erin
AB  - There are 'significant concerns' about morale, recruitment and work pressures in the nursing workforce in Scottish prisons, an RCN Scotland report has warned.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27925541
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27925541&id=doi:10.7748%2Fns.31.15.10.s8&issn=0029-6570&isbn=&volume=31&issue=15&spage=10&pages=10&date=2016&title=Nursing+Standard&atitle=Morale+at+%27all-time+low%27+for+nurses+in+Scottish+prisons.&aulast=Dean&pid=%3Cauthor%3EDean+E%3C%2Fauthor%3E%3CAN%3E27925541%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<165. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27892221
TI  - Nurse shortage in care homes 'critical'.
SO  - Nursing Standard. 31(13):9, 2016 Nov 23.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The care home sector in Scotland is facing an 'intolerable' shortage of nurses, with one in four nursing posts vacant, according to a new report.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27892221
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27892221&id=doi:10.7748%2Fns.31.13.9.s5&issn=0029-6570&isbn=&volume=31&issue=13&spage=9&pages=9&date=2016&title=Nursing+Standard&atitle=Nurse+shortage+in+care+homes+%27critical%27.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27892221%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<166. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27682528
TI  - Pedometers.
SO  - Nursing Standard. 31(5):7, 2016 Sep 28.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Nursing students and trainee midwives at Edinburgh Napier University have been given pedometers to boost their health and fitness after research revealed nearly 70% of nurses in Scotland are overweight.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27682528
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27682528&id=doi:10.7748%2Fns.31.5.7.s2&issn=0029-6570&isbn=&volume=31&issue=5&spage=7&pages=7&date=2016&title=Nursing+Standard&atitle=Pedometers.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27682528%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<167. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27239303
TI  - Seeking Sepsis in the Emergency Department- Identifying Barriers to Delivery of the Sepsis 6.
SO  - BMJ Quality Improvement Reports. 5(1), 2016.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Bentley J
AU  - Henderson S
AU  - Thakore S
AU  - Donald M
AU  - Wang W
FA  - Bentley, James
FA  - Henderson, Susan
FA  - Thakore, Shobhan
FA  - Donald, Michael
FA  - Wang, Weijie
IN  - Bentley, James. NHS Tayside.
IN  - Henderson, Susan. NHS Tayside.
IN  - Thakore, Shobhan. NHS Tayside.
IN  - Donald, Michael. NHS Tayside.
IN  - Wang, Weijie. NHS Tayside.
AB  - The Sepsis 6 is an internationally accepted management bundle that, when initiated within one hour of identifying sepsis, can reduce morbidity and mortality. This management bundle was advocated by the Scottish Patient Safety Programme as part of its Acute Adult campaign launched in 2008 and adopted by NHS Tayside in 2012. Despite this, the Emergency Department (ED) of Ninewells Hospital, a tertiary referral centre and major teaching hospital in Scotland, was displaying poor success in the Sepsis 6. We therefore set out to improve compliance by evaluating the application of all aspects of the NHS Tayside Sepsis 6 bundle within one hour of ED triage time, to identify what human factors may influence achieving the one hour The Sepsis 6 bundle. This allowed us to tailor a number of specific interventions including educational sessions, regular audit and personal feedback and check list Sepsis 6 sticker. These interventions promoted a steady increase in compliance from an initial rate of 51.0% to 74.3%. The project highlighted that undifferentiated patients create a challenge in initiating the Sepsis 6. Pyrexia is a key human factor-trigger for recognising sepsis with initial nursing assessment being vital in recognition and identifying the best area (resus) of the department to manage severely septic patients. EDs need to recognise these challenges and develop educational and feedback plans for staff and utilise available resources to maximise the Sepsis 6 compliance.
PT  - Journal Article
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27239303
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27239303&id=doi:10.1136%2Fbmjquality.u206760.w3983&issn=2050-1315&isbn=&volume=5&issue=1&spage=&pages=&date=2016&title=BMJ+Quality+Improvement+Reports&atitle=Seeking+Sepsis+in+the+Emergency+Department-+Identifying+Barriers+to+Delivery+of+the+Sepsis+6.&aulast=Bentley&pid=%3Cauthor%3EBentley+J%3C%2Fauthor%3E%3CAN%3E27239303%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<168. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26838615
TI  - RCN Scotland calls on politicians to show their support for nursing issues.
SO  - Nursing Standard. 30(23):8, 2016 Feb 03.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - RCN Scotland is calling on candidates standing for election to the Scottish parliament later this year to support key nursing issues.
PT  - News
YR  - 2016
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=26838615
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26838615&id=doi:10.7748%2Fns.30.23.8.s4&issn=0029-6570&isbn=&volume=30&issue=23&spage=8&pages=8&date=2016&title=Nursing+Standard&atitle=RCN+Scotland+calls+on+politicians+to+show+their+support+for+nursing+issues.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E26838615%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<169. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27708806
TI  - "I know exactly what I'm going into": recommendations for pre-nursing experience from an evaluation of a pre-nursing scholarship in rural Scotland.
SO  - Nursing Open. 2(3):105-118, 2015 Nov.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Smith A
AU  - Beattie M
AU  - Kyle RG
FA  - Smith, Annetta
FA  - Beattie, Michelle
FA  - Kyle, Richard G
IN  - Smith, Annetta. School of Health Sciences University of Stirling (Highland Campus) Centre for Health Science Inverness UK.
IN  - Beattie, Michelle. School of Health Sciences University of Stirling (Highland Campus) Centre for Health Science Inverness UK.
IN  - Kyle, Richard G. School of Nursing Midwifery and Social Care Edinburgh Napier University UK.
AB  - AIM: To develop a model of pre-nursing experience from evaluation of a pre-nursing scholarship for school pupils in Scotland.
AB  - DESIGN: Action research study.
AB  - METHODS: School pupils (n = 42) completed questionnaire surveys and participated in anecdote circles. Student nurses acting as pupil 'buddies' (n = 33) participated in focus groups. Descriptive quantitative data and thematic analyses of qualitative data were integrated across cohorts and campuses.
AB  - RESULTS: Ten recommended components of a model of pre-nursing experience were identified: educational experience of: (1) face-to-face on-campus teaching; (2) hands-on clinical skills sessions; and (3) andragogy, practice exposure to (4) nursing language; (5) nurses' emotional labour; (6) patients' stories; (7) pupils socializing with buddies; (8) buddies planning placement activities; and (9) supporting pupils during placements. Academic attainment was not a central component of the model due to pupils' need to (10) prioritize examined work for further/higher education entry.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27708806
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27708806&id=doi:10.1002%2Fnop2.23&issn=2054-1058&isbn=&volume=2&issue=3&spage=105&pages=105-118&date=2015&title=Nursing+Open&atitle=%22I+know+exactly+what+I%27m+going+into%22%3A+recommendations+for+pre-nursing+experience+from+an+evaluation+of+a+pre-nursing+scholarship+in+rural+Scotland.&aulast=Smith&pid=%3Cauthor%3ESmith+A%3C%2Fauthor%3E%3CAN%3E27708806%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<170. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27123179
TI  - Ischemic stroke management in West Scotland: a chart review.
SO  - Journal of Market Access & Health Policy. 3, 2015.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Verpillat P
AU  - Dorey J
AU  - Guilhaume-Goulant C
AU  - Dabbous F
AU  - Aballea S
FA  - Verpillat, Patrice
FA  - Dorey, Julie
FA  - Guilhaume-Goulant, Chantal
FA  - Dabbous, Firas
FA  - Aballea, Samuel
IN  - Verpillat, Patrice. H. Lundbeck A/S, Paris, France.
IN  - Dorey, Julie. Creativ-Ceutical, Paris, France.
IN  - Guilhaume-Goulant, Chantal. Laboratoire Sante - Individu - Societe (SIS, E.A. 4129), University of Lyon 1, Lyon, France.
IN  - Dabbous, Firas. Division of Epidemiology and Biostatistics, University of Illinois at Chicago, Chicago, IL, USA.
IN  - Aballea, Samuel. Creativ-Ceutical, Paris, France.
AB  - BACKGROUND: Little information is available about the long-term management of ischemic stroke (IS) in West Scotland. In this study we aim to describe the management of IS at onset, admission, and during follow-up among patients who survived an IS event.
AB  - METHODS: General practitioners (GPs) (n=20) were randomly selected to recruit IS patients and extract data about patient characteristics, hospitalizations, discharge, and ambulatory care from GP databases, hospital letters, and direct contact with patients and their relatives. Descriptive analyses were conducted.
AB  - RESULTS: One hundred and one patients were included, with a mean age of 65.6+/-13.4. About half of the patients contacted their GPs at the time of onset (45.4%). Cardiovascular history was prevalent in 29.7% of cases, and 14% of all cases were recurrences. Of the patients, 89 (88%) were hospitalized with mean length of stay (LOS) 11.8 days. Treatment was administered on average within 12.9 hours of admission and 23.6% of the admitted patients received thrombolytic treatment. During the 1-year follow-up period, 33.6% of patients were rehospitalized and the mean LOS was 15.1+/-29.5 days. Further, patients on average sought nursing care (10.9%), physical therapy (45.5%), occupational therapy (27.7%), speech therapy (12.9%), and professional caregivers (12%).
AB  - CONCLUSION: The health-care resource utilization of IS patients is a major driver of economic burden.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=27123179
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27123179&id=doi:10.3402%2Fjmahp.v3.26339&issn=2001-6689&isbn=&volume=3&issue=&spage=&pages=&date=2015&title=Journal+of+Market+Access+%26+Health+Policy&atitle=Ischemic+stroke+management+in+West+Scotland%3A+a+chart+review.&aulast=Verpillat&pid=%3Cauthor%3EVerpillat+P%3C%2Fauthor%3E%3CAN%3E27123179%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<171. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26734378
TI  - Improving early recognition of delirium using SQiD (Single Question to identify Delirium): a hospital based quality improvement project.
SO  - BMJ Quality Improvement Reports. 4(1), 2015.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - McCleary E
AU  - Cumming P
FA  - McCleary, Elaine
FA  - Cumming, Pamela
IN  - McCleary, Elaine. School of Nursing & Midwifery, University of Dundee.
IN  - Cumming, Pamela. School of Nursing & Midwifery, University of Dundee.
AB  - Delirium is a serious condition associated with poor outcomes which can be prevented and treated if recognised early. Older people and people with dementia or severe illness are more at risk of delirium. SQiD is a simple prompt question which asks, "Is this patient more confused than before?" Focusing specifically on patients aged 75 and over, this project aimed to increase awareness and usage of SQiD to help improve early recognition of delirium, in accordance with the Healthcare Improvement Scotland national initiative. This project was carried out by two student nurses during an eight week clinical placement in the acute surgical receiving unit (ASRU) of Ninewells Hospital, Dundee, Scotland. Qualitative and quantitative methodology was used to establish baseline data which revealed that only 35% of the multidisciplinary team (MDT) were aware of SQiD, with only 15% using SQiD. Initial activities involved raising awareness of SQiD by means of information cards and posters. Once awareness was raised, the usage of the SQiD question by nurses was tested. Finally, the SQiD question was incorporated into the nursing care round forms and usage recorded. Following these awareness raising activities we noted an increase of 83% awareness and 20% use of SQiD. Incorporating the SQiD question into the hourly care round forms increased awareness to 100% and usage to 50%. Although this small scale project could be viewed as a success, the requirements for sustainability depend upon further implementation and spreading of the change. Sustained improvement is also dependent upon the implementation of the care rounds. As nursing students, undertaking this improvement project has provided valuable lessons in both quality improvement science and personal learning. The improved knowledge and understanding of effective communication and the intricacies of team working is transferrable and can be applied to future nursing practice.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=26734378
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26734378&id=doi:10.1136%2Fbmjquality.u206598.w2653&issn=2050-1315&isbn=&volume=4&issue=1&spage=&pages=&date=2015&title=BMJ+Quality+Improvement+Reports&atitle=Improving+early+recognition+of+delirium+using+SQiD+%28Single+Question+to+identify+Delirium%29%3A+a+hospital+based+quality+improvement+project.&aulast=McCleary&pid=%3Cauthor%3EMcCleary+E%3C%2Fauthor%3E%3CAN%3E26734378%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<172. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26587055
TI  - Effective management of attention-deficit/hyperactivity disorder (ADHD) through structured re-assessment: the Dundee ADHD Clinical Care Pathway.
SO  - Child & Adolescent Psychiatry & Mental Health [Electronic Resource]. 9:52, 2015.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Coghill D
AU  - Seth S
FA  - Coghill, David
FA  - Seth, Sarah
IN  - Coghill, David. Division of Neuroscience, Ninewells Hospital and Medical School, University of Dundee, Dundee, DD1 9SY UK.
IN  - Seth, Sarah. Division of Neuroscience, Ninewells Hospital and Medical School, University of Dundee, Dundee, DD1 9SY UK.
AB  - Attention-deficit/hyperactivity disorder (ADHD) has become a major aspect of the work of child and adolescent psychiatrists and paediatricians in the UK. In Scotland, Child and Adolescent Mental Health Services were required to address an increase in referral rates and changes in evidence-based medicine and guidelines without additional funding. In response to this, clinicians in Dundee have, over the past 15 years, pioneered the use of integrated psychiatric, paediatric, nursing, occupational therapy, dietetic and psychological care with the development of a clearly structured, evidence-based assessment and treatment pathway to provide effective therapy for children and adolescents with ADHD. The Dundee ADHD Clinical Care Pathway (DACCP) uses standard protocols for assessment, titration and routine monitoring of clinical care and treatment outcomes, with much of the clinical work being nurse led. The DACCP has received international attention and has been used as a template for service development in many countries. This review describes the four key stages of the clinical care pathway (referral and pre-assessment; assessment, diagnosis and treatment planning; initiating treatment; and continuing care) and discusses translation of the DACCP into other healthcare systems. Tools for healthcare professionals to use or adapt according to their own clinical settings are also provided.
PT  - Journal Article
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=26587055
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26587055&id=doi:10.1186%2Fs13034-015-0083-2&issn=1753-2000&isbn=&volume=9&issue=&spage=52&pages=52&date=2015&title=Child+%26+Adolescent+Psychiatry+%26+Mental+Health+%5BElectronic+Resource%5D&atitle=Effective+management+of+attention-deficit%2Fhyperactivity+disorder+%28ADHD%29+through+structured+re-assessment%3A+the+Dundee+ADHD+Clinical+Care+Pathway.&aulast=Coghill&pid=%3Cauthor%3ECoghill+D%3C%2Fauthor%3E%3CAN%3E26587055%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<173. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 26350837
TI  - Academics draw up ten-point plan for pre-degree nursing scholarship.
SO  - Nursing Standard. 30(2):11, 2015 Sep 09.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Duffin C
FA  - Duffin, Christian
AB  - A ten-point plan for a pre-degree 'scholarship' has been drawn up by academics in Scotland in a bid to give school pupils a chance to determine whether to pursue a nursing career.
PT  - News
YR  - 2015
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=26350837
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:26350837&id=doi:10.7748%2Fns.30.2.11.s13&issn=0029-6570&isbn=&volume=30&issue=2&spage=11&pages=11&date=2015&title=Nursing+Standard&atitle=Academics+draw+up+ten-point+plan+for+pre-degree+nursing+scholarship.&aulast=Duffin&pid=%3Cauthor%3EDuffin+C%3C%2Fauthor%3E%3CAN%3E26350837%3C%2FAN%3E%3CDT%3ENews%3C%2FDT%3E

<174. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 25355108
TI  - Chief nursing officer for Scotland leaves a legacy of improvement.
SO  - Nursing Management (Harrow). 21(7):9, 2014 Oct 30.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Nadeem B
FA  - Nadeem, Beena
AB  - AFTER FOUR years in post, chief nursing officer (CNO) for Scotland Ros Moore is stepping down. Ms Moore, who leaves the job at the end of this year, has been credited with making significant improvements in the fields of nursing and midwifery.
PT  - Journal Article
YR  - 2014
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm3&AN=25355108
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:25355108&id=doi:10.7748%2Fnm.21.7.9.s11&issn=1354-5760&isbn=&volume=21&issue=7&spage=9&pages=9&date=2014&title=Nursing+Management+%28Harrow%29&atitle=Chief+nursing+officer+for+Scotland+leaves+a+legacy+of+improvement.&aulast=Nadeem&pid=%3Cauthor%3ENadeem+B%3C%2Fauthor%3E%3CAN%3E25355108%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<175. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22621255
TI  - Stress amongst nurses working in a healthcare telephone-advice service: relationship with job satisfaction, intention to leave, sickness absence, and performance.
SO  - Journal of Advanced Nursing. 68(7):1624-35, 2012 Jul.
VI  - 1
ST  - MEDLINE
AU  - Farquharson B
AU  - Allan J
AU  - Johnston D
AU  - Johnston M
AU  - Choudhary C
AU  - Jones M
FA  - Farquharson, Barbara
FA  - Allan, Julia
FA  - Johnston, Derek
FA  - Johnston, Marie
FA  - Choudhary, Carolyn
FA  - Jones, Martyn
IN  - Farquharson, Barbara. Institute of Applied Health Sciences, College of Life Sciences and Medicine, Aberdeen, UK. barbara.farquharson1@stir.ac.uk
AB  - AIMS: This paper is a report of a study, which assessed levels of stress amongst nurses working in a healthcare telephone-advice service. We explored whether stress related to performance, sickness absence, and intention to leave.
AB  - BACKGROUND: Nurses report high levels of stress, as do call-centre workers. The emergence of telephone health advice services means many nurses now work in call-centres, doing work that differs markedly from traditional nursing roles. Stress associated with these roles could have implications for nurses, patients, and service provision.
AB  - DESIGN: This paper reports cross-sectional survey results. The design of the overall study included longitudinal elements.
AB  - METHOD: A comprehensive study of stress was conducted amongst nurses working for a telephone-advice service in Scotland (2008-2010). All nurse-advisors were approached by letter and invited to participate. A total of 152 participants (33%) completed a questionnaire including General Health Questionnaire-12, Work Family Conflict Questionnaire, Job Satisfaction Scale and a measure of intention to leave the telephone-advice service and rated the perceived stress of 2 working shifts. Nurses' employers provided data on sickness absence and performance.
AB  - RESULTS: Overall levels of psychological distress were similar to those found amongst Scottish women generally. In multiple regression, work-family conflict was identified as a significant predictor of job satisfaction and intention to leave, and significantly related to sickness absence. There were significant correlations between General Health Questionnaire scores and perceived stress of shifts and some performance measures.
AB  - CONCLUSIONS: Work-family conflict is a significant predictor of job satisfaction, intention to leave, and sickness absence amongst telephone helpline nurses. Minimizing the impact of nurses' work on their home lives might reduce turnover and sickness absence.

 Copyright © 2012 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22621255
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22621255&id=doi:10.1111%2Fj.1365-2648.2012.06006.x&issn=0309-2402&isbn=&volume=68&issue=7&spage=1624&pages=1624-35&date=2012&title=Journal+of+Advanced+Nursing&atitle=Stress+amongst+nurses+working+in+a+healthcare+telephone-advice+service%3A+relationship+with+job+satisfaction%2C+intention+to+leave%2C+sickness+absence%2C+and+performance.&aulast=Farquharson&pid=%3Cauthor%3EFarquharson+B%3C%2Fauthor%3E%3CAN%3E22621255%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<176. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23252051
TI  - Compassion for keeps.
SO  - Nursing Standard. 27(2):20-2, 2012 Sep 12-18.
VI  - 1
ST  - MEDLINE
AU  - Trueland J
FA  - Trueland, Jennifer
AB  - A three-year programme in Scotland to encourage compassion in every aspect of nursing care drew to a close this summer. However, senior nurses are still involved in the Leadership in Compassionate Care programme, and are determined that its influence will continue to spread across the country.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=23252051
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23252051&id=doi:10.7748%2Fns.27.2.20.s28&issn=0029-6570&isbn=&volume=27&issue=2&spage=20&pages=20-2&date=2012&title=Nursing+Standard&atitle=Compassion+for+keeps.&aulast=Trueland&pid=%3Cauthor%3ETrueland+J%3C%2Fauthor%3E%3CAN%3E23252051%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<177. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23082362
TI  - Stroke rehabilitation and discharge planning.
SO  - Nursing Standard. 27(1):35-9, 2012 Sep 5-11.
VI  - 1
ST  - MEDLINE
AU  - Kerr P
FA  - Kerr, Peter
IN  - Kerr, Peter. Acute Stroke Unit, Western Infirmary, Glasgow. peter.kerr2@ggc.scot.nhs.uk
AB  - Nurses play a pivotal role in the rehabilitation and discharge planning process of patients who have had a stroke. The nurse's role in the wider stroke multidisciplinary team is complex and diverse and, as such, stroke nurses may find it hard to describe their role and how it fits into the rehabilitation and discharge planning process. A definition of the stroke nurse role in prominent publications such as those of the Scottish Intercollegiate Guidelines Network and the Royal College of Physicians is lacking. This article emphasises the role of the stroke nurse in the rehabilitation and discharge planning process in the stroke unit, while highlighting the complexity, diversity and importance of this role in providing holistic care and support for patients who have survived a stroke. The author draws on his clinical experience of stroke nursing practice in primary, secondary and tertiary care in west central Scotland.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=23082362
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23082362&id=doi:10.7748%2Fns2012.09.27.1.35.c9269&issn=0029-6570&isbn=&volume=27&issue=1&spage=35&pages=35-9&date=2012&title=Nursing+Standard&atitle=Stroke+rehabilitation+and+discharge+planning.&aulast=Kerr&pid=%3Cauthor%3EKerr+P%3C%2Fauthor%3E%3CAN%3E23082362%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<178. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23050503
TI  - Students' perception of a problem-based learning scenario in dental nurse education.
SO  - European Journal of Dental Education. 16(4):218-23, 2012 Nov.
VI  - 1
ST  - MEDLINE
AU  - Anderson V
AU  - Reid K
FA  - Anderson, V
FA  - Reid, K
IN  - Anderson, V. School of Education, University of Glasgow, Glasgow, UK. victoria.m.hadden@gmail.com
AB  - BACKGROUND: In July 2008, The General Dental Council implemented mandatory registration for Dental Nurses in the United Kingdom, recognising them as legally responsible for patient care. As dentistry comes to terms with the impact registration has on dental nurses, sustained advances in the teaching of students in other healthcare disciplines demonstrate the way in which the role of pedagogy in dental nurse education has been underdeveloped. In an attempt to see dental nursing stand in line with other progressive healthcare professionals, the authors have implemented Problem-Based Learning (PBL) into a dental nurse program in NHS Education for Scotland, Glasgow.
AB  - AIM: The aim of the research is to assess the perceptions of dental nurse students with regard to participation in active learning.
AB  - MATERIALS AND METHODS: The study is facilitated by a short PBL package which offers introductory exposure to this method of learning. A qualitative approach has been taken to gather experiential data using a questionnaire. Thematic analysis took place to reveal emergent themes.
AB  - RESULTS: Analysis reveals that the participants found PBL to be an enjoyable experience that could be valuable in the acquisition of deep knowledge and improved patient care. The participants raised concerns with regard to confidence in their own knowledge acquisition in PBL sessions and highlighted a need for improved feedback.
AB  - DISCUSSION AND CONCLUSION: While the participants enjoyed the self directed nature of PBL, it is important to note that the need for facilitator guidance was considered imperative, especially where the students had little or no experience of PBL, as in this study.

 Copyright © 2012 John Wiley & Sons A/S.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=23050503
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23050503&id=doi:10.1111%2Fj.1600-0579.2012.00745.x&issn=1396-5883&isbn=&volume=16&issue=4&spage=218&pages=218-23&date=2012&title=European+Journal+of+Dental+Education&atitle=Students%27+perception+of+a+problem-based+learning+scenario+in+dental+nurse+education.&aulast=Anderson&pid=%3Cauthor%3EAnderson+V%3C%2Fauthor%3E%3CAN%3E23050503%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<179. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23008900
TI  - What influences mentors to pass or fail students.
SO  - Nursing Management (Harrow). 19(5):16-21, 2012 Sep.
VI  - 1
ST  - MEDLINE
AU  - Brown L
AU  - Douglas V
AU  - Garrity J
AU  - Shepherd CK
FA  - Brown, Lynn
FA  - Douglas, Valerie
FA  - Garrity, John
FA  - Shepherd, Chew Kim
IN  - Brown, Lynn. University of the West of Scotland.
AB  - The aim of the study was to establish mentorship practice in relation to the University of the West of Scotland pre-registration nursing students. Surveys were sent to 4,341 mentors, with a 41 per cent response rate. Results show that 18 per cent of participants had passed a failing student. A number of factors influenced mentors' decisions, which to some extent echo findings from previous research. However, this study provides new perspectives on failing to fail and considers the supportive role of universities in relation to mentors and students' practice placements. The knowledge derived from this study will help inform mentoring and mentorship practice to ensure only safe and competent practitioners gain entry to the register.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=23008900
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23008900&id=doi:10.7748%2Fnm2012.09.19.5.16.c9260&issn=1354-5760&isbn=&volume=19&issue=5&spage=16&pages=16-21&date=2012&title=Nursing+Management+%28Harrow%29&atitle=What+influences+mentors+to+pass+or+fail+students.&aulast=Brown&pid=%3Cauthor%3EBrown+L%3C%2Fauthor%3E%3CAN%3E23008900%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<180. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22874826
TI  - A curriculum to ensure nursing staff competency.
SO  - British Journal of Nursing. 21(15):S10, S12, S14, S16-7, 2012 Aug 9-Sep 12.
VI  - 1
ST  - MEDLINE
AU  - Maylor ME
FA  - Maylor, Miles E
IN  - Maylor, Miles E. Tissue Viability Directorate, Oxford Radcliffe Hospitals NHS Trust.
AB  - Nurses and healthcare assistants (HCAs) involved in tissue viability are expected to be competent, but there is little agreement over how to define competence or the expertise required by people filling different roles. Most training in England is provided in house by tissue viability nurses or interested non-specialists; England is lagging behind Scotland and Wales in terms of learning materials and other resources. Staff members at a strategic health authority were surveyed so a consensus could be reached over a basic curriculum for tissue viability and the competence expected of nurses and HCAs at different levels of seniority. Respondents agreed that five topics should be covered by both nurses and HCAs: wound healing; leg ulceration; pressure ulceration; diabetic foot; and skin care. Levels of expertise and competence would depend on seniority. The curriculum provides a checklist that local tissue viability nurses can use as a basis for training colleagues. Trusts and educational providers should set a curriculum for tissue viability and standards of competence.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22874826
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22874826&id=doi:10.12968%2Fbjon.2012.21.Sup15.S10&issn=0966-0461&isbn=&volume=21&issue=15&spage=S10&pages=S10%2C+S12%2C+S14%2C+S16-7&date=2012&title=British+Journal+of+Nursing&atitle=A+curriculum+to+ensure+nursing+staff+competency.&aulast=Maylor&pid=%3Cauthor%3EMaylor+ME%3C%2Fauthor%3E%3CAN%3E22874826%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<181. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22683178
TI  - Evaluating Hub and Spoke models of practice learning in Scotland, UK: a multiple case study approach.
SO  - Nurse Education Today. 32(7):782-9, 2012 Oct.
VI  - 1
ST  - MEDLINE
AU  - Roxburgh M
AU  - Conlon M
AU  - Banks D
FA  - Roxburgh, Michelle
FA  - Conlon, Margaret
FA  - Banks, Debbie
IN  - Roxburgh, Michelle. University of Stirling, School of Nursing, Midwifery & Health, Stirling Campus, FK9 4LS, Scotland, UK. Cmr3@stir.ac.uk
AB  - BACKGROUND: Most of UK students' practice learning experience is based on a rotational placement model which often leads to students lacking confidence and feeling anxious about the complexities of the care environment.
AB  - OBJECTIVES: To evaluate the impact of Hub and Spoke model(s) of clinical practice placement across geographically diverse locations, with a particular focus on enhancing the student practice learning experience.
AB  - DESIGN: Multiple case study design.
AB  - SETTING & PARTICIPANTS: Comprised undergraduate student nurses from Adult, Learning Disability and Mental Health programmes from 3 Scottish Schools of Nursing.
AB  - METHODS: A mixed methods approach which included quantitative and qualitative date tools.
AB  - RESULTS: All three Hub and Spoke models shared two broad findings: 1) In the three Hub and Spoke models detailed in this paper, there is a continuum of student led learning which supports the process with opportunities for individual students to be positively innovative and creative in their learning approaches. Depth of learning was achieved in two ways; a) the method in which Hub placements are organised, managed and structured and, b) the depth of empathy and sensitivity to the individual at the centre of the care. 2) Placement capacity is increased: The classification of placements is reviewed to produce broader categories, Engagement of mentors/enhanced student/mentor relationship.
AB  - CONCLUSIONS: Practice Learning must be seen as an academic endeavour that promotes deep, meaningful, person-centred learning rather than superficial, compartmentalised placement-centred learning.

 Copyright © 2012 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22683178
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22683178&id=doi:10.1016%2Fj.nedt.2012.05.004&issn=0260-6917&isbn=&volume=32&issue=7&spage=782&pages=782-9&date=2012&title=Nurse+Education+Today&atitle=Evaluating+Hub+and+Spoke+models+of+practice+learning+in+Scotland%2C+UK%3A+a+multiple+case+study+approach.&aulast=Roxburgh&pid=%3Cauthor%3ERoxburgh+M%3C%2Fauthor%3E%3CAN%3E22683178%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<182. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22464632
TI  - Untangling a complex issue: an overview of initiatives to support nursing and midwifery student recruitment, selection and retention in Scottish Universities. [Review]
SO  - Nurse Education Today. 32(4):469-74, 2012 May.
VI  - 1
ST  - MEDLINE
AU  - Sabin M
AU  - Taylor R
AU  - Tilley C
FA  - Sabin, Michael
FA  - Taylor, Ruth
FA  - Tilley, Colin
IN  - Sabin, Michael. NHS Education for Scotland, Hanover Buildings, Rose Street, Edinburgh, EH2 2NN, UK. Mike.Sabin@nes.scot.nhs.uk
AB  - The reasons behind attrition rates in nursing and midwifery are many and complex. However, of the four UK countries, Scotland has been consistently cited as having the highest attrition rate from its pre-registration nursing and midwifery education programmes. This paper provides an overview of a nationally coordinated programme of work to support evidence-based intervention and identifies both opportunities for further national and international initiatives and presents early indicators of improvement in retention and completion.

 Copyright © 2012 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Review
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22464632
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22464632&id=doi:10.1016%2Fj.nedt.2012.02.009&issn=0260-6917&isbn=&volume=32&issue=4&spage=469&pages=469-74&date=2012&title=Nurse+Education+Today&atitle=Untangling+a+complex+issue%3A+an+overview+of+initiatives+to+support+nursing+and+midwifery+student+recruitment%2C+selection+and+retention+in+Scottish+Universities.&aulast=Sabin&pid=%3Cauthor%3ESabin+M%3C%2Fauthor%3E%3CAN%3E22464632%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<183. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22408216
TI  - Managing acute medical admissions: the plight of the medical boarder.
SO  - Scottish Medical Journal. 57(1):45-7, 2012 Feb.
VI  - 1
ST  - MEDLINE
AU  - McKnight JA
AU  - Espie C
FA  - McKnight, J A
FA  - Espie, C
IN  - McKnight, J A. Metabolic Unit, Western General Hospital, Edinburgh EH4 2XU, Scotland, UK. john.mcknight@nhs.net
AB  - In an ideal system, patients admitted acutely to hospital should have their care provided in an area with the most appropriate ward-based medical, nursing and allied professional staff profile. Frequently this does not happen due to the physical structure and organisation of our hospitals in Scotland. Acute medical admissions may be fitted in to the end of many different speciality ward areas while still under the care of a single internal medicine team - as 'medical boarders'. A survey of local medical and nursing staff revealed that a majority would not wish their relatives to be cared for in this way. It remains important to provide speciality beds for those patients who require them, but it is also necessary to develop a system that enables more patients to receive optimal care in the correct environment. In this article, we describe the issue, the problems created and some possible solutions.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22408216
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22408216&id=doi:10.1258%2Fsmj.2011.011187&issn=0036-9330&isbn=&volume=57&issue=1&spage=45&pages=45-7&date=2012&title=Scottish+Medical+Journal&atitle=Managing+acute+medical+admissions%3A+the+plight+of+the+medical+boarder.&aulast=McKnight&pid=%3Cauthor%3EMcKnight+JA%3C%2Fauthor%3E%3CAN%3E22408216%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<184. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22225893
TI  - Pre-prescribing: a safe way to learn at work?.
SO  - The clinical teacher. 9(1):45-9, 2012 Feb.
VI  - 1
ST  - MEDLINE
AU  - Smith SE
AU  - Tallentire VR
AU  - Cameron HS
AU  - Wood SM
FA  - Smith, Samantha E
FA  - Tallentire, Victoria R
FA  - Cameron, Helen S
FA  - Wood, S Morwenna
IN  - Smith, Samantha E. University of Edinburgh, Edinburgh, UK. sam.smith@ed.ac.uk
AB  - BACKGROUND: The General Medical Council mandates that UK medical graduates must be able to 'prescribe drugs safely, effectively and economically'. However, data from three UK medical schools show that graduates are poorly prepared for prescribing, and a recent study detected a prescribing error rate of 8.4 per cent amongst foundation year 1 doctors.
AB  - CONTEXT: This study took place in the National Health Service (NHS) Fife where, in common with all health boards in the UK, medical students are not permitted to prescribe. University of Edinburgh final-year medical student volunteers took part in the study.
AB  - INNOVATION: Medical, pharmacy and nursing staff collaborated to design and implement a controlled process (pre-prescribing) that allows medical students to write instructions on in-patient drug charts, and requires a doctor's countersignature before drugs are dispensed. Key features of the pre-prescribing protocol include fluorescent stickers for drug charts, bookmark aide-memoires to guide countersigning and ward-based information sheets. Twelve final-year medical students wrote 586 pre-prescriptions, and no adverse events were reported.
AB  - IMPLICATIONS: This study demonstrates the successful small-scale implementation of pre-prescribing. Initial data regarding the safety of the process is positive, but further evaluation is required to reassure all that the risk of adverse events is minimal. The project is to be expanded throughout South East Scotland with a view to all units providing the opportunity for pre-prescribing during the first student assistantships in March 2012. The longer-term goal is to set-up safe processes that will support medical students undertaking pre-prescribing throughout most of their final year.

 Copyright © Blackwell Publishing Ltd 2012.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22225893
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22225893&id=doi:10.1111%2Fj.1743-498X.2011.00506.x&issn=1743-4971&isbn=&volume=9&issue=1&spage=45&pages=45-9&date=2012&title=The+clinical+teacher&atitle=Pre-prescribing%3A+a+safe+way+to+learn+at+work%3F.&aulast=Smith&pid=%3Cauthor%3ESmith+SE%3C%2Fauthor%3E%3CAN%3E22225893%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<185. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22213312
TI  - The Scots' Paradox: can sun exposure, or lack of it, explain major paradoxes in epidemiology?. [Review]
SO  - Anticancer Research. 32(1):237-48, 2012 Jan.
VI  - 1
ST  - MEDLINE
AU  - Gillie O
FA  - Gillie, Oliver
IN  - Gillie, Oliver. Health Research Forum, 68 Whitehall Park, London N19 3TN, UK. olivergillie@blueyonder.co.uk
AB  - Five epidemiological paradoxes that have puzzled epidemiologists for a decade or more can be explained by the UVB-vitamin D hypothesis. The Scots' Paradox is examined in detail as an example. Many subsidiary factors varying over time and place influence the amount of UVB which reaches the skin of individuals and so the amount of vitamin D synthesised, while other factors influence the amount ingested. These factors are plotted leading to a common pathway that ends in vitamin D insufficiency and consequent disease. Examples suggest that the factors interact to increase mortality in Scotland in a way consistent with causation according to the criteria of Bradford Hill. It is suggested that different degrees of vitamin D insufficiency in populations can explain important differences in the health of nations and resolve health paradoxes. The analysis also shows that vitamin D insufficiency is a consequence of industrialisation and, like other consequences of industrial growth, such as water and air pollution, needs to be corrected by public health measures. Direct intervention with use of supplements and fortification of foods with vitamin D can be expected to provide considerable health gains, but progress will be slow until there is greater recognition of the vitamin D health crisis by the public, professionals and politicians. Health professionals need to be trained and motivated to encourage use of supplements, particularly by pregnant and nursing mothers, and infants. The importance of open sunny spaces and clean air that allows full penetration of UVB needs to be recognised by city planners and politicians. New advice and new fashions are needed to encourage maximum exposure of skin to summer sun without burning. Use of sunlamps to boost vitamin D synthesis could be useful.
PT  - Journal Article
PT  - Review
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22213312
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22213312&id=doi:&issn=0250-7005&isbn=&volume=32&issue=1&spage=237&pages=237-48&date=2012&title=Anticancer+Research&atitle=The+Scots%27+Paradox%3A+can+sun+exposure%2C+or+lack+of+it%2C+explain+major+paradoxes+in+epidemiology%3F.&aulast=Gillie&pid=%3Cauthor%3EGillie+O%3C%2Fauthor%3E%3CAN%3E22213312%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<186. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22142456
TI  - Learning Disability Liaison Nursing Services in south-east Scotland: a mixed-methods impact and outcome study.
SO  - Journal of Intellectual Disability Research. 56(12):1161-74, 2012 Dec.
VI  - 1
ST  - MEDLINE
AU  - Brown M
AU  - MacArthur J
AU  - McKechanie A
AU  - Mack S
AU  - Hayes M
AU  - Fletcher J
FA  - Brown, M
FA  - MacArthur, J
FA  - McKechanie, A
FA  - Mack, S
FA  - Hayes, M
FA  - Fletcher, J
IN  - Brown, M. Faculty of Health and Life Sciences, Edinburgh Napier University, UK. m.brown@napier.ac.uk
AB  - BACKGROUND: There have been significant concerns about the care and treatment of people with intellectual disabilities (ID) when attending general hospitals, which have led to inquiries that highlight service and systems failures. One response has been the development of Learning Disability Liaison Nursing (LDLN) Services across the UK that aim to ensure that additional, specialist support is available for patients, their carers and general healthcare professionals.
AB  - METHODS: A mixed-methods study to investigate the impact of LDLN Services across four Scottish NHS boards was undertaken. In total, 323 referrals made over 18 months were analysed along with qualitative data drawn from interviews and focus groups with a sample of 85 participants including patients with ID (n = 5), carers (n = 16), primary care healthcare professionals (n = 39) and general hospital professionals (n = 19) and learning disability liaison nurses (n = 6).
AB  - RESULTS: The referral patterns to the four liaison nursing services closely matched the known health needs of adults with ID, with common admissions being due to neurological, respiratory and gastrointestinal issues. The LDLN role was seen to be complex and impacted on three key areas: (i) clinical patient care; (ii) education and practice development; and (iii) strategic organisational developments. Specific patient outcomes were linked to issues relating to capacity and consent to treatment, fostering person-centred adjustments to care, augmenting communication and the liaison nurses acting as positive role models and ambassadors for people with ID.
AB  - CONCLUSIONS: The LDLN Services were valued by stakeholders by achieving person-centred outcomes. With their expert knowledge and skills, the liaison nurses had an important role in developing effective systems and processes within general hospital settings. The outcomes highlight the importance of supporting and promoting LDLN Services and the challenges in delivering the multifaceted elements of the role. There is a need to take account of the complex and multidimensional nature of the LDLN role and the possible tensions between achieving clinical outcomes, education and practice developments and organisational strategic initiatives.

 Copyright © 2011 The Authors. Journal of Intellectual Disability Research © 2011 Blackwell Publishing Ltd.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22142456
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22142456&id=doi:10.1111%2Fj.1365-2788.2011.01511.x&issn=0964-2633&isbn=&volume=56&issue=12&spage=1161&pages=1161-74&date=2012&title=Journal+of+Intellectual+Disability+Research&atitle=Learning+Disability+Liaison+Nursing+Services+in+south-east+Scotland%3A+a+mixed-methods+impact+and+outcome+study.&aulast=Brown&pid=%3Cauthor%3EBrown+M%3C%2Fauthor%3E%3CAN%3E22142456%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<187. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22081511
TI  - Estimating the prevalence of dementia: cognitive screening in Glasgow nursing homes.
SO  - International Journal of Geriatric Psychiatry. 27(8):785-91, 2012 Aug.
VI  - 1
ST  - MEDLINE
AU  - Lithgow S
AU  - Jackson GA
AU  - Browne D
FA  - Lithgow, Stephen
FA  - Jackson, Graham A
FA  - Browne, Debbie
IN  - Lithgow, Stephen. Leverndale Hospital, Glasgow, G53 7TU, UK.
AB  - OBJECTIVES: The purpose of this study is to establish existing levels of dementia in nursing homes.
AB  - DESIGN: The design was a randomised sample of every sixth nursing home resident in Glasgow City. Cognitive testing of 341 residents was carried out using the Standardised Mini Mental State Examination (SMMSE). For clients who had difficulty participating, the Functional Assessment Staging Tool (FAST) was used. Existing dementia diagnoses were compared with the prevalence indicated through cognitive testing.
AB  - MAIN OUTCOME MEASURES: Standardised Mini Mental State Examination and the FAST were used.
AB  - SETTING: This study was conducted in the nursing homes in the Glasgow City Council Local Authority, Scotland, UK (N = 49). Forty-eight homes participated in the study and one declined.
AB  - PARTICIPANTS: The participants were residents of the nursing homes in Glasgow City, including those in existing dementia units (sample = 422 of population 2532); 19 declined and 403 participated.
AB  - RESULTS: Two hundred thirty-four (58%) residents already had a diagnosis of dementia written in their care plans. One hundred twenty-eight residents (31.8%) without diagnosis of dementia in their care plans scored within the range of possible dementia (less than 24/30 on the SMMSE). A group of 55 (13.6%) residents had no diagnosis of dementia but had some type of cognitive impairment recorded in their notes and scored within the range of possible dementia on the SMMSE.
AB  - CONCLUSION: Existing levels of dementia diagnosis are 58%. This study finds an additional 31.8% of residents without a diagnosis of dementia who score within the range of possible dementia, giving a ceiling of 89.8%. It appears that underdiagnosis of dementia exists within this 31.8% group.

 Copyright © 2011 John Wiley & Sons, Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22081511
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22081511&id=doi:10.1002%2Fgps.2784&issn=0885-6230&isbn=&volume=27&issue=8&spage=785&pages=785-91&date=2012&title=International+Journal+of+Geriatric+Psychiatry&atitle=Estimating+the+prevalence+of+dementia%3A+cognitive+screening+in+Glasgow+nursing+homes.&aulast=Lithgow&pid=%3Cauthor%3ELithgow+S%3C%2Fauthor%3E%3CAN%3E22081511%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<188. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 22074458
TI  - The lifeworld characteristics of mental health nurses engaging in talk-based therapies: a qualitative study from Scotland and England.
SO  - Journal of Psychiatric & Mental Health Nursing. 19(4):303-9, 2012 May.
VI  - 1
ST  - MEDLINE
AU  - Hurley J
FA  - Hurley, J
IN  - Hurley, J. Southern Cross University, School of Health and Human Sciences, Coffs Harbour, NSW 2450, Australia. john.hurley@scu.edu.au
AB  - Twenty-four mental health nurses were interviewed to gain a greater understanding of their experiences of working within roles delivering talk-based therapies. The study participants, while echoing the broad direction and purpose of policy that supports mental health nurses expanding talk-based therapy roles, also offered insights into the challenges associated with embedding these roles into mental health settings. One area of findings analysed using Nvivo 8 software related to the characteristics of the environments in which these roles are, or will be enacted. Three key characteristics of these environments were: (1) low power and worth; (2) obstacles to success; and (3) uncertainty. Responses to the challenges found within this study are required from individual nurses, local organizations and strategic levels of nursing to ensure the successful implementation and uptake of talk-based therapy roles into the mental health nursing profession.

 Copyright © 2011 Blackwell Publishing.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=22074458
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:22074458&id=doi:10.1111%2Fj.1365-2850.2011.01788.x&issn=1351-0126&isbn=&volume=19&issue=4&spage=303&pages=303-9&date=2012&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=The+lifeworld+characteristics+of+mental+health+nurses+engaging+in+talk-based+therapies%3A+a+qualitative+study+from+Scotland+and+England.&aulast=Hurley&pid=%3Cauthor%3EHurley+J%3C%2Fauthor%3E%3CAN%3E22074458%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<189. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21986275
TI  - Care to be a nurse? Reflections on a radio broadcast and its ramifications for nursing today.
SO  - Nurse Education Today. 32(5):614-7, 2012 Jul.
VI  - 1
ST  - MEDLINE
AU  - Shields L
AU  - Morrall P
AU  - Goodman B
AU  - Purcell C
AU  - Watson R
FA  - Shields, Linda
FA  - Morrall, Peter
FA  - Goodman, Benny
FA  - Purcell, Christine
FA  - Watson, Roger
IN  - Shields, Linda. School of Nursing and Midwifery, Curtin University and Child and Adolescent Health Service, Perth, Western Australia, Australia. l.shields@curtin.edu.au
AB  - Nursing education in the UK has lagged behind most of the developed world since inception of Project 2000 because in England, a diploma has been accepted as the basis for education, unlike other countries (including Scotland and Wales) a degree has been the accepted standard for many years. While Australia's nursing education has been more protected, an anti-intellectualism is creeping in with a technical college now offering a nursing degree, and some universities lowering their admission standards for nursing courses. Changes in the UK being imposed through the influence of the global financial crisis threaten nursing even further and this is not helped by short sighted media reports of problems with nursing care in the National Health Service. This paper examines the continuing devaluing of critical thinking, something that we contend, with the strongest emphasis, should be at the core of every aspect of nursing practice, education and research., and implications for nursing in both the UK and Australia.

 Copyright © 2011 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=21986275
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21986275&id=doi:10.1016%2Fj.nedt.2011.09.001&issn=0260-6917&isbn=&volume=32&issue=5&spage=614&pages=614-7&date=2012&title=Nurse+Education+Today&atitle=Care+to+be+a+nurse%3F+Reflections+on+a+radio+broadcast+and+its+ramifications+for+nursing+today.&aulast=Shields&pid=%3Cauthor%3EShields+L%3C%2Fauthor%3E%3CAN%3E21986275%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<190. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21852026
TI  - What predicts the selection of nursing as a career choice in 5th and 6th year school students?.
SO  - Nurse Education Today. 32(5):588-93, 2012 Jul.
VI  - 1
ST  - MEDLINE
AU  - Neilson GR
AU  - Jones MC
FA  - Neilson, Gavin R
FA  - Jones, Martyn C
IN  - Neilson, Gavin R. School of Nursing and Midwifery, University of Dundee, United Kingdom. G.R.NEILSON@DUNDEE.AC.UK
AB  - Demand for nursing care, and nurses, is growing in the United Kingdom given an increasingly ageing patient population with long-term co-morbidities. An ageing nursing workforce and fewer school leavers entering nursing are key barriers to student nurse recruitment. This paper aims to identify the socio-demographic and correlates nursing as a career choice in 5th and 6th year school students. This cross-sectional descriptive study gathered self-administered questionnaires from a total cohort of 5th and 6th year school students (n=1059) in one educational authority in Scotland. A response rate of 100% was achieved, with 702 students expressing a career choice. Some 71.7% (n=503) of students providing a full data set would never consider nursing, even if they obtained poor grades. Only 28.3% (n=199) would ever consider nursing. Students cited nursing as a career choice if they were female, of average to below average academic ability/achievement, expressed a positive attitude to nursing as a degree subject which was shared by their career guidance teacher. Each additional higher reduced the likelihood of nursing as a career choice by 22%. Nursing is an unpopular career choice amongst school students. Strategies are required to improve the occupational image of nursing in secondary education.

 Copyright © 2011 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=21852026
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21852026&id=doi:10.1016%2Fj.nedt.2011.06.011&issn=0260-6917&isbn=&volume=32&issue=5&spage=588&pages=588-93&date=2012&title=Nurse+Education+Today&atitle=What+predicts+the+selection+of+nursing+as+a+career+choice+in+5th+and+6th+year+school+students%3F.&aulast=Neilson&pid=%3Cauthor%3ENeilson+GR%3C%2Fauthor%3E%3CAN%3E21852026%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<191. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21745759
TI  - A review of evidence for the practice learning environment: enhancing the context for nursing and midwifery care in Scotland. [Review]
SO  - Nurse Education in Practice. 12(1):60-4, 2012 Jan.
VI  - 1
ST  - MEDLINE
AU  - Holland K
AU  - Lauder W
FA  - Holland, Karen
FA  - Lauder, William
IN  - Holland, Karen. School of Nursing and Midwifery, Mary Seacole Building, University of Salford, UK. k.holland@salford.ac.uk
AB  - This paper considers the issues which will ensure practice learning excellence in the future and in particular how these will impact on the delivery of high quality nursing and midwifery care in Scotland in the United Kingdom (UK). This will include the inter-dependency of learning in practice for undergraduate pre-registration students and qualified practitioners, in particular continuing professional development as a lifelong experience and its link to quality care provision. We contend that the practice learning environment is the whole of an organisation which values and supports the development of its workforce through education. Partnership working between education and service providers is central to ensuring an educated and professionally prepared workforce. Both nursing and midwifery are practice-based professions which are accountable for, and charged with assuring, effective public health and safety. The initial paper which established the key issues discussed here was initially written as one of the key background papers for a consensus conference to inform NHS Education for Scotland's nursing and midwifery workforce development over the next five years (NES 2009).

 Copyright © 2011 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Review
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=21745759
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21745759&id=doi:10.1016%2Fj.nepr.2011.05.008&issn=1471-5953&isbn=&volume=12&issue=1&spage=60&pages=60-4&date=2012&title=Nurse+Education+in+Practice&atitle=A+review+of+evidence+for+the+practice+learning+environment%3A+enhancing+the+context+for+nursing+and+midwifery+care+in+Scotland.&aulast=Holland&pid=%3Cauthor%3EHolland+K%3C%2Fauthor%3E%3CAN%3E21745759%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<192. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21514016
TI  - Participants' engagement with and reactions to the use of on-line action learning sets to support advanced nursing role development.
SO  - Nurse Education Today. 32(3):267-72, 2012 Apr.
VI  - 1
ST  - MEDLINE
AU  - Currie K
AU  - Biggam J
AU  - Palmer J
AU  - Corcoran T
FA  - Currie, Kay
FA  - Biggam, John
FA  - Palmer, Janette
FA  - Corcoran, Terry
IN  - Currie, Kay. Glasgow Caledonian University Cowcaddens, UK. k.currie@gcu.ac.uk
AB  - Professional role development in nursing is occurring at a rapid pace in the UK as elsewhere. Internationally, finding relevant, flexible, sustainable educational solutions to support the preparation of nurses for new roles presents significant challenges for Higher Education Institutions, health service managers and the clinical practitioners who are would-be students. The use of on-line learning is frequently advocated as one means of resolving these difficulties. This paper discusses participants' engagement with, and reactions to, the use of on-line Action Learning Sets (ALS) as part of a national pilot development pathway for Advanced Nursing Practice in Scotland. Data collection included: survey of participants' views of on-line ALS; survey comparing perceptions of ALS with other educational experiences within the pathway; in-depth interviews with case-site participants. A range of benefits and limitations of on-line ALS was identified. The benefit of flexible access and sharing experiences with others was emphasised. Conversely, multiple commitments and lack of group cohesiveness significantly interfered with the effectiveness of this process. Key recommendations for future implementation acknowledge participants' preference for a blended approach, with face-to-face sessions to provide 'getting-to-know-you' opportunities, enhancing commitment to the group process.

 Copyright © 2011 Elsevier Ltd. All rights reserved.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med9&AN=21514016
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21514016&id=doi:10.1016%2Fj.nedt.2011.03.012&issn=0260-6917&isbn=&volume=32&issue=3&spage=267&pages=267-72&date=2012&title=Nurse+Education+Today&atitle=Participants%27+engagement+with+and+reactions+to+the+use+of+on-line+action+learning+sets+to+support+advanced+nursing+role+development.&aulast=Currie&pid=%3Cauthor%3ECurrie+K%3C%2Fauthor%3E%3CAN%3E21514016%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<193. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27736351
TI  - Out for consultation.
SO  - Nursing Management (Harrow). 19(2):11, 2012 Apr 26.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Professional regulation Nurses are being asked to respond to two consultations from the Nursing and Midwifery Council: the proposals by the law commissions of England and Wales, Northern Ireland and Scotland for the regulation of healthcare professionals, and the council's own equality objectives.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27736351
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27736351&id=doi:10.7748%2Fnm.19.2.11.s11&issn=1354-5760&isbn=&volume=19&issue=2&spage=11&pages=11&date=2012&title=Nursing+Management+%28Harrow%29&atitle=Out+for+consultation.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27736351%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<194. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27320808
TI  - Community nursing.
SO  - Nursing Management (Harrow). 18(10):13, 2012 Mar 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Modernising Nursing in the Community is a new website from NHS Education for Scotland. It brings together tools and information for community healthcare professionals from three 'platforms': children, young people and families; work and wellbeing; and adults and older people.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27320808
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27320808&id=doi:10.7748%2Fnm.18.10.13.s6&issn=1354-5760&isbn=&volume=18&issue=10&spage=13&pages=13&date=2012&title=Nursing+Management+%28Harrow%29&atitle=Community+nursing.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27320808%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<195. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27315905
TI  - Staff levels dip to lowest since 2006.
SO  - Nursing Standard. 26(22):13, 2012 Feb 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Latest workforce figures show there are 1,568 fewer whole-time equivalent nursing and midwifery staff in post across Scotland compared to the previous year.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27315905
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27315905&id=doi:10.7748%2Fns2012.02.26.22.13.p7434&issn=0029-6570&isbn=&volume=26&issue=22&spage=13&pages=13&date=2012&title=Nursing+Standard&atitle=Staff+levels+dip+to+lowest+since+2006.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27315905%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<196. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27741738
TI  - Embracing diversity.
SO  - Nursing Management (Harrow). 17(3):37, 2010 Jun 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Fyffe T
FA  - Fyffe, Theresa
IN  - Fyffe, Theresa. RCN Scotland.
AB  - I AM now the director of RCN Scotland but I started my nursing career in Dublin. As an Irish woman moving to Edinburgh, the culture shock was more intense than I had anticipated because the approaches taken in Ireland and Scotland to health care and daily life turned out to be so different. Thirty years on, I still appreciate the effect of cultural differences on our lives.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27741738
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27741738&id=doi:10.7748%2Fnm.17.3.37.s21&issn=1354-5760&isbn=&volume=17&issue=3&spage=37&pages=37&date=2010&title=Nursing+Management+%28Harrow%29&atitle=Embracing+diversity.&aulast=Fyffe&pid=%3Cauthor%3EFyffe+T%3C%2Fauthor%3E%3CAN%3E27741738%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<197. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27320620
TI  - College unveils nursing manifesto ahead of Scotland's elections.
SO  - Nursing Management (Harrow). 17(8):5, 2010 Dec 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - RCN SCOTLAND has published a blueprint for the future of nursing ahead of the country's government elections in May next year.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27320620
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27320620&id=doi:10.7748%2Fnm.17.8.5.s7&issn=1354-5760&isbn=&volume=17&issue=8&spage=5&pages=5&date=2010&title=Nursing+Management+%28Harrow%29&atitle=College+unveils+nursing+manifesto+ahead+of+Scotland%27s+elections.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27320620%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<198. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28076078
TI  - Generic community role to be scrapped.
SO  - Nursing Standard. 23(44):8, 2009 Jul 07.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The way community nursing care is delivered in Scotland will be re-examined after plans to create a generic community role were scrapped.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=28076078
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28076078&id=doi:10.7748%2Fns.23.44.8.s11&issn=0029-6570&isbn=&volume=23&issue=44&spage=8&pages=8&date=2009&title=Nursing+Standard&atitle=Generic+community+role+to+be+scrapped.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E28076078%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<199. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28075952
TI  - Scottish board meets to start community plan of action.
SO  - Nursing Standard. 23(51):9, 2009 Aug 26.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Plans to modernise community nursing in Scotland have taken a step forward with the first meeting of the board that will lead the way forward.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=28075952
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28075952&id=doi:10.7748%2Fns.23.51.9.s11&issn=0029-6570&isbn=&volume=23&issue=51&spage=9&pages=9&date=2009&title=Nursing+Standard&atitle=Scottish+board+meets+to+start+community+plan+of+action.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E28075952%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<200. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27741859
TI  - Remember our history.
SO  - Nursing Older People. 21(3):8, 2009 Apr 22.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Andrews J
FA  - Andrews, June
IN  - Andrews, June. Dementia Services Development Centre, University of Stirling.
AB  - On a trip to a nursing library in the Western Isles of Scotland just before Christmas I was looking for something to read, to take my mind off the 60-mile-an-hour crosswinds that were battering the little plane. I was kindly given some 30-year-old nursing magazines to read and throw away.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27741859
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27741859&id=doi:10.7748%2Fnop.21.3.8.s11&issn=1472-0795&isbn=&volume=21&issue=3&spage=8&pages=8&date=2009&title=Nursing+Older+People&atitle=Remember+our+history.&aulast=Andrews&pid=%3Cauthor%3EAndrews+J%3C%2Fauthor%3E%3CAN%3E27741859%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<201. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27316848
TI  - Advanced practice.
SO  - Nursing Management (Harrow). 16(3):13, 2009 Jun 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Williams R
FA  - Williams, Ruth
AB  - NHS Scotland has launched a website version of the Advanced Nursing Practice Toolkit, which contains a range of information and resources about advanced nursing practice.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27316848
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27316848&id=doi:10.7748%2Fnm.16.3.13.s22&issn=1354-5760&isbn=&volume=16&issue=3&spage=13&pages=13&date=2009&title=Nursing+Management+%28Harrow%29&atitle=Advanced+practice.&aulast=Williams&pid=%3Cauthor%3EWilliams+R%3C%2Fauthor%3E%3CAN%3E27316848%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<202. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27319761
TI  - Nursing and midwifery vacancies on rise.
SO  - Nursing Management (Harrow). 14(10):4, 2008 Mar 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The number of nursing and midwifery vacancies in NHS Scotland has risen, figures from the Information Services Division Scotland have shown.
PT  - Journal Article
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27319761
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27319761&id=doi:10.7748%2Fnm.14.10.4.s2&issn=1354-5760&isbn=&volume=14&issue=10&spage=4&pages=4&date=2008&title=Nursing+Management+%28Harrow%29&atitle=Nursing+and+midwifery+vacancies+on+rise.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27319761%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<203. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28091099
TI  - Scottish leaders seek urgent meeting with new health secretary.
SO  - Nursing Standard. 21(37):11, 2007 May 23.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Nursing leaders in Scotland are seeking an urgent meeting with the new cabinet secretary for health and wellbeing - and workforce planning is near the top of their agenda.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=28091099
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28091099&id=doi:10.7748%2Fns.21.37.11.s18&issn=0029-6570&isbn=&volume=21&issue=37&spage=11&pages=11&date=2007&title=Nursing+Standard&atitle=Scottish+leaders+seek+urgent+meeting+with+new+health+secretary.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E28091099%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<204. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27724265
TI  - Making practice perfect.
SO  - Nursing Management (Harrow). 14(1):12-16, 2007 Apr 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Paterson I
AU  - Burns I
FA  - Paterson, Isabel
FA  - Burns, Iain
IN  - Paterson, Isabel. Nursing.
IN  - Burns, Iain. Nursing.
IN  - Burns, Iain. Both at the school of nursing and midwifery, University of Dundee.
AB  - IT IS CRUCIAL to quality assurance that nursing students are given opportunities to evaluate their learning environments ( NHS Education for Scotland 2003 , Quality Assurance Agency for Higher Education 2001 ).
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27724265
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27724265&id=doi:10.7748%2Fnm.14.1.12.s10&issn=1354-5760&isbn=&volume=14&issue=1&spage=12&pages=12-16&date=2007&title=Nursing+Management+%28Harrow%29&atitle=Making+practice+perfect.&aulast=Paterson&pid=%3Cauthor%3EPaterson+I%3C%2Fauthor%3E%3CAN%3E27724265%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<205. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27724260
SO  - Nursing Management (Harrow). 14(1):4, 2007 Apr 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Speaking out: Dorothy Ngomo, executive director of the National Organisation of Nurses of Malawi, addresses nursing leaders at the RCN Scotland member conference in Edinburgh last month about the ongoing partnership between her organisation and the college. Ms Ngomo also witnessed how pressure from nurses resulted in health minister Andy Kerr's announcement that nurses in Scotland would receive their annual pay rise in full, unlike colleagues in England and Wales. RCN general secretary Peter Carter said: 'We welcome the decision to implement the Pay Review Body's recommendation in full. This shows the power of the nursing voice in the run up to the elections in May'.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27724260
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27724260&id=doi:10.7748%2Fnm.14.1.4.s4&issn=1354-5760&isbn=&volume=14&issue=1&spage=4&pages=4&date=2007&title=Nursing+Management+%28Harrow%29&atitle=news&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27724260%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<206. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27718944
TI  - Ex-CNO highlights areas for improvement.
SO  - Nursing Management (Harrow). 13(1):4, 2006 Apr 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Lipley N
FA  - Lipley, Nick
AB  - Former chief nursing officer (CNO) Anne Jarvie (below) has highlighted five areas of care provision that need to be improved across Scotland, after an inquiry into events at NHS Lothian.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27718944
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27718944&id=doi:10.7748%2Fnm.13.1.4.s5&issn=1354-5760&isbn=&volume=13&issue=1&spage=4&pages=4&date=2006&title=Nursing+Management+%28Harrow%29&atitle=Ex-CNO+highlights+areas+for+improvement.&aulast=Lipley&pid=%3Cauthor%3ELipley+N%3C%2Fauthor%3E%3CAN%3E27718944%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<207. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27719110
TI  - Nursing and midwifery research in scotland.
SO  - Nursing Management (Harrow). 12(7):17-18, 2005 Nov 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Fyffe T
AU  - Waterton J
AU  - Fyffe T
AU  - Waterton EJ
FA  - Fyffe, Theresa
FA  - Waterton, Jennifer
FA  - Fyffe, Theresa
FA  - Waterton, Edinburgh Jennifer
IN  - Fyffe, Theresa. acute services, quality, leadership, and research and development at the Scottish Executive Health Department.
IN  - Waterton, Edinburgh Jennifer. Chief Scientist Office.
IN  - Waterton, Edinburgh Jennifer. SEHD, Edinburgh.
AB  - THE NURSING and midwifery workforce is the largest clinical staff group in NHSScotland, with 37,260 whole time equivalent qualified staff.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27719110
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27719110&id=doi:10.7748%2Fnm.12.7.17.s16&issn=1354-5760&isbn=&volume=12&issue=7&spage=17&pages=17-18&date=2005&title=Nursing+Management+%28Harrow%29&atitle=Nursing+and+midwifery+research+in+scotland.&aulast=Fyffe&pid=%3Cauthor%3EFyffe+T%3C%2Fauthor%3E%3CAN%3E27719110%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<208. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27718848
TI  - Leading by example.
SO  - Nursing Management (Harrow). 11(7):6-7, 2004 Nov 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Black S
FA  - Black, Steven
AB  - There is a new face leading nursing and midwifery in Scotland: chief nursing officer (CNO) Paul Martin. As successor to Annie Jarvie, who retired in September after 12 years in post, he wants the profession's leaders to ensure that nurses and midwives remain at the heart of NHS modernisation.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27718848
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27718848&id=doi:10.7748%2Fnm.11.7.6.s9&issn=1354-5760&isbn=&volume=11&issue=7&spage=6&pages=6-7&date=2004&title=Nursing+Management+%28Harrow%29&atitle=Leading+by+example.&aulast=Black&pid=%3Cauthor%3EBlack+S%3C%2Fauthor%3E%3CAN%3E27718848%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<209. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27712165
TI  - Editorial.
SO  - Nursing Management (Harrow). 11(4):3, 2004 Jul 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - SO WEare to have new chief nursing officers (CNOs) for England and Scotland. Sarah Mullally's surprise resignation last month paves the way for a new leader in England, while Paul Martin has been appointed Anne Jarvie's successor in Scotland. Maybe a new era for nurse leadership is in the offing?
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27712165
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27712165&id=doi:10.7748%2Fnm.11.4.3.s1&issn=1354-5760&isbn=&volume=11&issue=4&spage=3&pages=3&date=2004&title=Nursing+Management+%28Harrow%29&atitle=Editorial.&aulast=katherine&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27712165%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<210. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27712157
TI  - Getting it right in education.
SO  - Nursing Management (Harrow). 11(4):37, 2004 Jul 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - More learning resources are being made available by organisations in Scotland. NHS Education for Scotland (NES) has launched Getting It Right Together, a learning resource produced with the Scottish Consortium for Learning Disability for pre-registration nursing students.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27712157
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27712157&id=doi:10.7748%2Fnm.11.4.37.s18&issn=1354-5760&isbn=&volume=11&issue=4&spage=37&pages=37&date=2004&title=Nursing+Management+%28Harrow%29&atitle=Getting+it+right+in+education.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27712157%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<211. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27712156
TI  - Preparing overseas nurses and midwives.
SO  - Nursing Management (Harrow). 11(4):37, 2004 Jul 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - NHS Education for Scotland, in partnership with the Queen's Nursing Institute Scotland, has also been developing a Scotland wide programme to prepare overseas nurses and midwives.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27712156
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27712156&id=doi:10.7748%2Fnm.11.4.37.s19&issn=1354-5760&isbn=&volume=11&issue=4&spage=37&pages=37&date=2004&title=Nursing+Management+%28Harrow%29&atitle=Preparing+overseas+nurses+and+midwives.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27712156%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<212. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27712149
TI  - New chief nurse for Scotland appointed.
SO  - Nursing Management (Harrow). 11(4):5, 2004 Jul 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The Scottish Executive has appointed Paul Mar- tin to replace Anne Jarvie as Scotland's chief nursing officer (CNO) in September.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27712149
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27712149&id=doi:10.7748%2Fnm.11.4.5.s7&issn=1354-5760&isbn=&volume=11&issue=4&spage=5&pages=5&date=2004&title=Nursing+Management+%28Harrow%29&atitle=New+chief+nurse+for+Scotland+appointed.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27712149%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<213. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27316215
TI  - A framework for practice.
SO  - Nursing Management (Harrow). 11(7):39, 2004 Nov 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The Scottish Executive has launched a framework for practice nursing in Scotland. It sets out 11 standards to support these nurses in their practice and career development, and offers advice to employers. Areas covered include best practice for recruitment and personal development. The full document is available at www.scotland.gov.uk/library5/health/fngp-00.asp.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27316215
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27316215&id=doi:10.7748%2Fnm.11.7.39.s15&issn=1354-5760&isbn=&volume=11&issue=7&spage=39&pages=39&date=2004&title=Nursing+Management+%28Harrow%29&atitle=A+framework+for+practice.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27316215%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<214. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27316029
TI  - [Not Available].
SO  - Nursing Management (Harrow). 11(5):5, 2004 Sep 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - Goodbye to all that:chief nursing officer for Scotland Anne Jarvie, who retires this month, has received the Lillian Carter Center for International Nursing Global Health Leadership Award. Ms Jarvie accepted the award at an international conference in the US. Department of Health nursing officer for international relations Anna Maslin said: 'A highly respected advocate for nursing, Anne Jarvie has played a major role in reforms within the NHS, and in 2001 outlined a ten-year strategy for nursing and midwifery in Scotland. Her vision encourages nurses to meet the challenges of the future, to embark upon a lifetime of learning and the pursuit of excellence in delivering the best care possible. Anne has also played a pivotal role in ensuring strategic nursing leadership at the highest levels of the NHS'.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27316029
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27316029&id=doi:10.7748%2Fnm.11.5.5.s8&issn=1354-5760&isbn=&volume=11&issue=5&spage=5&pages=5&date=2004&title=Nursing+Management+%28Harrow%29&atitle=%5BNot+Available%5D.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27316029%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<215. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27700289
TI  - Action plan announced for Scotland.
SO  - Nursing Management (Harrow). 8(9):4, 2002 Feb 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - The Scottish Executive has announced a package of measures to tackle recruitment and retention problems in Scotland. Following the nursing convention held last November, the Executive has published an action plan.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27700289
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27700289&id=doi:10.7748%2Fnm.8.9.4.s2&issn=1354-5760&isbn=&volume=8&issue=9&spage=4&pages=4&date=2002&title=Nursing+Management+%28Harrow%29&atitle=Action+plan+announced+for+Scotland.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27700289%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<216. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27059945
TI  - Role development in acute nursing in Scotland.
SO  - Nursing Standard. 16(17):33-8, 2002 Jan 09.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Armstrong S
AU  - Tolson D
AU  - West B
FA  - Armstrong, Sarah
FA  - Tolson, Debbie
FA  - West, Bernice
IN  - Armstrong, Sarah. Acute Services Strategy, Forth Valley Acute Hospitals NHS Trust, Falkirk.
IN  - Tolson, Debbie. Department of Nursing and Community Health, Glasgow Caledonian University.
IN  - West, Bernice. Centre for Nurse Practice, Research and Development, School of Nursing and Midwifery, The Robert Gordon University, Aberdeen.
AB  - Aim This research was designed to evaluate innovative roles underpinning successful nurse-led services in nursing and midwifery in Scotland. Method A dual methodological approach encompassing a national survey and detailed case studies was adopted. The survey of all NHS trusts in Scotland was designed to profile role developments and extended practices in nursing and midwifery practice. The survey data were used to identify case studies that reflected innovative roles within nursing and midwifery. Twenty semi-structured interviews were undertaken with clinical nurse specialists and analysed using the constant comparative approach of grounded theory. Results Three case studies in acute care were identified for in-depth study. The key themes to emerge were the specific nature of the work, the professional merit associated with each role, benefits to patients and the importance of objective evaluation of the role. Conclusion The findings from the acute care case studies strongly support the importance of nurses promoting and developing patient-focused initiatives in acute care.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27059945
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27059945&id=doi:10.7748%2Fns2002.01.16.17.33.c3136&issn=0029-6570&isbn=&volume=16&issue=17&spage=33&pages=33-8&date=2002&title=Nursing+Standard&atitle=Role+development+in+acute+nursing+in+Scotland.&aulast=Armstrong&pid=%3Cauthor%3EArmstrong+S%3C%2Fauthor%3E%3CAN%3E27059945%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<217. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28086497
TI  - Scottish nursing strategy puts focus on leadership.
SO  - Nursing Standard. 15(25):4, 2001 Mar 07.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Black S
FA  - Black, Steven
AB  - NURSES IN Scotland are to be sent on courses to improve their leadership skills as part of the government's strategy for the profession published last week.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=28086497
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28086497&id=doi:10.7748%2Fns.15.25.4.s3&issn=0029-6570&isbn=&volume=15&issue=25&spage=4&pages=4&date=2001&title=Nursing+Standard&atitle=Scottish+nursing+strategy+puts+focus+on+leadership.&aulast=Black&pid=%3Cauthor%3EBlack+S%3C%2Fauthor%3E%3CAN%3E28086497%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<218. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 28086451
TI  - Call to action for Scottish health care.
SO  - Nursing Standard. 15(25):3, 2001 Mar 07.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - SCOTLAND'S NEWLY published strategy for nursing and midwifery, Caring for Scotland, is a reminder of how different professional life can be for nurses across the UK. For example, while developments in telehealth and telemedicine facilities are certainly not unique to the remote rural areas of Scotland, there can be few nurses who can claim to be the sole health professional on a non-doctor island. One such district nurse looks forward with optimism to seeing the effect of the World Health Organization pilot family health nursing programme on her professional credibility. Perhaps not surprisingly, there is a fair bit of emphasis on helping nurses who work in remote and rural areas to develop their practice.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=28086451
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:28086451&id=doi:10.7748%2Fns.15.25.3.s2&issn=0029-6570&isbn=&volume=15&issue=25&spage=3&pages=3&date=2001&title=Nursing+Standard&atitle=Call+to+action+for+Scottish+health+care.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E28086451%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<219. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27700556
TI  - Social care and independent healthcare regulation will be radically reformed under the Care Standards Act 2000. What are the implications of this important piece of legislation? How will it affect the regulation of nursing agencies and national minimum standards relating to nursing staff in care homes? Chris Hume provides some answers.
SO  - Nursing Management (Harrow). 8(5):8, 2001 Sep 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - FROM APRIL 2002, regulation by the 150 local authorities and 95 health authorities of a range of institutions and agencies will become the responsibility of a single national body in England, the National Care Standards Commission (NCSC). The Care Standards Act 2000 repeals the legislation - the Registered Homes Act 1984 and relevant parts of the Children's Act 1989 - governing local authority regulation of residential homes, private children's homes and nursing agencies, health authority regulation of nursing homes and private hospitals, and the regulation of voluntary adoption agencies and voluntary children's homes by the Department of Health. Similar arrangements are being put in place in Wales and Scotland.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27700556
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27700556&id=doi:10.7748%2Fnm.8.5.8.s10&issn=1354-5760&isbn=&volume=8&issue=5&spage=8&pages=8&date=2001&title=Nursing+Management+%28Harrow%29&atitle=Social+care+and+independent+healthcare+regulation+will+be+radically+reformed+under+the+Care+Standards+Act+2000.+What+are+the+implications+of+this+important+piece+of+legislation%3F+How+will+it+affect+the+regulation+of+nursing+agencies+and+national+minimum+standards+relating+to+nursing+staff+in+care+homes%3F+Chris+Hume+provides+some+answers.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27700556%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<220. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27700545
TI  - Scottish agency reaches out.
SO  - Nursing Management (Harrow). 8(5):5, 2001 Sep 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  - A Scottish nursing agency has announced plans to expand its operations, including four new recruitment centres in England. ScotNursing is to open eight centres in total, the other four in Scotland. The organisation already has one centre in England.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27700545
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27700545&id=doi:10.7748%2Fnm.8.5.5.s7&issn=1354-5760&isbn=&volume=8&issue=5&spage=5&pages=5&date=2001&title=Nursing+Management+%28Harrow%29&atitle=Scottish+agency+reaches+out.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27700545%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<221. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 27700541
TI  - New jobs.
SO  - Nursing Management (Harrow). 8(5):4, 2001 Sep 01.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Anonymous
AB  -  David Benton is to leave his post as chief executive of the National Board in Scotland, to become nursing director at Grampian University Hospitals NHS Trust. He will take up his new post in October.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=27700541
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:27700541&id=doi:10.7748%2Fnm.8.5.4.s2&issn=1354-5760&isbn=&volume=8&issue=5&spage=4&pages=4&date=2001&title=Nursing+Management+%28Harrow%29&atitle=New+jobs.&aulast=&pid=%3Cauthor%3Eanonymous%3C%2Fauthor%3E%3CAN%3E27700541%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<222. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 23323204
TI  - Intravenous fluid prescribing practices by foundation year one doctors - a questionnaire study.
SO  - JRSM Short Reports. 3(9):64, 2012 Sep.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Lim CT
AU  - Dunlop M
AU  - Lim CS
FA  - Lim, Chung Thong
FA  - Dunlop, Michael
FA  - Lim, Chung Sim
IN  - Lim, Chung Thong. St Bartholomew's and the Royal London School of Medicine and Dentistry, Queen Mary College, University of London, London E1 2AD, UK.
AB  - OBJECTIVES: Foundation Year Ones (FY1s) are the most junior doctors in the UK who are often required to prescribe intravenous fluid to patients not under their regular care, during on-call or out-of-hours ward cover. This study aimed to investigate FY1s' practice and decision-making process of intravenous fluid prescribing to these patients.
AB  - DESIGN: Questionnaire survey.
AB  - SETTING: Survey on Practices during on-calls and out-of-hours ward covers.
AB  - PARTICIPANTS: FY1s of five National Health Service (NHS) hospitals in England and Scotland.
AB  - RESULTS: All 149 FY1s responded to survey. Eighty-six percent have been taught intravenous fluid prescribing during medical school, compared with only 48% in FY1 induction. More than half always/often checked the patient's urea and electrolytes (U&Es) (72%), read the fluid balance (58%) and observation charts (80%), discussed the case with nursing staff (75%), enquired about oral status (82%), identified the main diagnosis/operation (75%) and indication for intravenous fluid (72%) of the patient when prescribing intravenous fluid. However, less than half often/always read the medical notes (43%) or performed clinical examinations on patients (16%). Most FY1s (94%) always/often checked patient's U&Es when prescribing potassium.
AB  - CONCLUSIONS: The questionnaire study demonstrated variations among FY1s in the practice and decision-making process of intravenous fluid prescribing to patients unknown to them, during on-calls or out-of-hours ward covers. Such variations in practice should be addressed especially by medical and foundation schools, and NHS hospitals to improve patient care.
PT  - Journal Article
YR  - 2012
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=23323204
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:23323204&id=doi:10.1258%2Fshorts.20121.012041&issn=2042-5333&isbn=&volume=3&issue=9&spage=64&pages=64&date=2012&title=JRSM+Short+Reports&atitle=Intravenous+fluid+prescribing+practices+by+foundation+year+one+doctors+-+a+questionnaire+study.&aulast=Lim&pid=%3Cauthor%3ELim+CT%3C%2Fauthor%3E%3CAN%3E23323204%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<223. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19485059
TI  - Nurse staffing and patient outcomes: evolution of an international study.
SO  - Canadian Journal of Nursing Research. 41(1):320-39, 2009 Mar.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Sochalski J
AU  - Estabrooks CA
AU  - Humphrey CK
FA  - Sochalski, Julie
FA  - Estabrooks, Carole A
FA  - Humphrey, Charles K
IN  - Sochalski, Julie. Center for Health Outcomes and Policy Research, University of Pennsylvania, Philadelphia, PA, USA.
CM  - Reprint of
AB  - Industry-wide health sector reforms in the United States, Canada, and Europe have provided a unique opportunity to examine the effects of hospital restructuring on inpatient nursing care and patient outcomes across an array of settings. Seven interdisciplinary research teams--1 each in Alberta, British Columbia, England, Germany, Ontario, Scotland, and the United States--have formed an international consortium whose aim is to study the effects of such restructuring. Each site has enrolled large numbers of hospitals and nurses to explicate the role that organization of nursing care, a target of hospital restructuring, plays in differential patient outcomes. The study seeks to understand more fully the influence of both nurse staffing and the nursing practice environment on patient outcomes. Discussion of the theoretical foundation, study design, and process of developing the study instruments and measures illustrates the process to date, as well as the feasibility of and opportunities inherent in such an international endeavour.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=19485059
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19485059&id=doi:&issn=0844-5621&isbn=&volume=41&issue=1&spage=320&pages=320-39&date=2009&title=Canadian+Journal+of+Nursing+Research&atitle=Nurse+staffing+and+patient+outcomes%3A+evolution+of+an+international+study.&aulast=Sochalski&pid=%3Cauthor%3ESochalski+J%3C%2Fauthor%3E%3CAN%3E19485059%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<224. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19040909
TI  - Patients' views of nurses' competence.
SO  - Nurse Education in Practice. 6(6):411-7, 2006 Dec.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Calman L
FA  - Calman, Lynn
IN  - Calman, Lynn. School of Nursing, Midwifery and Social Work, The University of Manchester, Coupland 3, Oxford Road, Manchester M13 9PL, UK.
AB  - This study examines, from the patients' perspective, what is meant by competent nursing and how, with this perspective in mind, patients would view the prospect of assessing the competence of nurses. There is a little empirical research that clarifies professional competence from the patient's perspective. Nursing curricula in the UK have shifted attention to 'competencies' as the outcome of nurse education and, in an era of patient involvement, their views are important to investigate. The study utilises a grounded theory approach. Data were collected in Central Scotland between 2001 and 2003. Twenty-seven patients participated. Data were analysed, in keeping with the grounded theory tradition, utilising the constant comparative method. Patients described the foundation of competent nursing practice as technical care and nursing knowledge. Patients assume that technical care is competent as safe guards are considered to be in place to protect patients. When technical competence is assumed, interpersonal attributes become the most important indicator of the quality of nursing care. The results of this study highlight uncertainty about whether patients feel able to assess the competence of nurses. The results of this study may have implications for nurses internationally when trying to involve patients in the assessment of nurses.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=19040909
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19040909&id=doi:10.1016%2Fj.nepr.2006.07.011&issn=1471-5953&isbn=&volume=6&issue=6&spage=411&pages=411-7&date=2006&title=Nurse+Education+in+Practice&atitle=Patients%27+views+of+nurses%27+competence.&aulast=Calman&pid=%3Cauthor%3ECalman+L%3C%2Fauthor%3E%3CAN%3E19040909%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<225. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17480211
TI  - New role, new country: introducing US physician assistants to Scotland.
SO  - Human Resources for Health [Electronic Resource]. 5:13, 2007 May 04.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Buchan J
AU  - O'May F
AU  - Ball J
FA  - Buchan, James
FA  - O'May, Fiona
FA  - Ball, Jane
IN  - Buchan, James. Queen Margaret University, Clerwood Terrace, Edinburgh EH12 8TS, UK. jbuchan@qmu.ac.uk
AB  - This paper draws from research commissioned by the Scottish Executive Health Department (SEHD). It provides a case study in the introduction of a new health care worker role into an already well established and "mature" workforce configuration It assesses the role of US style physician assistants (PAs), as a precursor to planned "piloting" of the PA role within the National Health Service (NHS) in Scotland. The evidence base for the use of PAs is examined, and ways in which an established role in one health system (the USA) could be introduced to another country, where the role is "new" and unfamiliar, are explored. The history of the development of the PA role in the US also highlights a sometimes somewhat problematic relationship between P nursing profession. The paper highlights that the concept of the PA role as a 'dependent practitioner' is not well understood or developed in the NHS, where autonomous practice within regulated professions is the norm. In the PA model, responsibility is shared, but accountability rests with the supervising physician. Clarity of role definition, and engendering mutual respect based on fair treatment and effective management of multi-disciplinary teams will be pre-requisites for effective deployment of this new role in the NHS in Scotland.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=17480211
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17480211&id=doi:10.1186%2F1478-4491-5-13&issn=1478-4491&isbn=&volume=5&issue=&spage=13&pages=13&date=2007&title=Human+Resources+for+Health+%5BElectronic+Resource%5D&atitle=New+role%2C+new+country%3A+introducing+US+physician+assistants+to+Scotland.&aulast=Buchan&pid=%3Cauthor%3EBuchan+J%3C%2Fauthor%3E%3CAN%3E17480211%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<226. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11560709
TI  - Welfare benefits' screening and referral: a new direction for community nurses?.
SO  - Health & Social Care in the Community. 8(6):390-397, 2000 Nov.
VI  - 1
ST  - PubMed-not-MEDLINE
AU  - Hoskins R
AU  - Carter DE
FA  - Hoskins, Robert
FA  - Carter, Diana E.
IN  - Hoskins, Robert. Nursing & Midwifery School, University of Glasgow, Glasgow, UK.
AB  - The White Paper, Towards a Healthier Scotland considerably widens the community nursing scope for health promotion, as it recognises that disadvantaged life circumstances as well as unhealthy lifestyles contribute to poor health. It has been shown that income and health are interrelated. This evidence has demonstrated that it is not how rich a nation is that determines the overall health of its inhabitants; it is how equitably its wealth is distributed that counts: countries that have narrow income differentials tend to have better health. Both the income and health divide in Britain widened considerably between 1980 and 1992. It is argued that increasing income inequality leads to social isolation and chronic stress, which can impact on psycho-social pathways and damages life expectancy. This paper suggests that community nurses can address adverse life circumstances by finding ways of improving the economic status of their most vulnerable clients, and that one way of doing this would be to ensure that clients claim their full quota of welfare entitlement, given that there is several billion pounds of social security benefits that remain unclaimed in Britain every year.
PT  - Journal Article
YR  - 2000
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=pmnm2&AN=11560709
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11560709&id=doi:10.1046%2Fj.1365-2524.2000.00264.x&issn=0966-0410&isbn=&volume=8&issue=6&spage=390&pages=390-397&date=2000&title=Health+%26+Social+Care+in+the+Community&atitle=Welfare+benefits%27+screening+and+referral%3A+a+new+direction+for+community+nurses%3F.&aulast=Hoskins&pid=%3Cauthor%3EHoskins+R%3C%2Fauthor%3E%3CAN%3E11560709%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<227. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21988441
TI  - Building foundations for the future: the NHS Scotland advanced practice succession planning development pathway.
SO  - Journal of Nursing Management. 19(7):933-42, 2011 Oct.
VI  - 1
ST  - MEDLINE
AU  - Currie K
AU  - Grundy M
FA  - Currie, Kay
FA  - Grundy, Maggie
IN  - Currie, Kay. Glasgow Caledonian University, Glasgow, UK. k.currie@gcu.ac.uk
AB  - AIM: To highlight implications for managers from the implementation of a national advanced practice succession planning development pathway within Scotland.
AB  - BACKGROUND: Internationally, advanced practice posts have often developed in an ad-hoc manner, with little organizational attention to succession planning. Evaluation of a pilot national succession planning development pathway identified mechanisms which facilitate or hamper effective planning for advanced practice roles.
AB  - METHODS: A responsive evaluation design incorporating semi-structured questionnaires to pathway participants (n = 15) and semi-structured telephone interviews with case-site pathway participants (n = 7) and their line managers.
AB  - RESULTS: Managers believed the development pathway was worthwhile; however, there was limited strategic planning to match individuals' development to service need. Practitioners generally perceived managers as interested in their development, although levels of practical support varied. There is concern from both managers and practitioners regarding ongoing funding for advanced practice development.
AB  - CONCLUSION: The present evaluation study reiterates the need for organizational commitment to succession planning including robust service needs analysis mechanisms and adequate funding for development processes.
AB  - IMPLICATIONS FOR NURSING MANAGEMENT: Nurse managers are viewed as the 'gatekeepers' to opportunities for developing advanced nurse practitioners; scare resources must be targeted effectively to support succession planning through the development of selected individuals for future advanced practice posts, justified by service need.

 Copyright © 2011 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21988441
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21988441&id=doi:10.1111%2Fj.1365-2834.2011.01299.x&issn=0966-0429&isbn=&volume=19&issue=7&spage=933&pages=933-42&date=2011&title=Journal+of+Nursing+Management&atitle=Building+foundations+for+the+future%3A+the+NHS+Scotland+advanced+practice+succession+planning+development+pathway.&aulast=Currie&pid=%3Cauthor%3ECurrie+K%3C%2Fauthor%3E%3CAN%3E21988441%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<228. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21887974
TI  - Measuring vital signs: an integrated teaching approach.
SO  - Nursing Times. 107(27):16-7, 2011 Jul 12-18.
VI  - 1
ST  - MEDLINE
AU  - Everett F
AU  - Wright W
FA  - Everett, Fiona
FA  - Wright, Wendy
IN  - Everett, Fiona. School of Health Studies, University of the West of Scotland.
AB  - In September 2010, nurse lecturers at the University of the West of Scotland introduced a holistic, integrated teaching approach to engage students with essential nursing skills. This article discusses how the integrated approach was introduced and how it was used to teach students to measure vital signs. It also provides an evaluation of the approach and recommendations for further development.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21887974
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21887974&id=doi:&issn=0954-7762&isbn=&volume=107&issue=27&spage=16&pages=16-7&date=2011&title=Nursing+Times&atitle=Measuring+vital+signs%3A+an+integrated+teaching+approach.&aulast=Everett&pid=%3Cauthor%3EEverett+F%3C%2Fauthor%3E%3CAN%3E21887974%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<229. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21826869
TI  - Improving care planning in oncology nursing practice.
SO  - Nursing Standard. 25(42):33-9, 2011 Jun 22-28.
VI  - 1
ST  - MEDLINE
AU  - Stott N
FA  - Stott, Natalie
IN  - Stott, Natalie. Aberdeen Royal Infirmary, Aberdeen. nstott@nhs.net
AB  - This article describes a practice development project undertaken in an acute oncology unit in a large teaching hospital in Scotland. The project was designed to address care planning practice in the unit by introducing a pilot intravenous access care plan. The article discusses the review and audit process of the care plans previously used in the unit. The findings are discussed and areas for improvement and recommendations for future practice are outlined.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21826869
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21826869&id=doi:10.7748%2Fns2011.06.25.42.33.c8581&issn=0029-6570&isbn=&volume=25&issue=42&spage=33&pages=33-9&date=2011&title=Nursing+Standard&atitle=Improving+care+planning+in+oncology+nursing+practice.&aulast=Stott&pid=%3Cauthor%3EStott+N%3C%2Fauthor%3E%3CAN%3E21826869%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<230. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21749560
TI  - Mixed methods research in mental health nursing. [Review]
SO  - Journal of Psychiatric & Mental Health Nursing. 18(6):535-42, 2011 Aug.
VI  - 1
ST  - MEDLINE
AU  - Kettles AM
AU  - Creswell JW
AU  - Zhang W
FA  - Kettles, A M
FA  - Creswell, J W
FA  - Zhang, W
IN  - Kettles, A M. Royal Cornhill Hospital, Aberdeen, UK. alyson.kettles@nhs.net
AB  - Mixed methods research is becoming more widely used in order to answer research questions and to investigate research problems in mental health and psychiatric nursing. However, two separate literature searches, one in Scotland and one in the USA, revealed that few mental health nursing studies identified mixed methods research in their titles. Many studies used the term 'embedded' but few studies identified in the literature were mixed methods embedded studies. The history, philosophical underpinnings, definition, types of mixed methods research and associated pragmatism are discussed, as well as the need for mixed methods research. Examples of mental health nursing mixed methods research are used to illustrate the different types of mixed methods: convergent parallel, embedded, explanatory and exploratory in their sequential and concurrent combinations. Implementing mixed methods research is also discussed briefly and the problem of identifying mixed methods research in mental and psychiatric nursing are discussed with some possible solutions to the problem proposed.

 Copyright © 2011 Blackwell Publishing.
PT  - Journal Article
PT  - Review
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21749560
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21749560&id=doi:10.1111%2Fj.1365-2850.2011.01701.x&issn=1351-0126&isbn=&volume=18&issue=6&spage=535&pages=535-42&date=2011&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Mixed+methods+research+in+mental+health+nursing.&aulast=Kettles&pid=%3Cauthor%3EKettles+AM%3C%2Fauthor%3E%3CAN%3E21749560%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<231. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21722222
TI  - The evolution of the role of the Emergency Nurse Practitioner in Scotland: a longitudinal study.
SO  - Journal of Clinical Nursing. 20(19-20):2958-67, 2011 Oct.
VI  - 1
ST  - MEDLINE
AU  - Fotheringham D
AU  - Dickie S
AU  - Cooper M
FA  - Fotheringham, Diane
FA  - Dickie, Sarah
FA  - Cooper, Mark
IN  - Fotheringham, Diane. School of Health, Nursing and Midwifery, University of the West of Scotland, Paisley, UK. diane.fotheringham@uws.ac.uk
AB  - AIMS AND OBJECTIVES: To examine how the role of the Emergency Nurse Practitioner has evolved in Scotland.
AB  - BACKGROUND: In 2001, Cooper and colleagues published a report on their survey (carried out in 1998) which described the extent and nature of Emergency Nurse Practitioner services in Scotland. They described a nascent nursing role and service that existed in almost half of Emergency Departments and that concentrated its activity on the management of minor distal limb trauma and wound management. Since that date, several relevant and important political, professional and local issues have combined to accelerate the development of this role.
AB  - DESIGN: Longitudinal survey of Scottish Emergency Departments (n = 97 in 1998, n = 93 in 2009).
AB  - METHOD: Census survey of all Scottish Emergency Departments identified by NHS National Services Scotland's Information and Statistics Division Accident and Emergency Waiting Times dataset 2006-07.
AB  - RESULTS: Emergency Nurse Practitioners are now practising in the majority (89%) of Emergency Departments and Minor Injury Units compared with 47% in 1998. Most departments (78%) use Emergency Nurse Practitioners in dual roles, and most departments (67%) differentiate their Emergency Nurse Practitioners from other nursing staff by use of a title. Wide variations in pay, role and scope of practice still exist.
AB  - CONCLUSIONS: The role of the Emergency Nurse Practitioner has increasingly become part of mainstream health care delivery in Emergency Departments across Scotland and can now be considered to be common place. This study demonstrates that 'Advanced Nursing Practitioners' and 'Nurse Practitioners' cannot necessarily be considered to be synonymous, and nursing roles that are allowed to evolve naturally adopt a non-uniform level of practice.
AB  - RELEVANCE TO CLINICAL PRACTICE: This paper is of interest to Nurse Practitioners and workforce planners.

 Copyright © 2011 Blackwell Publishing Ltd.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21722222
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21722222&id=doi:10.1111%2Fj.1365-2702.2011.03747.x&issn=0962-1067&isbn=&volume=20&issue=19-20&spage=2958&pages=2958-67&date=2011&title=Journal+of+Clinical+Nursing&atitle=The+evolution+of+the+role+of+the+Emergency+Nurse+Practitioner+in+Scotland%3A+a+longitudinal+study.&aulast=Fotheringham&pid=%3Cauthor%3EFotheringham+D%3C%2Fauthor%3E%3CAN%3E21722222%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<232. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21647079
TI  - The constraints of the ordinary: 'being with' in the context of end-of-life nursing care.
SO  - International Journal of Palliative Nursing. 17(5):245-50, 2011 May.
VI  - 1
ST  - MEDLINE
AU  - Haraldsdottir E
FA  - Haraldsdottir, Erna
IN  - Haraldsdottir, Erna. erna.haraldsdittir@nhs.net
AB  - The concept of 'being with' was an essential part of the hospice philosophy developed by Cicely Saunders, and one that she believed was a key element in the care of the dying. In Saunders' philosophy, 'being with' is a specific moment of engagement between a health professional and a patient whereby the patient has the opportunity to examine and express their thoughts and feelings relating to their imminent death. This study examined how 'being with' was implemented as a part of ordinary day-to-day practice in a hospice in Scotland. The study was based on the principles of ethnomethodology, which aims to reveal embedded and taken-for-granted rules and behaviours that determine practice. The data collection and analysis revealed that the nursing practice was constructed in such a way that 'being with', as Saunders understood it, could not be initiated either by a member of the nursing staff or by the patients. By adopting the philosophical framework of Heidegger, the study offers an understanding of how the nursing staff had developed 'being with' as provision of comfort in order to protect both themselves and the patients from engaging with painful emotions associated with facing death.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21647079
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21647079&id=doi:10.12968%2Fijpn.2011.17.5.245&issn=1357-6321&isbn=&volume=17&issue=5&spage=245&pages=245-50&date=2011&title=International+Journal+of+Palliative+Nursing&atitle=The+constraints+of+the+ordinary%3A+%27being+with%27+in+the+context+of+end-of-life+nursing+care.&aulast=Haraldsdottir&pid=%3Cauthor%3EHaraldsdottir+E%3C%2Fauthor%3E%3CAN%3E21647079%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<233. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21605456
TI  - A retrospective study of risk factors for poor outcomes in methicillin-resistant Staphylococcus aureus (MRSA) infection in surgical patients.
SO  - Journal of Orthopaedic Surgery. 6:25, 2011 May 23.
VI  - 1
ST  - MEDLINE
AU  - Eseonu KC
AU  - Middleton SD
AU  - Eseonu CC
FA  - Eseonu, Kelechi C
FA  - Middleton, Scott D
FA  - Eseonu, Chinyere C
IN  - Eseonu, Kelechi C. Orthopaedic Trauma Unit, Royal Infirmary, Edinburgh, EH16 4SA, UK. kelechi.eseonu@doctors.org.uk
AB  - BACKGROUND: Since its isolation, Methicillin-resistant Staphlococcus aureus (MRSA) has become a major cause of hospital acquired infection (HAI), adverse patient outcome and overall resource utilisation. It is endemic in Scotland and widespread in Western hospitals. MRSA has been the subject of widespread media interest--a manifestation of concerns about sterile surgical techniques and hospital cleanliness. This study aimed to investigate patient outcome of MRSA infections over the last decade at a major orthopaedic trauma centre. The objective was to establish the association of variables, such as patient age and inpatient residence, against patient outcome, in order to quantify significant relationships; facilitating the evaluation of management strategies with an aim to improving patient outcomes and targeting high-risk procedures.
AB  - METHODS: This is a retrospective study of the rates and outcomes of MRSA infection in orthopaedic trauma at the Royal Infirmary of Edinburgh. Data was collated using SPSS 14.0 for Windows(R). Shapiro-Wilkes testing was performed to investigate the normality of continuous data sets (e.g: age). Data was analysed using both Chi-Squared and Fisher's exact tests (in cases of expected values under 5)
AB  - RESULTS: This study found significant associations between adverse patient outcome (persistent deep infection, osteomyelitis, the necessity for revision surgery, amputation and mortality) and the following patient variables: Length of inpatient stay, immuno-compromise, pre-admission residence in an institutional setting (such as a residential nursing home) and the number of antibiotics used in patient care. Despite 63% of all infections sampled resulting from proximal femoral fractures, no association between patient outcome and site of infection or diagnosis was found. Somewhat surprisingly, the relationship between age and outcome of infection was not proved to be significant, contradicting previous studies suggesting a statistical association. Antibiotic prophylaxis, previously identified as a factor in reducing overall incidence of MRSA infection, was not found to be significantly associated with outcome.
AB  - CONCLUSIONS: Early identification of high-risk patients as identified by this study could lead to more judicious use of therapeutic antibiotics and reductions in adverse outcome, as well as socioeconomic cost. These results could assist in more accurate risk stratification based on evidence based evaluation of the significance of the risk factors investigated.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21605456
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21605456&id=doi:10.1186%2F1749-799X-6-25&issn=1749-799X&isbn=&volume=6&issue=&spage=25&pages=25&date=2011&title=Journal+of+Orthopaedic+Surgery&atitle=A+retrospective+study+of+risk+factors+for+poor+outcomes+in+methicillin-resistant+Staphylococcus+aureus+%28MRSA%29+infection+in+surgical+patients.&aulast=Eseonu&pid=%3Cauthor%3EEseonu+KC%3C%2Fauthor%3E%3CAN%3E21605456%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<234. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21596761
TI  - Is it my job? Alcohol brief interventions: knowledge and attitudes among future health-care professionals in Scotland.
SO  - Alcohol & Alcoholism. 46(4):441-50, 2011 Jul-Aug.
VI  - 1
ST  - MEDLINE
AU  - Gill JS
AU  - O'May FP
FA  - Gill, Jan S
FA  - O'May, Fiona P
IN  - Gill, Jan S. School of Health Sciences, Queen Margaret University, Edinburgh EH21 6UU, UK. jgill@qmu.ac.uk
AB  - AIMS: To document knowledge and perceptions relating to the professional role in the area of alcohol misuse within a sample of first year (n = 278) and final year (n = 527) medical, nursing and allied health professional (NAHP) students in Scotland.
AB  - METHODS: A cross sectional survey design involving self-completed questionnaires administered in autumn 2008 (first year students) and spring 2009 (final year students) through course websites and lectures.
AB  - RESULTS: Gaps in the knowledge relating to current UK health guidelines were identified but more so among NAHP students than medical students. Exploration of the perceived role in this area of practice identified three broad groups of students: those clear about their role (medical and nursing students), those advocating a role but not identified by fellow students (occupational therapy and pharmacy) and those uncertain of their role (radiographers, speech and language therapists/audiologists and physiotherapy).
AB  - CONCLUSIONS: Higher education institutions should address the gaps in the knowledge around guidance for alcohol consumption. The effectiveness of brief interventions may depend on it. Additionally, through inter-professional teaching and in collaboration with the relevant professional bodies, more could be done to promote the contribution of practitioners other than those traditionally linked (i.e. medical and nursing) to this important clinical role.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21596761
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21596761&id=doi:10.1093%2Falcalc%2Fagr049&issn=0735-0414&isbn=&volume=46&issue=4&spage=441&pages=441-50&date=2011&title=Alcohol+%26+Alcoholism&atitle=Is+it+my+job%3F+Alcohol+brief+interventions%3A+knowledge+and+attitudes+among+future+health-care+professionals+in+Scotland.&aulast=Gill&pid=%3Cauthor%3EGill+JS%3C%2Fauthor%3E%3CAN%3E21596761%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<235. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21537280
TI  - Who cares for the carers? A student's experience of providing carer support and education.
SO  - British Journal of Nursing. 20(8):484-8, 2011 Apr 28-May 12.
VI  - 1
ST  - MEDLINE
AU  - Roy D
AU  - Gillespie M
FA  - Roy, Dionne
FA  - Gillespie, Mark
AB  - As the incidence of dementia increases with age and people are generally living longer, the number of people requiring care will continue to rise. There are approximately 820000 people in the UK with dementia and more than 500000 carers who are not part of the health and social care workforce. These unpaid carers provide support to people with dementia, often sacrificing their own work commitments, social and family life. As part of the 'Partnerships in recovery' module studied in the third year of the pre-registration mental health nursing programme at the University of the West of Scotland, the first author (DR) chose to use a pycho-education intervention to benefit the needs of a carer and client with vascular dementia. Providing support and education increases the likelihood of both carer and client engaging in a life that is meaningful and hopeful.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21537280
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21537280&id=doi:10.12968%2Fbjon.2011.20.8.484&issn=0966-0461&isbn=&volume=20&issue=8&spage=484&pages=484-8&date=2011&title=British+Journal+of+Nursing&atitle=Who+cares+for+the+carers%3F+A+student%27s+experience+of+providing+carer+support+and+education.&aulast=Roy&pid=%3Cauthor%3ERoy+D%3C%2Fauthor%3E%3CAN%3E21537280%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<236. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21406460
TI  - Age, co-morbidity and poor mobility: no evidence of predicting in-patient death and acute hospital length of stay in the oldest old.
SO  - Qjm. 104(8):671-9, 2011 Aug.
VI  - 1
ST  - MEDLINE
AU  - Pai Y
AU  - Butchart C
AU  - Lunt CJ
AU  - Musonda P
AU  - Gautham N
AU  - Soiza RL
AU  - Potter JF
AU  - Myint PK
FA  - Pai, Y
FA  - Butchart, C
FA  - Lunt, C J
FA  - Musonda, P
FA  - Gautham, N
FA  - Soiza, R L
FA  - Potter, J F
FA  - Myint, P K
IN  - Pai, Y. Department of Elderly Medicine, Royal Preston Hospital, Sharoe Green Lane, Fulwood, Preston PR2 9HT, Lancashire, England, UK.
AB  - BACKGROUND: The oldest old (aged over 90 years) are the fastest growing section of the UK population. Limited data exist regarding the effect of age, location, co-morbidity and physical performance status on outcome of acute illness in this age group.
AB  - METHODS: We performed a prospective study in people aged >= 90 years using hospital audit data in three hospitals in England and Scotland. We examined the characteristics of those admitted over three consecutive calendar months and calculated risk ratios of death and prolonged length of acute hospital stay (>7 days).
AB  - RESULTS: A total of 419 patients were included in this study (68% female, median age 93 years). There were similarities in presentation and diagnoses, but patients in Scotland (n = 164) were more likely to be admitted from sheltered housing or nursing homes than those in England (n = 255). Patients in England were significantly less likely to be able to mobilize < 10 m (41 vs. 34%, P < 0.001) but had lower prevalence of hypertension (40 vs. 55%, P = 0.02), ischaemic heart disease (30% vs. 45%, P = 0.02) and fewer prescribed medications (median 2 vs. 3, P < 0.001). Mortality was similar for the England and Scotland centres (P = 0.98). Previously recognized risk factors for death following hospital admission and length of stay e.g. older age, higher number of co-morbidities and poor mobility were not predictive in this study.
AB  - CONCLUSION: The 'oldest old' should not be considered as a homogenous group and findings from single-centre studies involving this age group may not be generalizable. We found no conclusive evidence that patient-related factors predict outcome in this age group in acute medical admission settings.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21406460
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21406460&id=doi:10.1093%2Fqjmed%2Fhcr028&issn=1460-2393&isbn=&volume=104&issue=8&spage=671&pages=671-9&date=2011&title=Qjm&atitle=Age%2C+co-morbidity+and+poor+mobility%3A+no+evidence+of+predicting+in-patient+death+and+acute+hospital+length+of+stay+in+the+oldest+old.&aulast=Pai&pid=%3Cauthor%3EPai+Y%3C%2Fauthor%3E%3CAN%3E21406460%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<237. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21375571
TI  - Professional boundary work in the face of change to generalist working in community nursing in Scotland.
SO  - Journal of Advanced Nursing. 67(8):1695-704, 2011 Aug.
VI  - 1
ST  - MEDLINE
AU  - Gray C
AU  - Hogg R
AU  - Kennedy C
FA  - Gray, Carol
FA  - Hogg, Rhona
FA  - Kennedy, Catriona
IN  - Gray, Carol. School of Nursing, Midwifery & Social Care, Edinburgh Napier University, UK. c.gray2@napier.ac.uk
CM  - Comment in (CIN)
AB  - AIM: The present study explored how community nurses and managers constituted changes towards generalist working.
AB  - BACKGROUND: Following international trends moving from acute care towards community care, changes within community nursing in the United Kingdom have been subject to debate in recent years. Sociological insights into 'boundary work' in professional disciplines are informative for understandings about proposed new roles in community nursing. Recently, radical changes to the role of the community nurse from specialist disciplines to a generalist community health nurse model were proposed in Scotland and tested in four health boards.
AB  - METHODS: Focus group discussions were held with 27 community nurses and semi-structured interviews with three managers during January-March 2009 in a purposive sample from one health board. Discussions were audio-recorded and transcribed verbatim. Initial thematic analysis was used to highlight key themes from the data and later a discursive analysis focused on the rhetorical strategies used by participants.
AB  - FINDINGS: Four key themes were identified along with the rhetorical devices associated with these including: the undermining of the generalist model through the 'jack of all trades, master of none' metaphor through associations of loss of specialisms; how the re-establishment of specialist discipline boundaries occurred; how current roles were validated and how managers and nurses accounted for future changes to the profession.
AB  - CONCLUSION: The qualitative study explored here has implications for discussions about future role change debates within community nursing as well as the specialist-generalist debate internationally. Managers and policy-makers involved in organizational changes are required to give greater credence to the perceived professional status of community nursing.

 Copyright © 2011 The Authors. Journal of Advanced Nursing © 2011 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21375571
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21375571&id=doi:10.1111%2Fj.1365-2648.2010.05601.x&issn=0309-2402&isbn=&volume=67&issue=8&spage=1695&pages=1695-704&date=2011&title=Journal+of+Advanced+Nursing&atitle=Professional+boundary+work+in+the+face+of+change+to+generalist+working+in+community+nursing+in+Scotland.&aulast=Gray&pid=%3Cauthor%3EGray+C%3C%2Fauthor%3E%3CAN%3E21375571%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<238. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21332574
TI  - Investigating the contribution of community nurses to anticipatory care: a qualitative exploratory study.
SO  - Journal of Advanced Nursing. 67(7):1558-67, 2011 Jul.
VI  - 1
ST  - MEDLINE
AU  - Kennedy C
AU  - Harbison J
AU  - Mahoney C
AU  - Jarvis A
AU  - Veitch L
FA  - Kennedy, Catriona
FA  - Harbison, Jean
FA  - Mahoney, Catherine
FA  - Jarvis, Alison
FA  - Veitch, Linda
IN  - Kennedy, Catriona. School of Nursing, Midwifery and Social Care, Edinburgh Napier University, UK. c.kennedy@napier.ac.uk
CM  - Comment in (CIN)
AB  - AIMS: To investigate how one aspect of anticipatory care is understood and delivered in practice. 'Anticipatory care' in this context can be understood as proactive care, which is oriented towards prevention of adverse events.
AB  - BACKGROUND: Scotland has identified the intention to move away from a preoccupation with acute care and invest in health improvement and anticipatory care. Community nurses are the key, yet little is known about how they understand and deliver anticipatory care.
AB  - METHODS: A qualitative case study design using individual in-depth interviews (n=10), observation (n=9) and focus groups (n=5) was selected. Five focus group interviews were carried out with district nurses, practice nurses and health visitors. Subsequently, nine observation events took place, each focused on a single nurse/client encounter. Data were collected during 2008 and 2009 in one Community Health Partnership in Scotland.
AB  - FINDINGS: Two approaches to anticipatory care emerged; these were influenced by participants' roles and responsibilities. Approach 1 derives from Government policy agenda and is focused on protocol-focused management of long-term illness. Approach 2 is synonymous with long-standing nursing activity focused on holistic care of individual patients. Both approaches are proactive in nature.
AB  - CONCLUSIONS: There is scope to develop a more conceptually complex model of anticipatory care, building on this initial exploration, within which all aims, roles, practices and methods of evaluation can be located and clearly visible. This offers the potential to enable practitioners to interpret and apply policy--otherwise change may be limited and result in service gaps.

 Copyright © 2011 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21332574
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21332574&id=doi:10.1111%2Fj.1365-2648.2010.05589.x&issn=0309-2402&isbn=&volume=67&issue=7&spage=1558&pages=1558-67&date=2011&title=Journal+of+Advanced+Nursing&atitle=Investigating+the+contribution+of+community+nurses+to+anticipatory+care%3A+a+qualitative+exploratory+study.&aulast=Kennedy&pid=%3Cauthor%3EKennedy+C%3C%2Fauthor%3E%3CAN%3E21332574%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<239. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21240481
TI  - Medication incidents reported to an online incident reporting system.
SO  - European Journal of Clinical Pharmacology. 67(5):527-32, 2011 May.
VI  - 1
ST  - MEDLINE
AU  - Alrwisan A
AU  - Ross J
AU  - Williams D
FA  - Alrwisan, Adel
FA  - Ross, Jennifer
FA  - Williams, David
IN  - Alrwisan, Adel. The National Pharmacovigilance Centre, Saudi Food and Drug Authority, Riyadh, Saudi Arabia. aarwisan@sfda.gov.sa
AB  - AIMS: Approximately 20% of deaths from adverse events are related to medication incidents, costing the NHS an additional 500 million annually. Less than 5% of adverse events are reported. This study aims to assess the reporting rate of medication incidents in NHS facilities in the north east of Scotland, and to describe the types and outcomes of reported incidents among different services. Furthermore, we wished to quantify the proportion of reported incidents according to the reporters' profession.
AB  - METHODS: A retrospective description was made of medication incidents reported to an online reporting system (DATIX) over a 46-month-period (July 2005 to April 2009). Reports originated from acute and community hospitals, mental health, and primary care facilities.
AB  - RESULTS: Over the study period there were 2,666 incidents reported with a mean monthly reporting rate of 78.2/month (SD+/-16.9). 6.1% of all incidents resulted in harm, with insulin being the most commonly implicated medication. Nearly three-quarters (74.2%, n=1,978) of total incidents originated from acute hospitals. Administration incidents were implicated in the majority of the reported medication incidents (59%), followed by prescribing (10.8%) and dispensing (9.9%), while the nondescript "other medication incidents" accounted for 20.3% of total incidents. The majority of reports were made by nursing and midwifery staff (80%), with medical and dental professionals reporting the lowest number of incidents (n=56, 2%).
AB  - CONCLUSIONS: The majority of medication incidents in this study were reported by nursing and midwifery staff, and were due to administration incidents. There is a clear need to elucidate the reasons for the limited contribution of the medical and dental professionals to reporting medication incidents.
PT  - Journal Article
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21240481
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21240481&id=doi:10.1007%2Fs00228-010-0986-z&issn=0031-6970&isbn=&volume=67&issue=5&spage=527&pages=527-32&date=2011&title=European+Journal+of+Clinical+Pharmacology&atitle=Medication+incidents+reported+to+an+online+incident+reporting+system.&aulast=Alrwisan&pid=%3Cauthor%3EAlrwisan+A%3C%2Fauthor%3E%3CAN%3E21240481%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<240. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21209143
TI  - Prevalence and outcomes of use of potentially inappropriate medicines in older people: cohort study stratified by residence in nursing home or in the community.
SO  - BMJ Quality & Safety. 20(3):275-81, 2011 Mar.
VI  - 1
ST  - MEDLINE
AU  - Barnett K
AU  - McCowan C
AU  - Evans JM
AU  - Gillespie ND
AU  - Davey PG
AU  - Fahey T
FA  - Barnett, K
FA  - McCowan, C
FA  - Evans, J M M
FA  - Gillespie, N D
FA  - Davey, P G
FA  - Fahey, T
IN  - Barnett, K. Division of Clinical & Population Sciences & Education, University of Dundee, Dundee, UK.
AB  - OBJECTIVES: To compare the prevalence of use of potentially inappropriate medicines (PIMs) between older patients living in their own homes versus those living in nursing or residential homes, and to test the association between exposure to PIMs and mortality.
AB  - DESIGN: Cohort study stratified by place of residence.
AB  - SETTING: Tayside, Scotland.
AB  - PARTICIPANTS: All people aged between 66 and 99 years who were resident or died in Tayside from 2005 to 2006.
AB  - MAIN OUTCOME MEASURES: The exposure variable was PIM use as defined by Beers' Criteria. All cause mortality was the main outcome measure.
AB  - RESULTS: 70,299 people were enrolled in the cohort of whom 96% were exposed to any medicine and 31% received a PIM. Place of residence was not associated with overall risk of receiving PIMs, adjusted OR 0.94, 95% CI 0.87 to 1.01. Exposure to five of the PIMs (including long-acting benzodiazepines) was significantly higher in nursing homes whereas exposure to five other PIMs (including amitriptyline and NSAIDs) was significantly lower. Exposure to PIMs was similar (20-46%) across all 71 general practices in Tayside and was not associated with increased risk of mortality after adjustment for age, gender and polypharmacy (adjusted OR 0.98, 95% CI 0.92 to 1.05).
AB  - CONCLUSIONS: The authors question the validity of the full list of PIMs as an indicator of safety of medicines in older people because one-third of the population is exposed with little practice variation and no significant impact on mortality. Future studies should focus on management of a shorter list of genuinely high-risk medicines.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2011
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21209143
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21209143&id=doi:10.1136%2Fbmjqs.2009.039818&issn=2044-5415&isbn=&volume=20&issue=3&spage=275&pages=275-81&date=2011&title=BMJ+Quality+%26+Safety&atitle=Prevalence+and+outcomes+of+use+of+potentially+inappropriate+medicines+in+older+people%3A+cohort+study+stratified+by+residence+in+nursing+home+or+in+the+community.&aulast=Barnett&pid=%3Cauthor%3EBarnett+K%3C%2Fauthor%3E%3CAN%3E21209143%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<241. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 21050337
TI  - Practitioner attitudes towards patients in forensic mental health settings.
SO  - Journal of Psychiatric & Mental Health Nursing. 17(8):706-14, 2010 Oct.
VI  - 1
ST  - MEDLINE
AU  - Lammie C
AU  - Harrison TE
AU  - Macmahon K
AU  - Knifton L
FA  - Lammie, C
FA  - Harrison, T E
FA  - Macmahon, K
FA  - Knifton, L
IN  - Lammie, C. NHS Greater Glasgow and Clyde, University of Strathclyde, Glasgow, UK.
AB  - Scotland has a national programme to improve mental health and well-being and addressing stigma among mental health practitioners is a priority. This study explores practitioner attitudes towards patients in medium and low secure forensic mental health settings through qualitative and quantitative approaches. Two questionnaires were used with nursing staff. A qualitative questionnaire asked participants to list examples of positive and negative practice and anti-discriminatory and discriminatory attitudes towards patients within forensic services. A quantitative questionnaire then asked participants to answer questions about a hypothetical man with schizophrenia called Harry. The overall balance of responses was more positive than negative in the qualitative results, particularly regarding patient rights, empowerment and control. However, there were a significant minority of negative attitudes in relation to recovery pessimism and desire for social distance. This was supported by the quantitative results where practitioners showed high stigma scores for avoidance and segregation. There were no significant differences in attitudes between medium and low secure settings. However overall, males reported more negative attitudes in relation to blame and avoidance and younger participants demonstrated more negative attitudes than older participants in relation to fear and danger. The implications for addressing stigma are discussed in relation to the wider national anti-stigma campaign and forensic services specifically.

 Copyright © 2010 Blackwell Publishing.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=21050337
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:21050337&id=doi:10.1111%2Fj.1365-2850.2010.01585.x&issn=1351-0126&isbn=&volume=17&issue=8&spage=706&pages=706-14&date=2010&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Practitioner+attitudes+towards+patients+in+forensic+mental+health+settings.&aulast=Lammie&pid=%3Cauthor%3ELammie+C%3C%2Fauthor%3E%3CAN%3E21050337%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<242. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20701188
TI  - Understanding leadership in community nursing in Scotland.
SO  - Community Practitioner. 83(7):24-8, 2010 Jul.
VI  - 1
ST  - MEDLINE
AU  - Haycock-Stuart E
AU  - Baggaley S
AU  - Kean S
AU  - Carson M
FA  - Haycock-Stuart, Elaine
FA  - Baggaley, Sarah
FA  - Kean, Susanne
FA  - Carson, Maggie
IN  - Haycock-Stuart, Elaine. University of Edinburgh.
AB  - There is limited evidence concerning leadership in community nursing. NHS policy also fails to clarify and define what leadership is, though regarding it as key to developing safe and high quality care. This paper reports the findings of a research study that aimed to identify how leadership is perceived and experienced by community nurses, and to examine the interaction between recent policy and leadership development in community nursing. Mixed qualitative methods were used involving 31 individual interviews and three focus groups with community nurses and nurse leaders (n-39) in three health boards in Scotland. Findings indicate the leadership qualities valued by participants, including the importance of leaders' visibility. Team leaders in particular were recognised for their visibility and clinical leadership. Strategic and professional leadership was less evident, so acting as a barrier to the development of the profession. The strategic vision was often not clear to community nurses, and they engaged in differing ways with the strategies and action plans of senior nurse leaders. New leadership roles, like change, need time to evolve and new leaders need space and the education to develop leadership. Future leaders in community nursing need to focus beyond clinical leadership, ensuring that good leadership is a process requiring interdependence between leaders and followers.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20701188
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20701188&id=doi:&issn=1462-2815&isbn=&volume=83&issue=7&spage=24&pages=24-8&date=2010&title=Community+Practitioner&atitle=Understanding+leadership+in+community+nursing+in+Scotland.&aulast=Haycock-Stuart&pid=%3Cauthor%3EHaycock-Stuart+E%3C%2Fauthor%3E%3CAN%3E20701188%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<243. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20663812
TI  - The integrated implementation of two end-of-life care tools in nursing care homes in the UK: an in-depth evaluation.
SO  - Palliative Medicine. 24(8):828-38, 2010 Dec.
VI  - 1
ST  - MEDLINE
AU  - Hockley J
AU  - Watson J
AU  - Oxenham D
AU  - Murray SA
FA  - Hockley, J
FA  - Watson, J
FA  - Oxenham, D
FA  - Murray, S A
IN  - Hockley, J. Primary Palliative Care Research Group, Division of Community Health Sciences, University of Edinburgh, UK. j.hockley@stchristophers.org.uk
AB  - In economically developed countries there is a rapidly increasing number of older people living and dying in care homes. The relative isolation of nursing care homes from the development of palliative care, the poor retention and recruitment of staff, and the lack of medical cover, hinder the provision of quality end-of-life care. End-of-life care strategies internationally highlight the benefit of using tools to help improve end-of-life care in care homes. All seven private nursing care homes within one district in Scotland undertook to implement, as a package, two end-of-life care tools, namely, the Gold Standards Framework for Care Homes (GSFCH) and an adapted Liverpool Care Pathway for Care Homes (LCP). A model of high facilitation, visiting the homes every 10-14 days with significant in-house staff training, was used to implement the 18-month programme. The notes of 228 residents who had died prior to and during the project were examined, alongside a staff audit looking at the effect that the project had on practice. A nurse researcher undertook qualitative interviews of bereaved relatives, pre-/post-implementation. This paper reports the results of an in-depth evaluation of professional practices and residents outcomes. There was a highly statistically significant increase in use of Do Not Attempt Resuscitation (DNAR) documentation, advance care planning and use of the LCP. An apparent reduction in unnecessary hospital admissions and a reduction in hospital deaths from 15% deaths pre-study to 8% deaths post-study were also found. Further work is needed to assess the optimum input required for successful implementation.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20663812
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20663812&id=doi:10.1177%2F0269216310373162&issn=0269-2163&isbn=&volume=24&issue=8&spage=828&pages=828-38&date=2010&title=Palliative+Medicine&atitle=The+integrated+implementation+of+two+end-of-life+care+tools+in+nursing+care+homes+in+the+UK%3A+an+in-depth+evaluation.&aulast=Hockley&pid=%3Cauthor%3EHockley+J%3C%2Fauthor%3E%3CAN%3E20663812%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<244. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20529186
TI  - Developing unplanned care teams in Scotland: evaluating outcomes.
SO  - Journal of Psychiatric & Mental Health Nursing. 17(4):348-54, 2010 May.
VI  - 1
ST  - MEDLINE
AU  - Hurley J
AU  - Kelly M
AU  - Mears A
AU  - Morrison C
AU  - Wiseman F
FA  - Hurley, J
FA  - Kelly, M
FA  - Mears, A
FA  - Morrison, C
FA  - Wiseman, F
IN  - Hurley, J. University of Dundee, Dundee, UK. j.m.hurley@dundee.ac.uk
AB  - Mental health nursing, along with other professional groups, has had to adapt to new ways of delivering health services, often in response to government policy. Consequently, traditional professional boundaries and roles are being rapidly and consistently expanded, often requiring coordinated responses across strategic, educational and clinical domains to ensure service users experience high-quality mental health interventions. This paper explores and evaluates such a coordinated response in developing unplanned care services in Scotland. The evaluation, placed within a framework of realistic evaluation, highlights not only the efficacy of the provided training and education for new roles within unplanned care, but also that emotionally intelligent capabilities are required to successfully implement the level of change currently being experienced within the UK mental health services.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20529186
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20529186&id=doi:10.1111%2Fj.1365-2850.2009.01532.x&issn=1351-0126&isbn=&volume=17&issue=4&spage=348&pages=348-54&date=2010&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Developing+unplanned+care+teams+in+Scotland%3A+evaluating+outcomes.&aulast=Hurley&pid=%3Cauthor%3EHurley+J%3C%2Fauthor%3E%3CAN%3E20529186%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<245. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20528684
TI  - Development of a best practice statement on the use of ankle-foot orthoses following stroke in Scotland. [Review]
SO  - Prosthetics & Orthotics International. 34(3):245-53, 2010 Sep.
VI  - 1
ST  - MEDLINE
AU  - Bowers R
AU  - Ross K
FA  - Bowers, Roy
FA  - Ross, Karyn
IN  - Bowers, Roy. National Centre for Prosthetics and Orthotics, University of Strathclyde, Glasgow, Scotland, UK. r.j.bowers@strath.ac.uk
AB  - A National Health Service Quality Improvement Scotland (NHS QIS) scoping exercise in 2007 identified the use of ankle-foot orthoses (AFOs) following stroke as a clinical improvement priority, leading to the development of a best practice statement (BPS) on AFO use after stroke. This paper outlines the development process of the BPS which is available from NHS QIS. The authors were involved as part of a working group that included practitioners from the fields of orthotics, physiotherapy, stroke nursing and bioengineering, staff of NHS QIS and a patient representative. In consultation with an NHS QIS health services researcher, the authors undertook a systematic literature review to evidence where possible the recommendations made in the BPS. Where evidence was unavailable, consensus was reached by the expert working group. As the BPS was designed for the non-specialist and non-orthotic practitioner the authors also developed educational resources which were included within the BPS to aid the understanding of the principles underpinning orthotic design and prescription. The BPS has been widely distributed throughout the health service in Scotland and is available electronically at no cost via the NHS QIS website. As part of an ongoing evaluation of the impact of the BPS on the quality of orthotic provision, NHS QIS has invited feedback regarding successes and challenges to implementation.
PT  - Journal Article
PT  - Review
PT  - Systematic Review
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20528684
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20528684&id=doi:10.3109%2F03093646.2010.486392&issn=0309-3646&isbn=&volume=34&issue=3&spage=245&pages=245-53&date=2010&title=Prosthetics+%26+Orthotics+International&atitle=Development+of+a+best+practice+statement+on+the+use+of+ankle-foot+orthoses+following+stroke+in+Scotland.&aulast=Bowers&pid=%3Cauthor%3EBowers+R%3C%2Fauthor%3E%3CAN%3E20528684%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<246. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20500286
TI  - Fitness for practice in nursing and midwifery education in Scotland, United Kingdom.
SO  - Journal of Clinical Nursing. 19(3-4):461-9, 2010 Feb.
VI  - 1
ST  - MEDLINE
AU  - Holland K
AU  - Roxburgh M
AU  - Johnson M
AU  - Topping K
AU  - Watson R
AU  - Lauder W
AU  - Porter M
FA  - Holland, Karen
FA  - Roxburgh, Michelle
FA  - Johnson, Martin
FA  - Topping, Keith
FA  - Watson, Roger
FA  - Lauder, William
FA  - Porter, Mary
IN  - Holland, Karen. School of Nursing, University of Salford, Salford, UK. k.holland@salford.ac.uk
AB  - AIM: The aim of this paper is to report findings from a major study that evaluated the Fitness for Practice nursing and midwifery curriculum in Scotland, UK.
AB  - BACKGROUND: The competence of student nurses and midwives at the point of registration has been the focus of debate and research. However, no major study, on such a large scale, had specifically evaluated pre-registration programmes to determine whether they enabled students to achieve 'fitness to practice'.
AB  - DESIGN: The study had a broad evaluation design conducted in three phases using a mixed methodology.
AB  - METHOD: Phase 1 involved questionnaires, Objective Structured Clinical Examination's (OSCE) and curriculum evaluation. Phase 2 involved semi-structured interviews (some telephone) and focus groups across main stakeholders: students (n = 78), mentors (n = 78), practice-education facilitators (n = 24), academics (n = 59), senior clinical (n = 46) and education managers (n = 16), service users and carers (n = 10).
AB  - RESULTS: The findings suggest that the Fitness for Practice curriculum model in Scotland has on the whole been successful. The key finding is the predominant opinion of stakeholders that newly qualified nurses and midwives are perceived as being fit for practice at the point of registration. A perceived lack of confidence is, as with all transitions to new roles, an understandable outcome.
AB  - CONCLUSIONS: Previous concern that student nurses and midwives are not 'fit for practice' has focused on the perceived lack of clinical skills at the point of registration, not on competence to practice in general. This study demonstrates that this is an important distinction and recognises that registration is only the beginning of a life long learning experience.
AB  - RELEVANCE TO CLINICAL PRACTICE: Students need to be supported to develop their confidence following registration as well as additional skills in their chosen field of practice. Appropriate mentorship and a period of preceptorship should be in place to accommodate this.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20500286
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20500286&id=doi:10.1111%2Fj.1365-2702.2009.03056.x&issn=0962-1067&isbn=&volume=19&issue=3-4&spage=461&pages=461-9&date=2010&title=Journal+of+Clinical+Nursing&atitle=Fitness+for+practice+in+nursing+and+midwifery+education+in+Scotland%2C+United+Kingdom.&aulast=Holland&pid=%3Cauthor%3EHolland+K%3C%2Fauthor%3E%3CAN%3E20500286%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<247. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20491212
TI  - Workload and workforce planning: supplementary staffing.
SO  - Nursing Management (Harrow). 17(2):24-8, 2010 May.
VI  - 1
ST  - MEDLINE
AU  - Simpson J
AU  - Barkby I
AU  - Lockhart K
FA  - Simpson, Jacqui
FA  - Barkby, Irene
FA  - Lockhart, Karen
IN  - Simpson, Jacqui. Scottish Government, Edinburgh.
AB  - This article describes how an over-reliance on agency staff in the NHS in Scotland has been addressed by the creation of unified, board-wide nurse banks; the development of a national nurse agency contract; and the use of tools devised by the Nursing and Midwifery Workload and Workforce Planning programme.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20491212
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20491212&id=doi:10.7748%2Fnm2010.05.17.2.24.c7726&issn=1354-5760&isbn=&volume=17&issue=2&spage=24&pages=24-8&date=2010&title=Nursing+Management+%28Harrow%29&atitle=Workload+and+workforce+planning%3A+supplementary+staffing.&aulast=Simpson&pid=%3Cauthor%3ESimpson+J%3C%2Fauthor%3E%3CAN%3E20491212%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<248. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20432644
TI  - Workload and workforce planning: developing a learning toolkit.
SO  - Nursing Management (Harrow). 17(1):32-4, 2010 Apr.
VI  - 1
ST  - MEDLINE
AU  - Kellagher M
AU  - Simpson J
AU  - Flynn B
AU  - Armstrong D
FA  - Kellagher, Mairi
FA  - Simpson, Jacqui
FA  - Flynn, Betty
FA  - Armstrong, Dorothy
IN  - Kellagher, Mairi. NHS West of Scotland.
AB  - The second article in this series described the tools for which there is a consensus for use in nursing and midwifery workload and workforce planning (NMWWP) in Scotland, and the national programme of education and training support developed for the staff who would be using the tools in NHS boards. To help senior charge nurses, midwives and others support and manage their staff resources effectively, a learning toolkit has been developed by the NMWWP programme in partnership with NHS Education for Scotland. The NMWWP learning toolkit (NHS Education for Scotland 2008), described in this article, is a flexible, practical, work-based resource for use in NHS boards. Intended primarily for senior charge nurses, it can also be used by other professionals who aspire to senior charge nurse positions and by nurse managers as a knowledge-refresher.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20432644
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20432644&id=doi:10.7748%2Fnm2010.04.17.1.32.c7646&issn=1354-5760&isbn=&volume=17&issue=1&spage=32&pages=32-4&date=2010&title=Nursing+Management+%28Harrow%29&atitle=Workload+and+workforce+planning%3A+developing+a+learning+toolkit.&aulast=Kellagher&pid=%3Cauthor%3EKellagher+M%3C%2Fauthor%3E%3CAN%3E20432644%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<249. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20398157
TI  - Place of death of older persons with dementia. A study in five European countries.
SO  - Journal of the American Geriatrics Society. 58(4):751-6, 2010 Apr.
VI  - 1
ST  - MEDLINE
AU  - Houttekier D
AU  - Cohen J
AU  - Bilsen J
AU  - Addington-Hall J
AU  - Onwuteaka-Philipsen BD
AU  - Deliens L
FA  - Houttekier, Dirk
FA  - Cohen, Joachim
FA  - Bilsen, Johan
FA  - Addington-Hall, Julia
FA  - Onwuteaka-Philipsen, Bregje D
FA  - Deliens, Luc
IN  - Houttekier, Dirk. End-of-Life Care Research Group, Vrije Universiteit Brussel, Brussels, Belgium. dirk.houttekier@vub.ac.be
AB  - The aging of the European population will lead to a rapid increase in dementia cases in the coming decades, posing challenges for the organization and provision of end-of-life care. Studying the place of death of patients with dementia, and what determines it, is relevant in this context. Using death certificates, the deaths of people aged 65 and older whose underlying cause of death was a dementia-related disease was studied in Belgium, the Netherlands, England, Scotland, and Wales. Between 50% (Wales) and 92% (Netherlands) of patients with dementia died in a nursing home and between 3% (Netherlands) and 46% (Wales) in hospital. Home death was rare (3-5%) except in Belgium (11%). Multivariate analysis showed that place of death was related to age, sex, available hospital and nursing home beds, and country of residence. Although availability of hospital and nursing home beds partially explained the variation between countries, considerable variation remained even after controlling for that, plus age, sex, and social support. Place of death from dementia differed significantly between the countries studied. In all countries, a majority of patients with dementia died in a long-term care facility. The provision of appropriate long-term care facilities with appropriate staffing could be the primary policy instrument that could help patients with dementia avoid dying in the hospital and ensure quality of end-of-life care in Europe.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20398157
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20398157&id=doi:10.1111%2Fj.1532-5415.2010.02771.x&issn=0002-8614&isbn=&volume=58&issue=4&spage=751&pages=751-6&date=2010&title=Journal+of+the+American+Geriatrics+Society&atitle=Place+of+death+of+older+persons+with+dementia.+A+study+in+five+European+countries.&aulast=Houttekier&pid=%3Cauthor%3EHouttekier+D%3C%2Fauthor%3E%3CAN%3E20398157%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<250. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20373654
TI  - Workload and workforce planning: tools, education and training.
SO  - Nursing Management (Harrow). 16(10):32-5, 2010 Mar.
VI  - 1
ST  - MEDLINE
AU  - Flynn B
AU  - Kellagher M
AU  - Simpson J
FA  - Flynn, Betty
FA  - Kellagher, Mairi
FA  - Simpson, Jacqui
AB  - The Nursing and Midwifery Workload and Workforce Planning programme for Scotland, the origins of which were described in last month's Nursing Management, does not solve all the problems faced by workforce planners. However, it can provide evidence that informs decisions, workload and workforce changes and a suite of tools has been developed, evaluated and introduced to help healthcare staff gather this evidence. In this article, these tools, and the education and training initiatives that help staff use them, are described.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20373654
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20373654&id=doi:10.7748%2Fnm2010.03.16.10.32.c7612&issn=1354-5760&isbn=&volume=16&issue=10&spage=32&pages=32-5&date=2010&title=Nursing+Management+%28Harrow%29&atitle=Workload+and+workforce+planning%3A+tools%2C+education+and+training.&aulast=Flynn&pid=%3Cauthor%3EFlynn+B%3C%2Fauthor%3E%3CAN%3E20373654%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<251. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20231045
TI  - Secondment as a means of practice development for Community Learning Disability Nurses working with children.
SO  - Nurse Education Today. 30(7):692-6, 2010 Oct.
VI  - 1
ST  - MEDLINE
AU  - Cheseldine S
AU  - Brown M
AU  - Wilkie F
FA  - Cheseldine, Sally
FA  - Brown, Marie
FA  - Wilkie, Fiona
IN  - Cheseldine, Sally. NHS Lothian, CPPD, Edenhall Hospital, Pinkieburn Road, Musselburgh EH21 7TZ, UK.
AB  - Many Community Learning Disability Nurses (CLDNs) in Scotland who work with children will have had some child health input during their registered nurse education programme, but often not specific to the needs of children who might be referred to them now as result of population changes, community care policy and improved methods of diagnosis (PHIS, 2004). Community nurses have relatively poor skills in detecting and managing mental health problems and identify training as a means of addressing this (Fox et al., 2003). To address the practice development needs identified by CLDNs through their Personal Development Plans (PDPs), secondments were provided to a Child and Adolescent Mental Health Service (CAMHS) for children and young people with learning disabilities for 2 days a week for six months. This was taken up by five CLDNs over a period of 3 years. The goals they set in their secondments were evaluated using Goal Attainment Scaling (GAS). This paper aims to discuss the use of GAS within secondments, as a means of identifying learning needs and developing practice in the area of CAMH nursing. The background to the paper, work based learning, health needs of children with LD and GAS are highlighted. Recommendations for future development are made.

 Copyright © 2010 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20231045
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20231045&id=doi:10.1016%2Fj.nedt.2010.01.007&issn=0260-6917&isbn=&volume=30&issue=7&spage=692&pages=692-6&date=2010&title=Nurse+Education+Today&atitle=Secondment+as+a+means+of+practice+development+for+Community+Learning+Disability+Nurses+working+with+children.&aulast=Cheseldine&pid=%3Cauthor%3ECheseldine+S%3C%2Fauthor%3E%3CAN%3E20231045%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<252. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20227360
TI  - A review of the literature: midwifery decision-making and birth. [Review]
SO  - Women & Birth: Journal of the Australian College of Midwives. 23(4):127-34, 2010 Dec.
VI  - 1
ST  - MEDLINE
AU  - Jefford E
AU  - Fahy K
AU  - Sundin D
FA  - Jefford, Elaine
FA  - Fahy, Kathleen
FA  - Sundin, Deborah
IN  - Jefford, Elaine. Newcastle University, School of Nursing and Midwifery, Callaghan Campus, NSW, Australia. elaine.jefford@uon.edu.au
AB  - BACKGROUND: Clinical decision-making was initially studied in medicine where hypothetico-deductive reasoning is the model for decision-making. The nursing perspective on clinical decision-making has largely been shaped by Patricia Benner's ground breaking work. Benner claimed expert nurses use humanistic-intuitive ways of making clinical decisions rather than the 'rational reasoning' as claimed by medicine. Clinical decision-making in midwifery is not the same as either nursing or medical decision-making because of the woman-midwife partnership where the woman is the ultimate decision-maker.
AB  - METHOD: CINHAL, Medline and Cochrane databases were systematically searched using key words derived from the guiding question. A review of the decision-making research literature in midwifery was undertaken where studies were published in English. The selection criteria for papers were: only research papers of direct relevance to the guiding research question were included in the review.
AB  - FINDINGS: Decision-making is under-researched in midwifery and more specifically birth, as only 4 research articles met the inclusion criteria in this review. Three of the studies involved qualified midwives, and one involved student midwives. Two studies were undertaken in England, one in Scotland and one in Sweden. The major findings synthesised from this review, are that; (1) midwifery decision-making during birth is socially negotiated involving hierarchies of surveillance and control; (2) the role of the woman in shared decision-making during birth has not been explored by midwifery research; (3) clinical decision-making encompasses clinical reasoning as essential but not sufficient for midwives to actually implement their preferred decision.
AB  - CONCLUSION: We argue that existing research does not inform the discipline of the complexity of midwifery clinical decision-making during birth. A well-designed study would involve investigating the clinical reasoning skills of the midwife, her relationship with the woman, the context of the particular birthing unit and the employment status of the midwife. The role of the woman as decision-maker in her own care during birth also needs careful research attention.

 Copyright © 2010 Australian College of Midwives. All rights reserved.
PT  - Journal Article
PT  - Review
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20227360
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20227360&id=doi:10.1016%2Fj.wombi.2010.02.001&issn=1871-5192&isbn=&volume=23&issue=4&spage=127&pages=127-34&date=2010&title=Women+%26+Birth%3A+Journal+of+the+Australian+College+of+Midwives&atitle=A+review+of+the+literature%3A+midwifery+decision-making+and+birth.&aulast=Jefford&pid=%3Cauthor%3EJefford+E%3C%2Fauthor%3E%3CAN%3E20227360%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<253. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20222230
TI  - Workload and workforce planning: taking a national approach.
SO  - Nursing Management (Harrow). 16(9):32-4, 2010 Feb.
VI  - 1
ST  - MEDLINE
AU  - Lockhart K
AU  - Barkby I
AU  - Kellagher M
FA  - Lockhart, Karen
FA  - Barkby, Irene
FA  - Kellagher, Mairi
IN  - Lockhart, Karen. Chief Nursing Officer's Directorate, Scottish Government, Edinburgh.
AB  - In response to an Audit Scotland report, the Scottish Executive, now the Scottish Government, set up the national Nursing and Midwifery Workload and Workforce Planning (NMWWP) programme to define workload and workforce needs, and to analyse the use of bank and agency staff. After extensive research, a systematic, national approach to nursing and midwifery workload and workforce planning was recommended. This article, the first in a series of five on this topic, describes the legislation and policies that underpin the NMWWP programme, and highlights the demographic issues that are pertinent to the nursing and midwifery workforce in Scotland.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20222230
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20222230&id=doi:10.7748%2Fnm2010.02.16.9.32.c7525&issn=1354-5760&isbn=&volume=16&issue=9&spage=32&pages=32-4&date=2010&title=Nursing+Management+%28Harrow%29&atitle=Workload+and+workforce+planning%3A+taking+a+national+approach.&aulast=Lockhart&pid=%3Cauthor%3ELockhart+K%3C%2Fauthor%3E%3CAN%3E20222230%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<254. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20218778
TI  - Interprofessional attitudes and perceptions: Results from a longitudinal controlled trial of pre-registration health and social care students in Scotland.
SO  - Journal of Interprofessional Care. 24(5):549-64, 2010 Sep.
VI  - 1
ST  - MEDLINE
AU  - McFadyen AK
AU  - Webster VS
AU  - Maclaren WM
AU  - O'neill MA
FA  - McFadyen, A K
FA  - Webster, V S
FA  - Maclaren, W M
FA  - O'neill, M A
IN  - McFadyen, A K. School of Engineering & Computing, Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 0BA, UK. akmf@gcal.ac.uk
AB  - This study made use of a controlled longitudinal design to assess the impact on pre-registration health and social care students of an interprofessional intervention on the attitudes to and perceptions of interprofessional ideals. Evaluation, over four years, of Nursing, Occupational Therapy, Podiatry, Prosthetics and Orthotics, Physiotherapy and Radiography students was performed using the adapted versions of the Readiness for Interprofessional Learning Scale (RIPLS) and the Interdisciplinary Education Perception Scale (IEPS). Baseline samples of the control and experimental groups were 260 and 313 respectively. Support for Interprofessional Education (IPE) appears high but possibly idealistically so initially. Restricted Maximum Likelihood (REML) models were used to assess intervention effects as well as any possible profession or time effects. The intervention was found to have had a significant effect on five of the measured sub-scales and the professions were found to react in a significantly different way on four of the sub-scales. The inclusion of a control group has confirmed previous findings from other studies but also highlights the possible effects of the general learning and teaching methodologies employed within various professions as well as the need for research into the influence of the timing, duration, style and content of clinical placement periods.
PT  - Clinical Trial
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20218778
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20218778&id=doi:10.3109%2F13561820903520369&issn=1356-1820&isbn=&volume=24&issue=5&spage=549&pages=549-64&date=2010&title=Journal+of+Interprofessional+Care&atitle=Interprofessional+attitudes+and+perceptions%3A+Results+from+a+longitudinal+controlled+trial+of+pre-registration+health+and+social+care+students+in+Scotland.&aulast=McFadyen&pid=%3Cauthor%3EMcFadyen+AK%3C%2Fauthor%3E%3CAN%3E20218778%3C%2FAN%3E%3CDT%3EClinical+Trial%3C%2FDT%3E

<255. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20149502
TI  - Can we predict successful completion of the common foundation programme at interview?.
SO  - Nurse Education Today. 30(7):649-56, 2010 Oct.
VI  - 1
ST  - MEDLINE
AU  - Donaldson JH
AU  - McCallum J
AU  - Lafferty P
FA  - Donaldson, Jayne H
FA  - McCallum, Jacqueline
FA  - Lafferty, Patricia
IN  - Donaldson, Jayne H. School of Nursing, Midwifery and Social Care, Faculty of Health, Life and Social Science, Edinburgh Napier University, Comely Bank Campus, Edinburgh EH4 2LD, UK. j.donaldson@napier.ac.uk
AB  - AIM: To gain an understanding of patterns of retention and attrition for student nurses on the diploma of higher education (DipHE)/bachelor of science (B.Sc.) (adult) on completion of the common foundation programme (CFP=year 1 of the programme).
AB  - METHOD: A questionnaire called the "interview score sheet" (ISS) collected data on six cohorts from a Higher Education Institution in Scotland. At the initial recruitment interview each candidate was scored independently by two interviewers on the ISS. Successful/unsuccessful attempts of theory-based and practice-based modules, and any reasons for attrition were recorded throughout the CFP. For the purposes of this study success was defined as achieving a pass grade in all modules associated with year 1 of the programme.
AB  - MAIN OUTCOME MEASURES: The study investigated the potential of the ISS in providing a reliable guide for student selection onto the DipHE/B.Sc. in nursing (adult) and providing information about the characteristics of a typical successful/unsuccessful student from the CFP.
AB  - ANALYSIS: Statistical analysis was conducted to examine the correlation between the total score on the ISS, any characteristics on the ISS and the students' successful completion of the CFP.
AB  - RESULTS: Six-hundred and thirty-eight students entered the CFP: 118 (18%) were unsuccessful and 520 (82%) were successful completers of the CFP. From the characteristics noted at interview on the ISS, the most reliable predictor of success was age. The total score achieved on the ISS was shown not to be a reliable predictor of success. Although not statistically significant, testing of numeracy and standard and content of written work may be of some value in predicting success and may warrant further study.

 Copyright © 2010 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Validation Study
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20149502
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20149502&id=doi:10.1016%2Fj.nedt.2009.12.019&issn=0260-6917&isbn=&volume=30&issue=7&spage=649&pages=649-56&date=2010&title=Nurse+Education+Today&atitle=Can+we+predict+successful+completion+of+the+common+foundation+programme+at+interview%3F.&aulast=Donaldson&pid=%3Cauthor%3EDonaldson+JH%3C%2Fauthor%3E%3CAN%3E20149502%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<256. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20100629
TI  - Numeracy for nursing, report of a pilot study to compare outcomes of two practical simulation tools--an online medication dosage assessment and practical assessment in the style of objective structured clinical examination.
SO  - Nurse Education Today. 30(7):608-14, 2010 Oct.
VI  - 1
ST  - MEDLINE
AU  - Hutton M
AU  - Coben D
AU  - Hall C
AU  - Rowe D
AU  - Sabin M
AU  - Weeks K
AU  - Woolley N
FA  - Hutton, Meriel
FA  - Coben, Diana
FA  - Hall, Carol
FA  - Rowe, David
FA  - Sabin, Mike
FA  - Weeks, Keith
FA  - Woolley, Norman
IN  - Hutton, Meriel. Department of Education and Professional Studies, King's College London, UK. Meriel.hutton@btinternet.com
AB  - UNLABELLED: This pilot study compares the results of medications calculations carried out by student nurses using an online assessment tool with the results of the same calculations carried out within simulated practice. The numeracy project, of which this is part, is funded by NHS Education for Scotland (NES).
AB  - OBJECTIVE: To test the efficacy of a realistic computer-based assessment of pre-registration nurses' medication calculations skills by comparing outcomes from using an online assessment tool with a practical assessment tool in the style of an Objective Structured Clinical Examination OSCE. Both assessment methods used medicine calculations usually presenting authentically in the practice setting.
AB  - DESIGN: A multi-stage quantitative study using a cross-over design.
AB  - SAMPLE: Fifty early 3rd year students on the adult branch of a pre-registration nursing programme at a large school of nursing in England.
AB  - RESULTS: Results showed that, for assessing accuracy of calculation, there was a high level of congruence between the two methods.
AB  - CONCLUSIONS: Computerised assessment of medications calculations using this particular platform is likely to closely mirror assessment of medication calculations done in a practical setting. As such it could be a useful adjunct to current assessment methods.

 Copyright © 2009 Elsevier Ltd. All rights reserved.
PT  - Comparative Study
PT  - Journal Article
PT  - Randomized Controlled Trial
PT  - Validation Study
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20100629
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20100629&id=doi:10.1016%2Fj.nedt.2009.12.009&issn=0260-6917&isbn=&volume=30&issue=7&spage=608&pages=608-14&date=2010&title=Nurse+Education+Today&atitle=Numeracy+for+nursing%2C+report+of+a+pilot+study+to+compare+outcomes+of+two+practical+simulation+tools--an+online+medication+dosage+assessment+and+practical+assessment+in+the+style+of+objective+structured+clinical+examination.&aulast=Hutton&pid=%3Cauthor%3EHutton+M%3C%2Fauthor%3E%3CAN%3E20100629%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<257. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20015951
TI  - Healthcare and medical graduates of 2009: their reactions to four key proposals in the Scottish Government's strategy for tackling alcohol misuse.
SO  - Alcohol & Alcoholism. 45(2):200-6, 2010 Mar-Apr.
VI  - 1
ST  - MEDLINE
AU  - Gill JS
AU  - Gibson C
AU  - Nicol M
FA  - Gill, Jan S
FA  - Gibson, Caroline
FA  - Nicol, Maggie
IN  - Gill, Jan S. School of Health Sciences, Queen Margaret University, Edinburgh, EH21 6UU, UK. jgill@qmu.ac.uk
AB  - AIMS: This study compares the views of final year medical, and nursing and allied health professional (NAHP) students in relation to four governmental proposals impacting on the sale and purchase of alcohol.
AB  - METHODS: Against a background of political will to address alcohol abuse in Scotland and moves within the National Health Service promoting a shifting of professional roles, self-completed questionnaires were administered in spring 2009 through course websites and lectures to final year medical and NAHP students.
AB  - RESULTS: Questionnaires were returned by 406 NAHPs and 121 medical students. Over three quarters of all students agreed with the proposed change to reduce the drink driving limit to 50 mg/100 ml blood. Less support was evident for the raising of the minimum legal purchase age for off-sales (37%), the banning of below cost price promotions of alcohol (47%) and minimum retail pricing (37%). However, there were differences between the NAHP and medical students in the case of the final two proposals; over 60% of the medical students agreed they would have a positive impact. For NAHPs, figures were 41% and 31%, respectively.
AB  - CONCLUSIONS: Support for four key proposals outlined by the Scottish Government to address alcohol misuse varied. Only the suggestion to lower the drink driving limit received backing overall and within students in these professions. Effectiveness of proposed restrictions on the price of alcohol was less well regarded except by medical students. Evident gaps in knowledge around health guidelines, and the finding that almost half of NAHPs disagreed that they had the appropriate knowledge to advise patients about responsible drinking advice and alcohol misuse problems, suggest a need for improved undergraduate education and continued professional development with respect to public health aspects of alcohol use.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=20015951
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20015951&id=doi:10.1093%2Falcalc%2Fagp084&issn=0735-0414&isbn=&volume=45&issue=2&spage=200&pages=200-6&date=2010&title=Alcohol+%26+Alcoholism&atitle=Healthcare+and+medical+graduates+of+2009%3A+their+reactions+to+four+key+proposals+in+the+Scottish+Government%27s+strategy+for+tackling+alcohol+misuse.&aulast=Gill&pid=%3Cauthor%3EGill+JS%3C%2Fauthor%3E%3CAN%3E20015951%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<258. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19995348
TI  - Inter-hospital transfers of acutely ill adults in Scotland.
SO  - Anaesthesia. 65(2):136-44, 2010 Feb.
VI  - 1
ST  - MEDLINE
AU  - Fried MJ
AU  - Bruce J
AU  - Colquhoun R
AU  - Smith G
FA  - Fried, M J
FA  - Bruce, J
FA  - Colquhoun, R
FA  - Smith, G
IN  - Fried, M J. Department of Anaesthesia, St John's Hospital, Livingston, UK.
AB  - The transfer of acutely ill adults who were transported between hospitals by the Scottish Ambulance Service was audited in order to determine the number of transfers and to quantify the incidence of adverse events. Patients over 16 years of age requiring intervention/vital signs monitoring during transfer or a nursing/medical escort from the outset were defined as acutely ill adults. Three thousand and forty-eight audit forms were received, of which 2396 were suitable for inclusion in the audit. Transfers primarily occurred for specialist management (1580; 66%) or specialist investigation (550; 23%). Clinicians escorted 825 (34%) patients and were away from their hospital a median (IQR [range]) of 2 h (01:24-3:30 [00:05-17:33]) h:min Clinical intervention was required in 84 transfers (4%). The median (IQR [range]) time for 248 transfers (10.3%) requiring assisted ventilation was 28 min (00:17-00:50 [00:04-02:55]). The incidence of unsecured medical equipment (in escorted transfers only) was significantly lower in dedicated transport teams (2/205, 1%) vs non-dedicated (113/620, 18%; p = 0.004). Medical equipment failures were less common in the transfer of patients requiring assisted ventilation (1/156, 0.6% vs 9/97, 9%; p = 0.001).
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19995348
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19995348&id=doi:10.1111%2Fj.1365-2044.2009.06165.x&issn=0003-2409&isbn=&volume=65&issue=2&spage=136&pages=136-44&date=2010&title=Anaesthesia&atitle=Inter-hospital+transfers+of+acutely+ill+adults+in+Scotland.&aulast=Fried&pid=%3Cauthor%3EFried+MJ%3C%2Fauthor%3E%3CAN%3E19995348%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<259. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19805006
TI  - A census of the advanced and specialist cancer nursing workforce in England, Northern Ireland and Wales.
SO  - European Journal of Oncology Nursing. 14(1):68-73, 2010 Feb.
VI  - 1
ST  - MEDLINE
AU  - Trevatt P
AU  - Leary A
FA  - Trevatt, Paul
FA  - Leary, Alison
IN  - Trevatt, Paul. North East London Cancer Network, Outpatients Dept, First Floor, Royal London Hospital, Stepney Way, London E1 1BB, UK. paul.trevatt@bartsandthelondon.nhs.uk
AB  - INTRODUCTION: At present no detailed data on the specialist cancer nursing workforce across different cancer types and populations is routinely collected in England, Wales or Northern Ireland. This has implications for workforce planning and the future provision of cancer services.
AB  - METHOD: In an attempt to establish a baseline of the workforce a census was taken. Data was collected via an Excel spreadsheet by Cancer Network Nurse Directors and Lead Nurses across England and Northern Ireland and a lead nurse in Wales. Scotland, Palliative Care and Chemotherapy posts were excluded at levels other than Consultant as these are collected via other mechanisms.
AB  - RESULTS & CONCLUSIONS: The census recorded 2309.4 specialist and advanced practice posts in England (89% response rate), 204 posts in Wales (66% response rate) and 43.4 posts in Northern Ireland (100% response rate). There is a variation in terms of distribution of specialist nurses across the Networks both in number and in cancer type. 1800 adult CNS posts were recorded in England and 1 in 5 of these were breast cancer posts. The range of job titles is very wide with 17 different titles being used. In England the extent of support for posts from Macmillan Cancer Support was considerable. Around a third (31%) of all adult cancer specialist posts in England are supported by Macmillan Cancer Support (n=671.2) 607.2 of these are CNS posts equating to 34% of all CNS posts in England. 34% of all NI CNS posts and 32.5% in Wales.

 Copyright 2009 Elsevier Ltd. All rights reserved.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19805006
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19805006&id=doi:10.1016%2Fj.ejon.2009.08.005&issn=1462-3889&isbn=&volume=14&issue=1&spage=68&pages=68-73&date=2010&title=European+Journal+of+Oncology+Nursing&atitle=A+census+of+the+advanced+and+specialist+cancer+nursing+workforce+in+England%2C+Northern+Ireland+and+Wales.&aulast=Trevatt&pid=%3Cauthor%3ETrevatt+P%3C%2Fauthor%3E%3CAN%3E19805006%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<260. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19596322
TI  - Using the serious mental illness health improvement profile [HIP] to identify physical problems in a cohort of community patients: a pragmatic case series evaluation.
SO  - International Journal of Nursing Studies. 47(2):136-45, 2010 Feb.
VI  - 1
ST  - MEDLINE
AU  - Shuel F
AU  - White J
AU  - Jones M
AU  - Gray R
FA  - Shuel, Francis
FA  - White, Jacquie
FA  - Jones, Martin
FA  - Gray, Richard
IN  - Shuel, Francis. Wishaw General Hospital, Lanarkshire, Scotland, United Kingdom.
AB  - BACKGROUND AND OBJECTIVES: The physical health of people with serious mental illness is a cause of growing concern to clinicians. Life expectancy in this population may be reduced by up to 25 years and patients often live with considerable physical morbidity that can dramatically reduce quality of life and contribute to social exclusion. This study sought to determine whether the serious mental illness health improvement profile [HIP], facilitated by mental health nurses [MHNs], has the clinical potential to identify physical morbidity and inform future evidence-based care.
AB  - DESIGN: Retrospective documentation audit and qualitative evaluation of patients' and clinicians' views about the use of the HIP in practice.
AB  - SETTING: A nurse-led outpatient medication management clinic, for community adult patients with serious mental illness in Scotland.
AB  - PARTICIPANTS: 31 Community patients with serious mental illness seen in the clinic by 2 MHNs trained to use the HIP. All 31 patients, 9 MHNs, 4 consultant psychiatrists and 12 general practitioners [GPs] (primary care physicians) participated in the qualitative evaluation.
AB  - METHODS: A retrospective documentation audit of case notes for all patients where the HIP had been implemented. Semi-structured interviews with patients and their secondary care clinicians. Postal survey of GPs.
AB  - RESULTS: 189 Physical health issues were identified (mean 6.1 per patient). Items most frequently flagged 'red', suggesting that intervention was required, were body mass index [BMI] (n=24), breast self-examination (n=23), waist circumference (n=21), pulse (n=14) and diet (n=13). Some rates of physical health problems observed were broadly similar to those reported in studies of patients receiving antipsychotics in primary care but much lower than those reported in epidemiological studies. Individualised care was planned and delivered with each patient based on the profile. 28 discreet interventions that included providing advice, promoting health behavioural change, performing an electrocardiogram and making a referral to professional colleagues were used. Qualitative feedback was positive. Our observations support the use of the HIP in clinical settings to enhance mental health nursing practice; however, we strongly recommend that training is required to support the use of the HIP.

 Copyright 2009 Elsevier Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19596322
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19596322&id=doi:10.1016%2Fj.ijnurstu.2009.06.003&issn=0020-7489&isbn=&volume=47&issue=2&spage=136&pages=136-45&date=2010&title=International+Journal+of+Nursing+Studies&atitle=Using+the+serious+mental+illness+health+improvement+profile+%5BHIP%5D+to+identify+physical+problems+in+a+cohort+of+community+patients%3A+a+pragmatic+case+series+evaluation.&aulast=Shuel&pid=%3Cauthor%3EShuel+F%3C%2Fauthor%3E%3CAN%3E19596322%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<261. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19560236
TI  - Not choosing nursing: work experience and career choice of high academic achieving school leavers.
SO  - Nurse Education Today. 30(1):9-14, 2010 Jan.
VI  - 1
ST  - MEDLINE
AU  - Neilson GR
AU  - McNally JG
FA  - Neilson, Gavin R
FA  - McNally, James G
IN  - Neilson, Gavin R. School of Nursing and Midwifery, University of Dundee, United Kingdom. g.r.neilson@dundee.ac.uk
AB  - Work experience has been a feature of the secondary school curriculum in the United Kingdom for a number of years. Usually requested by the pupil, it aims to provide opportunities for school pupils to enhance their knowledge and understanding of an occupation. The main benefits are claimed to be that it can help pupils develop an insight into the skills and attitudes required for an occupation and an awareness of career opportunities. However the quality and choice of placements are considered to be of great importance in this process and in influencing career choice [Department for Education and Skills (DfES), 2002a. Work Experience: A Guide for Employers. Department for Education and Skills, London]. As university departments of nursing experience a decline in the number of school pupils entering student nurse education programmes, and with the competition for school leavers becoming even greater, it is important to consider whether school pupils have access to appropriate work placements in nursing and what influence their experience has on pursuing nursing as a career choice. This paper is based on interview data from 20 high academic achieving fifth and sixth year school pupils in Scotland, paradigmatic cases from a larger survey sample (n=1062), who had considered nursing as a possible career choice within their career preference cluster, but then later disregarded nursing and decided to pursue medicine or another health care profession. This was partly reported by Neilson and Lauder [Neilson, G.R., Lauder, W., 2008. What do high academic achieving school pupils really think about a career in nursing: analysis of the narrative from paradigmatic case interviews. Nurse Education Today 28(6), 680-690] which examined what high academic achieving school pupils really thought about a career in nursing. However, the data was particularly striking in revealing the poor quality of nursing work experience for the pupils, and also their proposal that there was a need for work experience which was more representative of the reality of nursing. Participants reported that proper work experience in nursing could make it more attractive as a career choice but that there were difficulties and barriers in obtaining an appropriate work experience in nursing. These included unhelpful attitudes of teachers towards work experience in nursing in general and the placements themselves which were typically in a nursing home or a care home. They felt that departments of nursing within universities should have an input into organising more realistic work placements and that their involvement could foster greater interest amongst pupils in nursing as a career.
PT  - Journal Article
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19560236
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19560236&id=doi:10.1016%2Fj.nedt.2009.05.007&issn=0260-6917&isbn=&volume=30&issue=1&spage=9&pages=9-14&date=2010&title=Nurse+Education+Today&atitle=Not+choosing+nursing%3A+work+experience+and+career+choice+of+high+academic+achieving+school+leavers.&aulast=Neilson&pid=%3Cauthor%3ENeilson+GR%3C%2Fauthor%3E%3CAN%3E19560236%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<262. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19464953
TI  - Pre-registration adult nurses' knowledge of safe transfusion practice: Results of a 12 month follow-up study.
SO  - Nurse Education in Practice. 10(2):101-7, 2010 Mar.
VI  - 1
ST  - MEDLINE
AU  - Smith FC
AU  - Donaldson J
AU  - Pirie L
FA  - Smith, Fiona C
FA  - Donaldson, Jayne
FA  - Pirie, Liz
IN  - Smith, Fiona C. School of Nursing, Midwifery and Social Care, Canaan Lane Campus, Edinburgh Napier University, Edinburgh EH9 2TB, United Kingdom. f.smith@napier.ac.uk
AB  - This research project ascertained student nurses' knowledge retention of safe transfusion practice following a standardised teaching and learning programme (produced by the Scottish National Blood Transfusion Service, United Kingdom (UK)) within a School of Nursing in Scotland, UK. Several studies including the Serious Hazard of Transfusion (SHOT) annual reports demonstrated that there are risks to the patient in receiving blood components: receiving the wrong blood was the most common risk associated with blood transfusion (Ottewill, 2003; SHOT, 2007). This evaluative study used a questionnaire to assess the level of knowledge students (n=118) attained on the day of the session, 4-6 months and 11-12 months following the session. The study provided an insight into the effectiveness of a standardised teaching approach and highlighted areas for review in light of incorrect answers elicited. Despite all receiving the Standardised Programme, there was a wide range of initial overall scores achieved. The study demonstrated, within the small sample completing at all 3 time points, that there is clear degradation of knowledge during the study period. The influence of experience on knowledge retention appears to have a positive effect at 6 months but no appreciable effect at 12 months. These outcomes merit further, more robust and multi centre investigation to identify if there is replication of results.

 Copyright 2009 Elsevier Ltd. All rights reserved.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19464953
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19464953&id=doi:10.1016%2Fj.nepr.2009.04.003&issn=1471-5953&isbn=&volume=10&issue=2&spage=101&pages=101-7&date=2010&title=Nurse+Education+in+Practice&atitle=Pre-registration+adult+nurses%27+knowledge+of+safe+transfusion+practice%3A+Results+of+a+12+month+follow-up+study.&aulast=Smith&pid=%3Cauthor%3ESmith+FC%3C%2Fauthor%3E%3CAN%3E19464953%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<263. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19374700
TI  - Psychosocial health and health-related quality of life in school pupils 11-18 years.
SO  - Journal of Clinical Nursing. 19(13-14):1821-9, 2010 Jul.
VI  - 1
ST  - MEDLINE
AU  - Lauder W
AU  - Burton C
AU  - Roxburgh CM
AU  - Themessl-Huber M
AU  - O'Neill M
AU  - Abubakari A
FA  - Lauder, William
FA  - Burton, Catherine
FA  - Roxburgh, C Michelle
FA  - Themessl-Huber, Markus
FA  - O'Neill, Michelle
FA  - Abubakari, Abdulrazak
IN  - Lauder, William. Department of Nursing & Midwifery, University of Stirling, Stirling, UK. w.lauder@dundee.ac.uk
AB  - AIM: To establish levels of mental health at a community level and to model the relationship between mental health difficulty, health-related impact and health related quality of life in school pupils aged 11-18 years old.
AB  - BACKGROUND: The issue of psychosocial and mental health in school pupils is a topic of considerable academic and public interest. The incidence of mental health problems in children 11-18 years shows marked differences between countries and within countries. Much of the epidemiological literature has focused on diagnostic categories rather than population health.
AB  - DESIGN: The study employed a cross-sectional survey.
AB  - METHODS: A cross-sectional survey of 1786 school children aged 11-18 years was conducted in Scotland. Participants completed the strengths and difficulties questionnaire and the SF-10 for Children.
AB  - RESULTS: This group of school pupils had similar levels of mental health needs and psychosocial health status as UK and age-related US norms. They had poorer levels of physical health status. The most important predictors of psychosocial health status were difficulty category, impact, physical health status and chronicity. The most important predictors of impact were difficulty category, chronicity and psychosocial health status.
AB  - CONCLUSION: There is a need to tackle psychosocial health problems in schools. Problems are often chronic in nature and whilst still having an impact on the life of pupils may not be severe enough for a diagnosis which would trigger treatment in the conventional sense. Psychosocial health is predicted by physical health therefore nursing interventions which are focussed on both physical and psychosocial health may be needed.
AB  - RELEVANCE TO CLINICAL PRACTICE: This study suggests that in some geographical areas in UK targeting of services to 'high-need' schools is not necessary and universal services are required. Problems need to be detected before they reach current treatment thresholds. Interventions should be school-based with a focus on impact on classroom learning and family difficulties.

 Copyright © 2009 The Authors. Journal compilation © 2009 Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2010
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med8&AN=19374700
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19374700&id=doi:10.1111%2Fj.1365-2702.2008.02653.x&issn=0962-1067&isbn=&volume=19&issue=13-14&spage=1821&pages=1821-9&date=2010&title=Journal+of+Clinical+Nursing&atitle=Psychosocial+health+and+health-related+quality+of+life+in+school+pupils+11-18+years.&aulast=Lauder&pid=%3Cauthor%3ELauder+W%3C%2Fauthor%3E%3CAN%3E19374700%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<264. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19051661
TI  - Detection of adverse events in a Scottish hospital using a consensus-based methodology.
SO  - Scottish Medical Journal. 53(4):26-30, 2008 Nov.
VI  - 1
ST  - MEDLINE
AU  - Williams DJ
AU  - Olsen S
AU  - Crichton W
AU  - Witte K
AU  - Flin R
AU  - Ingram J
AU  - Campbell MK
AU  - Watson M
AU  - Hopf Y
AU  - Cuthbertson BH
FA  - Williams, D J
FA  - Olsen, S
FA  - Crichton, W
FA  - Witte, K
FA  - Flin, R
FA  - Ingram, J
FA  - Campbell, M K
FA  - Watson, M
FA  - Hopf, Y
FA  - Cuthbertson, B H
IN  - Williams, D J. Department of Clinical Pharmacology, Ward 12, Aberdeen Royal Infirmary, Foresterhill, Aberdeen AB25 2ZN. davidwilliams4@nhs.net
AB  - OBJECTIVE: To determine, using a consensus based methodology, the rate and nature of adverse events (AEs) among patients admitted to acute medicine, acute surgery and obstetrics in a large teaching hospital in Scotland.
AB  - METHODS: Retrospective case-note review of 450 medical, nursing and medication records to identify and classify adverse events. For 354 patients whose length of stay was greater than 24 hours, the overall adverse event rate was 7.9% which ranged from 0% in obstetrics, 7.2% in acute medicine to 13% in acute surgery. Among all AEs, 43% were deemed preventable by a consensus group and 59% of the AEs contributed to a proportion of the patients' hospital stay or led to hospital readmission. Whilst nurse identification of adverse events was highly specific (94%), its sensitivity was poor (43%). Only 10% of the identified AEs were identified by the hospital's voluntary reporting system for adverse events. The estimated additional cost of adverse events in terms of bed days was l69,189 which if extrapolated Scotland-wide could cost l297 million per annum.
AB  - CONCLUSIONS: This study supports the need to continue the traditional retrospective record review to identify adverse events. The current hospital-based reporting of adverse events does not provide a complete measure of adverse events and needs to be complemented by other measures.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19051661
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19051661&id=doi:10.1258%2FRSMSMJ.53.4.26&issn=0036-9330&isbn=&volume=53&issue=4&spage=26&pages=26-30&date=2008&title=Scottish+Medical+Journal&atitle=Detection+of+adverse+events+in+a+Scottish+hospital+using+a+consensus-based+methodology.&aulast=Williams&pid=%3Cauthor%3EWilliams+DJ%3C%2Fauthor%3E%3CAN%3E19051661%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<265. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 20034279
TI  - Indiscriminate coagulation screening of acute medical admissions: national cost ramifications.
SO  - Scottish Medical Journal. 54(4):32-4, 2009 Nov.
VI  - 1
ST  - MEDLINE
AU  - Hughes MA
AU  - Duckworth AD
AU  - Edmond I
AU  - Tan LL
AU  - Ripley DP
AU  - Tucker J
AU  - Leslie PJ
FA  - Hughes, M A
FA  - Duckworth, A D
FA  - Edmond, I
FA  - Tan, L L
FA  - Ripley, D P
FA  - Tucker, J
FA  - Leslie, P J
IN  - Hughes, M A. Foundation House Officers, Borders General Hospital, Melrose, Roxburghshire, UK. hughes81@gmail.com
AB  - BACKGROUND: Routine coagulation screening constitutes poor medical practice and is wasteful of resources. We aimed to determine the extent of inappropriate coagulopathy screening of acute medical admissions in a Scottish general hospital.
AB  - METHODS: One hundred consecutive medical admissions were prospectively analysed, assessing whether or not a coagulation screen had been conducted on admission and whether or not this was indicated according to current hospital guidelines. Following targeted dissemination of guidelines to appropriate front door medical and nursing staff the audit was repeated.
AB  - RESULTS: Pre-education, 58% of those for whom coagulation screening was not indicated were being tested. After targeted education, this figure was reduced to 32%. Preeducation, 81% of all patients in whom coagulation screening was indicated were tested. After targeted education, this figure was 86%.
AB  - CONCLUSION: Indiscriminate coagulation screening is widespread amongst medical admissions to our unit. With simple targeted education, we reduced the rate of inappropriate testing by 26% without reducing the rate of appropriate testing. In a small district general hospital (where the mean local cost for processing a haematology specimen is 8.59 pounds) this translates into a saving of 21,000 pounds per annum. Extrapolated nationwide this represents a cost saving of 1.15 million pounds per annum in Scotland.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=20034279
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:20034279&id=doi:10.1258%2Frsmsmj.54.4.32&issn=0036-9330&isbn=&volume=54&issue=4&spage=32&pages=32-4&date=2009&title=Scottish+Medical+Journal&atitle=Indiscriminate+coagulation+screening+of+acute+medical+admissions%3A+national+cost+ramifications.&aulast=Hughes&pid=%3Cauthor%3EHughes+MA%3C%2Fauthor%3E%3CAN%3E20034279%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<266. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19947960
TI  - From the old to the new: is forensic mental health nursing in transition?.
SO  - Journal of Forensic Nursing. 5(4):212-9, 2009.
VI  - 1
ST  - MEDLINE
AU  - Gillespie M
AU  - Flowers P
FA  - Gillespie, Mark
FA  - Flowers, Paul
IN  - Gillespie, Mark. University of the West of Scotland, School of Health Studies, Caird Park Hamilton, United Kingdom. mark.gillespie2@uws.ac.uk
AB  - This study adopts a qualitative research strategy (Interpretative Phenomenological Analysis) to explore in-depth the lived experience of six forensic mental health nurses working within Scotland. This paper examines one of the core themes uncovered through analyzing the transcripts, "From the Old to the New." This theme, it is suggested, reflects these nurses' experience as they move from the previously accepted culture and practice of forensic nursing to a new "humanistic" and "interpersonal" perspective.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19947960
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19947960&id=doi:10.1111%2Fj.1939-3938.2009.01056.x&issn=1556-3693&isbn=&volume=5&issue=4&spage=212&pages=212-9&date=2009&title=Journal+of+Forensic+Nursing&atitle=From+the+old+to+the+new%3A+is+forensic+mental+health+nursing+in+transition%3F.&aulast=Gillespie&pid=%3Cauthor%3EGillespie+M%3C%2Fauthor%3E%3CAN%3E19947960%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<267. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19850797
TI  - Introduction of the Liverpool Care Pathway for end of life care to emergency medicine.
SO  - Emergency Medicine Journal. 26(11):777-9, 2009 Nov.
VI  - 1
ST  - MEDLINE
AU  - Paterson BC
AU  - Duncan R
AU  - Conway R
AU  - Paterson FM
AU  - Napier P
AU  - Raitt M
FA  - Paterson, B C
FA  - Duncan, R
FA  - Conway, R
FA  - Paterson, F M
FA  - Napier, P
FA  - Raitt, M
IN  - Paterson, B C. Emergency Medicine Department, Ninewells Hospital, Dundee DD1 9SY, UK. brodie.paterson@nhs.net
AB  - AIM: To improve the care of patients presenting to the emergency department who are acutely dying or those in whom further disease-modifying treatment is not appropriate.
AB  - DESIGN: A quality improvement report on the implementation of a modified Liverpool Care Pathway for the Dying Patient (LCP) in an emergency medicine department.
AB  - SETTING: The emergency medicine department of Ninewells Hospital, Dundee. Ninewells Hospital is the tertiary referral and teaching hospital for the east coast of Scotland and North East Fife.
AB  - KEY MEASURES FOR IMPROVEMENT: The pathway was introduced after a 2001 study and a 2003 audit showed that the department had an increasing role in the care of the acutely dying, but some inconsistency in approach. Key measures for improvement were to improve communication between staff, improve the consistency of care and improve the perceived quality of care given. Senior decision making remains a crucial element of the pathway.
AB  - STRATEGIES FOR CHANGE: A modified LCP was developed and launched in November 2005. Change was managed via a series of meetings and a pilot process. Serial review and audit allowed ongoing quality review of the pathway and improvements.
AB  - RESULTS: The care of the dying patient has become a more consistent and positive endeavour. Nursing staff are very satisfied with its use, and it is hoped that the LCP pathway can be developed further within the organisation.
AB  - CONCLUSIONS: It has been a rewarding undertaking to improve the care of dying patients, but one which has taken time and has required consistent management of change to promote the positive outcomes.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19850797
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19850797&id=doi:10.1136%2Femj.2008.067249&issn=1472-0205&isbn=&volume=26&issue=11&spage=777&pages=777-9&date=2009&title=Emergency+Medicine+Journal&atitle=Introduction+of+the+Liverpool+Care+Pathway+for+end+of+life+care+to+emergency+medicine.&aulast=Paterson&pid=%3Cauthor%3EPaterson+BC%3C%2Fauthor%3E%3CAN%3E19850797%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<268. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19716617
TI  - Health Visiting--the end of a UK wide service?. [Review] [71 refs]
SO  - Health Policy. 93(2-3):93-101, 2009 Dec.
VI  - 1
ST  - MEDLINE
AU  - Hoskins RA
FA  - Hoskins, Robert Alan James
IN  - Hoskins, Robert Alan James. Nursing & Health Care, Medical Faculty, University of Glasgow, 59 Oakfield Avenue, Hillhead, Glasgow Scotland G12 8LL, United Kingdom. rh18e@clinmed.gla.ac.uk
AB  - In 1997 Health Visiting was deemed by New Labour to be an important player in reducing health inequalities. It was acknowledged that if Health Visiting was to fulfill this vision it would have to work out with its traditional child health role and also engage with groups, communities and populations to tackle the determinants of ill health. Twelve years on, external factors such as, NHS cut backs, recent changes to how Health Visitors are regulated throughout the UK and devolved Health Visiting policy making structures have led to the rapid demise in status and legitimacy of Health Visiting and its wider public health role. This article argues that the unintended consequences of devolved Health Visiting policy has resulted in 3 recent community nursing and health-visiting reviews in Scotland and England which have made divergent policy recommendations about the role of the Health Visitor in tackling health inequalities. The recommendations outlined in the Scottish review in particular threatened to jeopardise the very future provision of a UK wide Health Visiting service. If Health Visiting is to survive as a UK wide entity, a radical independent rethink as to its future direction and its public health role is urgently required. [References: 71]
PT  - Journal Article
PT  - Review
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19716617
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19716617&id=doi:10.1016%2Fj.healthpol.2009.08.001&issn=0168-8510&isbn=&volume=93&issue=2-3&spage=93&pages=93-101&date=2009&title=Health+Policy&atitle=Health+Visiting--the+end+of+a+UK+wide+service%3F.&aulast=Hoskins&pid=%3Cauthor%3EHoskins+RA%3C%2Fauthor%3E%3CAN%3E19716617%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<269. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19592916
TI  - Validation of the Impact of Health Information Technology (I-HIT) Scale: an international collaborative.
SO  - Studies in Health Technology & Informatics. 146:618-22, 2009.
VI  - 1
ST  - MEDLINE
AU  - Dykes PC
AU  - Hurley AC
AU  - Brown S
AU  - Carr R
AU  - Cashen M
AU  - Collins R
AU  - Cook R
AU  - Currie L
AU  - Docherty C
AU  - Ensio A
AU  - Foster J
AU  - Hardiker NR
AU  - Honey ML
AU  - Killalea R
AU  - Murphy J
AU  - Saranto K
AU  - Sensmeier J
AU  - Weaver C
FA  - Dykes, Patricia C
FA  - Hurley, Ann C
FA  - Brown, Suzanne
FA  - Carr, Robyn
FA  - Cashen, Margaret
FA  - Collins, Rita
FA  - Cook, Robyn
FA  - Currie, Leanne
FA  - Docherty, Charles
FA  - Ensio, Anneli
FA  - Foster, Joanne
FA  - Hardiker, Nicholas R
FA  - Honey, Michelle L L
FA  - Killalea, Rosaleen
FA  - Murphy, Judy
FA  - Saranto, Kaija
FA  - Sensmeier, Joyce
FA  - Weaver, Charlotte
IN  - Dykes, Patricia C. Brigham and Women's Hospital/Harvard Medical School, Boston, MA, USA. pdykes@partners.org
AB  - In 2005, the Healthcare Information Management Systems Society (HIMSS) Nursing Informatics Community developed a survey to measure the impact of health information technology (HIT), the I-HIT Scale, on the role of nurses and interdisciplinary communication in hospital settings. In 2007, nursing informatics colleagues from Australia, England, Finland, Ireland, New Zealand, Scotland and the United States formed a research collaborative to validate the I-HIT across countries. All teams have completed construct and face validation in their countries. Five out of six teams have initiated reliability testing by practicing nurses. This paper reports the international collaborative's validation of the I-HIT Scale completed to date.
PT  - Journal Article
PT  - Validation Study
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19592916
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19592916&id=doi:&issn=0926-9630&isbn=&volume=146&issue=&spage=618&pages=618-22&date=2009&title=Studies+in+Health+Technology+%26+Informatics&atitle=Validation+of+the+Impact+of+Health+Information+Technology+%28I-HIT%29+Scale%3A+an+international+collaborative.&aulast=Dykes&pid=%3Cauthor%3EDykes+PC%3C%2Fauthor%3E%3CAN%3E19592916%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<270. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19592874
TI  - The impact of Health Information Technology (I-HIT) Scale: the Australian results.
SO  - Studies in Health Technology & Informatics. 146:400-4, 2009.
VI  - 1
ST  - MEDLINE
AU  - Cook R
AU  - Foster J
FA  - Cook, Robyn
FA  - Foster, Joanne
IN  - Cook, Robyn. University of Technology, Sydney, Australia. tcook@bigpond.com
AB  - One of role of the nurse in the clinical setting is that of co-ordinating communication across the healthcare team. On a daily basis nurses interact with the person receiving care, their family members, and multiple care providers thus placing the nurse in the central position with access to a vast array of information on the person. Through this nurses have historically functioned as "information repositories". With the advent of Health Information Technology (HIT) tools there is a potential that HIT could impact interdisciplinary communication, practice efficiency and effectiveness, relationships and workflow in acute care settings [1][3]. In 2005, the HIMSS Nursing Informatics Community developed the I-HIT Scale to measure the impact of HIT on the nursing role and interdisciplinary communication in USA hospitals. In 2007, nursing informatics colleagues from Australia, Finland, Ireland, New Zealand, Scotland and the USA formed a research collaborative to validate the I-HIT in six additional countries. This paper will discuss the background, methodology, results and implications from the Australian I-HIT survey of over 1,100 nurses. The results are currently being analyzed and will be presented at the conference.
PT  - Journal Article
PT  - Validation Study
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19592874
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19592874&id=doi:&issn=0926-9630&isbn=&volume=146&issue=&spage=400&pages=400-4&date=2009&title=Studies+in+Health+Technology+%26+Informatics&atitle=The+impact+of+Health+Information+Technology+%28I-HIT%29+Scale%3A+the+Australian+results.&aulast=Cook&pid=%3Cauthor%3ECook+R%3C%2Fauthor%3E%3CAN%3E19592874%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<271. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19552044
TI  - Improving services for people with alcohol-related problems.
SO  - Nursing Standard. 23(38):35-40, 2009 May 27-Jun 2.
VI  - 1
ST  - MEDLINE
AU  - Mason C
FA  - Mason, Carolyn
IN  - Mason, Carolyn. Royal College of Nursing Northern Ireland, Belfast. carolyn.mason@rcn.org.uk
AB  - From March 2007 to April 2008 the Royal College of Nursing supported a project to improve services for people with alcohol-related problems by demonstrating and publicising the effectiveness of nursing interventions. The project team included representation from England, Northern Ireland, Wales and Scotland. This article presents a framework that can be adapted and used by nurses to promote the development of specialist nursing services by health and social care commissioners and policy makers to improve care for people who misuse alcohol.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19552044
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19552044&id=doi:10.7748%2Fns2009.05.23.38.35.c6974&issn=0029-6570&isbn=&volume=23&issue=38&spage=35&pages=35-40&date=2009&title=Nursing+Standard&atitle=Improving+services+for+people+with+alcohol-related+problems.&aulast=Mason&pid=%3Cauthor%3EMason+C%3C%2Fauthor%3E%3CAN%3E19552044%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<272. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19516228
TI  - Modernizing community nursing services in Scotland.
SO  - British Journal of Community Nursing. 14(6):249-50, 2009 Jun.
VI  - 1
ST  - MEDLINE
AU  - Kennedy C
FA  - Kennedy, Catriona
IN  - Kennedy, Catriona. Edinburgh Napier University. c.kennedy@napier.ac.uk
AB  - Scotland is in the midst of a major review of community nursing which began in 2006. The Scottish Executive, as part of the modernisation of the National Health Service, began a radical and far reaching review of nursing in the community. What transpires in Scotland over the next few years has the potential to contribute to the global debate about how community nursing may be developed to meet the needs of people and communities.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19516228
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19516228&id=doi:10.12968%2Fbjcn.2009.14.6.42591&issn=1462-4753&isbn=&volume=14&issue=6&spage=249&pages=249-50&date=2009&title=British+Journal+of+Community+Nursing&atitle=Modernizing+community+nursing+services+in+Scotland.&aulast=Kennedy&pid=%3Cauthor%3EKennedy+C%3C%2Fauthor%3E%3CAN%3E19516228%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<273. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19428158
TI  - The preparation of child health nurses in sexual health education: an exploratory study.
SO  - Nurse Education Today. 29(8):845-9, 2009 Nov.
VI  - 1
ST  - MEDLINE
AU  - Johnston JH
FA  - Johnston, Jacqueline H
IN  - Johnston, Jacqueline H. Edinburgh Napier University, School of Nursing, Midwifery and Social Care, Edinburgh EH4 2LD, UK. j.johnston@napier.ac.uk
AB  - There are very high rates of pregnancy and sexually transmitted infections in the teenage population in Scotland. The Scottish Government recommends that child health nurses working alongside education professionals should be addressing these issues. The aim of this study was to explore the nature, type and experience of educational provision student nurses gain during their undergraduate programme to help them deal effectively with the sexual health needs of children and young people with whom they are involved. Thirteen students from two third year cohorts of a child health pre-registration nursing programme took part in this qualitative, phenomenological study. Focus groups (n=2) were undertaken to gather data and to develop emerging themes. Four themes are reported: "greater knowledge and expectations" "variation in practice affects the variety of experience" "sexual health should be part of the role" and "need to be better prepared". The students reported on their previous experiences of sex education and about differences in practice whilst out on a variety of placements. Most of the students believed that delivering sexual health education to young people was the nurse's role however there appeared to be a consensus that they did not have sufficient knowledge of sexual health to achieve this.
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19428158
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19428158&id=doi:10.1016%2Fj.nedt.2009.03.011&issn=0260-6917&isbn=&volume=29&issue=8&spage=845&pages=845-9&date=2009&title=Nurse+Education+Today&atitle=The+preparation+of+child+health+nurses+in+sexual+health+education%3A+an+exploratory+study.&aulast=Johnston&pid=%3Cauthor%3EJohnston+JH%3C%2Fauthor%3E%3CAN%3E19428158%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<274. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19383053
TI  - Stroke nursing in Scotland. [Review] [10 refs]
SO  - International Journal of Stroke. 4(2):124-6, 2009 Apr.
VI  - 1
ST  - MEDLINE
AU  - Campbell L
AU  - MacRae J
FA  - Campbell, Linda
FA  - MacRae, Janet
IN  - Campbell, Linda. Stroke Unit, Raigmore Hospital, Inverness, UK. linda.campbell8@nhs.net
PT  - Journal Article
PT  - Review
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19383053
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19383053&id=doi:10.1111%2Fj.1747-4949.2009.00264.x&issn=1747-4930&isbn=&volume=4&issue=2&spage=124&pages=124-6&date=2009&title=International+Journal+of+Stroke&atitle=Stroke+nursing+in+Scotland.&aulast=Campbell&pid=%3Cauthor%3ECampbell+L%3C%2Fauthor%3E%3CAN%3E19383053%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<275. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19373181
TI  - Who should teach clinical skills to nursing students?. [Review] [24 refs]
SO  - British Journal of Nursing. 18(7):395-8, 2009 Apr 9-22.
VI  - 1
ST  - MEDLINE
AU  - Mackenzie KM
FA  - Mackenzie, Katherine M
IN  - Mackenzie, Katherine M. Department of Nursing and Midwifery, University of Stirling.
AB  - Nurse education has traditionally relied on clinical placements to provide nursing students with the 'hands-on' experience that is not possible to teach in a classroom setting. However, with changes to the NHS this is becoming increasingly difficult, with fewer resources available and issues of patient safety to consider. Hennman and Cunningham (2005) recognize there is a significant gulf between the theoretical component taught in the classroom and the complex realities of clinical practice. Cave (2005) has suggested the move into higher education has hindered rather than helped the linking of theory and practice in nurse education, because many nurse teachers are far removed from clinical practice and therefore no longer competent or clinically credible to be able to teach up-to-date clinical skills. In Scotland the Practice Education Facilitators role in integrating theory with practice is essential for both the NHS Trusts and higher education institutes. It would appear that these clinicians are the lynchpin between linking university work with the harsh realities of daily practice. If nurse education is to provide effective clinical skill simulation then it must also provide effective teachers who are up to date with current practice. In many cases this will not be the nurse teacher. [References: 24]
PT  - Journal Article
PT  - Review
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19373181
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19373181&id=doi:10.12968%2Fbjon.2009.18.7.41651&issn=0966-0461&isbn=&volume=18&issue=7&spage=395&pages=395-8&date=2009&title=British+Journal+of+Nursing&atitle=Who+should+teach+clinical+skills+to+nursing+students%3F.&aulast=Mackenzie&pid=%3Cauthor%3EMackenzie+KM%3C%2Fauthor%3E%3CAN%3E19373181%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<276. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19363867
TI  - Policy analysis: report of the review of community nursing in Scotland.
SO  - British Journal of Community Nursing. 14(1):30-4, 2009 Jan.
VI  - 1
ST  - MEDLINE
AU  - McAskill H
FA  - McAskill, Heather
IN  - McAskill, Heather. Robert Gordon University, Aberdeen. h.mcaskill@rgu.ac.uk
AB  - Policy making is a very complex area to those that are not directly involved in it, however it is essential that nurses understand the process, how it impacts on professional practice, and have the ability to analyse relevant policies. The aim of this paper is to encourage nurses to undertake a policy analysis by providing a 'real' example while examining research utilization and policy-making theory. A six stage approach developed from Benton and Cormack's (2000) framework to review literature is used to analyse the policy, Visible, Accessible and Integrated Care--a report of the review of community nursing in Scotland (Scottish Executive, 2006a).
PT  - Journal Article
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19363867
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19363867&id=doi:10.12968%2Fbjcn.2009.14.1.37523&issn=1462-4753&isbn=&volume=14&issue=1&spage=30&pages=30-4&date=2009&title=British+Journal+of+Community+Nursing&atitle=Policy+analysis%3A+report+of+the+review+of+community+nursing+in+Scotland.&aulast=McAskill&pid=%3Cauthor%3EMcAskill+H%3C%2Fauthor%3E%3CAN%3E19363867%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<277. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19358991
TI  - Working patterns and perceived contribution of prostate cancer clinical nurse specialists: a mixed method investigation.
SO  - International Journal of Nursing Studies. 46(10):1345-54, 2009 Oct.
VI  - 1
ST  - MEDLINE
AU  - Ream E
AU  - Wilson-Barnett J
AU  - Faithfull S
AU  - Fincham L
AU  - Khoo V
AU  - Richardson A
FA  - Ream, Emma
FA  - Wilson-Barnett, Jenifer
FA  - Faithfull, Sara
FA  - Fincham, Lorraine
FA  - Khoo, Vincent
FA  - Richardson, Alison
IN  - Ream, Emma. King's College London, United Kingdom. emma.ream@kcl.ac.uk
AB  - BACKGROUND: Prostate cancer is prevalent worldwide. In England, men living with this malignancy often report unmet psychological, informational, urological and sexual needs. Their experience of care is correspondingly lower than that of other patient groups with cancer. To address this, prostate cancer clinical nurse specialist posts were established across England and Scotland. Their intent was to support men with this form of cancer, enhance symptom management and improve quality of service provision.
AB  - OBJECTIVES: The research sought to investigate prostate cancer clinical nurse specialists' roles, determine whom they targeted services at, and determine their work practices and perceived contribution.
AB  - DESIGN: A mixed method multi-site exploratory-descriptive design was employed.
AB  - SETTINGS: Data were collected across four acute NHS Trusts-one in the South of England, one in the Midlands, one in Northern England and one in Scotland, respectively.
AB  - PARTICIPANTS: Participants included 4 prostate cancer clinical nurse specialists, 19 of their clinical colleagues and 40 men they provided care to.
AB  - METHODS: Data were collected through nurse specialists' completion of a Diary and Contact Sheets. Interviews were conducted concurrently with the nurses, stakeholders they worked alongside and patients on their caseload. Data were collected between November 2004 and January 2006.
AB  - RESULTS: There was great variation in the qualifications and experience of nurse specialists and in the services they provided. Services ranged from generic support and information provided across the disease trajectory to provision of services to meet specific care needs, e.g. providing nurse-led clinics for erectile dysfunction. Patients and members of the multidisciplinary team welcomed the introduction of nurse specialists but were aware they could become over burdened through their rapidly growing caseloads.
AB  - CONCLUSIONS: Variability in services provided by the prostate cancer nurse specialists arose from differences in local demand for nursing services and the skills and experiences of those appointed. Such variability - whilst understandable - has implications for access and equity across patient groups. Further, it can compromise efforts to define clinical nurse specialists' contribution to care, can impede others' expectation of their role, and render their outcomes difficult to evaluate.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19358991
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19358991&id=doi:10.1016%2Fj.ijnurstu.2009.03.006&issn=0020-7489&isbn=&volume=46&issue=10&spage=1345&pages=1345-54&date=2009&title=International+Journal+of+Nursing+Studies&atitle=Working+patterns+and+perceived+contribution+of+prostate+cancer+clinical+nurse+specialists%3A+a+mixed+method+investigation.&aulast=Ream&pid=%3Cauthor%3EReam+E%3C%2Fauthor%3E%3CAN%3E19358991%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<278. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19345449
TI  - Practice-based learning: the role of practice education facilitators in supporting mentors.
SO  - Nurse Education Today. 29(7):715-21, 2009 Oct.
VI  - 1
ST  - MEDLINE
AU  - Carlisle C
AU  - Calman L
AU  - Ibbotson T
FA  - Carlisle, Caroline
FA  - Calman, Lynn
FA  - Ibbotson, Tracy
IN  - Carlisle, Caroline. School of Nursing, Midwifery and Social Work, Room 5.323 University Place, The University of Manchester, Oxford Road, Manchester M13 9PL, United Kingdom. caroline.carlisle@manchester.ac.uk
AB  - Central to the provision of high quality clinical placements for nursing and midwifery students are mentors who help engender a positive learning environment. In 2004 the Scottish Executive Health Department (now Scottish Government Health Directorates), NHS Scotland, NHS Education for Scotland, NHS Boards and Higher Education Institutions initiated and supported the establishment of the Practice Education Facilitator (PEF) role whose purpose is to ensure that the student experience, at both pre- and post-registration level, is of the highest quality, primarily through the support of mentors. A 3-year project evaluated the implementation and impact of the PEF role across Scotland. The study utilised both quantitative and qualitative data collection, with a sample comprising mentors, PEFs, students and other key stakeholders. This paper reports on selected findings from that study, specifically the perceived impact of the PEF in supporting mentors. Findings indicate that the PEF role has been accepted widely across Scotland and is seen as valuable to the development of quality clinical learning environments. PEFs provide support and guidance for mentors when dealing with 'failing' students, and encourage the identification of innovative learning opportunities. PEFs play an active part in student evaluation of their placements, but further work is needed in order that the feedback to clinical areas and mentors is timely.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19345449
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19345449&id=doi:10.1016%2Fj.nedt.2009.02.018&issn=0260-6917&isbn=&volume=29&issue=7&spage=715&pages=715-21&date=2009&title=Nurse+Education+Today&atitle=Practice-based+learning%3A+the+role+of+practice+education+facilitators+in+supporting+mentors.&aulast=Carlisle&pid=%3Cauthor%3ECarlisle+C%3C%2Fauthor%3E%3CAN%3E19345449%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<279. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19321240
TI  - The practice-based small group learning approach: making evidence-based practice come alive for learners.
SO  - Nurse Education Today. 29(6):671-5, 2009 Aug.
VI  - 1
ST  - MEDLINE
AU  - Overton GK
AU  - Kelly D
AU  - McCalister P
AU  - Jones J
AU  - MacVicar R
FA  - Overton, Githa K
FA  - Kelly, Diane
FA  - McCalister, Peter
FA  - Jones, Jane
FA  - MacVicar, Ronald
IN  - Overton, Githa K. University of Dundee, NHS Education for Scotland, 8 Auchterhouse Park, Angus, Scotland, UK.
AB  - This paper reports the study of a pilot learning programme for the Continuing Professional Development of Practice Nurses (PNs) in Scotland. Two PN groups used the practice-based small group (PBSG) approach to learning, which is designed to encourage learning relevant to patient problems faced in day-to-day practice. Learners kept a log of their experiences of engaging in PBSG learning for three consecutive meetings. Data was also collected through interviews. The findings detail the motivation for joining the PBSGs, group dynamics and the development of cohesion, factors influencing participation in group-discussions and the nature of learning that took place in the groups. PNs from both groups reported that discussions led to habitual practices being challenged but without hostility, and that various sources of information were considered. The suitability of PBSG learning to promote evidence-based nursing practice is discussed.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19321240
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19321240&id=doi:10.1016%2Fj.nedt.2009.02.009&issn=0260-6917&isbn=&volume=29&issue=6&spage=671&pages=671-5&date=2009&title=Nurse+Education+Today&atitle=The+practice-based+small+group+learning+approach%3A+making+evidence-based+practice+come+alive+for+learners.&aulast=Overton&pid=%3Cauthor%3EOverton+GK%3C%2Fauthor%3E%3CAN%3E19321240%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<280. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19200275
TI  - Comparison of nephrology nursing interventions across five European countries.
SO  - Journal of Renal Care. 35(1):24-32, 2009 Mar.
VI  - 1
ST  - MEDLINE
AU  - Zampieron A
AU  - Ormandy P
AU  - Elseviers M
AU  - De Vos JY
AU  - Kafkia T
FA  - Zampieron, Alessandra
FA  - Ormandy, Paula
FA  - Elseviers, Monique
FA  - De Vos, Jean Yves
FA  - Kafkia, Theodora
IN  - Zampieron, Alessandra. Corso di Laurea in Infermieristica Padova, Universita di Padova, Italy. zampieron@lycos.com
AB  - Comparing nursing interventions between different countries is helpful towards developing a common nursing culture within Europe. The aim of the study was to compare the frequency of 14 specific nursing interventions indicators across five European countries (Belgium, Scotland, Czech Republic, Greece and the North of England). Data were collected as an integral part of the European Practice Database Project across two cycles (2005 and 2006) involving 172 renal centres. Using Pearson's chi-square and descriptive statistics the frequency of 11 out of the 14 nurse intervention indicators was found to vary significantly across the five countries. Indeed specific nurse interventions such as delegation, telephone consultations and laboratory data interpretation potentially identify where nurse activity is changing in response to pressures such as advancing nurse roles, staff shortages and increased patient demand.
PT  - Comparative Study
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19200275
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19200275&id=doi:10.1111%2Fj.1755-6686.2009.00076.x&issn=1755-6678&isbn=&volume=35&issue=1&spage=24&pages=24-32&date=2009&title=Journal+of+Renal+Care&atitle=Comparison+of+nephrology+nursing+interventions+across+five+European+countries.&aulast=Zampieron&pid=%3Cauthor%3EZampieron+A%3C%2Fauthor%3E%3CAN%3E19200275%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<281. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19120753
TI  - A longitudinal study of stress and psychological distress in nurses and nursing students.
SO  - Journal of Clinical Nursing. 18(2):270-8, 2009 Jan.
VI  - 1
ST  - MEDLINE
AU  - Watson R
AU  - Gardiner E
AU  - Hogston R
AU  - Gibson H
AU  - Stimpson A
AU  - Wrate R
AU  - Deary I
FA  - Watson, Roger
FA  - Gardiner, Eric
FA  - Hogston, Richard
FA  - Gibson, Helen
FA  - Stimpson, Anne
FA  - Wrate, Robert
FA  - Deary, Ian
IN  - Watson, Roger. School of Nursing and Midwifery, The University of Sheffield, Sheffield, UK.
AB  - AIM: The aim of this study was to investigate how differences in life events and stress contribute to psychological distress in nurses and nursing students.
AB  - BACKGROUND: Stress is an issue for nursing students and qualified nurses leading to psychological distress and attrition.
AB  - DESIGN: A longitudinal study using four time waves was conducted between 1994-1997.
AB  - METHODS: Measures were taken of stress, life events and psychological distress in addition to a range of demographic data. Data were analysed using descriptive statistics, linear modelling and mixed-effects modelling. The study was set in Scotland, UK and used newly qualified nurses and nursing students from four university departments of nursing over four years. The study was initiated with 359 participants (147 nurses and 212 nursing students) and complete data were obtained for 192 participants.
AB  - RESULTS: Stress levels, psychological distress and life events are all associated within time and across time. At baseline, life events and stress contributed significantly to psychological distress. The pattern of psychological distress differed between the nursing students and the newly qualified nurses with a high level in the nurses after qualifying and starting their career.
AB  - CONCLUSION: Stress, individual traits, adverse life events and psychological distress are all interrelated. Future lines of enquiry should focus on the transition between being a nursing student and becoming a nurse.
AB  - RELEVANCE TO CLINICAL PRACTICE: Stress and psychological distress may have negative outcomes for the retention of nursing students in programmes of study and newly qualified nurses in the nursing workforce.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19120753
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19120753&id=doi:10.1111%2Fj.1365-2702.2008.02555.x&issn=0962-1067&isbn=&volume=18&issue=2&spage=270&pages=270-8&date=2009&title=Journal+of+Clinical+Nursing&atitle=A+longitudinal+study+of+stress+and+psychological+distress+in+nurses+and+nursing+students.&aulast=Watson&pid=%3Cauthor%3EWatson+R%3C%2Fauthor%3E%3CAN%3E19120753%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<282. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19120750
TI  - Leadership as part of the nurse consultant role: banging the drum for patient care.
SO  - Journal of Clinical Nursing. 18(2):219-27, 2009 Jan.
VI  - 1
ST  - MEDLINE
AU  - McIntosh J
AU  - Tolson D
FA  - McIntosh, Jean
FA  - Tolson, Debbie
IN  - McIntosh, Jean. School of Nursing, Midwifery & Community Health, Glasgow Caledonian University, Cowcaddens Road, Glasgow, UK. J.McIntosh@gcal.ac.uk
CM  - Comment in (CIN)
AB  - AIMS AND OBJECTIVES: This paper draws upon an evaluation of the first group of nurse consultants in Scotland. The evaluation aimed to identify the extent to which they fulfilled the remit of their posts which comprised four core functions. One of these functions was to provide professional leadership and this paper focuses on this element of the role and aims to explore it in relation to the attributes of transformational leadership.
AB  - BACKGROUND: Nurse consultants were introduced in the UK in 2000. Their purpose was to achieve better outcomes for patients and strengthen leadership. Nursing research identifies leadership as a key element of the role, with postholders adopting transformational leadership approaches. Research from the fields of sociology and psychology identifies difficulties in formulating a coherent theory of leadership, arguing for better understanding of leadership processes.
AB  - DESIGN: Qualitative.
AB  - METHODS: This paper draws on 31 semi-structured interviews with four nurse consultants who were interviewed twice over six to nine months and 23 other 'stakeholders' who worked with them.
AB  - RESULTS: Varied leadership activity at ward, NHS Trust and strategic levels was identified. Postholders used approaches that resonated with the attributes of transformational leadership. Leadership processes included developing a vision for the service, acting as mediator and champion, and exerting control over complex change initiatives. Techniques of leadership included taking a 'softly softly' approach, pacing change initiatives and arguing assertively with those in senior positions. Interview findings also identified the level of preparation that was required to meet the remit of the posts, highlighting the importance of interpersonal skills and intellectual effort in achieving outcomes.
AB  - CONCLUSIONS: Nurse consultants require considerable technical expertise, cognitive and interpersonal skills, and the ability to take risks. The data suggest that the leadership attributes required are transformational in nature but that they also exceed those identified in much of the literature. These posts require appropriate support if they are to be sustainable. Relevance to clinical practice. This paper adds to our understanding of the complexity of the nurse consultant role and highlights the challenge of providing appropriate professional development for postholders.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19120750
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19120750&id=doi:10.1111%2Fj.1365-2702.2008.02520.x&issn=0962-1067&isbn=&volume=18&issue=2&spage=219&pages=219-27&date=2009&title=Journal+of+Clinical+Nursing&atitle=Leadership+as+part+of+the+nurse+consultant+role%3A+banging+the+drum+for+patient+care.&aulast=McIntosh&pid=%3Cauthor%3EMcIntosh+J%3C%2Fauthor%3E%3CAN%3E19120750%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<283. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18222574
TI  - Choice in maternity: rhetoric, reality and resistance.
SO  - Midwifery. 25(6):637-48, 2009 Dec.
VI  - 1
ST  - MEDLINE
AU  - Mander R
AU  - Melender HL
FA  - Mander, Rosemary
FA  - Melender, Hanna-Leena
IN  - Mander, Rosemary. School of Health in Social Science, University of Edinburgh, Teviot Place, Edinburgh EH8 9AG, Scotland, UK. R.Mander@ed.ac.uk
AB  - OBJECTIVE: to inform the organisation of the maternity services in Scotland, a phenomenological study was planned to examine maternity decision making in two similarly small countries. The aim was to examine the experience of contributing to decisions at clinical, organisational and policy-making levels. When examples were needed the informants were asked to use their experience of place of birth decisions.
AB  - DESIGN: a hermeneutic phenomenological approach was employed. In-depth, semi-structured conversations were used. The fieldwork extended over a 4-month period in 2005. The data were analysed using Colaizzi's method.
AB  - SETTING: Finland and New Zealand were chosen because the parallels in their health care and maternity care systems would limit disparities. In one of the Finnish centres, the findings were particularly homogeneous and exemplified many of the issues arising in other settings. The findings of the fieldwork in this Finnish centre are the focus of this paper.
AB  - PARTICIPANTS: the informants were mothers, midwife managers/policy makers, midwives and other maternity care providers. The findings of 12 conversations, including mothers and all groups of staff, are reported here.
AB  - FINDINGS: the background theme which emerged was 'trusting the system'. The informants were aware of the extent to which change is happening. One of the sub-themes contrasted the informants' perceptions of their lack of strength and courage with Finnish stereotypes. Being safe proved to be another crucial issue. The final sub-theme was 'playing the system'.
AB  - KEY CONCLUSIONS: trust in a well-respected health-care system was necessary for the informants to be able to subvert or resist that system. While such resistance has been documented in other disciplines, such as nursing, reference has not been found in relation to maternity. The resistance to the system was, at the time of the fieldwork, neither co-ordinated nor collaborative.
AB  - IMPLICATIONS FOR PRACTICE: the findings of this study carry important implications for women's and midwives' input into maternity care.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18222574
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18222574&id=doi:10.1016%2Fj.midw.2007.10.009&issn=0266-6138&isbn=&volume=25&issue=6&spage=637&pages=637-48&date=2009&title=Midwifery&atitle=Choice+in+maternity%3A+rhetoric%2C+reality+and+resistance.&aulast=Mander&pid=%3Cauthor%3EMander+R%3C%2Fauthor%3E%3CAN%3E18222574%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<284. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17962824
TI  - Goldmann tonometer calibration: a national survey.
SO  - Eye. 23(2):413-5, 2009 Feb.
VI  - 1
ST  - MEDLINE
AU  - Kumar N
AU  - Hillier RJ
FA  - Kumar, N
FA  - Hillier, R J
IN  - Kumar, N. Ophthalmology Department, Aintree University Hospitals NHS Foundation Trust, Walton Hospital, Liverpool, UK. nishant6377@gmail.com
AB  - INTRODUCTION: Recent studies suggest that Goldmann tonometers can rapidly develop calibration errors (CEs) in clinical use and routine checks are necessary to ensure accuracy.
AB  - PURPOSE: To determine current practice regarding CE checks in the United Kingdom and assess the views of senior nursing staff in charge of running ophthalmology outpatient clinics as to whom they feel to be responsible for CE checks.
AB  - METHODS: Every ophthalmology unit with training recognition in England, Northern Ireland, Scotland, and Wales was contacted. Senior nurses responded to a structured telephone questionnaire regarding local tonometer calibration practice and their views regarding who is responsible for CE checks. A total of 155 eye units were identified and contacted. The response rate was 100%.
AB  - RESULTS: CEs were checked for daily in 8 units (5.2%), weekly in 20 units (12.9%), fortnightly in 1 unit (0.6%), monthly in 12 units (7.7%), trimonthly in 5 units (3.2%), biannually in 27 units (17.4%), and annually in 21 units (13.5%). CEs were either never checked or checked in a very random manner (no identifiable pattern) in 61 units (39.4%). Sixty-three (40.6%) of the respondents felt CE checks were a departmental responsibility, 48 (31.0%) felt it to be the doctor's responsibility, and 44 (28.4%) felt CE checks should be performed by the nursing staff.
AB  - CONCLUSIONS: Our national survey suggests that very few units check their tonometers for CEs at intervals which ensure their accuracy. Our previous survey of doctors suggests that they believe nurses should check for CE, whereas the nursing staff believe CE checks are not their responsibility. This lack of communication between health-care professionals may lead to inaccurate tonometers being used in clinical practice. We suggest that every eye unit should have a protocol, which clearly identifies individuals responsible for checking for CEs at least on a monthly basis.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2009
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=17962824
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17962824&id=doi:10.1038%2Fsj.eye.6703010&issn=0950-222X&isbn=&volume=23&issue=2&spage=413&pages=413-5&date=2009&title=Eye&atitle=Goldmann+tonometer+calibration%3A+a+national+survey.&aulast=Kumar&pid=%3Cauthor%3EKumar+N%3C%2Fauthor%3E%3CAN%3E17962824%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<285. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19146511
TI  - Establishing the contribution of nursing in the community to the health of the people of Scotland: integrative literature review. [Review] [89 refs]
SO  - Journal of Advanced Nursing. 64(5):416-39, 2008 Dec.
VI  - 1
ST  - MEDLINE
AU  - Kennedy C
AU  - Christie J
AU  - Harbison J
AU  - Maxton F
AU  - Rutherford I
AU  - Moss D
FA  - Kennedy, Catriona
FA  - Christie, Jane
FA  - Harbison, Jean
FA  - Maxton, Fiona
FA  - Rutherford, Ishbel
FA  - Moss, Dawn
IN  - Kennedy, Catriona. Reader School of Nursing, Midwifery & Social Care, Napier University, Edinburgh, UK. c.kennedy@napier.ac.uk
AB  - AIM: This paper is a report of an integrative literature review to explore the evidence base for nursing in the community.
AB  - BACKGROUND: The Scottish Executive (2005) in Scotland (UK), announced that a review of nursing in the community should be undertaken to inform implementation of the policy Delivering for Health. This policy called for a fundamental shift in the focus of care away from acute hospitals into the community where health care in the future will be concentrated. To inform this review of nursing in the community, the Scottish Executive commissioned a literature review.
AB  - METHODS: An integrative literature review was carried out during 2006 (February to April). We carried out an extensive literature search using multiple electronic databases and hand-searched key texts to find suitable systematic reviews and primary quantitative and qualitative papers for review (1996-March 2006). We included English language publications describing systematic reviews and primary empirical research about community nurses' contributions to the health of people.
AB  - FINDINGS: Seventy-three papers (12 systematic reviews and 61 studies) met our inclusion criteria. All of the studies were scored as either 'low' or 'medium' quality. None merited a 'high' quality rating.
AB  - CONCLUSIONS: There is little research evaluating the impact of community nursing actions. Adequately resourced research is needed to strengthen the evidence base to support nurses in the community in delivering effective and efficient care that meet the health needs of people and communities. [References: 89]
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
PT  - Review
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19146511
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19146511&id=doi:10.1111%2Fj.1365-2648.2008.04621.x&issn=0309-2402&isbn=&volume=64&issue=5&spage=416&pages=416-39&date=2008&title=Journal+of+Advanced+Nursing&atitle=Establishing+the+contribution+of+nursing+in+the+community+to+the+health+of+the+people+of+Scotland%3A+integrative+literature+review.&aulast=Kennedy&pid=%3Cauthor%3EKennedy+C%3C%2Fauthor%3E%3CAN%3E19146511%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<286. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 19097383
TI  - ["Serbian mother from Scotland"--Dr. Elsie Inglis (1864-1917)]. [Serbian]
SO  - Medicinski Pregled. 61(7-8):419-26, 2008 Jul-Aug.
VI  - 1
ST  - MEDLINE
AU  - Mikic Z
FA  - Mikic, Zelimir
IN  - Mikic, Zelimir. Medicinski fakultet Novi Sad.
AB  - INTRODUCTION: 90 years ago, on November 26th, 1917, died Dr. Elsie Inglis, one of the greatest heroines of the First World War, founder and driving force of the famous "Scottish Women's Hospitals", and one of the most interesting persons in the history of medicine in general, and especially in Serbia where she and her hospitals were of the greatest help in the most difficult times.
AB  - CHILDHOOD AND EDUCATION: Elsie Maud Inglis was born in India in 1864, in a Scottish family which in 1878 moved back to Scotland where Elsie studied medicine and graduated from the Edinburgh University in 1899. Medical practice and Women's Movement (1894-1914) Dr. E. Inglis worked in Edinburgh, where in 1904. She opened a small hospital for women and children called "The Hospice", which was staffed only by women. She was also very active in the Women's Movement (the so-called suffragettes), fighting for the women's rights and for the Vote. From 1906 until 1914 she was Honorary Secretary of the Scottish Federation of Women's Suffrage Societies. THE FIRST WORLD WAR-THE SCOTTISH WOMEN'S HOSPITALS: After the outbreak of the Great War in August, 1914. Dr. E. Inglis immediately organised, through her Federation, the so-called "Scottish Women's Hospitals" (SWH), on the whole 13 of them, which worked through the war in France, Belgium, Serbia, Greece (Macedonia), and Russia (Romania). SERBIA, 1915: In.January, 1915 the first Unit of the SWH arrived to Kragujevac, and.soon three more hospitals came to Serbian towns of Valjevo, Lazarevac and Mladenovac. In May 1915 Dr. E. Inglis herself came to Serbia. In October, 1915, when the great offensive of the Central Powers began, all these hospitals were evacuated to Krusevac, where they undertook the task of nursing 900 Serbian wounded at the "Csar Lazar" military hospital. Dr. Inglis and the majority of her staff refused to evacuate any further and stayed with their Serb patients. In November, 1915 they became prisoners of war, but continued to treat their patients until February, 1916 when they were repatriated. RUSSIA, 1916-1917: Back home, Dr. E. Inglis formed a new large SWH Unit, which, headed by herself sailed for Russia in August, 1916, and soon joined the so-called Yugoslav Volunteer Division, consisting mainly of Serbs, fighting on the Dobrudja front. After heavy losses and many retreats the remainder of this division, together with the SWH were evacuated back to England, to Newcastle, where Dr. E. Inglis, who was already seriously ill, died, on November 26th, 1917. She was later buried in Edinburgh, with full military honours.
AB  - EPILOGUE: High honours were bestowed posthumously on Dr. E. Inglis both by Great Britain and Serbia, and now, 90 years after her death, we should remember her with deep gratitude and respect for all she did for our people in the most difficult times of its history.
PT  - Biography
PT  - Historical Article
PT  - Journal Article
PT  - Portrait
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=19097383
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:19097383&id=doi:&issn=0025-8105&isbn=&volume=61&issue=7-8&spage=419&pages=419-26&date=2008&title=Medicinski+Pregled&atitle=%5B%22Serbian+mother+from+Scotland%22--Dr.+Elsie+Inglis+%281864-1917%29%5D.&aulast=Mikic&pid=%3Cauthor%3EMikic+Z%3C%2Fauthor%3E%3CAN%3E19097383%3C%2FAN%3E%3CDT%3EBiography%3C%2FDT%3E

<287. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18988563
TI  - The Malawi connection.
SO  - Nursing Standard. 23(6):23, 2008 Oct 15-21.
VI  - 1
ST  - MEDLINE
AU  - Knight J
FA  - Knight, Jenny
AB  - Links between nurses in Scotland and Malawi have had a positive effect in both countries, with Scottish nurses engaging in fund-raising activities and Malawian nurses bolstering membership of their new nursing union.
PT  - Journal Article
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18988563
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18988563&id=doi:10.7748%2Fns.23.6.23.s24&issn=0029-6570&isbn=&volume=23&issue=6&spage=23&pages=23&date=2008&title=Nursing+Standard&atitle=The+Malawi+connection.&aulast=Knight&pid=%3Cauthor%3EKnight+J%3C%2Fauthor%3E%3CAN%3E18988563%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<288. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18856018
TI  - Community nursing: redesign in Scotland.
SO  - British Journal of Community Nursing. 13(8):373-7, 2008 Aug.
VI  - 1
ST  - MEDLINE
AU  - Quickfall J
AU  - Pollock L
FA  - Quickfall, Julia
FA  - Pollock, Linda
IN  - Quickfall, Julia. Queen's Nursing Institute, Scotland. julia.quickfall@qnis.org.uk
AB  - The report 'Visible, accessible and integrated care' (VAIC) proposes a new Community Health Nurse (CHN) model which involves the combination of the four current disciplines of district nursing, public health nursing (health visiting and school nursing) and family health nursing into a single generic role (Scottish Executive, 2006b). The Queen's Nursing Institute in Scotland (QNIS) wished to identify the implications of the VAIC report; a series of national focus groups were held throughout Scotland during 2007 with key stakeholders, initially including managers and senior nurses, practitioners, staff nurses and educationalists, and later family health nurses, practice nurses, school nurses, and General Practitioners. Finally, a patient and carers' focus group was held to establish a public perspective on the changes. This article summarizes the key findings from the QNIS focus groups and highlights the emerging themes concerning the implementation of VAIC.
PT  - Journal Article
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18856018
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18856018&id=doi:10.12968%2Fbjcn.2008.13.8.30730&issn=1462-4753&isbn=&volume=13&issue=8&spage=373&pages=373-7&date=2008&title=British+Journal+of+Community+Nursing&atitle=Community+nursing%3A+redesign+in+Scotland.&aulast=Quickfall&pid=%3Cauthor%3EQuickfall+J%3C%2Fauthor%3E%3CAN%3E18856018%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<289. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18842457
TI  - WISECARE+: Results of a European study of a nursing intervention for the management of chemotherapy-related symptoms.
SO  - European Journal of Oncology Nursing. 12(5):443-8, 2008 Dec.
VI  - 1
ST  - MEDLINE
AU  - Kearney N
AU  - Miller M
AU  - Maguire R
AU  - Dolan S
AU  - MacDonald R
AU  - McLeod J
AU  - Maher L
AU  - Sinclair L
AU  - Norrie J
AU  - Wengstrom Y
FA  - Kearney, Nora
FA  - Miller, Morven
FA  - Maguire, Roma
FA  - Dolan, Shelley
FA  - MacDonald, Roseanne
FA  - McLeod, Joan
FA  - Maher, Louise
FA  - Sinclair, Lesley
FA  - Norrie, John
FA  - Wengstrom, Yvonne
IN  - Kearney, Nora. Cancer Care Research Centre, Department of Nursing and Midwifery, University of Stirling, UK. nora.kearney@stir.ac.uk
AB  - While the use of chemotherapy has significantly improved survival rates, the symptoms associated with chemotherapy remain a major burden for patients. Preventing or appropriately managing side effects significantly improves patients' functional status and quality of life, ultimately leading to greater patient acceptance of chemotherapy. However, symptom assessment and management are fraught with difficulties such as poor patient recall, retrospective assessment conducted by clinicians and lack of appropriate, clinically relevant and patient friendly symptom assessment and management tools. Furthermore the differences between clinician and patient perceptions of stresses and distress during chemotherapy are well recognised. This study aimed to evaluate the impact of a nursing intervention incorporating structured symptom assessment and management, facilitated by information technology, on chemotherapy-related symptoms, nausea, vomiting, fatigue and mucositis. This pan-European study, involved 8 clinical sites from Belgium, Denmark, England, Ireland and Scotland. Adults (n=249) receiving first line chemotherapy for breast, lung, ovarian or colorectal cancer, osteosarcoma, acute myeloid leukaemia (AML), acute lymphoblastic leukaemia (ALL) or lymphoma were recruited to the study. Patients completed daily symptom assessment questionnaires for 14 days following consecutive cycles of chemotherapy. Symptom outcomes were compared before and after the introduction of the intervention with positive impact on patients' experiences of nausea, vomiting and oral problems. Fatigue was not significantly improved.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18842457
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18842457&id=doi:10.1016%2Fj.ejon.2008.07.005&issn=1462-3889&isbn=&volume=12&issue=5&spage=443&pages=443-8&date=2008&title=European+Journal+of+Oncology+Nursing&atitle=WISECARE%2B%3A+Results+of+a+European+study+of+a+nursing+intervention+for+the+management+of+chemotherapy-related+symptoms.&aulast=Kearney&pid=%3Cauthor%3EKearney+N%3C%2Fauthor%3E%3CAN%3E18842457%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<290. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18700077
TI  - Community nursing managers' perceptions and experiences of protected learning time: a qualitative study.
SO  - Quality in Primary Care. 16(1):39-47, 2008.
VI  - 1
ST  - MEDLINE
AU  - Cunningham DE
AU  - Kelly DR
FA  - Cunningham, David E
FA  - Kelly, Diane R
IN  - Cunningham, David E. NHS Education for Scotland, Glasgow, Scotland, UK. davidecunningham@wightcablenorth.net
AB  - BACKGROUND: Protected learning time (PLT) is used to allow primary healthcare teams time to learn, protected from service delivery. Different occupational groups have different perceptions and experiences of PLT. Research has shown that community nurses have low rates of attendance at practice-based PLT (PB-PLT) in one area in Scotland. Nursing managers have considerable influence with PLT, as leaders of community nursing teams and as members of PLT steering committees.
AB  - AIMS: To understand the community nursing managers' perceptions and experiences of PLT, and to explore their perceptions of the low rate of attendance by community nurses at PB-PLT.
AB  - METHODS: Qualitative study involving two focus groups (six nursing managers) and one interview (director of nursing), in three community health partnerships in one NHS health board in Scotland. Focus group interviews and one in-depth interview were conducted, audio-recorded and then transcribed. Transcriptions were analysed using a grounded theory approach to data analysis.
AB  - RESULTS: Participants recognised the potential benefits of PLT for community nursing and primary healthcare teams. They perceived low rates of attendance were because learning at PB-PLT was considered irrelevant by community nurses. They felt community nurses were not involved in planning and preparing PB-PLT, and that their learning needs were not incorporated into PB-PLT. Participants felt there were organisational differences between practices and the community nursing team, which acted as a barrier to learning. Participants had concerns about the learning arranged for practice nurses at PB-PLT. They considered that the new general medical services contract had been an initial barrier to learning.
AB  - CONCLUSION: Nursing managers had perceptions of PLT that contrasted with those of their community nurses. There were similarities also. Primary healthcare teams need to improve mutual understanding, and need to work together to improve the quality of learning at PB-PLT.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18700077
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18700077&id=doi:&issn=1479-1072&isbn=&volume=16&issue=1&spage=39&pages=39-47&date=2008&title=Quality+in+Primary+Care&atitle=Community+nursing+managers%27+perceptions+and+experiences+of+protected+learning+time%3A+a+qualitative+study.&aulast=Cunningham&pid=%3Cauthor%3ECunningham+DE%3C%2Fauthor%3E%3CAN%3E18700077%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<291. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18700076
TI  - Community nurses' perceptions and experiences of protected learning time: a focus group study.
SO  - Quality in Primary Care. 16(1):27-37, 2008.
VI  - 1
ST  - MEDLINE
AU  - Cunningham DE
AU  - Kelly DR
FA  - Cunningham, David E
FA  - Kelly, Diane R
IN  - Cunningham, David E. NHS Education for Scotland, Glasgow, Scotland, UK. davidecunningham@wightcablenorth.net
AB  - BACKGROUND: Protected learning time (PLT) has spread quickly to primary healthcare teams in Scotland. Previous research has shown that PLT is generally well received, but that different professional and occupational groups have differing perceptions and experiences of PLT. Community nurses have low rates of attendance at practice-based PLT in NHS Ayrshire and Arran. It is not known why.
AB  - AIMS: To explore and understand the community nurses' perceptions and experiences of PLT, and to discover the barriers to their attendance at practice-based PLT.
AB  - DESIGN: Qualitative study involving four focus groups of 37 community nurses.
AB  - SETTING: Three community health partnerships in one NHS health board area in Scotland.
AB  - METHODS: Focus group interviews were conducted, audio-recorded and then transcribed. Transcriptions were analysed using a grounded theory approach to data analysis.
AB  - RESULTS: Community nurses often had separate learning events at PLT, and were not involved in the processes of learning with the general medical practice. Chosen topics were often irrelevant to them and their attendance was low. Learning was often uniprofessional. Community nurses perceived they did not have adequate protection from service delivery during PLT. They felt that practice managers had a key role in the delivery of PLT, and that team working and team learning were important, and useful if done well. They considered that the new contract had had a negative impact on PLT.
AB  - DISCUSSION: Community nurses need to be involved more in the learning process, if PLT is to be relevant and useful to them and the practice. Nursing managers may need to increase the service protection for community nurses in order to allow them to learn with the rest of the primary healthcare team. Those who organise PLT at primary care organisation level may have to consider using independent facilitators to effect changes.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18700076
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18700076&id=doi:&issn=1479-1072&isbn=&volume=16&issue=1&spage=27&pages=27-37&date=2008&title=Quality+in+Primary+Care&atitle=Community+nurses%27+perceptions+and+experiences+of+protected+learning+time%3A+a+focus+group+study.&aulast=Cunningham&pid=%3Cauthor%3ECunningham+DE%3C%2Fauthor%3E%3CAN%3E18700076%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<292. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18638207
TI  - Quantitative analysis of mental health nurse prescribers in Scotland.
SO  - Journal of Psychiatric & Mental Health Nursing. 15(6):471-8, 2008 Aug.
VI  - 1
ST  - MEDLINE
AU  - Snowden A
FA  - Snowden, A
IN  - Snowden, A. Mental Health Nursing, School of Health Nursing and Midwifery, University of West of Scotland, Paisley, UK. austyn.snowden@uws.ac.uk
AB  - The UK parliament approved legislation expanding prescribing rights for all registered nurses in 2006. Mental health nurses do not appear to be embracing prescribing to the same degree as their colleagues. For example, mental health nurses represent 14% of the UK nursing population, but only 3% nurse prescribing population. In order to explore this disparity, the paper discusses quantitative analysis of the following objectives: (1) describe the impact of nurse prescribing on nurse prescribers in NHS Greater Glasgow and Clyde; and (2) identify differences between mental health nurse prescribers and other nurse prescribers in NHS Greater Glasgow and Clyde. Following online pilot study, a 26-item questionnaire was posted to 668 nurse prescribers in NHS Greater Glasgow and Clyde. A total of 365 questionnaires were returned (55.4%). Significant differences were found between mental health nurse prescribers and others in terms of age, gender, prescribing practice, academic achievement, method of prescribing, workplace, experience and attitude to prescribing. Possible reasons for these differences are suggested and form the basis of further planned research.
PT  - Journal Article
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18638207
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18638207&id=doi:10.1111%2Fj.1365-2850.2008.01251.x&issn=1351-0126&isbn=&volume=15&issue=6&spage=471&pages=471-8&date=2008&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Quantitative+analysis+of+mental+health+nurse+prescribers+in+Scotland.&aulast=Snowden&pid=%3Cauthor%3ESnowden+A%3C%2Fauthor%3E%3CAN%3E18638207%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<293. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18578760
TI  - An evaluation of fitness for practice curricula: self-efficacy, support and self-reported competence in preregistration student nurses and midwives.
SO  - Journal of Clinical Nursing. 17(14):1858-67, 2008 Jul.
VI  - 1
ST  - MEDLINE
AU  - Lauder W
AU  - Watson R
AU  - Topping K
AU  - Holland K
AU  - Johnson M
AU  - Porter M
AU  - Roxburgh M
AU  - Behr A
FA  - Lauder, William
FA  - Watson, Roger
FA  - Topping, Keith
FA  - Holland, Karen
FA  - Johnson, Martin
FA  - Porter, Mary
FA  - Roxburgh, Michelle
FA  - Behr, Aga
IN  - Lauder, William. School of Nursing & Midwifery, University of Dundee, Dundee, UK. w.lauder@dundee.ac.uk
AB  - AIMS AND OBJECTIVES: This element of the larger Scottish evaluation aimed to explore differences between access routes, cohorts and higher education institutes (HEI) (universities and colleges) in levels of self-efficacy, student support and self-reported competence in a nationally representative sample of student nurses and midwives.
AB  - BACKGROUND: This paper reports findings from the National Review of Pre-Registration Nursing and Midwifery Programmes in Scotland. Fitness for practice curricula have been the heart of many recent developments in nurse and midwifery education. Fitness for practice set out to map out the future direction of preregistration nursing and midwifery education with the aim of ensuring fitness for practice based on healthcare need. There have been no national evaluations of the effectiveness of this strategic objective. Previous major evaluations in the 1990s suggested that students may not have had the skills needed to be fit for practice.
AB  - DESIGN: The study design was a cross-sectional survey of a stratified random sample of student nurses and midwives (n = 777). Data collected included demographic information, generalised perceived self-efficacy, student support and self-reported competency.
AB  - RESULTS: Students reported high levels of self-reported competency. There were no significant differences between two cohorts or between students with different access routes. Students rated support from family and friends highest and support from HEI lowest. There was a significant difference in support levels between HEI. Self-efficacy scores were similar to other population means and showed small-moderate correlations with self-report competence. Similarly, self-reported competency appears to be at the higher end of the spectrum, although older students may have a more realistic perception of their competence. However, support from HEI was seen as less satisfactory and varied from one institution to another.
AB  - CONCLUSIONS: This study portrays a relatively positive picture of preregistration fitness for practice curricula. Questions are raised about the relative value students place on support from educationalists and mentors and whether support from family and friends and from peers needs to feature more prominently in curricula. The study provides modest support for social cognitive theory.
AB  - RELEVANCE TO CLINICAL PRACTICE: The major drivers for changes in preregistration curricula stemmed from fears about the competence of students. This study did not provide support for this viewpoint, and students' self-reports suggest that curricula are, in this respect, meeting their objectives. Nevertheless support from mentors and from educational institutes may need to be improved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18578760
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18578760&id=doi:10.1111%2Fj.1365-2702.2007.02223.x&issn=0962-1067&isbn=&volume=17&issue=14&spage=1858&pages=1858-67&date=2008&title=Journal+of+Clinical+Nursing&atitle=An+evaluation+of+fitness+for+practice+curricula%3A+self-efficacy%2C+support+and+self-reported+competence+in+preregistration+student+nurses+and+midwives.&aulast=Lauder&pid=%3Cauthor%3ELauder+W%3C%2Fauthor%3E%3CAN%3E18578760%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<294. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18477105
TI  - Working together; a nursing development project in Tajikistan. [Review] [15 refs]
SO  - International Nursing Review. 55(2):205-11, 2008 Jun.
VI  - 1
ST  - MEDLINE
AU  - Parfitt B
AU  - Mughal M
AU  - Thomas H
FA  - Parfitt, B
FA  - Mughal, M
FA  - Thomas, H
IN  - Parfitt, B. Global Development in Health, Glasgow Caledonian University, Scotland, UK. b.a.parfitt@gcal.ac.uk
AB  - BACKGROUND: This paper describes a Nursing Development Programme in Tajikistan where four organizations worked together to develop some innovative changes in nursing practice and education. Within the context of Health Care Reform the Government of Tajikistan provided a climate for Nursing Development. The joint efforts of the Ministry of Health, the World Health Organization (WHO), the WHO Collaborating Centre for Nursing and Midwifery at Glasgow Caledonian University, Scotland, and the Aga Khan Health Service in Tajikistan, have led to major changes in education and practice.
AB  - METHODS: The project focused on the development of new standards for practice in Gorno Badakhshan and a new Family Health Nurse curriculum for all students entering nursing programmes. A Nursing Centre was opened to provide leadership in education and practice and a co-ordinating Council was established to develop professional standards.
AB  - RESULTS: The project has demonstrated that nurses in Tajikistan have embraced the developments in both education and practice with the aim of improving the care they give to their communities and the support they provide for the teams within which they work.
AB  - CONCLUSIONS: The project also illustrates how different organizations can work effectively together. Key principles identified from this project for effective collaborative working include: communication, common goals, shared expertise, pooled funding and close alignment with Government strategies for Health Reform. [References: 15]
PT  - Journal Article
PT  - Review
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18477105
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18477105&id=doi:10.1111%2Fj.1466-7657.2007.00609.x&issn=0020-8132&isbn=&volume=55&issue=2&spage=205&pages=205-11&date=2008&title=International+Nursing+Review&atitle=Working+together%3B+a+nursing+development+project+in+Tajikistan.&aulast=Parfitt&pid=%3Cauthor%3EParfitt+B%3C%2Fauthor%3E%3CAN%3E18477105%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<295. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18439730
TI  - A review of curriculum evaluation in United Kingdom nursing education. [Review] [41 refs]
SO  - Nurse Education Today. 28(7):881-9, 2008 Oct.
VI  - 1
ST  - MEDLINE
AU  - Roxburgh M
AU  - Watson R
AU  - Holland K
AU  - Johnson M
AU  - Lauder W
AU  - Topping K
FA  - Roxburgh, Michelle
FA  - Watson, Roger
FA  - Holland, Karen
FA  - Johnson, Martin
FA  - Lauder, William
FA  - Topping, Keith
IN  - Roxburgh, Michelle. University of Dundee, School of Nursing and Midwifery, Tayside Campus, Ninewells, Dundee DD9 9YS, United Kingdom. m.roxburgh@dundee.ac.uk
AB  - Recently we have witnessed several significant changes to the nursing curriculum in the United Kingdom (UK). This review forms part of a larger study evaluating the 'fitness for practice' elements of the nursing curriculum in Scotland. Systematic review methods were used including the following databases: CINAHL and BNI. Twenty six papers were retrieved and 14 remained after applying the review criteria, the main rationale being the empirical focus. It appears that there is a paucity of research in this area in the UK and papers dealt exclusively with either content, process or outcome evaluation of the nursing curriculum. National, well funded, multi-centre studies tended to be more rigorous. Results , where they were positive about curricular changes, tended to be limited. There is clearly a need for rigorous research into curriculum evaluation, both at the micro and macro level, which investigates content, process and outcome. Without such research, curriculum change will be uninformed. [References: 41]
PT  - Journal Article
PT  - Review
PT  - Systematic Review
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=18439730
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18439730&id=doi:10.1016%2Fj.nedt.2008.03.003&issn=0260-6917&isbn=&volume=28&issue=7&spage=881&pages=881-9&date=2008&title=Nurse+Education+Today&atitle=A+review+of+curriculum+evaluation+in+United+Kingdom+nursing+education.&aulast=Roxburgh&pid=%3Cauthor%3ERoxburgh+M%3C%2Fauthor%3E%3CAN%3E18439730%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<296. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17428584
TI  - Implementation and evaluation of a pilot education programme in colorectal cancer management for nurses in Scotland.
SO  - Nurse Education Today. 28(1):15-23, 2008 Jan.
VI  - 1
ST  - MEDLINE
AU  - Knowles G
AU  - Hutchison C
AU  - Smith G
AU  - Philp ID
AU  - McCormick K
AU  - Preston E
FA  - Knowles, Gillian
FA  - Hutchison, Catherine
FA  - Smith, Graeme
FA  - Philp, Iona D
FA  - McCormick, Katrina
FA  - Preston, Elizabeth
IN  - Knowles, Gillian. Edinburgh Cancer Centre, Western General Hospital, Crewe Road, Edinburgh EH4 2XU, United Kingdom. gillian.knowles@scotland.gsi.gov.uk
AB  - This paper describes the results of an evaluation of a nursing education programme for nurses caring for patients with colorectal cancer. A sample of 67 registered nurses from 6 location sites within the 3 Regional Cancer Networks in Scotland were recruited to the pilot. The programme was adapted from an evidence-based education manual for nurses in the management of colorectal cancer developed by the European Oncology Nursing Society as part of a Nursing in Colorectal Cancer Initiative (NICCI) [Hawthorn, J., Redmond, K., 1999. A Guide to Colorectal Cancer. AstraZeneca Oncology, UK]. The format for evaluating the programme was based on the TELER method of treatment evaluation [Le Roux, A.A., 1995. TELER: the concept. Physiotherapy 79 (11), 755-758] that had previously been developed along side the training manual [Grocott, P., Richardson, A., Ambaum, B., Kearney, N., Redmond, K, 2001a. Nursing in colorectal cancer initiative--the audit phase. Part 1. Development of the audit tool. European Journal of Oncology Nursing 5 (2), 100-111; Grocott, P., Richardson, A., Ambaum, B., Kearney, N., Redmond, K., 2001b. Nursing in colorectal cancer initiative: the audit phase. Part 2. Content validity of the audit tool and implications of the standards set for clinical practice. European Journal of Oncology Nursing 5 (3), 165-173] for cytotoxic chemotherapy to provide the NICCI Audit Tool (Le Roux, 2003). This model was developed further in the current study to include the domains of: Disease, Diagnosis and Staging, Treatment, Nursing Issues and General Issues. Data were analysed descriptively and are discussed. Overall the results from this study demonstrate a statistically significant improvement in disease-related knowledge (p=<0.001) and in the best practice statements for nursing issues (p=<0.001) and general issues (including attitudes) (p=0.023) that were maintained at four months post completion of the course.
PT  - Clinical Trial
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=17428584
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17428584&id=doi:10.1016%2Fj.nedt.2007.02.002&issn=0260-6917&isbn=&volume=28&issue=1&spage=15&pages=15-23&date=2008&title=Nurse+Education+Today&atitle=Implementation+and+evaluation+of+a+pilot+education+programme+in+colorectal+cancer+management+for+nurses+in+Scotland.&aulast=Knowles&pid=%3Cauthor%3EKnowles+G%3C%2Fauthor%3E%3CAN%3E17428584%3C%2FAN%3E%3CDT%3EClinical+Trial%3C%2FDT%3E

<297. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17045999
TI  - Electroconvulsive therapy and the work of mental health nurses: a grounded theory study.
SO  - International Journal of Nursing Studies. 45(2):191-202, 2008 Feb.
VI  - 1
ST  - MEDLINE
AU  - Gass J
FA  - Gass, John
IN  - Gass, John. School of Nursing and Midwifery, Faculty of Health and Social Care, The Robert Gordon University, Garthdee Campus, Garthdee Road, Aberdeen, AB10 7QG, UK. j.gass@rgu.ac.uk <j.gass@rgu.ac.uk>
AB  - BACKGROUND: There is a long history of nursing practice in the area of electroconvulsive therapy (ECT). Opinions on the involvement of nurses in this treatment reflect the wider debate on its use in the professional and popular media. There is extensive literature on the issues raised by this particular treatment but little research into what nurses actually do when working with patients receiving ECT.
AB  - OBJECTIVES: The research question was: How do mental health nurses work with patients having electroconvulsive therapy?
AB  - DESIGN: This was a Grounded Theory adopting a 'hybrid' approach to the methodology influenced by the differing perspectives of both co-originators, Glaser and Strauss.
AB  - SETTINGS: The research took place in wards and ECT departments in two hospitals in Scotland.
AB  - PARTICIPANTS: Twenty-four mental health nurses, including 4 students working in National Health Service hospitals in Scotland were accessed through purposive, then theoretical sampling. This included non-participant observation of nurses in their work with patients throughout the treatment period and unstructured interviews.
AB  - METHODS: Analysis was based upon the constant comparative approach with open coding of data that was examined and compared for similarities and differences. This determined further data collection and theoretical development with regard to their properties and relationships to other codes until the point of saturation.
AB  - RESULTS: Nurses' actions in ECT characteristically involve two role groups: relational roles and treatment roles and two dilemmas: uncertain role and uncertain relationships. The core category 'being there' comprising 'engaged', 'present' and 'detached' accounts for nurses' actions in the ECT drama, approaches to difficulties encountered, and, paradoxically, how such actions contributes to this. Slipping is postulated as the basic social psychological process enabling nurses to manage their contact with the patient.
PT  - Journal Article
YR  - 2008
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med7&AN=17045999
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17045999&id=doi:10.1016%2Fj.ijnurstu.2006.08.011&issn=0020-7489&isbn=&volume=45&issue=2&spage=191&pages=191-202&date=2008&title=International+Journal+of+Nursing+Studies&atitle=Electroconvulsive+therapy+and+the+work+of+mental+health+nurses%3A+a+grounded+theory+study.&aulast=Gass&pid=%3Cauthor%3EGass+J%3C%2Fauthor%3E%3CAN%3E17045999%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<298. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17324193
TI  - Treatment of minor illness in primary care: a national survey of patient satisfaction, attitudes and preferences regarding a wider nursing role.
SO  - Health Expectations. 10(1):30-45, 2007 Mar.
VI  - 1
ST  - MEDLINE
AU  - Caldow J
AU  - Bond C
AU  - Ryan M
AU  - Campbell NC
AU  - Miguel FS
AU  - Kiger A
AU  - Lee A
FA  - Caldow, Jan
FA  - Bond, Christine
FA  - Ryan, Mandy
FA  - Campbell, Neil C
FA  - Miguel, Fernando San
FA  - Kiger, Alice
FA  - Lee, Amanda
IN  - Caldow, Jan. Department of General Practice and Primary Care, University of Aberdeen, Aberdeen, UK. j.l.caldow@abdn.ac.uk
AB  - BACKGROUND: This study investigated patient opinion about the provision of nurse-led vs. doctor-led primary health care in the treatment of minor illness.
AB  - DESIGN: A postal questionnaire survey including discrete choice experiment (DCE) of a national sample followed by telephone interviews with respondent volunteers.
AB  - SETTING AND PARTICIPANTS: A large random sample of the population of Scotland from a range of general practices including traditional and extended practice nursing roles was invited to participate.
AB  - MAIN OUTCOME MEASURES: Patient satisfaction with, opinion of and preference for practice nurse (PN) vs. doctor consultation in primary care in relation to gender, age, education and income.
AB  - RESULTS: Questionnaire response rate was 49% (1343 of 2740). Women, younger people, the less well-educated and those with higher income had a more positive attitude towards the PN. Older people had a more positive attitude to the doctor. Results from the DCE indicated that whilst most respondents would prefer a doctor consultation, many would be happy to consult with a nurse if other aspects of the consultation were improved. Forty-eight people were interviewed. The main perceived differences between doctors and nurses were academic ability and qualifications. Most respondents thought nurses could deal with relatively minor problems and should be able to prescribe some drugs.
AB  - CONCLUSION: Patients would always want their choice of health professional to be available at first contact. However, this study suggests that, in primary health-care practices, if nurses take on more roles previously the preserve of doctors, patients would accept them, particularly if patients receive information on nurses' capabilities.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17324193
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17324193&id=doi:10.1111%2Fj.1369-7625.2006.00422.x&issn=1369-6513&isbn=&volume=10&issue=1&spage=30&pages=30-45&date=2007&title=Health+Expectations&atitle=Treatment+of+minor+illness+in+primary+care%3A+a+national+survey+of+patient+satisfaction%2C+attitudes+and+preferences+regarding+a+wider+nursing+role.&aulast=Caldow&pid=%3Cauthor%3ECaldow+J%3C%2Fauthor%3E%3CAN%3E17324193%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<299. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 18044232
TI  - New Zealand nurses' reports on hospital care: an international comparison.
SO  - Nursing Praxis in New Zealand. 23(1):17-28, 2007 Jul.
VI  - 1
ST  - MEDLINE
AU  - Finlayson M
AU  - Aiken L
AU  - Nakarada-Kordic I
FA  - Finlayson, Mary
FA  - Aiken, Linda
FA  - Nakarada-Kordic, Ivana
IN  - Finlayson, Mary. University of Auckland, New Zealand.
AB  - Despite the differences in health care systems, nursing shortages and their contributing factors and consequences no longer seem to be solely country-specific. The present study replicated a cross-national study of nurses' perceptions of staffing, work organisation and outcomes conducted in more than 700 hospitals in the United States, Canada, England, Scotland, and Germany. This paper compares the 2001 New Zealand findings with the findings of the five-country study. New Zealand nurses report similar shortcomings in their work environment as do the nurses in countries with distinctly different health care systems. While they report similar high levels of competence and good relations between doctors and nurses as the respondents in the other five countries, higher numbers of New Zealand nurses 30 years of age or younger report their intention to leave their current jobs. New Zealand nurses also report the highest levels of job related stress, high levels of job dissatisfaction, and more than half report receiving inadequate organisational support. The implications of these findings are discussed in light of recent changes in the hospital environment.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, N.I.H., Extramural
PT  - Research Support, Non-U.S. Gov't
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=18044232
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:18044232&id=doi:&issn=0112-7438&isbn=&volume=23&issue=1&spage=17&pages=17-28&date=2007&title=Nursing+Praxis+in+New+Zealand&atitle=New+Zealand+nurses%27+reports+on+hospital+care%3A+an+international+comparison.&aulast=Finlayson&pid=%3Cauthor%3EFinlayson+M%3C%2Fauthor%3E%3CAN%3E18044232%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<300. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17911886
TI  - e-Health in Scotland: setting a baseline for stakeholder alignment.
SO  - Studies in Health Technology & Informatics. 129(Pt 2):1102-5, 2007.
VI  - 1
ST  - MEDLINE
AU  - Levy S
AU  - Casey A
AU  - Wallis A
FA  - Levy, Sharon
FA  - Casey, Anne
FA  - Wallis, Alison
IN  - Levy, Sharon. Royal College of Nursing Dundee/London/Lothian, UK.
AB  - Gaining knowledge of nurses' attitudes towards and understanding of various aspects of the Scottish e-Health programme is vital for needed 'stakeholder alignment'. This paper is focused on the Scottish results from a large on-line survey carried out in 2006, across the UK. Key findings, identified through analysis of both qualitative and quantitative data, are discussed. Results suggest that overall there is willingness and enthusiasm to engage and to see the modernisation of the NHS in Scotland underpinned by advanced and effective IT systems. It also shows that nurses have clear ideas about how information technology could help them and their patients in delivering safe care that enhances the visibility of the nursing contribution to care outcomes. It is argued that results help in setting a base-line from which to judge the success or otherwise of the needed e-Health clinical change management programme within clinical settings.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17911886
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17911886&id=doi:&issn=0926-9630&isbn=&volume=129&issue=2&spage=1102&pages=1102-5&date=2007&title=Studies+in+Health+Technology+%26+Informatics&atitle=e-Health+in+Scotland%3A+setting+a+baseline+for+stakeholder+alignment.&aulast=Levy&pid=%3Cauthor%3ELevy+S%3C%2Fauthor%3E%3CAN%3E17911886%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<301. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17883635
TI  - Commentary: Numata Y, Schultzer M, et al. (2006). Nurse staffing levels and hospital mortality in critical care settings: literature review and meta-analysis.
SO  - Nursing in Critical Care. 12(2):105-6, 2007 Mar-Apr.
VI  - 1
ST  - MEDLINE
AU  - Plowright C
FA  - Plowright, Catherine
CM  - Comment on (CON)
AB  - This paper reports a review of the literature on the association between critical care nurse staffing levels and patient mortality. Statistically significant inverse associations between levels of nurse staffing and hospital mortality have not been consistently found in the literature. Critical care settings are ideal to address this relationship due to high patient acuity and mortality, high intensity of the nursing care required and availability of individual risk adjustment methods. Major electronic databases were searched, including MEDLINE, EMBASE, and the Cumulative Index of Nursing and Allied Health Literature. The search terms included critical/intensive care, quality of health care, mortality/hospital mortality, personnel staffing and scheduling, and nursing staff (hospital). Only papers published in English were included. The original search was conducted in 2002 and updated in 2005. Nine studies were selected from 251 references screened. All nine were observational. Six were conducted in the USA, one in Austria, one in Brazil, and one in Scotland. The unadjusted risk ratio of nurse staffing (high versus low) on hospital mortality were combined meta-analytically (five studies). The pooled estimate was 0.65 (95% confidence interval 0.47-0.91). However, after adjusting for various covariates within each study, the individually reported associations between high nurse staffing and low hospital mortality became non-significant in all but one study. The impact of nurse staffing levels on patients' hospital mortality in critical care settings was not evident in the reviewed studies. Methodological challenges that might have impeded correct assessment of the association include measurement problems in exposure status and confounding factors, often uncontrolled. The lack of association also indicates that hospital mortality may not be sensitive enough to detect the consequences of low nurse staffing levels in critical care settings. Abstract reprinted from the Journal of Advanced Nursing volume 55, Numata Y et al., 'Nurse staffing levels and hospital mortality in critical care settings: literature review and meta-analysis.', pages 435-448. (c) 2006, with permission from Blackwell Publishing Ltd.
PT  - Journal Article
PT  - Comment
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17883635
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17883635&id=doi:10.1111%2Fj.1478-5153.2007.00213.x&issn=1362-1017&isbn=&volume=12&issue=2&spage=105&pages=105-6&date=2007&title=Nursing+in+Critical+Care&atitle=Commentary%3A+Numata+Y%2C+Schultzer+M%2C+et+al.+%282006%29.+Nurse+staffing+levels+and+hospital+mortality+in+critical+care+settings%3A+literature+review+and+meta-analysis.&aulast=Plowright&pid=%3Cauthor%3EPlowright+C%3C%2Fauthor%3E%3CAN%3E17883635%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<302. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17679281
TI  - Change management for school nurses in Scotland.
SO  - Nursing Standard. 21(42):35-9, 2007 Jun 27-Jul 3.
VI  - 1
ST  - MEDLINE
AU  - Allan E
FA  - Allan, E
IN  - Allan, E. Aberdeen City Community Health Partnership, Royal Aberdeen Children's Hospital. elaine.allan2@nhs.net
AB  - This article outlines the challenges of supporting one school nursing team through a period of unprecedented change - moving from being part of the Combined Child Health Service in the Grampian region of Scotland and part of the acute sector, to becoming part of Aberdeen City Community Health Partnership Children's Services. The article describes the reasons for the change, the challenges and opportunities generated and the ways in which good leadership facilitated a smooth transition.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17679281
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17679281&id=doi:10.7748%2Fns2007.06.21.42.35.c4573&issn=0029-6570&isbn=&volume=21&issue=42&spage=35&pages=35-9&date=2007&title=Nursing+Standard&atitle=Change+management+for+school+nurses+in+Scotland.&aulast=Allan&pid=%3Cauthor%3EAllan+E%3C%2Fauthor%3E%3CAN%3E17679281%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<303. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17517028
TI  - Flexible observation: guidelines versus reality.
SO  - Journal of Psychiatric & Mental Health Nursing. 14(4):373-81, 2007 Jun.
VI  - 1
ST  - MEDLINE
AU  - Kettles AM
AU  - Paterson K
FA  - Kettles, A M
FA  - Paterson, K
IN  - Kettles, A M. NHS Grampian, Bennachie, Royal Cornhill Hospital, Aberdeen, UK. alyson.kettles@nhs.net
AB  - This paper reports a small-scale pilot study to introduce flexible observation of patients in an acute psychiatric clinical area where nurses have increased autonomy to make such decisions. The Clinical Resource and Audit Group document 'Engaging People: Observation of People with Acute Mental Health Problems: A Good Practice Statement' outlines very clearly the observation levels that should be used in acute psychiatric areas in Scotland. It also states clearly who is responsible for conducting different parts of the observation process and how such observation procedures should be conducted. The available literature recommends three observation levels with engagement and considers that intermittent or time period checks are unsafe. A small-scale action research pilot study was conducted over a period of 6 months with individual incidents (n = 57) of patients requiring increased or decreased observation levels being included in the study. There were no exclusion criteria and this was a total sample in one clinical area. The results were analysed using the Statistical Package for the Social Sciences v.14.0 using non-parametric statistics and chi square. The results indicated there has been a shift away from doctors deciding on the levels of observation towards multidisciplinary or nursing decisions regarding this aspect of care. During the pilot, there was a gradual shift away from high levels of observation. Those that were placed on increased levels of observation were on them for a much shorter time than previously and staff generally found the new recording system to be more practical. There were a number of 'sub-levels' of general and constant observation in use. Over the years, recording has suffered from incomplete information and this pilot is no different with 56% (n = 34) of the recording sheets had at least one section of clinical information incomplete or not filled in at all. Despite the guidelines and the subsequent training of staff in the clinical area, some nursing staff were not participating as fully as they might in the decision-making process. Fewer patients were being placed on increased observation levels. Those that were placed on observation were on them for a much shorter time than previously and staff generally found the new recording system to be more practical.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17517028
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17517028&id=doi:10.1111%2Fj.1365-2850.2007.01092.x&issn=1351-0126&isbn=&volume=14&issue=4&spage=373&pages=373-81&date=2007&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Flexible+observation%3A+guidelines+versus+reality.&aulast=Kettles&pid=%3Cauthor%3EKettles+AM%3C%2Fauthor%3E%3CAN%3E17517028%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<304. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17462045
TI  - Using action research to construct national evidence-based nursing care guidance for gerontological nursing.
SO  - Journal of Clinical Nursing. 16(5):945-53, 2007 May.
VI  - 1
ST  - MEDLINE
AU  - Booth J
AU  - Tolson D
AU  - Hotchkiss R
AU  - Schofield I
FA  - Booth, Jo
FA  - Tolson, Debbie
FA  - Hotchkiss, Rhona
FA  - Schofield, Irene
IN  - Booth, Jo. Caledonian Nursing and Midwifery Research Centre, Glasgow Caledonian University, Glasgow, UK. jo.booth@gcl.ac.uk
CM  - Comment in (CIN)
AB  - AIM: This paper explores the development of a low-cost, involving methodology for constructing nursing-focused evidence-based national care guidance, known as Best Practice Statements, the intended users of which are gerontological nurses practising throughout Scotland.
AB  - DESIGN: The Best Practice Statement construction methodology forms one cycle in a five-year longitudinal action research study that aims to achieve evidence-based nursing, facilitate professional networking to support practice development and promote the principles and practice of gerontological nursing. Achieving these aims involved designing a virtual Practice Development College.
AB  - METHODS: A Community of Practice comprising practising gerontological nurses, expert advisors, academic teaching and research nurses collaborated in face-to-face meetings and in the virtual Practice Development College to delineate and refine the procedural model for Best Practice Statement construction. Focus groups, telephone interviews, analysis of on-line archives and documentary outputs formed the analytic dataset.
AB  - RESULTS: Qualitative analysis indicated that, from the perspective of the community of practice, the emerging methodology facilitated the melding of knowledge sources reflecting the dominant evidence hierarchy with other forms of evidence valued by gerontological nurses, in the Best Practice Statement.
AB  - RELEVANCE TO CLINICAL PRACTICE: Current methods of care guidance construction rarely address the concerns of nurses and the evidence from which guidelines are developed is narrowly defined with regard to inclusion and acceptability. In contrast this model focuses on nursing issues, embraces a wider definition of evidence and ensures that the published Best Practice Statements are credible and achievable in gerontological practice, where they are tested and refined as an inherent aspect of the development process.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17462045
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17462045&id=doi:10.1111%2Fj.1365-2702.2007.01773.x&issn=0962-1067&isbn=&volume=16&issue=5&spage=945&pages=945-53&date=2007&title=Journal+of+Clinical+Nursing&atitle=Using+action+research+to+construct+national+evidence-based+nursing+care+guidance+for+gerontological+nursing.&aulast=Booth&pid=%3Cauthor%3EBooth+J%3C%2Fauthor%3E%3CAN%3E17462045%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<305. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17385155
TI  - Sharp-device injuries to hospital staff nurses in 4 countries.
SO  - Infection Control & Hospital Epidemiology. 28(4):473-8, 2007 Apr.
VI  - 1
ST  - MEDLINE
AU  - Clarke SP
AU  - Schubert M
AU  - Korner T
FA  - Clarke, Sean P
FA  - Schubert, Maria
FA  - Korner, Thorsten
IN  - Clarke, Sean P. Center for Health Outcomes and Policy Research, University of Pennsylvania, Philadelphia, PA, 19104, USA. sclarke@nursing.upenn.edu
AB  - OBJECTIVE: To compare sharp-device injury rates among hospital staff nurses in 4 Western countries.
AB  - DESIGN: Cross-sectional survey.
AB  - SETTING: Acute-care hospital nurses in the United States (Pennsylvania), Canada (Alberta, British Columbia, and Ontario), the United Kingdom (England and Scotland), and Germany.
AB  - PARTICIPANTS: A total of 34,318 acute-care hospital staff nurses in 1998-1999.
AB  - RESULTS: Survey-based rates of retrospectively-reported needlestick injuries in the previous year for medical-surgical unit nurses ranged from 146 injuries per 1,000 full-time equivalent positions (FTEs) in the US sample to 488 injuries per 1,000 FTEs in Germany. In the United States and Canada, very high rates of sharp-device injury among nurses working in the operating room and/or perioperative care were observed (255 and 569 injuries per 1,000 FTEs per year, respectively). Reported use of safety-engineered sharp devices was considerably lower in Germany and Canada than it was in the United States. Some variation in injury rates was seen across nursing specialties among North American nurses, mostly in line with the frequency of risky procedures in the nurses' work.
AB  - CONCLUSIONS: Studies conducted in the United States over the past 15 years suggest that the rates of sharp-device injuries to front-line nurses have fallen over the past decade, probably at least in part because of increased awareness and adoption of safer technologies, suggesting that regulatory strategies have improved nurse safety. The much higher injury rate in Germany may be due to slow adoption of safety devices. Wider diffusion of safer technologies, as well as introduction and stronger enforcement of occupational safety and health regulations, are likely to decrease sharp-device injury rates in various countries even further.
PT  - Journal Article
PT  - Research Support, N.I.H., Extramural
PT  - Research Support, Non-U.S. Gov't
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17385155
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17385155&id=doi:10.1086%2F513445&issn=0899-823X&isbn=&volume=28&issue=4&spage=473&pages=473-8&date=2007&title=Infection+Control+%26+Hospital+Epidemiology&atitle=Sharp-device+injuries+to+hospital+staff+nurses+in+4+countries.&aulast=Clarke&pid=%3Cauthor%3EClarke+SP%3C%2Fauthor%3E%3CAN%3E17385155%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<306. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17326553
TI  - Community children's nursing services in Wales: will the NSF make a difference?.
SO  - Paediatric Nursing. 19(1):22-4, 2007 Feb.
VI  - 1
ST  - MEDLINE
AU  - Maunder EZ
FA  - Maunder, Eryl Zac
IN  - Maunder, Eryl Zac. School of Health Science, University of Wales, Swansea.
AB  - The 2006 edition of the RCN Community Children's Nursing Directory lists 239 services--16 of which are based in Wales, 12 in Northern Ireland, two in the Channel Islands, one in the Isle of Man, 23 in Scotland and 185 in England. This listing highlights the continued development and expansion of services across the UK, as well as the further developments that are needed to ensure equity of provision in many areas. The lack of UK or national strategies means that services continue to be developed in an ad hoc way. The National Service Framework for Children, Young people and Maternity Services in Wales (NSF) includes the need for community nursing services in every area of Wales in its recommendations (Welsh Assembly Government (WAG) 2005). As with previous policy recommendations dating back almost 50 years, no additional resources have been provided and no funding has been ring fenced to enable trusts to achieve this key action. With services competing for limited resources there is the risk that community children's services will remain under funded and continue to develop in an ad hoc manner.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17326553
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17326553&id=doi:&issn=0962-9513&isbn=&volume=19&issue=1&spage=22&pages=22-4&date=2007&title=Paediatric+Nursing&atitle=Community+children%27s+nursing+services+in+Wales%3A+will+the+NSF+make+a+difference%3F.&aulast=Maunder&pid=%3Cauthor%3EMaunder+EZ%3C%2Fauthor%3E%3CAN%3E17326553%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<307. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17235096
TI  - Redesign and modernisation of an NHS cataract service (Fife 1997-2004): multifaceted approach.
SO  - BMJ. 334(7585):148-52, 2007 Jan 20.
VI  - 1
ST  - MEDLINE
AU  - Tey A
AU  - Grant B
AU  - Harbison D
AU  - Sutherland S
AU  - Kearns P
AU  - Sanders R
FA  - Tey, Adrian
FA  - Grant, Barbara
FA  - Harbison, Dawn
FA  - Sutherland, Shona
FA  - Kearns, Patrick
FA  - Sanders, Roshini
IN  - Tey, Adrian. Department of Ophthalmology, Ninewells Hospital and Medical School, Dundee DD1 9SY. atey7@yahoo.co.uk
CM  - Comment in (CIN)
CM  - Comment in (CIN)
AB  - PROBLEM: A Scottish national health service ophthalmic facility was unable to cope with increasing demand for cataract surgery.
AB  - DESIGN: Multifaceted approach to redesign hospital space to accommodate a cataract unit; to invest in cataract nursing staff to allow more operations under local anaesthesia and as day cases; and to enhance input by general practitioners and optometrists to streamline and reduce false positive cataract referrals. A prospective audit for productivity was undertaken in 2004 (two years after the redesign) and compared against the national cataract surgery audit data for Fife from 1997.
AB  - SETTING: District general hospital serving a population of 400,000 in south east Scotland.
AB  - KEY MEASURES FOR IMPROVEMENT: Increasing throughput of cataract surgery while assessing quality of care provided against predefined evidence and Royal College of Ophthalmologists' guidelines, and evaluating training standards for ophthalmic surgical trainees against higher surgical training requirements.
AB  - STRATEGIES FOR CHANGE: Cataract services were redesigned to increase throughput and to reduce waiting times while preserving the quality of patient care. A secondary end point was to maintain surgical case load mix thus allowing trainees to continue to fulfil the number of operations required to acquire higher surgical training standards.
AB  - EFFECTS OF CHANGE: In the same three month period 237 cataract operations were carried out in 1997 and 374 in 2004, representing an increase of productivity by 60%. The waiting time for surgery decreased from more than one year to three months. The redesign resulted in almost complete preoperative and postoperative assessment by nursing staff, thus freeing medical time and allowing for more operations. Optometrists' referrals with reports increased significantly (P<0.0001). The number of operations carried out as day cases under local anaesthesia increased, with fewer intraoperative complications and postoperative visits (P<0.0001). The number of operations carried out by trainees more than doubled, from 43 to 100 cases, thus improving training opportunities.
AB  - LESSONS LEARNT: Modest capital investment in rebuilding space and in staff for cataract services can improve the quality and volume of cataract surgery. Enhancing existing NHS services provides for future need while maintaining training standards, thus potentially obviating the need for independent treatment centres. This model could be used throughout the United Kingdom.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17235096
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17235096&id=doi:10.1136%2Fbmj.39050.520069.BE&issn=0959-8138&isbn=&volume=334&issue=7585&spage=148&pages=148-52&date=2007&title=BMJ&atitle=Redesign+and+modernisation+of+an+NHS+cataract+service+%28Fife+1997-2004%29%3A+multifaceted+approach.&aulast=Tey&pid=%3Cauthor%3ETey+A%3C%2Fauthor%3E%3CAN%3E17235096%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<308. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17169469
TI  - What psychosocial well-being in the postnatal period means to midwives.
SO  - Midwifery. 23(4):413-24, 2007 Dec.
VI  - 1
ST  - MEDLINE
AU  - Gibb S
AU  - Hundley V
FA  - Gibb, Susan
FA  - Hundley, Vanora
IN  - Gibb, Susan. School of Nursing and Midwifery, The Robert Gordon University, Garthdee, Aberdeen, AB10 7QG, UK. s.gibb@rgu.ac.uk
AB  - OBJECTIVE: to explore midwives' views of psychosocial well-being in the postnatal period.
AB  - DESIGN: qualitative study using focus-group interviews conducted in 1999.
AB  - SETTING: two community health centres and a school of nursing and midwifery in Scotland.
AB  - PARTICIPANTS: a convenience sample of community and student midwives.
AB  - ANALYSIS: thematic analysis was undertaken through the identification of codes, categories and themes.
AB  - FINDINGS: the categories were generated from the interview questions: 'the meaning midwives give to women's psychosocial well-being', 'midwives' assessment of women's well-being', and 'midwives views of worrying behaviours' displayed by women. From the first two categories, themes of 'coping', 'expectations', 'observation and communication skills', 'labour debriefing', and 'previous contact with women' emerged. Midwives assessed coping and unmet expectations through a range of communication and observational skills, including the use of a form of labour debriefing. Midwives who knew women during their pregnancy thought that they were able to assess coping and expectations better in the postnatal period. The midwives tended to describe women using stereotypical categories. From the third category, 'worrying behaviours', three themes emerged; 'extreme or obsessive behaviours about self, the baby or house' 'wanting to detain you' and 'quiet women'.
AB  - CONCLUSIONS: the meaning midwives give to psychosocial well-being includes a complex interplay between midwives' views of psychosocial well-being and their assessment of it. The importance midwives give to knowing women in pregnancy has implications for the ongoing debate about the provision of continuity of carer. Midwives used a range of techniques to elicit accurate information, to confirm problems or be reassured that all was well. Views based on stereotypical generalisations should be challenged.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17169469
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17169469&id=doi:10.1016%2Fj.midw.2006.07.005&issn=0266-6138&isbn=&volume=23&issue=4&spage=413&pages=413-24&date=2007&title=Midwifery&atitle=What+psychosocial+well-being+in+the+postnatal+period+means+to+midwives.&aulast=Gibb&pid=%3Cauthor%3EGibb+S%3C%2Fauthor%3E%3CAN%3E17169469%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<309. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17067725
TI  - An examination of the scope and purpose of education in mental health nursing.
SO  - Nurse Education Today. 27(6):588-96, 2007 Aug.
VI  - 1
ST  - MEDLINE
AU  - Gass J
AU  - McKie A
AU  - Smith I
AU  - Brown A
AU  - Addo M
FA  - Gass, John
FA  - McKie, Andrew
FA  - Smith, Ian
FA  - Brown, Ann
FA  - Addo, Mary
IN  - Gass, John. School of Nursing and Midwifery, Faculty of Health and Social Care, The Robert Gordon University, Garthdee Campus, Garthdee Road, Aberdeen, AB10 7QG, United Kingdom. j.gass@rgu.ac.uk
AB  - This study examined the education of mental health nurses by surveying all qualified mental health nurses working within one National Health Service region in Scotland. Using an adaptation of a previously used instrument, 488 questionnaires were distributed producing a response rate of 194 (39.75%). The study's themes - initial preparation, professional development and future practice - reveal findings of interest, particularly the axis of RMN (pre-1992 education) and RMN (Project 2000 education). In terms of initial preparation, clear differences between groups were found. Pre-1992 RMNs' report on educational experience majoring on practical skills contrasts sharply with Project 2000 respondents who, in spite of a course philosophy of reflective practice, emphasised an apparent lack of practical skills for practice. For professional development, both groups valued flexible approaches via journal reading, teaching, networking and participating in clinical supervision. In terms of educational provision, short course provision with an emphasis on short, flexible course provision (e.g., in-service study days), practice education and closer (and flexible) links between higher education and the practice area were highlighted as the most important ways to prepare for future practice.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17067725
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17067725&id=doi:10.1016%2Fj.nedt.2006.08.020&issn=0260-6917&isbn=&volume=27&issue=6&spage=588&pages=588-96&date=2007&title=Nurse+Education+Today&atitle=An+examination+of+the+scope+and+purpose+of+education+in+mental+health+nursing.&aulast=Gass&pid=%3Cauthor%3EGass+J%3C%2Fauthor%3E%3CAN%3E17067725%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<310. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16759758
TI  - The path to nurse registration.
SO  - Nurse Education Today. 27(2):145-54, 2007 Feb.
VI  - 1
ST  - MEDLINE
AU  - Sheward L
AU  - Smith I
FA  - Sheward, Louisa
FA  - Smith, Iain
IN  - Sheward, Louisa. University of Paisley, School of Health, Nursing and Midwifery, University Campus Ayr, Beech Grove, Ayr, Scotland KA8 0SR, United Kingdom. shew-nm0@wpmail.paisley.ac.uk
AB  - The aim of this study was to identify factors promoting or impeding pre-registration degree level education at the first School of Nursing in Scotland offering transfer from diploma to degree programmes. A questionnaire was used to collect data from third year student nurses (adult branch). This included an "attitude towards obtaining a degree" scale, developed using psychometric techniques to maximise reliability and validity. Attitudes were generally positive. The majority of participants believed obtaining a degree would help nurses develop their career and increase their professional status. However, the majority disagreed with views that obtaining a degree was essential to be a good nurse, would make nurses better at their jobs and would improve patient care provided by nurses. Only 25% believed obtaining a degree ought to be essential for all student nurses. Twenty-nine participants did not accept transfer to a degree programme. Of these, four-fifths reported this was due to the combined pressures of academic workload, family and work. None of these participants believed that obtaining a degree would make nurses better at their jobs. A theory-practice divide seemed to exist whereby many participants did not relate increased degree knowledge to improved clinical practice.
PT  - Journal Article
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16759758
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16759758&id=doi:10.1016%2Fj.nedt.2006.04.003&issn=0260-6917&isbn=&volume=27&issue=2&spage=145&pages=145-54&date=2007&title=Nurse+Education+Today&atitle=The+path+to+nurse+registration.&aulast=Sheward&pid=%3Cauthor%3ESheward+L%3C%2Fauthor%3E%3CAN%3E16759758%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<311. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16575417
TI  - Goldmann applanation tonometer calibration error checks: current practice in the UK.
SO  - Eye. 21(6):733-4, 2007 Jun.
VI  - 1
ST  - MEDLINE
AU  - Kumar N
AU  - Jivan S
FA  - Kumar, N
FA  - Jivan, S
IN  - Kumar, N. Eye Department, University of Hospital Aintree, Liverpool, Mersey, UK. nishant6377@aol.com
AB  - AIM: Assess current practice and views regarding checking Goldmann applanation tonometers for calibration errors in the United Kingdom.
AB  - DESIGN: Questionnaire survey.
AB  - METHODS: A total of 100 ophthalmology residents from England, Wales, and Scotland attending the 2004 Congress of the Royal College of Ophthalmologists, UK, responded to a structured questionnaire. They were asked the following: how often they used different tonometers between clinical sessions; how often they checked their tonometers for errors; and who they felt was responsible for checking tonometers for calibration errors.
AB  - RESULTS: All respondents were using a different Goldmann tonometer for each clinic: 85% never check tonometers for errors; only 7% perform checks at the start of each clinical session; and 8% would only check the tonometer for calibration errors if they had suspicious or unexpected measurements. A total of 70% of respondents felt that calibration checks are not part of their responsibility. They believe that either nursing staff or other hospital staff should carry out calibration checks and ensure that tonometers are accurate. The remaining 30% felt that calibration checks should be carried out by the doctor using the tonometer.
AB  - CONCLUSION: Despite evidence that Goldmann tonometers lose accuracy during routine use in clinical practice, only a minority are checking the tonometers for calibration errors. There is no consensus as to who should be responsible for ensuring that tonometer calibration is maintained. We recommend that tonometers should be checked for calibration errors at least on a monthly basis by individuals identified by departmental protocols.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2007
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16575417
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16575417&id=doi:10.1038%2Fsj.eye.6702316&issn=0950-222X&isbn=&volume=21&issue=6&spage=733&pages=733-4&date=2007&title=Eye&atitle=Goldmann+applanation+tonometer+calibration+error+checks%3A+current+practice+in+the+UK.&aulast=Kumar&pid=%3Cauthor%3EKumar+N%3C%2Fauthor%3E%3CAN%3E16575417%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<312. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17102277
TI  - The structure and content of the nursing component of a pilot electronic health record for the cardiac managed clinical network in Scotland.
SO  - Studies in Health Technology & Informatics. 122:342-5, 2006.
VI  - 1
ST  - MEDLINE
AU  - Docherty C
FA  - Docherty, Charles
IN  - Docherty, Charles. Glasgow Caledonian University, Glasgow, Scotland. c.a.Docherty@gcal.ac.uk
AB  - The development of a Portal for the Cardiac Managed Clinical Network (MCN) in Glasgow, Scotland, provided an opportunity to move towards a paperless environment for health care records. Nursing diagnoses within NANDA were ranked and 39 core to cardiac nursing identified. Appropriate nursing interventions and outcomes were grouped to form 'templates' adaptable to the individual. A system was proposed to facilitate the use of these templates to ease the process of producing care plans. However, this did no more than serve as an ideal. This exercise acknowledges the complexity of nursing activity and highlights the need to standardise protocols and procedures in nursing practice. It also illustrates the imperative for nurses to be actively involved in developing clinical systems fit for purpose.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17102277
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17102277&id=doi:&issn=0926-9630&isbn=&volume=122&issue=&spage=342&pages=342-5&date=2006&title=Studies+in+Health+Technology+%26+Informatics&atitle=The+structure+and+content+of+the+nursing+component+of+a+pilot+electronic+health+record+for+the+cardiac+managed+clinical+network+in+Scotland.&aulast=Docherty&pid=%3Cauthor%3EDocherty+C%3C%2Fauthor%3E%3CAN%3E17102277%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<313. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17102262
TI  - A Tartan Warning: Results from the Royal College of Nursing (Scotland) on-line surveys.
SO  - Studies in Health Technology & Informatics. 122:269-72, 2006.
VI  - 1
ST  - MEDLINE
AU  - Levy S
AU  - Dallest K
AU  - Casey A
FA  - Levy, Sharon
FA  - Dallest, Kathy
FA  - Casey, Anne
IN  - Levy, Sharon. Royal College of Nursing Dundee, London, UK.
AB  - Rapid advancements in Information and communication technologies are set to revolutionise the National Health Service across UK and billions of pounds are spent on modernising the service. The technology enabled service in Scotland will have a considerable impact on the working lives of care providers. Nursing professionals, being the largest single professional group in the care service, are likely to be the most affected by it. Early consultations, dissemination of appropriate information and involvement of nurses, health visitors and midwives is vital for a successful Scottish e-Health programme. However, results from the Royal College of Nursing 2004/5 on-line surveys, reported here, suggest that the majority of respondents remain unaware of Scottish e-Health developments. The authors argue that more focused action is needed to enable more nurses to get involved in the design and implementation of new clinical systems.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17102262
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17102262&id=doi:&issn=0926-9630&isbn=&volume=122&issue=&spage=269&pages=269-72&date=2006&title=Studies+in+Health+Technology+%26+Informatics&atitle=A+Tartan+Warning%3A+Results+from+the+Royal+College+of+Nursing+%28Scotland%29+on-line+surveys.&aulast=Levy&pid=%3Cauthor%3ELevy+S%3C%2Fauthor%3E%3CAN%3E17102262%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<314. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17087664
TI  - The national review of mental health nursing in Scotland: implications for the profession.
SO  - Journal of Psychiatric & Mental Health Nursing. 13(6):634-5, 2006 Dec.
VI  - 1
ST  - MEDLINE
AU  - Lauder W
AU  - Forrest S
AU  - Masters H
FA  - Lauder, W
FA  - Forrest, S
FA  - Masters, H
PT  - Editorial
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17087664
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17087664&id=doi:10.1111%2Fj.1365-2850.2006.01039.x&issn=1351-0126&isbn=&volume=13&issue=6&spage=634&pages=634-5&date=2006&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=The+national+review+of+mental+health+nursing+in+Scotland%3A+implications+for+the+profession.&aulast=Lauder&pid=%3Cauthor%3ELauder+W%3C%2Fauthor%3E%3CAN%3E17087664%3C%2FAN%3E%3CDT%3EEditorial%3C%2FDT%3E

<315. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17063578
TI  - Review of nursing in the community in Scotland.
SO  - Community Practitioner. 79(10):317; author reply 317, 2006 Oct.
VI  - 1
ST  - MEDLINE
AU  - Martin P
FA  - Martin, Paul
CM  - Comment on (CON)
PT  - Comment
PT  - Letter
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17063578
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17063578&id=doi:&issn=1462-2815&isbn=&volume=79&issue=10&spage=317&pages=317%3B+author+reply+317&date=2006&title=Community+Practitioner&atitle=Review+of+nursing+in+the+community+in+Scotland.&aulast=Martin&pid=%3Cauthor%3EMartin+P%3C%2Fauthor%3E%3CAN%3E17063578%3C%2FAN%3E%3CDT%3EComment%3C%2FDT%3E

<316. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17059492
TI  - Public policy and private provisions: changes in residential care from 1991 to 2001.
SO  - Health & Social Care in the Community. 14(6):499-507, 2006 Nov.
VI  - 1
ST  - MEDLINE
AU  - Haynes P
AU  - Banks L
AU  - Balloch S
AU  - Hill M
FA  - Haynes, Philip
FA  - Banks, Laura
FA  - Balloch, Susan
FA  - Hill, Michael
IN  - Haynes, Philip. Health and Social Policy Research Centre, School of Applied Social Science, University of Brighton, Brighton, UK. p.haynes@brighton.ac.uk
AB  - This research examined changes in the number of care homes and their residents in the UK between the 1991 and 2001 Censuses. Local-authority-owned provision universally declined in this period, but changes in private residential and nursing homes were far more varied. Some parts of Britain experienced a growth in this market, in particular Scotland. Regions which were traditionally linked with greater numbers of retired people in their populations declined in their private residential home markets (e.g. the South West and South East). Wales experienced a regional decline that was greater than most English regions. Using additional Department of Health data, it was possible to estimate which local authority areas in England were exporting state-funded supported residents to homes out of their area. Most of these authorities were in urban areas and the highest rates of exporting were from Inner London boroughs. Political control and average property prices were explored as possible independent variables influencing the percentage rate of decline in homes in a local authority area. It appeared that Conservative authorities experienced a more rapid decline in government-owned homes than those run by Labour, but the results were not statistically significant, suggesting that local politics was a not a key influence on the trend. Average property prices did not affect all areas of the country, but were found to have a negative and significant association with percentage rates of decline in care homes in both Wales and London.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17059492
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17059492&id=doi:10.1111%2Fj.1365-2524.2006.00638.x&issn=0966-0410&isbn=&volume=14&issue=6&spage=499&pages=499-507&date=2006&title=Health+%26+Social+Care+in+the+Community&atitle=Public+policy+and+private+provisions%3A+changes+in+residential+care+from+1991+to+2001.&aulast=Haynes&pid=%3Cauthor%3EHaynes+P%3C%2Fauthor%3E%3CAN%3E17059492%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<317. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17040511
TI  - Constructing a new approach to developing evidence-based practice with nurses and older people.
SO  - Worldviews on Evidence-Based Nursing. 3(2):62-72, 2006.
VI  - 1
ST  - MEDLINE
AU  - Tolson D
AU  - Irene S
AU  - Booth J
AU  - Kelly TB
AU  - James L
FA  - Tolson, Debbie
FA  - Irene, Schofield
FA  - Booth, Jo
FA  - Kelly, Timothy B
FA  - James, Louise
IN  - Tolson, Debbie. Gerontological Nursing, Midwifery and Community Health, Glasgow Caledonian University, Glasgow, UK. D.tolson@gcal.ac.uk
AB  - PURPOSE: Providing evidence-based nursing care to older people is central to the international development agenda. This paper is a report on the first 5 years (2000-2005) of a participatory research project, the purpose of which was to collaborate with practitioners and older people to develop approaches to promote the attainment of evidence-based nursing care across Scotland.
AB  - DESIGN: Many theoretical influences shaped the design of this action research study including realistic evaluation, participatory social learning theory, and descriptions of communities of practice. Multiple methods of data collection were used during four action cycles. The inaugural community of practice comprised 30 nurses, a second group of 30 nurses joined midway, followed by a third group of 15 nurses, and finally, an older person-carer community of 21 members was established.
AB  - FINDINGS: Project outputs included the construction of an internet-based, practice-development college. A procedural model for developing and demonstrating care guidance drawn from a diversity of evidence and reflective of an agreed set of principles was piloted and endorsed by the national standard setting agency. A preliminary version of a promising approach to practice development, "the Caledonian Model," was delineated for future testing and refinement.
AB  - CONCLUSION: This work indicates the merits of using participatory research to find solutions to the challenge of promoting evidence-based practice. Evaluation data suggest that in combination, the approaches developed in this project empower nurses to work with older people to champion developments even in seemingly unfavorable conditions.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17040511
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17040511&id=doi:10.1111%2Fj.1741-6787.2006.00052.x&issn=1545-102X&isbn=&volume=3&issue=2&spage=62&pages=62-72&date=2006&title=Worldviews+on+Evidence-Based+Nursing&atitle=Constructing+a+new+approach+to+developing+evidence-based+practice+with+nurses+and+older+people.&aulast=Tolson&pid=%3Cauthor%3ETolson+D%3C%2Fauthor%3E%3CAN%3E17040511%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<318. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17014931
TI  - Patients' views of nurses' competence.
SO  - Nurse Education Today. 26(8):719-25, 2006 Dec.
VI  - 1
ST  - MEDLINE
AU  - Calman L
FA  - Calman, Lynn
IN  - Calman, Lynn. School of Nursing, Midwifery and Social Work, The University of Manchester, Coupland 3, Oxford Road, Manchester M13 9PL, UK. lynn.calman@manchester.ac.uk
AB  - This study examines, from the patients' perspective, what is meant by competent nursing and how, with this perspective in mind, patients would view the prospect of assessing the competence of nurses. There is a little empirical research that clarifies professional competence from the patient's perspective. Nursing curricula in the UK have shifted attention to 'competencies' as the outcome of nurse education and, in an era of patient involvement, their views are important to investigate. The study utilises a grounded theory approach. Data were collected in Central Scotland between 2001 and 2003. Twenty-seven patients participated. Data were analysed, in keeping with the grounded theory tradition, utilising the constant comparative method. Patients described the foundation of competent nursing practice as technical care and nursing knowledge. Patients assume that technical care is competent as safe guards are considered to be in place to protect patients. When technical competence is assumed, interpersonal attributes become the most important indicator of the quality of nursing care. The results of this study highlight uncertainty about whether patients feel able to assess the competence of nurses. The results of this study may have implications for nurses internationally when trying to involve patients in the assessment of nurses.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17014931
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17014931&id=doi:10.1016%2Fj.nedt.2006.07.016&issn=0260-6917&isbn=&volume=26&issue=8&spage=719&pages=719-25&date=2006&title=Nurse+Education+Today&atitle=Patients%27+views+of+nurses%27+competence.&aulast=Calman&pid=%3Cauthor%3ECalman+L%3C%2Fauthor%3E%3CAN%3E17014931%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<319. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17009775
TI  - Health visitor or public health nurse? A Scottish study.
SO  - Community Practitioner. 79(9):289-92, 2006 Sep.
VI  - 1
ST  - MEDLINE
AU  - Wilson S
FA  - Wilson, Susan
IN  - Wilson, Susan. East Ayrshire Community Health Partnership.
AB  - The Scottish Executive and the National Health Service (NHS) have been consistently promoting 'public health nursing' as a new way forward in the community. In addition, since 2001 traditional health visitor and school nurse education programmes have been replaced by a single public health nurse training curriculum. However, many of the roles, responsibilities and job descriptions of clinical health visiting staff have remained unchanged within health board areas. This has led to apparent confusion among staff, both newly qualified and those already in post. This lack of clarity in policy and role prompted this research study, which set out to investigate the perceptions of the public health role of the health visitor within a health board area in Scotland. Initially, a review of the relevant literature was undertaken to provide in-depth background information on the topic, to enable a critical analysis of the current public health role of the health visitor. This analysis was further informed by obtaining qualitative and quantitative data via a questionnaire sent to 89 health visitors, to determine the attitudes and opinions of health visitors currently working within a Scottish health board area. Results from the study indicate that, despite the plethora of public health-related Scottish Executive publications and the changes in educational programmes, many health visitors still carry out what is perceived as a traditional role with mainly the under-five age group. The study also identified the need for clear direction in the public health role for health visitors, with many health visitors expressing a willingness to make changes to their current role.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17009775
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17009775&id=doi:&issn=1462-2815&isbn=&volume=79&issue=9&spage=289&pages=289-92&date=2006&title=Community+Practitioner&atitle=Health+visitor+or+public+health+nurse%3F+A+Scottish+study.&aulast=Wilson&pid=%3Cauthor%3EWilson+S%3C%2Fauthor%3E%3CAN%3E17009775%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<320. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 17004314
TI  - Resourcing global health: a conference of the Global Network of WHO Collaborating Centres for Nursing and Midwifery Development, Glasgow, Scotland, June 2006.
SO  - Midwifery. 22(3):200-3, 2006 Sep.
VI  - 1
ST  - MEDLINE
AU  - Duff E
FA  - Duff, Elizabeth
IN  - Duff, Elizabeth. International Confederation of Midwives. e.duff@internationalmidwives.org
PT  - Congress
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=17004314
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:17004314&id=doi:10.1016%2Fj.midw.2006.07.001&issn=0266-6138&isbn=&volume=22&issue=3&spage=200&pages=200-3&date=2006&title=Midwifery&atitle=Resourcing+global+health%3A+a+conference+of+the+Global+Network+of+WHO+Collaborating+Centres+for+Nursing+and+Midwifery+Development%2C+Glasgow%2C+Scotland%2C+June+2006.&aulast=Duff&pid=%3Cauthor%3EDuff+E%3C%2Fauthor%3E%3CAN%3E17004314%3C%2FAN%3E%3CDT%3ECongress%3C%2FDT%3E

<321. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16997481
TI  - Are burns photographs useful?.
SO  - Burns. 32(7):876-9, 2006 Nov.
VI  - 1
ST  - MEDLINE
AU  - Nelson L
AU  - Boyle M
AU  - Taggart I
AU  - Watson S
FA  - Nelson, L
FA  - Boyle, M
FA  - Taggart, I
FA  - Watson, S
IN  - Nelson, L. Glasgow Royal Infirmary Burns Unit, 84 Castle Street, Glasgow G4 0SF, United Kingdom.
AB  - UNLABELLED: Routine photography of all patients admitted to the West of Scotland Regional Burns Unit was introduced in 2003. To date, there are few burns units to evaluate the usefulness of photographs taken.
AB  - AIM: To assess the usefulness of photographs of patients admitted to the burns unit to various members of the multidisciplinary team.
AB  - METHOD: A questionnaire was completed by hospital staff involved in the management of burns patients over a 3-month period. A total of 43 questionnaires were completed.
AB  - RESULTS: The majority of questionnaires were completed by nursing staff (55%) followed by medical staff (23%); physiotherapy (5%); anaesthetists (7%); theatre staff (5%); students (2%); dietician (2%). About 98% of respondents agreed that photographs were useful overall, particularly for teaching purposes. About 9% disagreed that photographs were useful for assessment due to difficulty in assessing depth of burn. About 72% agreed that the photographs were useful for patient management and improve patient care. About 88% agreed that all patients should have photographs available in future. Advantages of photographs include; moving and handling of patients; patient positioning in theatre; reviewing wound healing and complications. They are useful for assessing site, size and type of burn. Disadvantages include difficulty in assessing depth of burn, technical factors, and unavailability out of hours.
AB  - CONCLUSIONS: Photographs of burns patients are useful overall to all members of the multidisciplinary team.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16997481
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16997481&id=doi:10.1016%2Fj.burns.2006.02.004&issn=0305-4179&isbn=&volume=32&issue=7&spage=876&pages=876-9&date=2006&title=Burns&atitle=Are+burns+photographs+useful%3F.&aulast=Nelson&pid=%3Cauthor%3ENelson+L%3C%2Fauthor%3E%3CAN%3E16997481%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<322. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16968432
TI  - Do nurses promote urinary continence in hospitalized older people?: An exploratory study.
SO  - Journal of Clinical Nursing. 15(10):1276-86, 2006 Oct.
VI  - 1
ST  - MEDLINE
AU  - Dingwall L
AU  - McLafferty E
FA  - Dingwall, Lindsay
FA  - McLafferty, Ella
IN  - Dingwall, Lindsay. SPQ Care of Older People, Assessment and Rehabilitation, School of Nursing and Midwifery, University of Dundee, Dundee, Scotland. l.h.dingwall@dundee.ac.uk
AB  - AIM: The aim of this paper is to explore whether nurses working in elderly medicine and in acute medical settings promote urinary continence in older people or in reality use containment strategies.
AB  - BACKGROUND: Untreated urinary incontinence in older adults can result in prolonged hospital admission and increased risk of admission to long-term care. Urinary incontinence can also have severe psychosocial effects on older people. Most studies relating to this topic have relied on quantitative approaches to data collection with a seeming lack of qualitative investigation into how nursing staff promote urinary continence in hospitalized older people.
AB  - METHOD: Focus groups and one-to-one semi-structured interviews were carried out in two NHS regions in Scotland. Registered and non-Registered Nurses were invited to participate. Five focus groups (n = 17) and four single interviews (n = 4) were conducted. Data generated were analysed thematically using QSR N-VIVO 2.
AB  - FINDINGS: Some nurses believe that older people accept urinary incontinence as a consequence of ageing. Lack of assessment results in older people being labelled as incontinent of urine. Assessment strategies in medicine for the elderly tend to focus on product identification and management of incontinence. Although nurses from all clinical areas identify the importance of promoting continence, the problem continues to be contained rather than treated. Conflicting clinical priorities, varying staff approaches to urinary continence and deficits in education are cited among the barriers to promoting continence.
AB  - CONCLUSIONS: The results suggest that nurses continue to contain urinary incontinence rather than promoting continence in older people.
AB  - RELEVANCE TO CLINICAL PRACTICE: Nursing staff need to be aware of the impact of untreated urinary incontinence on older people. Practitioners should promote continence rather than employing containment strategies. A validated assessment tool for older people needs to be developed. Views of older people should be sought regarding their attitudes towards urinary incontinence.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16968432
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16968432&id=doi:10.1111%2Fj.1365-2702.2006.01381.x&issn=0962-1067&isbn=&volume=15&issue=10&spage=1276&pages=1276-86&date=2006&title=Journal+of+Clinical+Nursing&atitle=Do+nurses+promote+urinary+continence+in+hospitalized+older+people%3F%3A+An+exploratory+study.&aulast=Dingwall&pid=%3Cauthor%3EDingwall+L%3C%2Fauthor%3E%3CAN%3E16968432%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<323. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16907788
TI  - Nurses' opportunistic interventions with patients in relation to smoking.
SO  - Journal of Advanced Nursing. 55(5):568-77, 2006 Sep.
VI  - 1
ST  - MEDLINE
AU  - Whyte RE
AU  - Watson HE
AU  - McIntosh J
FA  - Whyte, Rosemary E
FA  - Watson, Hazel E
FA  - McIntosh, Jean
IN  - Whyte, Rosemary E. Post-Doctoral Research Fellow, Caledonian Nursing and Midwifery Research Centre, Glasgow Caledonian University, Glasgow, UK. R.Whyte@gcal.ac.uk
AB  - AIM: This paper reports a study exploring nurses' provision of opportunistic health education on smoking for hospital patients.
AB  - BACKGROUND: Smoking cessation guidelines recommend assessment of patients' smoking habits and provision of smoking cessation advice when possible, and highlight the importance of the role of nurses in health promotion and health education. In the past, nurses have been criticized for lack of knowledge, skills and confidence in relation to health education and the perception that it is additional to, rather than integrated with, nursing care.
AB  - METHODS: A qualitative case study design was selected to explore the health education practice of 12 nurses working in acute wards in three general hospitals in Scotland. Data were collected in 2000 through non-participant observation, semi-structured interviews and the use of a radio-microphone to record nurse-patient interactions. The data analysis was guided by four key elements of health education practice: 'the teachable moment', 'readiness to learn', 'the provision of health information' and 'oral communication'.
AB  - FINDINGS: Smoking was part of the nurses' agenda, as most recognized opportunities to introduce health education on smoking during nursing care, suggesting a tentative move towards the integration of health education with nursing care. Evidence from patients' interactions indicated ample opportunity for nurses to provide smoking-related health information. However, the content of nurses' interactions on smoking was variable, with some limited by poor communication skills and inadequate knowledge of smoking and smoking cessation. The context of the interactions was also important in understanding some of the restrictions on conversational progress.
AB  - CONCLUSIONS: Nurses require the knowledge and skills to perform a health education role, and the inclusion of smoking cessation guidelines in nursing curricula would contribute to this. Where patients are in hospitals for short periods of time, opportunistic health education on smoking needs to be introduced as the basis for more specialist intervention.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16907788
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16907788&id=doi:10.1111%2Fj.1365-2648.2006.03949.x&issn=0309-2402&isbn=&volume=55&issue=5&spage=568&pages=568-77&date=2006&title=Journal+of+Advanced+Nursing&atitle=Nurses%27+opportunistic+interventions+with+patients+in+relation+to+smoking.&aulast=Whyte&pid=%3Cauthor%3EWhyte+RE%3C%2Fauthor%3E%3CAN%3E16907788%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<324. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16866839
TI  - Nurse staffing levels and hospital mortality in critical care settings: literature review and meta-analysis. [Review] [44 refs]
SO  - Journal of Advanced Nursing. 55(4):435-48, 2006 Aug.
VI  - 1
ST  - MEDLINE
AU  - Numata Y
AU  - Schulzer M
AU  - van der Wal R
AU  - Globerman J
AU  - Semeniuk P
AU  - Balka E
AU  - Fitzgerald JM
FA  - Numata, Yuka
FA  - Schulzer, Michael
FA  - van der Wal, Rena
FA  - Globerman, Judith
FA  - Semeniuk, Pat
FA  - Balka, Ellen
FA  - Fitzgerald, J Mark
IN  - Numata, Yuka. Vancouver General Hospital, Vancouver, British Columbia, Canada. yuka.numata@vch.ca
CM  - Comment in (CIN)
AB  - AIM: This paper reports a review of the literature on the association between critical care nurse staffing levels and patient mortality.
AB  - BACKGROUND: Statistically significant inverse associations between levels of nurse staffing and hospital mortality have not been consistently found in the literature. Critical care settings are ideal to address this relationship due to high patient acuity and mortality, high intensity of the nursing care required, and availability of individual risk adjustment methods.
AB  - METHODS: Major electronic databases were searched, including MEDLINE, EMBASE, and the Cumulative Index of Nursing and Allied Health Literature. The search terms included critical/intensive care, quality of health care, mortality/hospital mortality, personnel staffing and scheduling, and nursing staff (hospital). Only papers published in English were included. The original search was conducted in 2002 and updated in 2005.
AB  - RESULTS: Nine studies were selected from 251 references screened. All nine were observational. Six were conducted in the United States of America, one in Austria, one in Brazil, and one in Scotland. The unadjusted risk ratio of nurse staffing (high vs. low) on hospital mortality were combined meta-analytically (five studies). The pooled estimate was 0.65 (95% confidence interval 0.47-0.91). However, after adjusting for various covariates within each study, the individually reported associations between high nurse staffing and low hospital mortality became non-significant in all but one study.
AB  - CONCLUSION: The impact of nurse staffing levels on patients' hospital mortality in critical care settings was not evident in the reviewed studies. Methodological challenges that might have impeded correct assessment of the association include measurement problems in exposure status and confounding factors, often uncontrolled. The lack of association also indicates that hospital mortality may not be sensitive enough to detect the consequences of low nurse staffing levels in critical care settings. [References: 44]
PT  - Journal Article
PT  - Meta-Analysis
PT  - Research Support, Non-U.S. Gov't
PT  - Review
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16866839
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16866839&id=doi:10.1111%2Fj.1365-2648.2006.03941.x&issn=0309-2402&isbn=&volume=55&issue=4&spage=435&pages=435-48&date=2006&title=Journal+of+Advanced+Nursing&atitle=Nurse+staffing+levels+and+hospital+mortality+in+critical+care+settings%3A+literature+review+and+meta-analysis.&aulast=Numata&pid=%3Cauthor%3ENumata+Y%3C%2Fauthor%3E%3CAN%3E16866839%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<325. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16866808
TI  - Promoting physical activity in primary care settings: health visitors' and practice nurses' views and experiences.
SO  - Journal of Advanced Nursing. 55(2):159-68, 2006 Jul.
VI  - 1
ST  - MEDLINE
AU  - Douglas F
AU  - van Teijlingen E
AU  - Torrance N
AU  - Fearn P
AU  - Kerr A
AU  - Meloni S
FA  - Douglas, Flora
FA  - van Teijlingen, Edwin
FA  - Torrance, Nicola
FA  - Fearn, Paul
FA  - Kerr, Ann
FA  - Meloni, Serena
IN  - Douglas, Flora. Department of Public Health, University of Aberdeen, Aberdeen, UK. f.douglas@abdn.ac.uk
AB  - AIM: This paper reports a study investigating health visitors' and practice nurses' attitudes, beliefs and practice associated with routinely advising patients about physical activity.
AB  - BACKGROUND: There is worldwide concern about increasing rates of obesity and decreasing population levels of physical activity, and it has been argued that primary healthcare professionals are ideally placed to promote physical activity within local communities. In recent years, the public health role of primary care-based nurses in the United Kingdom has been considerably expanded to include playing a key role in improving the health of their local practice populations. A systematic literature search revealed that very few studies investigating nurses' views and experiences of this type work have been published. The limited amount of research that has been conducted is generally small-scale and primarily concerned with general medical practitioners' practice and attitudes, and not those of nurses.
AB  - METHODS: A questionnaire survey (n = 630) and 20 in-depth interviews were conducted with health visitors and practice nurses in four health regions in Scotland between March and April 2004. The response rate was 63% overall.
AB  - RESULTS: Ninety per cent (n = 149) of health visitors and 88% (n = 186) of practice nurses said that they were very likely or likely to recommend all apparently healthy adult patients to take moderate exercise. Health visitors were more likely to discuss psychological benefits than practice nurses. However, only 9% (n = 15) of practice nurses and 11% (n = 15) of health visitors correctly described the current recommendations - an accumulation of 30 minutes of moderate physical activity five times a week. Interview data suggested that most nurses gave physical activity advice based on their beliefs about the patient's willingness to change and their impressions of the patient's presenting condition, underlying physical condition and life circumstances. No measure of underlying physical fitness was used. There was a lack of agreement between the questionnaire and interview data associated with levels of physical activity advising.
AB  - CONCLUSION: There were high levels of enthusiasm for physical activity promotion amongst health visitors and practice nurses. However, nursing leaders and opinion-makers should challenge practitioners' current beliefs and assumptions about physical activity promotion in the general population.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16866808
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16866808&id=doi:10.1111%2Fj.1365-2648.2006.03903.x&issn=0309-2402&isbn=&volume=55&issue=2&spage=159&pages=159-68&date=2006&title=Journal+of+Advanced+Nursing&atitle=Promoting+physical+activity+in+primary+care+settings%3A+health+visitors%27+and+practice+nurses%27+views+and+experiences.&aulast=Douglas&pid=%3Cauthor%3EDouglas+F%3C%2Fauthor%3E%3CAN%3E16866808%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<326. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16834584
TI  - Analysis of the impact of a national initiative to promote evidence-based nursing practice.
SO  - International Journal of Nursing Practice. 12(4):232-40, 2006 Aug.
VI  - 1
ST  - MEDLINE
AU  - Ring N
AU  - Coull A
AU  - Howie C
AU  - Murphy-Black T
AU  - Watterson A
FA  - Ring, Nicola
FA  - Coull, Alison
FA  - Howie, Catherine
FA  - Murphy-Black, Tricia
FA  - Watterson, Andrew
IN  - Ring, Nicola. Department of Nursing and Midwifery, University of Stirling, Stirling, UK. nicola.ring@stir.ac.uk
AB  - Best Practice Statements (BPS) are designed to facilitate evidence-based practice. This descriptive, exploratory study evaluated the impact of five of these statements in Scotland. A postal survey of 1,278 registered nurses was undertaken to determine use of these statements and their perceived benefits (response rate: 42%). Use of the BPS differed across clinical sites and some statements were more likely to be used than others. Identified barriers and drivers to their use were similar to factors known to encourage or hinder evidence-based practice generally. Although approximately 25% of clinical respondents reported using the BPS, most respondents reported perceived benefits to patients usually through quality improvement. Results highlight the importance of facilitation and supportive contexts in encouraging clinical use of these statements. Findings suggest that variation in clinical implementation of the BPS need to be addressed locally and nationally if their benefits are to be maximized.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16834584
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16834584&id=doi:10.1111%2Fj.1440-172X.2006.00569.x&issn=1322-7114&isbn=&volume=12&issue=4&spage=232&pages=232-40&date=2006&title=International+Journal+of+Nursing+Practice&atitle=Analysis+of+the+impact+of+a+national+initiative+to+promote+evidence-based+nursing+practice.&aulast=Ring&pid=%3Cauthor%3ERing+N%3C%2Fauthor%3E%3CAN%3E16834584%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<327. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16764398
TI  - Infection control education for undergraduates.
SO  - Nursing Standard. 20(37):35-41, 2006 May 24-30.
VI  - 1
ST  - MEDLINE
AU  - Chalmers C
AU  - Straub M
FA  - Chalmers, Claire
FA  - Straub, Marion
IN  - Chalmers, Claire. Bell College, Hamilton, Lanarkshire. c.chalmers@bell.ac.uk
AB  - Healthcare-associated infection (HCAI) is recognised as a major and increasing problem to health (Scottish Executive 2002a). National strategies are being considered to address the problem. This article describes how one Scottish higher education institution collaborated to identify, adapt and implement the Cleanliness Champions programme--a national infection control educational initiative--in established undergraduate nursing and midwifery curricula. The result was that undergraduate nursing and midwifery students were included in the national campaign to tackle HCAI in Scotland.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16764398
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16764398&id=doi:10.7748%2Fns2006.05.20.37.35.c4159&issn=0029-6570&isbn=&volume=20&issue=37&spage=35&pages=35-41&date=2006&title=Nursing+Standard&atitle=Infection+control+education+for+undergraduates.&aulast=Chalmers&pid=%3Cauthor%3EChalmers+C%3C%2Fauthor%3E%3CAN%3E16764398%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<328. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16650030
TI  - Nursing and midwifery research in Scotland: from partnership to collaboration. [Review] [14 refs]
SO  - International Nursing Review. 53(2):117-22, 2006 Jun.
VI  - 1
ST  - MEDLINE
AU  - Fyffe T
FA  - Fyffe, T
IN  - Fyffe, T. Scottish Executive Health Department, Edinburgh Directorate of Nursing, St Andrew's House, Regent Road, Edinburgh, EH1 3DG, UK. theresa.Fyffe@scotland.gov.uk
AB  - Nurses and midwives form the workforce that provides the greatest proportion of direct care to service users. They have the ability to make a significant impact not only on the quality and outcomes of patient care, but also on service users' and carers' perceptions of the care experience. It is therefore vital that nursing and midwifery practice has a robust knowledge and evidence base. The Scottish Executive Health Department, in partnership with other key stakeholders, launched in 2004 an 8 million pounds funding package for research and development capacity and capability initiatives for nursing, midwifery and the allied health professions. This article seeks to describe the process of engagement and partnership building that enabled this scheme to be developed. It will attempt to illustrate how the convergence of political, policy and professional agendas has provided the opportunity for nurses and midwives to set a direction of travel for research and development that will enable them to become key players within multidisciplinary research at United Kingdom and international levels. [References: 14]
PT  - Journal Article
PT  - Review
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16650030
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16650030&id=doi:10.1111%2Fj.1466-7657.2006.00443.x&issn=0020-8132&isbn=&volume=53&issue=2&spage=117&pages=117-22&date=2006&title=International+Nursing+Review&atitle=Nursing+and+midwifery+research+in+Scotland%3A+from+partnership+to+collaboration.&aulast=Fyffe&pid=%3Cauthor%3EFyffe+T%3C%2Fauthor%3E%3CAN%3E16650030%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<329. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16623292
TI  - Nursing students' understanding of the Glasgow Coma Scale.
SO  - Nursing Standard. 20(30):41-7, 2006 Apr 5-11.
VI  - 1
ST  - MEDLINE
AU  - Shoqirat N
FA  - Shoqirat, N
IN  - Shoqirat, N. Faculty of Health and Social Sciences, School of Health Sciences, Queen Margaret University College, Edinburgh. nshoqirat@qmuc.ac.uk
AB  - AIM: To explore third year nursing students' understanding of the Glasgow Coma Scale (GCS).
AB  - METHOD: An explorative survey using a semi-structured questionnaire was used. A convenience sample of 65 third year nursing students was selected from a university faculty of nursing in Scotland. Of 65 questionnaires distributed, 39 were returned, giving a 60 per cent response rate.
AB  - FINDINGS: Most respondents (n= 24, 62 per cent) were not confident in practical use of the GCS. However, they wanted to improve their theoretical knowledge as well as their practical skills.
AB  - CONCLUSION: A short training course is needed to make sure that students are able to use the GCS effectively while minimising errors.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16623292
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16623292&id=doi:10.7748%2Fns.20.30.41.s54&issn=0029-6570&isbn=&volume=20&issue=30&spage=41&pages=41-7&date=2006&title=Nursing+Standard&atitle=Nursing+students%27+understanding+of+the+Glasgow+Coma+Scale.&aulast=Shoqirat&pid=%3Cauthor%3EShoqirat+N%3C%2Fauthor%3E%3CAN%3E16623292%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<330. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16566338
TI  - Quality assurance and UK nurse education.
SO  - Nursing Standard. 20(27):41-7, 2006 Mar 15-21.
VI  - 1
ST  - MEDLINE
AU  - Hogston R
AU  - Watson R
AU  - Norman I
AU  - Stimpson A
AU  - Sanderson D
AU  - O'Reilly J
FA  - Hogston, Richard
FA  - Watson, Roger
FA  - Norman, Ian
FA  - Stimpson, Anne
FA  - Sanderson, Diana
FA  - O'Reilly, Jacqueline
IN  - Hogston, Richard. School of Health and Community Care, Leeds Metropolitan University. r.hogston@leedsmet.ac.uk
AB  - AIM: To evaluate the quality assurance model for nursing education in the United Kingdom (UK) for the first nine months after the inception in 2002 of the Nursing and Midwifery Council (NMC).
AB  - METHOD: A specially designed questionnaire was administered to representatives of higher education institutions where nurse education took place and representatives of the NMC in all four countries of the UK.
AB  - RESULTS: Quality assurance activity had taken place across the UK, mostly in the shape of validation events. Quality assurance events proceeded largely as expected by higher education and NMC representatives. There was a statistically significant trend towards greater preparedness and knowledge for validation and satisfaction with the new quality assurance procedures in Scotland, Wales and Northern Ireland compared with England.
AB  - CONCLUSION: At the time of this study the new quality assurance procedures were less than 12 months old and there may have been resistance to change in England where the changes were greatest.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16566338
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16566338&id=doi:10.7748%2Fns2006.03.20.27.41.c4093&issn=0029-6570&isbn=&volume=20&issue=27&spage=41&pages=41-7&date=2006&title=Nursing+Standard&atitle=Quality+assurance+and+UK+nurse+education.&aulast=Hogston&pid=%3Cauthor%3EHogston+R%3C%2Fauthor%3E%3CAN%3E16566338%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<331. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16493318
TI  - The Welsh Nursing Academy: a focus for excellence. [Review] [20 refs]
SO  - British Journal of Nursing. 15(3):134-7, 2006 Feb 9-22.
VI  - 1
ST  - MEDLINE
AU  - Davies R
AU  - Clark J
FA  - Davies, Ruth
FA  - Clark, June
IN  - Davies, Ruth. University of Wales, Swansea.
AB  - This article traces the development of the Welsh Nursing Academy (WNA) and links this to other changes that have occurred within the professions of nursing, midwifery and heath visiting, as well as the political landscape of Wales. The mission of the WNA is to serve the people of Wales by promoting excellence in nursing and health care through the generation, synthesis and dissemination of nursing knowledge. How this will be translated into practice through the activities of its membership will be shown in relation to each of the academy's five purposes. This is the first nursing academy to be established in the UK and it is likely that others will follow in England, Scotland and Northern Ireland. As the article concludes, this may lead to a federation of academies across the UK which will collaborate and support each other and link up with existing nursing academies in other countries. [References: 20]
PT  - Journal Article
PT  - Review
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16493318
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16493318&id=doi:10.12968%2Fbjon.2006.15.3.20518&issn=0966-0461&isbn=&volume=15&issue=3&spage=134&pages=134-7&date=2006&title=British+Journal+of+Nursing&atitle=The+Welsh+Nursing+Academy%3A+a+focus+for+excellence.&aulast=Davies&pid=%3Cauthor%3EDavies+R%3C%2Fauthor%3E%3CAN%3E16493318%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<332. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16493293
TI  - Referral criteria: making the district nursing service visible. [Review] [31 refs]
SO  - British Journal of Community Nursing. 11(1):17-22, 2006 Jan.
VI  - 1
ST  - MEDLINE
AU  - Jarvis A
AU  - Mackie S
AU  - Arundel D
FA  - Jarvis, Alison
FA  - Mackie, Sheila
FA  - Arundel, Dawn
IN  - Jarvis, Alison. Primary and Community Division, NHS Lothian. Alison.jarvis@ed.ac.uk
AB  - The development of referral criteria has been seen as one of the keys to the proactive enhancement of the district nursing service to ensure equity and efficiency of service provision (Audit Commission, 1999). Referral criteria specify what constitutes an appropriate district nursing referral and who is the best person or service to undertake the care if it is not. With the continued focus of shifting the balance of care away from the hospital and into the community and a historically reactive rather than proactive work force, district nurses in Lothian, Scotland developed referral criteria for the service. This article discusses the drivers for the development of these criteria, how they were developed, and the anticipated difference implementation of the criteria would make to district nursing. [References: 31]
PT  - Journal Article
PT  - Review
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16493293
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16493293&id=doi:10.12968%2Fbjcn.2006.11.1.20280&issn=1462-4753&isbn=&volume=11&issue=1&spage=17&pages=17-22&date=2006&title=British+Journal+of+Community+Nursing&atitle=Referral+criteria%3A+making+the+district+nursing+service+visible.&aulast=Jarvis&pid=%3Cauthor%3EJarvis+A%3C%2Fauthor%3E%3CAN%3E16493293%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<333. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16487419
TI  - New nursing roles: the experience of Scotland's consultant nurse/midwives.
SO  - Journal of Nursing Management. 14(2):83-9, 2006 Mar.
VI  - 1
ST  - MEDLINE
AU  - Booth J
AU  - Hutchison C
AU  - Beech C
AU  - Robertson K
FA  - Booth, Joanne
FA  - Hutchison, Catherine
FA  - Beech, Christine
FA  - Robertson, Karen
IN  - Booth, Joanne. School of Nursing, Midwifery and Community Health, Glasgow Caledonian University, Glasgow, UK. Jo.Booth@gcal.ac.uk
CM  - Comment in (CIN)
AB  - AIM: To describe career pathways of consultant nurses/midwives and identify postholders views on key factors in role initiation, development and progression to inform future development and appointment of nurse/midwife consultants in National Health Service Scotland.
AB  - BACKGROUND: Nurse/midwife consultants represent the highest levels of clinical practice. Given the Scottish Executive Health Department's aim to treble numbers conditions and circumstances that enable them to flourish must be identified.
AB  - METHOD: A postal survey was undertaken of all nurse/midwife consultants in post (n = 16).
AB  - RESULTS: Key themes emerged around factors that consultant nurse/midwives considered important including mentorship, autonomy and clinical credibility. Barriers to role delivery included lack of understanding of roles and the wide scope of some posts. Considerable variation in support, conditions of service and line management arrangements was found.
AB  - CONCLUSIONS: Development of a recognized career pathway and a consistent approach to employment and support of postholders is recommended.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16487419
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16487419&id=doi:10.1111%2Fj.1365-2934.2006.00595.x&issn=0966-0429&isbn=&volume=14&issue=2&spage=83&pages=83-9&date=2006&title=Journal+of+Nursing+Management&atitle=New+nursing+roles%3A+the+experience+of+Scotland%27s+consultant+nurse%2Fmidwives.&aulast=Booth&pid=%3Cauthor%3EBooth+J%3C%2Fauthor%3E%3CAN%3E16487419%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<334. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16376348
TI  - Is the introduction of a student-centred, problem-based curriculum associated with improvements in student nurse well-being and performance? An observational study of effect.
SO  - International Journal of Nursing Studies. 43(8):941-52, 2006 Nov.
VI  - 1
ST  - MEDLINE
AU  - Jones MC
AU  - Johnston DW
FA  - Jones, Martyn C
FA  - Johnston, Derek W
IN  - Jones, Martyn C. School of Nursing and Midwifery, University of Dundee, 11 Airlie Place, Dundee, UK. m.c.jones@dundee.ac.uk
AB  - AIMS: To explore the impact of curriculum redesign and innovation on student well-being and performance, including essay and examination marks and sickness absence.
AB  - BACKGROUND: While the emotional impact of preparing to be a health professional can be reduced by helping students to adapt, the positive effect of curriculum innovation and redesign is rarely evaluated. DESIGN, SAMPLE AND METHODS: Student nurse well-being and performance was compared at weeks 24/25 and 40/50 following course entry between comparable independent cohorts of students undertaking a traditional programme (N=406, 83% return rate) with those on an innovative, student-centred, problem-based educational programme (N=447, 79% return rate). The setting was a School of Nursing and Midwifery in the North-East of Scotland. Measures included stress and mental health outcomes and measures of performance including academic marks and sickness absence.
AB  - RESULTS: At week 25 into the course students on the innovative course had fewer academic, clinical and personal worries than students in the previous more traditional programme and were more likely to report using adaptive direct, problem-solving coping at week 50. While students on the innovative course reported less distress in their first year of the course, they scored less well on comparable essay assignments and had reliably greater sickness absence totals than those educated by traditional methods.
AB  - CONCLUSION: In this setting, curriculum innovation was associated with positive changes in student well-being but not on performance.
PT  - Comparative Study
PT  - Evaluation Study
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16376348
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16376348&id=doi:10.1016%2Fj.ijnurstu.2005.10.013&issn=0020-7489&isbn=&volume=43&issue=8&spage=941&pages=941-52&date=2006&title=International+Journal+of+Nursing+Studies&atitle=Is+the+introduction+of+a+student-centred%2C+problem-based+curriculum+associated+with+improvements+in+student+nurse+well-being+and+performance%3F+An+observational+study+of+effect.&aulast=Jones&pid=%3Cauthor%3EJones+MC%3C%2Fauthor%3E%3CAN%3E16376348%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<335. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16023649
TI  - A follow-up study of professionals' perspectives on the development of family health nursing in Scotland: a questionnaire survey.
SO  - International Journal of Nursing Studies. 43(3):345-56, 2006 Mar.
VI  - 1
ST  - MEDLINE
AU  - Macduff C
FA  - Macduff, Colin
IN  - Macduff, Colin. Centre for Nurse Practice Research and Development (CeNPRaD), School of Nursing and Midwifery, The Robert Gordon University, Garthdee Road, Aberdeen AB10 7QG, UK. c.macduff@rgu.ac.uk
AB  - BACKGROUND: In 1998 the World Health Organisation Europe introduced the Family Health Nurse concept. The envisaged role of this community-based nurse was seen as multi-faceted and included helping individuals, families and communities to cope with illness and improve their health. During 2000-2002 Scotland led enactment of the concept through education and practice, and the first research study evaluating its operation and impact in remote and rural areas was published in 2003.
AB  - OBJECTIVE: This study's purpose was to follow up health care professionals' perspectives on the development of family health nursing in remote and rural areas of Scotland since 2002.
AB  - METHODS: The main research method used was questionnaire survey of all the established family health nurses in these areas and all other health and social care professionals with whom they had regular work-related contact. Where novel contexts or practice patterns emerged, further investigation was undertaken through telephone interviews.
AB  - FINDINGS: Twenty-three family health nurses (88%) and 88 of their colleagues (52%) returned questionnaires. Eight family health nurses were interviewed. The dominant theme within the findings was the gradual, positive development of a role which tended to maintain established community nursing service provision, yet also supplement this with a limited expansion of family health services and public health activities. The flexibility and wide scope of the FHN role in terms of providing generalist community health nursing services was clearly evident. However, capacity to engage with whole families was found to vary widely in practice.
AB  - CONCLUSIONS: Within remote and rural Scotland family health nursing is gradually consolidating and developing, but its particular aspiration to engage with whole families is often difficult to enact and is not a priority within mainstream UK primary care policy, planning or provision.
PT  - Journal Article
YR  - 2006
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16023649
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16023649&id=doi:10.1016%2Fj.ijnurstu.2005.05.004&issn=0020-7489&isbn=&volume=43&issue=3&spage=345&pages=345-56&date=2006&title=International+Journal+of+Nursing+Studies&atitle=A+follow-up+study+of+professionals%27+perspectives+on+the+development+of+family+health+nursing+in+Scotland%3A+a+questionnaire+survey.&aulast=Macduff&pid=%3Cauthor%3EMacduff+C%3C%2Fauthor%3E%3CAN%3E16023649%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<336. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16415733
TI  - The progress of family health nursing in remote and rural Scotland.
SO  - British Journal of Community Nursing. 10(12):558-62, 2005 Dec.
VI  - 1
ST  - MEDLINE
AU  - Macduff C
FA  - Macduff, Colin
IN  - Macduff, Colin. School of Nursing and Midwifery, The Robert Gordon University, Aberdeen. c.macduff@rgu.ac.uk
AB  - Since 2001 the World Health Organization Europe's family health nurse (FHN) role has been developing in remote and rural areas of Scotland. In 2003, an independent evaluation identified a need for facilitation of the FHN role and family-health orientated approaches with local primary health care teams. The Scottish Executive Health Department appointed three part-time, regionally-based family health practice development facilitators (FHPDFs) in December 2003 to work over an 18-month period. This article presents findings from a small study which sought these FHPDFs' judgements on individual FHN autonomy and supportive colleague action at 24 sites where FHNs were practising. These judgements reveal a picture of mixed progress that is consistent with findings from other related research. This collective overview is presented in the form of a new typology and the resultant implications for future development of family health nursing are discussed.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16415733
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16415733&id=doi:10.12968%2Fbjcn.2005.10.12.20150&issn=1462-4753&isbn=&volume=10&issue=12&spage=558&pages=558-62&date=2005&title=British+Journal+of+Community+Nursing&atitle=The+progress+of+family+health+nursing+in+remote+and+rural+Scotland.&aulast=Macduff&pid=%3Cauthor%3EMacduff+C%3C%2Fauthor%3E%3CAN%3E16415733%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<337. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16295613
TI  - Nursing and midwifery research in Scotland.
SO  - Nursing Management (Harrow). 12(7):17-8, 2005 Nov.
VI  - 1
ST  - MEDLINE
AU  - Fyffe T
AU  - Waterton J
FA  - Fyffe, Theresa
FA  - Waterton, Jennifer
IN  - Fyffe, Theresa. Scottish Executive Health Department, Edinburgh.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16295613
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16295613&id=doi:&issn=1354-5760&isbn=&volume=12&issue=7&spage=17&pages=17-8&date=2005&title=Nursing+Management+%28Harrow%29&atitle=Nursing+and+midwifery+research+in+Scotland.&aulast=Fyffe&pid=%3Cauthor%3EFyffe+T%3C%2Fauthor%3E%3CAN%3E16295613%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<338. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16255740
TI  - 'They first killed his heart (then) he took his own life'. Part 1: a review of the context and literature on mental health issues for refugees and asylum seekers.
SO  - International Journal of Nursing Practice. 11(6):286-91, 2005 Dec.
VI  - 1
ST  - MEDLINE
AU  - Procter NG
FA  - Procter, Nicholas G
IN  - Procter, Nicholas G. School of Nursing and Midwifery, University of South Australia--City East Campus, North Terrace, Adelaide, South Australia, Australia. nicholas.procter@unisa.edu.au
AB  - This is the first in a two-part series of papers examining mental health issues for refugees and asylum seekers. Beginning with the suicide of an asylum seeker in Scotland, the paper emphasizes mental health issues for adult and child asylum seekers, stress and memory, suicide, self-harm, risk and protective factors, compulsory health treatments and the prevention of mental illness. It sets the scene for the second paper by drawing implications for nursing practice in the community. Although most literature on refugee and asylum seeker mental health exists outside of nursing scholarship, a majority of the issues reviewed in this paper are mutual challenges for all in the health and helping professions. Nurses interested in refugee and migration issues face two intertwined challenges: that of how to assist migrants with their diverse mental health needs and how, at the same time, to contribute to a society that can promote mental health for all by taking on both the difficulties and opportunities posed by cultural diversity.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16255740
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16255740&id=doi:10.1111%2Fj.1440-172X.2005.00537.x&issn=1322-7114&isbn=&volume=11&issue=6&spage=286&pages=286-91&date=2005&title=International+Journal+of+Nursing+Practice&atitle=%27They+first+killed+his+heart+%28then%29+he+took+his+own+life%27.+Part+1%3A+a+review+of+the+context+and+literature+on+mental+health+issues+for+refugees+and+asylum+seekers.&aulast=Procter&pid=%3Cauthor%3EProcter+NG%3C%2Fauthor%3E%3CAN%3E16255740%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<339. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16234743
TI  - Primary care nursing research and the Scottish School of Primary Care.
SO  - British Journal of Community Nursing. 10(10):466-8, 2005 Oct.
VI  - 1
ST  - MEDLINE
AU  - Campbell SE
AU  - McCloughan L
AU  - Watson M
FA  - Campbell, Susan E
FA  - McCloughan, Lucy
FA  - Watson, Margaret
IN  - Campbell, Susan E. Department of General Practice and Primary Care, University of Aberdeen.
AB  - Research capability and research capacity are two fundamental requirements in the development of a research-active, evidence-based nursing profession. The Scottish School of Primary Care is developing programmes to address these issues across Scotland.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16234743
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16234743&id=doi:10.12968%2Fbjcn.2005.10.10.19860&issn=1462-4753&isbn=&volume=10&issue=10&spage=466&pages=466-8&date=2005&title=British+Journal+of+Community+Nursing&atitle=Primary+care+nursing+research+and+the+Scottish+School+of+Primary+Care.&aulast=Campbell&pid=%3Cauthor%3ECampbell+SE%3C%2Fauthor%3E%3CAN%3E16234743%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<340. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16164522
TI  - Nursing best practice statements: an exploration of their implementation in clinical practice.
SO  - Journal of Clinical Nursing. 14(9):1048-58, 2005 Oct.
VI  - 1
ST  - MEDLINE
AU  - Ring N
AU  - Malcolm C
AU  - Coull A
AU  - Murphy-Black T
AU  - Watterson A
FA  - Ring, Nicola
FA  - Malcolm, Cari
FA  - Coull, Alison
FA  - Murphy-Black, Tricia
FA  - Watterson, Andrew
IN  - Ring, Nicola. Department of Nursing & Midwifery, University of Stirling, Stirling, UK. nicola.ring@stir.ac.uk
AB  - AIMS AND OBJECTIVES: To explore implementation of the first five Best Practice Statements from the perspective of nurses involved in their development.
AB  - BACKGROUND: Best Practice Statements were introduced in Scotland to encourage consistent evidence-based nursing practice. As a new initiative, research was required to investigate their clinical implementation.
AB  - DESIGN AND METHODS: In this descriptive study, semi-structured interviews of a purposive sample of nurses (n = 15) were undertaken. Content analysis was used to identify themes emerging from the interview data.
AB  - FINDINGS: Four main themes emerged from analysis of transcripts: variations in use of the Best Practice Statements; benefits to patients; benefits to practitioners; and, barriers and drivers to use. Amongst participants, personal users adopted the statements in their own practice but enablers also actively encouraged others to use the statements. Whether participants acted as enablers depended on individual, team and organizational factors. The ability of participants to act as leaders was influential in determining their ability both to facilitate local implementation and to encourage others to regard the Best Practice Statements as a priority for implementation.
AB  - CONCLUSIONS: This exploratory study highlighted examples of patients and practitioners benefiting from the Best Practice Statements. Such findings suggest these statements could become a useful tool in promoting evidence-based nursing practice. However, implementation of the Best Practice Statements varied between participants and their organizations. Nurses who were most effective in promoting local implementation of the Best Practice Statements adopted facilitator and leadership roles within their organizations.
AB  - RELEVANCE TO PRACTICE: By relating research findings to the literature on guideline and research utilization, this study gives further insight into the implementation of evidence-based practice by nurses. In particular, it supports the conclusion that to be truly effective, initiatives to promote evidence-based practice require nurses to act as local facilitators and leaders.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16164522
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16164522&id=doi:10.1111%2Fj.1365-2702.2005.01225.x&issn=0962-1067&isbn=&volume=14&issue=9&spage=1048&pages=1048-58&date=2005&title=Journal+of+Clinical+Nursing&atitle=Nursing+best+practice+statements%3A+an+exploration+of+their+implementation+in+clinical+practice.&aulast=Ring&pid=%3Cauthor%3ERing+N%3C%2Fauthor%3E%3CAN%3E16164522%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<341. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 16004737
TI  - Running nurse-led secondary prevention clinics for coronary heart disease in primary care: qualitative study of health professionals' perspectives.
SO  - British Journal of General Practice. 55(516):522-8, 2005 Jul.
VI  - 1
ST  - MEDLINE
AU  - Murchie P
AU  - Campbell NC
AU  - Ritchie LD
AU  - Thain J
FA  - Murchie, Peter
FA  - Campbell, Neil C
FA  - Ritchie, Lewis D
FA  - Thain, Joan
IN  - Murchie, Peter. Department of General Practice and Primary Care, University of Aberdeen, Foresterhill Health Centre, Aberdeen. p.murchie@abdn.ac.uk
AB  - BACKGROUND: A randomised trial of nurse-led secondary prevention clinics for coronary heart disease resulted in improved secondary prevention and significantly lowered all-cause mortality at 4-year follow-up. This qualitative trial was conducted to explore the experience of health professionals that had been involved in running the clinics.
AB  - AIM: To identify the barriers and facilitators to establishing secondary prevention clinics for coronary heart disease within primary care.
AB  - DESIGN OF STUDY: Semi-structured audiotaped telephone interviews with GPs and nurses involved in running clinics.
AB  - SETTING: A stratified, random sample of 19 urban, suburban, and rural general practices in north-east Scotland.
AB  - METHOD: Semi-structured telephone interviews with 19 GPs and 17 practice-based nurses involved in running nurse-led clinics for the secondary prevention of coronary heart disease.
AB  - RESULTS: Eight practices had run clinics continuously and 11 had stopped, with eight subsequently restarting. Participants accounted for these patterns by referring to advantages and disadvantages of the clinics in four areas: patient care, development of nursing skills, team working, and infrastructure. Most practitioners perceived benefits for patients from attending secondary prevention clinics, but some, from small rural practices, thought they were unnecessary. The extended role for nurses was welcomed, but was dependent on motivated staff, appropriate training and support. Clinics relied on, and could enhance, team working, however, some doctors were wary of delegating. With regard to infrastructure, staff shortages (especially nurses) and accommodation were as problematic as lack of funds.
AB  - CONCLUSIONS: Nurse-led secondary prevention clinics were viewed positively by most healthcare professionals that had been involved in running them, but barriers to their implementation had led most to stop running them at some point. Lack of space and staff shortages are likely to remain ongoing problems, but improvements in funding training and communication within practices could help clinics to be put into practice and sustained.
PT  - Clinical Trial
PT  - Journal Article
PT  - Multicenter Study
PT  - Randomized Controlled Trial
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=16004737
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:16004737&id=doi:&issn=0960-1643&isbn=&volume=55&issue=516&spage=522&pages=522-8&date=2005&title=British+Journal+of+General+Practice&atitle=Running+nurse-led+secondary+prevention+clinics+for+coronary+heart+disease+in+primary+care%3A+qualitative+study+of+health+professionals%27+perspectives.&aulast=Murchie&pid=%3Cauthor%3EMurchie+P%3C%2Fauthor%3E%3CAN%3E16004737%3C%2FAN%3E%3CDT%3EClinical+Trial%3C%2FDT%3E

<342. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15926971
TI  - Influence of policies on nursing practice in long-term care environments for older people.
SO  - Journal of Advanced Nursing. 50(6):661-71, 2005 Jun.
VI  - 1
ST  - MEDLINE
AU  - Tolson D
AU  - Maclaren W
AU  - Kiely S
AU  - Lowndes A
FA  - Tolson, Debbie
FA  - Maclaren, William
FA  - Kiely, Sian
FA  - Lowndes, Andrew
IN  - Tolson, Debbie. School of Nursing, Midwifery and Community Health, Glasgow Caledonian University, Glasgow, UK. d.tolson@gcal.ac.uk
AB  - AIM: This paper reports a study exploring nurses' awareness of, access to and use of policies within long-term care environments for older people in Scotland.
AB  - BACKGROUND: The provision of the highest quality of nursing care for older people with continuing care needs is facilitated through a number of strategic mechanisms. These encompass regulatory systems, national and local policies and care guidance. Failure of practitioners to engage with the 'policy context' may compromise care standards.
AB  - METHOD: This was a two-stage investigation. A Delphi approach with 33 panel members was used to generate consensus as to the 10 most important current policies in this area of practice. A postal survey was undertaken with 2072 nurses to identify the practice impact of policies, including the 10 identified items.
AB  - FINDINGS: Identification of the 10 most important policies proved challenging for panel members. Initially they identified 137 policy items, which were reduced after clustering and two further rounds to 10 items (consensus agreement 57%). Completed questionnaires were returned by 986 (48%) nurses. A long list of problems limited access to policy information. Nurses reported little time to keep up to date, compounded by communication inefficiencies and limited access to the internet. Awareness of the 10 selected items ranged from 46 to 83% and clarity of the practice message was high (85-94%); however, the reported influence on practice varied, with 10-26% of respondents indicating no effect. Professional priorities did not coincide with the priorities of older people themselves.
AB  - CONCLUSION: Nurses appear bewildered by the number and status of policy items. Current methods to provide nurses with information and keep them up to date were not ideal. Processes need to be developed that will engage nurses in policy and pursue closer alignment with the priorities of older people. Strategies are required to identify key policies and promote their implementation.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15926971
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15926971&id=doi:10.1111%2Fj.1365-2648.2005.03451.x&issn=0309-2402&isbn=&volume=50&issue=6&spage=661&pages=661-71&date=2005&title=Journal+of+Advanced+Nursing&atitle=Influence+of+policies+on+nursing+practice+in+long-term+care+environments+for+older+people.&aulast=Tolson&pid=%3Cauthor%3ETolson+D%3C%2Fauthor%3E%3CAN%3E15926971%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<343. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15904997
TI  - Marking criteria for assessing practice-based portfolios at masters' level.
SO  - Nurse Education Today. 25(5):377-89, 2005 Jul.
VI  - 1
ST  - MEDLINE
AU  - Jasper MA
AU  - Fulton J
FA  - Jasper, Melanie A
FA  - Fulton, John
IN  - Jasper, Melanie A. Head of Health and Social Welfare Studies, Canterbury Christ Church University College, North Holmes Road, Canterbury, Kent, CT1 1QU, United Kingdom. m.jasper@canterbury.ac.uk
AB  - Whilst portfolios have increasingly been used to assess attainment and competence in nursing and other health care professions for over a decade, the assessment processes and criteria for assessing them have remained largely rudimentary and undeveloped. In fact, assessment often remains localised, impressionistic and dependent upon the interpretation and adaptation of criteria developed generically for work at this level within individual Higher Education Institutes (HEIs). This paper presents Masters' level marking criteria for portfolios from practice-based healthcare disciplines developed from the Quality Assurance Agency (QAA) descriptors of Masters level achievement and graduateness [Quality Assurance Agency for Higher Education, 2001. The Framework for Higher Education Qualifications in England, Scotland, Northern Ireland] in combination with practice-based outcomes. A six-stage methodology was devised to analyse these descriptors, develop, re-order, test and refine them in order to enhance their applicability to portfolios from practice-based disciplines. As part of this process the emerging criteria were tested against existing portfolios. Extracts from these are presented to illustrate the criteria. Two case study sites from diverse areas of England are used where Masters' courses in nursing and healthcare disciplines are offered. For portfolios to be effective in demonstrating Masters' level academic criteria, learning outcomes and advanced professional practice they need to demonstrate coherent structure, conclusions drawn from reflection on practice and a body of evidence that is coherent with, and linked to their reflective commentaries. The marking criteria presented to assess these attributes incorporate features of the structures, processes and outcomes of both practice and learning. The strategy can be used by both assessors and students, in formative and summative assessment, to identify student attainments, strengths and weaknesses.
PT  - Journal Article
PT  - Multicenter Study
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15904997
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15904997&id=doi:10.1016%2Fj.nedt.2005.03.006&issn=0260-6917&isbn=&volume=25&issue=5&spage=377&pages=377-89&date=2005&title=Nurse+Education+Today&atitle=Marking+criteria+for+assessing+practice-based+portfolios+at+masters%27+level.&aulast=Jasper&pid=%3Cauthor%3EJasper+MA%3C%2Fauthor%3E%3CAN%3E15904997%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<344. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15834357
TI  - Creating an international nursing practice and education workplace. [Review] [25 refs]
SO  - Journal of Pediatric Nursing. 20(1):34-44, 2005 Feb.
VI  - 1
ST  - MEDLINE
AU  - Hern MJ
AU  - Vaughn G
AU  - Mason D
AU  - Weitkamp T
FA  - Hern, Marcia J
FA  - Vaughn, Gretchen
FA  - Mason, Debby
FA  - Weitkamp, Tina
IN  - Hern, Marcia J. Community Outreach and Development, College of Nursing, University of Cincinnati, Cincinnati, OH, USA. mhern@twu.edu
AB  - In today's global workplace, both nursing practice and education need to promote international health. Nurses from a comprehensive 373-patient-bed hospital at Cincinnati Children's Hospital Medical Center and faculty from the College of Nursing, University of Cincinnati, in southwest Ohio have successfully collaborated to develop several unique international nursing exchange programs. The goals of these programs are to increase cultural sensitivity and nursing knowledge relevant to a global community. The essential components used in creating and implementing the programs with Scotland, Honduras, and Korea will serve as an international workplace model for others, especially for those settings focused on children and family health care. [References: 25]
PT  - Journal Article
PT  - Review
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15834357
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15834357&id=doi:10.1016%2Fj.pedn.2004.12.006&issn=0882-5963&isbn=&volume=20&issue=1&spage=34&pages=34-44&date=2005&title=Journal+of+Pediatric+Nursing&atitle=Creating+an+international+nursing+practice+and+education+workplace.&aulast=Hern&pid=%3Cauthor%3EHern+MJ%3C%2Fauthor%3E%3CAN%3E15834357%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<345. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15819655
TI  - Describing gerontological nursing: an academic exercise or prerequisite for progress?.
SO  - Journal of Clinical Nursing. 14 Suppl 1:13-23, 2005 Mar.
VI  - 1
ST  - MEDLINE
AU  - Kelly TB
AU  - Tolson D
AU  - Schofield I
AU  - Booth J
FA  - Kelly, Timothy B
FA  - Tolson, Debbie
FA  - Schofield, Irene
FA  - Booth, Jo
IN  - Kelly, Timothy B. Glasgow Caledonian University, School of Nursing, Midwifery and Community Health, Glasgow, UK. tim.kelly@gcal.ac.uk
AB  - AIMS AND OBJECTIVES: To develop a practitioner-led description of gerontological nursing and articulate the principles which underpin its practice.
AB  - BACKGROUND: As the population ages expertise in gerontological nursing will become increasingly important. However, a complete and widely accepted delineation of the rationale, philosophy, knowledge base and special skills for gerontological nursing is yet to be developed.
AB  - METHODS: As one cycle of a larger action research project informed by realistic evaluation, a representative sample of 30 Scottish nurses worked together as a Community of Practice to develop a description of gerontological nursing that would have utility in their practice and in the development of best practice care guidance. Data collection involved group interviews and records of on-line discussions. Data were analysed using content analysis. The emerging description was verified through external consultation with other nursing colleagues and older people.
AB  - RESULTS: Nursing older people within Scotland was perceived as low status and participants reported that a positive reframing of gerontological nursing was needed. A description and underlying principles were developed by nurses and used as a lens to shape best practice statements. The description embraces a person-centred and enabling approach to evidenced-based gerontological nursing.
AB  - CONCLUSIONS: Gerontological practice requires an accessible consensus view and description to support its development. Practising nurses developed such a view and its utility has been seen in the development of best practice statements. Relevance to clinical practice. The description and principles of gerontological nursing can be used to guide nursing practice, practice development and research.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15819655
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15819655&id=doi:10.1111%2Fj.1365-2702.2005.01147.x&issn=0962-1067&isbn=&volume=14&issue=1&spage=13&pages=13-23&date=2005&title=Journal+of+Clinical+Nursing&atitle=Describing+gerontological+nursing%3A+an+academic+exercise+or+prerequisite+for+progress%3F.&aulast=Kelly&pid=%3Cauthor%3EKelly+TB%3C%2Fauthor%3E%3CAN%3E15819655%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<346. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15792383
TI  - The Adults with Incapacity (Scotland) Act--Who knows? Who cares?.
SO  - Scottish Medical Journal. 50(1):20-2, 2005 Feb.
VI  - 1
ST  - MEDLINE
AU  - Ramsey S
FA  - Ramsey, S
IN  - Ramsey, S. sara_l_ramsey@hotmail.com
OI  - Source: KIE. 129457
OI  - Source: NRCBL. VF 8.3.3
AB  - UNLABELLED: The Adults with Incapacity (Scotland) Act 2000 provides new guidelines on obtaining consent for adults who are incapable of providing informed consent. This article surveys current practice of health workers when obtaining consent from such individuals, and the results are compared to the Incapacity Act and local guidelines. The survey results suggest that practice of the guidelines is variable and often legally inadequate.
AB  - AIMS: To quantify awareness and practical application of the Adults with Incapacity (Scotland) Act in surgical wards in a central Glasgow teaching hospital, 2 years after the Act's introduction.
AB  - METHODS: An interviewer led anonymous questionnaire was presented to all degree educated staff encountered on random visits to acute and elective surgical and orthopaedic wards in a split site teaching hospital.
AB  - RESULTS: 17 out of 50 staff approached (34%) had not heard of the Adults with Incapacity Act. There was a significantly higher level of awareness amongst staff based on acute wards (85%) when compared with those from elective wards (54%) (p < 0.05, chi-square) There was a complete absence offormal training in using the Act and knowledge was sometimes inaccurate or incorrect. Most staff that had heard of the Act could suggest causes of incapacity, but some included physical disability. There was a persistence of the belief that a relative can consentfor an incapable adult patient, and this was expressed by some of the staff despite knowledge of the Act.
AB  - CONCLUSIONS: This study shows that a significant number of ward staff have no knowledge of the Act; and understanding is variable amongst staff who have heard of it. The Adults with Incapacity (Scotland) Act 2000 is a unique piece of legislation to protect the interests of incapable patients, and doctors treating them; but is of no use if medical and nursing staff are unaware of its existence.
PT  - Journal Article
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15792383
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15792383&id=doi:10.1177%2F003693300505000108&issn=0036-9330&isbn=&volume=50&issue=1&spage=20&pages=20-2&date=2005&title=Scottish+Medical+Journal&atitle=The+Adults+with+Incapacity+%28Scotland%29+Act--Who+knows%3F+Who+cares%3F.&aulast=Ramsey&pid=%3Cauthor%3ERamsey+S%3C%2Fauthor%3E%3CAN%3E15792383%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<347. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15788076
TI  - Progressing evidence-based practice: an effective nursing model?.
SO  - Journal of Advanced Nursing. 50(2):124-33, 2005 Apr.
VI  - 1
ST  - MEDLINE
AU  - Tolson D
AU  - McAloon M
AU  - Hotchkiss R
AU  - Schofield I
FA  - Tolson, Debbie
FA  - McAloon, Marie
FA  - Hotchkiss, Rhona
FA  - Schofield, Irene
IN  - Tolson, Debbie. School of Nursing, Midwifery and Community Health, Glasgow Caledonian University, Govan Mbeki Building, Cowcaddens Road, Glasgow G4 0BA, Scotland, UK. d.tolson@gcal.ac.uk
AB  - AIMS: This paper presents findings from telephone interviews completed with link nurses 2 years into the project to explore how participation progressed achievement of evidence-based practice where the link nurses worked.
AB  - BACKGROUND: In 2001, an innovative practice development initiative was launched in Scotland. A national network of experienced nurses from across the country was recruited to form the inaugural Community of Practice. This involved describing gerontological nursing, pioneering a nurse-sensitive methodology to craft care guidance that reflects the agreed practice model, and constructing a virtual college based on a situated learning model.
AB  - METHODS: A volunteer sample of link nurses took part in telephone interviews exploring experiences of using the virtual college and the extent to which the description of gerontological nursing and the first best practice statement on nutrition had influenced practice.
AB  - FINDINGS: Five components (themes) were identified as facilitating the attainment of evidence-based practice. These focussed on confidence-building and the positive benefits of achieving vision and clarity for gerontological nursing. Membership of a national Community of Practice afforded status and strengthened sense of professional identity. The inclusive knowledge synthesis methodology used to prepare, pilot and support implementation of the best practice statement was highly valued. Progress towards evidence-based practice in all affiliated areas was reported. Major challenges for nurses in participating in the virtual college included the absence of a learning-at-work culture, lack of time and doubts about the legitimacy of internet-based learning.
AB  - CONCLUSION: The evaluation indicates the potential merits of e-practice development, particularly for nurses who feel geographically and professionally isolated or disenchanted with available continuing professional development opportunities. Participation in the virtual college appeared to enrich practice and foster a culture of change.
PT  - Evaluation Study
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15788076
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15788076&id=doi:10.1111%2Fj.1365-2648.2005.03371.x&issn=0309-2402&isbn=&volume=50&issue=2&spage=124&pages=124-33&date=2005&title=Journal+of+Advanced+Nursing&atitle=Progressing+evidence-based+practice%3A+an+effective+nursing+model%3F.&aulast=Tolson&pid=%3Cauthor%3ETolson+D%3C%2Fauthor%3E%3CAN%3E15788076%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<348. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15680618
TI  - An exploration of the caring attributes and perceptions of work place change among gerontological nursing staff in England, Scotland and China (Hong Kong).
SO  - International Journal of Nursing Studies. 42(2):197-209, 2005 Feb.
VI  - 1
ST  - MEDLINE
AU  - Schofield I
AU  - Tolson D
AU  - Arthur D
AU  - Davies S
AU  - Nolan M
FA  - Schofield, Irene
FA  - Tolson, Debbie
FA  - Arthur, David
FA  - Davies, Sue
FA  - Nolan, Mike
IN  - Schofield, Irene. Glasgow Caledonian University, Cowcaddens Road, Glasgow G4 OBA, UK. i.schofield@gcal.ac.uk
AB  - This study investigates caring attributes and perceptions of work place change among qualified and unqualified nursing staff working with older people in three countries. A Modified Caring Attributes Questionnaire and Perception of Workplace Change Schedule were administered to 737 staff. Caring attributes scores were highest for nurses working in long stay settings, and lowest in nurses aged 25-29 years. Nurses in Hong Kong appear better educated than UK counterparts. Staff development seemed more common in long stay settings. Results suggest workplace changes limiting care quality were more pronounced in Scotland. Reported job satisfaction and moral were lowest in the UK group.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15680618
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15680618&id=doi:10.1016%2Fj.ijnurstu.2004.06.002&issn=0020-7489&isbn=&volume=42&issue=2&spage=197&pages=197-209&date=2005&title=International+Journal+of+Nursing+Studies&atitle=An+exploration+of+the+caring+attributes+and+perceptions+of+work+place+change+among+gerontological+nursing+staff+in+England%2C+Scotland+and+China+%28Hong+Kong%29.&aulast=Schofield&pid=%3Cauthor%3ESchofield+I%3C%2Fauthor%3E%3CAN%3E15680618%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<349. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15582639
TI  - An evaluation of the first year of family health nursing practice in Scotland.
SO  - International Journal of Nursing Studies. 42(1):47-59, 2005 Jan.
VI  - 1
ST  - MEDLINE
AU  - Macduff C
AU  - West BJ
FA  - Macduff, Colin
FA  - West, Bernice J M
IN  - Macduff, Colin. Centre for Nurse Practice Research and Development, The Robert Gordon University, Garthdee Road, Aberdeen AB10 7QG, UK. c.macduff@rgu.ac.uk
AB  - Scotland has led enactment of the new World Health Organisation (Europe) Family Health Nurse (FHN) concept. This paper presents research which evaluated the initial operation and impact of the role in remote and rural regions of Scotland. Through use of a multiplex research design informed by ideas from realistic evaluation, fourth generation evaluation and case study research, an initial typology of practice was constructed. The new FHN role typically supplemented, rather than supplanted, pre-existing community nursing services. Implications arising from key findings are discussed in relation to Scottish, UK and European nursing and primary care perspectives.
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2005
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med6&AN=15582639
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15582639&id=doi:10.1016%2Fj.ijnurstu.2004.05.003&issn=0020-7489&isbn=&volume=42&issue=1&spage=47&pages=47-59&date=2005&title=International+Journal+of+Nursing+Studies&atitle=An+evaluation+of+the+first+year+of+family+health+nursing+practice+in+Scotland.&aulast=Macduff&pid=%3Cauthor%3EMacduff+C%3C%2Fauthor%3E%3CAN%3E15582639%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<350. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15615170
TI  - Perspectives of cultural competence in health care.
SO  - Nursing Standard. 19(11):33-8, 2004 Nov 24-30.
VI  - 1
ST  - MEDLINE
AU  - Leishman J
FA  - Leishman, June
IN  - Leishman, June. School of Social and Health Sciences, University of Abertay Dundee, Dundee. j.leishman@abertay.ac.uk
AB  - AIM: The aim of this study was to explore the views of one group of healthcare professionals on the importance of cultural awareness in healthcare practice.
AB  - METHOD: A qualitative approach was used. Ten nurses of varying age from two counties in Scotland who worked across a range of clinical practice areas were interviewed. The interviews were largely unstructured but included an opening question and prompts for the interviewer
AB  - FINDINGS: A lack of knowledge and understanding was demonstrated by the participants in relation to the diverse cultural groups who constitute the population of this country, and a gap in nurse education and training provision across a range of healthcare areas.
AB  - CONCLUSION: Nursing curricula need to include more knowledge and learning about cultural awareness, and nurses need more practical experience of caring for patients from different cultures. The findings assisted in the development of a framework for nurse education that embraces the concept of cultural competency.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15615170
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15615170&id=doi:10.7748%2Fns2004.11.19.11.33.c3764&issn=0029-6570&isbn=&volume=19&issue=11&spage=33&pages=33-8&date=2004&title=Nursing+Standard&atitle=Perspectives+of+cultural+competence+in+health+care.&aulast=Leishman&pid=%3Cauthor%3ELeishman+J%3C%2Fauthor%3E%3CAN%3E15615170%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<351. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15549002
TI  - Identifying the palliative care role of the nurse working in community hospitals: an exploratory study.
SO  - International Journal of Palliative Nursing. 10(9):426-34, 2004 Sep.
VI  - 1
ST  - MEDLINE
AU  - Hamilton F
AU  - McDowell J
FA  - Hamilton, Faye
FA  - McDowell, Joan
IN  - Hamilton, Faye. Palliative Services, Perth and Kinross, Blair Hospital, Muirhall Road, Perth PH2 7BH, UK. faye.hamilton@tpct.scot.nhs.uk
AB  - AIM: to ascertain registered nurses' and GPs' perceptions of and influences on the nurse's role in providing palliative care in community hospitals.
AB  - DESIGN: qualitative exploratory/descriptive study.
AB  - SETTING: two community hospital sites within Perth and Kinross, Scotland.
AB  - METHOD: taped semi-structured interviews with four registered nurses and two GPs. Participants ' perceptions were sought on the roles of nursing and medical professionals and of factors facilitating and hindering the provision of palliative care within the community hospital setting.
AB  - FINDINGS: six key themes were identified through thematic analysis of the information: communication, teamwork and relationships, holistic care, resources, culture, professional role.
AB  - CONCLUSION: the themes were inter-related and gave valuable insight into the multidimensional nature and significance of the nurse's role in palliative care in the community hospital setting.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15549002
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15549002&id=doi:10.12968%2Fijpn.2004.10.9.16047&issn=1357-6321&isbn=&volume=10&issue=9&spage=426&pages=426-34&date=2004&title=International+Journal+of+Palliative+Nursing&atitle=Identifying+the+palliative+care+role+of+the+nurse+working+in+community+hospitals%3A+an+exploratory+study.&aulast=Hamilton&pid=%3Cauthor%3EHamilton+F%3C%2Fauthor%3E%3CAN%3E15549002%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<352. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15493764
TI  - Evaluating a project to improve care of older people in Scotland.
SO  - Nursing Times. 100(38):34-6, 2004 Sep 21-27.
VI  - 1
ST  - MEDLINE
AU  - McDonach E
AU  - Kydd A
FA  - McDonach, Eileen
FA  - Kydd, Angela
IN  - McDonach, Eileen. University of Dundee.
AB  - This is the second of two articles on an innovative pilot study in Scotland attempting to promote evidence-based practice in the nursing care of older people in a variety of residential care settings. This article documents findings from a qualitative process evaluation of the experiences of the eight nurse clinicians who participated in the pilot. The evaluation provided valuable insights into how future schemes might be enhanced.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15493764
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15493764&id=doi:&issn=0954-7762&isbn=&volume=100&issue=38&spage=34&pages=34-6&date=2004&title=Nursing+Times&atitle=Evaluating+a+project+to+improve+care+of+older+people+in+Scotland.&aulast=McDonach&pid=%3Cauthor%3EMcDonach+E%3C%2Fauthor%3E%3CAN%3E15493764%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<353. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15485150
TI  - Setting up a project to improve care of older people in Scotland.
SO  - Nursing Times. 100(37):40-3, 2004 Sep 14-20.
VI  - 1
ST  - MEDLINE
AU  - Kydd A
FA  - Kydd, Angela
IN  - Kydd, Angela. School of Health, Nursing and Midwifery, University of Paisley.
AB  - This is the first of two articles which describe the 'Developing as a centre of excellence project' at the School of Health, Nursing and Midwifery at the University of Paisley. The aim of the project was to enhance good gerontological care by creating a partnership between clinicians and academic staff.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15485150
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15485150&id=doi:&issn=0954-7762&isbn=&volume=100&issue=37&spage=40&pages=40-3&date=2004&title=Nursing+Times&atitle=Setting+up+a+project+to+improve+care+of+older+people+in+Scotland.&aulast=Kydd&pid=%3Cauthor%3EKydd+A%3C%2Fauthor%3E%3CAN%3E15485150%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<354. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15465174
TI  - An evaluation of an educational programme to prepare family health nurses.
SO  - Nurse Education Today. 24(7):575-83, 2004 Oct.
VI  - 1
ST  - MEDLINE
AU  - Macduff C
AU  - West BJ
FA  - Macduff, Colin
FA  - West, Bernice J M
IN  - Macduff, Colin. Centre for Nurse Practice Research and Development, The Robert Gordon University, Garthdee Road, Aberdeen AB10 7QG, UK. c.macduff@rgu.ac.uk
AB  - In 1998 the World Health Organisation (WHO) Europe proposed a new type of community based nurse called the family health nurse (FHN). Although it was initially envisaged that 18 European countries would take part in the development of the FHN role through parallel processes of education and implementation, Scotland has been significantly ahead of other countries in enacting this plan. A pilot project involving community nurses from four remote and rural regions of Scotland was conducted between 2001 and 2003. A Scottish University was commissioned to provide a degree-level course for registered nurses with a minimum of two years post-registration qualifying experience. This paper summarises the main findings and issues arising from an external research evaluation of this educational programme. The programme was found to differ substantially in focus and format from other specialist community nursing programmes available in Scotland. Moreover there were key differences from the curriculum proposed by WHO Europe, in that there was more grounding in North American family nursing models and less focus on management and leadership. This customized degree programme provides a precedent for other educational providers in the UK to reconsider their approach to specialist practice degree level education.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15465174
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15465174&id=doi:10.1016%2Fj.nedt.2004.08.001&issn=0260-6917&isbn=&volume=24&issue=7&spage=575&pages=575-83&date=2004&title=Nurse+Education+Today&atitle=An+evaluation+of+an+educational+programme+to+prepare+family+health+nurses.&aulast=Macduff&pid=%3Cauthor%3EMacduff+C%3C%2Fauthor%3E%3CAN%3E15465174%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<355. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15327659
TI  - 'From the sphere of Sarah Gampism':The professionalisation of nursing and midwifery in the Colony of Victoria.
SO  - Nursing Inquiry. 11(3):192-201, 2004 Sep.
VI  - 1
ST  - MEDLINE
AU  - Grehan M
FA  - Grehan, Madonna
IN  - Grehan, Madonna. School of Nursing, University of Melbourne, Melbourne, Victoria, Australia. m.grehan@pgrad.unimelb.edu.au
AB  - In the nineteenth century, while the Colony of Victoria was still a fledgling settlement, many of the hospitals of England, Scotland, Ireland, and Europe had instituted forms of nursing and midwifery training. When graduates of these training schemes emigrated to Australia with their knowledge, skills and experience, they found health practice to be haphazard and lacking in organisational standards. Individual immigrant women rose to prominence as managers of Victorian hospitals, and superintendents of homes for trained nurses. Through professional networks of their peers and compatriots, these women succeeded in placing the profession of nursing on a firm footing, and were instrumental in the emergence of professional organisations for trained nurses and midwives in Victoria, including the Melbourne District Nursing Society, the short-lived Nurses Association of Australasia (1892), and the Victorian Trained Nurses Association (1901). Their leadership was to have a profound influence on the way nursing and midwifery were regulated in twentieth century Victoria. In this historical review, we trace the movement to professionalise nursing and midwifery which emerged in the Colony of Victoria during the late nineteenth and early twentieth centuries.
PT  - Historical Article
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15327659
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15327659&id=doi:10.1111%2Fj.1440-1800.2004.00222.x&issn=1320-7881&isbn=&volume=11&issue=3&spage=192&pages=192-201&date=2004&title=Nursing+Inquiry&atitle=%27From+the+sphere+of+Sarah+Gampism%27%3AThe+professionalisation+of+nursing+and+midwifery+in+the+Colony+of+Victoria.&aulast=Grehan&pid=%3Cauthor%3EGrehan+M%3C%2Fauthor%3E%3CAN%3E15327659%3C%2FAN%3E%3CDT%3EHistorical+Article%3C%2FDT%3E

<356. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15269645
TI  - Family health nursing: the education programme for the WHO Europe Scottish Pilot.
SO  - British Journal of Community Nursing. 9(6):245-50, 2004 Jun.
VI  - 1
ST  - MEDLINE
AU  - Murray I
FA  - Murray, Ian
IN  - Murray, Ian. Family Health Nurse Programme, University of Stirling, Scotland. ian.murray@stir.ac.uk
AB  - This article outlines the development of the family health nurse (FNH) programme, which was delivered by the University of Stirling in the highlands and islands of Scotland as part of a World Health Organization European pilot project. An outline of the structure of the programme and its key features is described. The concept of the FHN emerged from the WHO's initiative to develop a practitioner who has the family as the organizing focus of their practice (WHO, 2000). An insight is provided into the experience of the first students to undergo this programme, along with a brief summary of the main findings of the external evaluation of both the education programme and the implementation of the role in the remote and rural communities of the highlands and islands of Scotland. Suggestions are made that will hopefully influence the second phase of this project that the Scottish Executive are supporting in an urban setting, which is due to begin in September 2004.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15269645
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15269645&id=doi:10.12968%2Fbjcn.2004.9.6.13119&issn=1462-4753&isbn=&volume=9&issue=6&spage=245&pages=245-50&date=2004&title=British+Journal+of+Community+Nursing&atitle=Family+health+nursing%3A+the+education+programme+for+the+WHO+Europe+Scottish+Pilot.&aulast=Murray&pid=%3Cauthor%3EMurray+I%3C%2Fauthor%3E%3CAN%3E15269645%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<357. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15245860
TI  - A comparative study of the course-related family and financial problems of mature nursing students in Scotland and Australia.
SO  - Nurse Education Today. 24(5):373-81, 2004 Jul.
VI  - 1
ST  - MEDLINE
AU  - Cuthbertson P
AU  - Lauder W
AU  - Steele R
AU  - Cleary S
AU  - Bradshaw J
FA  - Cuthbertson, Philip
FA  - Lauder, William
FA  - Steele, Rebekah
FA  - Cleary, Sonja
FA  - Bradshaw, Julie
IN  - Cuthbertson, Philip. Department of Nursing and Midwifery, University of Stirling, Stirling, Scotland, UK. p.g.cuthbertson@stir.ac.uk
AB  - This study reports a comparative survey of mature students undertaking pre-registration undergraduate nursing education in Australia and Scotland. The study aimed to explore comparisons between the course-related and course-related financial difficulties faced by mature students in two very different educational and funding systems. Financial stress is a predictor of both physical and mental health problems. A similar pattern of course-related problems were reported by both Australian and Scottish students with the exception that Scottish students experienced more problems with childcare and caring for elderly relatives. Course-related problems may be inherent in the nature of undergraduate nursing education although the relatively time-intensive nature of Scottish curricula may explain the childcare and elderly relatives difference. Scottish students reported higher overall financial-related problems but Australian students reported more problems with funding placements. These findings have implications for both curriculum designers and policy makers.
PT  - Comparative Study
PT  - Journal Article
PT  - Multicenter Study
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15245860
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15245860&id=doi:10.1016%2Fj.nedt.2004.03.005&issn=0260-6917&isbn=&volume=24&issue=5&spage=373&pages=373-81&date=2004&title=Nurse+Education+Today&atitle=A+comparative+study+of+the+course-related+family+and+financial+problems+of+mature+nursing+students+in+Scotland+and+Australia.&aulast=Cuthbertson&pid=%3Cauthor%3ECuthbertson+P%3C%2Fauthor%3E%3CAN%3E15245860%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<358. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15209146
TI  - Monitoring mortality in general practice in Grampian, Scotland.
SO  - Scottish Medical Journal. 49(2):66-8, 2004 May.
VI  - 1
ST  - MEDLINE
AU  - Nimmo AW
AU  - Peterkin G
AU  - Coid DR
FA  - Nimmo, A W
FA  - Peterkin, G
FA  - Coid, D R
IN  - Nimmo, A W. Department of Public Health, Grampian NHS Board, Summerfield House, 2 Eday Road, Aberdeen.
AB  - Information on the distribution of mortality and morbidity in general practice is scarce, and not easily accessible either by health authorities or individual general practices. Although the assessment of population mortality is a standard public health measure, colleagues in public health, information sciences and general practice rarely undertake such activity related to general practice populations. Mortality information can be used for various purposes. Examples are providing background data for clinical audits or alerting practitioners to quality issues in the healthcare industry or even suggesting environmental hazards. We measured the experience of mortality in all generally practices in Grampian in the years 1991 to 1999. All practices were notified of their actual and expected mortality over this period of time and asked for comment. Only three general practices had excess mortality experience in both the periods 1991 to 1995 and 1996 to 1999. Only a minority of practices commented on the results. It appears that a high presence of nursing homes in a practice might skew the results; this phenomenon will be central to further inquiry. Future methodology for recording death in general practice should take account of this, as well as providing an account of the qualitative aspects of patients' need for a dignified satisfactory death.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15209146
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15209146&id=doi:10.1177%2F003693300404900209&issn=0036-9330&isbn=&volume=49&issue=2&spage=66&pages=66-8&date=2004&title=Scottish+Medical+Journal&atitle=Monitoring+mortality+in+general+practice+in+Grampian%2C+Scotland.&aulast=Nimmo&pid=%3Cauthor%3ENimmo+AW%3C%2Fauthor%3E%3CAN%3E15209146%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<359. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15189418
TI  - Paediatric oncology nurse education: the development of a national framework.
SO  - Journal of Clinical Nursing. 13(5):646-54, 2004 Jul.
VI  - 1
ST  - MEDLINE
AU  - Tomlinson D
FA  - Tomlinson, Deborah
IN  - Tomlinson, Deborah. Nursing Studies, University of Edinburgh, 31 Buccleuch Place, Edinburgh EH8 9JT, Scotland, UK. deborah.tomlinson@ed.ac.uk
AB  - BACKGROUND: It is recognized that there is a need for specialist nursing courses in a range of paediatric nursing specialities. Paediatric oncology nurses are facing challenges with clinical advances and the need for specialized care. At present there are no available courses in Scotland offering preparation for nurses working in a paediatric oncology setting.
AB  - AIMS AND OBJECTIVES: This project, supported by Macmillan Cancer Relief, addresses this deficit by developing a comprehensive framework for a small and widely dispersed speciality.
AB  - METHODS: Information on the needs and expectations of nurses and service managers in this field was obtained through postal questionnaires and focus groups. Due to the need for collaboration between higher educational institutions and service colleagues the views of educators were also established through questionnaires and semi-structured interviews.
AB  - RESULTS: Problematic practice issues were cited and these issues were further discussed and recognized as the main educational needs. Availability and accessibility of education were of great importance.
AB  - CONCLUSION: The framework developed aims to provide ongoing opportunities for continuing professional development within this speciality. Development of the educational framework is required to provide a course accessible to a wide geographical area of nurses.
AB  - RELEVANCE TO CLINICAL PRACTICE: A National Framework for Paediatric Oncology Nurse Education was developed in response to views of experts working in the field, to the views of other stakeholders and to what is known about needs and preferences of children with cancer and their families.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15189418
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15189418&id=doi:10.1111%2Fj.1365-2702.2004.00917.x&issn=0962-1067&isbn=&volume=13&issue=5&spage=646&pages=646-54&date=2004&title=Journal+of+Clinical+Nursing&atitle=Paediatric+oncology+nurse+education%3A+the+development+of+a+national+framework.&aulast=Tomlinson&pid=%3Cauthor%3ETomlinson+D%3C%2Fauthor%3E%3CAN%3E15189418%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<360. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15150450
TI  - Perceptions of spiritual care among nurses undertaking postregistration education.
SO  - International Journal of Palliative Nursing. 10(4):162-71, 2004 Apr.
VI  - 1
ST  - MEDLINE
AU  - Milligan S
FA  - Milligan, Stuart
IN  - Milligan, Stuart. School of Health, Nursing and Midwifery, University of Paisley, Paisley, PA1 2BE, UK. stuart.milligan@paisley.ac.uk
AB  - Previous research has suggested that qualified nurses recognize that patients have spiritual needs and consider meeting those needs to be important. However, there is also evidence suggesting that nurses feel ill prepared for, and uncertain about, their role as spiritual care providers. A questionnaire on spiritual care and the nurse's role was distributed to a group of 59 registered nurses (of varying ages and levels of experience) undertaking a palliative care module as part of a post-registration degree programme in Scotland. The findings demonstrated that respondents regarded spiritual care as important, especially for certain patient groups. They also thought nurses had a significant responsibility in spiritual caregiving. Individuals varied in how difficult they found identifying patients in need of spiritual care and in meeting those needs. However, analysis of responses revealed considerable insight into possible signs of patient need, examples of nursing interventions and potential barriers to effective spiritual care. Some areas of relative lack of knowledge were identified and may indicate where future efforts to raise awareness of spiritual care among similar groups of nurses should be concentrated.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15150450
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15150450&id=doi:10.12968%2Fijpn.2004.10.4.12792&issn=1357-6321&isbn=&volume=10&issue=4&spage=162&pages=162-71&date=2004&title=International+Journal+of+Palliative+Nursing&atitle=Perceptions+of+spiritual+care+among+nurses+undertaking+postregistration+education.&aulast=Milligan&pid=%3Cauthor%3EMilligan+S%3C%2Fauthor%3E%3CAN%3E15150450%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<361. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15132062
TI  - Evaluating the funding and capacity of research in Scotland.
SO  - Nursing Times. 100(16):36-8, 2004 Apr 20-26.
VI  - 1
ST  - MEDLINE
AU  - Dowding D
AU  - Fyffe T
FA  - Dowding, Dawn
FA  - Fyffe, Theresa
IN  - Dowding, Dawn. Department of Health Sciences, University of York, Hull York Medical School, York.
AB  - This paper will discuss the results of a scoping exercise carried out as part of a strategy to inform subsequent models of infrastructure funding. The exercise showed that Scotland has less research capacity in nursing and midwifery than the UK as a whole. Following the publication of a nursing and midwifery research strategy for Scotland, initiatives are being put in place to fund an increase in research capacity and capability in the nursing and midwifery professions.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15132062
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15132062&id=doi:&issn=0954-7762&isbn=&volume=100&issue=16&spage=36&pages=36-8&date=2004&title=Nursing+Times&atitle=Evaluating+the+funding+and+capacity+of+research+in+Scotland.&aulast=Dowding&pid=%3Cauthor%3EDowding+D%3C%2Fauthor%3E%3CAN%3E15132062%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<362. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 15053121
TI  - Young adults with acquired brain injury in nursing homes in Glasgow.
SO  - Clinical Rehabilitation. 18(2):132-8, 2004 Mar.
VI  - 1
ST  - MEDLINE
AU  - McMillan TM
AU  - Laurie M
FA  - McMillan, T M
FA  - Laurie, M
IN  - McMillan, T M. Department of Psychological Medicine, University of Glasgow, Gartnavel Royal Hospital, 1055 Great Western Road, Glasgow G12 OXH, Scotland, UK. t.m.mcmillan@clinmed.gla.ac.uk
AB  - OBJECTIVE: To survey the characteristics, level of disability and services received by young adults with acquired brain injury (ABI) resident in nursing homes in Greater Glasgow.
AB  - DESIGN: Telephone survey of 75 nursing homes followed by a questionnaire survey and review of medication cardexes. Included were all people under 65 years with ABI resident in nursing homes in Greater Glasgow between 1 February 2000 and 31 January 2001.
AB  - SETTING: Twenty-eight nursing homes in Greater Glasgow, Scotland (population 0.9 million).
AB  - SUBJECTS: Young adults (16-64) with ABI.
AB  - MAIN OUTCOME MEASURES: Structured questionnaire, Barthel Index, Office of Population Census Survey (OPCS) Disability Form, review of medication cardexes.
AB  - RESULTS: Information was obtained on all cases identified in 75 nursing homes. There were 92 people with ABI in 28 nursing homes; 43/92 were in three homes. Only 42 had inpatient rehabilitation preadmission. Severe disability (OPCS categories 7-10) was found in 54 cases and minimal/minor disability (OPCS categories 1-2) in 18. Thirty-two exhibited challenging behaviour, nine of these were physically violent. Homes were staffed by unqualified assistants, supervised by nurses. No home itself offered rehabilitation, but some had accessed an NHS physical disability community team (28/92 cases) or other community teams (5/92). Proactive medical review was uncommon. Medication had been reviewed since admission in a minority (21/92). Most had regular visits from relatives.
AB  - CONCLUSIONS: There is a wide range of disability in nursing home residents in Greater Glasgow. Proactive, routine review of medical, rehabilitation and medication needs is rare, as is rehabilitation pre and post discharge. This is serious given the likelihood of reduced intellectual and/or physical capacity in this population. Nursing homes should have hospital discharge reports that inform about immediate preadmission history, rationale for medication and placement. There is a need for regular and ongoing health service review of nursing home residents including potential for rehabilitation and return to community living.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=15053121
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:15053121&id=doi:10.1191%2F0269215504cr712oa&issn=0269-2155&isbn=&volume=18&issue=2&spage=132&pages=132-8&date=2004&title=Clinical+Rehabilitation&atitle=Young+adults+with+acquired+brain+injury+in+nursing+homes+in+Glasgow.&aulast=McMillan&pid=%3Cauthor%3EMcMillan+TM%3C%2Fauthor%3E%3CAN%3E15053121%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<363. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 14769455
TI  - Teaching sex education: are Scottish school nurses prepared for the challenge?.
SO  - Nurse Education Today. 24(2):113-20, 2004 Feb.
VI  - 1
ST  - MEDLINE
AU  - McFadyen J
FA  - McFadyen, J
IN  - McFadyen, J. School of Nursing Midwifery, Health, University of Paisley, Paisley PAI 2BE, UK. jackie.mcfadyen@paisley.ac.uk
AB  - Teaching sex education to school pupils in Scotland continues to be a controversial issue. In reality there is lack of leadership, strategy and an uncoordinated approach to delivering this important topic. The school nurse is frequently identified as a suitable professional to lead the way because it is assumed that school nurses are well educated in the field of sexual and reproductive health. Nationally, little is known about the educational status of Scottish school nurses and there is no research evidence available from which generalisations can be made. This study aims to explore the educational preparation of school nurses that underpins teaching sex education to school pupils in Scotland. A cross-sectional descriptive study was completed in September 1998. The results confirmed that school nurses in Scotland are predominantly female and 70% of the respondents (n=117) were over the age of 40 years of age. No common basic nursing qualification was identified. The majority of school nurses in Scotland perceive sex education to be part of their role and 39% (n=65) testified that specific sexual health training had been undertaken. Many lack confidence in this area of practice and are aware of extensive educational needs in relation to teaching sexual health and reproductive health. Despite these findings 75% (n=126) were actively involved in teaching sex education to school pupils.
PT  - Journal Article
YR  - 2004
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=14769455
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:14769455&id=doi:10.1016%2Fj.nedt.2003.10.003&issn=0260-6917&isbn=&volume=24&issue=2&spage=113&pages=113-20&date=2004&title=Nurse+Education+Today&atitle=Teaching+sex+education%3A+are+Scottish+school+nurses+prepared+for+the+challenge%3F.&aulast=McFadyen&pid=%3Cauthor%3EMcFadyen+J%3C%2Fauthor%3E%3CAN%3E14769455%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<364. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 14641637
TI  - Developing professional clinical skills for practice - the results of a feasibility study using a reflective approach to intimate examination.
SO  - Medical Education. 37 Suppl 1:34-41, 2003 Nov.
VI  - 1
ST  - MEDLINE
AU  - Ker JS
FA  - Ker, J S
IN  - Ker, J S. Clinical Skills Centre, University of Dundee, UK. j.s.ker@dundee.ac.uk
AB  - OBJECTIVES: To develop a student-selected component (SSC) for junior medical students, to evaluate the feasibility of incorporating the development of skills in carrying out an intimate examination, whilst developing professional thinking skills using a reflective approach.
AB  - SUBJECTS: The student selected component was designed for a maximum of 6 students over a 4-week period in Phase 2 (year 2 and 3) of the undergraduate medical curriculum.
AB  - SETTING: The Clinical Skills Centre, the Faculty of Medicine Nursing and Dentistry, University of Dundee, Scotland, UK.
AB  - METHODS: The SSC consisted of a weekly patient clerking from the ward, an analysis of the clinical and communication skills for any intimate examinations the patient would require, and practice using simulators and simulated patients. Students were supported by timed periods of structured reflection, which enabled them to discuss ethical issues and their own professional conduct related to carrying out an intimate examination. The SSC was evaluated on 3 levels; student satisfaction, learning professional thinking using a reflective approach, and observing behaviour change in relation to skill development, using a ward simulation exercise.
AB  - RESULTS: The evaluation at the levels of student satisfaction, learning professional thinking and changes in behaviour associated with intimate examination demonstrated that the SSC had been well received by the students, who felt they had improved their skills in intimate examinations in the context of a ward simulation exercise, in parallel with their professional thinking skills.
AB  - CONCLUSION: It is possible to develop the professional thinking of junior medical students at the same time as developing their technical competence in relation to intimate examinations. It may be advantageous to introduce students early to this reflective approach, using simulation to promote the integration of theory with practice.
PT  - Journal Article
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=14641637
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:14641637&id=doi:10.1046%2Fj.1365-2923.37.s1.4.x&issn=0308-0110&isbn=&volume=37&issue=1&spage=34&pages=34-41&date=2003&title=Medical+Education&atitle=Developing+professional+clinical+skills+for+practice+-+the+results+of+a+feasibility+study+using+a+reflective+approach+to+intimate+examination.&aulast=Ker&pid=%3Cauthor%3EKer+JS%3C%2Fauthor%3E%3CAN%3E14641637%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<365. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 14639977
TI  - Older nurses and employment decisions.
SO  - Nursing Standard. 18(7):35-40, 2003 Oct 29-Nov 4.
VI  - 1
ST  - MEDLINE
AU  - Watson R
AU  - Manthorpe J
AU  - Andrews J
FA  - Watson, Roger
FA  - Manthorpe, Jill
FA  - Andrews, JoyAnn
IN  - Watson, Roger. School of Nursing, Social Work and Applied Health Studies, University of Hull. r.watson@hull.ac.uk
AB  - AIM: To investigate the options, decisions and outcomes for nurses aged over 50 in terms of remaining in, retiring from, or returning to, work in the NHS.
AB  - METHOD: Interviews were conducted with 18 employers, advisers and policy makers linked to the nursing labour market. They were conducted by telephone (n = 14) or face to face (n = 4), recorded (with consent), transcribed and analysed thematically. Interviews were also held with 84 older nurses who were remaining in nursing, had retired or had returned to nursing. One focus group was held with older nurses who 'remained' in Scotland (n = 11) and the rest of the data were collected in face-to-face and telephone interviews (n = 73). Again, interviews were recorded (with consent), transcribed and analysed thematically.
AB  - RESULTS: There is a gap between the rhetoric of policy and the implementation of practice in the employment of older nurses.
AB  - CONCLUSION: Older nurses could continue to make a valuable contribution to the NHS, especially in light of the shortage of nurses, but their value is not always recognised. If older nurses are to continue making a contribution then they need good advice about employment, retirement and pension options.
PT  - Journal Article
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=14639977
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:14639977&id=doi:10.7748%2Fns2003.10.18.7.35.c3480&issn=0029-6570&isbn=&volume=18&issue=7&spage=35&pages=35-40&date=2003&title=Nursing+Standard&atitle=Older+nurses+and+employment+decisions.&aulast=Watson&pid=%3Cauthor%3EWatson+R%3C%2Fauthor%3E%3CAN%3E14639977%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<366. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 14512859
TI  - An exploratory survey into primary care nurses and dementia care.
SO  - British Journal of Nursing. 12(17):1029-37, 2003 Sep 25-Oct 8.
VI  - 1
ST  - MEDLINE
AU  - Bryans M
AU  - Keady J
AU  - Turner S
AU  - Wilcock J
AU  - Downs M
AU  - Iliffe S
FA  - Bryans, Michelle
FA  - Keady, John
FA  - Turner, Steve
FA  - Wilcock, Jane
FA  - Downs, Murna
FA  - Iliffe, Steve
IN  - Bryans, Michelle. University of Edinburgh, Edinburgh, Scotland, UK.
AB  - This article introduces findings from the first phase of a randomized controlled trial of educational interventions in primary care. The focus of the article is the knowledge, attitudes and confidence of primary care nursing staff to the diagnosis and ongoing management of dementia. A total 78 nurses with a mean age of 46.4 years and a mean time since qualification of 23.0 years were recruited in 36 practices in central Scotland and in London. Disciplines represented by this sample were predominantly district nurses, health visitors, practice nurses and community staff nurses. Each practitioner was administered an extensive self-completion questionnaire before the educational interventions were introduced to measure baseline knowledge, confidence and perceived difficulties in dementia care management and attitudes. Results from the quiz indicate lower levels of knowledge about epidemiology and diagnosis, but slightly higher levels about management strategies. Self-reported ratings of confidence were also low and were directly related to ratings of difficulty in identifying dementia and dealing with coexisting behavioural and mental health problems. Lower scores on all domains were recorded for practice nurses than for district nurses or health visitors.
PT  - Clinical Trial
PT  - Journal Article
PT  - Randomized Controlled Trial
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=14512859
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:14512859&id=doi:10.12968%2Fbjon.2003.12.17.11723&issn=0966-0461&isbn=&volume=12&issue=17&spage=1029&pages=1029-37&date=2003&title=British+Journal+of+Nursing&atitle=An+exploratory+survey+into+primary+care+nurses+and+dementia+care.&aulast=Bryans&pid=%3Cauthor%3EBryans+M%3C%2Fauthor%3E%3CAN%3E14512859%3C%2FAN%3E%3CDT%3EClinical+Trial%3C%2FDT%3E

<367. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12961937
TI  - Best practice in the care of patients with a tracheostomy. [Review] [9 refs]
SO  - Nursing Times. 99(30):24-5, 2003 Jul 29-Aug 4.
VI  - 1
ST  - MEDLINE
AU  - Bond P
AU  - Grant F
AU  - Coltart L
AU  - Elder F
FA  - Bond, Penny
FA  - Grant, Fiona
FA  - Coltart, Lynne
FA  - Elder, Fiona
IN  - Bond, Penny. Falkirk Royal Infirmary, Forth Valley Acute Hospitals NHS Trust.
CM  - Comment in (CIN)
AB  - This article examines the development of a best practice statement on the care of patients with a tracheostomy. It outlines key elements of care, including the context in which care is given. This best practice statement is part of a series of such documents produced by the former Scottish Nursing and Midwifery Practice Development Unit, which has now merged with four other clinical effectiveness organisations to form NHS Quality Improvement Scotland (NHSQIS). [References: 9]
PT  - Journal Article
PT  - Review
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12961937
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12961937&id=doi:&issn=0954-7762&isbn=&volume=99&issue=30&spage=24&pages=24-5&date=2003&title=Nursing+Times&atitle=Best+practice+in+the+care+of+patients+with+a+tracheostomy.&aulast=Bond&pid=%3Cauthor%3EBond+P%3C%2Fauthor%3E%3CAN%3E12961937%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<368. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12752907
TI  - Patients' autonomy in surgical care: a comparison of nurses' perceptions in five European countries.
SO  - International Nursing Review. 50(2):85-94, 2003 Jun.
VI  - 1
ST  - MEDLINE
AU  - Suhonen R
AU  - Valimaki M
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Scott PA
AU  - Kaljonen A
AU  - Arndt M
AU  - Leino-Kilpi H
FA  - Suhonen, R
FA  - Valimaki, M
FA  - Dassen, T
FA  - Gasull, M
FA  - Lemonidou, C
FA  - Scott, P A
FA  - Kaljonen, A
FA  - Arndt, M
FA  - Leino-Kilpi, H
IN  - Suhonen, R. Health Care District of Forssa, Forssa Hospital, Forssa, Finland. suhonen.ritta@kolumbus.fi
AB  - BACKGROUND: This report forms part of the results of an international comparative study funded by the European Commission (1998-2001).
AB  - AIM: To describe and compare the maintenance of patients' autonomy on surgical wards, from the point of view of nursing staff, in five European countries (Finland, Spain, Greece, Germany and Scotland). Autonomy is defined in terms of information received and decision making by patients.
AB  - METHOD: The data were collected using a questionnaire specifically designed for use in this study. Responses (response rate 66%) were obtained from 1280 nurses working on surgical wards. Data analysis was based on descriptive statistics, t-tests, analysis of variance (ANOVA) with posthoc Tukey's HSD test and logistic regression.
AB  - RESULTS: There were clear between-country differences in nurses' perceptions, especially on a north-south axis (Finland and Scotland vs. Greece and Spain), regarding the extent to which the autonomy of surgical patients is supported by nursing staff. Training and ethics education, in particular, were associated with nurses' perceptions of the maintenance of patient autonomy in Finland and Greece.
AB  - CONCLUSION: Further research is needed to establish whether the results obtained are caused by differences in cultures, nursing practices or roles of health-care personnel or patients in different European countries.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12752907
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12752907&id=doi:10.1046%2Fj.1466-7657.2003.00168.x&issn=0020-8132&isbn=&volume=50&issue=2&spage=85&pages=85-94&date=2003&title=International+Nursing+Review&atitle=Patients%27+autonomy+in+surgical+care%3A+a+comparison+of+nurses%27+perceptions+in+five+European+countries.&aulast=Suhonen&pid=%3Cauthor%3ESuhonen+R%3C%2Fauthor%3E%3CAN%3E12752907%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<369. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12682581
TI  - Development of a tissue viability nursing competency framework. [Review] [25 refs]
SO  - British Journal of Nursing. 12(6 Suppl):S38-44, 2003 Mar.
VI  - 1
ST  - MEDLINE
AU  - Finnie A
AU  - Wilson A
FA  - Finnie, Alison
FA  - Wilson, Alice
IN  - Finnie, Alison. Department of Nursing and Midwifery, University of Stirling.
AB  - In 1999, a sub-group of the National Association for Tissue Viability Nurse Specialists (Scotland) agreed to lead the production of a competency framework. The aims were to define tissue viability specialist nursing, to provide a framework for tissue viability nurse specialists (TVNSs) that would form a basis for clinical supervision and mentorship, and to inform curricular for tissue viability education. Using a combination of models, a framework evolved which defines the multifaceted nature of the role. The framework lists competencies, which are further broken down into specific role elements, matched with measurable performance criteria for the TVNS. The competency statements that are provided within the publication describe the attitude, knowledge and skills required to fulfil the TVNS role. The document, 'A Route to Enhanced Competence for Tissue Viability Nurse Specialists', was published in June 2002. This initiative meets the national need for definition of specialist practice and provides a standard by which the public can be assured of quality care from TVNSs in Scotland. [References: 25]
PT  - Journal Article
PT  - Review
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12682581
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12682581&id=doi:10.12968%2Fbjon.2003.12.Sup1.11251&issn=0966-0461&isbn=&volume=12&issue=6&spage=S38&pages=S38-44&date=2003&title=British+Journal+of+Nursing&atitle=Development+of+a+tissue+viability+nursing+competency+framework.&aulast=Finnie&pid=%3Cauthor%3EFinnie+A%3C%2Fauthor%3E%3CAN%3E12682581%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<370. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12641815
TI  - Nursing morale: what is it like and why?.
SO  - Journal of Advanced Nursing. 42(1):82-9, 2003 Apr.
VI  - 1
ST  - MEDLINE
AU  - Callaghan M
FA  - Callaghan, Margaret
IN  - Callaghan, Margaret. MRC Social and Public Health Sciences Unit, University of Glasgow, Glasgow, UK. margaret-c@msoc.mrc.gla.ac.uk
AB  - BACKGROUND: There has been increased concern in the United Kingdom about the problems of recruitment and retention in the nursing profession, and how this is influenced by low morale. Despite this, however, there are relatively few studies, particularly of a qualitative nature, where nurses are asked about their morale and what factors affect it.
AB  - AIMS: The present study aimed to explore nursing morale and determine the factors which nurses believed to influence it. By doing so, it was hoped that factors which affect nurse recruitment and retention could be identified.
AB  - METHODS: Fifty-eight nurses (28 males, 30 females) working in the National Health Service in Scotland were interviewed in depth about their morale and their concerns about their career. Thematic analysis was carried out and a number of main issues emerged.
AB  - FINDINGS: Morale in this group was very low. A large number of nurses were considering leaving the profession and the majority would discourage others from becoming a nurse. The themes that emerged, which related to their disillusionment, included low pay, lack of support for education, limited opportunity for promotion, lack of resources and job insecurity.
AB  - CONCLUSIONS: The findings suggest that while recent salary increases may have helped to improve morale, other factors must also be addressed if further decline in morale and a subsequent nursing shortage is to be avoided.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12641815
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12641815&id=doi:10.1046%2Fj.1365-2648.2003.02582.x&issn=0309-2402&isbn=&volume=42&issue=1&spage=82&pages=82-9&date=2003&title=Journal+of+Advanced+Nursing&atitle=Nursing+morale%3A+what+is+it+like+and+why%3F.&aulast=Callaghan&pid=%3Cauthor%3ECallaghan+M%3C%2Fauthor%3E%3CAN%3E12641815%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<371. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12603764
TI  - Early introduction to interprofessional learning: a simulated ward environment.
SO  - Medical Education. 37(3):248-55, 2003 Mar.
VI  - 1
ST  - MEDLINE
AU  - Ker J
AU  - Mole L
AU  - Bradley P
FA  - Ker, Jean
FA  - Mole, Lesley
FA  - Bradley, Paul
IN  - Ker, Jean. Clinical Skills Centre, University of Dundee, UK. j.s.ker@dundee.ac.uk
AB  - OBJECTIVES: To develop an interprofessional simulated ward environment for junior medical and nursing students and to identify themes for future evaluations and modify criteria for formative assessment of the exercise.
AB  - SUBJECTS: Second year medical and nursing students.
AB  - SETTING: The multiprofessional Clinical Skills Centre at the Faculty of Medicine, and Nursing, University of Dundee, Scotland.
AB  - METHOD: A simulated ward environment was created in the Clinical Skills Centre around patients with common medical conditions. Students were allocated to interprofessional teams and, after a briefing given in the form of a ward report, were asked to take responsibility for the ward for 'a shift'. Observers from the Schools of Medicine and Nursing charted their progress in relation to evidence of collaborative team working, effective leadership, the ability to prioritise workload and competence in clinical performance. Evaluations of the exercise were taken from all participants. The criteria for formative assessment were reviewed by the observers after the exercise and a focus group was used to generate additional criteria and modify those piloted.
AB  - RESULTS: The exercise was perceived positively by all participating groups. Themes for evaluation of future exercises and modified criteria for future assessment were identified.
AB  - CONCLUSIONS: The exercise gave students their first experience of participating independently in a realistic and safe operational ward setting. It proved to be a powerful learning experience for the students.
PT  - Evaluation Study
PT  - Journal Article
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12603764
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12603764&id=doi:10.1046%2Fj.1365-2923.2003.01439.x&issn=0308-0110&isbn=&volume=37&issue=3&spage=248&pages=248-55&date=2003&title=Medical+Education&atitle=Early+introduction+to+interprofessional+learning%3A+a+simulated+ward+environment.&aulast=Ker&pid=%3Cauthor%3EKer+J%3C%2Fauthor%3E%3CAN%3E12603764%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<372. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12581117
TI  - Supporting carers of people diagnosed with schizophrenia: evaluating change in nursing practice following training.
SO  - Journal of Advanced Nursing. 41(3):295-305, 2003 Feb.
VI  - 1
ST  - MEDLINE
AU  - Gall SH
AU  - Atkinson J
AU  - Elliott L
AU  - Johansen R
FA  - Gall, Sheena H
FA  - Atkinson, Jacqueline
FA  - Elliott, Lawrence
FA  - Johansen, Ron
IN  - Gall, Sheena H. School of Nursing and Midwifery, University of Dundee, Dundee, UK. shgall@snm.dundee.ac.uk
AB  - BACKGROUND: United Kingdom legislation and clinical standards for schizophrenia challenge nurses to re-examine the support that they provide to carers. Nurses are in a key position to provide this support but may lack the necessary skills to do so. The training programme evaluated in the present study aimed to address this problem.
AB  - STUDY AIM: To evaluate change in clinical practice brought about by post-registration training for mental health nurses in supporting carers of people diagnosed with schizophrenia.
AB  - DESIGN/METHODS: The study was undertaken in collaboration between the Universities of Dundee and Glasgow, and Tayside National Health Service (NHS) Trust (Scotland). Respondents were nine nurses who completed training and then delivered a planned programme of support to carers. Data on nursing practice were gathered through semi-structured interviews with nurses before training and after providing support. Following the support intervention, carers also commented on the nurses' practice.
AB  - FINDINGS: Eight of the nine nurses reported changes in practice in five key areas: They built collaborative relationships with carers, developed a carer focused approach to their practice, acknowledged and supported the carer role, and made progress in identifying carer needs and accessing resources to meet these needs. Nurses experienced difficulties supporting carers who had mental health problems or previous negative experiences of services. Those who lacked community experience also found it difficult to adjust to working in a community setting. Although clinical supervision helped them to work through these difficulties, they remain largely unresolved.
AB  - CONCLUSIONS: Findings from this study indicate that appropriate training may enable nurses to improve the support provided to carers of people diagnosed with schizophrenia. This study represents an important stage in determining the nature of support offered to carers by nurses. While developed to help nurses to meet clinical standards set for schizophrenia in the UK, findings may have clinical significance for nurses in other countries.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12581117
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12581117&id=doi:10.1046%2Fj.1365-2648.2003.02529.x&issn=0309-2402&isbn=&volume=41&issue=3&spage=295&pages=295-305&date=2003&title=Journal+of+Advanced+Nursing&atitle=Supporting+carers+of+people+diagnosed+with+schizophrenia%3A+evaluating+change+in+nursing+practice+following+training.&aulast=Gall&pid=%3Cauthor%3EGall+SH%3C%2Fauthor%3E%3CAN%3E12581117%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<373. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12572761
TI  - Perceptions of autonomy, privacy and informed consent in the care of elderly people in five European countries: comparison and implications for the future.
SO  - Nursing Ethics. 10(1):58-66, 2003 Jan.
VI  - 1
ST  - MEDLINE
AU  - Leino-Kilpi H
AU  - Valimaki M
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Scott PA
AU  - Schopp A
AU  - Arndt M
AU  - Kaljonen A
FA  - Leino-Kilpi, Helena
FA  - Valimaki, Maritta
FA  - Dassen, Theo
FA  - Gasull, Maria
FA  - Lemonidou, Chryssoula
FA  - Scott, P Anne
FA  - Schopp, Anja
FA  - Arndt, Marianne
FA  - Kaljonen, Anne
IN  - Leino-Kilpi, Helena. Department of Nursing Science, University of Turku, Finland. Helena.Leino-Kilpi@utu.fi
OI  - Source: KIE. 108472
AB  - This article discusses nurses' and elderly patients' perceptions of the realization of autonomy, privacy and informed consent in five European countries. Comparisons between the concepts and the countries indicated that both nurses and patients gave the highest ratings to privacy and the lowest to informed consent. There were differences between countries. According to the patient data, autonomy is best realized in Spain, privacy in the UK (Scotland), and informed consent in Finland. For the staff data, the best results tended to concentrate in the UK. The conceptual and methodological limitations of the study are identified and discussed. Implications of the results are divided into three areas: nursing practice, education and research. In practice, the analysis of patients' values and the ethical sensitivity of nurses are important as part of ethically good care. In nurse education, students should learn to recognize ethical problems, generally and particularly, among vulnerable groups of patients. Multicultural international research is needed in this area. This is the last of a set of five articles published together in this issue of Nursing Ethics in which the results of this comparative research project are presented.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12572761
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12572761&id=doi:10.1191%2F0969733003ne575oa&issn=0969-7330&isbn=&volume=10&issue=1&spage=58&pages=58-66&date=2003&title=Nursing+Ethics&atitle=Perceptions+of+autonomy%2C+privacy+and+informed+consent+in+the+care+of+elderly+people+in+five+European+countries%3A+comparison+and+implications+for+the+future.&aulast=Leino-Kilpi&pid=%3Cauthor%3ELeino-Kilpi+H%3C%2Fauthor%3E%3CAN%3E12572761%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<374. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12572760
TI  - Perceptions of informed consent in the care of elderly people in five European countries.
SO  - Nursing Ethics. 10(1):48-57, 2003 Jan.
VI  - 1
ST  - MEDLINE
AU  - Schopp A
AU  - Valimaki M
AU  - Leino-Kilpi H
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Scott PA
AU  - Arndt M
AU  - Kaljonen A
FA  - Schopp, Anja
FA  - Valimaki, Maritta
FA  - Leino-Kilpi, Helena
FA  - Dassen, Theo
FA  - Gasull, Maria
FA  - Lemonidou, Chryssoula
FA  - Scott, P Anne
FA  - Arndt, Marianne
FA  - Kaljonen, Anne
IN  - Schopp, Anja. Humbolt University, Berlin, Germany.
OI  - Source: KIE. 108473
AB  - The focus of this article is on elderly patients' and nursing staff perceptions of informed consent in the care of elderly patients/residents in five European countries. The results suggest that patients and nurses differ in their views on how informed consent is implemented. Among elderly patients the highest frequency for securing informed consent was reported in Finland; the lowest was in Germany. In contrast, among nurses, the highest frequency was reported in the UK (Scotland) and the lowest in Finland. In a comparison of patients' and nurses' perceptions, nurses had more positive views than patients in all countries except Finland. Patients with less need for nursing interventions in Greece and Spain gave their consent less often. The German and Greek patients were older, and the results also point to an association between this and their lower frequency of giving consent. In Spain, patients who were married or who had a family member or friend to look after their personal affairs were more likely to be included in the group whose consent was sought less often. This is the fourth of a set of five articles published together in this issue of Nursing Ethics in which the results of this comparative research project are presented.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12572760
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12572760&id=doi:10.1191%2F0969733003ne574oa&issn=0969-7330&isbn=&volume=10&issue=1&spage=48&pages=48-57&date=2003&title=Nursing+Ethics&atitle=Perceptions+of+informed+consent+in+the+care+of+elderly+people+in+five+European+countries.&aulast=Schopp&pid=%3Cauthor%3ESchopp+A%3C%2Fauthor%3E%3CAN%3E12572760%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<375. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12572759
TI  - Perceptions of privacy in the care of elderly people in five European countries.
SO  - Nursing Ethics. 10(1):39-47, 2003 Jan.
VI  - 1
ST  - MEDLINE
AU  - Schopp A
AU  - Leino-Kilpi H
AU  - Valimaki M
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Scott PA
AU  - Arndt M
AU  - Kaljonen A
FA  - Schopp, Anja
FA  - Leino-Kilpi, Helena
FA  - Valimaki, Maritta
FA  - Dassen, Theo
FA  - Gasull, Maria
FA  - Lemonidou, Chryssoula
FA  - Scott, P Anne
FA  - Arndt, Marianne
FA  - Kaljonen, Anne
IN  - Schopp, Anja. Humbolt University, Berlin, Germany.
OI  - Source: KIE. 108477
AB  - The focus of this article is on elderly patients' and nursing staff perceptions of privacy in the care of elderly patients/residents in five European countries. Privacy includes physical, social and informational elements. The results show that perceptions of privacy were strongest in the UK (Scotland) and weakest in Greece. Country comparisons revealed statistically significant differences between the perceptions of elderly patients and also between those of nurses working in the same ward or long-term care facility. Perceptions of privacy by patients and their nursing staff were quite similar in Finland, Germany and the UK. In contrast, in Greece and Spain these perceptions were different: nurses believed that they took account of their patients' privacy needs more often than the patients themselves felt this was the case. Among Spanish and UK patients, an association was found between lower levels of independence and comparatively less positive perceptions of privacy. No associations were established between nurses' perceptions and their demographic factors. This is the third of a set of five articles published together in this issue of Nursing Ethics in which the results of this comparative research project are presented.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12572759
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12572759&id=doi:10.1191%2F0969733003ne573oa&issn=0969-7330&isbn=&volume=10&issue=1&spage=39&pages=39-47&date=2003&title=Nursing+Ethics&atitle=Perceptions+of+privacy+in+the+care+of+elderly+people+in+five+European+countries.&aulast=Schopp&pid=%3Cauthor%3ESchopp+A%3C%2Fauthor%3E%3CAN%3E12572759%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<376. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12572757
TI  - Perceptions of autonomy, privacy and informed consent in the care of elderly people in five European countries: general overview.
SO  - Nursing Ethics. 10(1):18-27, 2003 Jan.
VI  - 1
ST  - MEDLINE
AU  - Leino-Kilpi H
AU  - Valimaki M
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Schopp A
AU  - Scott PA
AU  - Arndt M
AU  - Kaljonen A
FA  - Leino-Kilpi, Helena
FA  - Valimaki, Maritta
FA  - Dassen, Theo
FA  - Gasull, Maria
FA  - Lemonidou, Chryssoula
FA  - Schopp, Anja
FA  - Scott, P Anne
FA  - Arndt, Marianne
FA  - Kaljonen, Anne
IN  - Leino-Kilpi, Helena. Department of Nursing Science, University of Turku, Finland. Helena.Leino-Kilpi@utu.fi
OI  - Source: KIE. 108471
AB  - Ethical issues in the care of elderly people have been identified in many countries. We report the findings of a comparative research project funded by the European Commission, which took place between 1998 and 2001. The project explored the issues of autonomy (part I), privacy (part II) and informed consent (part III) in nursing practice. Data were collected from elderly residents/patients (n = 573) and nursing staff (n = 887) in five European countries: Finland, Spain, Greece, Germany and the UK (Scotland). Questionnaires were used as the data collection tool (self-completion questionnaires for staff, structured interviews for the elderly participants). Four basic nursing interventions in the care of elderly people were targeted: hygiene, fluid intake and nutrition, medication, and elimination. The data were analysed statistically. The results indicated differences within all five countries between staff and patient perceptions of autonomy, privacy and informed consent. There were also similar differences between individual countries. Conclusions were reached concerning practice, education and research. This is the first of a set of five articles published together in this issue of Nursing Ethics in which the results of this comparative research project are presented.
PT  - Comparative Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12572757
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12572757&id=doi:10.1191%2F0969733003ne571oa&issn=0969-7330&isbn=&volume=10&issue=1&spage=18&pages=18-27&date=2003&title=Nursing+Ethics&atitle=Perceptions+of+autonomy%2C+privacy+and+informed+consent+in+the+care+of+elderly+people+in+five+European+countries%3A+general+overview.&aulast=Leino-Kilpi&pid=%3Cauthor%3ELeino-Kilpi+H%3C%2Fauthor%3E%3CAN%3E12572757%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<377. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12533368
TI  - Impact of a newly opened prison on an accident and emergency department.
SO  - Emergency Medicine Journal. 20(1):48-51, 2003 Jan.
VI  - 1
ST  - MEDLINE
AU  - Boyce SH
AU  - Stevenson J
AU  - Jamieson IS
AU  - Campbell S
FA  - Boyce, S H
FA  - Stevenson, J
FA  - Jamieson, I S
FA  - Campbell, S
IN  - Boyce, S H. Accident and Emergency Department, Crosshouse Hospital, Kilmarnock, Scotland. steveboyce_scotland@yahoo.com
AB  - OBJECTIVE: To determine the impact of a newly opened prison on an accident and emergency (A&E) department.
AB  - METHOD: A new category B prison opened in April 1999, the first privately run prison in Scotland and the third largest in population. All prisoners referred to the A&E department for treatment were identified prospectively during the first year after the opening of the prison.
AB  - RESULTS: 99 prisoners and four members of staff attended during the one year period. Ages ranged from 18-64 years with a mean age of 29.8 years. Presentations were as a result of deliberate self harm (22%), injury after violence (18%), sports injury (15%), surgical condition (15%), medical illness (13%), accidental injury (9%), ENT problem (2%), and miscellaneous (6%). Thirty seven prisoners (35.6%) were admitted to the hospital. Further review at outpatient clinics was arranged for 15 prisoners. One prisoner died, the result of suicide by hanging. The remaining prisoners were returned to the prison for further management by the prison medical and nursing team. Twelve prisoners re-attended a total of 37 times, ranging from twice to a maximum of eight visits. Some 42.3% of attendances were during "working hours" (09.00-17.00) and 57.7% attended "out of hours" (17.00-09.00). Twenty four referrals (23.1%) were deemed inappropriate by the prison medical team on retrospective review. Sixteen of these occurred "out of hours". Forty one prisoners (39.4%) were known to have a history of injecting drug misuse. Including re-attenders, 59 presentations (56.7%) to the A&E department had a history of injecting drug misuse. Of these 41 prisoners, 11 (26.8%) were hepatitis C positive, with eight of these having a positive polymerase chain reaction test. No prisoners had HIV and only one prisoner was hepatitis B positive.
AB  - CONCLUSION: The opening of the prison resulted in only a slight increase in the workload of the A&E department. A significant proportion of prisoners were admitted to the hospital highlighting the practical and logistical problems of managing people restrained and in custody. Most cases can be safely referred back to the prison. Increased input is required from the prison medical team when dealing with deliberate self harm, frequent attenders, and "out of hours" referrals. All A&E staff must be aware of the increased risk of hepatitis C infection when dealing with a confined prison population.
PT  - Journal Article
YR  - 2003
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med5&AN=12533368
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12533368&id=doi:10.1136%2Femj.20.1.48&issn=1472-0205&isbn=&volume=20&issue=1&spage=48&pages=48-51&date=2003&title=Emergency+Medicine+Journal&atitle=Impact+of+a+newly+opened+prison+on+an+accident+and+emergency+department.&aulast=Boyce&pid=%3Cauthor%3EBoyce+SH%3C%2Fauthor%3E%3CAN%3E12533368%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<378. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12664763
TI  - Information for community hospitals.
SO  - Health Bulletin. 60(1):13-9, 2002 Jan.
VI  - 1
ST  - MEDLINE
AU  - Urquhart J
AU  - Graham BJ
AU  - Ward A
AU  - Greig H
FA  - Urquhart, J
FA  - Graham, B J M
FA  - Ward, A
FA  - Greig, H
IN  - Urquhart, J. ISD Scotland, Information and Statistics Division, Trinity Park House, S. Trinity Road, Edinburgh.
AB  - OBJECTIVE: To design and test a revised data collection system for routine patient based data in the Community Hospital setting in Scotland.
AB  - DESIGN: A two part qualitative study was designed to identify the requirements for Community Hospital information, develop a data set to meet these requirements and pilot a proposed Community Hospital Information System.
AB  - SETTING: Identification of the information deficit (Stage 1) involved administering face to face questionnaires in all relevant Health Board areas in Scotland; piloting of the proposed information system (Stage 2) was carried out in four Community Hospitals in Scotland.
AB  - RESULTS: Stage 1 of the study highlighted the information requirements as including: who is being treated; why they are there; how complex their needs are; what is being done and by whom; and what is happening next. The additionally required data included: admission reason--medical/social; type of care--intended and provided; all relevant diagnoses and social factors; medication--on admission and discharge; interventions--nursing/GP/consultant; dependency throughout stay; delayed discharge information; and discharge plan. The summary of recommendations that flowed from this part of the study includes: incremental electronic record; link with GP and acute systems; interface with other community systems; duplication of recording; accessibility at local level with variable levels of access (to protect patient confidentiality). Stage 2 of the study piloted the collection of the proposed dataset and permitted development of suitable feedback information, in particular the patient summary screens. Economic evaluation of the proposed dataset compared to the existing data was carried out in parallel with the study and is reported elsewhere.
AB  - CONCLUSION: It is feasible and highly desirable to collect clinically useful information at little additional cost and to provide relevant feedback, including useful patient summary screens, representing the patient stay in hospital.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12664763
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12664763&id=doi:&issn=0374-8014&isbn=&volume=60&issue=1&spage=13&pages=13-9&date=2002&title=Health+Bulletin&atitle=Information+for+community+hospitals.&aulast=Urquhart&pid=%3Cauthor%3EUrquhart+J%3C%2Fauthor%3E%3CAN%3E12664763%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<379. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12492942
TI  - Nursing shortages and evidence-based interventions: a case study from Scotland.
SO  - International Nursing Review. 49(4):209-18, 2002 Dec.
VI  - 1
ST  - MEDLINE
AU  - Buchan J
FA  - Buchan, J
IN  - Buchan, J. Faculty of Social Sciences and Health Care, Queen Margaret University College, Edinburgh, UK. jbuchan@qmuc.ac.uk
CM  - Comment in (CIN)
AB  - In this report, key aspects of change in the labour market for nurses in Scotland are examined, and an integrated policy framework intended to improve nurse recruitment, retention and utilization is outlined. The purpose of this article is to provide an overview of the dynamics of the nursing labour market in Scotland and to draw some more general messages from the evidence base on the effectiveness of interventions to improve recruitment and retention of nursing staff. The paper has three main elements: it provides a backdrop of key trends in the Scottish nursing labour market; it summarizes issues related to planning and nursing shortages, including an assessment of the utility of current indicators of recruitment and retention difficulties; and it reviews the main potential interventions to address nurse recruitment and retention difficulties, drawing from key research/evidence from UK and other English language sources. Five main interventions are examined: integrating the planning of the healthcare workforce; improving recruitment; incentives to improve retention; improving staff deployment; and improving utilization/skill mix.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12492942
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12492942&id=doi:&issn=0020-8132&isbn=&volume=49&issue=4&spage=209&pages=209-18&date=2002&title=International+Nursing+Review&atitle=Nursing+shortages+and+evidence-based+interventions%3A+a+case+study+from+Scotland.&aulast=Buchan&pid=%3Cauthor%3EBuchan+J%3C%2Fauthor%3E%3CAN%3E12492942%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<380. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12387762
TI  - Supporting families: how are nursing students being prepared for this developing role across Scotland.
SO  - Nurse Education Today. 22(6):481-91, 2002 Aug.
VI  - 1
ST  - MEDLINE
AU  - O'Sullivan Burchard DJ
AU  - Whyte DA
AU  - Jackson K
FA  - O'Sullivan Burchard, Dorothee J H
FA  - Whyte, Dorothy A
FA  - Jackson, Kate
IN  - O'Sullivan Burchard, Dorothee J H. Department of Nursing and Community Health, Faculty of Health, Glasgow Caledonian University, Cowcaddens Road, Glasgow, G4 0BA, UK. d.Burchard@gcal.ac.uk
AB  - Increasing emphasis on primary care has led to a reappraisal of the scope and importance of nursing work with families. The purpose of this study was to explore the knowledge base of lecturers in Scotland that underpinned instruction of student nurses in working with families at diploma and undergraduate level. A postal survey was conducted throughout the 11 educational institutions providing pre-registration nursing programmes. Data were collected from a purposive sample and quantitatively analysed using descriptive statistics. Qualitative data were subjected to content analysis. The response rate was 54.7% (n=95). Findings showed a consensus about the importance of nursing work with families. Family nursing was seen to be relevant across all branches of nursing and academic programmes. There was no statistically significant difference between the levels of academic qualification and perceived knowledge base of lecturers with reference to family nursing theory. The need for a conceptual framework for family nursing was suggested. Knowledge of family nursing literature was limited and necessity for professional development in the teaching of family nursing was acknowledged. The implications of the inquiry point to the need for the integration of family nursing into nursing curricula in Scotland.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12387762
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12387762&id=doi:&issn=0260-6917&isbn=&volume=22&issue=6&spage=481&pages=481-91&date=2002&title=Nurse+Education+Today&atitle=Supporting+families%3A+how+are+nursing+students+being+prepared+for+this+developing+role+across+Scotland.&aulast=O%27Sullivan+Burchard&pid=%3Cauthor%3EO%27Sullivan+Burchard+DJ%3C%2Fauthor%3E%3CAN%3E12387762%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<381. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12386653
TI  - Hospital staffing, organization, and quality of care: Cross-national findings.
SO  - Nursing Outlook. 50(5):187-94, 2002 Sep-Oct.
VI  - 1
ST  - MEDLINE
AU  - Aiken LH
AU  - Clarke SP
AU  - Sloane DM
FA  - Aiken, Linda H
FA  - Clarke, Sean P
FA  - Sloane, Douglas M
IN  - Aiken, Linda H. Center for Health Outcomes and Policy Research, University of Pennsylvania School of Nursing, Department of Sociology, University of Pennsylvania, Philadelphia 19104, USA. laiken@nursing.upenn.edu
AB  - OBJECTIVE: To examine the effects of nurse staffing and organizational support for nursing care on nurses' dissatisfaction with their jobs, nurse burnout, and nurse reports of quality of patient care in an international sample of hospitals.
AB  - DESIGN: Multisite cross-sectional survey
AB  - SETTING: Adult acute-care hospitals in the U.S. (Pennsylvania), Canada (Ontario and British Columbia), England and Scotland.
AB  - STUDY PARTICIPANTS: 10319 nurses working on medical and surgical units in 303 hospitals across the five jurisdictions.
AB  - INTERVENTIONS: None Main outcome measures: Nurse job dissatisfaction, burnout, and nurse-rated quality of care.
AB  - RESULTS: Dissatisfaction, burnout and concerns about quality of care were common among hospital nurses in all five sites. Organizational/managerial support for nursing had a pronounced effect on nurse dissatisfaction and burnout, and both organizational support for nursing and nurse staffing were directly, and independently, related to nurse-assessed quality of care. Multivariate results imply that nurse reports of low quality care were three times as likely in hospitals with low staffing and support for nurses as in hospitals with high staffing and support.
AB  - CONCLUSION: Adequate nurse staffing and organizational/managerial support for nursing are key to improving the quality of patient care, to diminishing nurse job dissatisfaction and burnout and, ultimately, to improving the nurse retention problem in hospital settings.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
PT  - Research Support, U.S. Gov't, P.H.S.
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12386653
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12386653&id=doi:10.1067%2Fmno.2002.126696&issn=0029-6554&isbn=&volume=50&issue=5&spage=187&pages=187-94&date=2002&title=Nursing+Outlook&atitle=Hospital+staffing%2C+organization%2C+and+quality+of+care%3A+Cross-national+findings.&aulast=Aiken&pid=%3Cauthor%3EAiken+LH%3C%2Fauthor%3E%3CAN%3E12386653%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<382. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12192752
TI  - Nutritional care for adults in hospital.
SO  - Nursing Times. 98(31):32-3, 2002 Jul 30-Aug 5.
VI  - 1
ST  - MEDLINE
AU  - Harris G
AU  - Bond P
FA  - Harris, Gill
FA  - Bond, Penny
IN  - Harris, Gill. Anaesthetic Department, Victoria Infirmary, Glasgow.
AB  - Despite the fact that up to 40% of hospital patients may be malnourished, many nutritional referrals are inconsistent or inappropriate. Recent research has raised awareness of nutrition, but wide variations remain in the assessment and referral procedures used by hospital trusts. The final best practice statement in our series emerged from the responses of nursing and dietetic staff across Scotland. The statement focuses on five aspects of nutritional care: admission to hospital; nursing management of nutritional care; nutritional screening and documentation; criteria for nutritional referrals, and education and training.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12192752
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12192752&id=doi:&issn=0954-7762&isbn=&volume=98&issue=31&spage=32&pages=32-3&date=2002&title=Nursing+Times&atitle=Nutritional+care+for+adults+in+hospital.&aulast=Harris&pid=%3Cauthor%3EHarris+G%3C%2Fauthor%3E%3CAN%3E12192752%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<383. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12171220
TI  - A qualitative study of why general practitioners admit to community hospitals.
SO  - British Journal of General Practice. 52(481):628-30, 632-5, 2002 Aug.
VI  - 1
ST  - MEDLINE
AU  - Grant JA
AU  - Dowell J
FA  - Grant, James A
FA  - Dowell, Jon
IN  - Grant, James A. St Margaret's Health Centre, Auchterarder, Perthshire. jgrant@stmargarets.finix.org.uk
AB  - BACKGROUND: Intermediate care, which is provided by community hospitals, is increasingly seen as one way of reducing pressure on secondary care. However, despite evidence of wide variation, there is little literature describing how general practitioners (GPs) use these hospitals. Because of the control they have over decisions to admit, development of these units depends on the cooperation of GPs.
AB  - AIM: To identify and understand the factors influencing the decision to admit to a community hospital.
AB  - DESIGN OF STUDY: A qualitative interview study.
AB  - SETTING: Twenty-seven practitioners from ten practices supporting five community hospitals in one region of Tayside, Scotland Secondary support was identical for all sites.
AB  - METHOD: In-depth interviews were conducted with a purposive sample of GPs representing those who had the most and the least use of the five community hospitals. A qualitative anaysis was performed to determine thefactors that practitioners considered important when making decisions about admission. Results were presented to the study group for validation.
AB  - RESULTS: All admissions required adequate capacity in the community hospital system. Primarily social admissions were straight forward requiring only adequate hospital nursing, and GP capacity. More typical admissions involving social and medical needs required consideration of the professional concerns and the personal influences on the doctor as well as the potential benefits to the patient. As medical complexity increased the doctor's comfort/discomfort became the deciding factor.
AB  - CONCLUSION: Provided there was adequate capacity, the GPs perceived the level of comfort to be the prime determinant of which patients are admitted to community hospitals and which are referred to secondary care.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12171220
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12171220&id=doi:&issn=0960-1643&isbn=&volume=52&issue=481&spage=628&pages=628-30%2C+632-5&date=2002&title=British+Journal+of+General+Practice&atitle=A+qualitative+study+of+why+general+practitioners+admit+to+community+hospitals.&aulast=Grant&pid=%3Cauthor%3EGrant+JA%3C%2Fauthor%3E%3CAN%3E12171220%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<384. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12164911
TI  - A comparison of therapeutic commitment, role support, role competency and empathy in three cohorts of nursing students.
SO  - Journal of Psychiatric & Mental Health Nursing. 9(4):483-91, 2002 Aug.
VI  - 1
ST  - MEDLINE
AU  - Lauder W
AU  - Reynolds W
AU  - Smith A
AU  - Sharkey S
FA  - Lauder, W
FA  - Reynolds, W
FA  - Smith, A
FA  - Sharkey, S
IN  - Lauder, W. University of Stirling Psychosocial Research Group, Department of Nursing and Midwifery, University of Stirling, Inverness, UK. William.Lauder@Stir.ac.uk
AB  - This study investigated the perceptions of students regarding their therapeutic commitment, role competency, role support and empathy towards working with people who have mental health problems. These qualities play a key part in the development of therapeutic relationships, an important goal for working with individuals in most nursing situations. The sample comprised of three cohorts of nursing students undertaking the Diploma in Higher Education (Nursing) in Scotland. There were no significant differences in perceptions of empathy and therapeutic commitment among three cohorts of students, but third year students felt they received less role support than other cohorts. The findings also revealed that preregistration nursing students have perceptions of their role competency and empathic skills which are considerably greater than has been previously reported by registered nurses. The implications of these findings for nurse education are discussed.
PT  - Comparative Study
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12164911
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12164911&id=doi:10.1046%2Fj.1365-2850.2002.00510.x&issn=1351-0126&isbn=&volume=9&issue=4&spage=483&pages=483-91&date=2002&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=A+comparison+of+therapeutic+commitment%2C+role+support%2C+role+competency+and+empathy+in+three+cohorts+of+nursing+students.&aulast=Lauder&pid=%3Cauthor%3ELauder+W%3C%2Fauthor%3E%3CAN%3E12164911%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<385. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12131861
TI  - Best practice statement of the prevention of pressure ulcers. [Review] [20 refs]
SO  - British Journal of Nursing. 11(12 Suppl):S38, S40, S42 passim, 2002 Jun.
VI  - 1
ST  - MEDLINE
AU  - Cooper P
AU  - Gray D
FA  - Cooper, Pam
FA  - Gray, David
IN  - Cooper, Pam. Department of Tissue Viability, Aberdeen Royal Infirmary; and Nursing and Midwifery Development Unit, Scotland.
AB  - The Nursing and Midwifery Development Unit, Scotland, has developed a range of best practice statements, one of which relates to the prevention of pressure ulcers. The development of the statement involved achieving a consensus as to what constituted best practice in this field among the 30 nurse specialists in tissue viability working within Scotland. The statement aims to provide practical, relevant and factual information to guide pressure ulcer prevention practice. [References: 20]
PT  - Journal Article
PT  - Review
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12131861
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12131861&id=doi:10.12968%2Fbjon.2002.11.Sup2.10295&issn=0966-0461&isbn=&volume=11&issue=12&spage=S38&pages=S38%2C+S40%2C+S42+passim&date=2002&title=British+Journal+of+Nursing&atitle=Best+practice+statement+of+the+prevention+of+pressure+ulcers.&aulast=Cooper&pid=%3Cauthor%3ECooper+P%3C%2Fauthor%3E%3CAN%3E12131861%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<386. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12048497
TI  - Marie Curie nurses: enabling patients with cancer to die at home.
SO  - British Journal of Community Nursing. 7(5):240-4, 2002 May.
VI  - 1
ST  - MEDLINE
AU  - Higginson IJ
AU  - Wilkinson S
FA  - Higginson, Irene J
FA  - Wilkinson, Susie
IN  - Higginson, Irene J. Department of Palliative Care and Policy, King's College London.
AB  - Marie Curie Cancer Care established its nursing service in 1958; however, the service has had little formal evaluation. This study aimed to describe and evaluate the care provided by Marie Curie nurse, and in particular to determine whether patients in their care remained and died at home. Two existing data sets were used: data on all patients referred to the Marie Curie Nursing Services in 147 areas of England, Wales, Scotland and Northern Ireland for 26 months, and data on cancer death registrations in England. A request for a Marie Curie nurse was made for 26,632 patients, 97% of whom had cancer and 11% of whom lived alone. The amount of care provided varied enormously (<1 hour-2862 hours), although the vast majority of patients less than 300 hours of nursing care. Place of death was recorded for only half these patients; 94% died at home, 2.5% in a hospice, 2.3% in a hospital, 0.2% in a nursing home and 0.6% other. Home death was most often associated with patients receiving medication via a syringe driver, patients living with other people, patients with cancer, other than prostate cancer, shorter time between referral and death and younger age. The results lend support to the theory that the care given to patients in their homes by Marie Curie nurses facilitated home death for many patients. Services need to ensure that mechanisms are in place to achieve data collection. Rigorous prospective evaluation is needed in the future.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12048497
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12048497&id=doi:10.12968%2Fbjcn.2002.7.5.10359&issn=1462-4753&isbn=&volume=7&issue=5&spage=240&pages=240-4&date=2002&title=British+Journal+of+Community+Nursing&atitle=Marie+Curie+nurses%3A+enabling+patients+with+cancer+to+die+at+home.&aulast=Higginson&pid=%3Cauthor%3EHigginson+IJ%3C%2Fauthor%3E%3CAN%3E12048497%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<387. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12028285
TI  - Assessing practice of student nurses: methods, preparation of assessors and student views.
SO  - Journal of Advanced Nursing. 38(5):516-23, 2002 Jun.
VI  - 1
ST  - MEDLINE
AU  - Calman L
AU  - Watson R
AU  - Norman I
AU  - Redfern S
AU  - Murrells T
FA  - Calman, Lynn
FA  - Watson, Roger
FA  - Norman, Ian
FA  - Redfern, Sally
FA  - Murrells, Trevor
IN  - Calman, Lynn. Department of Nursing Studies, University of Edinburgh, Edinburgh, UK. lynn.calman@ed.ac.uk
AB  - AIMS: To describe the methods of measuring progress in achieving competence of preregistration nursing and midwifery students used by institutions of higher and further education in Scotland and to describe the philosophy and approaches to competence assessment in each institution.
AB  - BACKGROUND: Institutions of higher and further education in Scotland operate a variety of schemes to assess the clinical practice of student nurses. These are based on different philosophies and practices and this raises the question of which are valid and reliable.
AB  - METHODS: All institutions in Scotland providing validated Diploma of Higher Education programmes for preregistration nursing and midwifery participated in this study. Data were collected by postal questionnaire, review of programme documentation and supplemented with interviews with key stakeholders. The directors of the 13 programmes (seven nursing and six midwifery programmes) were surveyed and also 12 group interviews with students (six nursing and six midwifery student groups) from seven institutions. Students from all four branches were represented and 72 students (36 nurses and 36 midwives) were interviewed.
AB  - RESULTS: Four key findings were identified and related to competence assessment methods, preparation of practice assessors, consequences of failure to meet expected level of outcome and students' views.
AB  - CONCLUSIONS: There has been a change in theoretical frameworks of assessment instruments used since the 1992 programmes commenced and only a limited number of approaches to clinical assessment are used in Scotland. Students' views suggested that they had little confidence in methods of clinical competence assessment and there was no formal validity and reliability testing within institutions. A lack of consistency in the training of student assessors in the clinical areas was identified. Some of these issues may be resolved with the development of a national instrument for competence assessment.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12028285
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12028285&id=doi:10.1046%2Fj.1365-2648.2002.02213.x&issn=0309-2402&isbn=&volume=38&issue=5&spage=516&pages=516-23&date=2002&title=Journal+of+Advanced+Nursing&atitle=Assessing+practice+of+student+nurses%3A+methods%2C+preparation+of+assessors+and+student+views.&aulast=Calman&pid=%3Cauthor%3ECalman+L%3C%2Fauthor%3E%3CAN%3E12028285%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<388. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11884195
TI  - Presentation skills workshops for nurses.
SO  - Nurse Education Today. 22(2):144-51, 2002 Feb.
VI  - 1
ST  - MEDLINE
AU  - Kinn Su
AU  - Kenyon M
FA  - Kinn, S ue
FA  - Kenyon, Mary
IN  - Kinn, S ue. Nursing Research Initiative for Scotland, Faculty of Health, Glasgow Caledonian University, Cowcaddens Road, Glasgow, G4 0BA, UK. s.kinn@gcal.ac.uk
AB  - In the modern NHS, where there is increasing emphasis on evidence-based practice and clinical governance, all healthcare professionals need to be able to present the results of their professional activities. Traditionally, nurses have not been trained to present the results of their work either verbally or in writing. A series of presentation workshops for nurses were held in Scotland. The feedback and presentation activities of participants, in the year following the workshops, are reported here. Immediate verbal feedback indicated that the majority of those attending had enjoyed the workshops. Written feedback over the course of the following year showed that the learning needs of participants had largely been met and that many of those attending had gone on to present their own work. Presentations were both verbal and in writing at a variety of levels, ranging from local reports and presentations to journal articles and papers given at international conferences. Nurses responded well to the very practical, informal and non-threatening environment of the workshop. The development of presentation skills has wider implications for raising awareness of and sharing best practice in nursing care.

 Copyright 2002, Elsevier Science Ltd. All rights reserved.
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11884195
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11884195&id=doi:10.1054%2Fnedt.2001.0665&issn=0260-6917&isbn=&volume=22&issue=2&spage=144&pages=144-51&date=2002&title=Nurse+Education+Today&atitle=Presentation+skills+workshops+for+nurses.&aulast=Kinn&pid=%3Cauthor%3EKinn+Su%3C%2Fauthor%3E%3CAN%3E11884195%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<389. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11871630
TI  - Hospital staffing, organization, and quality of care: cross-national findings.
SO  - International Journal for Quality in Health Care. 14(1):5-13, 2002 Feb.
VI  - 1
ST  - MEDLINE
AU  - Aiken LH
AU  - Clarke SP
AU  - Sloane DM
AU  - International Hospital Outcomes Research Consortium
FA  - Aiken, Linda H
FA  - Clarke, Sean P
FA  - Sloane, Douglas M
FA  - International Hospital Outcomes Research Consortium
IN  - Aiken, Linda H. Center for Health Outcomes and Policy Research, University of Pennsylvania School of Nursing, Philadelphia 19104-6069, USA. laiken@nursing.upenn.edu
AB  - OBJECTIVE: To examine the effects of nurse staffing and organizational support for nursing care on nurses' dissatisfaction with their jobs, nurse burnout, and nurse reports of quality of patient care in an international sample of hospitals.
AB  - DESIGN: Multisite cross-sectional survey.
AB  - SETTING: Adult acute-care hospitals in the United States (Pennsylvania), Canada (Ontario and British Columbia), England, and Scotland.
AB  - STUDY PARTICIPANTS: 10 319 nurses working on medical and surgical units in 303 hospitals across the five jurisdictions.
AB  - INTERVENTIONS: None.
AB  - MAIN OUTCOME MEASURES: Nurse job dissatisfaction, burnout, and nurse-rated quality of care.
AB  - RESULTS: Dissatisfaction, burnout, and concerns about quality of care were common among hospital nurses in all five sites. Organizational/managerial support for nursing had a pronounced effect on nurse dissatisfaction and burnout, and both organizational support for nursing and nurse staffing were directly, and independently, related to nurse-assessed quality of care. Multivariate results imply that nurse reports of low quality care were three times as likely in hospitals with low staffing and support for nurses as in hospitals with high staffing and support.
AB  - CONCLUSION: Adequate nurse staffing and organizational/managerial support for nursing are key to improving the quality of patient care, to diminishing nurse job dissatisfaction and burnout and, ultimately, to improving the nurse retention problem in hospital settings.
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
PT  - Research Support, U.S. Gov't, P.H.S.
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11871630
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11871630&id=doi:10.1093%2Fintqhc%2F14.1.5&issn=1353-4505&isbn=&volume=14&issue=1&spage=5&pages=5-13&date=2002&title=International+Journal+for+Quality+in+Health+Care&atitle=Hospital+staffing%2C+organization%2C+and+quality+of+care%3A+cross-national+findings.&aulast=Aiken&pid=%3Cauthor%3EAiken+LH%3C%2Fauthor%3E%3CAN%3E11871630%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<390. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11861955
TI  - Assessment of nutritional status in hospital in-patients.
SO  - Qjm. 95(2):83-7, 2002 Feb.
VI  - 1
ST  - MEDLINE
AU  - Campbell SE
AU  - Avenell A
AU  - Walker AE
FA  - Campbell, S E
FA  - Avenell, A
FA  - Walker, A E
IN  - Campbell, S E. Health Services Research Unit, University of Aberdeen, Polwarth Building, Foresterhill, Aberdeen, UK. s.e.campbell@abdn.ac.uk
AB  - BACKGROUND: The King's Fund and British Association of Parenteral and Enteral Nutrition recommend that all hospital patients should have height and weight recorded, to detect the need for nutritional support. Systematic review evidence also suggests that protein and energy supplementation of adults in hospital with a wide range of conditions improves outcome.
AB  - AIM: To assess the recording of weight and height in hospitals.
AB  - DESIGN: Survey (random sample).
AB  - METHODS: As part of a survey on the provision of deep venous thrombosis prophylaxis, we collected information on height and weight recording from medical and nursing notes. We randomly selected five medical, five surgical, five orthopaedic, and five obstetrics and gynaecology directorates from across Scotland. Six hundred case notes were requested, and 88% were available for data extraction. Some 67% of hospital episodes provided information about weight, and 41% on both height and weight. General medicine directorates had the lowest recording of weight, and in medical and surgical directorates, both weight and height were rarely recorded in comparison with the other two directorates (p<0.001).
AB  - DISCUSSION: Our survey suggests that recommendations to assess nutritional risk are not being followed, and that many patients at risk of malnutrition are not being detected or treated.
PT  - Journal Article
PT  - Multicenter Study
PT  - Research Support, Non-U.S. Gov't
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11861955
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11861955&id=doi:10.1093%2Fqjmed%2F95.2.83&issn=1460-2725&isbn=&volume=95&issue=2&spage=83&pages=83-7&date=2002&title=Qjm&atitle=Assessment+of+nutritional+status+in+hospital+in-patients.&aulast=Campbell&pid=%3Cauthor%3ECampbell+SE%3C%2Fauthor%3E%3CAN%3E11861955%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<391. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11851782
TI  - Maintaining privacy on post-natal wards: a study in five European countries.
SO  - Journal of Advanced Nursing. 37(2):145-54, 2002 Jan.
VI  - 1
ST  - MEDLINE
AU  - Leino-Kilpi H
AU  - Valimaki M
AU  - Dassen T
AU  - Gasull M
AU  - Lemonidou C
AU  - Scott PA
AU  - Arndt M
AU  - Kaljonen A
FA  - Leino-Kilpi, Helena
FA  - Valimaki, Maritta
FA  - Dassen, Theo
FA  - Gasull, Maria
FA  - Lemonidou, Chryssoula
FA  - Scott, P Anne
FA  - Arndt, Marianne
FA  - Kaljonen, Anne
IN  - Leino-Kilpi, Helena. Department of Nursing, University of Turku, Turku, Finland, Researcher, Department of Nursing, University of Turku, Turku, Finland. helena.leino-kilpi@utu.fi
OI  - Source: KIE. 111230
AB  - AIM: Maintaining privacy on post-natal wards: a study in five European countries Aim. To describe how mothers' privacy is maintained on post-natal wards in five European countries: Finland, Spain, Greece, Germany and Scotland [United Kingdom (UK)]
AB  - BACKGROUND: Privacy is an important concept in nursing and nursing ethics. Empirical studies in this field, however, are few. In this study, privacy is defined as comprising both physical and social-informational dimensions and both the perceptions of mothers and professional were investigated.
AB  - METHODS: The data were collected by a questionnaire from mothers (n=1192) and midwife/nursing staff (n=952).
AB  - RESULTS: The results revealed differences both between the different countries and between patients' and professionals' views. Mothers in Finland, Germany and Scotland felt their privacy was maintained better than mothers in Greece and Spain. The differences in staff perceptions are less clear-cut. Different background factors emerge as statistically significant in different countries.
AB  - CONCLUSION: Empirical studies in privacy are important and give ideas about the problems in nursing practice. Future analyses should look also at other areas of nursing.
PT  - Comparative Study
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11851782
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11851782&id=doi:10.1046%2Fj.1365-2648.2002.02070.x&issn=0309-2402&isbn=&volume=37&issue=2&spage=145&pages=145-54&date=2002&title=Journal+of+Advanced+Nursing&atitle=Maintaining+privacy+on+post-natal+wards%3A+a+study+in+five+European+countries.&aulast=Leino-Kilpi&pid=%3Cauthor%3ELeino-Kilpi+H%3C%2Fauthor%3E%3CAN%3E11851782%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<392. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11755444
TI  - The validity and reliability of methods to assess the competence to practise of pre-registration nursing and midwifery students.
SO  - International Journal of Nursing Studies. 39(2):133-45, 2002 Feb.
VI  - 1
ST  - MEDLINE
AU  - Norman IJ
AU  - Watson R
AU  - Murrells T
AU  - Calman L
AU  - Redfern S
FA  - Norman, Ian J
FA  - Watson, Roger
FA  - Murrells, Trevor
FA  - Calman, Lynn
FA  - Redfern, Sally
IN  - Norman, Ian J. Mental Health Section, School of Nursing and Midwifery, King's College London, James Clerk Maxwell Building, Waterloo Road, SE1 8WA, London, UK. ian.j.norman@kcl.ac.uk
AB  - This paper reports findings from a study funded by the National Board for Nursing, Midwifery and Health Visiting for Scotland to test selected nursing and midwifery clinical competence assessment tools for reliability and validity. The study, which took place over two years from July 1997, involved comparing items in the selected tools with statutory competencies for nurses and midwives, collecting assessment data from a sample of 257 nursing and 43 midwifery students in four educational institutions and administering additional assessment measures (the Nursing Competencies Questionnaire (NCQ) (Bartlett et al., An evaluation of pre-registration nursing education: a literature review and comparative study of graduate outcomes, Oxford Centre for Health Care Research & Development, Oxford Brookes University, Oxford, 1998) and the Key Areas Assessment Instrument-KAAI) to the total student sample (and to their lecturers and practice assessors) at two time points which were six months apart. Our focus was the programme-specific clinical competence assessment tools but by testing these tools we also provide evidence on the validity of other methods of competence assessment. Validity of the methods was assessed, primarily, by calculating multivariate and univariate correlation coefficients between them. The NCQ and KAAI were analysed for internal consistency. The NCQ and the versions of KAAI for lecturers and practice assessors were found to have good internal consistency. The version of the KAAI tool developed for students showed reasonable internal consistency for nursing students, but less consistency for midwifery students. Correlational analysis of data collected on students showed that there is little or no relationship between most of the clinical competence assessment methods in current use, or between these methods and those introduced by the research team. This finding supports previous research, particularly in medical education and confirms that the different methods address different abilities.A clear finding from this study is that no single method is appropriate for assessing clinical competence. A multi-method UK-wide strategy for clinical competence assessment for nursing and midwifery is needed if we are to be sure that assessment reveals whether or not students have achieved the complex repertoire of knowledge, skills and attitudes required for competent practice.
PT  - Journal Article
YR  - 2002
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11755444
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11755444&id=doi:10.1016%2Fs0020-7489%2801%2900028-1&issn=0020-7489&isbn=&volume=39&issue=2&spage=133&pages=133-45&date=2002&title=International+Journal+of+Nursing+Studies&atitle=The+validity+and+reliability+of+methods+to+assess+the+competence+to+practise+of+pre-registration+nursing+and+midwifery+students.&aulast=Norman&pid=%3Cauthor%3ENorman+IJ%3C%2Fauthor%3E%3CAN%3E11755444%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<393. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12811907
TI  - Independent nursing practice: a national survey of attitudes of practice employed nurses in Scotland.
SO  - Health Bulletin. 59(1):21-8, 2001 Jan.
VI  - 1
ST  - MEDLINE
AU  - Caldow JL
AU  - Bond CM
AU  - Russell EM
FA  - Caldow, J L
FA  - Bond, C M
FA  - Russell, E M
IN  - Caldow, J L. Department of General Practice and Primary Care, University of Aberdeen, Foresterhill Health Centre, Westburn Road, Aberdeen.
AB  - BACKGROUND: During the last decade, the number of practice nurses has increased dramatically and their role has evolved according to demand rather than through planning and design. Consequently, many nursing roles have become extended and nurses now perform many of the tasks previously performed by doctors. With increasing emphasis on primary care, their new role has become widely accepted and continues to develop. There is now a real question as to whether, with suitable training, it is timely to consider a formal extension to independent practice for at least some practice nurses.
AB  - OBJECTIVE: The aim was to describe the characteristics of practice nurses and to explore their attitudes to independent practice. For the purpose of this study, independent practice was taken to mean specialised autonomous practice.
AB  - DESIGN: This was a descriptive, cross-sectional study undertaken by postal questionnaire. A two stage sampling process was used.
AB  - SETTING: Firstly a 1/2 sample of all general practices in Scotland (n = 625) was asked for the names of all practice employed nurses. Secondly, one practice nurse from each practice was sent a postal questionnaire.
AB  - RESULTS: Five hundred and thirty eight general practices responded. Eighty six practices had no practice employed nurse. Four hundred and thirty three practices (96%; 433/452) were willing to allow their practice nurses to be approached to take part in the study. Four hundred practice nurses returned questionnaires (92%; 400/433). Fifteen were excluded because the nurses were not fully practice employed. Three hundred and eighty five were suitable for inclusion in the study (85%; 385/452). Most practice nurses were over 35 years of age and had been in post for more than three years. Almost half had at least one other nursing qualification in addition to registration. Eighty six percent thought that there should be independent practice for some nurses within the profession and 65% would, themselves, be happy to practise independently.
AB  - CONCLUSION: Most practice nurses throughout Scotland think that there should be independent practice for some nurses.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12811907
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12811907&id=doi:&issn=0374-8014&isbn=&volume=59&issue=1&spage=21&pages=21-8&date=2001&title=Health+Bulletin&atitle=Independent+nursing+practice%3A+a+national+survey+of+attitudes+of+practice+employed+nurses+in+Scotland.&aulast=Caldow&pid=%3Cauthor%3ECaldow+JL%3C%2Fauthor%3E%3CAN%3E12811907%3C%2FAN%3E%3CDT%3EJournal+Article%3C%2FDT%3E

<394. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12664731
TI  - A second survey of Scottish emergency psychiatry.
SO  - Health Bulletin. 59(4):228-32, 2001 Jul.
VI  - 1
ST  - MEDLINE
AU  - Pullen IM
AU  - Nisbet E
FA  - Pullen, I M
FA  - Nisbet, E
AB  - OBJECTIVE: To survey NHS services providing emergency psychiatric assessment in Scotland and to compare the findings with those of the survey conducted 8 years ago.
AB  - DESIGN: Postal and telephone questionnaire of all primary care trusts, the one integrated trust and three Island Health Boards in Scotland.
AB  - RESULTS: All parts of Scotland provide a 24 hour service for the assessment of psychiatric emergencies. There is a range of multidisciplinary responses during office hours with a total of 75 multidisciplinary Community Mental Health Teams, 18 Community Psychiatric Nursing Teams, 11 liaison psychiatry teams and one dedicated emergency team. However, for most of the week, the service is provided by a duty basic grade doctor in each area with the exception of Orkney.
AB  - CONCLUSIONS: Planning the most appropriate emergency and crisis service for any population depends on suitable data being available. Eight years after the first survey there is still no systematic collection of data on emergency contacts in Scotland. The systematic collection of National data is required for effective audit, planning and development of these services. The working definitions proposed in the first survey would be suitable for coding.
PT  - Comparative Study
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12664731
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12664731&id=doi:&issn=0374-8014&isbn=&volume=59&issue=4&spage=228&pages=228-32&date=2001&title=Health+Bulletin&atitle=A+second+survey+of+Scottish+emergency+psychiatry.&aulast=Pullen&pid=%3Cauthor%3EPullen+IM%3C%2Fauthor%3E%3CAN%3E12664731%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<395. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 12216265
TI  - Telemedicine in rural care. Part 2: Assessing the wider issues.
SO  - Nursing Standard. 15(33):33-7, 2001 May 2-8.
VI  - 1
ST  - MEDLINE
AU  - Macduff C
AU  - West B
AU  - Harvey S
FA  - Macduff, C
FA  - West, B
FA  - Harvey, S
IN  - Macduff, C. Centre for Nurse Practice, Research and Development, Robert Gordon University, Aberdeen.
AB  - BACKGROUND: The first article about this development (Macduff et al 2001) described the evolution of a nurse-led telemedicine service in the village of Hamlet (population 1,600), north-east Scotland, and presented the findings of an evaluation study. In this second article, those findings are discussed in relation to the wider picture of nursing involvement in teleconsultation. The village has no medical practice or pharmacy and the majority of Hamlet's residents aged over 65 are registered with the Bradieslea Road surgery, one of three general practices six miles away in the town of Bradieslea. The community nursing service is based in small rooms at a sheltered housing complex in the village. This service covers all patients in the Hamlet area. It is staffed by one full-time district nurse/health visitor (who acts as team leader) and one part-time district nurse. Both are qualified nurse prescribers.
AB  - CONCLUSION: Opportunities now exist for nurses to use teleconsultation for the benefit of their patients. A systematic development of this type of nursing role through integration with broader service development would be valuable.
PT  - Evaluation Study
PT  - Journal Article
PT  - Research Support, Non-U.S. Gov't
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=12216265
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:12216265&id=doi:10.7748%2Fns2001.05.15.33.33.c3020&issn=0029-6570&isbn=&volume=15&issue=33&spage=33&pages=33-7&date=2001&title=Nursing+Standard&atitle=Telemedicine+in+rural+care.+Part+2%3A+Assessing+the+wider+issues.&aulast=Macduff&pid=%3Cauthor%3EMacduff+C%3C%2Fauthor%3E%3CAN%3E12216265%3C%2FAN%3E%3CDT%3EEvaluation+Study%3C%2FDT%3E

<396. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11879493
TI  - Clients' reflections on relationships with nurses: comparisons from Canada and Scotland.
SO  - Journal of Psychiatric & Mental Health Nursing. 8(1):45-51, 2001 Feb.
VI  - 1
ST  - MEDLINE
AU  - Forchuk C
AU  - Reynolds W
FA  - Forchuk, C
FA  - Reynolds, W
IN  - Forchuk, C. University of Western Ontario/London Health-Science Centre Research, 375 South Street, London, Ontario, Canada, N6A 4G5.
AB  - It has been suggested that the crucial elements in nursing situations are the nurse, the client, and what goes on between them. This paper examines what goes on between clients and nurses during interpersonal relationships, from the perspective of the clients. Data are presented from studies conducted in Canada and Scotland. It is shown that what clients want, or do not want, during relationships with their nurses, is similar on both sides of the Atlantic. The findings reported in this paper are relevant to transcultural nursing, ethical care, the growth in consumerism, and client advocacy. The findings suggest also that there is a need for nursing research to focus on clinical outcomes in order to establish whether clients' perceptions of helping relationships have any relevance to favourable health outcomes, and the evidence base for clinical nursing.
PT  - Comparative Study
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11879493
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11879493&id=doi:10.1046%2Fj.1365-2850.2001.00344.x&issn=1351-0126&isbn=&volume=8&issue=1&spage=45&pages=45-51&date=2001&title=Journal+of+Psychiatric+%26+Mental+Health+Nursing&atitle=Clients%27+reflections+on+relationships+with+nurses%3A+comparisons+from+Canada+and+Scotland.&aulast=Forchuk&pid=%3Cauthor%3EForchuk+C%3C%2Fauthor%3E%3CAN%3E11879493%3C%2FAN%3E%3CDT%3EComparative+Study%3C%2FDT%3E

<397. >
VN  - Ovid Technologies
DB  - Ovid MEDLINE(R)
UI  - 11865225
TI  - Nurse prescribing: views on autonomy and independence.
SO  - British Journal of Community Nursing. 6(7):350-5, 2001 Jul.
VI  - 1
ST  - MEDLINE
AU  - Rodden C
FA  - Rodden, C
IN  - Rodden, C. Ayrshire and Arran Primary Care Trust, Ayr, Scotland.
AB  - The introduction of nurse prescribing throughout Scotland in the primary care setting has proved to be an interesting development for nurses. The aim of this study was to assess the impact of nurse prescribing on district nurses and health visitors in one NHS trust in Scotland. All prescribing nurses in the trust were asked to participate in the study. This explored their perceptions of autonomy and the level of dependence on GP colleagues since being able to prescribe. In addition, prescribing patterns were examined to ascertain whether there was a relationship between the area of nursing (e.g. district nursing or health visiting) or the length of prescribing experiences, and the number of prescriptions written.
PT  - Journal Article
YR  - 2001
XL  - https://ovidsp.ovid.com/ovidweb.cgi?T=JS&CSC=Y&NEWS=N&PAGE=fulltext&D=med4&AN=11865225
XL  - http://eleanor.lib.gla.ac.uk:4550/resserv?sid=OVID:medline&id=pmid:11865225&id=doi:10.12968%2Fbjcn.2001.6.7.7067&issn=1462-4753&isbn=&volume=6&issue=7&spage=350&pages=350-5&date=20